<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent" xmlns:tbl="http://www.oasis-open.org/tables/exchange/1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:WIPO="http://www.altova.com/MapForce/UDF/WIPO" xmlns:mathml="http://www.w3.org/1998/Math/MathML3" xmlns:vmf="http://www.altova.com/MapForce/UDF/vmf" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common" xmlns:pat="http://www.wipo.int/standards/XMLSchema/ST96/Patent" exclude-result-prefixes="WIPO vmf xs fn">
	<xsl:output method="xml" encoding="UTF-8" byte-order-mark="no" indent="yes" doctype-system="../../Schemas/ST36DTD/xx-patent-document-v2-3.dtd"/>
	<xsl:param name="Common_V7_010" select="'Common_V7_0.xml'"/>
	<xsl:param name="Common_V7_011" select="'Common_V7_0.xml'"/>
	<xsl:param name="Common_V7_012" select="'Common_V7_0.xml'"/>
	<xsl:param name="Common_V7_013" select="'Common_V7_0.xml'"/>
	<xsl:param name="Common_V7_02" select="'Common_V7_0.xml'"/>
	<xsl:param name="Common_V7_03" select="'Common_V7_0.xml'"/>
	<xsl:param name="Common_V7_04" select="'Common_V7_0.xml'"/>
	<xsl:param name="Common_V7_05" select="'Common_V7_0.xml'"/>
	<xsl:param name="Common_V7_06" select="'Common_V7_0.xml'"/>
	<xsl:param name="Common_V7_07" select="'Common_V7_0.xml'"/>
	<xsl:param name="Common_V7_08" select="'Common_V7_0.xml'"/>
	<xsl:param name="Common_V7_09" select="'Common_V7_0.xml'"/>
	<xsl:template name="WIPO:AddressLineTextToroom">
		<xsl:param name="AddressLineText" select="()"/>
		<xsl:if test="fn:exists(($AddressLineText/@com:addressLineCategory)[(fn:string(.) = 'Room')])">
			<room>
				<xsl:sequence select="fn:string($AddressLineText)"/>
			</room>
		</xsl:if>
	</xsl:template>
	<xsl:template name="WIPO:AddressLineTextToaddress-1">
		<xsl:param name="AddressLineText" select="()"/>
		<xsl:if test="fn:exists(($AddressLineText/@com:sequenceNumber)[(fn:string(.) = xs:string(xs:decimal('1')))])">
			<address-1>
				<xsl:sequence select="fn:string($AddressLineText)"/>
			</address-1>
		</xsl:if>
	</xsl:template>
	<xsl:template name="WIPO:GeographicRegionNameTocounty">
		<xsl:param name="GeographicRegionName" select="()"/>
		<xsl:if test="fn:exists(($GeographicRegionName/@com:geographicRegionCategory)[(fn:string(.) = 'County')])">
			<county>
				<xsl:sequence select="fn:string($GeographicRegionName)"/>
			</county>
		</xsl:if>
	</xsl:template>
	<xsl:template name="WIPO:AddressLineTextTostreet">
		<xsl:param name="AddressLineText" select="()"/>
		<xsl:if test="fn:exists(($AddressLineText/@com:addressLineCategory)[(fn:string(.) = 'Street')])">
			<street>
				<xsl:sequence select="fn:string($AddressLineText)"/>
			</street>
		</xsl:if>
	</xsl:template>
	<xsl:template name="WIPO:AddressLineTextTobuilding">
		<xsl:param name="AddressLineText" select="()"/>
		<xsl:if test="fn:exists(($AddressLineText/@com:addressLineCategory)[(fn:string(.) = 'Building')])">
			<building>
				<xsl:sequence select="fn:string($AddressLineText)"/>
			</building>
		</xsl:if>
	</xsl:template>
	<xsl:template name="WIPO:AddresLineTextToaddress-floor">
		<xsl:param name="AddressLineText" select="()"/>
		<xsl:if test="fn:exists(($AddressLineText/@com:addressLineCategory)[(fn:string(.) = 'Floor')])">
			<address-floor>
				<xsl:sequence select="fn:string($AddressLineText)"/>
			</address-floor>
		</xsl:if>
	</xsl:template>
	<xsl:template name="WIPO:AddressLineTextTopobox">
		<xsl:param name="AddressLineText" select="()"/>
		<xsl:if test="fn:exists(($AddressLineText/@com:addressLineCategory)[(fn:string(.) = 'Postal office box')])">
			<pobox>
				<xsl:sequence select="fn:string($AddressLineText)"/>
			</pobox>
		</xsl:if>
	</xsl:template>
	<xsl:template name="WIPO:AddressLineTextToaddress-5">
		<xsl:param name="AddressLineText" select="()"/>
		<xsl:if test="fn:exists(($AddressLineText/@com:sequenceNumber)[(fn:string(.) = xs:string(xs:decimal('5')))])">
			<address-5>
				<xsl:sequence select="fn:string($AddressLineText)"/>
			</address-5>
		</xsl:if>
	</xsl:template>
	<xsl:template name="WIPO:AddressLineTextToaddress-4">
		<xsl:param name="AddressLineText" select="()"/>
		<xsl:if test="fn:exists(($AddressLineText/@com:sequenceNumber)[(fn:string(.) = xs:string(xs:decimal('4')))])">
			<address-4>
				<xsl:sequence select="fn:string($AddressLineText)"/>
			</address-4>
		</xsl:if>
	</xsl:template>
	<xsl:template name="WIPO:AddressLineTextToaddress-3">
		<xsl:param name="AddressLineText" select="()"/>
		<xsl:if test="fn:exists(($AddressLineText/@com:sequenceNumber)[(fn:string(.) = xs:string(xs:decimal('3')))])">
			<address-3>
				<xsl:sequence select="fn:string($AddressLineText)"/>
			</address-3>
		</xsl:if>
	</xsl:template>
	<xsl:template name="WIPO:AddressLineTextToaddress-2">
		<xsl:param name="AddressLineText" select="()"/>
		<xsl:if test="fn:exists(($AddressLineText/@com:sequenceNumber)[(fn:string(.) = xs:string(xs:decimal('2')))])">
			<address-2>
				<xsl:sequence select="fn:string($AddressLineText)"/>
			</address-2>
		</xsl:if>
	</xsl:template>
	<xsl:template name="WIPO:GeographicRegionNameToState">
		<xsl:param name="GeographicRegionName" select="()"/>
		<xsl:if test="fn:exists(($GeographicRegionName/@com:geographicRegionCategory)[(fn:string(.) = 'State')])">
			<state>
				<xsl:sequence select="fn:string($GeographicRegionName)"/>
			</state>
		</xsl:if>
	</xsl:template>
	<xsl:template name="vmf:vmf1_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Informal'">
				<xsl:copy-of select="'informal'"/>
			</xsl:when>
			<xsl:when test="$input='General'">
				<xsl:copy-of select="'general'"/>
			</xsl:when>
			<xsl:when test="$input='Advanced'">
				<xsl:copy-of select="'advanced'"/>
			</xsl:when>
			<xsl:when test="$input='Main'">
				<xsl:copy-of select="'main'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="/">
		<xsl:variable name="var16_Contact" as="node()?" select="com:Contact"/>
		<addressbook>
			<xsl:for-each select="$var16_Contact/@com:languageCode">
				<xsl:attribute name="lang" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$var16_Contact">
				<xsl:variable name="var14_PostalAddressBag" as="node()?" select="com:PostalAddressBag"/>
				<xsl:variable name="var15_Name" as="node()?" select="com:Name"/>
				<xsl:for-each select="$var15_Name/com:PersonName/com:PersonFullName">
					<name>
						<xsl:attribute name="name-type" select="'natural'"/>
						<xsl:sequence select="fn:string(.)"/>
					</name>
				</xsl:for-each>
				<xsl:for-each select="$var15_Name/com:OrganizationName">
					<name>
						<xsl:attribute name="name-type" select="'legal'"/>
						<xsl:sequence select="fn:string(com:OrganizationStandardName)"/>
					</name>
				</xsl:for-each>
				<xsl:for-each select="$var15_Name/com:EntityName">
					<name>
						<xsl:sequence select="fn:string(.)"/>
					</name>
				</xsl:for-each>
				<xsl:for-each select="$var15_Name/com:PersonName/com:PersonStructuredName/com:NamePrefix">
					<prefix>
						<xsl:sequence select="fn:string(.)"/>
					</prefix>
				</xsl:for-each>
				<xsl:for-each select="$var15_Name/com:PersonName/com:PersonStructuredName">
					<last-name>
						<xsl:sequence select="fn:string(com:LastName)"/>
					</last-name>
				</xsl:for-each>
				<xsl:for-each select="$var15_Name/com:PersonName/com:PersonStructuredName/com:FirstName">
					<first-name>
						<xsl:sequence select="fn:string(.)"/>
					</first-name>
				</xsl:for-each>
				<xsl:for-each select="$var15_Name/com:PersonName/com:PersonStructuredName/com:MiddleName">
					<middle-name>
						<xsl:sequence select="fn:string(.)"/>
					</middle-name>
				</xsl:for-each>
				<xsl:for-each select="$var15_Name/com:PersonName/com:PersonStructuredName/com:FirstLastName">
					<first-last-name>
						<xsl:sequence select="fn:string(.)"/>
					</first-last-name>
				</xsl:for-each>
				<xsl:for-each select="$var15_Name/com:PersonName/com:PersonStructuredName/com:SecondLastName">
					<second-last-name>
						<xsl:sequence select="fn:string(.)"/>
					</second-last-name>
				</xsl:for-each>
				<xsl:for-each select="$var15_Name/com:PersonName/com:PersonStructuredName/com:NameSuffix">
					<suffix>
						<xsl:sequence select="fn:string(.)"/>
					</suffix>
				</xsl:for-each>
				<xsl:for-each select="$var15_Name/com:EntityName/@com:entityNameCategory">
					<role>
						<xsl:sequence select="fn:string(.)"/>
					</role>
				</xsl:for-each>
				<xsl:for-each select="($var15_Name/com:OrganizationName/com:OrganizationOtherName)[fn:exists((./@com:organizationNameCategory)[(fn:string(.) = 'Organization department name')])]">
					<department>
						<xsl:sequence select="fn:string(.)"/>
					</department>
				</xsl:for-each>
				<xsl:for-each select="$var15_Name/com:PersonName/com:PersonStructuredName/com:PersonOtherName">
					<synonym>
						<xsl:sequence select="fn:string(.)"/>
					</synonym>
				</xsl:for-each>
				<address>
					<xsl:for-each select="$var14_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:AddressLineText">
						<xsl:variable name="var1_resultof_AddressLineTextToaddress__" as="node()?">
							<xsl:call-template name="WIPO:AddressLineTextToaddress-1">
								<xsl:with-param name="AddressLineText" as="node()">
									<com:AddressLineText>
										<xsl:sequence select="(./@node(), ./node())"/>
									</com:AddressLineText>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var1_resultof_AddressLineTextToaddress__">
							<address-1>
								<xsl:sequence select="fn:string(.)"/>
							</address-1>
						</xsl:for-each>
					</xsl:for-each>
					<xsl:for-each select="$var14_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:AddressLineText">
						<xsl:variable name="var2_resultof_AddressLineTextToaddress__" as="node()?">
							<xsl:call-template name="WIPO:AddressLineTextToaddress-2">
								<xsl:with-param name="AddressLineText" as="node()">
									<com:AddressLineText>
										<xsl:sequence select="(./@node(), ./node())"/>
									</com:AddressLineText>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var2_resultof_AddressLineTextToaddress__">
							<address-2>
								<xsl:sequence select="fn:string(.)"/>
							</address-2>
						</xsl:for-each>
					</xsl:for-each>
					<xsl:for-each select="$var14_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:AddressLineText">
						<xsl:variable name="var3_resultof_AddressLineTextToaddress__" as="node()?">
							<xsl:call-template name="WIPO:AddressLineTextToaddress-3">
								<xsl:with-param name="AddressLineText" as="node()">
									<com:AddressLineText>
										<xsl:sequence select="(./@node(), ./node())"/>
									</com:AddressLineText>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var3_resultof_AddressLineTextToaddress__">
							<address-3>
								<xsl:sequence select="fn:string(.)"/>
							</address-3>
						</xsl:for-each>
					</xsl:for-each>
					<xsl:for-each select="$var14_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:AddressLineText">
						<xsl:variable name="var4_resultof_AddressLineTextToaddress__" as="node()?">
							<xsl:call-template name="WIPO:AddressLineTextToaddress-4">
								<xsl:with-param name="AddressLineText" as="node()">
									<com:AddressLineText>
										<xsl:sequence select="(./@node(), ./node())"/>
									</com:AddressLineText>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var4_resultof_AddressLineTextToaddress__">
							<address-4>
								<xsl:sequence select="fn:string(.)"/>
							</address-4>
						</xsl:for-each>
					</xsl:for-each>
					<xsl:for-each select="$var14_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:AddressLineText">
						<xsl:variable name="var5_resultof_AddressLineTextToaddress__" as="node()?">
							<xsl:call-template name="WIPO:AddressLineTextToaddress-5">
								<xsl:with-param name="AddressLineText" as="node()">
									<com:AddressLineText>
										<xsl:sequence select="(./@node(), ./node())"/>
									</com:AddressLineText>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var5_resultof_AddressLineTextToaddress__">
							<address-5>
								<xsl:sequence select="fn:string(.)"/>
							</address-5>
						</xsl:for-each>
					</xsl:for-each>
					<xsl:for-each select="$var14_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:PostalCode">
						<mailcode>
							<xsl:sequence select="fn:string(.)"/>
						</mailcode>
					</xsl:for-each>
					<xsl:for-each select="$var14_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:AddressLineText">
						<xsl:variable name="var6_resultof_AddressLineTextTopobox" as="node()?">
							<xsl:call-template name="WIPO:AddressLineTextTopobox">
								<xsl:with-param name="AddressLineText" as="node()">
									<com:AddressLineText>
										<xsl:sequence select="(./@node(), ./node())"/>
									</com:AddressLineText>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var6_resultof_AddressLineTextTopobox">
							<pobox>
								<xsl:sequence select="fn:string(.)"/>
							</pobox>
						</xsl:for-each>
					</xsl:for-each>
					<xsl:for-each select="$var14_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:AddressLineText">
						<xsl:variable name="var7_resultof_AddressLineTextToroom" as="node()?">
							<xsl:call-template name="WIPO:AddressLineTextToroom">
								<xsl:with-param name="AddressLineText" as="node()">
									<com:AddressLineText>
										<xsl:sequence select="(./@node(), ./node())"/>
									</com:AddressLineText>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var7_resultof_AddressLineTextToroom">
							<room>
								<xsl:sequence select="fn:string(.)"/>
							</room>
						</xsl:for-each>
					</xsl:for-each>
					<xsl:for-each select="$var14_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:AddressLineText">
						<xsl:variable name="var8_resultof_AddresLineTextToaddress_floor" as="node()?">
							<xsl:call-template name="WIPO:AddresLineTextToaddress-floor">
								<xsl:with-param name="AddressLineText" as="node()">
									<com:AddressLineText>
										<xsl:sequence select="(./@node(), ./node())"/>
									</com:AddressLineText>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var8_resultof_AddresLineTextToaddress_floor">
							<address-floor>
								<xsl:sequence select="fn:string(.)"/>
							</address-floor>
						</xsl:for-each>
					</xsl:for-each>
					<xsl:for-each select="$var14_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:AddressLineText">
						<xsl:variable name="var9_resultof_AddressLineTextTobuilding" as="node()?">
							<xsl:call-template name="WIPO:AddressLineTextTobuilding">
								<xsl:with-param name="AddressLineText" as="node()">
									<com:AddressLineText>
										<xsl:sequence select="(./@node(), ./node())"/>
									</com:AddressLineText>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var9_resultof_AddressLineTextTobuilding">
							<building>
								<xsl:sequence select="fn:string(.)"/>
							</building>
						</xsl:for-each>
					</xsl:for-each>
					<xsl:for-each select="$var14_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:AddressLineText">
						<xsl:variable name="var10_resultof_AddressLineTextTostreet" as="node()?">
							<xsl:call-template name="WIPO:AddressLineTextTostreet">
								<xsl:with-param name="AddressLineText" as="node()">
									<com:AddressLineText>
										<xsl:sequence select="(./@node(), ./node())"/>
									</com:AddressLineText>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var10_resultof_AddressLineTextTostreet">
							<street>
								<xsl:sequence select="fn:string(.)"/>
							</street>
						</xsl:for-each>
					</xsl:for-each>
					<xsl:for-each select="$var14_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:CityName">
						<city>
							<xsl:sequence select="fn:string(.)"/>
						</city>
					</xsl:for-each>
					<xsl:for-each select="$var14_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:GeographicRegionName">
						<xsl:variable name="var11_resultof_GeographicRegionNameTocounty" as="node()?">
							<xsl:call-template name="WIPO:GeographicRegionNameTocounty">
								<xsl:with-param name="GeographicRegionName" as="node()">
									<com:GeographicRegionName>
										<xsl:sequence select="(./@node(), ./node())"/>
									</com:GeographicRegionName>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var11_resultof_GeographicRegionNameTocounty">
							<county>
								<xsl:sequence select="fn:string(.)"/>
							</county>
						</xsl:for-each>
					</xsl:for-each>
					<xsl:for-each select="$var14_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:GeographicRegionName">
						<xsl:variable name="var12_resultof_GeographicRegionNameToState" as="node()?">
							<xsl:call-template name="WIPO:GeographicRegionNameToState">
								<xsl:with-param name="GeographicRegionName" as="node()">
									<com:GeographicRegionName>
										<xsl:sequence select="(./@node(), ./node())"/>
									</com:GeographicRegionName>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var12_resultof_GeographicRegionNameToState">
							<state>
								<xsl:sequence select="fn:string(.)"/>
							</state>
						</xsl:for-each>
					</xsl:for-each>
					<xsl:for-each select="$var14_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:PostalCode">
						<postcode>
							<xsl:sequence select="fn:string(.)"/>
						</postcode>
					</xsl:for-each>
					<xsl:for-each select="$var14_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress">
						<country>
							<xsl:sequence select="fn:string(com:CountryCode)"/>
						</country>
					</xsl:for-each>
					<xsl:for-each select="$var14_PostalAddressBag/com:PostalAddress/com:PostalAddressText">
						<text>
							<xsl:sequence select="fn:string(.)"/>
						</text>
					</xsl:for-each>
				</address>
				<xsl:for-each select="com:PhoneNumberBag/com:PhoneNumber">
					<phone>
						<xsl:sequence select="fn:string(.)"/>
					</phone>
				</xsl:for-each>
				<xsl:for-each select="com:FaxNumberBag/com:FaxNumber">
					<fax>
						<xsl:sequence select="fn:string(.)"/>
					</fax>
				</xsl:for-each>
				<xsl:for-each select="com:EmailAddressBag/com:EmailAddressText">
					<email>
						<xsl:for-each select="@com:emailAddressPurposeCategory">
							<xsl:variable name="var13_resultof_vmf__inputtoresult" as="xs:string?">
								<xsl:call-template name="vmf:vmf1_inputtoresult">
									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
								</xsl:call-template>
							</xsl:variable>
							<xsl:for-each select="$var13_resultof_vmf__inputtoresult">
								<xsl:attribute name="email-purpose" select="."/>
							</xsl:for-each>
						</xsl:for-each>
						<xsl:sequence select="fn:string(.)"/>
					</email>
				</xsl:for-each>
				<xsl:for-each select="com:WebAddressBag/com:WebAddressURI">
					<url>
						<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
					</url>
				</xsl:for-each>
				<xsl:for-each select="com:OtherElectronicAddressBag/com:OtherElectronicAddressText">
					<ead>
						<xsl:sequence select="fn:string(.)"/>
					</ead>
				</xsl:for-each>
			</xsl:for-each>
		</addressbook>
	</xsl:template>
</xsl:stylesheet>
