<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:tbl="http://www.oasis-open.org/tables/exchange/1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:WIPO="http://www.altova.com/MapForce/UDF/WIPO" xmlns:mathml="http://www.w3.org/1998/Math/MathML3" xmlns:vmf="http://www.altova.com/MapForce/UDF/vmf" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common" xmlns:pat="http://www.wipo.int/standards/XMLSchema/ST96/Patent" exclude-result-prefixes="vmf xs fn">
	<xsl:output method="xml" encoding="UTF-8" byte-order-mark="no" indent="yes"/>
	<xsl:template name="vmf:vmf1_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='informal'">
				<xsl:copy-of select="'Informal'"/>
			</xsl:when>
			<xsl:when test="$input='general'">
				<xsl:copy-of select="'General'"/>
			</xsl:when>
			<xsl:when test="$input='advanced'">
				<xsl:copy-of select="'Advanced'"/>
			</xsl:when>
			<xsl:when test="$input='main'">
				<xsl:copy-of select="'Main'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="/">
		<xsl:variable name="var4_addressbook" as="node()?" select="addressbook"/>
		<com:Contact xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common" xmlns:tbl="http://www.oasis-open.org/tables/exchange/1.0" xmlns:mathml="http://www.w3.org/1998/Math/MathML3">
			<xsl:attribute name="xsi:schemaLocation" namespace="http://www.w3.org/2001/XMLSchema-instance" select="'Common_V7_0.xsd'"/>
			<xsl:for-each select="$var4_addressbook/@lang">
				<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$var4_addressbook">
				<xsl:variable name="var3_cur" as="node()" select="."/>
				<xsl:variable name="var2_address" as="node()?" select="address"/>
				<com:Name>
					<xsl:for-each select="(./name/node())[fn:boolean(self::text())]">
						<com:PersonName>
							<com:PersonStructuredName>
								<xsl:for-each select="$var3_cur/prefix">
									<com:NamePrefix>
										<xsl:sequence select="fn:string(.)"/>
									</com:NamePrefix>
								</xsl:for-each>
								<xsl:for-each select="$var3_cur/first-name">
									<com:FirstName>
										<xsl:sequence select="fn:string(.)"/>
									</com:FirstName>
								</xsl:for-each>
								<xsl:for-each select="$var3_cur/middle-name">
									<com:MiddleName>
										<xsl:sequence select="fn:string(.)"/>
									</com:MiddleName>
								</xsl:for-each>
								<xsl:for-each select="$var3_cur/last-name">
									<com:LastName>
										<xsl:sequence select="fn:string(.)"/>
									</com:LastName>
								</xsl:for-each>
								<xsl:for-each select="$var3_cur/first-last-name">
									<com:FirstLastName>
										<xsl:sequence select="fn:string(.)"/>
									</com:FirstLastName>
								</xsl:for-each>
								<xsl:for-each select="$var3_cur/second-last-name">
									<com:SecondLastName>
										<xsl:sequence select="fn:string(.)"/>
									</com:SecondLastName>
								</xsl:for-each>
								<xsl:for-each select="$var3_cur/suffix">
									<com:NameSuffix>
										<xsl:sequence select="fn:string(.)"/>
									</com:NameSuffix>
								</xsl:for-each>
								<xsl:for-each select="$var3_cur/synonym">
									<com:PersonOtherName>
										<xsl:sequence select="fn:string(.)"/>
									</com:PersonOtherName>
								</xsl:for-each>
							</com:PersonStructuredName>
						</com:PersonName>
					</xsl:for-each>
					<xsl:for-each select="(./orgname/node())[fn:boolean(self::text())]">
						<com:OrganizationName>
							<com:OrganizationStandardName>
								<xsl:sequence select="fn:string(.)"/>
							</com:OrganizationStandardName>
						</com:OrganizationName>
					</xsl:for-each>
					<com:EntityName>
						<xsl:for-each select="role">
							<xsl:attribute name="com:entityNameCategory" select="fn:string(.)"/>
						</xsl:for-each>
					</com:EntityName>
				</com:Name>
				<com:PostalAddressBag>
					<com:PostalAddress>
						<com:PostalStructuredAddress>
							<xsl:for-each select="$var2_address/address-1">
								<com:AddressLineText>
									<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:decimal('1'))"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:AddressLineText>
							</xsl:for-each>
							<xsl:for-each select="$var2_address/address-3">
								<com:AddressLineText>
									<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:decimal('3'))"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:AddressLineText>
							</xsl:for-each>
							<xsl:for-each select="$var2_address/address-2">
								<com:AddressLineText>
									<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:decimal('2'))"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:AddressLineText>
							</xsl:for-each>
							<xsl:for-each select="$var2_address/address-4">
								<com:AddressLineText>
									<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:decimal('4'))"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:AddressLineText>
							</xsl:for-each>
							<xsl:for-each select="$var2_address/building">
								<com:AddressLineText>
									<xsl:attribute name="com:addressLineCategory" select="'Building'"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:AddressLineText>
							</xsl:for-each>
							<xsl:for-each select="$var2_address/room">
								<com:AddressLineText>
									<xsl:attribute name="com:addressLineCategory" select="'Room'"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:AddressLineText>
							</xsl:for-each>
							<xsl:for-each select="$var2_address/address-5">
								<com:AddressLineText>
									<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:decimal('5'))"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:AddressLineText>
							</xsl:for-each>
							<xsl:for-each select="$var2_address/pobox">
								<com:AddressLineText>
									<xsl:attribute name="com:addressLineCategory" select="'Postal office box'"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:AddressLineText>
							</xsl:for-each>
							<xsl:for-each select="$var2_address/street">
								<com:AddressLineText>
									<xsl:attribute name="com:addressLineCategory" select="'Street'"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:AddressLineText>
							</xsl:for-each>
							<xsl:for-each select="$var2_address/address-floor">
								<com:AddressLineText>
									<xsl:attribute name="com:addressLineCategory" select="'Floor'"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:AddressLineText>
							</xsl:for-each>
							<xsl:for-each select="$var2_address/city">
								<com:CityName>
									<xsl:sequence select="fn:string(.)"/>
								</com:CityName>
							</xsl:for-each>
							<xsl:for-each select="$var2_address/county">
								<com:GeographicRegionName>
									<xsl:attribute name="com:geographicRegionCategory" select="'County'"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:GeographicRegionName>
							</xsl:for-each>
							<xsl:for-each select="$var2_address/state">
								<com:GeographicRegionName>
									<xsl:attribute name="com:geographicRegionCategory" select="'State'"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:GeographicRegionName>
							</xsl:for-each>
							<xsl:for-each select="$var2_address/country">
								<com:CountryCode>
									<xsl:sequence select="fn:string(.)"/>
								</com:CountryCode>
							</xsl:for-each>
							<xsl:for-each select="$var2_address/mailcode">
								<com:PostalCode>
									<xsl:sequence select="fn:string(.)"/>
								</com:PostalCode>
							</xsl:for-each>
							<xsl:for-each select="$var2_address/postcode">
								<com:PostalCode>
									<xsl:sequence select="fn:string(.)"/>
								</com:PostalCode>
							</xsl:for-each>
						</com:PostalStructuredAddress>
						<xsl:for-each select="$var2_address/text">
							<com:PostalAddressText>
								<xsl:sequence select="fn:string(.)"/>
							</com:PostalAddressText>
						</xsl:for-each>
					</com:PostalAddress>
				</com:PostalAddressBag>
				<com:FaxNumberBag>
					<xsl:for-each select="fax">
						<com:FaxNumber>
							<xsl:sequence select="fn:string(.)"/>
						</com:FaxNumber>
					</xsl:for-each>
				</com:FaxNumberBag>
				<com:EmailAddressBag>
					<xsl:for-each select="email">
						<com:EmailAddressText>
							<xsl:for-each select="@email-purpose">
								<xsl:variable name="var1_resultof_vmf__inputtoresult" as="xs:string?">
									<xsl:call-template name="vmf:vmf1_inputtoresult">
										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
									</xsl:call-template>
								</xsl:variable>
								<xsl:for-each select="$var1_resultof_vmf__inputtoresult">
									<xsl:attribute name="com:emailAddressPurposeCategory" select="."/>
								</xsl:for-each>
							</xsl:for-each>
							<xsl:sequence select="fn:string(.)"/>
						</com:EmailAddressText>
					</xsl:for-each>
				</com:EmailAddressBag>
				<com:WebAddressBag>
					<xsl:for-each select="url">
						<com:WebAddressURI>
							<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
						</com:WebAddressURI>
					</xsl:for-each>
				</com:WebAddressBag>
				<com:PhoneNumberBag>
					<xsl:for-each select="phone">
						<com:PhoneNumber>
							<xsl:sequence select="fn:string(.)"/>
						</com:PhoneNumber>
					</xsl:for-each>
				</com:PhoneNumberBag>
				<com:OtherElectronicAddressBag>
					<xsl:for-each select="ead">
						<com:OtherElectronicAddressText>
							<xsl:sequence select="fn:string(.)"/>
						</com:OtherElectronicAddressText>
					</xsl:for-each>
				</com:OtherElectronicAddressBag>
			</xsl:for-each>
		</com:Contact>
	</xsl:template>
</xsl:stylesheet>
