<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:WIPO="http://www.altova.com/MapForce/UDF/WIPO" xmlns:tbf="http://www.altova.com/MapForce/UDF/tbf" xmlns:vmf="http://www.altova.com/MapForce/UDF/vmf" xmlns:tbl="http://www.oasis-open.org/tables/exchange/1.0" xmlns:mathnl="http://www.w3.org/1998/Math/MathML" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common" xmlns:pat="http://www.wipo.int/standards/XMLSchema/ST96/Patent" exclude-result-prefixes="WIPO tbf vmf tbl mathnl xs fn com pat">
	<xsl:output method="xml" encoding="UTF-8" byte-order-mark="no" indent="yes" doctype-system="../../Schemas/ST36DTD/application-body-v1-6.dtd"/>
	<xsl:template name="WIPO:ST96CitationBagToST36citation-list">
		<xsl:param name="CitationBag" select="()"/>
		<citation-list>
			<xsl:for-each select="$CitationBag/@com:id">
				<xsl:attribute name="id" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$CitationBag/com:PatentCitationBag">
				<patent-literature>
					<xsl:for-each select="com:Heading">
						<xsl:variable name="var1_resultof_ST__HeadingToST__heading" as="node()?">
							<xsl:call-template name="WIPO:ST96HeadingToST36heading">
								<xsl:with-param name="Heading" as="node()">
									<Heading xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
										<xsl:sequence select="(./@node(), ./node())"/>
									</Heading>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var1_resultof_ST__HeadingToST__heading">
							<heading>
								<xsl:sequence select="(./@node(), ./node())"/>
							</heading>
						</xsl:for-each>
					</xsl:for-each>
					<xsl:for-each select="com:P">
						<xsl:variable name="var2_resultof_ST__PToST__p" as="node()?">
							<xsl:call-template name="WIPO:ST96PToST36p">
								<xsl:with-param name="P" as="node()">
									<P xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
										<xsl:sequence select="(./@node(), ./node())"/>
									</P>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var2_resultof_ST__PToST__p">
							<p>
								<xsl:sequence select="(./@node(), ./node())"/>
							</p>
						</xsl:for-each>
					</xsl:for-each>
				</patent-literature>
			</xsl:for-each>
			<xsl:for-each select="$CitationBag/com:NPLCitationBag">
				<non-patent-literature>
					<xsl:for-each select="com:Heading">
						<xsl:variable name="var3_resultof_ST__HeadingToST__heading" as="node()?">
							<xsl:call-template name="WIPO:ST96HeadingToST36heading">
								<xsl:with-param name="Heading" as="node()">
									<Heading xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
										<xsl:sequence select="(./@node(), ./node())"/>
									</Heading>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var3_resultof_ST__HeadingToST__heading">
							<heading>
								<xsl:sequence select="(./@node(), ./node())"/>
							</heading>
						</xsl:for-each>
					</xsl:for-each>
					<xsl:for-each select="com:P">
						<xsl:variable name="var4_resultof_ST__PToST__p" as="node()?">
							<xsl:call-template name="WIPO:ST96PToST36p">
								<xsl:with-param name="P" as="node()">
									<P xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
										<xsl:sequence select="(./@node(), ./node())"/>
									</P>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var4_resultof_ST__PToST__p">
							<p>
								<xsl:sequence select="(./@node(), ./node())"/>
							</p>
						</xsl:for-each>
					</xsl:for-each>
				</non-patent-literature>
			</xsl:for-each>
			<xsl:for-each select="$CitationBag/com:Heading">
				<xsl:variable name="var5_resultof_ST__HeadingToST__heading" as="node()?">
					<xsl:call-template name="WIPO:ST96HeadingToST36heading">
						<xsl:with-param name="Heading" as="node()">
							<Heading xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Heading>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var5_resultof_ST__HeadingToST__heading">
					<heading>
						<xsl:sequence select="(./@node(), ./node())"/>
					</heading>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$CitationBag/com:P">
				<xsl:variable name="var6_resultof_ST__PToST__p" as="node()?">
					<xsl:call-template name="WIPO:ST96PToST36p">
						<xsl:with-param name="P" as="node()">
							<P xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</P>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var6_resultof_ST__PToST__p">
					<p>
						<xsl:sequence select="(./@node(), ./node())"/>
					</p>
				</xsl:for-each>
			</xsl:for-each>
		</citation-list>
	</xsl:template>
	<xsl:template name="WIPO:ST96SequenceListTextToST36sequence-list-text">
		<xsl:param name="SequenceListText" select="()"/>
		<sequence-list-text>
			<xsl:for-each select="$SequenceListText/@com:id">
				<xsl:attribute name="id" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$SequenceListText/com:Heading">
				<xsl:variable name="var1_resultof_ST__HeadingToST__heading" as="node()?">
					<xsl:call-template name="WIPO:ST96HeadingToST36heading">
						<xsl:with-param name="Heading" as="node()">
							<Heading xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Heading>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__HeadingToST__heading">
					<heading>
						<xsl:sequence select="(./@node(), ./node())"/>
					</heading>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$SequenceListText/com:P">
				<xsl:variable name="var2_resultof_ST__PToST__p" as="node()?">
					<xsl:call-template name="WIPO:ST96PToST36p">
						<xsl:with-param name="P" as="node()">
							<P xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</P>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_ST__PToST__p">
					<p>
						<xsl:sequence select="(./@node(), ./node())"/>
					</p>
				</xsl:for-each>
			</xsl:for-each>
		</sequence-list-text>
	</xsl:template>
	<xsl:template name="WIPO:ST96DepositedBiologicalMaterialReferenceToST36reference-to-deposited-biological-material">
		<xsl:param name="DepositedBiologicalMaterialReference" select="()"/>
		<reference-to-deposited-biological-material>
			<xsl:for-each select="$DepositedBiologicalMaterialReference/@com:id">
				<xsl:attribute name="id" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$DepositedBiologicalMaterialReference/com:Heading">
				<xsl:variable name="var1_resultof_ST__HeadingToST__heading" as="node()?">
					<xsl:call-template name="WIPO:ST96HeadingToST36heading">
						<xsl:with-param name="Heading" as="node()">
							<Heading xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Heading>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__HeadingToST__heading">
					<heading>
						<xsl:sequence select="(./@node(), ./node())"/>
					</heading>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$DepositedBiologicalMaterialReference/com:P">
				<xsl:variable name="var2_resultof_ST__PToST__p" as="node()?">
					<xsl:call-template name="WIPO:ST96PToST36p">
						<xsl:with-param name="P" as="node()">
							<P xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</P>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_ST__PToST__p">
					<p>
						<xsl:sequence select="(./@node(), ./node())"/>
					</p>
				</xsl:for-each>
			</xsl:for-each>
		</reference-to-deposited-biological-material>
	</xsl:template>
	<xsl:template name="WIPO:ST96ReferenceSignBagToST36reference-signs-list">
		<xsl:param name="ReferenceSignBag" select="()"/>
		<reference-signs-list>
			<xsl:for-each select="$ReferenceSignBag/@com:id">
				<xsl:attribute name="id" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$ReferenceSignBag/com:Heading">
				<xsl:variable name="var1_resultof_ST__HeadingToST__heading" as="node()?">
					<xsl:call-template name="WIPO:ST96HeadingToST36heading">
						<xsl:with-param name="Heading" as="node()">
							<Heading xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Heading>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__HeadingToST__heading">
					<heading>
						<xsl:sequence select="(./@node(), ./node())"/>
					</heading>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$ReferenceSignBag/com:P">
				<xsl:variable name="var2_resultof_ST__PToST__p" as="node()?">
					<xsl:call-template name="WIPO:ST96PToST36p">
						<xsl:with-param name="P" as="node()">
							<P xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</P>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_ST__PToST__p">
					<p>
						<xsl:sequence select="(./@node(), ./node())"/>
					</p>
				</xsl:for-each>
			</xsl:for-each>
		</reference-signs-list>
	</xsl:template>
	<xsl:template name="WIPO:ST96IndustrialApplicabilityToST36industrial-applicability">
		<xsl:param name="IndustrialApplicability" select="()"/>
		<industrial-applicability>
			<xsl:for-each select="$IndustrialApplicability/@com:id">
				<xsl:attribute name="id" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$IndustrialApplicability/com:Heading">
				<xsl:variable name="var1_resultof_ST__HeadingToST__heading" as="node()?">
					<xsl:call-template name="WIPO:ST96HeadingToST36heading">
						<xsl:with-param name="Heading" as="node()">
							<Heading xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Heading>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__HeadingToST__heading">
					<heading>
						<xsl:sequence select="(./@node(), ./node())"/>
					</heading>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$IndustrialApplicability/com:P">
				<xsl:variable name="var2_resultof_ST__PToST__p" as="node()?">
					<xsl:call-template name="WIPO:ST96PToST36p">
						<xsl:with-param name="P" as="node()">
							<P xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</P>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_ST__PToST__p">
					<p>
						<xsl:sequence select="(./@node(), ./node())"/>
					</p>
				</xsl:for-each>
			</xsl:for-each>
		</industrial-applicability>
	</xsl:template>
	<xsl:template name="WIPO:ST96InventionModeToST36mode-for-invention">
		<xsl:param name="InventionMode" select="()"/>
		<mode-for-invention>
			<xsl:for-each select="$InventionMode/@com:id">
				<xsl:attribute name="id" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$InventionMode/com:Heading">
				<xsl:variable name="var1_resultof_ST__HeadingToST__heading" as="node()?">
					<xsl:call-template name="WIPO:ST96HeadingToST36heading">
						<xsl:with-param name="Heading" as="node()">
							<Heading xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Heading>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__HeadingToST__heading">
					<heading>
						<xsl:sequence select="(./@node(), ./node())"/>
					</heading>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$InventionMode/com:P">
				<xsl:variable name="var2_resultof_ST__PToST__p" as="node()?">
					<xsl:call-template name="WIPO:ST96PToST36p">
						<xsl:with-param name="P" as="node()">
							<P xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</P>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_ST__PToST__p">
					<p>
						<xsl:sequence select="(./@node(), ./node())"/>
					</p>
				</xsl:for-each>
			</xsl:for-each>
		</mode-for-invention>
	</xsl:template>
	<xsl:template name="WIPO:ST96BestModeToST36best-mode">
		<xsl:param name="BestMode" select="()"/>
		<best-mode>
			<xsl:for-each select="$BestMode/@com:id">
				<xsl:attribute name="id" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$BestMode/com:Heading">
				<xsl:variable name="var1_resultof_ST__HeadingToST__heading" as="node()?">
					<xsl:call-template name="WIPO:ST96HeadingToST36heading">
						<xsl:with-param name="Heading" as="node()">
							<Heading xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Heading>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__HeadingToST__heading">
					<heading>
						<xsl:sequence select="(./@node(), ./node())"/>
					</heading>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$BestMode/com:P">
				<xsl:variable name="var2_resultof_ST__PToST__p" as="node()?">
					<xsl:call-template name="WIPO:ST96PToST36p">
						<xsl:with-param name="P" as="node()">
							<P xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</P>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_ST__PToST__p">
					<p>
						<xsl:sequence select="(./@node(), ./node())"/>
					</p>
				</xsl:for-each>
			</xsl:for-each>
		</best-mode>
	</xsl:template>
	<xsl:template name="WIPO:ST96EmbodimentExampleToST36embodiments-example">
		<xsl:param name="EmbodimentExample" select="()"/>
		<embodiments-example>
			<xsl:for-each select="$EmbodimentExample/@com:id">
				<xsl:attribute name="id" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$EmbodimentExample/@pat:exampleNumber">
				<xsl:attribute name="ex-num" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$EmbodimentExample/com:Heading">
				<xsl:variable name="var1_resultof_ST__HeadingToST__heading" as="node()?">
					<xsl:call-template name="WIPO:ST96HeadingToST36heading">
						<xsl:with-param name="Heading" as="node()">
							<Heading xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Heading>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__HeadingToST__heading">
					<heading>
						<xsl:sequence select="(./@node(), ./node())"/>
					</heading>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$EmbodimentExample/com:P">
				<xsl:variable name="var2_resultof_ST__PToST__p" as="node()?">
					<xsl:call-template name="WIPO:ST96PToST36p">
						<xsl:with-param name="P" as="node()">
							<P xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</P>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_ST__PToST__p">
					<p>
						<xsl:sequence select="(./@node(), ./node())"/>
					</p>
				</xsl:for-each>
			</xsl:for-each>
		</embodiments-example>
	</xsl:template>
	<xsl:template name="WIPO:ST96EmbodimentDescriptionToST36description-of-embodiments">
		<xsl:param name="EmbodimentDescription" select="()"/>
		<description-of-embodiments>
			<xsl:for-each select="$EmbodimentDescription/@com:id">
				<xsl:attribute name="id" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$EmbodimentDescription/pat:EmbodimentExample">
				<xsl:variable name="var1_resultof_ST__EmbodimentExampleToST__embodiments_example" as="node()?">
					<xsl:call-template name="WIPO:ST96EmbodimentExampleToST36embodiments-example">
						<xsl:with-param name="EmbodimentExample" as="node()">
							<EmbodimentExample xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</EmbodimentExample>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__EmbodimentExampleToST__embodiments_example">
					<embodiments-example>
						<xsl:sequence select="(./@node(), ./node())"/>
					</embodiments-example>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$EmbodimentDescription/com:Heading">
				<xsl:variable name="var2_resultof_ST__HeadingToST__heading" as="node()?">
					<xsl:call-template name="WIPO:ST96HeadingToST36heading">
						<xsl:with-param name="Heading" as="node()">
							<Heading xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Heading>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_ST__HeadingToST__heading">
					<heading>
						<xsl:sequence select="(./@node(), ./node())"/>
					</heading>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$EmbodimentDescription/com:P">
				<xsl:variable name="var3_resultof_ST__PToST__p" as="node()?">
					<xsl:call-template name="WIPO:ST96PToST36p">
						<xsl:with-param name="P" as="node()">
							<P xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</P>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var3_resultof_ST__PToST__p">
					<p>
						<xsl:sequence select="(./@node(), ./node())"/>
					</p>
				</xsl:for-each>
			</xsl:for-each>
		</description-of-embodiments>
	</xsl:template>
	<xsl:template name="WIPO:ST96DrawingDescriptionToST36description-of-drawings">
		<xsl:param name="DrawingDescription" select="()"/>
		<description-of-drawings>
			<xsl:for-each select="$DrawingDescription/@com:id">
				<xsl:attribute name="id" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$DrawingDescription/com:Heading">
				<xsl:variable name="var1_resultof_ST__HeadingToST__heading" as="node()?">
					<xsl:call-template name="WIPO:ST96HeadingToST36heading">
						<xsl:with-param name="Heading" as="node()">
							<Heading xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Heading>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__HeadingToST__heading">
					<heading>
						<xsl:sequence select="(./@node(), ./node())"/>
					</heading>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$DrawingDescription/com:P">
				<xsl:variable name="var2_resultof_ST__PToST__p" as="node()?">
					<xsl:call-template name="WIPO:ST96PToST36p">
						<xsl:with-param name="P" as="node()">
							<P xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</P>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_ST__PToST__p">
					<p>
						<xsl:sequence select="(./@node(), ./node())"/>
					</p>
				</xsl:for-each>
			</xsl:for-each>
		</description-of-drawings>
	</xsl:template>
	<xsl:template name="WIPO:ST96InventionSummaryToST36summary-of-invention">
		<xsl:param name="InventionSummary" select="()"/>
		<summary-of-invention>
			<xsl:for-each select="$InventionSummary/@com:id">
				<xsl:attribute name="id" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$InventionSummary/pat:TechnicalProblem">
				<xsl:variable name="var1_resultof_ST__TechnicalProblemToST__tech_problem" as="node()?">
					<xsl:call-template name="WIPO:ST96TechnicalProblemToST36tech-problem">
						<xsl:with-param name="TechnicalProblem" as="node()">
							<TechnicalProblem xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</TechnicalProblem>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__TechnicalProblemToST__tech_problem">
					<tech-problem>
						<xsl:sequence select="(./@node(), ./node())"/>
					</tech-problem>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$InventionSummary/pat:TechnicalSolution">
				<xsl:variable name="var2_resultof_ST__TechnicalSolutionToST__tech_solution" as="node()?">
					<xsl:call-template name="WIPO:ST96TechnicalSolutionToST36tech-solution">
						<xsl:with-param name="TechnicalSolution" as="node()">
							<TechnicalSolution xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</TechnicalSolution>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_ST__TechnicalSolutionToST__tech_solution">
					<tech-solution>
						<xsl:sequence select="(./@node(), ./node())"/>
					</tech-solution>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$InventionSummary/pat:AdvantageousEffects">
				<xsl:variable name="var3_resultof_ST__AdvantageousEffectsToST__advantageous_effects" as="node()?">
					<xsl:call-template name="WIPO:ST96AdvantageousEffectsToST36advantageous-effects">
						<xsl:with-param name="AdvantageousEffects" as="node()">
							<AdvantageousEffects xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</AdvantageousEffects>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var3_resultof_ST__AdvantageousEffectsToST__advantageous_effects">
					<advantageous-effects>
						<xsl:sequence select="(./@node(), ./node())"/>
					</advantageous-effects>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$InventionSummary/com:Heading">
				<xsl:variable name="var4_resultof_ST__HeadingToST__heading" as="node()?">
					<xsl:call-template name="WIPO:ST96HeadingToST36heading">
						<xsl:with-param name="Heading" as="node()">
							<Heading xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Heading>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var4_resultof_ST__HeadingToST__heading">
					<heading>
						<xsl:sequence select="(./@node(), ./node())"/>
					</heading>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$InventionSummary/com:P">
				<xsl:variable name="var5_resultof_ST__PToST__p" as="node()?">
					<xsl:call-template name="WIPO:ST96PToST36p">
						<xsl:with-param name="P" as="node()">
							<P xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</P>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var5_resultof_ST__PToST__p">
					<p>
						<xsl:sequence select="(./@node(), ./node())"/>
					</p>
				</xsl:for-each>
			</xsl:for-each>
		</summary-of-invention>
	</xsl:template>
	<xsl:template name="WIPO:ST96AdvantageousEffectsToST36advantageous-effects">
		<xsl:param name="AdvantageousEffects" select="()"/>
		<advantageous-effects>
			<xsl:for-each select="$AdvantageousEffects/@com:id">
				<xsl:attribute name="id" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$AdvantageousEffects/com:Heading">
				<xsl:variable name="var1_resultof_ST__HeadingToST__heading" as="node()?">
					<xsl:call-template name="WIPO:ST96HeadingToST36heading">
						<xsl:with-param name="Heading" as="node()">
							<Heading xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Heading>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__HeadingToST__heading">
					<heading>
						<xsl:sequence select="(./@node(), ./node())"/>
					</heading>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$AdvantageousEffects/com:P">
				<xsl:variable name="var2_resultof_ST__PToST__p" as="node()?">
					<xsl:call-template name="WIPO:ST96PToST36p">
						<xsl:with-param name="P" as="node()">
							<P xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</P>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_ST__PToST__p">
					<p>
						<xsl:sequence select="(./@node(), ./node())"/>
					</p>
				</xsl:for-each>
			</xsl:for-each>
		</advantageous-effects>
	</xsl:template>
	<xsl:template name="WIPO:ST96TechnicalSolutionToST36tech-solution">
		<xsl:param name="TechnicalSolution" select="()"/>
		<tech-solution>
			<xsl:for-each select="$TechnicalSolution/@com:id">
				<xsl:attribute name="id" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$TechnicalSolution/com:Heading">
				<xsl:variable name="var1_resultof_ST__HeadingToST__heading" as="node()?">
					<xsl:call-template name="WIPO:ST96HeadingToST36heading">
						<xsl:with-param name="Heading" as="node()">
							<Heading xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Heading>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__HeadingToST__heading">
					<heading>
						<xsl:sequence select="(./@node(), ./node())"/>
					</heading>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$TechnicalSolution/com:P">
				<xsl:variable name="var2_resultof_ST__PToST__p" as="node()?">
					<xsl:call-template name="WIPO:ST96PToST36p">
						<xsl:with-param name="P" as="node()">
							<P xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</P>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_ST__PToST__p">
					<p>
						<xsl:sequence select="(./@node(), ./node())"/>
					</p>
				</xsl:for-each>
			</xsl:for-each>
		</tech-solution>
	</xsl:template>
	<xsl:template name="WIPO:ST96TechnicalProblemToST36tech-problem">
		<xsl:param name="TechnicalProblem" select="()"/>
		<tech-problem>
			<xsl:for-each select="$TechnicalProblem/@com:id">
				<xsl:attribute name="id" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$TechnicalProblem/com:Heading">
				<xsl:variable name="var1_resultof_ST__HeadingToST__heading" as="node()?">
					<xsl:call-template name="WIPO:ST96HeadingToST36heading">
						<xsl:with-param name="Heading" as="node()">
							<Heading xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Heading>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__HeadingToST__heading">
					<heading>
						<xsl:sequence select="(./@node(), ./node())"/>
					</heading>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$TechnicalProblem/com:P">
				<xsl:variable name="var2_resultof_ST__PToST__p" as="node()?">
					<xsl:call-template name="WIPO:ST96PToST36p">
						<xsl:with-param name="P" as="node()">
							<P xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</P>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_ST__PToST__p">
					<p>
						<xsl:sequence select="(./@node(), ./node())"/>
					</p>
				</xsl:for-each>
			</xsl:for-each>
		</tech-problem>
	</xsl:template>
	<xsl:template name="WIPO:ST96DisclosureToST36disclosure">
		<xsl:param name="Disclosure" select="()"/>
		<disclosure>
			<xsl:for-each select="$Disclosure/@com:id">
				<xsl:attribute name="id" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$Disclosure/pat:TechnicalProblem">
				<xsl:variable name="var1_resultof_ST__TechnicalProblemToST__tech_problem" as="node()?">
					<xsl:call-template name="WIPO:ST96TechnicalProblemToST36tech-problem">
						<xsl:with-param name="TechnicalProblem" as="node()">
							<TechnicalProblem xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</TechnicalProblem>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__TechnicalProblemToST__tech_problem">
					<tech-problem>
						<xsl:sequence select="(./@node(), ./node())"/>
					</tech-problem>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Disclosure/pat:TechnicalSolution">
				<xsl:variable name="var2_resultof_ST__TechnicalSolutionToST__tech_solution" as="node()?">
					<xsl:call-template name="WIPO:ST96TechnicalSolutionToST36tech-solution">
						<xsl:with-param name="TechnicalSolution" as="node()">
							<TechnicalSolution xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</TechnicalSolution>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_ST__TechnicalSolutionToST__tech_solution">
					<tech-solution>
						<xsl:sequence select="(./@node(), ./node())"/>
					</tech-solution>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Disclosure/pat:AdvantageousEffects">
				<xsl:variable name="var3_resultof_ST__AdvantageousEffectsToST__advantageous_effects" as="node()?">
					<xsl:call-template name="WIPO:ST96AdvantageousEffectsToST36advantageous-effects">
						<xsl:with-param name="AdvantageousEffects" as="node()">
							<AdvantageousEffects xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</AdvantageousEffects>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var3_resultof_ST__AdvantageousEffectsToST__advantageous_effects">
					<advantageous-effects>
						<xsl:sequence select="(./@node(), ./node())"/>
					</advantageous-effects>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Disclosure/com:Heading">
				<xsl:variable name="var4_resultof_ST__HeadingToST__heading" as="node()?">
					<xsl:call-template name="WIPO:ST96HeadingToST36heading">
						<xsl:with-param name="Heading" as="node()">
							<Heading xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Heading>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var4_resultof_ST__HeadingToST__heading">
					<heading>
						<xsl:sequence select="(./@node(), ./node())"/>
					</heading>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Disclosure/com:P">
				<xsl:variable name="var5_resultof_ST__PToST__p" as="node()?">
					<xsl:call-template name="WIPO:ST96PToST36p">
						<xsl:with-param name="P" as="node()">
							<P xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</P>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var5_resultof_ST__PToST__p">
					<p>
						<xsl:sequence select="(./@node(), ./node())"/>
					</p>
				</xsl:for-each>
			</xsl:for-each>
		</disclosure>
	</xsl:template>
	<xsl:template name="WIPO:ST96BackgroundArtToST36background-art">
		<xsl:param name="BackgroundArt" select="()"/>
		<background-art>
			<xsl:for-each select="$BackgroundArt/@com:id">
				<xsl:attribute name="id" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$BackgroundArt/com:Heading">
				<xsl:variable name="var1_resultof_ST__HeadingToST__heading" as="node()?">
					<xsl:call-template name="WIPO:ST96HeadingToST36heading">
						<xsl:with-param name="Heading" as="node()">
							<Heading xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Heading>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__HeadingToST__heading">
					<heading>
						<xsl:sequence select="(./@node(), ./node())"/>
					</heading>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$BackgroundArt/com:P">
				<xsl:variable name="var2_resultof_ST__PToST__p" as="node()?">
					<xsl:call-template name="WIPO:ST96PToST36p">
						<xsl:with-param name="P" as="node()">
							<P xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</P>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_ST__PToST__p">
					<p>
						<xsl:sequence select="(./@node(), ./node())"/>
					</p>
				</xsl:for-each>
			</xsl:for-each>
		</background-art>
	</xsl:template>
	<xsl:template name="WIPO:ST96HeadingToST36heading">
		<xsl:param name="Heading" select="()"/>
		<heading>
			<xsl:for-each select="$Heading/@com:headingLevelCode">
				<xsl:variable name="var1_resultof_vmf__inputtoresult" as="xs:string?">
					<xsl:call-template name="vmf:vmf2_inputtoresult">
						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_vmf__inputtoresult">
					<xsl:attribute name="level" select="."/>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Heading/@com:id">
				<xsl:attribute name="id" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="($Heading/node())[fn:boolean(self::text())]">
				<xsl:sequence select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$Heading/com:B">
				<xsl:variable name="var2_resultof_ST__BToST__b" as="node()?">
					<xsl:call-template name="WIPO:ST96BToST36b">
						<xsl:with-param name="B" as="node()">
							<B xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</B>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_ST__BToST__b">
					<b>
						<xsl:sequence select="(./@node(), ./node())"/>
					</b>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Heading/com:I">
				<xsl:variable name="var3_resultof_ST__IToST__i" as="node()?">
					<xsl:call-template name="WIPO:ST96IToST36i">
						<xsl:with-param name="I" as="node()">
							<I xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</I>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var3_resultof_ST__IToST__i">
					<i>
						<xsl:sequence select="(./@node(), ./node())"/>
					</i>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Heading/com:U">
				<xsl:variable name="var4_resultof_ST__UToST__u" as="node()?">
					<xsl:call-template name="WIPO:ST96UToST36u">
						<xsl:with-param name="U" as="node()">
							<U xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</U>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var4_resultof_ST__UToST__u">
					<u>
						<xsl:sequence select="(./@node(), ./node())"/>
					</u>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Heading/com:O">
				<xsl:variable name="var5_resultof_ST__OToST__o" as="node()?">
					<xsl:call-template name="WIPO:ST96OToST36o">
						<xsl:with-param name="O" as="node()">
							<O xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</O>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var5_resultof_ST__OToST__o">
					<o>
						<xsl:sequence select="(./@node(), ./node())"/>
					</o>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Heading/com:Sup">
				<xsl:variable name="var6_resultof_ST__SupToST__sup" as="node()?">
					<xsl:call-template name="WIPO:ST96SupToST36sup">
						<xsl:with-param name="Sup" as="node()">
							<Sup xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Sup>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var6_resultof_ST__SupToST__sup">
					<sup>
						<xsl:sequence select="(./@node(), ./node())"/>
					</sup>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Heading/com:Sub">
				<xsl:variable name="var7_resultof_ST__SubToSt__sub" as="node()?">
					<xsl:call-template name="WIPO:ST96SubToSt36sub">
						<xsl:with-param name="Sub" as="node()">
							<Sub xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Sub>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var7_resultof_ST__SubToSt__sub">
					<sub>
						<xsl:sequence select="(./@node(), ./node())"/>
					</sub>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Heading/com:SmallCapital">
				<xsl:variable name="var8_resultof_ST__SmallCapitalToST__smallcaps" as="node()?">
					<xsl:call-template name="WIPO:ST96SmallCapitalToST36smallcaps">
						<xsl:with-param name="SmallCapital" as="node()">
							<SmallCapital xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</SmallCapital>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var8_resultof_ST__SmallCapitalToST__smallcaps">
					<smallcaps>
						<xsl:sequence select="(./@node(), ./node())"/>
					</smallcaps>
				</xsl:for-each>
			</xsl:for-each>
		</heading>
	</xsl:template>
	<xsl:template name="WIPO:ST96TechnicalFieldToST36technical-field">
		<xsl:param name="TechnicalField" select="()"/>
		<technical-field>
			<xsl:for-each select="$TechnicalField/@com:id">
				<xsl:attribute name="id" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$TechnicalField/com:Heading">
				<xsl:variable name="var1_resultof_ST__HeadingToST__heading" as="node()?">
					<xsl:call-template name="WIPO:ST96HeadingToST36heading">
						<xsl:with-param name="Heading" as="node()">
							<Heading xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Heading>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__HeadingToST__heading">
					<heading>
						<xsl:sequence select="(./@node(), ./node())"/>
					</heading>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$TechnicalField/com:P">
				<xsl:variable name="var2_resultof_ST__PToST__p" as="node()?">
					<xsl:call-template name="WIPO:ST96PToST36p">
						<xsl:with-param name="P" as="node()">
							<P xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</P>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_ST__PToST__p">
					<p>
						<xsl:sequence select="(./@node(), ./node())"/>
					</p>
				</xsl:for-each>
			</xsl:for-each>
		</technical-field>
	</xsl:template>
	<xsl:template name="WIPO:ST96InventionTitleToST36invention-title">
		<xsl:param name="InventionTitle" select="()"/>
		<invention-title>
			<xsl:for-each select="$InventionTitle/@com:id">
				<xsl:attribute name="id" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$InventionTitle/@com:languageCode">
				<xsl:attribute name="lang" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$InventionTitle/node()">
				<xsl:if test="fn:boolean(self::text())">
					<xsl:sequence select="fn:string(.)"/>
				</xsl:if>
				<xsl:variable name="var1_test_resultof_node_name_equal_qname" as="node()?">
					<xsl:if test="fn:boolean(self::com:B)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:variable>
				<xsl:for-each select="$var1_test_resultof_node_name_equal_qname">
					<xsl:variable name="var2_resultof_ST__BToST__b" as="node()?">
						<xsl:call-template name="WIPO:ST96BToST36b">
							<xsl:with-param name="B" as="node()">
								<B xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="(./@node(), ./node())"/>
								</B>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:for-each select="$var2_resultof_ST__BToST__b">
						<b>
							<xsl:sequence select="(./@node(), ./node())"/>
						</b>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:variable name="var3_test_resultof_node_name_equal_qname" as="node()?">
					<xsl:if test="fn:boolean(self::com:I)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:variable>
				<xsl:for-each select="$var3_test_resultof_node_name_equal_qname">
					<xsl:variable name="var4_resultof_ST__IToST__i" as="node()?">
						<xsl:call-template name="WIPO:ST96IToST36i">
							<xsl:with-param name="I" as="node()">
								<I xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="(./@node(), ./node())"/>
								</I>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:for-each select="$var4_resultof_ST__IToST__i">
						<i>
							<xsl:sequence select="(./@node(), ./node())"/>
						</i>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:variable name="var5_test_resultof_node_name_equal_qname" as="node()?">
					<xsl:if test="fn:boolean(self::com:U)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:variable>
				<xsl:for-each select="$var5_test_resultof_node_name_equal_qname">
					<xsl:variable name="var6_resultof_ST__UToST__u" as="node()?">
						<xsl:call-template name="WIPO:ST96UToST36u">
							<xsl:with-param name="U" as="node()">
								<U xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="(./@node(), ./node())"/>
								</U>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:for-each select="$var6_resultof_ST__UToST__u">
						<u>
							<xsl:sequence select="(./@node(), ./node())"/>
						</u>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:variable name="var7_test_resultof_node_name_equal_qname" as="node()?">
					<xsl:if test="fn:boolean(self::com:O)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:variable>
				<xsl:for-each select="$var7_test_resultof_node_name_equal_qname">
					<xsl:variable name="var8_resultof_ST__OToST__o" as="node()?">
						<xsl:call-template name="WIPO:ST96OToST36o">
							<xsl:with-param name="O" as="node()">
								<O xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="(./@node(), ./node())"/>
								</O>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:for-each select="$var8_resultof_ST__OToST__o">
						<o>
							<xsl:sequence select="(./@node(), ./node())"/>
						</o>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:variable name="var9_test_resultof_node_name_equal_qname" as="node()?">
					<xsl:if test="fn:boolean(self::com:Sup)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:variable>
				<xsl:for-each select="$var9_test_resultof_node_name_equal_qname">
					<xsl:variable name="var10_resultof_ST__SupToST__sup" as="node()?">
						<xsl:call-template name="WIPO:ST96SupToST36sup">
							<xsl:with-param name="Sup" as="node()">
								<Sup xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="(./@node(), ./node())"/>
								</Sup>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:for-each select="$var10_resultof_ST__SupToST__sup">
						<sup>
							<xsl:sequence select="(./@node(), ./node())"/>
						</sup>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:variable name="var11_test_resultof_node_name_equal_qname" as="node()?">
					<xsl:if test="fn:boolean(self::com:Sub)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:variable>
				<xsl:for-each select="$var11_test_resultof_node_name_equal_qname">
					<xsl:variable name="var12_resultof_ST__SubToSt__sub" as="node()?">
						<xsl:call-template name="WIPO:ST96SubToSt36sub">
							<xsl:with-param name="Sub" as="node()">
								<Sub xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="(./@node(), ./node())"/>
								</Sub>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:for-each select="$var12_resultof_ST__SubToSt__sub">
						<sub>
							<xsl:sequence select="(./@node(), ./node())"/>
						</sub>
					</xsl:for-each>
				</xsl:for-each>
			</xsl:for-each>
		</invention-title>
	</xsl:template>
	<xsl:template name="WIPO:ST96DescriptionToST36description">
		<xsl:param name="Description" select="()"/>
		<description>
			<xsl:for-each select="$Description/@com:id">
				<xsl:attribute name="id" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$Description/@com:languageCode">
				<xsl:attribute name="lang" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$Description/pat:DocumentURI">
				<xsl:variable name="var4_cur" as="node()" select="."/>
				<xsl:variable name="var3___as_string" as="xs:string" select="xs:string(xs:decimal('0'))"/>
				<xsl:variable name="var2_firstPageNumber" as="node()?" select="@pat:firstPageNumber"/>
				<doc-page>
					<xsl:for-each select="@com:id">
						<xsl:attribute name="id" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:attribute name="he" select="$var3___as_string"/>
					<xsl:attribute name="wi" select="$var3___as_string"/>
					<xsl:for-each select="@pat:pageDocumentFormatCategory">
						<xsl:variable name="var1_resultof_vmf__inputtoresult" as="xs:string?">
							<xsl:call-template name="vmf:vmf1_inputtoresult">
								<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var1_resultof_vmf__inputtoresult">
							<xsl:attribute name="type" select="."/>
						</xsl:for-each>
					</xsl:for-each>
					<xsl:for-each select="($var2_firstPageNumber)[fn:not(fn:exists($var4_cur/@pat:lastPageNumber))]">
						<xsl:attribute name="pp" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:for-each select="($var2_firstPageNumber)[fn:exists($var4_cur/@pat:lastPageNumber)]">
						<xsl:attribute name="ppf" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:for-each select="@com:documentFileName">
						<xsl:attribute name="file" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:for-each select="@pat:ocrIndicator">
						<xsl:attribute name="ocr" select="xs:string(xs:boolean(fn:string(.)))"/>
					</xsl:for-each>
				</doc-page>
			</xsl:for-each>
			<xsl:for-each select="$Description/pat:PageImage">
				<xsl:variable name="var5_resultof_ST__PageImageToST__doc_page" as="node()?">
					<xsl:call-template name="WIPO:ST96PageImageToST36doc-page">
						<xsl:with-param name="PageImage" as="node()">
							<PageImage xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</PageImage>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var5_resultof_ST__PageImageToST__doc_page">
					<doc-page>
						<xsl:sequence select="(./@node(), ./node())"/>
					</doc-page>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Description/pat:InventionTitle">
				<xsl:variable name="var6_resultof_ST__InventionTitleToST__invention_title" as="node()?">
					<xsl:call-template name="WIPO:ST96InventionTitleToST36invention-title">
						<xsl:with-param name="InventionTitle" as="node()">
							<InventionTitle xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</InventionTitle>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var6_resultof_ST__InventionTitleToST__invention_title">
					<invention-title>
						<xsl:sequence select="(./@node(), ./node())"/>
					</invention-title>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Description/pat:TechnicalField">
				<xsl:variable name="var7_resultof_ST__TechnicalFieldToST__technical_field" as="node()?">
					<xsl:call-template name="WIPO:ST96TechnicalFieldToST36technical-field">
						<xsl:with-param name="TechnicalField" as="node()">
							<TechnicalField xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</TechnicalField>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var7_resultof_ST__TechnicalFieldToST__technical_field">
					<technical-field>
						<xsl:sequence select="(./@node(), ./node())"/>
					</technical-field>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Description/pat:BackgroundArt">
				<xsl:variable name="var8_resultof_ST__BackgroundArtToST__background_art" as="node()?">
					<xsl:call-template name="WIPO:ST96BackgroundArtToST36background-art">
						<xsl:with-param name="BackgroundArt" as="node()">
							<BackgroundArt xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</BackgroundArt>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var8_resultof_ST__BackgroundArtToST__background_art">
					<background-art>
						<xsl:sequence select="(./@node(), ./node())"/>
					</background-art>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Description/pat:Disclosure">
				<xsl:variable name="var9_resultof_ST__DisclosureToST__disclosure" as="node()?">
					<xsl:call-template name="WIPO:ST96DisclosureToST36disclosure">
						<xsl:with-param name="Disclosure" as="node()">
							<Disclosure xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Disclosure>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var9_resultof_ST__DisclosureToST__disclosure">
					<disclosure>
						<xsl:sequence select="(./@node(), ./node())"/>
					</disclosure>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Description/pat:InventionSummary">
				<xsl:variable name="var10_resultof_ST__InventionSummaryToST__summary_of_invention" as="node()?">
					<xsl:call-template name="WIPO:ST96InventionSummaryToST36summary-of-invention">
						<xsl:with-param name="InventionSummary" as="node()">
							<InventionSummary xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</InventionSummary>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var10_resultof_ST__InventionSummaryToST__summary_of_invention">
					<summary-of-invention>
						<xsl:sequence select="(./@node(), ./node())"/>
					</summary-of-invention>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Description/pat:DrawingDescription">
				<xsl:variable name="var11_resultof_ST__DrawingDescriptionToST__description_of_drawings" as="node()?">
					<xsl:call-template name="WIPO:ST96DrawingDescriptionToST36description-of-drawings">
						<xsl:with-param name="DrawingDescription" as="node()">
							<DrawingDescription xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</DrawingDescription>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var11_resultof_ST__DrawingDescriptionToST__description_of_drawings">
					<description-of-drawings>
						<xsl:sequence select="(./@node(), ./node())"/>
					</description-of-drawings>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Description/pat:EmbodimentDescription">
				<xsl:variable name="var12_resultof_ST__EmbodimentDescriptionToST__description_of_embodiments" as="node()?">
					<xsl:call-template name="WIPO:ST96EmbodimentDescriptionToST36description-of-embodiments">
						<xsl:with-param name="EmbodimentDescription" as="node()">
							<EmbodimentDescription xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</EmbodimentDescription>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var12_resultof_ST__EmbodimentDescriptionToST__description_of_embodiments">
					<description-of-embodiments>
						<xsl:sequence select="(./@node(), ./node())"/>
					</description-of-embodiments>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Description/pat:BestMode">
				<xsl:variable name="var13_resultof_ST__BestModeToST__best_mode" as="node()?">
					<xsl:call-template name="WIPO:ST96BestModeToST36best-mode">
						<xsl:with-param name="BestMode" as="node()">
							<BestMode xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</BestMode>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var13_resultof_ST__BestModeToST__best_mode">
					<best-mode>
						<xsl:sequence select="(./@node(), ./node())"/>
					</best-mode>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Description/pat:InventionMode">
				<xsl:variable name="var14_resultof_ST__InventionModeToST__mode_for_invention" as="node()?">
					<xsl:call-template name="WIPO:ST96InventionModeToST36mode-for-invention">
						<xsl:with-param name="InventionMode" as="node()">
							<InventionMode xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</InventionMode>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var14_resultof_ST__InventionModeToST__mode_for_invention">
					<mode-for-invention>
						<xsl:sequence select="(./@node(), ./node())"/>
					</mode-for-invention>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Description/pat:IndustrialApplicability">
				<xsl:variable name="var15_resultof_ST__IndustrialApplicabilityToST__industrial_applicability" as="node()?">
					<xsl:call-template name="WIPO:ST96IndustrialApplicabilityToST36industrial-applicability">
						<xsl:with-param name="IndustrialApplicability" as="node()">
							<IndustrialApplicability xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</IndustrialApplicability>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var15_resultof_ST__IndustrialApplicabilityToST__industrial_applicability">
					<industrial-applicability>
						<xsl:sequence select="(./@node(), ./node())"/>
					</industrial-applicability>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Description/pat:ReferenceSignBag">
				<xsl:variable name="var16_resultof_ST__ReferenceSignBagToST__reference_signs_list" as="node()?">
					<xsl:call-template name="WIPO:ST96ReferenceSignBagToST36reference-signs-list">
						<xsl:with-param name="ReferenceSignBag" as="node()">
							<ReferenceSignBag xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</ReferenceSignBag>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var16_resultof_ST__ReferenceSignBagToST__reference_signs_list">
					<reference-signs-list>
						<xsl:sequence select="(./@node(), ./node())"/>
					</reference-signs-list>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Description/pat:DepositedBiologicalMaterialReference">
				<xsl:variable name="var17_resultof_ST__DepositedBiologicalMaterialReferenceToST__reference_to_deposited_biological_material" as="node()?">
					<xsl:call-template name="WIPO:ST96DepositedBiologicalMaterialReferenceToST36reference-to-deposited-biological-material">
						<xsl:with-param name="DepositedBiologicalMaterialReference" as="node()">
							<DepositedBiologicalMaterialReference xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</DepositedBiologicalMaterialReference>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var17_resultof_ST__DepositedBiologicalMaterialReferenceToST__reference_to_deposited_biological_material">
					<reference-to-deposited-biological-material>
						<xsl:sequence select="(./@node(), ./node())"/>
					</reference-to-deposited-biological-material>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Description/pat:SequenceListText">
				<xsl:variable name="var18_resultof_ST__SequenceListTextToST__sequence_list_text" as="node()?">
					<xsl:call-template name="WIPO:ST96SequenceListTextToST36sequence-list-text">
						<xsl:with-param name="SequenceListText" as="node()">
							<SequenceListText xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</SequenceListText>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var18_resultof_ST__SequenceListTextToST__sequence_list_text">
					<sequence-list-text>
						<xsl:sequence select="(./@node(), ./node())"/>
					</sequence-list-text>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Description/com:CitationBag">
				<xsl:variable name="var19_resultof_ST__CitationBagToST__citation_list" as="node()?">
					<xsl:call-template name="WIPO:ST96CitationBagToST36citation-list">
						<xsl:with-param name="CitationBag" as="node()">
							<CitationBag xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</CitationBag>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var19_resultof_ST__CitationBagToST__citation_list">
					<citation-list>
						<xsl:sequence select="(./@node(), ./node())"/>
					</citation-list>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Description/com:Heading">
				<xsl:variable name="var20_resultof_ST__HeadingToST__heading" as="node()?">
					<xsl:call-template name="WIPO:ST96HeadingToST36heading">
						<xsl:with-param name="Heading" as="node()">
							<Heading xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Heading>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var20_resultof_ST__HeadingToST__heading">
					<heading>
						<xsl:sequence select="(./@node(), ./node())"/>
					</heading>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Description/com:P">
				<xsl:variable name="var21_resultof_ST__PToST__p" as="node()?">
					<xsl:call-template name="WIPO:ST96PToST36p">
						<xsl:with-param name="P" as="node()">
							<P xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</P>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var21_resultof_ST__PToST__p">
					<p>
						<xsl:sequence select="(./@node(), ./node())"/>
					</p>
				</xsl:for-each>
			</xsl:for-each>
		</description>
	</xsl:template>
	<xsl:template name="WIPO:ST96ClaimTextToST36claim-text">
		<xsl:param name="ClaimText" select="()"/>
		<claim-text>
			<xsl:for-each select="$ClaimText/node()">
				<xsl:if test="fn:boolean(self::text())">
					<xsl:sequence select="fn:string(.)"/>
				</xsl:if>
				<xsl:variable name="var1_test_resultof_node_name_equal_qname" as="node()?">
					<xsl:if test="fn:boolean(self::pat:ClaimText)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:variable>
				<xsl:for-each select="$var1_test_resultof_node_name_equal_qname">
					<xsl:variable name="var2_resultof_ST__ClaimTextToST__claim_text" as="node()?">
						<xsl:call-template name="WIPO:ST96ClaimTextToST36claim-text">
							<xsl:with-param name="ClaimText" as="node()">
								<ClaimText xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
									<xsl:sequence select="(./@node(), ./node())"/>
								</ClaimText>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:for-each select="$var2_resultof_ST__ClaimTextToST__claim_text">
						<claim-text>
							<xsl:sequence select="(./@node(), ./node())"/>
						</claim-text>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:variable name="var3_test_resultof_node_name_equal_qname" as="node()?">
					<xsl:if test="fn:boolean(self::pat:ClaimReference)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:variable>
				<xsl:for-each select="$var3_test_resultof_node_name_equal_qname">
					<claim-ref>
						<xsl:for-each select="@com:idrefs">
							<xsl:attribute name="idref" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
						</xsl:for-each>
						<xsl:for-each select="(./node())[fn:boolean(self::text())]">
							<xsl:sequence select="fn:string(.)"/>
						</xsl:for-each>
					</claim-ref>
				</xsl:for-each>
				<xsl:variable name="var4_test_resultof_node_name_equal_qname" as="node()?">
					<xsl:if test="fn:boolean(self::com:B)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:variable>
				<xsl:for-each select="$var4_test_resultof_node_name_equal_qname">
					<xsl:variable name="var5_resultof_ST__BToST__b" as="node()?">
						<xsl:call-template name="WIPO:ST96BToST36b">
							<xsl:with-param name="B" as="node()">
								<B xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="(./@node(), ./node())"/>
								</B>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:for-each select="$var5_resultof_ST__BToST__b">
						<b>
							<xsl:sequence select="(./@node(), ./node())"/>
						</b>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:variable name="var6_test_resultof_node_name_equal_qname" as="node()?">
					<xsl:if test="fn:boolean(self::com:I)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:variable>
				<xsl:for-each select="$var6_test_resultof_node_name_equal_qname">
					<xsl:variable name="var7_resultof_ST__IToST__i" as="node()?">
						<xsl:call-template name="WIPO:ST96IToST36i">
							<xsl:with-param name="I" as="node()">
								<I xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="(./@node(), ./node())"/>
								</I>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:for-each select="$var7_resultof_ST__IToST__i">
						<i>
							<xsl:sequence select="(./@node(), ./node())"/>
						</i>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:variable name="var8_test_resultof_node_name_equal_qname" as="node()?">
					<xsl:if test="fn:boolean(self::com:U)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:variable>
				<xsl:for-each select="$var8_test_resultof_node_name_equal_qname">
					<xsl:variable name="var9_resultof_ST__UToST__u" as="node()?">
						<xsl:call-template name="WIPO:ST96UToST36u">
							<xsl:with-param name="U" as="node()">
								<U xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="(./@node(), ./node())"/>
								</U>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:for-each select="$var9_resultof_ST__UToST__u">
						<u>
							<xsl:sequence select="(./@node(), ./node())"/>
						</u>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:variable name="var10_test_resultof_node_name_equal_qname" as="node()?">
					<xsl:if test="fn:boolean(self::com:O)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:variable>
				<xsl:for-each select="$var10_test_resultof_node_name_equal_qname">
					<xsl:variable name="var11_resultof_ST__OToST__o" as="node()?">
						<xsl:call-template name="WIPO:ST96OToST36o">
							<xsl:with-param name="O" as="node()">
								<O xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="(./@node(), ./node())"/>
								</O>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:for-each select="$var11_resultof_ST__OToST__o">
						<o>
							<xsl:sequence select="(./@node(), ./node())"/>
						</o>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:variable name="var12_test_resultof_node_name_equal_qname" as="node()?">
					<xsl:if test="fn:boolean(self::com:Sup)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:variable>
				<xsl:for-each select="$var12_test_resultof_node_name_equal_qname">
					<xsl:variable name="var13_resultof_ST__SupToST__sup" as="node()?">
						<xsl:call-template name="WIPO:ST96SupToST36sup">
							<xsl:with-param name="Sup" as="node()">
								<Sup xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="(./@node(), ./node())"/>
								</Sup>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:for-each select="$var13_resultof_ST__SupToST__sup">
						<sup>
							<xsl:sequence select="(./@node(), ./node())"/>
						</sup>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:variable name="var14_test_resultof_node_name_equal_qname" as="node()?">
					<xsl:if test="fn:boolean(self::com:Sub)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:variable>
				<xsl:for-each select="$var14_test_resultof_node_name_equal_qname">
					<xsl:variable name="var15_resultof_ST__SubToSt__sub" as="node()?">
						<xsl:call-template name="WIPO:ST96SubToSt36sub">
							<xsl:with-param name="Sub" as="node()">
								<Sub xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="(./@node(), ./node())"/>
								</Sub>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:for-each select="$var15_resultof_ST__SubToSt__sub">
						<sub>
							<xsl:sequence select="(./@node(), ./node())"/>
						</sub>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:variable name="var16_test_resultof_node_name_equal_qname" as="node()?">
					<xsl:if test="fn:boolean(self::com:SmallCapital)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:variable>
				<xsl:for-each select="$var16_test_resultof_node_name_equal_qname">
					<xsl:variable name="var17_resultof_ST__SmallCapitalToST__smallcaps" as="node()?">
						<xsl:call-template name="WIPO:ST96SmallCapitalToST36smallcaps">
							<xsl:with-param name="SmallCapital" as="node()">
								<SmallCapital xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="(./@node(), ./node())"/>
								</SmallCapital>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:for-each select="$var17_resultof_ST__SmallCapitalToST__smallcaps">
						<smallcaps>
							<xsl:sequence select="(./@node(), ./node())"/>
						</smallcaps>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:variable name="var18_test_resultof_node_name_equal_qname" as="node()?">
					<xsl:if test="fn:boolean(self::com:Br)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:variable>
				<xsl:for-each select="$var18_test_resultof_node_name_equal_qname">
					<br>
						<xsl:sequence select="()"/>
					</br>
				</xsl:for-each>
				<xsl:variable name="var19_test_resultof_node_name_equal_qname" as="node()?">
					<xsl:if test="fn:boolean(self::com:Pre)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:variable>
				<xsl:for-each select="$var19_test_resultof_node_name_equal_qname">
					<xsl:variable name="var20_resultof_ST__PreToST__pre" as="node()?">
						<xsl:call-template name="WIPO:ST96PreToST36pre">
							<xsl:with-param name="Pre" as="node()">
								<Pre xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="(./@node(), ./node())"/>
								</Pre>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:for-each select="$var20_resultof_ST__PreToST__pre">
						<pre>
							<xsl:sequence select="(./@node(), ./node())"/>
						</pre>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:variable name="var21_test_resultof_node_name_equal_qname" as="node()?">
					<xsl:if test="fn:boolean(self::com:CrossReference)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:variable>
				<xsl:for-each select="$var21_test_resultof_node_name_equal_qname">
					<xsl:variable name="var22_resultof_ST__CrossReferenceToST__crossref" as="node()?">
						<xsl:call-template name="WIPO:ST96CrossReferenceToST36crossref">
							<xsl:with-param name="CrossReference" as="node()">
								<CrossReference xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="(./@node(), ./node())"/>
								</CrossReference>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:for-each select="$var22_resultof_ST__CrossReferenceToST__crossref">
						<crossref>
							<xsl:sequence select="(./@node(), ./node())"/>
						</crossref>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:variable name="var23_test_resultof_node_name_equal_qname" as="node()?">
					<xsl:if test="fn:boolean(self::com:FigureReference)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:variable>
				<xsl:for-each select="$var23_test_resultof_node_name_equal_qname">
					<xsl:variable name="var24_resultof_ST__FigureReferenceToST__figref" as="node()?">
						<xsl:call-template name="WIPO:ST96FigureReferenceToST36figref">
							<xsl:with-param name="FigureReference" as="node()">
								<FigureReference xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="(./@node(), ./node())"/>
								</FigureReference>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:for-each select="$var24_resultof_ST__FigureReferenceToST__figref">
						<figref>
							<xsl:sequence select="(./@node(), ./node())"/>
						</figref>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:variable name="var25_test_resultof_node_name_equal_qname" as="node()?">
					<xsl:if test="fn:boolean(self::com:Image)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:variable>
				<xsl:for-each select="$var25_test_resultof_node_name_equal_qname">
					<xsl:variable name="var26_resultof_ST__ImageToST__img" as="node()?">
						<xsl:call-template name="WIPO:ST96ImageToST36img">
							<xsl:with-param name="Image" as="node()">
								<Image xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="(./@node(), ./node())"/>
								</Image>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:for-each select="$var26_resultof_ST__ImageToST__img">
						<img>
							<xsl:sequence select="(./@node(), ./node())"/>
						</img>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:variable name="var27_test_resultof_node_name_equal_qname" as="node()?">
					<xsl:if test="fn:boolean(self::com:ChemicalFormulae)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:variable>
				<xsl:for-each select="$var27_test_resultof_node_name_equal_qname">
					<xsl:variable name="var28_resultof_ST__ChemicalFormulaeToST__chemistry" as="node()?">
						<xsl:call-template name="WIPO:ST96ChemicalFormulaeToST36chemistry">
							<xsl:with-param name="ChemicalFormulae" as="node()">
								<ChemicalFormulae xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="(./@node(), ./node())"/>
								</ChemicalFormulae>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:for-each select="$var28_resultof_ST__ChemicalFormulaeToST__chemistry">
						<chemistry>
							<xsl:sequence select="(./@node(), ./node())"/>
						</chemistry>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:variable name="var29_test_resultof_node_name_equal_qname" as="node()?">
					<xsl:if test="fn:boolean(self::com:Math)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:variable>
				<xsl:for-each select="$var29_test_resultof_node_name_equal_qname">
					<xsl:variable name="var30_resultof_ST__MathToST__math" as="node()?">
						<xsl:call-template name="WIPO:ST96MathToST36math">
							<xsl:with-param name="Math" as="node()">
								<Math xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="(./@node(), ./node())"/>
								</Math>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:for-each select="$var30_resultof_ST__MathToST__math">
						<maths>
							<xsl:sequence select="(./@node(), ./node())"/>
						</maths>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:variable name="var31_test_resultof_node_name_equal_qname" as="node()?">
					<xsl:if test="fn:boolean(self::com:Table)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:variable>
				<xsl:for-each select="$var31_test_resultof_node_name_equal_qname">
					<xsl:variable name="var32_resultof_ST__TableToST__tables" as="node()?">
						<xsl:call-template name="WIPO:ST96TableToST36tables">
							<xsl:with-param name="Table" as="node()">
								<Table xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="(./@node(), ./node())"/>
								</Table>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:for-each select="$var32_resultof_ST__TableToST__tables">
						<tables>
							<xsl:sequence select="(./@node(), ./node())"/>
						</tables>
					</xsl:for-each>
				</xsl:for-each>
			</xsl:for-each>
		</claim-text>
	</xsl:template>
	<xsl:template name="WIPO:ST96ClaimToST36claim">
		<xsl:param name="Claim" select="()"/>
		<claim>
			<xsl:for-each select="$Claim/@com:id">
				<xsl:attribute name="id" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$Claim/pat:ClaimNumber">
				<xsl:attribute name="num" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$Claim/pat:ClaimText">
				<xsl:variable name="var1_resultof_ST__ClaimTextToST__claim_text" as="node()?">
					<xsl:call-template name="WIPO:ST96ClaimTextToST36claim-text">
						<xsl:with-param name="ClaimText" as="node()">
							<ClaimText xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</ClaimText>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__ClaimTextToST__claim_text">
					<claim-text>
						<xsl:sequence select="(./@node(), ./node())"/>
					</claim-text>
				</xsl:for-each>
			</xsl:for-each>
		</claim>
	</xsl:template>
	<xsl:template name="WIPO:ST96ClaimsToST36claims">
		<xsl:param name="Claims" select="()"/>
		<claims>
			<xsl:for-each select="$Claims/@com:id">
				<xsl:attribute name="id" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$Claims/@com:languageCode">
				<xsl:attribute name="lang" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$Claims/pat:PageImage">
				<xsl:variable name="var1_resultof_ST__PageImageToST__doc_page" as="node()?">
					<xsl:call-template name="WIPO:ST96PageImageToST36doc-page">
						<xsl:with-param name="PageImage" as="node()">
							<PageImage xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</PageImage>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__PageImageToST__doc_page">
					<doc-page>
						<xsl:sequence select="(./@node(), ./node())"/>
					</doc-page>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Claims/pat:DocumentURI">
				<xsl:variable name="var5_cur" as="node()" select="."/>
				<xsl:variable name="var4___as_string" as="xs:string" select="xs:string(xs:decimal('0'))"/>
				<xsl:variable name="var3_firstPageNumber" as="node()?" select="@pat:firstPageNumber"/>
				<doc-page>
					<xsl:for-each select="@com:id">
						<xsl:attribute name="id" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:attribute name="he" select="$var4___as_string"/>
					<xsl:attribute name="wi" select="$var4___as_string"/>
					<xsl:for-each select="@pat:pageDocumentFormatCategory">
						<xsl:variable name="var2_resultof_vmf__inputtoresult" as="xs:string?">
							<xsl:call-template name="vmf:vmf1_inputtoresult">
								<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var2_resultof_vmf__inputtoresult">
							<xsl:attribute name="type" select="."/>
						</xsl:for-each>
					</xsl:for-each>
					<xsl:for-each select="($var3_firstPageNumber)[fn:not(fn:exists($var5_cur/@pat:lastPageNumber))]">
						<xsl:attribute name="pp" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:for-each select="($var3_firstPageNumber)[fn:exists($var5_cur/@pat:lastPageNumber)]">
						<xsl:attribute name="ppf" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:for-each select="@com:documentFileName">
						<xsl:attribute name="file" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:for-each select="@pat:ocrIndicator">
						<xsl:attribute name="ocr" select="xs:string(xs:boolean(fn:string(.)))"/>
					</xsl:for-each>
				</doc-page>
			</xsl:for-each>
			<xsl:for-each select="$Claims/pat:Claim">
				<xsl:variable name="var6_resultof_ST__ClaimToST__claim" as="node()?">
					<xsl:call-template name="WIPO:ST96ClaimToST36claim">
						<xsl:with-param name="Claim" as="node()">
							<Claim xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Patent">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Claim>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var6_resultof_ST__ClaimToST__claim">
					<claim>
						<xsl:sequence select="(./@node(), ./node())"/>
					</claim>
				</xsl:for-each>
			</xsl:for-each>
		</claims>
	</xsl:template>
	<xsl:template name="WIPO:ST96EntryToST36entry">
		<xsl:param name="Entry" select="()"/>
		<entry>
			<xsl:for-each select="$Entry/@tbl:colname">
				<xsl:attribute name="colname" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$Entry/@tbl:namest">
				<xsl:attribute name="namest" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$Entry/@tbl:nameend">
				<xsl:attribute name="nameend" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$Entry/@tbl:morerows">
				<xsl:attribute name="morerows" select="xs:string(xs:integer(fn:string(.)))"/>
			</xsl:for-each>
			<xsl:for-each select="$Entry/@tbl:colsep">
				<xsl:attribute name="colsep" select="xs:string(xs:boolean(fn:string(.)))"/>
			</xsl:for-each>
			<xsl:for-each select="$Entry/@tbl:rowsep">
				<xsl:attribute name="rowsep" select="xs:string(xs:boolean(fn:string(.)))"/>
			</xsl:for-each>
			<xsl:for-each select="$Entry/@tbl:align">
				<xsl:attribute name="align" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$Entry/@tbl:char">
				<xsl:attribute name="char" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$Entry/@tbl:charoff">
				<xsl:attribute name="charoff" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$Entry/@tbl:valign">
				<xsl:attribute name="valign" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="($Entry/node())[fn:boolean(self::text())]">
				<xsl:sequence select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$Entry/com:B">
				<xsl:variable name="var1_resultof_ST__BToST__b" as="node()?">
					<xsl:call-template name="WIPO:ST96BToST36b">
						<xsl:with-param name="B" as="node()">
							<B xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</B>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__BToST__b">
					<b>
						<xsl:sequence select="(./@node(), ./node())"/>
					</b>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Entry/com:I">
				<xsl:variable name="var2_resultof_ST__IToST__i" as="node()?">
					<xsl:call-template name="WIPO:ST96IToST36i">
						<xsl:with-param name="I" as="node()">
							<I xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</I>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_ST__IToST__i">
					<i>
						<xsl:sequence select="(./@node(), ./node())"/>
					</i>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Entry/com:U">
				<xsl:variable name="var3_resultof_ST__UToST__u" as="node()?">
					<xsl:call-template name="WIPO:ST96UToST36u">
						<xsl:with-param name="U" as="node()">
							<U xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</U>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var3_resultof_ST__UToST__u">
					<u>
						<xsl:sequence select="(./@node(), ./node())"/>
					</u>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Entry/com:Sup">
				<xsl:variable name="var4_resultof_ST__SupToST__sup" as="node()?">
					<xsl:call-template name="WIPO:ST96SupToST36sup">
						<xsl:with-param name="Sup" as="node()">
							<Sup xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Sup>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var4_resultof_ST__SupToST__sup">
					<sup>
						<xsl:sequence select="(./@node(), ./node())"/>
					</sup>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Entry/com:Sub">
				<xsl:variable name="var5_resultof_ST__SubToSt__sub" as="node()?">
					<xsl:call-template name="WIPO:ST96SubToSt36sub">
						<xsl:with-param name="Sub" as="node()">
							<Sub xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Sub>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var5_resultof_ST__SubToSt__sub">
					<sub>
						<xsl:sequence select="(./@node(), ./node())"/>
					</sub>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Entry/com:SmallCapital">
				<xsl:variable name="var6_resultof_ST__SmallCapitalToST__smallcaps" as="node()?">
					<xsl:call-template name="WIPO:ST96SmallCapitalToST36smallcaps">
						<xsl:with-param name="SmallCapital" as="node()">
							<SmallCapital xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</SmallCapital>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var6_resultof_ST__SmallCapitalToST__smallcaps">
					<smallcaps>
						<xsl:sequence select="(./@node(), ./node())"/>
					</smallcaps>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Entry/com:Br">
				<br>
					<xsl:sequence select="()"/>
				</br>
			</xsl:for-each>
			<xsl:for-each select="$Entry/com:PatentCitation">
				<xsl:variable name="var7_resultof_ST__PatentCitationToST__patcit" as="node()?">
					<xsl:call-template name="WIPO:ST96PatentCitationToST36patcit">
						<xsl:with-param name="PatentCitation" as="node()">
							<PatentCitation xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</PatentCitation>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var7_resultof_ST__PatentCitationToST__patcit">
					<patcit>
						<xsl:sequence select="(./@node(), ./node())"/>
					</patcit>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Entry/com:NPLCitation">
				<xsl:variable name="var8_resultof_ST__NPLCitationToST__nplcit" as="node()?">
					<xsl:call-template name="WIPO:ST96NPLCitationToST36nplcit">
						<xsl:with-param name="NPLCitation" as="node()">
							<NPLCitation xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</NPLCitation>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var8_resultof_ST__NPLCitationToST__nplcit">
					<nplcit>
						<xsl:sequence select="(./@node(), ./node())"/>
					</nplcit>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Entry/com:BioDeposit">
				<xsl:variable name="var9_resultof_ST__BioDepositToST__bio_deposit" as="node()?">
					<xsl:call-template name="WIPO:ST96BioDepositToST36bio-deposit">
						<xsl:with-param name="BioDeposit" as="node()">
							<BioDeposit xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</BioDeposit>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var9_resultof_ST__BioDepositToST__bio_deposit">
					<bio-deposit>
						<xsl:sequence select="(./@node(), ./node())"/>
					</bio-deposit>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Entry/com:CrossReference">
				<xsl:variable name="var10_resultof_ST__CrossReferenceToST__crossref" as="node()?">
					<xsl:call-template name="WIPO:ST96CrossReferenceToST36crossref">
						<xsl:with-param name="CrossReference" as="node()">
							<CrossReference xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</CrossReference>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var10_resultof_ST__CrossReferenceToST__crossref">
					<crossref>
						<xsl:sequence select="(./@node(), ./node())"/>
					</crossref>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Entry/com:DL">
				<xsl:variable name="var11_resultof_ST__DLToST__dl" as="node()?">
					<xsl:call-template name="WIPO:ST96DLToST36dl">
						<xsl:with-param name="DL" as="node()">
							<DL xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</DL>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var11_resultof_ST__DLToST__dl">
					<dl>
						<xsl:sequence select="(./@node(), ./node())"/>
					</dl>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Entry/com:UL">
				<xsl:variable name="var12_resultof_ST__ULToST__ul" as="node()?">
					<xsl:call-template name="WIPO:ST96ULToST36ul">
						<xsl:with-param name="UL" as="node()">
							<UL xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</UL>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var12_resultof_ST__ULToST__ul">
					<ul>
						<xsl:sequence select="(./@node(), ./node())"/>
					</ul>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Entry/com:OL">
				<xsl:variable name="var13_resultof_ST__OLToST__ol" as="node()?">
					<xsl:call-template name="WIPO:ST96OLToST36ol">
						<xsl:with-param name="OL" as="node()">
							<OL xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</OL>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var13_resultof_ST__OLToST__ol">
					<ol>
						<xsl:sequence select="(./@node(), ./node())"/>
					</ol>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Entry/com:ChemicalFormulae">
				<xsl:variable name="var14_resultof_ST__ChemicalFormulaeToST__chemistry" as="node()?">
					<xsl:call-template name="WIPO:ST96ChemicalFormulaeToST36chemistry">
						<xsl:with-param name="ChemicalFormulae" as="node()">
							<ChemicalFormulae xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</ChemicalFormulae>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var14_resultof_ST__ChemicalFormulaeToST__chemistry">
					<chemistry>
						<xsl:sequence select="(./@node(), ./node())"/>
					</chemistry>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Entry/com:Math">
				<xsl:variable name="var15_resultof_ST__MathToST__math" as="node()?">
					<xsl:call-template name="WIPO:ST96MathToST36math">
						<xsl:with-param name="Math" as="node()">
							<Math xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Math>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var15_resultof_ST__MathToST__math">
					<maths>
						<xsl:sequence select="(./@node(), ./node())"/>
					</maths>
				</xsl:for-each>
			</xsl:for-each>
		</entry>
	</xsl:template>
	<xsl:template name="WIPO:ST96TableTitleToST36title">
		<xsl:param name="TableTitle" select="()"/>
		<title>
			<xsl:for-each select="($TableTitle/node())[fn:boolean(self::text())]">
				<xsl:sequence select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$TableTitle/com:B">
				<xsl:variable name="var1_resultof_ST__BToST__b" as="node()?">
					<xsl:call-template name="WIPO:ST96BToST36b">
						<xsl:with-param name="B" as="node()">
							<B xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</B>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__BToST__b">
					<b>
						<xsl:sequence select="(./@node(), ./node())"/>
					</b>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$TableTitle/com:I">
				<xsl:variable name="var2_resultof_ST__IToST__i" as="node()?">
					<xsl:call-template name="WIPO:ST96IToST36i">
						<xsl:with-param name="I" as="node()">
							<I xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</I>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_ST__IToST__i">
					<i>
						<xsl:sequence select="(./@node(), ./node())"/>
					</i>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$TableTitle/com:U">
				<xsl:variable name="var3_resultof_ST__UToST__u" as="node()?">
					<xsl:call-template name="WIPO:ST96UToST36u">
						<xsl:with-param name="U" as="node()">
							<U xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</U>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var3_resultof_ST__UToST__u">
					<u>
						<xsl:sequence select="(./@node(), ./node())"/>
					</u>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$TableTitle/com:Sup">
				<xsl:variable name="var4_resultof_ST__SupToST__sup" as="node()?">
					<xsl:call-template name="WIPO:ST96SupToST36sup">
						<xsl:with-param name="Sup" as="node()">
							<Sup xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Sup>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var4_resultof_ST__SupToST__sup">
					<sup>
						<xsl:sequence select="(./@node(), ./node())"/>
					</sup>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$TableTitle/com:Sub">
				<xsl:variable name="var5_resultof_ST__SubToSt__sub" as="node()?">
					<xsl:call-template name="WIPO:ST96SubToSt36sub">
						<xsl:with-param name="Sub" as="node()">
							<Sub xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Sub>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var5_resultof_ST__SubToSt__sub">
					<sub>
						<xsl:sequence select="(./@node(), ./node())"/>
					</sub>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$TableTitle/com:SmallCapital">
				<xsl:variable name="var6_resultof_ST__SmallCapitalToST__smallcaps" as="node()?">
					<xsl:call-template name="WIPO:ST96SmallCapitalToST36smallcaps">
						<xsl:with-param name="SmallCapital" as="node()">
							<SmallCapital xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</SmallCapital>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var6_resultof_ST__SmallCapitalToST__smallcaps">
					<smallcaps>
						<xsl:sequence select="(./@node(), ./node())"/>
					</smallcaps>
				</xsl:for-each>
			</xsl:for-each>
		</title>
	</xsl:template>
	<xsl:template name="WIPO:ST96IPOASISTableToST36table">
		<xsl:param name="IPOASISTable" select="()"/>
		<table>
			<xsl:for-each select="$IPOASISTable/@tbl:frame">
				<xsl:attribute name="frame" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$IPOASISTable/@tbl:colsep">
				<xsl:attribute name="colsep" select="xs:string(xs:boolean(fn:string(.)))"/>
			</xsl:for-each>
			<xsl:for-each select="$IPOASISTable/@tbl:rowsep">
				<xsl:attribute name="rowsep" select="xs:string(xs:boolean(fn:string(.)))"/>
			</xsl:for-each>
			<xsl:for-each select="$IPOASISTable/@com:pageWide">
				<xsl:attribute name="pgwide" select="xs:string(xs:decimal(fn:string(.)))"/>
			</xsl:for-each>
			<xsl:for-each select="$IPOASISTable/com:TableTitle">
				<xsl:variable name="var1_resultof_ST__TableTitleToST__title" as="node()?">
					<xsl:call-template name="WIPO:ST96TableTitleToST36title">
						<xsl:with-param name="TableTitle" as="node()">
							<TableTitle xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</TableTitle>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__TableTitleToST__title">
					<title>
						<xsl:sequence select="(./@node(), ./node())"/>
					</title>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$IPOASISTable/com:TableGroup">
				<tgroup>
					<xsl:for-each select="@tbl:cols">
						<xsl:attribute name="cols" select="xs:string(xs:integer(fn:string(.)))"/>
					</xsl:for-each>
					<xsl:for-each select="@tbl:colsep">
						<xsl:attribute name="colsep" select="xs:string(xs:boolean(fn:string(.)))"/>
					</xsl:for-each>
					<xsl:for-each select="@tbl:rowsep">
						<xsl:attribute name="rowsep" select="xs:string(xs:boolean(fn:string(.)))"/>
					</xsl:for-each>
					<xsl:for-each select="@tbl:align">
						<xsl:attribute name="align" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:for-each select="tbl:colspec">
						<colspec>
							<xsl:for-each select="@tbl:colnum">
								<xsl:attribute name="colnum" select="xs:string(xs:integer(fn:string(.)))"/>
							</xsl:for-each>
							<xsl:for-each select="@tbl:colname">
								<xsl:attribute name="colname" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@tbl:colwidth">
								<xsl:attribute name="colwidth" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@tbl:colsep">
								<xsl:attribute name="colsep" select="xs:string(xs:boolean(fn:string(.)))"/>
							</xsl:for-each>
							<xsl:for-each select="@tbl:rowsep">
								<xsl:attribute name="rowsep" select="xs:string(xs:boolean(fn:string(.)))"/>
							</xsl:for-each>
							<xsl:for-each select="@tbl:align">
								<xsl:attribute name="align" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@tbl:char">
								<xsl:attribute name="char" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@tbl:charoff">
								<xsl:attribute name="charoff" select="fn:string(.)"/>
							</xsl:for-each>
						</colspec>
					</xsl:for-each>
					<xsl:for-each select="tbl:thead">
						<thead>
							<xsl:for-each select="@tbl:valign">
								<xsl:attribute name="valign" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="tbl:row">
								<row>
									<xsl:for-each select="@tbl:rowsep">
										<xsl:attribute name="rowsep" select="xs:string(xs:boolean(fn:string(.)))"/>
									</xsl:for-each>
									<xsl:for-each select="@tbl:valign">
										<xsl:attribute name="valign" select="fn:string(.)"/>
									</xsl:for-each>
								</row>
							</xsl:for-each>
						</thead>
					</xsl:for-each>
					<xsl:for-each select="com:TableBody">
						<tbody>
							<xsl:for-each select="@tbl:valign">
								<xsl:attribute name="valign" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="com:Row">
								<row>
									<xsl:for-each select="@tbl:rowsep">
										<xsl:attribute name="rowsep" select="xs:string(xs:boolean(fn:string(.)))"/>
									</xsl:for-each>
									<xsl:for-each select="@tbl:valign">
										<xsl:attribute name="valign" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="com:Entry">
										<xsl:variable name="var2_resultof_ST__EntryToST__entry" as="node()?">
											<xsl:call-template name="WIPO:ST96EntryToST36entry">
												<xsl:with-param name="Entry" as="node()">
													<Entry xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
														<xsl:sequence select="(./@node(), ./node())"/>
													</Entry>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:variable>
										<xsl:for-each select="$var2_resultof_ST__EntryToST__entry">
											<entry>
												<xsl:sequence select="(./@node(), ./node())"/>
											</entry>
										</xsl:for-each>
									</xsl:for-each>
								</row>
							</xsl:for-each>
						</tbody>
					</xsl:for-each>
				</tgroup>
			</xsl:for-each>
		</table>
	</xsl:template>
	<xsl:template name="WIPO:ST96TableToST36tables">
		<xsl:param name="Table" select="()"/>
		<xsl:variable name="var3_IPOASISTable" as="node()*" select="$Table/com:IPOASISTable"/>
		<tables>
			<xsl:for-each select="$var3_IPOASISTable/@com:tableNumber">
				<xsl:attribute name="num" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$Table/com:TableImage">
				<xsl:variable name="var1_resultof_ST__ImageToST__img" as="node()?">
					<xsl:call-template name="WIPO:ST96ImageToST36img">
						<xsl:with-param name="Image" as="node()">
							<Image xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:for-each select="@com:id">
									<xsl:attribute name="com:id" select="fn:string(.)"/>
								</xsl:for-each>
								<xsl:for-each select="@com:fileLocationURI">
									<xsl:attribute name="com:fileLocationURI" select="xs:string(xs:anyURI(fn:string(.)))"/>
								</xsl:for-each>
								<xsl:for-each select="@com:imageContentCategory">
									<xsl:attribute name="com:imageContentCategory" select="fn:string(.)"/>
								</xsl:for-each>
								<xsl:for-each select="@com:orientationCategory">
									<xsl:attribute name="com:orientationCategory" select="fn:string(.)"/>
								</xsl:for-each>
								<xsl:for-each select="@com:imageWrappingStyleCategory">
									<xsl:attribute name="com:imageWrappingStyleCategory" select="fn:string(.)"/>
								</xsl:for-each>
								<xsl:for-each select="com:ImageFormatCategory">
									<ImageFormatCategory>
										<xsl:sequence select="fn:string(.)"/>
									</ImageFormatCategory>
								</xsl:for-each>
								<xsl:for-each select="com:FileName">
									<FileName>
										<xsl:sequence select="fn:string(.)"/>
									</FileName>
								</xsl:for-each>
								<xsl:for-each select="com:HeightMeasure">
									<HeightMeasure>
										<xsl:sequence select="(./@node(), ./node())"/>
									</HeightMeasure>
								</xsl:for-each>
								<xsl:for-each select="com:WidthMeasure">
									<WidthMeasure>
										<xsl:sequence select="(./@node(), ./node())"/>
									</WidthMeasure>
								</xsl:for-each>
								<xsl:for-each select="com:Alt">
									<Alt>
										<xsl:sequence select="fn:string(.)"/>
									</Alt>
								</xsl:for-each>
								<xsl:for-each select="com:HorizontalResolutionQuantity">
									<HorizontalResolutionQuantity>
										<xsl:sequence select="(./@node(), ./node())"/>
									</HorizontalResolutionQuantity>
								</xsl:for-each>
								<xsl:for-each select="com:VerticalResolutionQuantity">
									<VerticalResolutionQuantity>
										<xsl:sequence select="(./@node(), ./node())"/>
									</VerticalResolutionQuantity>
								</xsl:for-each>
								<xsl:for-each select="com:ImageResolutionQuantity">
									<ImageResolutionQuantity>
										<xsl:sequence select="(./@node(), ./node())"/>
									</ImageResolutionQuantity>
								</xsl:for-each>
								<xsl:for-each select="com:BitDepthQuantity">
									<BitDepthQuantity>
										<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
									</BitDepthQuantity>
								</xsl:for-each>
								<xsl:for-each select="com:ColourIndicator">
									<ColourIndicator>
										<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
									</ColourIndicator>
								</xsl:for-each>
								<xsl:for-each select="com:ColourModeCategory">
									<ColourModeCategory>
										<xsl:sequence select="fn:string(.)"/>
									</ColourModeCategory>
								</xsl:for-each>
								<xsl:for-each select="com:Caption">
									<Caption>
										<xsl:sequence select="(./@node(), ./node())"/>
									</Caption>
								</xsl:for-each>
								<xsl:for-each select="com:ImageStatusCategory">
									<ImageStatusCategory>
										<xsl:sequence select="fn:string(.)"/>
									</ImageStatusCategory>
								</xsl:for-each>
								<xsl:for-each select="com:ImageRenditionCategory">
									<ImageRenditionCategory>
										<xsl:sequence select="fn:string(.)"/>
									</ImageRenditionCategory>
								</xsl:for-each>
							</Image>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__ImageToST__img">
					<img>
						<xsl:sequence select="(./@node(), ./node())"/>
					</img>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$var3_IPOASISTable">
				<xsl:variable name="var2_resultof_ST__IPOASISTableToST__table" as="node()?">
					<xsl:call-template name="WIPO:ST96IPOASISTableToST36table">
						<xsl:with-param name="IPOASISTable" as="node()">
							<IPOASISTable xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</IPOASISTable>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_ST__IPOASISTableToST__table">
					<table>
						<xsl:sequence select="(./@node(), ./node())"/>
					</table>
				</xsl:for-each>
			</xsl:for-each>
		</tables>
	</xsl:template>
	<xsl:template name="WIPO:ST96BioDepositDepositaryToST36depositary">
		<xsl:param name="BioDepositDepositary" select="()"/>
		<xsl:variable name="var1_PostalAddressBag" as="node()*" select="$BioDepositDepositary/com:PostalAddressBag"/>
		<depositary>
			<xsl:for-each select="$var1_PostalAddressBag/com:PostalAddress/com:PostalAddressText">
				<xsl:sequence select="fn:string(.)"/>
			</xsl:for-each>
			<address>
				<xsl:for-each select="$var1_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:AddressLineText">
					<address-1>
						<xsl:sequence select="fn:string(.)"/>
					</address-1>
				</xsl:for-each>
				<xsl:for-each select="$var1_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:AddressLineText">
					<address-2>
						<xsl:sequence select="fn:string(.)"/>
					</address-2>
				</xsl:for-each>
				<xsl:for-each select="$var1_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:AddressLineText">
					<address-3>
						<xsl:sequence select="fn:string(.)"/>
					</address-3>
				</xsl:for-each>
				<xsl:for-each select="$var1_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:AddressLineText">
					<address-4>
						<xsl:sequence select="fn:string(.)"/>
					</address-4>
				</xsl:for-each>
				<xsl:for-each select="$var1_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:AddressLineText">
					<address-5>
						<xsl:sequence select="fn:string(.)"/>
					</address-5>
				</xsl:for-each>
				<xsl:for-each select="$var1_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:CityName">
					<city>
						<xsl:sequence select="fn:string(.)"/>
					</city>
				</xsl:for-each>
				<xsl:for-each select="$var1_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:GeographicRegionName">
					<state>
						<xsl:sequence select="fn:string(.)"/>
					</state>
				</xsl:for-each>
				<xsl:for-each select="$var1_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:PostalCode">
					<postcode>
						<xsl:sequence select="fn:string(.)"/>
					</postcode>
				</xsl:for-each>
				<xsl:for-each select="$var1_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:CountryCode">
					<country>
						<xsl:sequence select="fn:string(.)"/>
					</country>
				</xsl:for-each>
				<xsl:for-each select="$var1_PostalAddressBag/com:PostalAddress/com:PostalStructuredAddress/com:AddressLineText">
					<text>
						<xsl:sequence select="fn:string(.)"/>
					</text>
				</xsl:for-each>
				<xsl:for-each select="$var1_PostalAddressBag/com:PostalAddress/com:PostalAddressText/@com:languageCode">
					<text>
						<xsl:sequence select="fn:string(.)"/>
					</text>
				</xsl:for-each>
			</address>
		</depositary>
	</xsl:template>
	<xsl:template name="WIPO:ST96BioDepositToST36bio-deposit">
		<xsl:param name="BioDeposit" select="()"/>
		<bio-deposit>
			<xsl:for-each select="$BioDeposit/@com:id">
				<xsl:attribute name="id" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$BioDeposit/@com:sequenceNumber">
				<xsl:attribute name="num" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$BioDeposit/@com:sourceURI">
				<xsl:attribute name="url" select="xs:string(xs:anyURI(fn:string(.)))"/>
			</xsl:for-each>
			<xsl:for-each select="$BioDeposit/com:BioDepositDepositary">
				<xsl:variable name="var1_resultof_ST__BioDepositDepositaryToST__depositary" as="node()?">
					<xsl:call-template name="WIPO:ST96BioDepositDepositaryToST36depositary">
						<xsl:with-param name="BioDepositDepositary" as="node()">
							<BioDepositDepositary xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="()"/>
							</BioDepositDepositary>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__BioDepositDepositaryToST__depositary">
					<depositary>
						<xsl:sequence select="fn:string(.)"/>
					</depositary>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$BioDeposit/com:BiologicalAccessionNumber">
				<bio-accno>
					<xsl:sequence select="fn:string(.)"/>
				</bio-accno>
			</xsl:for-each>
			<xsl:for-each select="$BioDeposit/com:BioDepositDate">
				<date>
					<xsl:sequence select="fn:string(.)"/>
				</date>
			</xsl:for-each>
			<xsl:for-each select="$BioDeposit/com:BioDepositTermText">
				<term>
					<xsl:sequence select="fn:string(.)"/>
				</term>
			</xsl:for-each>
			<xsl:for-each select="$BioDeposit/com:BioDepositText">
				<dtext>
					<xsl:sequence select="fn:string(.)"/>
				</dtext>
			</xsl:for-each>
		</bio-deposit>
	</xsl:template>
	<xsl:template name="WIPO:ST96FigureReferenceToST36figref">
		<xsl:param name="FigureReference" select="()"/>
		<figref>
			<xsl:for-each select="$FigureReference/@com:idrefs">
				<xsl:attribute name="idref" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
			</xsl:for-each>
			<xsl:for-each select="$FigureReference/@com:referencedFigureNumber">
				<xsl:attribute name="num" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="($FigureReference/node())[fn:boolean(self::text())]">
				<xsl:sequence select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$FigureReference/com:B">
				<xsl:variable name="var1_resultof_ST__BToST__b" as="node()?">
					<xsl:call-template name="WIPO:ST96BToST36b">
						<xsl:with-param name="B" as="node()">
							<B xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</B>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__BToST__b">
					<b>
						<xsl:sequence select="fn:string(.)"/>
					</b>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$FigureReference/com:I">
				<xsl:variable name="var2_resultof_ST__IToST__i" as="node()?">
					<xsl:call-template name="WIPO:ST96IToST36i">
						<xsl:with-param name="I" as="node()">
							<I xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</I>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_ST__IToST__i">
					<i>
						<xsl:sequence select="fn:string(.)"/>
					</i>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$FigureReference/com:U">
				<xsl:variable name="var3_resultof_ST__UToST__u" as="node()?">
					<xsl:call-template name="WIPO:ST96UToST36u">
						<xsl:with-param name="U" as="node()">
							<U xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</U>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var3_resultof_ST__UToST__u">
					<u>
						<xsl:sequence select="fn:string(.)"/>
					</u>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$FigureReference/com:O">
				<xsl:variable name="var4_resultof_ST__OToST__o" as="node()?">
					<xsl:call-template name="WIPO:ST96OToST36o">
						<xsl:with-param name="O" as="node()">
							<O xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</O>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var4_resultof_ST__OToST__o">
					<o>
						<xsl:sequence select="fn:string(.)"/>
					</o>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$FigureReference/com:Sup">
				<xsl:variable name="var5_resultof_ST__SupToST__sup" as="node()?">
					<xsl:call-template name="WIPO:ST96SupToST36sup">
						<xsl:with-param name="Sup" as="node()">
							<Sup xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Sup>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var5_resultof_ST__SupToST__sup">
					<sup>
						<xsl:sequence select="fn:string(.)"/>
					</sup>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$FigureReference/com:Sub">
				<xsl:variable name="var6_resultof_ST__SubToSt__sub" as="node()?">
					<xsl:call-template name="WIPO:ST96SubToSt36sub">
						<xsl:with-param name="Sub" as="node()">
							<Sub xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Sub>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var6_resultof_ST__SubToSt__sub">
					<sub>
						<xsl:sequence select="fn:string(.)"/>
					</sub>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$FigureReference/com:SmallCapital">
				<xsl:variable name="var7_resultof_ST__SmallCapitalToST__smallcaps" as="node()?">
					<xsl:call-template name="WIPO:ST96SmallCapitalToST36smallcaps">
						<xsl:with-param name="SmallCapital" as="node()">
							<SmallCapital xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</SmallCapital>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var7_resultof_ST__SmallCapitalToST__smallcaps">
					<smallcaps>
						<xsl:sequence select="fn:string(.)"/>
					</smallcaps>
				</xsl:for-each>
			</xsl:for-each>
		</figref>
	</xsl:template>
	<xsl:template name="WIPO:ST96ChemicalFormulaeToST36chemistry">
		<xsl:param name="ChemicalFormulae" select="()"/>
		<chemistry>
			<xsl:for-each select="$ChemicalFormulae/@com:chemicalFormulaeNumber">
				<xsl:attribute name="num" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$ChemicalFormulae/com:Image">
				<xsl:variable name="var1_resultof_ST__ImageToST__img" as="node()?">
					<xsl:call-template name="WIPO:ST96ImageToST36img">
						<xsl:with-param name="Image" as="node()">
							<Image xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Image>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__ImageToST__img">
					<img>
						<xsl:sequence select="(./@node(), ./node())"/>
					</img>
				</xsl:for-each>
			</xsl:for-each>
		</chemistry>
	</xsl:template>
	<xsl:template name="WIPO:ST96MathToST36math">
		<xsl:param name="Math" select="()"/>
		<maths>
			<xsl:for-each select="$Math/@com:mathNumber">
				<xsl:attribute name="num" select="fn:string(.)"/>
			</xsl:for-each>
			<xsl:for-each select="$Math/com:Image">
				<xsl:variable name="var1_resultof_ST__ImageToST__img" as="node()?">
					<xsl:call-template name="WIPO:ST96ImageToST36img">
						<xsl:with-param name="Image" as="node()">
							<Image xmlns="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="(./@node(), ./node())"/>
							</Image>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_ST__ImageToST__img">
					<img>
						<xsl:sequence select="(./@node(), ./node())"/>
					</img>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Math/mathnl:math">
				<xsl:variable name="var3279_type" as="node()?" select="@type"/>
				<math>
					<xsl:for-each select="@xlink:href">
						<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
					</xsl:for-each>
					<xsl:for-each select="$var3279_type">
						<xsl:attribute name="xlink:type" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:for-each select="@class">
						<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
					</xsl:for-each>
					<xsl:for-each select="@style">
						<xsl:attribute name="style" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:for-each select="@id">
						<xsl:attribute name="id" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:for-each select="@xref">
						<xsl:attribute name="xref" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:for-each select="@macros">
						<xsl:attribute name="macros" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:for-each select="@display">
						<xsl:attribute name="display" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:for-each select="$var3279_type">
						<xsl:attribute name="type" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:for-each select="@name">
						<xsl:attribute name="name" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:for-each select="@height">
						<xsl:attribute name="height" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:for-each select="@width">
						<xsl:attribute name="width" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:for-each select="@baseline">
						<xsl:attribute name="baseline" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:for-each select="@overflow">
						<xsl:attribute name="overflow" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:for-each select="@altimg">
						<xsl:attribute name="altimg" select="xs:string(xs:anyURI(fn:string(.)))"/>
					</xsl:for-each>
					<xsl:for-each select="@alttext">
						<xsl:attribute name="alttext" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:for-each select="mathnl:mi">
						<mi>
							<xsl:for-each select="@xlink:href">
								<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
							</xsl:for-each>
							<xsl:for-each select="@class">
								<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
							</xsl:for-each>
							<xsl:for-each select="@style">
								<xsl:attribute name="style" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@id">
								<xsl:attribute name="id" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@xref">
								<xsl:attribute name="xref" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@mathvariant">
								<xsl:attribute name="mathvariant" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@mathsize">
								<xsl:attribute name="mathsize" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@mathcolor">
								<xsl:attribute name="mathcolor" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@mathbackground">
								<xsl:attribute name="mathbackground" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="node()">
								<xsl:if test="fn:boolean(self::text())">
									<xsl:sequence select="fn:string(.)"/>
								</xsl:if>
								<xsl:variable name="var2_test_resultof_node_name_equal_qname" as="node()?">
									<xsl:if test="fn:boolean(self::mathnl:mglyph)">
										<xsl:sequence select="."/>
									</xsl:if>
								</xsl:variable>
								<xsl:for-each select="$var2_test_resultof_node_name_equal_qname">
									<mglyph>
										<xsl:call-template name="tbf:tbf1_mglyph">
											<xsl:with-param name="input" select="." as="node()"/>
										</xsl:call-template>
									</mglyph>
								</xsl:for-each>
								<xsl:variable name="var3_test_resultof_node_name_equal_qname" as="node()?">
									<xsl:if test="fn:boolean(self::mathnl:malignmark)">
										<xsl:sequence select="."/>
									</xsl:if>
								</xsl:variable>
								<xsl:for-each select="$var3_test_resultof_node_name_equal_qname">
									<malignmark>
										<xsl:for-each select="@edge">
											<xsl:attribute name="edge" select="fn:string(.)"/>
										</xsl:for-each>
									</malignmark>
								</xsl:for-each>
							</xsl:for-each>
						</mi>
					</xsl:for-each>
					<xsl:for-each select="mathnl:mn">
						<mn>
							<xsl:for-each select="@xlink:href">
								<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
							</xsl:for-each>
							<xsl:for-each select="@class">
								<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
							</xsl:for-each>
							<xsl:for-each select="@style">
								<xsl:attribute name="style" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@id">
								<xsl:attribute name="id" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@xref">
								<xsl:attribute name="xref" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@mathvariant">
								<xsl:attribute name="mathvariant" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@mathsize">
								<xsl:attribute name="mathsize" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@mathcolor">
								<xsl:attribute name="mathcolor" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@mathbackground">
								<xsl:attribute name="mathbackground" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="node()">
								<xsl:if test="fn:boolean(self::text())">
									<xsl:sequence select="fn:string(.)"/>
								</xsl:if>
								<xsl:variable name="var4_test_resultof_node_name_equal_qname" as="node()?">
									<xsl:if test="fn:boolean(self::mathnl:mglyph)">
										<xsl:sequence select="."/>
									</xsl:if>
								</xsl:variable>
								<xsl:for-each select="$var4_test_resultof_node_name_equal_qname">
									<mglyph>
										<xsl:call-template name="tbf:tbf1_mglyph">
											<xsl:with-param name="input" select="." as="node()"/>
										</xsl:call-template>
									</mglyph>
								</xsl:for-each>
								<xsl:variable name="var5_test_resultof_node_name_equal_qname" as="node()?">
									<xsl:if test="fn:boolean(self::mathnl:malignmark)">
										<xsl:sequence select="."/>
									</xsl:if>
								</xsl:variable>
								<xsl:for-each select="$var5_test_resultof_node_name_equal_qname">
									<malignmark>
										<xsl:for-each select="@edge">
											<xsl:attribute name="edge" select="fn:string(.)"/>
										</xsl:for-each>
									</malignmark>
								</xsl:for-each>
							</xsl:for-each>
						</mn>
					</xsl:for-each>
					<xsl:for-each select="mathnl:mo">
						<mo>
							<xsl:for-each select="@xlink:href">
								<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
							</xsl:for-each>
							<xsl:for-each select="@class">
								<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
							</xsl:for-each>
							<xsl:for-each select="@style">
								<xsl:attribute name="style" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@id">
								<xsl:attribute name="id" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@xref">
								<xsl:attribute name="xref" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@mathvariant">
								<xsl:attribute name="mathvariant" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@mathsize">
								<xsl:attribute name="mathsize" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@mathcolor">
								<xsl:attribute name="mathcolor" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@mathbackground">
								<xsl:attribute name="mathbackground" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@form">
								<xsl:attribute name="form" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@fence">
								<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
							</xsl:for-each>
							<xsl:for-each select="@separator">
								<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
							</xsl:for-each>
							<xsl:for-each select="@lspace">
								<xsl:attribute name="lspace" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@rspace">
								<xsl:attribute name="rspace" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@stretchy">
								<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
							</xsl:for-each>
							<xsl:for-each select="@symmetric">
								<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
							</xsl:for-each>
							<xsl:for-each select="@maxsize">
								<xsl:attribute name="maxsize" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@minsize">
								<xsl:attribute name="minsize" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@largeop">
								<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
							</xsl:for-each>
							<xsl:for-each select="@movablelimits">
								<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
							</xsl:for-each>
							<xsl:for-each select="@accent">
								<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
							</xsl:for-each>
							<xsl:for-each select="node()">
								<xsl:if test="fn:boolean(self::text())">
									<xsl:sequence select="fn:string(.)"/>
								</xsl:if>
								<xsl:variable name="var6_test_resultof_node_name_equal_qname" as="node()?">
									<xsl:if test="fn:boolean(self::mathnl:mglyph)">
										<xsl:sequence select="."/>
									</xsl:if>
								</xsl:variable>
								<xsl:for-each select="$var6_test_resultof_node_name_equal_qname">
									<mglyph>
										<xsl:call-template name="tbf:tbf1_mglyph">
											<xsl:with-param name="input" select="." as="node()"/>
										</xsl:call-template>
									</mglyph>
								</xsl:for-each>
								<xsl:variable name="var7_test_resultof_node_name_equal_qname" as="node()?">
									<xsl:if test="fn:boolean(self::mathnl:malignmark)">
										<xsl:sequence select="."/>
									</xsl:if>
								</xsl:variable>
								<xsl:for-each select="$var7_test_resultof_node_name_equal_qname">
									<malignmark>
										<xsl:for-each select="@edge">
											<xsl:attribute name="edge" select="fn:string(.)"/>
										</xsl:for-each>
									</malignmark>
								</xsl:for-each>
							</xsl:for-each>
						</mo>
					</xsl:for-each>
					<xsl:for-each select="mathnl:mtext">
						<mtext>
							<xsl:for-each select="@xlink:href">
								<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
							</xsl:for-each>
							<xsl:for-each select="@class">
								<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
							</xsl:for-each>
							<xsl:for-each select="@style">
								<xsl:attribute name="style" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@id">
								<xsl:attribute name="id" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@xref">
								<xsl:attribute name="xref" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@mathvariant">
								<xsl:attribute name="mathvariant" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@mathsize">
								<xsl:attribute name="mathsize" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@mathcolor">
								<xsl:attribute name="mathcolor" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@mathbackground">
								<xsl:attribute name="mathbackground" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="node()">
								<xsl:if test="fn:boolean(self::text())">
									<xsl:sequence select="fn:string(.)"/>
								</xsl:if>
								<xsl:variable name="var8_test_resultof_node_name_equal_qname" as="node()?">
									<xsl:if test="fn:boolean(self::mathnl:mglyph)">
										<xsl:sequence select="."/>
									</xsl:if>
								</xsl:variable>
								<xsl:for-each select="$var8_test_resultof_node_name_equal_qname">
									<mglyph>
										<xsl:call-template name="tbf:tbf1_mglyph">
											<xsl:with-param name="input" select="." as="node()"/>
										</xsl:call-template>
									</mglyph>
								</xsl:for-each>
								<xsl:variable name="var9_test_resultof_node_name_equal_qname" as="node()?">
									<xsl:if test="fn:boolean(self::mathnl:malignmark)">
										<xsl:sequence select="."/>
									</xsl:if>
								</xsl:variable>
								<xsl:for-each select="$var9_test_resultof_node_name_equal_qname">
									<malignmark>
										<xsl:for-each select="@edge">
											<xsl:attribute name="edge" select="fn:string(.)"/>
										</xsl:for-each>
									</malignmark>
								</xsl:for-each>
							</xsl:for-each>
						</mtext>
					</xsl:for-each>
					<xsl:for-each select="mathnl:ms">
						<ms>
							<xsl:for-each select="@xlink:href">
								<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
							</xsl:for-each>
							<xsl:for-each select="@class">
								<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
							</xsl:for-each>
							<xsl:for-each select="@style">
								<xsl:attribute name="style" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@id">
								<xsl:attribute name="id" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@xref">
								<xsl:attribute name="xref" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@mathvariant">
								<xsl:attribute name="mathvariant" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@mathsize">
								<xsl:attribute name="mathsize" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@mathcolor">
								<xsl:attribute name="mathcolor" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@mathbackground">
								<xsl:attribute name="mathbackground" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@lquote">
								<xsl:attribute name="lquote" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@rquote">
								<xsl:attribute name="rquote" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="node()">
								<xsl:if test="fn:boolean(self::text())">
									<xsl:sequence select="fn:string(.)"/>
								</xsl:if>
								<xsl:variable name="var10_test_resultof_node_name_equal_qname" as="node()?">
									<xsl:if test="fn:boolean(self::mathnl:mglyph)">
										<xsl:sequence select="."/>
									</xsl:if>
								</xsl:variable>
								<xsl:for-each select="$var10_test_resultof_node_name_equal_qname">
									<mglyph>
										<xsl:call-template name="tbf:tbf1_mglyph">
											<xsl:with-param name="input" select="." as="node()"/>
										</xsl:call-template>
									</mglyph>
								</xsl:for-each>
								<xsl:variable name="var11_test_resultof_node_name_equal_qname" as="node()?">
									<xsl:if test="fn:boolean(self::mathnl:malignmark)">
										<xsl:sequence select="."/>
									</xsl:if>
								</xsl:variable>
								<xsl:for-each select="$var11_test_resultof_node_name_equal_qname">
									<malignmark>
										<xsl:for-each select="@edge">
											<xsl:attribute name="edge" select="fn:string(.)"/>
										</xsl:for-each>
									</malignmark>
								</xsl:for-each>
							</xsl:for-each>
						</ms>
					</xsl:for-each>
					<xsl:for-each select="mathnl:mrow">
						<mrow>
							<xsl:for-each select="@xlink:href">
								<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
							</xsl:for-each>
							<xsl:for-each select="@class">
								<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
							</xsl:for-each>
							<xsl:for-each select="@style">
								<xsl:attribute name="style" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@id">
								<xsl:attribute name="id" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="@xref">
								<xsl:attribute name="xref" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="mathnl:mi">
								<mi>
									<xsl:for-each select="@xlink:href">
										<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
									</xsl:for-each>
									<xsl:for-each select="@class">
										<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
									</xsl:for-each>
									<xsl:for-each select="@style">
										<xsl:attribute name="style" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@id">
										<xsl:attribute name="id" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@xref">
										<xsl:attribute name="xref" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@mathvariant">
										<xsl:attribute name="mathvariant" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@mathsize">
										<xsl:attribute name="mathsize" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@mathcolor">
										<xsl:attribute name="mathcolor" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@mathbackground">
										<xsl:attribute name="mathbackground" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="node()">
										<xsl:if test="fn:boolean(self::text())">
											<xsl:sequence select="fn:string(.)"/>
										</xsl:if>
										<xsl:variable name="var12_test_resultof_node_name_equal_qname" as="node()?">
											<xsl:if test="fn:boolean(self::mathnl:mglyph)">
												<xsl:sequence select="."/>
											</xsl:if>
										</xsl:variable>
										<xsl:for-each select="$var12_test_resultof_node_name_equal_qname">
											<mglyph>
												<xsl:call-template name="tbf:tbf1_mglyph">
													<xsl:with-param name="input" select="." as="node()"/>
												</xsl:call-template>
											</mglyph>
										</xsl:for-each>
										<xsl:variable name="var13_test_resultof_node_name_equal_qname" as="node()?">
											<xsl:if test="fn:boolean(self::mathnl:malignmark)">
												<xsl:sequence select="."/>
											</xsl:if>
										</xsl:variable>
										<xsl:for-each select="$var13_test_resultof_node_name_equal_qname">
											<malignmark>
												<xsl:for-each select="@edge">
													<xsl:attribute name="edge" select="fn:string(.)"/>
												</xsl:for-each>
											</malignmark>
										</xsl:for-each>
									</xsl:for-each>
								</mi>
							</xsl:for-each>
							<xsl:for-each select="mathnl:mn">
								<mn>
									<xsl:for-each select="@xlink:href">
										<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
									</xsl:for-each>
									<xsl:for-each select="@class">
										<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
									</xsl:for-each>
									<xsl:for-each select="@style">
										<xsl:attribute name="style" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@id">
										<xsl:attribute name="id" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@xref">
										<xsl:attribute name="xref" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@mathvariant">
										<xsl:attribute name="mathvariant" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@mathsize">
										<xsl:attribute name="mathsize" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@mathcolor">
										<xsl:attribute name="mathcolor" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@mathbackground">
										<xsl:attribute name="mathbackground" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="node()">
										<xsl:if test="fn:boolean(self::text())">
											<xsl:sequence select="fn:string(.)"/>
										</xsl:if>
										<xsl:variable name="var14_test_resultof_node_name_equal_qname" as="node()?">
											<xsl:if test="fn:boolean(self::mathnl:mglyph)">
												<xsl:sequence select="."/>
											</xsl:if>
										</xsl:variable>
										<xsl:for-each select="$var14_test_resultof_node_name_equal_qname">
											<mglyph>
												<xsl:call-template name="tbf:tbf1_mglyph">
													<xsl:with-param name="input" select="." as="node()"/>
												</xsl:call-template>
											</mglyph>
										</xsl:for-each>
										<xsl:variable name="var15_test_resultof_node_name_equal_qname" as="node()?">
											<xsl:if test="fn:boolean(self::mathnl:malignmark)">
												<xsl:sequence select="."/>
											</xsl:if>
										</xsl:variable>
										<xsl:for-each select="$var15_test_resultof_node_name_equal_qname">
											<malignmark>
												<xsl:for-each select="@edge">
													<xsl:attribute name="edge" select="fn:string(.)"/>
												</xsl:for-each>
											</malignmark>
										</xsl:for-each>
									</xsl:for-each>
								</mn>
							</xsl:for-each>
							<xsl:for-each select="mathnl:mo">
								<mo>
									<xsl:for-each select="@xlink:href">
										<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
									</xsl:for-each>
									<xsl:for-each select="@class">
										<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
									</xsl:for-each>
									<xsl:for-each select="@style">
										<xsl:attribute name="style" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@id">
										<xsl:attribute name="id" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@xref">
										<xsl:attribute name="xref" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@mathvariant">
										<xsl:attribute name="mathvariant" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@mathsize">
										<xsl:attribute name="mathsize" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@mathcolor">
										<xsl:attribute name="mathcolor" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@mathbackground">
										<xsl:attribute name="mathbackground" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@form">
										<xsl:attribute name="form" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@fence">
										<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
									</xsl:for-each>
									<xsl:for-each select="@separator">
										<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
									</xsl:for-each>
									<xsl:for-each select="@lspace">
										<xsl:attribute name="lspace" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@rspace">
										<xsl:attribute name="rspace" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@stretchy">
										<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
									</xsl:for-each>
									<xsl:for-each select="@symmetric">
										<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
									</xsl:for-each>
									<xsl:for-each select="@maxsize">
										<xsl:attribute name="maxsize" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@minsize">
										<xsl:attribute name="minsize" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@largeop">
										<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
									</xsl:for-each>
									<xsl:for-each select="@movablelimits">
										<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
									</xsl:for-each>
									<xsl:for-each select="@accent">
										<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
									</xsl:for-each>
									<xsl:for-each select="node()">
										<xsl:if test="fn:boolean(self::text())">
											<xsl:sequence select="fn:string(.)"/>
										</xsl:if>
										<xsl:variable name="var16_test_resultof_node_name_equal_qname" as="node()?">
											<xsl:if test="fn:boolean(self::mathnl:mglyph)">
												<xsl:sequence select="."/>
											</xsl:if>
										</xsl:variable>
										<xsl:for-each select="$var16_test_resultof_node_name_equal_qname">
											<mglyph>
												<xsl:call-template name="tbf:tbf1_mglyph">
													<xsl:with-param name="input" select="." as="node()"/>
												</xsl:call-template>
											</mglyph>
										</xsl:for-each>
										<xsl:variable name="var17_test_resultof_node_name_equal_qname" as="node()?">
											<xsl:if test="fn:boolean(self::mathnl:malignmark)">
												<xsl:sequence select="."/>
											</xsl:if>
										</xsl:variable>
										<xsl:for-each select="$var17_test_resultof_node_name_equal_qname">
											<malignmark>
												<xsl:for-each select="@edge">
													<xsl:attribute name="edge" select="fn:string(.)"/>
												</xsl:for-each>
											</malignmark>
										</xsl:for-each>
									</xsl:for-each>
								</mo>
							</xsl:for-each>
							<xsl:for-each select="mathnl:mtext">
								<mtext>
									<xsl:for-each select="@xlink:href">
										<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
									</xsl:for-each>
									<xsl:for-each select="@class">
										<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
									</xsl:for-each>
									<xsl:for-each select="@style">
										<xsl:attribute name="style" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@id">
										<xsl:attribute name="id" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@xref">
										<xsl:attribute name="xref" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@mathvariant">
										<xsl:attribute name="mathvariant" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@mathsize">
										<xsl:attribute name="mathsize" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@mathcolor">
										<xsl:attribute name="mathcolor" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@mathbackground">
										<xsl:attribute name="mathbackground" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="node()">
										<xsl:if test="fn:boolean(self::text())">
											<xsl:sequence select="fn:string(.)"/>
										</xsl:if>
										<xsl:variable name="var18_test_resultof_node_name_equal_qname" as="node()?">
											<xsl:if test="fn:boolean(self::mathnl:mglyph)">
												<xsl:sequence select="."/>
											</xsl:if>
										</xsl:variable>
										<xsl:for-each select="$var18_test_resultof_node_name_equal_qname">
											<mglyph>
												<xsl:call-template name="tbf:tbf1_mglyph">
													<xsl:with-param name="input" select="." as="node()"/>
												</xsl:call-template>
											</mglyph>
										</xsl:for-each>
										<xsl:variable name="var19_test_resultof_node_name_equal_qname" as="node()?">
											<xsl:if test="fn:boolean(self::mathnl:malignmark)">
												<xsl:sequence select="."/>
											</xsl:if>
										</xsl:variable>
										<xsl:for-each select="$var19_test_resultof_node_name_equal_qname">
											<malignmark>
												<xsl:for-each select="@edge">
													<xsl:attribute name="edge" select="fn:string(.)"/>
												</xsl:for-each>
											</malignmark>
										</xsl:for-each>
									</xsl:for-each>
								</mtext>
							</xsl:for-each>
							<xsl:for-each select="mathnl:ms">
								<ms>
									<xsl:for-each select="@xlink:href">
										<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
									</xsl:for-each>
									<xsl:for-each select="@class">
										<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
									</xsl:for-each>
									<xsl:for-each select="@style">
										<xsl:attribute name="style" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@id">
										<xsl:attribute name="id" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@xref">
										<xsl:attribute name="xref" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@mathvariant">
										<xsl:attribute name="mathvariant" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@mathsize">
										<xsl:attribute name="mathsize" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@mathcolor">
										<xsl:attribute name="mathcolor" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@mathbackground">
										<xsl:attribute name="mathbackground" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@lquote">
										<xsl:attribute name="lquote" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@rquote">
										<xsl:attribute name="rquote" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="node()">
										<xsl:if test="fn:boolean(self::text())">
											<xsl:sequence select="fn:string(.)"/>
										</xsl:if>
										<xsl:variable name="var20_test_resultof_node_name_equal_qname" as="node()?">
											<xsl:if test="fn:boolean(self::mathnl:mglyph)">
												<xsl:sequence select="."/>
											</xsl:if>
										</xsl:variable>
										<xsl:for-each select="$var20_test_resultof_node_name_equal_qname">
											<mglyph>
												<xsl:call-template name="tbf:tbf1_mglyph">
													<xsl:with-param name="input" select="." as="node()"/>
												</xsl:call-template>
											</mglyph>
										</xsl:for-each>
										<xsl:variable name="var21_test_resultof_node_name_equal_qname" as="node()?">
											<xsl:if test="fn:boolean(self::mathnl:malignmark)">
												<xsl:sequence select="."/>
											</xsl:if>
										</xsl:variable>
										<xsl:for-each select="$var21_test_resultof_node_name_equal_qname">
											<malignmark>
												<xsl:for-each select="@edge">
													<xsl:attribute name="edge" select="fn:string(.)"/>
												</xsl:for-each>
											</malignmark>
										</xsl:for-each>
									</xsl:for-each>
								</ms>
							</xsl:for-each>
							<xsl:for-each select="mathnl:mrow">
								<mrow>
									<xsl:sequence select="()"/>
								</mrow>
							</xsl:for-each>
							<xsl:for-each select="mathnl:mfrac">
								<mfrac>
									<xsl:for-each select="@xlink:href">
										<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
									</xsl:for-each>
									<xsl:for-each select="@class">
										<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
									</xsl:for-each>
									<xsl:for-each select="@style">
										<xsl:attribute name="style" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@id">
										<xsl:attribute name="id" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@xref">
										<xsl:attribute name="xref" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@bevelled">
										<xsl:attribute name="bevelled" select="xs:string(xs:boolean(fn:string(.)))"/>
									</xsl:for-each>
									<xsl:for-each select="@numalign">
										<xsl:attribute name="numalign" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@denomalign">
										<xsl:attribute name="denomalign" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="@linethickness">
										<xsl:attribute name="linethickness" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:for-each select="mathnl:mi">
										<mi>
											<xsl:for-each select="@xlink:href">
												<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
											</xsl:for-each>
											<xsl:for-each select="@class">
												<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
											</xsl:for-each>
											<xsl:for-each select="@style">
												<xsl:attribute name="style" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@id">
												<xsl:attribute name="id" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@xref">
												<xsl:attribute name="xref" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@mathvariant">
												<xsl:attribute name="mathvariant" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@mathsize">
												<xsl:attribute name="mathsize" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@mathcolor">
												<xsl:attribute name="mathcolor" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@mathbackground">
												<xsl:attribute name="mathbackground" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="node()">
												<xsl:if test="fn:boolean(self::text())">
													<xsl:sequence select="fn:string(.)"/>
												</xsl:if>
												<xsl:variable name="var22_test_resultof_node_name_equal_qname" as="node()?">
													<xsl:if test="fn:boolean(self::mathnl:mglyph)">
														<xsl:sequence select="."/>
													</xsl:if>
												</xsl:variable>
												<xsl:for-each select="$var22_test_resultof_node_name_equal_qname">
													<mglyph>
														<xsl:call-template name="tbf:tbf1_mglyph">
															<xsl:with-param name="input" select="." as="node()"/>
														</xsl:call-template>
													</mglyph>
												</xsl:for-each>
												<xsl:variable name="var23_test_resultof_node_name_equal_qname" as="node()?">
													<xsl:if test="fn:boolean(self::mathnl:malignmark)">
														<xsl:sequence select="."/>
													</xsl:if>
												</xsl:variable>
												<xsl:for-each select="$var23_test_resultof_node_name_equal_qname">
													<malignmark>
														<xsl:for-each select="@edge">
															<xsl:attribute name="edge" select="fn:string(.)"/>
														</xsl:for-each>
													</malignmark>
												</xsl:for-each>
											</xsl:for-each>
										</mi>
									</xsl:for-each>
									<xsl:for-each select="mathnl:mn">
										<mn>
											<xsl:for-each select="@xlink:href">
												<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
											</xsl:for-each>
											<xsl:for-each select="@class">
												<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
											</xsl:for-each>
											<xsl:for-each select="@style">
												<xsl:attribute name="style" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@id">
												<xsl:attribute name="id" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@xref">
												<xsl:attribute name="xref" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@mathvariant">
												<xsl:attribute name="mathvariant" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@mathsize">
												<xsl:attribute name="mathsize" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@mathcolor">
												<xsl:attribute name="mathcolor" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@mathbackground">
												<xsl:attribute name="mathbackground" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="node()">
												<xsl:if test="fn:boolean(self::text())">
													<xsl:sequence select="fn:string(.)"/>
												</xsl:if>
												<xsl:variable name="var24_test_resultof_node_name_equal_qname" as="node()?">
													<xsl:if test="fn:boolean(self::mathnl:mglyph)">
														<xsl:sequence select="."/>
													</xsl:if>
												</xsl:variable>
												<xsl:for-each select="$var24_test_resultof_node_name_equal_qname">
													<mglyph>
														<xsl:call-template name="tbf:tbf1_mglyph">
															<xsl:with-param name="input" select="." as="node()"/>
														</xsl:call-template>
													</mglyph>
												</xsl:for-each>
												<xsl:variable name="var25_test_resultof_node_name_equal_qname" as="node()?">
													<xsl:if test="fn:boolean(self::mathnl:malignmark)">
														<xsl:sequence select="."/>
													</xsl:if>
												</xsl:variable>
												<xsl:for-each select="$var25_test_resultof_node_name_equal_qname">
													<malignmark>
														<xsl:for-each select="@edge">
															<xsl:attribute name="edge" select="fn:string(.)"/>
														</xsl:for-each>
													</malignmark>
												</xsl:for-each>
											</xsl:for-each>
										</mn>
									</xsl:for-each>
									<xsl:for-each select="mathnl:mo">
										<mo>
											<xsl:for-each select="@xlink:href">
												<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
											</xsl:for-each>
											<xsl:for-each select="@class">
												<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
											</xsl:for-each>
											<xsl:for-each select="@style">
												<xsl:attribute name="style" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@id">
												<xsl:attribute name="id" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@xref">
												<xsl:attribute name="xref" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@mathvariant">
												<xsl:attribute name="mathvariant" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@mathsize">
												<xsl:attribute name="mathsize" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@mathcolor">
												<xsl:attribute name="mathcolor" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@mathbackground">
												<xsl:attribute name="mathbackground" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@form">
												<xsl:attribute name="form" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@fence">
												<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
											</xsl:for-each>
											<xsl:for-each select="@separator">
												<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
											</xsl:for-each>
											<xsl:for-each select="@lspace">
												<xsl:attribute name="lspace" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@rspace">
												<xsl:attribute name="rspace" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@stretchy">
												<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
											</xsl:for-each>
											<xsl:for-each select="@symmetric">
												<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
											</xsl:for-each>
											<xsl:for-each select="@maxsize">
												<xsl:attribute name="maxsize" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@minsize">
												<xsl:attribute name="minsize" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@largeop">
												<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
											</xsl:for-each>
											<xsl:for-each select="@movablelimits">
												<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
											</xsl:for-each>
											<xsl:for-each select="@accent">
												<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
											</xsl:for-each>
											<xsl:for-each select="node()">
												<xsl:if test="fn:boolean(self::text())">
													<xsl:sequence select="fn:string(.)"/>
												</xsl:if>
												<xsl:variable name="var26_test_resultof_node_name_equal_qname" as="node()?">
													<xsl:if test="fn:boolean(self::mathnl:mglyph)">
														<xsl:sequence select="."/>
													</xsl:if>
												</xsl:variable>
												<xsl:for-each select="$var26_test_resultof_node_name_equal_qname">
													<mglyph>
														<xsl:call-template name="tbf:tbf1_mglyph">
															<xsl:with-param name="input" select="." as="node()"/>
														</xsl:call-template>
													</mglyph>
												</xsl:for-each>
												<xsl:variable name="var27_test_resultof_node_name_equal_qname" as="node()?">
													<xsl:if test="fn:boolean(self::mathnl:malignmark)">
														<xsl:sequence select="."/>
													</xsl:if>
												</xsl:variable>
												<xsl:for-each select="$var27_test_resultof_node_name_equal_qname">
													<malignmark>
														<xsl:for-each select="@edge">
															<xsl:attribute name="edge" select="fn:string(.)"/>
														</xsl:for-each>
													</malignmark>
												</xsl:for-each>
											</xsl:for-each>
										</mo>
									</xsl:for-each>
									<xsl:for-each select="mathnl:mtext">
										<mtext>
											<xsl:for-each select="@xlink:href">
												<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
											</xsl:for-each>
											<xsl:for-each select="@class">
												<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
											</xsl:for-each>
											<xsl:for-each select="@style">
												<xsl:attribute name="style" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@id">
												<xsl:attribute name="id" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@xref">
												<xsl:attribute name="xref" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@mathvariant">
												<xsl:attribute name="mathvariant" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@mathsize">
												<xsl:attribute name="mathsize" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@mathcolor">
												<xsl:attribute name="mathcolor" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@mathbackground">
												<xsl:attribute name="mathbackground" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="node()">
												<xsl:if test="fn:boolean(self::text())">
													<xsl:sequence select="fn:string(.)"/>
												</xsl:if>
												<xsl:variable name="var28_test_resultof_node_name_equal_qname" as="node()?">
													<xsl:if test="fn:boolean(self::mathnl:mglyph)">
														<xsl:sequence select="."/>
													</xsl:if>
												</xsl:variable>
												<xsl:for-each select="$var28_test_resultof_node_name_equal_qname">
													<mglyph>
														<xsl:call-template name="tbf:tbf1_mglyph">
															<xsl:with-param name="input" select="." as="node()"/>
														</xsl:call-template>
													</mglyph>
												</xsl:for-each>
												<xsl:variable name="var29_test_resultof_node_name_equal_qname" as="node()?">
													<xsl:if test="fn:boolean(self::mathnl:malignmark)">
														<xsl:sequence select="."/>
													</xsl:if>
												</xsl:variable>
												<xsl:for-each select="$var29_test_resultof_node_name_equal_qname">
													<malignmark>
														<xsl:for-each select="@edge">
															<xsl:attribute name="edge" select="fn:string(.)"/>
														</xsl:for-each>
													</malignmark>
												</xsl:for-each>
											</xsl:for-each>
										</mtext>
									</xsl:for-each>
									<xsl:for-each select="mathnl:ms">
										<ms>
											<xsl:for-each select="@xlink:href">
												<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
											</xsl:for-each>
											<xsl:for-each select="@class">
												<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
											</xsl:for-each>
											<xsl:for-each select="@style">
												<xsl:attribute name="style" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@id">
												<xsl:attribute name="id" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@xref">
												<xsl:attribute name="xref" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@mathvariant">
												<xsl:attribute name="mathvariant" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@mathsize">
												<xsl:attribute name="mathsize" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@mathcolor">
												<xsl:attribute name="mathcolor" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@mathbackground">
												<xsl:attribute name="mathbackground" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@lquote">
												<xsl:attribute name="lquote" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@rquote">
												<xsl:attribute name="rquote" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="node()">
												<xsl:if test="fn:boolean(self::text())">
													<xsl:sequence select="fn:string(.)"/>
												</xsl:if>
												<xsl:variable name="var30_test_resultof_node_name_equal_qname" as="node()?">
													<xsl:if test="fn:boolean(self::mathnl:mglyph)">
														<xsl:sequence select="."/>
													</xsl:if>
												</xsl:variable>
												<xsl:for-each select="$var30_test_resultof_node_name_equal_qname">
													<mglyph>
														<xsl:call-template name="tbf:tbf1_mglyph">
															<xsl:with-param name="input" select="." as="node()"/>
														</xsl:call-template>
													</mglyph>
												</xsl:for-each>
												<xsl:variable name="var31_test_resultof_node_name_equal_qname" as="node()?">
													<xsl:if test="fn:boolean(self::mathnl:malignmark)">
														<xsl:sequence select="."/>
													</xsl:if>
												</xsl:variable>
												<xsl:for-each select="$var31_test_resultof_node_name_equal_qname">
													<malignmark>
														<xsl:for-each select="@edge">
															<xsl:attribute name="edge" select="fn:string(.)"/>
														</xsl:for-each>
													</malignmark>
												</xsl:for-each>
											</xsl:for-each>
										</ms>
									</xsl:for-each>
									<xsl:for-each select="mathnl:mrow">
										<mrow>
											<xsl:sequence select="()"/>
										</mrow>
									</xsl:for-each>
									<xsl:for-each select="mathnl:mfrac">
										<mfrac>
											<xsl:sequence select="()"/>
										</mfrac>
									</xsl:for-each>
									<xsl:for-each select="mathnl:msqrt">
										<msqrt>
											<xsl:for-each select="@xlink:href">
												<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
											</xsl:for-each>
											<xsl:for-each select="@class">
												<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
											</xsl:for-each>
											<xsl:for-each select="@style">
												<xsl:attribute name="style" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@id">
												<xsl:attribute name="id" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="@xref">
												<xsl:attribute name="xref" select="fn:string(.)"/>
											</xsl:for-each>
											<xsl:for-each select="mathnl:mi">
												<mi>
													<xsl:for-each select="@xlink:href">
														<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
													</xsl:for-each>
													<xsl:for-each select="@class">
														<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
													</xsl:for-each>
													<xsl:for-each select="@style">
														<xsl:attribute name="style" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@id">
														<xsl:attribute name="id" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@xref">
														<xsl:attribute name="xref" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@mathvariant">
														<xsl:attribute name="mathvariant" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@mathsize">
														<xsl:attribute name="mathsize" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@mathcolor">
														<xsl:attribute name="mathcolor" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@mathbackground">
														<xsl:attribute name="mathbackground" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="node()">
														<xsl:if test="fn:boolean(self::text())">
															<xsl:sequence select="fn:string(.)"/>
														</xsl:if>
														<xsl:variable name="var32_test_resultof_node_name_equal_qname" as="node()?">
															<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																<xsl:sequence select="."/>
															</xsl:if>
														</xsl:variable>
														<xsl:for-each select="$var32_test_resultof_node_name_equal_qname">
															<mglyph>
																<xsl:call-template name="tbf:tbf1_mglyph">
																	<xsl:with-param name="input" select="." as="node()"/>
																</xsl:call-template>
															</mglyph>
														</xsl:for-each>
														<xsl:variable name="var33_test_resultof_node_name_equal_qname" as="node()?">
															<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																<xsl:sequence select="."/>
															</xsl:if>
														</xsl:variable>
														<xsl:for-each select="$var33_test_resultof_node_name_equal_qname">
															<malignmark>
																<xsl:for-each select="@edge">
																	<xsl:attribute name="edge" select="fn:string(.)"/>
																</xsl:for-each>
															</malignmark>
														</xsl:for-each>
													</xsl:for-each>
												</mi>
											</xsl:for-each>
											<xsl:for-each select="mathnl:mn">
												<mn>
													<xsl:for-each select="@xlink:href">
														<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
													</xsl:for-each>
													<xsl:for-each select="@class">
														<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
													</xsl:for-each>
													<xsl:for-each select="@style">
														<xsl:attribute name="style" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@id">
														<xsl:attribute name="id" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@xref">
														<xsl:attribute name="xref" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@mathvariant">
														<xsl:attribute name="mathvariant" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@mathsize">
														<xsl:attribute name="mathsize" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@mathcolor">
														<xsl:attribute name="mathcolor" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@mathbackground">
														<xsl:attribute name="mathbackground" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="node()">
														<xsl:if test="fn:boolean(self::text())">
															<xsl:sequence select="fn:string(.)"/>
														</xsl:if>
														<xsl:variable name="var34_test_resultof_node_name_equal_qname" as="node()?">
															<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																<xsl:sequence select="."/>
															</xsl:if>
														</xsl:variable>
														<xsl:for-each select="$var34_test_resultof_node_name_equal_qname">
															<mglyph>
																<xsl:call-template name="tbf:tbf1_mglyph">
																	<xsl:with-param name="input" select="." as="node()"/>
																</xsl:call-template>
															</mglyph>
														</xsl:for-each>
														<xsl:variable name="var35_test_resultof_node_name_equal_qname" as="node()?">
															<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																<xsl:sequence select="."/>
															</xsl:if>
														</xsl:variable>
														<xsl:for-each select="$var35_test_resultof_node_name_equal_qname">
															<malignmark>
																<xsl:for-each select="@edge">
																	<xsl:attribute name="edge" select="fn:string(.)"/>
																</xsl:for-each>
															</malignmark>
														</xsl:for-each>
													</xsl:for-each>
												</mn>
											</xsl:for-each>
											<xsl:for-each select="mathnl:mo">
												<mo>
													<xsl:for-each select="@xlink:href">
														<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
													</xsl:for-each>
													<xsl:for-each select="@class">
														<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
													</xsl:for-each>
													<xsl:for-each select="@style">
														<xsl:attribute name="style" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@id">
														<xsl:attribute name="id" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@xref">
														<xsl:attribute name="xref" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@mathvariant">
														<xsl:attribute name="mathvariant" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@mathsize">
														<xsl:attribute name="mathsize" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@mathcolor">
														<xsl:attribute name="mathcolor" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@mathbackground">
														<xsl:attribute name="mathbackground" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@form">
														<xsl:attribute name="form" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@fence">
														<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
													</xsl:for-each>
													<xsl:for-each select="@separator">
														<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
													</xsl:for-each>
													<xsl:for-each select="@lspace">
														<xsl:attribute name="lspace" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@rspace">
														<xsl:attribute name="rspace" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@stretchy">
														<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
													</xsl:for-each>
													<xsl:for-each select="@symmetric">
														<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
													</xsl:for-each>
													<xsl:for-each select="@maxsize">
														<xsl:attribute name="maxsize" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@minsize">
														<xsl:attribute name="minsize" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@largeop">
														<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
													</xsl:for-each>
													<xsl:for-each select="@movablelimits">
														<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
													</xsl:for-each>
													<xsl:for-each select="@accent">
														<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
													</xsl:for-each>
													<xsl:for-each select="node()">
														<xsl:if test="fn:boolean(self::text())">
															<xsl:sequence select="fn:string(.)"/>
														</xsl:if>
														<xsl:variable name="var36_test_resultof_node_name_equal_qname" as="node()?">
															<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																<xsl:sequence select="."/>
															</xsl:if>
														</xsl:variable>
														<xsl:for-each select="$var36_test_resultof_node_name_equal_qname">
															<mglyph>
																<xsl:call-template name="tbf:tbf1_mglyph">
																	<xsl:with-param name="input" select="." as="node()"/>
																</xsl:call-template>
															</mglyph>
														</xsl:for-each>
														<xsl:variable name="var37_test_resultof_node_name_equal_qname" as="node()?">
															<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																<xsl:sequence select="."/>
															</xsl:if>
														</xsl:variable>
														<xsl:for-each select="$var37_test_resultof_node_name_equal_qname">
															<malignmark>
																<xsl:for-each select="@edge">
																	<xsl:attribute name="edge" select="fn:string(.)"/>
																</xsl:for-each>
															</malignmark>
														</xsl:for-each>
													</xsl:for-each>
												</mo>
											</xsl:for-each>
											<xsl:for-each select="mathnl:mtext">
												<mtext>
													<xsl:for-each select="@xlink:href">
														<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
													</xsl:for-each>
													<xsl:for-each select="@class">
														<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
													</xsl:for-each>
													<xsl:for-each select="@style">
														<xsl:attribute name="style" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@id">
														<xsl:attribute name="id" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@xref">
														<xsl:attribute name="xref" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@mathvariant">
														<xsl:attribute name="mathvariant" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@mathsize">
														<xsl:attribute name="mathsize" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@mathcolor">
														<xsl:attribute name="mathcolor" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@mathbackground">
														<xsl:attribute name="mathbackground" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="node()">
														<xsl:if test="fn:boolean(self::text())">
															<xsl:sequence select="fn:string(.)"/>
														</xsl:if>
														<xsl:variable name="var38_test_resultof_node_name_equal_qname" as="node()?">
															<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																<xsl:sequence select="."/>
															</xsl:if>
														</xsl:variable>
														<xsl:for-each select="$var38_test_resultof_node_name_equal_qname">
															<mglyph>
																<xsl:call-template name="tbf:tbf1_mglyph">
																	<xsl:with-param name="input" select="." as="node()"/>
																</xsl:call-template>
															</mglyph>
														</xsl:for-each>
														<xsl:variable name="var39_test_resultof_node_name_equal_qname" as="node()?">
															<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																<xsl:sequence select="."/>
															</xsl:if>
														</xsl:variable>
														<xsl:for-each select="$var39_test_resultof_node_name_equal_qname">
															<malignmark>
																<xsl:for-each select="@edge">
																	<xsl:attribute name="edge" select="fn:string(.)"/>
																</xsl:for-each>
															</malignmark>
														</xsl:for-each>
													</xsl:for-each>
												</mtext>
											</xsl:for-each>
											<xsl:for-each select="mathnl:ms">
												<ms>
													<xsl:for-each select="@xlink:href">
														<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
													</xsl:for-each>
													<xsl:for-each select="@class">
														<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
													</xsl:for-each>
													<xsl:for-each select="@style">
														<xsl:attribute name="style" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@id">
														<xsl:attribute name="id" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@xref">
														<xsl:attribute name="xref" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@mathvariant">
														<xsl:attribute name="mathvariant" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@mathsize">
														<xsl:attribute name="mathsize" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@mathcolor">
														<xsl:attribute name="mathcolor" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@mathbackground">
														<xsl:attribute name="mathbackground" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@lquote">
														<xsl:attribute name="lquote" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@rquote">
														<xsl:attribute name="rquote" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="node()">
														<xsl:if test="fn:boolean(self::text())">
															<xsl:sequence select="fn:string(.)"/>
														</xsl:if>
														<xsl:variable name="var40_test_resultof_node_name_equal_qname" as="node()?">
															<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																<xsl:sequence select="."/>
															</xsl:if>
														</xsl:variable>
														<xsl:for-each select="$var40_test_resultof_node_name_equal_qname">
															<mglyph>
																<xsl:call-template name="tbf:tbf1_mglyph">
																	<xsl:with-param name="input" select="." as="node()"/>
																</xsl:call-template>
															</mglyph>
														</xsl:for-each>
														<xsl:variable name="var41_test_resultof_node_name_equal_qname" as="node()?">
															<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																<xsl:sequence select="."/>
															</xsl:if>
														</xsl:variable>
														<xsl:for-each select="$var41_test_resultof_node_name_equal_qname">
															<malignmark>
																<xsl:for-each select="@edge">
																	<xsl:attribute name="edge" select="fn:string(.)"/>
																</xsl:for-each>
															</malignmark>
														</xsl:for-each>
													</xsl:for-each>
												</ms>
											</xsl:for-each>
											<xsl:for-each select="mathnl:mrow">
												<mrow>
													<xsl:sequence select="()"/>
												</mrow>
											</xsl:for-each>
											<xsl:for-each select="mathnl:mfrac">
												<mfrac>
													<xsl:sequence select="()"/>
												</mfrac>
											</xsl:for-each>
											<xsl:for-each select="mathnl:msqrt">
												<msqrt>
													<xsl:sequence select="()"/>
												</msqrt>
											</xsl:for-each>
											<xsl:for-each select="mathnl:mroot">
												<mroot>
													<xsl:for-each select="@xlink:href">
														<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
													</xsl:for-each>
													<xsl:for-each select="@class">
														<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
													</xsl:for-each>
													<xsl:for-each select="@style">
														<xsl:attribute name="style" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@id">
														<xsl:attribute name="id" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="@xref">
														<xsl:attribute name="xref" select="fn:string(.)"/>
													</xsl:for-each>
													<xsl:for-each select="mathnl:mi">
														<mi>
															<xsl:for-each select="@xlink:href">
																<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
															</xsl:for-each>
															<xsl:for-each select="@class">
																<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
															</xsl:for-each>
															<xsl:for-each select="@style">
																<xsl:attribute name="style" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@id">
																<xsl:attribute name="id" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@xref">
																<xsl:attribute name="xref" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@mathvariant">
																<xsl:attribute name="mathvariant" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@mathsize">
																<xsl:attribute name="mathsize" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@mathcolor">
																<xsl:attribute name="mathcolor" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@mathbackground">
																<xsl:attribute name="mathbackground" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="node()">
																<xsl:if test="fn:boolean(self::text())">
																	<xsl:sequence select="fn:string(.)"/>
																</xsl:if>
																<xsl:variable name="var42_test_resultof_node_name_equal_qname" as="node()?">
																	<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																		<xsl:sequence select="."/>
																	</xsl:if>
																</xsl:variable>
																<xsl:for-each select="$var42_test_resultof_node_name_equal_qname">
																	<mglyph>
																		<xsl:call-template name="tbf:tbf1_mglyph">
																			<xsl:with-param name="input" select="." as="node()"/>
																		</xsl:call-template>
																	</mglyph>
																</xsl:for-each>
																<xsl:variable name="var43_test_resultof_node_name_equal_qname" as="node()?">
																	<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																		<xsl:sequence select="."/>
																	</xsl:if>
																</xsl:variable>
																<xsl:for-each select="$var43_test_resultof_node_name_equal_qname">
																	<malignmark>
																		<xsl:for-each select="@edge">
																			<xsl:attribute name="edge" select="fn:string(.)"/>
																		</xsl:for-each>
																	</malignmark>
																</xsl:for-each>
															</xsl:for-each>
														</mi>
													</xsl:for-each>
													<xsl:for-each select="mathnl:mn">
														<mn>
															<xsl:for-each select="@xlink:href">
																<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
															</xsl:for-each>
															<xsl:for-each select="@class">
																<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
															</xsl:for-each>
															<xsl:for-each select="@style">
																<xsl:attribute name="style" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@id">
																<xsl:attribute name="id" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@xref">
																<xsl:attribute name="xref" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@mathvariant">
																<xsl:attribute name="mathvariant" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@mathsize">
																<xsl:attribute name="mathsize" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@mathcolor">
																<xsl:attribute name="mathcolor" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@mathbackground">
																<xsl:attribute name="mathbackground" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="node()">
																<xsl:if test="fn:boolean(self::text())">
																	<xsl:sequence select="fn:string(.)"/>
																</xsl:if>
																<xsl:variable name="var44_test_resultof_node_name_equal_qname" as="node()?">
																	<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																		<xsl:sequence select="."/>
																	</xsl:if>
																</xsl:variable>
																<xsl:for-each select="$var44_test_resultof_node_name_equal_qname">
																	<mglyph>
																		<xsl:call-template name="tbf:tbf1_mglyph">
																			<xsl:with-param name="input" select="." as="node()"/>
																		</xsl:call-template>
																	</mglyph>
																</xsl:for-each>
																<xsl:variable name="var45_test_resultof_node_name_equal_qname" as="node()?">
																	<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																		<xsl:sequence select="."/>
																	</xsl:if>
																</xsl:variable>
																<xsl:for-each select="$var45_test_resultof_node_name_equal_qname">
																	<malignmark>
																		<xsl:for-each select="@edge">
																			<xsl:attribute name="edge" select="fn:string(.)"/>
																		</xsl:for-each>
																	</malignmark>
																</xsl:for-each>
															</xsl:for-each>
														</mn>
													</xsl:for-each>
													<xsl:for-each select="mathnl:mo">
														<mo>
															<xsl:for-each select="@xlink:href">
																<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
															</xsl:for-each>
															<xsl:for-each select="@class">
																<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
															</xsl:for-each>
															<xsl:for-each select="@style">
																<xsl:attribute name="style" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@id">
																<xsl:attribute name="id" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@xref">
																<xsl:attribute name="xref" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@mathvariant">
																<xsl:attribute name="mathvariant" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@mathsize">
																<xsl:attribute name="mathsize" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@mathcolor">
																<xsl:attribute name="mathcolor" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@mathbackground">
																<xsl:attribute name="mathbackground" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@form">
																<xsl:attribute name="form" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@fence">
																<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
															</xsl:for-each>
															<xsl:for-each select="@separator">
																<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
															</xsl:for-each>
															<xsl:for-each select="@lspace">
																<xsl:attribute name="lspace" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@rspace">
																<xsl:attribute name="rspace" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@stretchy">
																<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
															</xsl:for-each>
															<xsl:for-each select="@symmetric">
																<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
															</xsl:for-each>
															<xsl:for-each select="@maxsize">
																<xsl:attribute name="maxsize" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@minsize">
																<xsl:attribute name="minsize" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@largeop">
																<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
															</xsl:for-each>
															<xsl:for-each select="@movablelimits">
																<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
															</xsl:for-each>
															<xsl:for-each select="@accent">
																<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
															</xsl:for-each>
															<xsl:for-each select="node()">
																<xsl:if test="fn:boolean(self::text())">
																	<xsl:sequence select="fn:string(.)"/>
																</xsl:if>
																<xsl:variable name="var46_test_resultof_node_name_equal_qname" as="node()?">
																	<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																		<xsl:sequence select="."/>
																	</xsl:if>
																</xsl:variable>
																<xsl:for-each select="$var46_test_resultof_node_name_equal_qname">
																	<mglyph>
																		<xsl:call-template name="tbf:tbf1_mglyph">
																			<xsl:with-param name="input" select="." as="node()"/>
																		</xsl:call-template>
																	</mglyph>
																</xsl:for-each>
																<xsl:variable name="var47_test_resultof_node_name_equal_qname" as="node()?">
																	<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																		<xsl:sequence select="."/>
																	</xsl:if>
																</xsl:variable>
																<xsl:for-each select="$var47_test_resultof_node_name_equal_qname">
																	<malignmark>
																		<xsl:for-each select="@edge">
																			<xsl:attribute name="edge" select="fn:string(.)"/>
																		</xsl:for-each>
																	</malignmark>
																</xsl:for-each>
															</xsl:for-each>
														</mo>
													</xsl:for-each>
													<xsl:for-each select="mathnl:mtext">
														<mtext>
															<xsl:for-each select="@xlink:href">
																<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
															</xsl:for-each>
															<xsl:for-each select="@class">
																<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
															</xsl:for-each>
															<xsl:for-each select="@style">
																<xsl:attribute name="style" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@id">
																<xsl:attribute name="id" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@xref">
																<xsl:attribute name="xref" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@mathvariant">
																<xsl:attribute name="mathvariant" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@mathsize">
																<xsl:attribute name="mathsize" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@mathcolor">
																<xsl:attribute name="mathcolor" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@mathbackground">
																<xsl:attribute name="mathbackground" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="node()">
																<xsl:if test="fn:boolean(self::text())">
																	<xsl:sequence select="fn:string(.)"/>
																</xsl:if>
																<xsl:variable name="var48_test_resultof_node_name_equal_qname" as="node()?">
																	<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																		<xsl:sequence select="."/>
																	</xsl:if>
																</xsl:variable>
																<xsl:for-each select="$var48_test_resultof_node_name_equal_qname">
																	<mglyph>
																		<xsl:call-template name="tbf:tbf1_mglyph">
																			<xsl:with-param name="input" select="." as="node()"/>
																		</xsl:call-template>
																	</mglyph>
																</xsl:for-each>
																<xsl:variable name="var49_test_resultof_node_name_equal_qname" as="node()?">
																	<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																		<xsl:sequence select="."/>
																	</xsl:if>
																</xsl:variable>
																<xsl:for-each select="$var49_test_resultof_node_name_equal_qname">
																	<malignmark>
																		<xsl:for-each select="@edge">
																			<xsl:attribute name="edge" select="fn:string(.)"/>
																		</xsl:for-each>
																	</malignmark>
																</xsl:for-each>
															</xsl:for-each>
														</mtext>
													</xsl:for-each>
													<xsl:for-each select="mathnl:ms">
														<ms>
															<xsl:for-each select="@xlink:href">
																<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
															</xsl:for-each>
															<xsl:for-each select="@class">
																<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
															</xsl:for-each>
															<xsl:for-each select="@style">
																<xsl:attribute name="style" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@id">
																<xsl:attribute name="id" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@xref">
																<xsl:attribute name="xref" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@mathvariant">
																<xsl:attribute name="mathvariant" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@mathsize">
																<xsl:attribute name="mathsize" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@mathcolor">
																<xsl:attribute name="mathcolor" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@mathbackground">
																<xsl:attribute name="mathbackground" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@lquote">
																<xsl:attribute name="lquote" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@rquote">
																<xsl:attribute name="rquote" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="node()">
																<xsl:if test="fn:boolean(self::text())">
																	<xsl:sequence select="fn:string(.)"/>
																</xsl:if>
																<xsl:variable name="var50_test_resultof_node_name_equal_qname" as="node()?">
																	<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																		<xsl:sequence select="."/>
																	</xsl:if>
																</xsl:variable>
																<xsl:for-each select="$var50_test_resultof_node_name_equal_qname">
																	<mglyph>
																		<xsl:call-template name="tbf:tbf1_mglyph">
																			<xsl:with-param name="input" select="." as="node()"/>
																		</xsl:call-template>
																	</mglyph>
																</xsl:for-each>
																<xsl:variable name="var51_test_resultof_node_name_equal_qname" as="node()?">
																	<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																		<xsl:sequence select="."/>
																	</xsl:if>
																</xsl:variable>
																<xsl:for-each select="$var51_test_resultof_node_name_equal_qname">
																	<malignmark>
																		<xsl:for-each select="@edge">
																			<xsl:attribute name="edge" select="fn:string(.)"/>
																		</xsl:for-each>
																	</malignmark>
																</xsl:for-each>
															</xsl:for-each>
														</ms>
													</xsl:for-each>
													<xsl:for-each select="mathnl:mrow">
														<mrow>
															<xsl:sequence select="()"/>
														</mrow>
													</xsl:for-each>
													<xsl:for-each select="mathnl:mfrac">
														<mfrac>
															<xsl:sequence select="()"/>
														</mfrac>
													</xsl:for-each>
													<xsl:for-each select="mathnl:msqrt">
														<msqrt>
															<xsl:sequence select="()"/>
														</msqrt>
													</xsl:for-each>
													<xsl:for-each select="mathnl:mroot">
														<mroot>
															<xsl:sequence select="()"/>
														</mroot>
													</xsl:for-each>
													<xsl:for-each select="mathnl:mpadded">
														<mpadded>
															<xsl:for-each select="@xlink:href">
																<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
															</xsl:for-each>
															<xsl:for-each select="@class">
																<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
															</xsl:for-each>
															<xsl:for-each select="@style">
																<xsl:attribute name="style" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@id">
																<xsl:attribute name="id" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@xref">
																<xsl:attribute name="xref" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@width">
																<xsl:attribute name="width" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@height">
																<xsl:attribute name="height" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@depth">
																<xsl:attribute name="depth" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="@lspace">
																<xsl:attribute name="lspace" select="fn:string(.)"/>
															</xsl:for-each>
															<xsl:for-each select="mathnl:mi">
																<mi>
																	<xsl:for-each select="@xlink:href">
																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																	</xsl:for-each>
																	<xsl:for-each select="@class">
																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																	</xsl:for-each>
																	<xsl:for-each select="@style">
																		<xsl:attribute name="style" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@id">
																		<xsl:attribute name="id" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@xref">
																		<xsl:attribute name="xref" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@mathvariant">
																		<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@mathsize">
																		<xsl:attribute name="mathsize" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@mathcolor">
																		<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@mathbackground">
																		<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="node()">
																		<xsl:if test="fn:boolean(self::text())">
																			<xsl:sequence select="fn:string(.)"/>
																		</xsl:if>
																		<xsl:variable name="var52_test_resultof_node_name_equal_qname" as="node()?">
																			<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																				<xsl:sequence select="."/>
																			</xsl:if>
																		</xsl:variable>
																		<xsl:for-each select="$var52_test_resultof_node_name_equal_qname">
																			<mglyph>
																				<xsl:call-template name="tbf:tbf1_mglyph">
																					<xsl:with-param name="input" select="." as="node()"/>
																				</xsl:call-template>
																			</mglyph>
																		</xsl:for-each>
																		<xsl:variable name="var53_test_resultof_node_name_equal_qname" as="node()?">
																			<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																				<xsl:sequence select="."/>
																			</xsl:if>
																		</xsl:variable>
																		<xsl:for-each select="$var53_test_resultof_node_name_equal_qname">
																			<malignmark>
																				<xsl:for-each select="@edge">
																					<xsl:attribute name="edge" select="fn:string(.)"/>
																				</xsl:for-each>
																			</malignmark>
																		</xsl:for-each>
																	</xsl:for-each>
																</mi>
															</xsl:for-each>
															<xsl:for-each select="mathnl:mn">
																<mn>
																	<xsl:for-each select="@xlink:href">
																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																	</xsl:for-each>
																	<xsl:for-each select="@class">
																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																	</xsl:for-each>
																	<xsl:for-each select="@style">
																		<xsl:attribute name="style" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@id">
																		<xsl:attribute name="id" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@xref">
																		<xsl:attribute name="xref" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@mathvariant">
																		<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@mathsize">
																		<xsl:attribute name="mathsize" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@mathcolor">
																		<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@mathbackground">
																		<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="node()">
																		<xsl:if test="fn:boolean(self::text())">
																			<xsl:sequence select="fn:string(.)"/>
																		</xsl:if>
																		<xsl:variable name="var54_test_resultof_node_name_equal_qname" as="node()?">
																			<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																				<xsl:sequence select="."/>
																			</xsl:if>
																		</xsl:variable>
																		<xsl:for-each select="$var54_test_resultof_node_name_equal_qname">
																			<mglyph>
																				<xsl:call-template name="tbf:tbf1_mglyph">
																					<xsl:with-param name="input" select="." as="node()"/>
																				</xsl:call-template>
																			</mglyph>
																		</xsl:for-each>
																		<xsl:variable name="var55_test_resultof_node_name_equal_qname" as="node()?">
																			<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																				<xsl:sequence select="."/>
																			</xsl:if>
																		</xsl:variable>
																		<xsl:for-each select="$var55_test_resultof_node_name_equal_qname">
																			<malignmark>
																				<xsl:for-each select="@edge">
																					<xsl:attribute name="edge" select="fn:string(.)"/>
																				</xsl:for-each>
																			</malignmark>
																		</xsl:for-each>
																	</xsl:for-each>
																</mn>
															</xsl:for-each>
															<xsl:for-each select="mathnl:mo">
																<mo>
																	<xsl:for-each select="@xlink:href">
																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																	</xsl:for-each>
																	<xsl:for-each select="@class">
																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																	</xsl:for-each>
																	<xsl:for-each select="@style">
																		<xsl:attribute name="style" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@id">
																		<xsl:attribute name="id" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@xref">
																		<xsl:attribute name="xref" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@mathvariant">
																		<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@mathsize">
																		<xsl:attribute name="mathsize" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@mathcolor">
																		<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@mathbackground">
																		<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@form">
																		<xsl:attribute name="form" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@fence">
																		<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
																	</xsl:for-each>
																	<xsl:for-each select="@separator">
																		<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
																	</xsl:for-each>
																	<xsl:for-each select="@lspace">
																		<xsl:attribute name="lspace" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@rspace">
																		<xsl:attribute name="rspace" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@stretchy">
																		<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
																	</xsl:for-each>
																	<xsl:for-each select="@symmetric">
																		<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
																	</xsl:for-each>
																	<xsl:for-each select="@maxsize">
																		<xsl:attribute name="maxsize" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@minsize">
																		<xsl:attribute name="minsize" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@largeop">
																		<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
																	</xsl:for-each>
																	<xsl:for-each select="@movablelimits">
																		<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
																	</xsl:for-each>
																	<xsl:for-each select="@accent">
																		<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
																	</xsl:for-each>
																	<xsl:for-each select="node()">
																		<xsl:if test="fn:boolean(self::text())">
																			<xsl:sequence select="fn:string(.)"/>
																		</xsl:if>
																		<xsl:variable name="var56_test_resultof_node_name_equal_qname" as="node()?">
																			<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																				<xsl:sequence select="."/>
																			</xsl:if>
																		</xsl:variable>
																		<xsl:for-each select="$var56_test_resultof_node_name_equal_qname">
																			<mglyph>
																				<xsl:call-template name="tbf:tbf1_mglyph">
																					<xsl:with-param name="input" select="." as="node()"/>
																				</xsl:call-template>
																			</mglyph>
																		</xsl:for-each>
																		<xsl:variable name="var57_test_resultof_node_name_equal_qname" as="node()?">
																			<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																				<xsl:sequence select="."/>
																			</xsl:if>
																		</xsl:variable>
																		<xsl:for-each select="$var57_test_resultof_node_name_equal_qname">
																			<malignmark>
																				<xsl:for-each select="@edge">
																					<xsl:attribute name="edge" select="fn:string(.)"/>
																				</xsl:for-each>
																			</malignmark>
																		</xsl:for-each>
																	</xsl:for-each>
																</mo>
															</xsl:for-each>
															<xsl:for-each select="mathnl:mtext">
																<mtext>
																	<xsl:for-each select="@xlink:href">
																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																	</xsl:for-each>
																	<xsl:for-each select="@class">
																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																	</xsl:for-each>
																	<xsl:for-each select="@style">
																		<xsl:attribute name="style" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@id">
																		<xsl:attribute name="id" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@xref">
																		<xsl:attribute name="xref" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@mathvariant">
																		<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@mathsize">
																		<xsl:attribute name="mathsize" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@mathcolor">
																		<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@mathbackground">
																		<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="node()">
																		<xsl:if test="fn:boolean(self::text())">
																			<xsl:sequence select="fn:string(.)"/>
																		</xsl:if>
																		<xsl:variable name="var58_test_resultof_node_name_equal_qname" as="node()?">
																			<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																				<xsl:sequence select="."/>
																			</xsl:if>
																		</xsl:variable>
																		<xsl:for-each select="$var58_test_resultof_node_name_equal_qname">
																			<mglyph>
																				<xsl:call-template name="tbf:tbf1_mglyph">
																					<xsl:with-param name="input" select="." as="node()"/>
																				</xsl:call-template>
																			</mglyph>
																		</xsl:for-each>
																		<xsl:variable name="var59_test_resultof_node_name_equal_qname" as="node()?">
																			<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																				<xsl:sequence select="."/>
																			</xsl:if>
																		</xsl:variable>
																		<xsl:for-each select="$var59_test_resultof_node_name_equal_qname">
																			<malignmark>
																				<xsl:for-each select="@edge">
																					<xsl:attribute name="edge" select="fn:string(.)"/>
																				</xsl:for-each>
																			</malignmark>
																		</xsl:for-each>
																	</xsl:for-each>
																</mtext>
															</xsl:for-each>
															<xsl:for-each select="mathnl:ms">
																<ms>
																	<xsl:for-each select="@xlink:href">
																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																	</xsl:for-each>
																	<xsl:for-each select="@class">
																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																	</xsl:for-each>
																	<xsl:for-each select="@style">
																		<xsl:attribute name="style" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@id">
																		<xsl:attribute name="id" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@xref">
																		<xsl:attribute name="xref" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@mathvariant">
																		<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@mathsize">
																		<xsl:attribute name="mathsize" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@mathcolor">
																		<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@mathbackground">
																		<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@lquote">
																		<xsl:attribute name="lquote" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@rquote">
																		<xsl:attribute name="rquote" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="node()">
																		<xsl:if test="fn:boolean(self::text())">
																			<xsl:sequence select="fn:string(.)"/>
																		</xsl:if>
																		<xsl:variable name="var60_test_resultof_node_name_equal_qname" as="node()?">
																			<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																				<xsl:sequence select="."/>
																			</xsl:if>
																		</xsl:variable>
																		<xsl:for-each select="$var60_test_resultof_node_name_equal_qname">
																			<mglyph>
																				<xsl:call-template name="tbf:tbf1_mglyph">
																					<xsl:with-param name="input" select="." as="node()"/>
																				</xsl:call-template>
																			</mglyph>
																		</xsl:for-each>
																		<xsl:variable name="var61_test_resultof_node_name_equal_qname" as="node()?">
																			<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																				<xsl:sequence select="."/>
																			</xsl:if>
																		</xsl:variable>
																		<xsl:for-each select="$var61_test_resultof_node_name_equal_qname">
																			<malignmark>
																				<xsl:for-each select="@edge">
																					<xsl:attribute name="edge" select="fn:string(.)"/>
																				</xsl:for-each>
																			</malignmark>
																		</xsl:for-each>
																	</xsl:for-each>
																</ms>
															</xsl:for-each>
															<xsl:for-each select="mathnl:mrow">
																<mrow>
																	<xsl:sequence select="()"/>
																</mrow>
															</xsl:for-each>
															<xsl:for-each select="mathnl:mfrac">
																<mfrac>
																	<xsl:sequence select="()"/>
																</mfrac>
															</xsl:for-each>
															<xsl:for-each select="mathnl:msqrt">
																<msqrt>
																	<xsl:sequence select="()"/>
																</msqrt>
															</xsl:for-each>
															<xsl:for-each select="mathnl:mroot">
																<mroot>
																	<xsl:sequence select="()"/>
																</mroot>
															</xsl:for-each>
															<xsl:for-each select="mathnl:mpadded">
																<mpadded>
																	<xsl:sequence select="()"/>
																</mpadded>
															</xsl:for-each>
															<xsl:for-each select="mathnl:mphantom">
																<mphantom>
																	<xsl:for-each select="@xlink:href">
																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																	</xsl:for-each>
																	<xsl:for-each select="@class">
																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																	</xsl:for-each>
																	<xsl:for-each select="@style">
																		<xsl:attribute name="style" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@id">
																		<xsl:attribute name="id" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@xref">
																		<xsl:attribute name="xref" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="mathnl:mi">
																		<mi>
																			<xsl:for-each select="@xlink:href">
																				<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																			</xsl:for-each>
																			<xsl:for-each select="@class">
																				<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																			</xsl:for-each>
																			<xsl:for-each select="@style">
																				<xsl:attribute name="style" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@id">
																				<xsl:attribute name="id" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@xref">
																				<xsl:attribute name="xref" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@mathvariant">
																				<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@mathsize">
																				<xsl:attribute name="mathsize" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@mathcolor">
																				<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@mathbackground">
																				<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="node()">
																				<xsl:if test="fn:boolean(self::text())">
																					<xsl:sequence select="fn:string(.)"/>
																				</xsl:if>
																				<xsl:variable name="var62_test_resultof_node_name_equal_qname" as="node()?">
																					<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																						<xsl:sequence select="."/>
																					</xsl:if>
																				</xsl:variable>
																				<xsl:for-each select="$var62_test_resultof_node_name_equal_qname">
																					<mglyph>
																						<xsl:call-template name="tbf:tbf1_mglyph">
																							<xsl:with-param name="input" select="." as="node()"/>
																						</xsl:call-template>
																					</mglyph>
																				</xsl:for-each>
																				<xsl:variable name="var63_test_resultof_node_name_equal_qname" as="node()?">
																					<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																						<xsl:sequence select="."/>
																					</xsl:if>
																				</xsl:variable>
																				<xsl:for-each select="$var63_test_resultof_node_name_equal_qname">
																					<malignmark>
																						<xsl:for-each select="@edge">
																							<xsl:attribute name="edge" select="fn:string(.)"/>
																						</xsl:for-each>
																					</malignmark>
																				</xsl:for-each>
																			</xsl:for-each>
																		</mi>
																	</xsl:for-each>
																	<xsl:for-each select="mathnl:mn">
																		<mn>
																			<xsl:for-each select="@xlink:href">
																				<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																			</xsl:for-each>
																			<xsl:for-each select="@class">
																				<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																			</xsl:for-each>
																			<xsl:for-each select="@style">
																				<xsl:attribute name="style" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@id">
																				<xsl:attribute name="id" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@xref">
																				<xsl:attribute name="xref" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@mathvariant">
																				<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@mathsize">
																				<xsl:attribute name="mathsize" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@mathcolor">
																				<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@mathbackground">
																				<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="node()">
																				<xsl:if test="fn:boolean(self::text())">
																					<xsl:sequence select="fn:string(.)"/>
																				</xsl:if>
																				<xsl:variable name="var64_test_resultof_node_name_equal_qname" as="node()?">
																					<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																						<xsl:sequence select="."/>
																					</xsl:if>
																				</xsl:variable>
																				<xsl:for-each select="$var64_test_resultof_node_name_equal_qname">
																					<mglyph>
																						<xsl:call-template name="tbf:tbf1_mglyph">
																							<xsl:with-param name="input" select="." as="node()"/>
																						</xsl:call-template>
																					</mglyph>
																				</xsl:for-each>
																				<xsl:variable name="var65_test_resultof_node_name_equal_qname" as="node()?">
																					<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																						<xsl:sequence select="."/>
																					</xsl:if>
																				</xsl:variable>
																				<xsl:for-each select="$var65_test_resultof_node_name_equal_qname">
																					<malignmark>
																						<xsl:for-each select="@edge">
																							<xsl:attribute name="edge" select="fn:string(.)"/>
																						</xsl:for-each>
																					</malignmark>
																				</xsl:for-each>
																			</xsl:for-each>
																		</mn>
																	</xsl:for-each>
																	<xsl:for-each select="mathnl:mo">
																		<mo>
																			<xsl:for-each select="@xlink:href">
																				<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																			</xsl:for-each>
																			<xsl:for-each select="@class">
																				<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																			</xsl:for-each>
																			<xsl:for-each select="@style">
																				<xsl:attribute name="style" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@id">
																				<xsl:attribute name="id" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@xref">
																				<xsl:attribute name="xref" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@mathvariant">
																				<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@mathsize">
																				<xsl:attribute name="mathsize" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@mathcolor">
																				<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@mathbackground">
																				<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@form">
																				<xsl:attribute name="form" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@fence">
																				<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
																			</xsl:for-each>
																			<xsl:for-each select="@separator">
																				<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
																			</xsl:for-each>
																			<xsl:for-each select="@lspace">
																				<xsl:attribute name="lspace" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@rspace">
																				<xsl:attribute name="rspace" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@stretchy">
																				<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
																			</xsl:for-each>
																			<xsl:for-each select="@symmetric">
																				<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
																			</xsl:for-each>
																			<xsl:for-each select="@maxsize">
																				<xsl:attribute name="maxsize" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@minsize">
																				<xsl:attribute name="minsize" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@largeop">
																				<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
																			</xsl:for-each>
																			<xsl:for-each select="@movablelimits">
																				<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
																			</xsl:for-each>
																			<xsl:for-each select="@accent">
																				<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
																			</xsl:for-each>
																			<xsl:for-each select="node()">
																				<xsl:if test="fn:boolean(self::text())">
																					<xsl:sequence select="fn:string(.)"/>
																				</xsl:if>
																				<xsl:variable name="var66_test_resultof_node_name_equal_qname" as="node()?">
																					<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																						<xsl:sequence select="."/>
																					</xsl:if>
																				</xsl:variable>
																				<xsl:for-each select="$var66_test_resultof_node_name_equal_qname">
																					<mglyph>
																						<xsl:call-template name="tbf:tbf1_mglyph">
																							<xsl:with-param name="input" select="." as="node()"/>
																						</xsl:call-template>
																					</mglyph>
																				</xsl:for-each>
																				<xsl:variable name="var67_test_resultof_node_name_equal_qname" as="node()?">
																					<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																						<xsl:sequence select="."/>
																					</xsl:if>
																				</xsl:variable>
																				<xsl:for-each select="$var67_test_resultof_node_name_equal_qname">
																					<malignmark>
																						<xsl:for-each select="@edge">
																							<xsl:attribute name="edge" select="fn:string(.)"/>
																						</xsl:for-each>
																					</malignmark>
																				</xsl:for-each>
																			</xsl:for-each>
																		</mo>
																	</xsl:for-each>
																	<xsl:for-each select="mathnl:mtext">
																		<mtext>
																			<xsl:for-each select="@xlink:href">
																				<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																			</xsl:for-each>
																			<xsl:for-each select="@class">
																				<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																			</xsl:for-each>
																			<xsl:for-each select="@style">
																				<xsl:attribute name="style" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@id">
																				<xsl:attribute name="id" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@xref">
																				<xsl:attribute name="xref" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@mathvariant">
																				<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@mathsize">
																				<xsl:attribute name="mathsize" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@mathcolor">
																				<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@mathbackground">
																				<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="node()">
																				<xsl:if test="fn:boolean(self::text())">
																					<xsl:sequence select="fn:string(.)"/>
																				</xsl:if>
																				<xsl:variable name="var68_test_resultof_node_name_equal_qname" as="node()?">
																					<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																						<xsl:sequence select="."/>
																					</xsl:if>
																				</xsl:variable>
																				<xsl:for-each select="$var68_test_resultof_node_name_equal_qname">
																					<mglyph>
																						<xsl:call-template name="tbf:tbf1_mglyph">
																							<xsl:with-param name="input" select="." as="node()"/>
																						</xsl:call-template>
																					</mglyph>
																				</xsl:for-each>
																				<xsl:variable name="var69_test_resultof_node_name_equal_qname" as="node()?">
																					<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																						<xsl:sequence select="."/>
																					</xsl:if>
																				</xsl:variable>
																				<xsl:for-each select="$var69_test_resultof_node_name_equal_qname">
																					<malignmark>
																						<xsl:for-each select="@edge">
																							<xsl:attribute name="edge" select="fn:string(.)"/>
																						</xsl:for-each>
																					</malignmark>
																				</xsl:for-each>
																			</xsl:for-each>
																		</mtext>
																	</xsl:for-each>
																	<xsl:for-each select="mathnl:ms">
																		<ms>
																			<xsl:for-each select="@xlink:href">
																				<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																			</xsl:for-each>
																			<xsl:for-each select="@class">
																				<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																			</xsl:for-each>
																			<xsl:for-each select="@style">
																				<xsl:attribute name="style" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@id">
																				<xsl:attribute name="id" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@xref">
																				<xsl:attribute name="xref" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@mathvariant">
																				<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@mathsize">
																				<xsl:attribute name="mathsize" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@mathcolor">
																				<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@mathbackground">
																				<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@lquote">
																				<xsl:attribute name="lquote" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@rquote">
																				<xsl:attribute name="rquote" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="node()">
																				<xsl:if test="fn:boolean(self::text())">
																					<xsl:sequence select="fn:string(.)"/>
																				</xsl:if>
																				<xsl:variable name="var70_test_resultof_node_name_equal_qname" as="node()?">
																					<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																						<xsl:sequence select="."/>
																					</xsl:if>
																				</xsl:variable>
																				<xsl:for-each select="$var70_test_resultof_node_name_equal_qname">
																					<mglyph>
																						<xsl:call-template name="tbf:tbf1_mglyph">
																							<xsl:with-param name="input" select="." as="node()"/>
																						</xsl:call-template>
																					</mglyph>
																				</xsl:for-each>
																				<xsl:variable name="var71_test_resultof_node_name_equal_qname" as="node()?">
																					<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																						<xsl:sequence select="."/>
																					</xsl:if>
																				</xsl:variable>
																				<xsl:for-each select="$var71_test_resultof_node_name_equal_qname">
																					<malignmark>
																						<xsl:for-each select="@edge">
																							<xsl:attribute name="edge" select="fn:string(.)"/>
																						</xsl:for-each>
																					</malignmark>
																				</xsl:for-each>
																			</xsl:for-each>
																		</ms>
																	</xsl:for-each>
																	<xsl:for-each select="mathnl:mrow">
																		<mrow>
																			<xsl:sequence select="()"/>
																		</mrow>
																	</xsl:for-each>
																	<xsl:for-each select="mathnl:mfrac">
																		<mfrac>
																			<xsl:sequence select="()"/>
																		</mfrac>
																	</xsl:for-each>
																	<xsl:for-each select="mathnl:msqrt">
																		<msqrt>
																			<xsl:sequence select="()"/>
																		</msqrt>
																	</xsl:for-each>
																	<xsl:for-each select="mathnl:mroot">
																		<mroot>
																			<xsl:sequence select="()"/>
																		</mroot>
																	</xsl:for-each>
																	<xsl:for-each select="mathnl:mpadded">
																		<mpadded>
																			<xsl:sequence select="()"/>
																		</mpadded>
																	</xsl:for-each>
																	<xsl:for-each select="mathnl:mphantom">
																		<mphantom>
																			<xsl:sequence select="()"/>
																		</mphantom>
																	</xsl:for-each>
																	<xsl:for-each select="mathnl:mfenced">
																		<mfenced>
																			<xsl:for-each select="@xlink:href">
																				<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																			</xsl:for-each>
																			<xsl:for-each select="@class">
																				<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																			</xsl:for-each>
																			<xsl:for-each select="@style">
																				<xsl:attribute name="style" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@id">
																				<xsl:attribute name="id" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@xref">
																				<xsl:attribute name="xref" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@open">
																				<xsl:attribute name="open" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@close">
																				<xsl:attribute name="close" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="@separators">
																				<xsl:attribute name="separators" select="fn:string(.)"/>
																			</xsl:for-each>
																			<xsl:for-each select="mathnl:mi">
																				<mi>
																					<xsl:for-each select="@xlink:href">
																						<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																					</xsl:for-each>
																					<xsl:for-each select="@class">
																						<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																					</xsl:for-each>
																					<xsl:for-each select="@style">
																						<xsl:attribute name="style" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@id">
																						<xsl:attribute name="id" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@xref">
																						<xsl:attribute name="xref" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@mathvariant">
																						<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@mathsize">
																						<xsl:attribute name="mathsize" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@mathcolor">
																						<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@mathbackground">
																						<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="node()">
																						<xsl:if test="fn:boolean(self::text())">
																							<xsl:sequence select="fn:string(.)"/>
																						</xsl:if>
																						<xsl:variable name="var72_test_resultof_node_name_equal_qname" as="node()?">
																							<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																								<xsl:sequence select="."/>
																							</xsl:if>
																						</xsl:variable>
																						<xsl:for-each select="$var72_test_resultof_node_name_equal_qname">
																							<mglyph>
																								<xsl:call-template name="tbf:tbf1_mglyph">
																									<xsl:with-param name="input" select="." as="node()"/>
																								</xsl:call-template>
																							</mglyph>
																						</xsl:for-each>
																						<xsl:variable name="var73_test_resultof_node_name_equal_qname" as="node()?">
																							<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																								<xsl:sequence select="."/>
																							</xsl:if>
																						</xsl:variable>
																						<xsl:for-each select="$var73_test_resultof_node_name_equal_qname">
																							<malignmark>
																								<xsl:for-each select="@edge">
																									<xsl:attribute name="edge" select="fn:string(.)"/>
																								</xsl:for-each>
																							</malignmark>
																						</xsl:for-each>
																					</xsl:for-each>
																				</mi>
																			</xsl:for-each>
																			<xsl:for-each select="mathnl:mn">
																				<mn>
																					<xsl:for-each select="@xlink:href">
																						<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																					</xsl:for-each>
																					<xsl:for-each select="@class">
																						<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																					</xsl:for-each>
																					<xsl:for-each select="@style">
																						<xsl:attribute name="style" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@id">
																						<xsl:attribute name="id" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@xref">
																						<xsl:attribute name="xref" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@mathvariant">
																						<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@mathsize">
																						<xsl:attribute name="mathsize" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@mathcolor">
																						<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@mathbackground">
																						<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="node()">
																						<xsl:if test="fn:boolean(self::text())">
																							<xsl:sequence select="fn:string(.)"/>
																						</xsl:if>
																						<xsl:variable name="var74_test_resultof_node_name_equal_qname" as="node()?">
																							<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																								<xsl:sequence select="."/>
																							</xsl:if>
																						</xsl:variable>
																						<xsl:for-each select="$var74_test_resultof_node_name_equal_qname">
																							<mglyph>
																								<xsl:call-template name="tbf:tbf1_mglyph">
																									<xsl:with-param name="input" select="." as="node()"/>
																								</xsl:call-template>
																							</mglyph>
																						</xsl:for-each>
																						<xsl:variable name="var75_test_resultof_node_name_equal_qname" as="node()?">
																							<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																								<xsl:sequence select="."/>
																							</xsl:if>
																						</xsl:variable>
																						<xsl:for-each select="$var75_test_resultof_node_name_equal_qname">
																							<malignmark>
																								<xsl:for-each select="@edge">
																									<xsl:attribute name="edge" select="fn:string(.)"/>
																								</xsl:for-each>
																							</malignmark>
																						</xsl:for-each>
																					</xsl:for-each>
																				</mn>
																			</xsl:for-each>
																			<xsl:for-each select="mathnl:mo">
																				<mo>
																					<xsl:for-each select="@xlink:href">
																						<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																					</xsl:for-each>
																					<xsl:for-each select="@class">
																						<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																					</xsl:for-each>
																					<xsl:for-each select="@style">
																						<xsl:attribute name="style" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@id">
																						<xsl:attribute name="id" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@xref">
																						<xsl:attribute name="xref" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@mathvariant">
																						<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@mathsize">
																						<xsl:attribute name="mathsize" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@mathcolor">
																						<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@mathbackground">
																						<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@form">
																						<xsl:attribute name="form" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@fence">
																						<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
																					</xsl:for-each>
																					<xsl:for-each select="@separator">
																						<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
																					</xsl:for-each>
																					<xsl:for-each select="@lspace">
																						<xsl:attribute name="lspace" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@rspace">
																						<xsl:attribute name="rspace" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@stretchy">
																						<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
																					</xsl:for-each>
																					<xsl:for-each select="@symmetric">
																						<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
																					</xsl:for-each>
																					<xsl:for-each select="@maxsize">
																						<xsl:attribute name="maxsize" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@minsize">
																						<xsl:attribute name="minsize" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@largeop">
																						<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
																					</xsl:for-each>
																					<xsl:for-each select="@movablelimits">
																						<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
																					</xsl:for-each>
																					<xsl:for-each select="@accent">
																						<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
																					</xsl:for-each>
																					<xsl:for-each select="node()">
																						<xsl:if test="fn:boolean(self::text())">
																							<xsl:sequence select="fn:string(.)"/>
																						</xsl:if>
																						<xsl:variable name="var76_test_resultof_node_name_equal_qname" as="node()?">
																							<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																								<xsl:sequence select="."/>
																							</xsl:if>
																						</xsl:variable>
																						<xsl:for-each select="$var76_test_resultof_node_name_equal_qname">
																							<mglyph>
																								<xsl:call-template name="tbf:tbf1_mglyph">
																									<xsl:with-param name="input" select="." as="node()"/>
																								</xsl:call-template>
																							</mglyph>
																						</xsl:for-each>
																						<xsl:variable name="var77_test_resultof_node_name_equal_qname" as="node()?">
																							<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																								<xsl:sequence select="."/>
																							</xsl:if>
																						</xsl:variable>
																						<xsl:for-each select="$var77_test_resultof_node_name_equal_qname">
																							<malignmark>
																								<xsl:for-each select="@edge">
																									<xsl:attribute name="edge" select="fn:string(.)"/>
																								</xsl:for-each>
																							</malignmark>
																						</xsl:for-each>
																					</xsl:for-each>
																				</mo>
																			</xsl:for-each>
																			<xsl:for-each select="mathnl:mtext">
																				<mtext>
																					<xsl:for-each select="@xlink:href">
																						<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																					</xsl:for-each>
																					<xsl:for-each select="@class">
																						<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																					</xsl:for-each>
																					<xsl:for-each select="@style">
																						<xsl:attribute name="style" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@id">
																						<xsl:attribute name="id" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@xref">
																						<xsl:attribute name="xref" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@mathvariant">
																						<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@mathsize">
																						<xsl:attribute name="mathsize" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@mathcolor">
																						<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@mathbackground">
																						<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="node()">
																						<xsl:if test="fn:boolean(self::text())">
																							<xsl:sequence select="fn:string(.)"/>
																						</xsl:if>
																						<xsl:variable name="var78_test_resultof_node_name_equal_qname" as="node()?">
																							<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																								<xsl:sequence select="."/>
																							</xsl:if>
																						</xsl:variable>
																						<xsl:for-each select="$var78_test_resultof_node_name_equal_qname">
																							<mglyph>
																								<xsl:call-template name="tbf:tbf1_mglyph">
																									<xsl:with-param name="input" select="." as="node()"/>
																								</xsl:call-template>
																							</mglyph>
																						</xsl:for-each>
																						<xsl:variable name="var79_test_resultof_node_name_equal_qname" as="node()?">
																							<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																								<xsl:sequence select="."/>
																							</xsl:if>
																						</xsl:variable>
																						<xsl:for-each select="$var79_test_resultof_node_name_equal_qname">
																							<malignmark>
																								<xsl:for-each select="@edge">
																									<xsl:attribute name="edge" select="fn:string(.)"/>
																								</xsl:for-each>
																							</malignmark>
																						</xsl:for-each>
																					</xsl:for-each>
																				</mtext>
																			</xsl:for-each>
																			<xsl:for-each select="mathnl:ms">
																				<ms>
																					<xsl:for-each select="@xlink:href">
																						<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																					</xsl:for-each>
																					<xsl:for-each select="@class">
																						<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																					</xsl:for-each>
																					<xsl:for-each select="@style">
																						<xsl:attribute name="style" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@id">
																						<xsl:attribute name="id" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@xref">
																						<xsl:attribute name="xref" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@mathvariant">
																						<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@mathsize">
																						<xsl:attribute name="mathsize" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@mathcolor">
																						<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@mathbackground">
																						<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@lquote">
																						<xsl:attribute name="lquote" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@rquote">
																						<xsl:attribute name="rquote" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="node()">
																						<xsl:if test="fn:boolean(self::text())">
																							<xsl:sequence select="fn:string(.)"/>
																						</xsl:if>
																						<xsl:variable name="var80_test_resultof_node_name_equal_qname" as="node()?">
																							<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																								<xsl:sequence select="."/>
																							</xsl:if>
																						</xsl:variable>
																						<xsl:for-each select="$var80_test_resultof_node_name_equal_qname">
																							<mglyph>
																								<xsl:call-template name="tbf:tbf1_mglyph">
																									<xsl:with-param name="input" select="." as="node()"/>
																								</xsl:call-template>
																							</mglyph>
																						</xsl:for-each>
																						<xsl:variable name="var81_test_resultof_node_name_equal_qname" as="node()?">
																							<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																								<xsl:sequence select="."/>
																							</xsl:if>
																						</xsl:variable>
																						<xsl:for-each select="$var81_test_resultof_node_name_equal_qname">
																							<malignmark>
																								<xsl:for-each select="@edge">
																									<xsl:attribute name="edge" select="fn:string(.)"/>
																								</xsl:for-each>
																							</malignmark>
																						</xsl:for-each>
																					</xsl:for-each>
																				</ms>
																			</xsl:for-each>
																			<xsl:for-each select="mathnl:mrow">
																				<mrow>
																					<xsl:sequence select="()"/>
																				</mrow>
																			</xsl:for-each>
																			<xsl:for-each select="mathnl:mfrac">
																				<mfrac>
																					<xsl:sequence select="()"/>
																				</mfrac>
																			</xsl:for-each>
																			<xsl:for-each select="mathnl:msqrt">
																				<msqrt>
																					<xsl:sequence select="()"/>
																				</msqrt>
																			</xsl:for-each>
																			<xsl:for-each select="mathnl:mroot">
																				<mroot>
																					<xsl:sequence select="()"/>
																				</mroot>
																			</xsl:for-each>
																			<xsl:for-each select="mathnl:menclose">
																				<menclose>
																					<xsl:for-each select="@xlink:href">
																						<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																					</xsl:for-each>
																					<xsl:for-each select="@class">
																						<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																					</xsl:for-each>
																					<xsl:for-each select="@style">
																						<xsl:attribute name="style" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@id">
																						<xsl:attribute name="id" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@xref">
																						<xsl:attribute name="xref" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="@notation">
																						<xsl:attribute name="notation" select="fn:string(.)"/>
																					</xsl:for-each>
																					<xsl:for-each select="mathnl:mi">
																						<mi>
																							<xsl:for-each select="@xlink:href">
																								<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																							</xsl:for-each>
																							<xsl:for-each select="@class">
																								<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																							</xsl:for-each>
																							<xsl:for-each select="@style">
																								<xsl:attribute name="style" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@id">
																								<xsl:attribute name="id" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@xref">
																								<xsl:attribute name="xref" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@mathvariant">
																								<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@mathsize">
																								<xsl:attribute name="mathsize" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@mathcolor">
																								<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@mathbackground">
																								<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="node()">
																								<xsl:if test="fn:boolean(self::text())">
																									<xsl:sequence select="fn:string(.)"/>
																								</xsl:if>
																								<xsl:variable name="var82_test_resultof_node_name_equal_qname" as="node()?">
																									<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																										<xsl:sequence select="."/>
																									</xsl:if>
																								</xsl:variable>
																								<xsl:for-each select="$var82_test_resultof_node_name_equal_qname">
																									<mglyph>
																										<xsl:call-template name="tbf:tbf1_mglyph">
																											<xsl:with-param name="input" select="." as="node()"/>
																										</xsl:call-template>
																									</mglyph>
																								</xsl:for-each>
																								<xsl:variable name="var83_test_resultof_node_name_equal_qname" as="node()?">
																									<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																										<xsl:sequence select="."/>
																									</xsl:if>
																								</xsl:variable>
																								<xsl:for-each select="$var83_test_resultof_node_name_equal_qname">
																									<malignmark>
																										<xsl:for-each select="@edge">
																											<xsl:attribute name="edge" select="fn:string(.)"/>
																										</xsl:for-each>
																									</malignmark>
																								</xsl:for-each>
																							</xsl:for-each>
																						</mi>
																					</xsl:for-each>
																					<xsl:for-each select="mathnl:mn">
																						<mn>
																							<xsl:for-each select="@xlink:href">
																								<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																							</xsl:for-each>
																							<xsl:for-each select="@class">
																								<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																							</xsl:for-each>
																							<xsl:for-each select="@style">
																								<xsl:attribute name="style" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@id">
																								<xsl:attribute name="id" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@xref">
																								<xsl:attribute name="xref" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@mathvariant">
																								<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@mathsize">
																								<xsl:attribute name="mathsize" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@mathcolor">
																								<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@mathbackground">
																								<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="node()">
																								<xsl:if test="fn:boolean(self::text())">
																									<xsl:sequence select="fn:string(.)"/>
																								</xsl:if>
																								<xsl:variable name="var84_test_resultof_node_name_equal_qname" as="node()?">
																									<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																										<xsl:sequence select="."/>
																									</xsl:if>
																								</xsl:variable>
																								<xsl:for-each select="$var84_test_resultof_node_name_equal_qname">
																									<mglyph>
																										<xsl:call-template name="tbf:tbf1_mglyph">
																											<xsl:with-param name="input" select="." as="node()"/>
																										</xsl:call-template>
																									</mglyph>
																								</xsl:for-each>
																								<xsl:variable name="var85_test_resultof_node_name_equal_qname" as="node()?">
																									<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																										<xsl:sequence select="."/>
																									</xsl:if>
																								</xsl:variable>
																								<xsl:for-each select="$var85_test_resultof_node_name_equal_qname">
																									<malignmark>
																										<xsl:for-each select="@edge">
																											<xsl:attribute name="edge" select="fn:string(.)"/>
																										</xsl:for-each>
																									</malignmark>
																								</xsl:for-each>
																							</xsl:for-each>
																						</mn>
																					</xsl:for-each>
																					<xsl:for-each select="mathnl:mo">
																						<mo>
																							<xsl:for-each select="@xlink:href">
																								<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																							</xsl:for-each>
																							<xsl:for-each select="@class">
																								<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																							</xsl:for-each>
																							<xsl:for-each select="@style">
																								<xsl:attribute name="style" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@id">
																								<xsl:attribute name="id" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@xref">
																								<xsl:attribute name="xref" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@mathvariant">
																								<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@mathsize">
																								<xsl:attribute name="mathsize" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@mathcolor">
																								<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@mathbackground">
																								<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@form">
																								<xsl:attribute name="form" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@fence">
																								<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
																							</xsl:for-each>
																							<xsl:for-each select="@separator">
																								<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
																							</xsl:for-each>
																							<xsl:for-each select="@lspace">
																								<xsl:attribute name="lspace" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@rspace">
																								<xsl:attribute name="rspace" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@stretchy">
																								<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
																							</xsl:for-each>
																							<xsl:for-each select="@symmetric">
																								<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
																							</xsl:for-each>
																							<xsl:for-each select="@maxsize">
																								<xsl:attribute name="maxsize" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@minsize">
																								<xsl:attribute name="minsize" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@largeop">
																								<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
																							</xsl:for-each>
																							<xsl:for-each select="@movablelimits">
																								<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
																							</xsl:for-each>
																							<xsl:for-each select="@accent">
																								<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
																							</xsl:for-each>
																							<xsl:for-each select="node()">
																								<xsl:if test="fn:boolean(self::text())">
																									<xsl:sequence select="fn:string(.)"/>
																								</xsl:if>
																								<xsl:variable name="var86_test_resultof_node_name_equal_qname" as="node()?">
																									<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																										<xsl:sequence select="."/>
																									</xsl:if>
																								</xsl:variable>
																								<xsl:for-each select="$var86_test_resultof_node_name_equal_qname">
																									<mglyph>
																										<xsl:call-template name="tbf:tbf1_mglyph">
																											<xsl:with-param name="input" select="." as="node()"/>
																										</xsl:call-template>
																									</mglyph>
																								</xsl:for-each>
																								<xsl:variable name="var87_test_resultof_node_name_equal_qname" as="node()?">
																									<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																										<xsl:sequence select="."/>
																									</xsl:if>
																								</xsl:variable>
																								<xsl:for-each select="$var87_test_resultof_node_name_equal_qname">
																									<malignmark>
																										<xsl:for-each select="@edge">
																											<xsl:attribute name="edge" select="fn:string(.)"/>
																										</xsl:for-each>
																									</malignmark>
																								</xsl:for-each>
																							</xsl:for-each>
																						</mo>
																					</xsl:for-each>
																					<xsl:for-each select="mathnl:mtext">
																						<mtext>
																							<xsl:for-each select="@xlink:href">
																								<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																							</xsl:for-each>
																							<xsl:for-each select="@class">
																								<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																							</xsl:for-each>
																							<xsl:for-each select="@style">
																								<xsl:attribute name="style" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@id">
																								<xsl:attribute name="id" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@xref">
																								<xsl:attribute name="xref" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@mathvariant">
																								<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@mathsize">
																								<xsl:attribute name="mathsize" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@mathcolor">
																								<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@mathbackground">
																								<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="node()">
																								<xsl:if test="fn:boolean(self::text())">
																									<xsl:sequence select="fn:string(.)"/>
																								</xsl:if>
																								<xsl:variable name="var88_test_resultof_node_name_equal_qname" as="node()?">
																									<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																										<xsl:sequence select="."/>
																									</xsl:if>
																								</xsl:variable>
																								<xsl:for-each select="$var88_test_resultof_node_name_equal_qname">
																									<mglyph>
																										<xsl:call-template name="tbf:tbf1_mglyph">
																											<xsl:with-param name="input" select="." as="node()"/>
																										</xsl:call-template>
																									</mglyph>
																								</xsl:for-each>
																								<xsl:variable name="var89_test_resultof_node_name_equal_qname" as="node()?">
																									<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																										<xsl:sequence select="."/>
																									</xsl:if>
																								</xsl:variable>
																								<xsl:for-each select="$var89_test_resultof_node_name_equal_qname">
																									<malignmark>
																										<xsl:for-each select="@edge">
																											<xsl:attribute name="edge" select="fn:string(.)"/>
																										</xsl:for-each>
																									</malignmark>
																								</xsl:for-each>
																							</xsl:for-each>
																						</mtext>
																					</xsl:for-each>
																					<xsl:for-each select="mathnl:ms">
																						<ms>
																							<xsl:for-each select="@xlink:href">
																								<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																							</xsl:for-each>
																							<xsl:for-each select="@class">
																								<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																							</xsl:for-each>
																							<xsl:for-each select="@style">
																								<xsl:attribute name="style" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@id">
																								<xsl:attribute name="id" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@xref">
																								<xsl:attribute name="xref" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@mathvariant">
																								<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@mathsize">
																								<xsl:attribute name="mathsize" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@mathcolor">
																								<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@mathbackground">
																								<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@lquote">
																								<xsl:attribute name="lquote" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@rquote">
																								<xsl:attribute name="rquote" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="node()">
																								<xsl:if test="fn:boolean(self::text())">
																									<xsl:sequence select="fn:string(.)"/>
																								</xsl:if>
																								<xsl:variable name="var90_test_resultof_node_name_equal_qname" as="node()?">
																									<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																										<xsl:sequence select="."/>
																									</xsl:if>
																								</xsl:variable>
																								<xsl:for-each select="$var90_test_resultof_node_name_equal_qname">
																									<mglyph>
																										<xsl:call-template name="tbf:tbf1_mglyph">
																											<xsl:with-param name="input" select="." as="node()"/>
																										</xsl:call-template>
																									</mglyph>
																								</xsl:for-each>
																								<xsl:variable name="var91_test_resultof_node_name_equal_qname" as="node()?">
																									<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																										<xsl:sequence select="."/>
																									</xsl:if>
																								</xsl:variable>
																								<xsl:for-each select="$var91_test_resultof_node_name_equal_qname">
																									<malignmark>
																										<xsl:for-each select="@edge">
																											<xsl:attribute name="edge" select="fn:string(.)"/>
																										</xsl:for-each>
																									</malignmark>
																								</xsl:for-each>
																							</xsl:for-each>
																						</ms>
																					</xsl:for-each>
																					<xsl:for-each select="mathnl:mrow">
																						<mrow>
																							<xsl:sequence select="()"/>
																						</mrow>
																					</xsl:for-each>
																					<xsl:for-each select="mathnl:mfrac">
																						<mfrac>
																							<xsl:sequence select="()"/>
																						</mfrac>
																					</xsl:for-each>
																					<xsl:for-each select="mathnl:msqrt">
																						<msqrt>
																							<xsl:sequence select="()"/>
																						</msqrt>
																					</xsl:for-each>
																					<xsl:for-each select="mathnl:mroot">
																						<mroot>
																							<xsl:sequence select="()"/>
																						</mroot>
																					</xsl:for-each>
																					<xsl:for-each select="mathnl:menclose">
																						<menclose>
																							<xsl:sequence select="()"/>
																						</menclose>
																					</xsl:for-each>
																					<xsl:for-each select="mathnl:mpadded">
																						<mpadded>
																							<xsl:sequence select="()"/>
																						</mpadded>
																					</xsl:for-each>
																					<xsl:for-each select="mathnl:mphantom">
																						<mphantom>
																							<xsl:sequence select="()"/>
																						</mphantom>
																					</xsl:for-each>
																					<xsl:for-each select="mathnl:mfenced">
																						<mfenced>
																							<xsl:sequence select="()"/>
																						</mfenced>
																					</xsl:for-each>
																					<xsl:for-each select="mathnl:msub">
																						<msub>
																							<xsl:for-each select="@xlink:href">
																								<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																							</xsl:for-each>
																							<xsl:for-each select="@class">
																								<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																							</xsl:for-each>
																							<xsl:for-each select="@style">
																								<xsl:attribute name="style" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@id">
																								<xsl:attribute name="id" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@xref">
																								<xsl:attribute name="xref" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="@subscriptshift">
																								<xsl:attribute name="subscriptshift" select="fn:string(.)"/>
																							</xsl:for-each>
																							<xsl:for-each select="mathnl:mi">
																								<mi>
																									<xsl:for-each select="@xlink:href">
																										<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																									</xsl:for-each>
																									<xsl:for-each select="@class">
																										<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																									</xsl:for-each>
																									<xsl:for-each select="@style">
																										<xsl:attribute name="style" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@id">
																										<xsl:attribute name="id" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@xref">
																										<xsl:attribute name="xref" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@mathvariant">
																										<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@mathsize">
																										<xsl:attribute name="mathsize" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@mathcolor">
																										<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@mathbackground">
																										<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="node()">
																										<xsl:if test="fn:boolean(self::text())">
																											<xsl:sequence select="fn:string(.)"/>
																										</xsl:if>
																										<xsl:variable name="var92_test_resultof_node_name_equal_qname" as="node()?">
																											<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																												<xsl:sequence select="."/>
																											</xsl:if>
																										</xsl:variable>
																										<xsl:for-each select="$var92_test_resultof_node_name_equal_qname">
																											<mglyph>
																												<xsl:call-template name="tbf:tbf1_mglyph">
																													<xsl:with-param name="input" select="." as="node()"/>
																												</xsl:call-template>
																											</mglyph>
																										</xsl:for-each>
																										<xsl:variable name="var93_test_resultof_node_name_equal_qname" as="node()?">
																											<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																												<xsl:sequence select="."/>
																											</xsl:if>
																										</xsl:variable>
																										<xsl:for-each select="$var93_test_resultof_node_name_equal_qname">
																											<malignmark>
																												<xsl:for-each select="@edge">
																													<xsl:attribute name="edge" select="fn:string(.)"/>
																												</xsl:for-each>
																											</malignmark>
																										</xsl:for-each>
																									</xsl:for-each>
																								</mi>
																							</xsl:for-each>
																							<xsl:for-each select="mathnl:mn">
																								<mn>
																									<xsl:for-each select="@xlink:href">
																										<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																									</xsl:for-each>
																									<xsl:for-each select="@class">
																										<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																									</xsl:for-each>
																									<xsl:for-each select="@style">
																										<xsl:attribute name="style" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@id">
																										<xsl:attribute name="id" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@xref">
																										<xsl:attribute name="xref" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@mathvariant">
																										<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@mathsize">
																										<xsl:attribute name="mathsize" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@mathcolor">
																										<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@mathbackground">
																										<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="node()">
																										<xsl:if test="fn:boolean(self::text())">
																											<xsl:sequence select="fn:string(.)"/>
																										</xsl:if>
																										<xsl:variable name="var94_test_resultof_node_name_equal_qname" as="node()?">
																											<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																												<xsl:sequence select="."/>
																											</xsl:if>
																										</xsl:variable>
																										<xsl:for-each select="$var94_test_resultof_node_name_equal_qname">
																											<mglyph>
																												<xsl:call-template name="tbf:tbf1_mglyph">
																													<xsl:with-param name="input" select="." as="node()"/>
																												</xsl:call-template>
																											</mglyph>
																										</xsl:for-each>
																										<xsl:variable name="var95_test_resultof_node_name_equal_qname" as="node()?">
																											<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																												<xsl:sequence select="."/>
																											</xsl:if>
																										</xsl:variable>
																										<xsl:for-each select="$var95_test_resultof_node_name_equal_qname">
																											<malignmark>
																												<xsl:for-each select="@edge">
																													<xsl:attribute name="edge" select="fn:string(.)"/>
																												</xsl:for-each>
																											</malignmark>
																										</xsl:for-each>
																									</xsl:for-each>
																								</mn>
																							</xsl:for-each>
																							<xsl:for-each select="mathnl:mo">
																								<mo>
																									<xsl:for-each select="@xlink:href">
																										<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																									</xsl:for-each>
																									<xsl:for-each select="@class">
																										<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																									</xsl:for-each>
																									<xsl:for-each select="@style">
																										<xsl:attribute name="style" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@id">
																										<xsl:attribute name="id" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@xref">
																										<xsl:attribute name="xref" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@mathvariant">
																										<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@mathsize">
																										<xsl:attribute name="mathsize" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@mathcolor">
																										<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@mathbackground">
																										<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@form">
																										<xsl:attribute name="form" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@fence">
																										<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
																									</xsl:for-each>
																									<xsl:for-each select="@separator">
																										<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
																									</xsl:for-each>
																									<xsl:for-each select="@lspace">
																										<xsl:attribute name="lspace" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@rspace">
																										<xsl:attribute name="rspace" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@stretchy">
																										<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
																									</xsl:for-each>
																									<xsl:for-each select="@symmetric">
																										<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
																									</xsl:for-each>
																									<xsl:for-each select="@maxsize">
																										<xsl:attribute name="maxsize" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@minsize">
																										<xsl:attribute name="minsize" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@largeop">
																										<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
																									</xsl:for-each>
																									<xsl:for-each select="@movablelimits">
																										<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
																									</xsl:for-each>
																									<xsl:for-each select="@accent">
																										<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
																									</xsl:for-each>
																									<xsl:for-each select="node()">
																										<xsl:if test="fn:boolean(self::text())">
																											<xsl:sequence select="fn:string(.)"/>
																										</xsl:if>
																										<xsl:variable name="var96_test_resultof_node_name_equal_qname" as="node()?">
																											<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																												<xsl:sequence select="."/>
																											</xsl:if>
																										</xsl:variable>
																										<xsl:for-each select="$var96_test_resultof_node_name_equal_qname">
																											<mglyph>
																												<xsl:call-template name="tbf:tbf1_mglyph">
																													<xsl:with-param name="input" select="." as="node()"/>
																												</xsl:call-template>
																											</mglyph>
																										</xsl:for-each>
																										<xsl:variable name="var97_test_resultof_node_name_equal_qname" as="node()?">
																											<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																												<xsl:sequence select="."/>
																											</xsl:if>
																										</xsl:variable>
																										<xsl:for-each select="$var97_test_resultof_node_name_equal_qname">
																											<malignmark>
																												<xsl:for-each select="@edge">
																													<xsl:attribute name="edge" select="fn:string(.)"/>
																												</xsl:for-each>
																											</malignmark>
																										</xsl:for-each>
																									</xsl:for-each>
																								</mo>
																							</xsl:for-each>
																							<xsl:for-each select="mathnl:mtext">
																								<mtext>
																									<xsl:for-each select="@xlink:href">
																										<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																									</xsl:for-each>
																									<xsl:for-each select="@class">
																										<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																									</xsl:for-each>
																									<xsl:for-each select="@style">
																										<xsl:attribute name="style" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@id">
																										<xsl:attribute name="id" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@xref">
																										<xsl:attribute name="xref" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@mathvariant">
																										<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@mathsize">
																										<xsl:attribute name="mathsize" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@mathcolor">
																										<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@mathbackground">
																										<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="node()">
																										<xsl:if test="fn:boolean(self::text())">
																											<xsl:sequence select="fn:string(.)"/>
																										</xsl:if>
																										<xsl:variable name="var98_test_resultof_node_name_equal_qname" as="node()?">
																											<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																												<xsl:sequence select="."/>
																											</xsl:if>
																										</xsl:variable>
																										<xsl:for-each select="$var98_test_resultof_node_name_equal_qname">
																											<mglyph>
																												<xsl:call-template name="tbf:tbf1_mglyph">
																													<xsl:with-param name="input" select="." as="node()"/>
																												</xsl:call-template>
																											</mglyph>
																										</xsl:for-each>
																										<xsl:variable name="var99_test_resultof_node_name_equal_qname" as="node()?">
																											<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																												<xsl:sequence select="."/>
																											</xsl:if>
																										</xsl:variable>
																										<xsl:for-each select="$var99_test_resultof_node_name_equal_qname">
																											<malignmark>
																												<xsl:for-each select="@edge">
																													<xsl:attribute name="edge" select="fn:string(.)"/>
																												</xsl:for-each>
																											</malignmark>
																										</xsl:for-each>
																									</xsl:for-each>
																								</mtext>
																							</xsl:for-each>
																							<xsl:for-each select="mathnl:ms">
																								<ms>
																									<xsl:for-each select="@xlink:href">
																										<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																									</xsl:for-each>
																									<xsl:for-each select="@class">
																										<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																									</xsl:for-each>
																									<xsl:for-each select="@style">
																										<xsl:attribute name="style" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@id">
																										<xsl:attribute name="id" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@xref">
																										<xsl:attribute name="xref" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@mathvariant">
																										<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@mathsize">
																										<xsl:attribute name="mathsize" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@mathcolor">
																										<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@mathbackground">
																										<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@lquote">
																										<xsl:attribute name="lquote" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@rquote">
																										<xsl:attribute name="rquote" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="node()">
																										<xsl:if test="fn:boolean(self::text())">
																											<xsl:sequence select="fn:string(.)"/>
																										</xsl:if>
																										<xsl:variable name="var100_test_resultof_node_name_equal_qname" as="node()?">
																											<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																												<xsl:sequence select="."/>
																											</xsl:if>
																										</xsl:variable>
																										<xsl:for-each select="$var100_test_resultof_node_name_equal_qname">
																											<mglyph>
																												<xsl:call-template name="tbf:tbf1_mglyph">
																													<xsl:with-param name="input" select="." as="node()"/>
																												</xsl:call-template>
																											</mglyph>
																										</xsl:for-each>
																										<xsl:variable name="var101_test_resultof_node_name_equal_qname" as="node()?">
																											<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																												<xsl:sequence select="."/>
																											</xsl:if>
																										</xsl:variable>
																										<xsl:for-each select="$var101_test_resultof_node_name_equal_qname">
																											<malignmark>
																												<xsl:for-each select="@edge">
																													<xsl:attribute name="edge" select="fn:string(.)"/>
																												</xsl:for-each>
																											</malignmark>
																										</xsl:for-each>
																									</xsl:for-each>
																								</ms>
																							</xsl:for-each>
																							<xsl:for-each select="mathnl:mrow">
																								<mrow>
																									<xsl:sequence select="()"/>
																								</mrow>
																							</xsl:for-each>
																							<xsl:for-each select="mathnl:mfrac">
																								<mfrac>
																									<xsl:sequence select="()"/>
																								</mfrac>
																							</xsl:for-each>
																							<xsl:for-each select="mathnl:msqrt">
																								<msqrt>
																									<xsl:sequence select="()"/>
																								</msqrt>
																							</xsl:for-each>
																							<xsl:for-each select="mathnl:mroot">
																								<mroot>
																									<xsl:sequence select="()"/>
																								</mroot>
																							</xsl:for-each>
																							<xsl:for-each select="mathnl:menclose">
																								<menclose>
																									<xsl:sequence select="()"/>
																								</menclose>
																							</xsl:for-each>
																							<xsl:for-each select="mathnl:mpadded">
																								<mpadded>
																									<xsl:sequence select="()"/>
																								</mpadded>
																							</xsl:for-each>
																							<xsl:for-each select="mathnl:mphantom">
																								<mphantom>
																									<xsl:sequence select="()"/>
																								</mphantom>
																							</xsl:for-each>
																							<xsl:for-each select="mathnl:mfenced">
																								<mfenced>
																									<xsl:sequence select="()"/>
																								</mfenced>
																							</xsl:for-each>
																							<xsl:for-each select="mathnl:msub">
																								<msub>
																									<xsl:sequence select="()"/>
																								</msub>
																							</xsl:for-each>
																							<xsl:for-each select="mathnl:msup">
																								<msup>
																									<xsl:for-each select="@xlink:href">
																										<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																									</xsl:for-each>
																									<xsl:for-each select="@class">
																										<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																									</xsl:for-each>
																									<xsl:for-each select="@style">
																										<xsl:attribute name="style" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@id">
																										<xsl:attribute name="id" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@xref">
																										<xsl:attribute name="xref" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="@superscriptshift">
																										<xsl:attribute name="superscriptshift" select="fn:string(.)"/>
																									</xsl:for-each>
																									<xsl:for-each select="mathnl:mi">
																										<mi>
																											<xsl:for-each select="@xlink:href">
																												<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																											</xsl:for-each>
																											<xsl:for-each select="@class">
																												<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																											</xsl:for-each>
																											<xsl:for-each select="@style">
																												<xsl:attribute name="style" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@id">
																												<xsl:attribute name="id" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@xref">
																												<xsl:attribute name="xref" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@mathvariant">
																												<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@mathsize">
																												<xsl:attribute name="mathsize" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@mathcolor">
																												<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@mathbackground">
																												<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="node()">
																												<xsl:if test="fn:boolean(self::text())">
																													<xsl:sequence select="fn:string(.)"/>
																												</xsl:if>
																												<xsl:variable name="var102_test_resultof_node_name_equal_qname" as="node()?">
																													<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																														<xsl:sequence select="."/>
																													</xsl:if>
																												</xsl:variable>
																												<xsl:for-each select="$var102_test_resultof_node_name_equal_qname">
																													<mglyph>
																														<xsl:call-template name="tbf:tbf1_mglyph">
																															<xsl:with-param name="input" select="." as="node()"/>
																														</xsl:call-template>
																													</mglyph>
																												</xsl:for-each>
																												<xsl:variable name="var103_test_resultof_node_name_equal_qname" as="node()?">
																													<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																														<xsl:sequence select="."/>
																													</xsl:if>
																												</xsl:variable>
																												<xsl:for-each select="$var103_test_resultof_node_name_equal_qname">
																													<malignmark>
																														<xsl:for-each select="@edge">
																															<xsl:attribute name="edge" select="fn:string(.)"/>
																														</xsl:for-each>
																													</malignmark>
																												</xsl:for-each>
																											</xsl:for-each>
																										</mi>
																									</xsl:for-each>
																									<xsl:for-each select="mathnl:mn">
																										<mn>
																											<xsl:for-each select="@xlink:href">
																												<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																											</xsl:for-each>
																											<xsl:for-each select="@class">
																												<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																											</xsl:for-each>
																											<xsl:for-each select="@style">
																												<xsl:attribute name="style" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@id">
																												<xsl:attribute name="id" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@xref">
																												<xsl:attribute name="xref" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@mathvariant">
																												<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@mathsize">
																												<xsl:attribute name="mathsize" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@mathcolor">
																												<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@mathbackground">
																												<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="node()">
																												<xsl:if test="fn:boolean(self::text())">
																													<xsl:sequence select="fn:string(.)"/>
																												</xsl:if>
																												<xsl:variable name="var104_test_resultof_node_name_equal_qname" as="node()?">
																													<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																														<xsl:sequence select="."/>
																													</xsl:if>
																												</xsl:variable>
																												<xsl:for-each select="$var104_test_resultof_node_name_equal_qname">
																													<mglyph>
																														<xsl:call-template name="tbf:tbf1_mglyph">
																															<xsl:with-param name="input" select="." as="node()"/>
																														</xsl:call-template>
																													</mglyph>
																												</xsl:for-each>
																												<xsl:variable name="var105_test_resultof_node_name_equal_qname" as="node()?">
																													<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																														<xsl:sequence select="."/>
																													</xsl:if>
																												</xsl:variable>
																												<xsl:for-each select="$var105_test_resultof_node_name_equal_qname">
																													<malignmark>
																														<xsl:for-each select="@edge">
																															<xsl:attribute name="edge" select="fn:string(.)"/>
																														</xsl:for-each>
																													</malignmark>
																												</xsl:for-each>
																											</xsl:for-each>
																										</mn>
																									</xsl:for-each>
																									<xsl:for-each select="mathnl:mo">
																										<mo>
																											<xsl:for-each select="@xlink:href">
																												<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																											</xsl:for-each>
																											<xsl:for-each select="@class">
																												<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																											</xsl:for-each>
																											<xsl:for-each select="@style">
																												<xsl:attribute name="style" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@id">
																												<xsl:attribute name="id" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@xref">
																												<xsl:attribute name="xref" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@mathvariant">
																												<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@mathsize">
																												<xsl:attribute name="mathsize" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@mathcolor">
																												<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@mathbackground">
																												<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@form">
																												<xsl:attribute name="form" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@fence">
																												<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
																											</xsl:for-each>
																											<xsl:for-each select="@separator">
																												<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
																											</xsl:for-each>
																											<xsl:for-each select="@lspace">
																												<xsl:attribute name="lspace" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@rspace">
																												<xsl:attribute name="rspace" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@stretchy">
																												<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
																											</xsl:for-each>
																											<xsl:for-each select="@symmetric">
																												<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
																											</xsl:for-each>
																											<xsl:for-each select="@maxsize">
																												<xsl:attribute name="maxsize" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@minsize">
																												<xsl:attribute name="minsize" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@largeop">
																												<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
																											</xsl:for-each>
																											<xsl:for-each select="@movablelimits">
																												<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
																											</xsl:for-each>
																											<xsl:for-each select="@accent">
																												<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
																											</xsl:for-each>
																											<xsl:for-each select="node()">
																												<xsl:if test="fn:boolean(self::text())">
																													<xsl:sequence select="fn:string(.)"/>
																												</xsl:if>
																												<xsl:variable name="var106_test_resultof_node_name_equal_qname" as="node()?">
																													<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																														<xsl:sequence select="."/>
																													</xsl:if>
																												</xsl:variable>
																												<xsl:for-each select="$var106_test_resultof_node_name_equal_qname">
																													<mglyph>
																														<xsl:call-template name="tbf:tbf1_mglyph">
																															<xsl:with-param name="input" select="." as="node()"/>
																														</xsl:call-template>
																													</mglyph>
																												</xsl:for-each>
																												<xsl:variable name="var107_test_resultof_node_name_equal_qname" as="node()?">
																													<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																														<xsl:sequence select="."/>
																													</xsl:if>
																												</xsl:variable>
																												<xsl:for-each select="$var107_test_resultof_node_name_equal_qname">
																													<malignmark>
																														<xsl:for-each select="@edge">
																															<xsl:attribute name="edge" select="fn:string(.)"/>
																														</xsl:for-each>
																													</malignmark>
																												</xsl:for-each>
																											</xsl:for-each>
																										</mo>
																									</xsl:for-each>
																									<xsl:for-each select="mathnl:mtext">
																										<mtext>
																											<xsl:for-each select="@xlink:href">
																												<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																											</xsl:for-each>
																											<xsl:for-each select="@class">
																												<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																											</xsl:for-each>
																											<xsl:for-each select="@style">
																												<xsl:attribute name="style" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@id">
																												<xsl:attribute name="id" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@xref">
																												<xsl:attribute name="xref" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@mathvariant">
																												<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@mathsize">
																												<xsl:attribute name="mathsize" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@mathcolor">
																												<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@mathbackground">
																												<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="node()">
																												<xsl:if test="fn:boolean(self::text())">
																													<xsl:sequence select="fn:string(.)"/>
																												</xsl:if>
																												<xsl:variable name="var108_test_resultof_node_name_equal_qname" as="node()?">
																													<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																														<xsl:sequence select="."/>
																													</xsl:if>
																												</xsl:variable>
																												<xsl:for-each select="$var108_test_resultof_node_name_equal_qname">
																													<mglyph>
																														<xsl:call-template name="tbf:tbf1_mglyph">
																															<xsl:with-param name="input" select="." as="node()"/>
																														</xsl:call-template>
																													</mglyph>
																												</xsl:for-each>
																												<xsl:variable name="var109_test_resultof_node_name_equal_qname" as="node()?">
																													<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																														<xsl:sequence select="."/>
																													</xsl:if>
																												</xsl:variable>
																												<xsl:for-each select="$var109_test_resultof_node_name_equal_qname">
																													<malignmark>
																														<xsl:for-each select="@edge">
																															<xsl:attribute name="edge" select="fn:string(.)"/>
																														</xsl:for-each>
																													</malignmark>
																												</xsl:for-each>
																											</xsl:for-each>
																										</mtext>
																									</xsl:for-each>
																									<xsl:for-each select="mathnl:ms">
																										<ms>
																											<xsl:for-each select="@xlink:href">
																												<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																											</xsl:for-each>
																											<xsl:for-each select="@class">
																												<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																											</xsl:for-each>
																											<xsl:for-each select="@style">
																												<xsl:attribute name="style" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@id">
																												<xsl:attribute name="id" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@xref">
																												<xsl:attribute name="xref" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@mathvariant">
																												<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@mathsize">
																												<xsl:attribute name="mathsize" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@mathcolor">
																												<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@mathbackground">
																												<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@lquote">
																												<xsl:attribute name="lquote" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@rquote">
																												<xsl:attribute name="rquote" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="node()">
																												<xsl:if test="fn:boolean(self::text())">
																													<xsl:sequence select="fn:string(.)"/>
																												</xsl:if>
																												<xsl:variable name="var110_test_resultof_node_name_equal_qname" as="node()?">
																													<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																														<xsl:sequence select="."/>
																													</xsl:if>
																												</xsl:variable>
																												<xsl:for-each select="$var110_test_resultof_node_name_equal_qname">
																													<mglyph>
																														<xsl:call-template name="tbf:tbf1_mglyph">
																															<xsl:with-param name="input" select="." as="node()"/>
																														</xsl:call-template>
																													</mglyph>
																												</xsl:for-each>
																												<xsl:variable name="var111_test_resultof_node_name_equal_qname" as="node()?">
																													<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																														<xsl:sequence select="."/>
																													</xsl:if>
																												</xsl:variable>
																												<xsl:for-each select="$var111_test_resultof_node_name_equal_qname">
																													<malignmark>
																														<xsl:for-each select="@edge">
																															<xsl:attribute name="edge" select="fn:string(.)"/>
																														</xsl:for-each>
																													</malignmark>
																												</xsl:for-each>
																											</xsl:for-each>
																										</ms>
																									</xsl:for-each>
																									<xsl:for-each select="mathnl:mrow">
																										<mrow>
																											<xsl:sequence select="()"/>
																										</mrow>
																									</xsl:for-each>
																									<xsl:for-each select="mathnl:mfrac">
																										<mfrac>
																											<xsl:sequence select="()"/>
																										</mfrac>
																									</xsl:for-each>
																									<xsl:for-each select="mathnl:msqrt">
																										<msqrt>
																											<xsl:sequence select="()"/>
																										</msqrt>
																									</xsl:for-each>
																									<xsl:for-each select="mathnl:mroot">
																										<mroot>
																											<xsl:sequence select="()"/>
																										</mroot>
																									</xsl:for-each>
																									<xsl:for-each select="mathnl:menclose">
																										<menclose>
																											<xsl:sequence select="()"/>
																										</menclose>
																									</xsl:for-each>
																									<xsl:for-each select="mathnl:mpadded">
																										<mpadded>
																											<xsl:sequence select="()"/>
																										</mpadded>
																									</xsl:for-each>
																									<xsl:for-each select="mathnl:mphantom">
																										<mphantom>
																											<xsl:sequence select="()"/>
																										</mphantom>
																									</xsl:for-each>
																									<xsl:for-each select="mathnl:mfenced">
																										<mfenced>
																											<xsl:sequence select="()"/>
																										</mfenced>
																									</xsl:for-each>
																									<xsl:for-each select="mathnl:msub">
																										<msub>
																											<xsl:sequence select="()"/>
																										</msub>
																									</xsl:for-each>
																									<xsl:for-each select="mathnl:msup">
																										<msup>
																											<xsl:sequence select="()"/>
																										</msup>
																									</xsl:for-each>
																									<xsl:for-each select="mathnl:msubsup">
																										<msubsup>
																											<xsl:for-each select="@xlink:href">
																												<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																											</xsl:for-each>
																											<xsl:for-each select="@class">
																												<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																											</xsl:for-each>
																											<xsl:for-each select="@style">
																												<xsl:attribute name="style" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@id">
																												<xsl:attribute name="id" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@xref">
																												<xsl:attribute name="xref" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@subscriptshift">
																												<xsl:attribute name="subscriptshift" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="@superscriptshift">
																												<xsl:attribute name="superscriptshift" select="fn:string(.)"/>
																											</xsl:for-each>
																											<xsl:for-each select="mathnl:mi">
																												<mi>
																													<xsl:for-each select="@xlink:href">
																														<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																													</xsl:for-each>
																													<xsl:for-each select="@class">
																														<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																													</xsl:for-each>
																													<xsl:for-each select="@style">
																														<xsl:attribute name="style" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@id">
																														<xsl:attribute name="id" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@xref">
																														<xsl:attribute name="xref" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@mathvariant">
																														<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@mathsize">
																														<xsl:attribute name="mathsize" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@mathcolor">
																														<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@mathbackground">
																														<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="node()">
																														<xsl:if test="fn:boolean(self::text())">
																															<xsl:sequence select="fn:string(.)"/>
																														</xsl:if>
																														<xsl:variable name="var112_test_resultof_node_name_equal_qname" as="node()?">
																															<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																<xsl:sequence select="."/>
																															</xsl:if>
																														</xsl:variable>
																														<xsl:for-each select="$var112_test_resultof_node_name_equal_qname">
																															<mglyph>
																																<xsl:call-template name="tbf:tbf1_mglyph">
																																	<xsl:with-param name="input" select="." as="node()"/>
																																</xsl:call-template>
																															</mglyph>
																														</xsl:for-each>
																														<xsl:variable name="var113_test_resultof_node_name_equal_qname" as="node()?">
																															<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																<xsl:sequence select="."/>
																															</xsl:if>
																														</xsl:variable>
																														<xsl:for-each select="$var113_test_resultof_node_name_equal_qname">
																															<malignmark>
																																<xsl:for-each select="@edge">
																																	<xsl:attribute name="edge" select="fn:string(.)"/>
																																</xsl:for-each>
																															</malignmark>
																														</xsl:for-each>
																													</xsl:for-each>
																												</mi>
																											</xsl:for-each>
																											<xsl:for-each select="mathnl:mn">
																												<mn>
																													<xsl:for-each select="@xlink:href">
																														<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																													</xsl:for-each>
																													<xsl:for-each select="@class">
																														<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																													</xsl:for-each>
																													<xsl:for-each select="@style">
																														<xsl:attribute name="style" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@id">
																														<xsl:attribute name="id" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@xref">
																														<xsl:attribute name="xref" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@mathvariant">
																														<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@mathsize">
																														<xsl:attribute name="mathsize" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@mathcolor">
																														<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@mathbackground">
																														<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="node()">
																														<xsl:if test="fn:boolean(self::text())">
																															<xsl:sequence select="fn:string(.)"/>
																														</xsl:if>
																														<xsl:variable name="var114_test_resultof_node_name_equal_qname" as="node()?">
																															<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																<xsl:sequence select="."/>
																															</xsl:if>
																														</xsl:variable>
																														<xsl:for-each select="$var114_test_resultof_node_name_equal_qname">
																															<mglyph>
																																<xsl:call-template name="tbf:tbf1_mglyph">
																																	<xsl:with-param name="input" select="." as="node()"/>
																																</xsl:call-template>
																															</mglyph>
																														</xsl:for-each>
																														<xsl:variable name="var115_test_resultof_node_name_equal_qname" as="node()?">
																															<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																<xsl:sequence select="."/>
																															</xsl:if>
																														</xsl:variable>
																														<xsl:for-each select="$var115_test_resultof_node_name_equal_qname">
																															<malignmark>
																																<xsl:for-each select="@edge">
																																	<xsl:attribute name="edge" select="fn:string(.)"/>
																																</xsl:for-each>
																															</malignmark>
																														</xsl:for-each>
																													</xsl:for-each>
																												</mn>
																											</xsl:for-each>
																											<xsl:for-each select="mathnl:mo">
																												<mo>
																													<xsl:for-each select="@xlink:href">
																														<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																													</xsl:for-each>
																													<xsl:for-each select="@class">
																														<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																													</xsl:for-each>
																													<xsl:for-each select="@style">
																														<xsl:attribute name="style" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@id">
																														<xsl:attribute name="id" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@xref">
																														<xsl:attribute name="xref" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@mathvariant">
																														<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@mathsize">
																														<xsl:attribute name="mathsize" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@mathcolor">
																														<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@mathbackground">
																														<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@form">
																														<xsl:attribute name="form" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@fence">
																														<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
																													</xsl:for-each>
																													<xsl:for-each select="@separator">
																														<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
																													</xsl:for-each>
																													<xsl:for-each select="@lspace">
																														<xsl:attribute name="lspace" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@rspace">
																														<xsl:attribute name="rspace" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@stretchy">
																														<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
																													</xsl:for-each>
																													<xsl:for-each select="@symmetric">
																														<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
																													</xsl:for-each>
																													<xsl:for-each select="@maxsize">
																														<xsl:attribute name="maxsize" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@minsize">
																														<xsl:attribute name="minsize" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@largeop">
																														<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
																													</xsl:for-each>
																													<xsl:for-each select="@movablelimits">
																														<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
																													</xsl:for-each>
																													<xsl:for-each select="@accent">
																														<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
																													</xsl:for-each>
																													<xsl:for-each select="node()">
																														<xsl:if test="fn:boolean(self::text())">
																															<xsl:sequence select="fn:string(.)"/>
																														</xsl:if>
																														<xsl:variable name="var116_test_resultof_node_name_equal_qname" as="node()?">
																															<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																<xsl:sequence select="."/>
																															</xsl:if>
																														</xsl:variable>
																														<xsl:for-each select="$var116_test_resultof_node_name_equal_qname">
																															<mglyph>
																																<xsl:call-template name="tbf:tbf1_mglyph">
																																	<xsl:with-param name="input" select="." as="node()"/>
																																</xsl:call-template>
																															</mglyph>
																														</xsl:for-each>
																														<xsl:variable name="var117_test_resultof_node_name_equal_qname" as="node()?">
																															<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																<xsl:sequence select="."/>
																															</xsl:if>
																														</xsl:variable>
																														<xsl:for-each select="$var117_test_resultof_node_name_equal_qname">
																															<malignmark>
																																<xsl:for-each select="@edge">
																																	<xsl:attribute name="edge" select="fn:string(.)"/>
																																</xsl:for-each>
																															</malignmark>
																														</xsl:for-each>
																													</xsl:for-each>
																												</mo>
																											</xsl:for-each>
																											<xsl:for-each select="mathnl:mtext">
																												<mtext>
																													<xsl:for-each select="@xlink:href">
																														<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																													</xsl:for-each>
																													<xsl:for-each select="@class">
																														<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																													</xsl:for-each>
																													<xsl:for-each select="@style">
																														<xsl:attribute name="style" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@id">
																														<xsl:attribute name="id" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@xref">
																														<xsl:attribute name="xref" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@mathvariant">
																														<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@mathsize">
																														<xsl:attribute name="mathsize" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@mathcolor">
																														<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@mathbackground">
																														<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="node()">
																														<xsl:if test="fn:boolean(self::text())">
																															<xsl:sequence select="fn:string(.)"/>
																														</xsl:if>
																														<xsl:variable name="var118_test_resultof_node_name_equal_qname" as="node()?">
																															<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																<xsl:sequence select="."/>
																															</xsl:if>
																														</xsl:variable>
																														<xsl:for-each select="$var118_test_resultof_node_name_equal_qname">
																															<mglyph>
																																<xsl:call-template name="tbf:tbf1_mglyph">
																																	<xsl:with-param name="input" select="." as="node()"/>
																																</xsl:call-template>
																															</mglyph>
																														</xsl:for-each>
																														<xsl:variable name="var119_test_resultof_node_name_equal_qname" as="node()?">
																															<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																<xsl:sequence select="."/>
																															</xsl:if>
																														</xsl:variable>
																														<xsl:for-each select="$var119_test_resultof_node_name_equal_qname">
																															<malignmark>
																																<xsl:for-each select="@edge">
																																	<xsl:attribute name="edge" select="fn:string(.)"/>
																																</xsl:for-each>
																															</malignmark>
																														</xsl:for-each>
																													</xsl:for-each>
																												</mtext>
																											</xsl:for-each>
																											<xsl:for-each select="mathnl:ms">
																												<ms>
																													<xsl:for-each select="@xlink:href">
																														<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																													</xsl:for-each>
																													<xsl:for-each select="@class">
																														<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																													</xsl:for-each>
																													<xsl:for-each select="@style">
																														<xsl:attribute name="style" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@id">
																														<xsl:attribute name="id" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@xref">
																														<xsl:attribute name="xref" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@mathvariant">
																														<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@mathsize">
																														<xsl:attribute name="mathsize" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@mathcolor">
																														<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@mathbackground">
																														<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@lquote">
																														<xsl:attribute name="lquote" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@rquote">
																														<xsl:attribute name="rquote" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="node()">
																														<xsl:if test="fn:boolean(self::text())">
																															<xsl:sequence select="fn:string(.)"/>
																														</xsl:if>
																														<xsl:variable name="var120_test_resultof_node_name_equal_qname" as="node()?">
																															<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																<xsl:sequence select="."/>
																															</xsl:if>
																														</xsl:variable>
																														<xsl:for-each select="$var120_test_resultof_node_name_equal_qname">
																															<mglyph>
																																<xsl:call-template name="tbf:tbf1_mglyph">
																																	<xsl:with-param name="input" select="." as="node()"/>
																																</xsl:call-template>
																															</mglyph>
																														</xsl:for-each>
																														<xsl:variable name="var121_test_resultof_node_name_equal_qname" as="node()?">
																															<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																<xsl:sequence select="."/>
																															</xsl:if>
																														</xsl:variable>
																														<xsl:for-each select="$var121_test_resultof_node_name_equal_qname">
																															<malignmark>
																																<xsl:for-each select="@edge">
																																	<xsl:attribute name="edge" select="fn:string(.)"/>
																																</xsl:for-each>
																															</malignmark>
																														</xsl:for-each>
																													</xsl:for-each>
																												</ms>
																											</xsl:for-each>
																											<xsl:for-each select="mathnl:mrow">
																												<mrow>
																													<xsl:sequence select="()"/>
																												</mrow>
																											</xsl:for-each>
																											<xsl:for-each select="mathnl:mfrac">
																												<mfrac>
																													<xsl:sequence select="()"/>
																												</mfrac>
																											</xsl:for-each>
																											<xsl:for-each select="mathnl:msqrt">
																												<msqrt>
																													<xsl:sequence select="()"/>
																												</msqrt>
																											</xsl:for-each>
																											<xsl:for-each select="mathnl:mroot">
																												<mroot>
																													<xsl:sequence select="()"/>
																												</mroot>
																											</xsl:for-each>
																											<xsl:for-each select="mathnl:menclose">
																												<menclose>
																													<xsl:sequence select="()"/>
																												</menclose>
																											</xsl:for-each>
																											<xsl:for-each select="mathnl:mpadded">
																												<mpadded>
																													<xsl:sequence select="()"/>
																												</mpadded>
																											</xsl:for-each>
																											<xsl:for-each select="mathnl:mphantom">
																												<mphantom>
																													<xsl:sequence select="()"/>
																												</mphantom>
																											</xsl:for-each>
																											<xsl:for-each select="mathnl:mfenced">
																												<mfenced>
																													<xsl:sequence select="()"/>
																												</mfenced>
																											</xsl:for-each>
																											<xsl:for-each select="mathnl:msub">
																												<msub>
																													<xsl:sequence select="()"/>
																												</msub>
																											</xsl:for-each>
																											<xsl:for-each select="mathnl:msup">
																												<msup>
																													<xsl:sequence select="()"/>
																												</msup>
																											</xsl:for-each>
																											<xsl:for-each select="mathnl:msubsup">
																												<msubsup>
																													<xsl:sequence select="()"/>
																												</msubsup>
																											</xsl:for-each>
																											<xsl:for-each select="mathnl:munder">
																												<munder>
																													<xsl:for-each select="@xlink:href">
																														<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																													</xsl:for-each>
																													<xsl:for-each select="@class">
																														<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																													</xsl:for-each>
																													<xsl:for-each select="@style">
																														<xsl:attribute name="style" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@id">
																														<xsl:attribute name="id" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@xref">
																														<xsl:attribute name="xref" select="fn:string(.)"/>
																													</xsl:for-each>
																													<xsl:for-each select="@accentunder">
																														<xsl:attribute name="accentunder" select="xs:string(xs:boolean(fn:string(.)))"/>
																													</xsl:for-each>
																													<xsl:for-each select="mathnl:mi">
																														<mi>
																															<xsl:for-each select="@xlink:href">
																																<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																															</xsl:for-each>
																															<xsl:for-each select="@class">
																																<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																															</xsl:for-each>
																															<xsl:for-each select="@style">
																																<xsl:attribute name="style" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@id">
																																<xsl:attribute name="id" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@xref">
																																<xsl:attribute name="xref" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@mathvariant">
																																<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@mathsize">
																																<xsl:attribute name="mathsize" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@mathcolor">
																																<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@mathbackground">
																																<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="node()">
																																<xsl:if test="fn:boolean(self::text())">
																																	<xsl:sequence select="fn:string(.)"/>
																																</xsl:if>
																																<xsl:variable name="var122_test_resultof_node_name_equal_qname" as="node()?">
																																	<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																		<xsl:sequence select="."/>
																																	</xsl:if>
																																</xsl:variable>
																																<xsl:for-each select="$var122_test_resultof_node_name_equal_qname">
																																	<mglyph>
																																		<xsl:call-template name="tbf:tbf1_mglyph">
																																			<xsl:with-param name="input" select="." as="node()"/>
																																		</xsl:call-template>
																																	</mglyph>
																																</xsl:for-each>
																																<xsl:variable name="var123_test_resultof_node_name_equal_qname" as="node()?">
																																	<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																		<xsl:sequence select="."/>
																																	</xsl:if>
																																</xsl:variable>
																																<xsl:for-each select="$var123_test_resultof_node_name_equal_qname">
																																	<malignmark>
																																		<xsl:for-each select="@edge">
																																			<xsl:attribute name="edge" select="fn:string(.)"/>
																																		</xsl:for-each>
																																	</malignmark>
																																</xsl:for-each>
																															</xsl:for-each>
																														</mi>
																													</xsl:for-each>
																													<xsl:for-each select="mathnl:mn">
																														<mn>
																															<xsl:for-each select="@xlink:href">
																																<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																															</xsl:for-each>
																															<xsl:for-each select="@class">
																																<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																															</xsl:for-each>
																															<xsl:for-each select="@style">
																																<xsl:attribute name="style" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@id">
																																<xsl:attribute name="id" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@xref">
																																<xsl:attribute name="xref" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@mathvariant">
																																<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@mathsize">
																																<xsl:attribute name="mathsize" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@mathcolor">
																																<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@mathbackground">
																																<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="node()">
																																<xsl:if test="fn:boolean(self::text())">
																																	<xsl:sequence select="fn:string(.)"/>
																																</xsl:if>
																																<xsl:variable name="var124_test_resultof_node_name_equal_qname" as="node()?">
																																	<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																		<xsl:sequence select="."/>
																																	</xsl:if>
																																</xsl:variable>
																																<xsl:for-each select="$var124_test_resultof_node_name_equal_qname">
																																	<mglyph>
																																		<xsl:call-template name="tbf:tbf1_mglyph">
																																			<xsl:with-param name="input" select="." as="node()"/>
																																		</xsl:call-template>
																																	</mglyph>
																																</xsl:for-each>
																																<xsl:variable name="var125_test_resultof_node_name_equal_qname" as="node()?">
																																	<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																		<xsl:sequence select="."/>
																																	</xsl:if>
																																</xsl:variable>
																																<xsl:for-each select="$var125_test_resultof_node_name_equal_qname">
																																	<malignmark>
																																		<xsl:for-each select="@edge">
																																			<xsl:attribute name="edge" select="fn:string(.)"/>
																																		</xsl:for-each>
																																	</malignmark>
																																</xsl:for-each>
																															</xsl:for-each>
																														</mn>
																													</xsl:for-each>
																													<xsl:for-each select="mathnl:mo">
																														<mo>
																															<xsl:for-each select="@xlink:href">
																																<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																															</xsl:for-each>
																															<xsl:for-each select="@class">
																																<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																															</xsl:for-each>
																															<xsl:for-each select="@style">
																																<xsl:attribute name="style" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@id">
																																<xsl:attribute name="id" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@xref">
																																<xsl:attribute name="xref" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@mathvariant">
																																<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@mathsize">
																																<xsl:attribute name="mathsize" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@mathcolor">
																																<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@mathbackground">
																																<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@form">
																																<xsl:attribute name="form" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@fence">
																																<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
																															</xsl:for-each>
																															<xsl:for-each select="@separator">
																																<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
																															</xsl:for-each>
																															<xsl:for-each select="@lspace">
																																<xsl:attribute name="lspace" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@rspace">
																																<xsl:attribute name="rspace" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@stretchy">
																																<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
																															</xsl:for-each>
																															<xsl:for-each select="@symmetric">
																																<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
																															</xsl:for-each>
																															<xsl:for-each select="@maxsize">
																																<xsl:attribute name="maxsize" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@minsize">
																																<xsl:attribute name="minsize" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@largeop">
																																<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
																															</xsl:for-each>
																															<xsl:for-each select="@movablelimits">
																																<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
																															</xsl:for-each>
																															<xsl:for-each select="@accent">
																																<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
																															</xsl:for-each>
																															<xsl:for-each select="node()">
																																<xsl:if test="fn:boolean(self::text())">
																																	<xsl:sequence select="fn:string(.)"/>
																																</xsl:if>
																																<xsl:variable name="var126_test_resultof_node_name_equal_qname" as="node()?">
																																	<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																		<xsl:sequence select="."/>
																																	</xsl:if>
																																</xsl:variable>
																																<xsl:for-each select="$var126_test_resultof_node_name_equal_qname">
																																	<mglyph>
																																		<xsl:call-template name="tbf:tbf1_mglyph">
																																			<xsl:with-param name="input" select="." as="node()"/>
																																		</xsl:call-template>
																																	</mglyph>
																																</xsl:for-each>
																																<xsl:variable name="var127_test_resultof_node_name_equal_qname" as="node()?">
																																	<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																		<xsl:sequence select="."/>
																																	</xsl:if>
																																</xsl:variable>
																																<xsl:for-each select="$var127_test_resultof_node_name_equal_qname">
																																	<malignmark>
																																		<xsl:for-each select="@edge">
																																			<xsl:attribute name="edge" select="fn:string(.)"/>
																																		</xsl:for-each>
																																	</malignmark>
																																</xsl:for-each>
																															</xsl:for-each>
																														</mo>
																													</xsl:for-each>
																													<xsl:for-each select="mathnl:mtext">
																														<mtext>
																															<xsl:for-each select="@xlink:href">
																																<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																															</xsl:for-each>
																															<xsl:for-each select="@class">
																																<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																															</xsl:for-each>
																															<xsl:for-each select="@style">
																																<xsl:attribute name="style" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@id">
																																<xsl:attribute name="id" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@xref">
																																<xsl:attribute name="xref" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@mathvariant">
																																<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@mathsize">
																																<xsl:attribute name="mathsize" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@mathcolor">
																																<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@mathbackground">
																																<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="node()">
																																<xsl:if test="fn:boolean(self::text())">
																																	<xsl:sequence select="fn:string(.)"/>
																																</xsl:if>
																																<xsl:variable name="var128_test_resultof_node_name_equal_qname" as="node()?">
																																	<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																		<xsl:sequence select="."/>
																																	</xsl:if>
																																</xsl:variable>
																																<xsl:for-each select="$var128_test_resultof_node_name_equal_qname">
																																	<mglyph>
																																		<xsl:call-template name="tbf:tbf1_mglyph">
																																			<xsl:with-param name="input" select="." as="node()"/>
																																		</xsl:call-template>
																																	</mglyph>
																																</xsl:for-each>
																																<xsl:variable name="var129_test_resultof_node_name_equal_qname" as="node()?">
																																	<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																		<xsl:sequence select="."/>
																																	</xsl:if>
																																</xsl:variable>
																																<xsl:for-each select="$var129_test_resultof_node_name_equal_qname">
																																	<malignmark>
																																		<xsl:for-each select="@edge">
																																			<xsl:attribute name="edge" select="fn:string(.)"/>
																																		</xsl:for-each>
																																	</malignmark>
																																</xsl:for-each>
																															</xsl:for-each>
																														</mtext>
																													</xsl:for-each>
																													<xsl:for-each select="mathnl:ms">
																														<ms>
																															<xsl:for-each select="@xlink:href">
																																<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																															</xsl:for-each>
																															<xsl:for-each select="@class">
																																<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																															</xsl:for-each>
																															<xsl:for-each select="@style">
																																<xsl:attribute name="style" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@id">
																																<xsl:attribute name="id" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@xref">
																																<xsl:attribute name="xref" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@mathvariant">
																																<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@mathsize">
																																<xsl:attribute name="mathsize" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@mathcolor">
																																<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@mathbackground">
																																<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@lquote">
																																<xsl:attribute name="lquote" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@rquote">
																																<xsl:attribute name="rquote" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="node()">
																																<xsl:if test="fn:boolean(self::text())">
																																	<xsl:sequence select="fn:string(.)"/>
																																</xsl:if>
																																<xsl:variable name="var130_test_resultof_node_name_equal_qname" as="node()?">
																																	<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																		<xsl:sequence select="."/>
																																	</xsl:if>
																																</xsl:variable>
																																<xsl:for-each select="$var130_test_resultof_node_name_equal_qname">
																																	<mglyph>
																																		<xsl:call-template name="tbf:tbf1_mglyph">
																																			<xsl:with-param name="input" select="." as="node()"/>
																																		</xsl:call-template>
																																	</mglyph>
																																</xsl:for-each>
																																<xsl:variable name="var131_test_resultof_node_name_equal_qname" as="node()?">
																																	<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																		<xsl:sequence select="."/>
																																	</xsl:if>
																																</xsl:variable>
																																<xsl:for-each select="$var131_test_resultof_node_name_equal_qname">
																																	<malignmark>
																																		<xsl:for-each select="@edge">
																																			<xsl:attribute name="edge" select="fn:string(.)"/>
																																		</xsl:for-each>
																																	</malignmark>
																																</xsl:for-each>
																															</xsl:for-each>
																														</ms>
																													</xsl:for-each>
																													<xsl:for-each select="mathnl:mrow">
																														<mrow>
																															<xsl:sequence select="()"/>
																														</mrow>
																													</xsl:for-each>
																													<xsl:for-each select="mathnl:mfrac">
																														<mfrac>
																															<xsl:sequence select="()"/>
																														</mfrac>
																													</xsl:for-each>
																													<xsl:for-each select="mathnl:msqrt">
																														<msqrt>
																															<xsl:sequence select="()"/>
																														</msqrt>
																													</xsl:for-each>
																													<xsl:for-each select="mathnl:mroot">
																														<mroot>
																															<xsl:sequence select="()"/>
																														</mroot>
																													</xsl:for-each>
																													<xsl:for-each select="mathnl:menclose">
																														<menclose>
																															<xsl:sequence select="()"/>
																														</menclose>
																													</xsl:for-each>
																													<xsl:for-each select="mathnl:mpadded">
																														<mpadded>
																															<xsl:sequence select="()"/>
																														</mpadded>
																													</xsl:for-each>
																													<xsl:for-each select="mathnl:mphantom">
																														<mphantom>
																															<xsl:sequence select="()"/>
																														</mphantom>
																													</xsl:for-each>
																													<xsl:for-each select="mathnl:mfenced">
																														<mfenced>
																															<xsl:sequence select="()"/>
																														</mfenced>
																													</xsl:for-each>
																													<xsl:for-each select="mathnl:msub">
																														<msub>
																															<xsl:sequence select="()"/>
																														</msub>
																													</xsl:for-each>
																													<xsl:for-each select="mathnl:msup">
																														<msup>
																															<xsl:sequence select="()"/>
																														</msup>
																													</xsl:for-each>
																													<xsl:for-each select="mathnl:msubsup">
																														<msubsup>
																															<xsl:sequence select="()"/>
																														</msubsup>
																													</xsl:for-each>
																													<xsl:for-each select="mathnl:munder">
																														<munder>
																															<xsl:sequence select="()"/>
																														</munder>
																													</xsl:for-each>
																													<xsl:for-each select="mathnl:mover">
																														<mover>
																															<xsl:for-each select="@xlink:href">
																																<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																															</xsl:for-each>
																															<xsl:for-each select="@class">
																																<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																															</xsl:for-each>
																															<xsl:for-each select="@style">
																																<xsl:attribute name="style" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@id">
																																<xsl:attribute name="id" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@xref">
																																<xsl:attribute name="xref" select="fn:string(.)"/>
																															</xsl:for-each>
																															<xsl:for-each select="@accent">
																																<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
																															</xsl:for-each>
																															<xsl:for-each select="mathnl:mi">
																																<mi>
																																	<xsl:for-each select="@xlink:href">
																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@class">
																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@style">
																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@id">
																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@xref">
																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@mathvariant">
																																		<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@mathsize">
																																		<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@mathcolor">
																																		<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@mathbackground">
																																		<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="node()">
																																		<xsl:if test="fn:boolean(self::text())">
																																			<xsl:sequence select="fn:string(.)"/>
																																		</xsl:if>
																																		<xsl:variable name="var132_test_resultof_node_name_equal_qname" as="node()?">
																																			<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																				<xsl:sequence select="."/>
																																			</xsl:if>
																																		</xsl:variable>
																																		<xsl:for-each select="$var132_test_resultof_node_name_equal_qname">
																																			<mglyph>
																																				<xsl:call-template name="tbf:tbf1_mglyph">
																																					<xsl:with-param name="input" select="." as="node()"/>
																																				</xsl:call-template>
																																			</mglyph>
																																		</xsl:for-each>
																																		<xsl:variable name="var133_test_resultof_node_name_equal_qname" as="node()?">
																																			<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																				<xsl:sequence select="."/>
																																			</xsl:if>
																																		</xsl:variable>
																																		<xsl:for-each select="$var133_test_resultof_node_name_equal_qname">
																																			<malignmark>
																																				<xsl:for-each select="@edge">
																																					<xsl:attribute name="edge" select="fn:string(.)"/>
																																				</xsl:for-each>
																																			</malignmark>
																																		</xsl:for-each>
																																	</xsl:for-each>
																																</mi>
																															</xsl:for-each>
																															<xsl:for-each select="mathnl:mn">
																																<mn>
																																	<xsl:for-each select="@xlink:href">
																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@class">
																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@style">
																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@id">
																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@xref">
																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@mathvariant">
																																		<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@mathsize">
																																		<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@mathcolor">
																																		<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@mathbackground">
																																		<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="node()">
																																		<xsl:if test="fn:boolean(self::text())">
																																			<xsl:sequence select="fn:string(.)"/>
																																		</xsl:if>
																																		<xsl:variable name="var134_test_resultof_node_name_equal_qname" as="node()?">
																																			<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																				<xsl:sequence select="."/>
																																			</xsl:if>
																																		</xsl:variable>
																																		<xsl:for-each select="$var134_test_resultof_node_name_equal_qname">
																																			<mglyph>
																																				<xsl:call-template name="tbf:tbf1_mglyph">
																																					<xsl:with-param name="input" select="." as="node()"/>
																																				</xsl:call-template>
																																			</mglyph>
																																		</xsl:for-each>
																																		<xsl:variable name="var135_test_resultof_node_name_equal_qname" as="node()?">
																																			<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																				<xsl:sequence select="."/>
																																			</xsl:if>
																																		</xsl:variable>
																																		<xsl:for-each select="$var135_test_resultof_node_name_equal_qname">
																																			<malignmark>
																																				<xsl:for-each select="@edge">
																																					<xsl:attribute name="edge" select="fn:string(.)"/>
																																				</xsl:for-each>
																																			</malignmark>
																																		</xsl:for-each>
																																	</xsl:for-each>
																																</mn>
																															</xsl:for-each>
																															<xsl:for-each select="mathnl:mo">
																																<mo>
																																	<xsl:for-each select="@xlink:href">
																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@class">
																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@style">
																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@id">
																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@xref">
																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@mathvariant">
																																		<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@mathsize">
																																		<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@mathcolor">
																																		<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@mathbackground">
																																		<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@form">
																																		<xsl:attribute name="form" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@fence">
																																		<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@separator">
																																		<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@lspace">
																																		<xsl:attribute name="lspace" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@rspace">
																																		<xsl:attribute name="rspace" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@stretchy">
																																		<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@symmetric">
																																		<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@maxsize">
																																		<xsl:attribute name="maxsize" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@minsize">
																																		<xsl:attribute name="minsize" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@largeop">
																																		<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@movablelimits">
																																		<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@accent">
																																		<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="node()">
																																		<xsl:if test="fn:boolean(self::text())">
																																			<xsl:sequence select="fn:string(.)"/>
																																		</xsl:if>
																																		<xsl:variable name="var136_test_resultof_node_name_equal_qname" as="node()?">
																																			<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																				<xsl:sequence select="."/>
																																			</xsl:if>
																																		</xsl:variable>
																																		<xsl:for-each select="$var136_test_resultof_node_name_equal_qname">
																																			<mglyph>
																																				<xsl:call-template name="tbf:tbf1_mglyph">
																																					<xsl:with-param name="input" select="." as="node()"/>
																																				</xsl:call-template>
																																			</mglyph>
																																		</xsl:for-each>
																																		<xsl:variable name="var137_test_resultof_node_name_equal_qname" as="node()?">
																																			<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																				<xsl:sequence select="."/>
																																			</xsl:if>
																																		</xsl:variable>
																																		<xsl:for-each select="$var137_test_resultof_node_name_equal_qname">
																																			<malignmark>
																																				<xsl:for-each select="@edge">
																																					<xsl:attribute name="edge" select="fn:string(.)"/>
																																				</xsl:for-each>
																																			</malignmark>
																																		</xsl:for-each>
																																	</xsl:for-each>
																																</mo>
																															</xsl:for-each>
																															<xsl:for-each select="mathnl:mtext">
																																<mtext>
																																	<xsl:for-each select="@xlink:href">
																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@class">
																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@style">
																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@id">
																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@xref">
																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@mathvariant">
																																		<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@mathsize">
																																		<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@mathcolor">
																																		<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@mathbackground">
																																		<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="node()">
																																		<xsl:if test="fn:boolean(self::text())">
																																			<xsl:sequence select="fn:string(.)"/>
																																		</xsl:if>
																																		<xsl:variable name="var138_test_resultof_node_name_equal_qname" as="node()?">
																																			<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																				<xsl:sequence select="."/>
																																			</xsl:if>
																																		</xsl:variable>
																																		<xsl:for-each select="$var138_test_resultof_node_name_equal_qname">
																																			<mglyph>
																																				<xsl:call-template name="tbf:tbf1_mglyph">
																																					<xsl:with-param name="input" select="." as="node()"/>
																																				</xsl:call-template>
																																			</mglyph>
																																		</xsl:for-each>
																																		<xsl:variable name="var139_test_resultof_node_name_equal_qname" as="node()?">
																																			<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																				<xsl:sequence select="."/>
																																			</xsl:if>
																																		</xsl:variable>
																																		<xsl:for-each select="$var139_test_resultof_node_name_equal_qname">
																																			<malignmark>
																																				<xsl:for-each select="@edge">
																																					<xsl:attribute name="edge" select="fn:string(.)"/>
																																				</xsl:for-each>
																																			</malignmark>
																																		</xsl:for-each>
																																	</xsl:for-each>
																																</mtext>
																															</xsl:for-each>
																															<xsl:for-each select="mathnl:ms">
																																<ms>
																																	<xsl:for-each select="@xlink:href">
																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@class">
																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@style">
																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@id">
																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@xref">
																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@mathvariant">
																																		<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@mathsize">
																																		<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@mathcolor">
																																		<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@mathbackground">
																																		<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@lquote">
																																		<xsl:attribute name="lquote" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@rquote">
																																		<xsl:attribute name="rquote" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="node()">
																																		<xsl:if test="fn:boolean(self::text())">
																																			<xsl:sequence select="fn:string(.)"/>
																																		</xsl:if>
																																		<xsl:variable name="var140_test_resultof_node_name_equal_qname" as="node()?">
																																			<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																				<xsl:sequence select="."/>
																																			</xsl:if>
																																		</xsl:variable>
																																		<xsl:for-each select="$var140_test_resultof_node_name_equal_qname">
																																			<mglyph>
																																				<xsl:call-template name="tbf:tbf1_mglyph">
																																					<xsl:with-param name="input" select="." as="node()"/>
																																				</xsl:call-template>
																																			</mglyph>
																																		</xsl:for-each>
																																		<xsl:variable name="var141_test_resultof_node_name_equal_qname" as="node()?">
																																			<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																				<xsl:sequence select="."/>
																																			</xsl:if>
																																		</xsl:variable>
																																		<xsl:for-each select="$var141_test_resultof_node_name_equal_qname">
																																			<malignmark>
																																				<xsl:for-each select="@edge">
																																					<xsl:attribute name="edge" select="fn:string(.)"/>
																																				</xsl:for-each>
																																			</malignmark>
																																		</xsl:for-each>
																																	</xsl:for-each>
																																</ms>
																															</xsl:for-each>
																															<xsl:for-each select="mathnl:mrow">
																																<mrow>
																																	<xsl:sequence select="()"/>
																																</mrow>
																															</xsl:for-each>
																															<xsl:for-each select="mathnl:mfrac">
																																<mfrac>
																																	<xsl:sequence select="()"/>
																																</mfrac>
																															</xsl:for-each>
																															<xsl:for-each select="mathnl:msqrt">
																																<msqrt>
																																	<xsl:sequence select="()"/>
																																</msqrt>
																															</xsl:for-each>
																															<xsl:for-each select="mathnl:mroot">
																																<mroot>
																																	<xsl:sequence select="()"/>
																																</mroot>
																															</xsl:for-each>
																															<xsl:for-each select="mathnl:menclose">
																																<menclose>
																																	<xsl:sequence select="()"/>
																																</menclose>
																															</xsl:for-each>
																															<xsl:for-each select="mathnl:mpadded">
																																<mpadded>
																																	<xsl:sequence select="()"/>
																																</mpadded>
																															</xsl:for-each>
																															<xsl:for-each select="mathnl:mphantom">
																																<mphantom>
																																	<xsl:sequence select="()"/>
																																</mphantom>
																															</xsl:for-each>
																															<xsl:for-each select="mathnl:mfenced">
																																<mfenced>
																																	<xsl:sequence select="()"/>
																																</mfenced>
																															</xsl:for-each>
																															<xsl:for-each select="mathnl:msub">
																																<msub>
																																	<xsl:sequence select="()"/>
																																</msub>
																															</xsl:for-each>
																															<xsl:for-each select="mathnl:msup">
																																<msup>
																																	<xsl:sequence select="()"/>
																																</msup>
																															</xsl:for-each>
																															<xsl:for-each select="mathnl:msubsup">
																																<msubsup>
																																	<xsl:sequence select="()"/>
																																</msubsup>
																															</xsl:for-each>
																															<xsl:for-each select="mathnl:munder">
																																<munder>
																																	<xsl:sequence select="()"/>
																																</munder>
																															</xsl:for-each>
																															<xsl:for-each select="mathnl:mover">
																																<mover>
																																	<xsl:sequence select="()"/>
																																</mover>
																															</xsl:for-each>
																															<xsl:for-each select="mathnl:munderover">
																																<munderover>
																																	<xsl:for-each select="@xlink:href">
																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@class">
																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@style">
																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@id">
																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@xref">
																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@accent">
																																		<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="@accentunder">
																																		<xsl:attribute name="accentunder" select="xs:string(xs:boolean(fn:string(.)))"/>
																																	</xsl:for-each>
																																	<xsl:for-each select="mathnl:mi">
																																		<mi>
																																			<xsl:for-each select="@xlink:href">
																																				<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@class">
																																				<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@style">
																																				<xsl:attribute name="style" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@id">
																																				<xsl:attribute name="id" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@xref">
																																				<xsl:attribute name="xref" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@mathvariant">
																																				<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@mathsize">
																																				<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@mathcolor">
																																				<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@mathbackground">
																																				<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="node()">
																																				<xsl:if test="fn:boolean(self::text())">
																																					<xsl:sequence select="fn:string(.)"/>
																																				</xsl:if>
																																				<xsl:variable name="var142_test_resultof_node_name_equal_qname" as="node()?">
																																					<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																						<xsl:sequence select="."/>
																																					</xsl:if>
																																				</xsl:variable>
																																				<xsl:for-each select="$var142_test_resultof_node_name_equal_qname">
																																					<mglyph>
																																						<xsl:call-template name="tbf:tbf1_mglyph">
																																							<xsl:with-param name="input" select="." as="node()"/>
																																						</xsl:call-template>
																																					</mglyph>
																																				</xsl:for-each>
																																				<xsl:variable name="var143_test_resultof_node_name_equal_qname" as="node()?">
																																					<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																						<xsl:sequence select="."/>
																																					</xsl:if>
																																				</xsl:variable>
																																				<xsl:for-each select="$var143_test_resultof_node_name_equal_qname">
																																					<malignmark>
																																						<xsl:for-each select="@edge">
																																							<xsl:attribute name="edge" select="fn:string(.)"/>
																																						</xsl:for-each>
																																					</malignmark>
																																				</xsl:for-each>
																																			</xsl:for-each>
																																		</mi>
																																	</xsl:for-each>
																																	<xsl:for-each select="mathnl:mn">
																																		<mn>
																																			<xsl:for-each select="@xlink:href">
																																				<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@class">
																																				<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@style">
																																				<xsl:attribute name="style" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@id">
																																				<xsl:attribute name="id" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@xref">
																																				<xsl:attribute name="xref" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@mathvariant">
																																				<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@mathsize">
																																				<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@mathcolor">
																																				<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@mathbackground">
																																				<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="node()">
																																				<xsl:if test="fn:boolean(self::text())">
																																					<xsl:sequence select="fn:string(.)"/>
																																				</xsl:if>
																																				<xsl:variable name="var144_test_resultof_node_name_equal_qname" as="node()?">
																																					<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																						<xsl:sequence select="."/>
																																					</xsl:if>
																																				</xsl:variable>
																																				<xsl:for-each select="$var144_test_resultof_node_name_equal_qname">
																																					<mglyph>
																																						<xsl:call-template name="tbf:tbf1_mglyph">
																																							<xsl:with-param name="input" select="." as="node()"/>
																																						</xsl:call-template>
																																					</mglyph>
																																				</xsl:for-each>
																																				<xsl:variable name="var145_test_resultof_node_name_equal_qname" as="node()?">
																																					<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																						<xsl:sequence select="."/>
																																					</xsl:if>
																																				</xsl:variable>
																																				<xsl:for-each select="$var145_test_resultof_node_name_equal_qname">
																																					<malignmark>
																																						<xsl:for-each select="@edge">
																																							<xsl:attribute name="edge" select="fn:string(.)"/>
																																						</xsl:for-each>
																																					</malignmark>
																																				</xsl:for-each>
																																			</xsl:for-each>
																																		</mn>
																																	</xsl:for-each>
																																	<xsl:for-each select="mathnl:mo">
																																		<mo>
																																			<xsl:for-each select="@xlink:href">
																																				<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@class">
																																				<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@style">
																																				<xsl:attribute name="style" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@id">
																																				<xsl:attribute name="id" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@xref">
																																				<xsl:attribute name="xref" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@mathvariant">
																																				<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@mathsize">
																																				<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@mathcolor">
																																				<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@mathbackground">
																																				<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@form">
																																				<xsl:attribute name="form" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@fence">
																																				<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@separator">
																																				<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@lspace">
																																				<xsl:attribute name="lspace" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@rspace">
																																				<xsl:attribute name="rspace" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@stretchy">
																																				<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@symmetric">
																																				<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@maxsize">
																																				<xsl:attribute name="maxsize" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@minsize">
																																				<xsl:attribute name="minsize" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@largeop">
																																				<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@movablelimits">
																																				<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@accent">
																																				<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="node()">
																																				<xsl:if test="fn:boolean(self::text())">
																																					<xsl:sequence select="fn:string(.)"/>
																																				</xsl:if>
																																				<xsl:variable name="var146_test_resultof_node_name_equal_qname" as="node()?">
																																					<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																						<xsl:sequence select="."/>
																																					</xsl:if>
																																				</xsl:variable>
																																				<xsl:for-each select="$var146_test_resultof_node_name_equal_qname">
																																					<mglyph>
																																						<xsl:call-template name="tbf:tbf1_mglyph">
																																							<xsl:with-param name="input" select="." as="node()"/>
																																						</xsl:call-template>
																																					</mglyph>
																																				</xsl:for-each>
																																				<xsl:variable name="var147_test_resultof_node_name_equal_qname" as="node()?">
																																					<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																						<xsl:sequence select="."/>
																																					</xsl:if>
																																				</xsl:variable>
																																				<xsl:for-each select="$var147_test_resultof_node_name_equal_qname">
																																					<malignmark>
																																						<xsl:for-each select="@edge">
																																							<xsl:attribute name="edge" select="fn:string(.)"/>
																																						</xsl:for-each>
																																					</malignmark>
																																				</xsl:for-each>
																																			</xsl:for-each>
																																		</mo>
																																	</xsl:for-each>
																																	<xsl:for-each select="mathnl:mtext">
																																		<mtext>
																																			<xsl:for-each select="@xlink:href">
																																				<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@class">
																																				<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@style">
																																				<xsl:attribute name="style" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@id">
																																				<xsl:attribute name="id" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@xref">
																																				<xsl:attribute name="xref" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@mathvariant">
																																				<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@mathsize">
																																				<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@mathcolor">
																																				<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@mathbackground">
																																				<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="node()">
																																				<xsl:if test="fn:boolean(self::text())">
																																					<xsl:sequence select="fn:string(.)"/>
																																				</xsl:if>
																																				<xsl:variable name="var148_test_resultof_node_name_equal_qname" as="node()?">
																																					<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																						<xsl:sequence select="."/>
																																					</xsl:if>
																																				</xsl:variable>
																																				<xsl:for-each select="$var148_test_resultof_node_name_equal_qname">
																																					<mglyph>
																																						<xsl:call-template name="tbf:tbf1_mglyph">
																																							<xsl:with-param name="input" select="." as="node()"/>
																																						</xsl:call-template>
																																					</mglyph>
																																				</xsl:for-each>
																																				<xsl:variable name="var149_test_resultof_node_name_equal_qname" as="node()?">
																																					<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																						<xsl:sequence select="."/>
																																					</xsl:if>
																																				</xsl:variable>
																																				<xsl:for-each select="$var149_test_resultof_node_name_equal_qname">
																																					<malignmark>
																																						<xsl:for-each select="@edge">
																																							<xsl:attribute name="edge" select="fn:string(.)"/>
																																						</xsl:for-each>
																																					</malignmark>
																																				</xsl:for-each>
																																			</xsl:for-each>
																																		</mtext>
																																	</xsl:for-each>
																																	<xsl:for-each select="mathnl:ms">
																																		<ms>
																																			<xsl:for-each select="@xlink:href">
																																				<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@class">
																																				<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@style">
																																				<xsl:attribute name="style" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@id">
																																				<xsl:attribute name="id" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@xref">
																																				<xsl:attribute name="xref" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@mathvariant">
																																				<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@mathsize">
																																				<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@mathcolor">
																																				<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@mathbackground">
																																				<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@lquote">
																																				<xsl:attribute name="lquote" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@rquote">
																																				<xsl:attribute name="rquote" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="node()">
																																				<xsl:if test="fn:boolean(self::text())">
																																					<xsl:sequence select="fn:string(.)"/>
																																				</xsl:if>
																																				<xsl:variable name="var150_test_resultof_node_name_equal_qname" as="node()?">
																																					<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																						<xsl:sequence select="."/>
																																					</xsl:if>
																																				</xsl:variable>
																																				<xsl:for-each select="$var150_test_resultof_node_name_equal_qname">
																																					<mglyph>
																																						<xsl:call-template name="tbf:tbf1_mglyph">
																																							<xsl:with-param name="input" select="." as="node()"/>
																																						</xsl:call-template>
																																					</mglyph>
																																				</xsl:for-each>
																																				<xsl:variable name="var151_test_resultof_node_name_equal_qname" as="node()?">
																																					<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																						<xsl:sequence select="."/>
																																					</xsl:if>
																																				</xsl:variable>
																																				<xsl:for-each select="$var151_test_resultof_node_name_equal_qname">
																																					<malignmark>
																																						<xsl:for-each select="@edge">
																																							<xsl:attribute name="edge" select="fn:string(.)"/>
																																						</xsl:for-each>
																																					</malignmark>
																																				</xsl:for-each>
																																			</xsl:for-each>
																																		</ms>
																																	</xsl:for-each>
																																	<xsl:for-each select="mathnl:mrow">
																																		<mrow>
																																			<xsl:sequence select="()"/>
																																		</mrow>
																																	</xsl:for-each>
																																	<xsl:for-each select="mathnl:mfrac">
																																		<mfrac>
																																			<xsl:sequence select="()"/>
																																		</mfrac>
																																	</xsl:for-each>
																																	<xsl:for-each select="mathnl:msqrt">
																																		<msqrt>
																																			<xsl:sequence select="()"/>
																																		</msqrt>
																																	</xsl:for-each>
																																	<xsl:for-each select="mathnl:mroot">
																																		<mroot>
																																			<xsl:sequence select="()"/>
																																		</mroot>
																																	</xsl:for-each>
																																	<xsl:for-each select="mathnl:menclose">
																																		<menclose>
																																			<xsl:sequence select="()"/>
																																		</menclose>
																																	</xsl:for-each>
																																	<xsl:for-each select="mathnl:mpadded">
																																		<mpadded>
																																			<xsl:sequence select="()"/>
																																		</mpadded>
																																	</xsl:for-each>
																																	<xsl:for-each select="mathnl:mphantom">
																																		<mphantom>
																																			<xsl:sequence select="()"/>
																																		</mphantom>
																																	</xsl:for-each>
																																	<xsl:for-each select="mathnl:mfenced">
																																		<mfenced>
																																			<xsl:sequence select="()"/>
																																		</mfenced>
																																	</xsl:for-each>
																																	<xsl:for-each select="mathnl:msub">
																																		<msub>
																																			<xsl:sequence select="()"/>
																																		</msub>
																																	</xsl:for-each>
																																	<xsl:for-each select="mathnl:msup">
																																		<msup>
																																			<xsl:sequence select="()"/>
																																		</msup>
																																	</xsl:for-each>
																																	<xsl:for-each select="mathnl:msubsup">
																																		<msubsup>
																																			<xsl:sequence select="()"/>
																																		</msubsup>
																																	</xsl:for-each>
																																	<xsl:for-each select="mathnl:munder">
																																		<munder>
																																			<xsl:sequence select="()"/>
																																		</munder>
																																	</xsl:for-each>
																																	<xsl:for-each select="mathnl:mover">
																																		<mover>
																																			<xsl:sequence select="()"/>
																																		</mover>
																																	</xsl:for-each>
																																	<xsl:for-each select="mathnl:munderover">
																																		<munderover>
																																			<xsl:sequence select="()"/>
																																		</munderover>
																																	</xsl:for-each>
																																	<xsl:for-each select="mathnl:mmultiscripts">
																																		<mmultiscripts>
																																			<xsl:for-each select="@xlink:href">
																																				<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@class">
																																				<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@style">
																																				<xsl:attribute name="style" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@id">
																																				<xsl:attribute name="id" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="@xref">
																																				<xsl:attribute name="xref" select="fn:string(.)"/>
																																			</xsl:for-each>
																																			<xsl:for-each select="mathnl:mi">
																																				<mi>
																																					<xsl:for-each select="@xlink:href">
																																						<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@class">
																																						<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@style">
																																						<xsl:attribute name="style" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@id">
																																						<xsl:attribute name="id" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@xref">
																																						<xsl:attribute name="xref" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@mathvariant">
																																						<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@mathsize">
																																						<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@mathcolor">
																																						<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@mathbackground">
																																						<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="node()">
																																						<xsl:if test="fn:boolean(self::text())">
																																							<xsl:sequence select="fn:string(.)"/>
																																						</xsl:if>
																																						<xsl:variable name="var152_test_resultof_node_name_equal_qname" as="node()?">
																																							<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																								<xsl:sequence select="."/>
																																							</xsl:if>
																																						</xsl:variable>
																																						<xsl:for-each select="$var152_test_resultof_node_name_equal_qname">
																																							<mglyph>
																																								<xsl:call-template name="tbf:tbf1_mglyph">
																																									<xsl:with-param name="input" select="." as="node()"/>
																																								</xsl:call-template>
																																							</mglyph>
																																						</xsl:for-each>
																																						<xsl:variable name="var153_test_resultof_node_name_equal_qname" as="node()?">
																																							<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																								<xsl:sequence select="."/>
																																							</xsl:if>
																																						</xsl:variable>
																																						<xsl:for-each select="$var153_test_resultof_node_name_equal_qname">
																																							<malignmark>
																																								<xsl:for-each select="@edge">
																																									<xsl:attribute name="edge" select="fn:string(.)"/>
																																								</xsl:for-each>
																																							</malignmark>
																																						</xsl:for-each>
																																					</xsl:for-each>
																																				</mi>
																																			</xsl:for-each>
																																			<xsl:for-each select="mathnl:mn">
																																				<mn>
																																					<xsl:for-each select="@xlink:href">
																																						<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@class">
																																						<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@style">
																																						<xsl:attribute name="style" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@id">
																																						<xsl:attribute name="id" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@xref">
																																						<xsl:attribute name="xref" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@mathvariant">
																																						<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@mathsize">
																																						<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@mathcolor">
																																						<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@mathbackground">
																																						<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="node()">
																																						<xsl:if test="fn:boolean(self::text())">
																																							<xsl:sequence select="fn:string(.)"/>
																																						</xsl:if>
																																						<xsl:variable name="var154_test_resultof_node_name_equal_qname" as="node()?">
																																							<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																								<xsl:sequence select="."/>
																																							</xsl:if>
																																						</xsl:variable>
																																						<xsl:for-each select="$var154_test_resultof_node_name_equal_qname">
																																							<mglyph>
																																								<xsl:call-template name="tbf:tbf1_mglyph">
																																									<xsl:with-param name="input" select="." as="node()"/>
																																								</xsl:call-template>
																																							</mglyph>
																																						</xsl:for-each>
																																						<xsl:variable name="var155_test_resultof_node_name_equal_qname" as="node()?">
																																							<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																								<xsl:sequence select="."/>
																																							</xsl:if>
																																						</xsl:variable>
																																						<xsl:for-each select="$var155_test_resultof_node_name_equal_qname">
																																							<malignmark>
																																								<xsl:for-each select="@edge">
																																									<xsl:attribute name="edge" select="fn:string(.)"/>
																																								</xsl:for-each>
																																							</malignmark>
																																						</xsl:for-each>
																																					</xsl:for-each>
																																				</mn>
																																			</xsl:for-each>
																																			<xsl:for-each select="mathnl:mo">
																																				<mo>
																																					<xsl:for-each select="@xlink:href">
																																						<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@class">
																																						<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@style">
																																						<xsl:attribute name="style" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@id">
																																						<xsl:attribute name="id" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@xref">
																																						<xsl:attribute name="xref" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@mathvariant">
																																						<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@mathsize">
																																						<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@mathcolor">
																																						<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@mathbackground">
																																						<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@form">
																																						<xsl:attribute name="form" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@fence">
																																						<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@separator">
																																						<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@lspace">
																																						<xsl:attribute name="lspace" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@rspace">
																																						<xsl:attribute name="rspace" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@stretchy">
																																						<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@symmetric">
																																						<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@maxsize">
																																						<xsl:attribute name="maxsize" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@minsize">
																																						<xsl:attribute name="minsize" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@largeop">
																																						<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@movablelimits">
																																						<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@accent">
																																						<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="node()">
																																						<xsl:if test="fn:boolean(self::text())">
																																							<xsl:sequence select="fn:string(.)"/>
																																						</xsl:if>
																																						<xsl:variable name="var156_test_resultof_node_name_equal_qname" as="node()?">
																																							<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																								<xsl:sequence select="."/>
																																							</xsl:if>
																																						</xsl:variable>
																																						<xsl:for-each select="$var156_test_resultof_node_name_equal_qname">
																																							<mglyph>
																																								<xsl:call-template name="tbf:tbf1_mglyph">
																																									<xsl:with-param name="input" select="." as="node()"/>
																																								</xsl:call-template>
																																							</mglyph>
																																						</xsl:for-each>
																																						<xsl:variable name="var157_test_resultof_node_name_equal_qname" as="node()?">
																																							<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																								<xsl:sequence select="."/>
																																							</xsl:if>
																																						</xsl:variable>
																																						<xsl:for-each select="$var157_test_resultof_node_name_equal_qname">
																																							<malignmark>
																																								<xsl:for-each select="@edge">
																																									<xsl:attribute name="edge" select="fn:string(.)"/>
																																								</xsl:for-each>
																																							</malignmark>
																																						</xsl:for-each>
																																					</xsl:for-each>
																																				</mo>
																																			</xsl:for-each>
																																			<xsl:for-each select="mathnl:mtext">
																																				<mtext>
																																					<xsl:for-each select="@xlink:href">
																																						<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@class">
																																						<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@style">
																																						<xsl:attribute name="style" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@id">
																																						<xsl:attribute name="id" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@xref">
																																						<xsl:attribute name="xref" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@mathvariant">
																																						<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@mathsize">
																																						<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@mathcolor">
																																						<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@mathbackground">
																																						<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="node()">
																																						<xsl:if test="fn:boolean(self::text())">
																																							<xsl:sequence select="fn:string(.)"/>
																																						</xsl:if>
																																						<xsl:variable name="var158_test_resultof_node_name_equal_qname" as="node()?">
																																							<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																								<xsl:sequence select="."/>
																																							</xsl:if>
																																						</xsl:variable>
																																						<xsl:for-each select="$var158_test_resultof_node_name_equal_qname">
																																							<mglyph>
																																								<xsl:call-template name="tbf:tbf1_mglyph">
																																									<xsl:with-param name="input" select="." as="node()"/>
																																								</xsl:call-template>
																																							</mglyph>
																																						</xsl:for-each>
																																						<xsl:variable name="var159_test_resultof_node_name_equal_qname" as="node()?">
																																							<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																								<xsl:sequence select="."/>
																																							</xsl:if>
																																						</xsl:variable>
																																						<xsl:for-each select="$var159_test_resultof_node_name_equal_qname">
																																							<malignmark>
																																								<xsl:for-each select="@edge">
																																									<xsl:attribute name="edge" select="fn:string(.)"/>
																																								</xsl:for-each>
																																							</malignmark>
																																						</xsl:for-each>
																																					</xsl:for-each>
																																				</mtext>
																																			</xsl:for-each>
																																			<xsl:for-each select="mathnl:ms">
																																				<ms>
																																					<xsl:for-each select="@xlink:href">
																																						<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@class">
																																						<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@style">
																																						<xsl:attribute name="style" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@id">
																																						<xsl:attribute name="id" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@xref">
																																						<xsl:attribute name="xref" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@mathvariant">
																																						<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@mathsize">
																																						<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@mathcolor">
																																						<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@mathbackground">
																																						<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@lquote">
																																						<xsl:attribute name="lquote" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@rquote">
																																						<xsl:attribute name="rquote" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="node()">
																																						<xsl:if test="fn:boolean(self::text())">
																																							<xsl:sequence select="fn:string(.)"/>
																																						</xsl:if>
																																						<xsl:variable name="var160_test_resultof_node_name_equal_qname" as="node()?">
																																							<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																								<xsl:sequence select="."/>
																																							</xsl:if>
																																						</xsl:variable>
																																						<xsl:for-each select="$var160_test_resultof_node_name_equal_qname">
																																							<mglyph>
																																								<xsl:call-template name="tbf:tbf1_mglyph">
																																									<xsl:with-param name="input" select="." as="node()"/>
																																								</xsl:call-template>
																																							</mglyph>
																																						</xsl:for-each>
																																						<xsl:variable name="var161_test_resultof_node_name_equal_qname" as="node()?">
																																							<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																								<xsl:sequence select="."/>
																																							</xsl:if>
																																						</xsl:variable>
																																						<xsl:for-each select="$var161_test_resultof_node_name_equal_qname">
																																							<malignmark>
																																								<xsl:for-each select="@edge">
																																									<xsl:attribute name="edge" select="fn:string(.)"/>
																																								</xsl:for-each>
																																							</malignmark>
																																						</xsl:for-each>
																																					</xsl:for-each>
																																				</ms>
																																			</xsl:for-each>
																																			<xsl:for-each select="mathnl:mrow">
																																				<mrow>
																																					<xsl:sequence select="()"/>
																																				</mrow>
																																			</xsl:for-each>
																																			<xsl:for-each select="mathnl:mfrac">
																																				<mfrac>
																																					<xsl:sequence select="()"/>
																																				</mfrac>
																																			</xsl:for-each>
																																			<xsl:for-each select="mathnl:msqrt">
																																				<msqrt>
																																					<xsl:sequence select="()"/>
																																				</msqrt>
																																			</xsl:for-each>
																																			<xsl:for-each select="mathnl:mroot">
																																				<mroot>
																																					<xsl:sequence select="()"/>
																																				</mroot>
																																			</xsl:for-each>
																																			<xsl:for-each select="mathnl:menclose">
																																				<menclose>
																																					<xsl:sequence select="()"/>
																																				</menclose>
																																			</xsl:for-each>
																																			<xsl:for-each select="mathnl:mpadded">
																																				<mpadded>
																																					<xsl:sequence select="()"/>
																																				</mpadded>
																																			</xsl:for-each>
																																			<xsl:for-each select="mathnl:mphantom">
																																				<mphantom>
																																					<xsl:sequence select="()"/>
																																				</mphantom>
																																			</xsl:for-each>
																																			<xsl:for-each select="mathnl:mfenced">
																																				<mfenced>
																																					<xsl:sequence select="()"/>
																																				</mfenced>
																																			</xsl:for-each>
																																			<xsl:for-each select="mathnl:msub">
																																				<msub>
																																					<xsl:sequence select="()"/>
																																				</msub>
																																			</xsl:for-each>
																																			<xsl:for-each select="mathnl:msup">
																																				<msup>
																																					<xsl:sequence select="()"/>
																																				</msup>
																																			</xsl:for-each>
																																			<xsl:for-each select="mathnl:msubsup">
																																				<msubsup>
																																					<xsl:sequence select="()"/>
																																				</msubsup>
																																			</xsl:for-each>
																																			<xsl:for-each select="mathnl:munder">
																																				<munder>
																																					<xsl:sequence select="()"/>
																																				</munder>
																																			</xsl:for-each>
																																			<xsl:for-each select="mathnl:mover">
																																				<mover>
																																					<xsl:sequence select="()"/>
																																				</mover>
																																			</xsl:for-each>
																																			<xsl:for-each select="mathnl:munderover">
																																				<munderover>
																																					<xsl:sequence select="()"/>
																																				</munderover>
																																			</xsl:for-each>
																																			<xsl:for-each select="mathnl:mmultiscripts">
																																				<mmultiscripts>
																																					<xsl:sequence select="()"/>
																																				</mmultiscripts>
																																			</xsl:for-each>
																																			<xsl:for-each select="mathnl:mtable">
																																				<mtable>
																																					<xsl:for-each select="@xlink:href">
																																						<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@class">
																																						<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@style">
																																						<xsl:attribute name="style" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@id">
																																						<xsl:attribute name="id" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@xref">
																																						<xsl:attribute name="xref" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@align">
																																						<xsl:attribute name="align" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@rowalign">
																																						<xsl:attribute name="rowalign" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@columnalign">
																																						<xsl:attribute name="columnalign" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@columnwidth">
																																						<xsl:attribute name="columnwidth" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@groupalign">
																																						<xsl:attribute name="groupalign" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@alignmentscope">
																																						<xsl:attribute name="alignmentscope" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@side">
																																						<xsl:attribute name="side" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@rowspacing">
																																						<xsl:attribute name="rowspacing" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@columnspacing">
																																						<xsl:attribute name="columnspacing" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@rowlines">
																																						<xsl:attribute name="rowlines" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@columnlines">
																																						<xsl:attribute name="columnlines" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@width">
																																						<xsl:attribute name="width" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@frame">
																																						<xsl:attribute name="frame" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@framespacing">
																																						<xsl:attribute name="framespacing" select="fn:string(.)"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@equalrows">
																																						<xsl:attribute name="equalrows" select="xs:string(xs:boolean(fn:string(.)))"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@equalcolumns">
																																						<xsl:attribute name="equalcolumns" select="xs:string(xs:boolean(fn:string(.)))"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="@displaystyle">
																																						<xsl:attribute name="displaystyle" select="xs:string(xs:boolean(fn:string(.)))"/>
																																					</xsl:for-each>
																																					<xsl:for-each select="mathnl:mtr">
																																						<mtr>
																																							<xsl:for-each select="@xlink:href">
																																								<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																							</xsl:for-each>
																																							<xsl:for-each select="@class">
																																								<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																							</xsl:for-each>
																																							<xsl:for-each select="@style">
																																								<xsl:attribute name="style" select="fn:string(.)"/>
																																							</xsl:for-each>
																																							<xsl:for-each select="@id">
																																								<xsl:attribute name="id" select="fn:string(.)"/>
																																							</xsl:for-each>
																																							<xsl:for-each select="@xref">
																																								<xsl:attribute name="xref" select="fn:string(.)"/>
																																							</xsl:for-each>
																																							<xsl:for-each select="@rowalign">
																																								<xsl:attribute name="rowalign" select="fn:string(.)"/>
																																							</xsl:for-each>
																																							<xsl:for-each select="@columnalign">
																																								<xsl:attribute name="columnalign" select="fn:string(.)"/>
																																							</xsl:for-each>
																																							<xsl:for-each select="@groupalign">
																																								<xsl:attribute name="groupalign" select="fn:string(.)"/>
																																							</xsl:for-each>
																																							<xsl:for-each select="mathnl:mtd">
																																								<mtd>
																																									<xsl:for-each select="@xlink:href">
																																										<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																									</xsl:for-each>
																																									<xsl:for-each select="@class">
																																										<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																									</xsl:for-each>
																																									<xsl:for-each select="@style">
																																										<xsl:attribute name="style" select="fn:string(.)"/>
																																									</xsl:for-each>
																																									<xsl:for-each select="@id">
																																										<xsl:attribute name="id" select="fn:string(.)"/>
																																									</xsl:for-each>
																																									<xsl:for-each select="@xref">
																																										<xsl:attribute name="xref" select="fn:string(.)"/>
																																									</xsl:for-each>
																																									<xsl:for-each select="@rowalign">
																																										<xsl:attribute name="rowalign" select="fn:string(.)"/>
																																									</xsl:for-each>
																																									<xsl:for-each select="@columnalign">
																																										<xsl:attribute name="columnalign" select="fn:string(.)"/>
																																									</xsl:for-each>
																																									<xsl:for-each select="@groupalign">
																																										<xsl:attribute name="groupalign" select="fn:string(.)"/>
																																									</xsl:for-each>
																																									<xsl:for-each select="@rowspan">
																																										<xsl:attribute name="rowspan" select="xs:string(xs:integer(fn:string(.)))"/>
																																									</xsl:for-each>
																																									<xsl:for-each select="@columnspan">
																																										<xsl:attribute name="columnspan" select="xs:string(xs:integer(fn:string(.)))"/>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:mi">
																																										<mi>
																																											<xsl:for-each select="@xlink:href">
																																												<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@class">
																																												<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@style">
																																												<xsl:attribute name="style" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@id">
																																												<xsl:attribute name="id" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@xref">
																																												<xsl:attribute name="xref" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@mathvariant">
																																												<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@mathsize">
																																												<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@mathcolor">
																																												<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@mathbackground">
																																												<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="node()">
																																												<xsl:if test="fn:boolean(self::text())">
																																													<xsl:sequence select="fn:string(.)"/>
																																												</xsl:if>
																																												<xsl:variable name="var162_test_resultof_node_name_equal_qname" as="node()?">
																																													<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																														<xsl:sequence select="."/>
																																													</xsl:if>
																																												</xsl:variable>
																																												<xsl:for-each select="$var162_test_resultof_node_name_equal_qname">
																																													<mglyph>
																																														<xsl:call-template name="tbf:tbf1_mglyph">
																																															<xsl:with-param name="input" select="." as="node()"/>
																																														</xsl:call-template>
																																													</mglyph>
																																												</xsl:for-each>
																																												<xsl:variable name="var163_test_resultof_node_name_equal_qname" as="node()?">
																																													<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																														<xsl:sequence select="."/>
																																													</xsl:if>
																																												</xsl:variable>
																																												<xsl:for-each select="$var163_test_resultof_node_name_equal_qname">
																																													<malignmark>
																																														<xsl:for-each select="@edge">
																																															<xsl:attribute name="edge" select="fn:string(.)"/>
																																														</xsl:for-each>
																																													</malignmark>
																																												</xsl:for-each>
																																											</xsl:for-each>
																																										</mi>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:mn">
																																										<mn>
																																											<xsl:for-each select="@xlink:href">
																																												<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@class">
																																												<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@style">
																																												<xsl:attribute name="style" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@id">
																																												<xsl:attribute name="id" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@xref">
																																												<xsl:attribute name="xref" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@mathvariant">
																																												<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@mathsize">
																																												<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@mathcolor">
																																												<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@mathbackground">
																																												<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="node()">
																																												<xsl:if test="fn:boolean(self::text())">
																																													<xsl:sequence select="fn:string(.)"/>
																																												</xsl:if>
																																												<xsl:variable name="var164_test_resultof_node_name_equal_qname" as="node()?">
																																													<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																														<xsl:sequence select="."/>
																																													</xsl:if>
																																												</xsl:variable>
																																												<xsl:for-each select="$var164_test_resultof_node_name_equal_qname">
																																													<mglyph>
																																														<xsl:call-template name="tbf:tbf1_mglyph">
																																															<xsl:with-param name="input" select="." as="node()"/>
																																														</xsl:call-template>
																																													</mglyph>
																																												</xsl:for-each>
																																												<xsl:variable name="var165_test_resultof_node_name_equal_qname" as="node()?">
																																													<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																														<xsl:sequence select="."/>
																																													</xsl:if>
																																												</xsl:variable>
																																												<xsl:for-each select="$var165_test_resultof_node_name_equal_qname">
																																													<malignmark>
																																														<xsl:for-each select="@edge">
																																															<xsl:attribute name="edge" select="fn:string(.)"/>
																																														</xsl:for-each>
																																													</malignmark>
																																												</xsl:for-each>
																																											</xsl:for-each>
																																										</mn>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:mo">
																																										<mo>
																																											<xsl:for-each select="@xlink:href">
																																												<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@class">
																																												<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@style">
																																												<xsl:attribute name="style" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@id">
																																												<xsl:attribute name="id" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@xref">
																																												<xsl:attribute name="xref" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@mathvariant">
																																												<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@mathsize">
																																												<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@mathcolor">
																																												<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@mathbackground">
																																												<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@form">
																																												<xsl:attribute name="form" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@fence">
																																												<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@separator">
																																												<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@lspace">
																																												<xsl:attribute name="lspace" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@rspace">
																																												<xsl:attribute name="rspace" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@stretchy">
																																												<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@symmetric">
																																												<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@maxsize">
																																												<xsl:attribute name="maxsize" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@minsize">
																																												<xsl:attribute name="minsize" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@largeop">
																																												<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@movablelimits">
																																												<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@accent">
																																												<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="node()">
																																												<xsl:if test="fn:boolean(self::text())">
																																													<xsl:sequence select="fn:string(.)"/>
																																												</xsl:if>
																																												<xsl:variable name="var166_test_resultof_node_name_equal_qname" as="node()?">
																																													<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																														<xsl:sequence select="."/>
																																													</xsl:if>
																																												</xsl:variable>
																																												<xsl:for-each select="$var166_test_resultof_node_name_equal_qname">
																																													<mglyph>
																																														<xsl:call-template name="tbf:tbf1_mglyph">
																																															<xsl:with-param name="input" select="." as="node()"/>
																																														</xsl:call-template>
																																													</mglyph>
																																												</xsl:for-each>
																																												<xsl:variable name="var167_test_resultof_node_name_equal_qname" as="node()?">
																																													<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																														<xsl:sequence select="."/>
																																													</xsl:if>
																																												</xsl:variable>
																																												<xsl:for-each select="$var167_test_resultof_node_name_equal_qname">
																																													<malignmark>
																																														<xsl:for-each select="@edge">
																																															<xsl:attribute name="edge" select="fn:string(.)"/>
																																														</xsl:for-each>
																																													</malignmark>
																																												</xsl:for-each>
																																											</xsl:for-each>
																																										</mo>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:mtext">
																																										<mtext>
																																											<xsl:for-each select="@xlink:href">
																																												<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@class">
																																												<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@style">
																																												<xsl:attribute name="style" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@id">
																																												<xsl:attribute name="id" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@xref">
																																												<xsl:attribute name="xref" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@mathvariant">
																																												<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@mathsize">
																																												<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@mathcolor">
																																												<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@mathbackground">
																																												<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="node()">
																																												<xsl:if test="fn:boolean(self::text())">
																																													<xsl:sequence select="fn:string(.)"/>
																																												</xsl:if>
																																												<xsl:variable name="var168_test_resultof_node_name_equal_qname" as="node()?">
																																													<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																														<xsl:sequence select="."/>
																																													</xsl:if>
																																												</xsl:variable>
																																												<xsl:for-each select="$var168_test_resultof_node_name_equal_qname">
																																													<mglyph>
																																														<xsl:call-template name="tbf:tbf1_mglyph">
																																															<xsl:with-param name="input" select="." as="node()"/>
																																														</xsl:call-template>
																																													</mglyph>
																																												</xsl:for-each>
																																												<xsl:variable name="var169_test_resultof_node_name_equal_qname" as="node()?">
																																													<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																														<xsl:sequence select="."/>
																																													</xsl:if>
																																												</xsl:variable>
																																												<xsl:for-each select="$var169_test_resultof_node_name_equal_qname">
																																													<malignmark>
																																														<xsl:for-each select="@edge">
																																															<xsl:attribute name="edge" select="fn:string(.)"/>
																																														</xsl:for-each>
																																													</malignmark>
																																												</xsl:for-each>
																																											</xsl:for-each>
																																										</mtext>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:ms">
																																										<ms>
																																											<xsl:for-each select="@xlink:href">
																																												<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@class">
																																												<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@style">
																																												<xsl:attribute name="style" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@id">
																																												<xsl:attribute name="id" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@xref">
																																												<xsl:attribute name="xref" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@mathvariant">
																																												<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@mathsize">
																																												<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@mathcolor">
																																												<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@mathbackground">
																																												<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@lquote">
																																												<xsl:attribute name="lquote" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@rquote">
																																												<xsl:attribute name="rquote" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="node()">
																																												<xsl:if test="fn:boolean(self::text())">
																																													<xsl:sequence select="fn:string(.)"/>
																																												</xsl:if>
																																												<xsl:variable name="var170_test_resultof_node_name_equal_qname" as="node()?">
																																													<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																														<xsl:sequence select="."/>
																																													</xsl:if>
																																												</xsl:variable>
																																												<xsl:for-each select="$var170_test_resultof_node_name_equal_qname">
																																													<mglyph>
																																														<xsl:call-template name="tbf:tbf1_mglyph">
																																															<xsl:with-param name="input" select="." as="node()"/>
																																														</xsl:call-template>
																																													</mglyph>
																																												</xsl:for-each>
																																												<xsl:variable name="var171_test_resultof_node_name_equal_qname" as="node()?">
																																													<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																														<xsl:sequence select="."/>
																																													</xsl:if>
																																												</xsl:variable>
																																												<xsl:for-each select="$var171_test_resultof_node_name_equal_qname">
																																													<malignmark>
																																														<xsl:for-each select="@edge">
																																															<xsl:attribute name="edge" select="fn:string(.)"/>
																																														</xsl:for-each>
																																													</malignmark>
																																												</xsl:for-each>
																																											</xsl:for-each>
																																										</ms>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:mspace">
																																										<mspace>
																																											<xsl:for-each select="@width">
																																												<xsl:attribute name="width" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@height">
																																												<xsl:attribute name="height" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@depth">
																																												<xsl:attribute name="depth" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@linebreak">
																																												<xsl:attribute name="linebreak" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@xlink:href">
																																												<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@class">
																																												<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@style">
																																												<xsl:attribute name="style" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@id">
																																												<xsl:attribute name="id" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@xref">
																																												<xsl:attribute name="xref" select="fn:string(.)"/>
																																											</xsl:for-each>
																																										</mspace>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:mrow">
																																										<mrow>
																																											<xsl:sequence select="()"/>
																																										</mrow>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:mfrac">
																																										<mfrac>
																																											<xsl:sequence select="()"/>
																																										</mfrac>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:msqrt">
																																										<msqrt>
																																											<xsl:sequence select="()"/>
																																										</msqrt>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:mroot">
																																										<mroot>
																																											<xsl:sequence select="()"/>
																																										</mroot>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:menclose">
																																										<menclose>
																																											<xsl:sequence select="()"/>
																																										</menclose>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:mpadded">
																																										<mpadded>
																																											<xsl:sequence select="()"/>
																																										</mpadded>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:mphantom">
																																										<mphantom>
																																											<xsl:sequence select="()"/>
																																										</mphantom>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:mfenced">
																																										<mfenced>
																																											<xsl:sequence select="()"/>
																																										</mfenced>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:msub">
																																										<msub>
																																											<xsl:sequence select="()"/>
																																										</msub>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:msup">
																																										<msup>
																																											<xsl:sequence select="()"/>
																																										</msup>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:msubsup">
																																										<msubsup>
																																											<xsl:sequence select="()"/>
																																										</msubsup>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:munder">
																																										<munder>
																																											<xsl:sequence select="()"/>
																																										</munder>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:mover">
																																										<mover>
																																											<xsl:sequence select="()"/>
																																										</mover>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:munderover">
																																										<munderover>
																																											<xsl:sequence select="()"/>
																																										</munderover>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:mmultiscripts">
																																										<mmultiscripts>
																																											<xsl:sequence select="()"/>
																																										</mmultiscripts>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:mtable">
																																										<mtable>
																																											<xsl:sequence select="()"/>
																																										</mtable>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:maligngroup">
																																										<maligngroup>
																																											<xsl:for-each select="@xlink:href">
																																												<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@class">
																																												<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@style">
																																												<xsl:attribute name="style" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@id">
																																												<xsl:attribute name="id" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@xref">
																																												<xsl:attribute name="xref" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@groupalign">
																																												<xsl:attribute name="groupalign" select="fn:string(.)"/>
																																											</xsl:for-each>
																																										</maligngroup>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:malignmark">
																																										<malignmark>
																																											<xsl:for-each select="@edge">
																																												<xsl:attribute name="edge" select="fn:string(.)"/>
																																											</xsl:for-each>
																																										</malignmark>
																																									</xsl:for-each>
																																									<xsl:for-each select="mathnl:maction">
																																										<maction>
																																											<xsl:for-each select="@xlink:href">
																																												<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@class">
																																												<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@style">
																																												<xsl:attribute name="style" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@id">
																																												<xsl:attribute name="id" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@xref">
																																												<xsl:attribute name="xref" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@actiontype">
																																												<xsl:attribute name="actiontype" select="fn:string(.)"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="@selection">
																																												<xsl:attribute name="selection" select="xs:string(xs:integer(fn:string(.)))"/>
																																											</xsl:for-each>
																																											<xsl:for-each select="mathnl:mi">
																																												<mi>
																																													<xsl:for-each select="@xlink:href">
																																														<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@class">
																																														<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@style">
																																														<xsl:attribute name="style" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@id">
																																														<xsl:attribute name="id" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@xref">
																																														<xsl:attribute name="xref" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@mathvariant">
																																														<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@mathsize">
																																														<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@mathcolor">
																																														<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@mathbackground">
																																														<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="node()">
																																														<xsl:if test="fn:boolean(self::text())">
																																															<xsl:sequence select="fn:string(.)"/>
																																														</xsl:if>
																																														<xsl:variable name="var172_test_resultof_node_name_equal_qname" as="node()?">
																																															<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																<xsl:sequence select="."/>
																																															</xsl:if>
																																														</xsl:variable>
																																														<xsl:for-each select="$var172_test_resultof_node_name_equal_qname">
																																															<mglyph>
																																																<xsl:call-template name="tbf:tbf1_mglyph">
																																																	<xsl:with-param name="input" select="." as="node()"/>
																																																</xsl:call-template>
																																															</mglyph>
																																														</xsl:for-each>
																																														<xsl:variable name="var173_test_resultof_node_name_equal_qname" as="node()?">
																																															<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																<xsl:sequence select="."/>
																																															</xsl:if>
																																														</xsl:variable>
																																														<xsl:for-each select="$var173_test_resultof_node_name_equal_qname">
																																															<malignmark>
																																																<xsl:for-each select="@edge">
																																																	<xsl:attribute name="edge" select="fn:string(.)"/>
																																																</xsl:for-each>
																																															</malignmark>
																																														</xsl:for-each>
																																													</xsl:for-each>
																																												</mi>
																																											</xsl:for-each>
																																											<xsl:for-each select="mathnl:mn">
																																												<mn>
																																													<xsl:for-each select="@xlink:href">
																																														<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@class">
																																														<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@style">
																																														<xsl:attribute name="style" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@id">
																																														<xsl:attribute name="id" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@xref">
																																														<xsl:attribute name="xref" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@mathvariant">
																																														<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@mathsize">
																																														<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@mathcolor">
																																														<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@mathbackground">
																																														<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="node()">
																																														<xsl:if test="fn:boolean(self::text())">
																																															<xsl:sequence select="fn:string(.)"/>
																																														</xsl:if>
																																														<xsl:variable name="var174_test_resultof_node_name_equal_qname" as="node()?">
																																															<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																<xsl:sequence select="."/>
																																															</xsl:if>
																																														</xsl:variable>
																																														<xsl:for-each select="$var174_test_resultof_node_name_equal_qname">
																																															<mglyph>
																																																<xsl:call-template name="tbf:tbf1_mglyph">
																																																	<xsl:with-param name="input" select="." as="node()"/>
																																																</xsl:call-template>
																																															</mglyph>
																																														</xsl:for-each>
																																														<xsl:variable name="var175_test_resultof_node_name_equal_qname" as="node()?">
																																															<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																<xsl:sequence select="."/>
																																															</xsl:if>
																																														</xsl:variable>
																																														<xsl:for-each select="$var175_test_resultof_node_name_equal_qname">
																																															<malignmark>
																																																<xsl:for-each select="@edge">
																																																	<xsl:attribute name="edge" select="fn:string(.)"/>
																																																</xsl:for-each>
																																															</malignmark>
																																														</xsl:for-each>
																																													</xsl:for-each>
																																												</mn>
																																											</xsl:for-each>
																																											<xsl:for-each select="mathnl:mo">
																																												<mo>
																																													<xsl:for-each select="@xlink:href">
																																														<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@class">
																																														<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@style">
																																														<xsl:attribute name="style" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@id">
																																														<xsl:attribute name="id" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@xref">
																																														<xsl:attribute name="xref" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@mathvariant">
																																														<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@mathsize">
																																														<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@mathcolor">
																																														<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@mathbackground">
																																														<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@form">
																																														<xsl:attribute name="form" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@fence">
																																														<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@separator">
																																														<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@lspace">
																																														<xsl:attribute name="lspace" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@rspace">
																																														<xsl:attribute name="rspace" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@stretchy">
																																														<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@symmetric">
																																														<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@maxsize">
																																														<xsl:attribute name="maxsize" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@minsize">
																																														<xsl:attribute name="minsize" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@largeop">
																																														<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@movablelimits">
																																														<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@accent">
																																														<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="node()">
																																														<xsl:if test="fn:boolean(self::text())">
																																															<xsl:sequence select="fn:string(.)"/>
																																														</xsl:if>
																																														<xsl:variable name="var176_test_resultof_node_name_equal_qname" as="node()?">
																																															<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																<xsl:sequence select="."/>
																																															</xsl:if>
																																														</xsl:variable>
																																														<xsl:for-each select="$var176_test_resultof_node_name_equal_qname">
																																															<mglyph>
																																																<xsl:call-template name="tbf:tbf1_mglyph">
																																																	<xsl:with-param name="input" select="." as="node()"/>
																																																</xsl:call-template>
																																															</mglyph>
																																														</xsl:for-each>
																																														<xsl:variable name="var177_test_resultof_node_name_equal_qname" as="node()?">
																																															<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																<xsl:sequence select="."/>
																																															</xsl:if>
																																														</xsl:variable>
																																														<xsl:for-each select="$var177_test_resultof_node_name_equal_qname">
																																															<malignmark>
																																																<xsl:for-each select="@edge">
																																																	<xsl:attribute name="edge" select="fn:string(.)"/>
																																																</xsl:for-each>
																																															</malignmark>
																																														</xsl:for-each>
																																													</xsl:for-each>
																																												</mo>
																																											</xsl:for-each>
																																											<xsl:for-each select="mathnl:mtext">
																																												<mtext>
																																													<xsl:for-each select="@xlink:href">
																																														<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@class">
																																														<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@style">
																																														<xsl:attribute name="style" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@id">
																																														<xsl:attribute name="id" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@xref">
																																														<xsl:attribute name="xref" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@mathvariant">
																																														<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@mathsize">
																																														<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@mathcolor">
																																														<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@mathbackground">
																																														<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="node()">
																																														<xsl:if test="fn:boolean(self::text())">
																																															<xsl:sequence select="fn:string(.)"/>
																																														</xsl:if>
																																														<xsl:variable name="var178_test_resultof_node_name_equal_qname" as="node()?">
																																															<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																<xsl:sequence select="."/>
																																															</xsl:if>
																																														</xsl:variable>
																																														<xsl:for-each select="$var178_test_resultof_node_name_equal_qname">
																																															<mglyph>
																																																<xsl:call-template name="tbf:tbf1_mglyph">
																																																	<xsl:with-param name="input" select="." as="node()"/>
																																																</xsl:call-template>
																																															</mglyph>
																																														</xsl:for-each>
																																														<xsl:variable name="var179_test_resultof_node_name_equal_qname" as="node()?">
																																															<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																<xsl:sequence select="."/>
																																															</xsl:if>
																																														</xsl:variable>
																																														<xsl:for-each select="$var179_test_resultof_node_name_equal_qname">
																																															<malignmark>
																																																<xsl:for-each select="@edge">
																																																	<xsl:attribute name="edge" select="fn:string(.)"/>
																																																</xsl:for-each>
																																															</malignmark>
																																														</xsl:for-each>
																																													</xsl:for-each>
																																												</mtext>
																																											</xsl:for-each>
																																											<xsl:for-each select="mathnl:ms">
																																												<ms>
																																													<xsl:for-each select="@xlink:href">
																																														<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@class">
																																														<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@style">
																																														<xsl:attribute name="style" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@id">
																																														<xsl:attribute name="id" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@xref">
																																														<xsl:attribute name="xref" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@mathvariant">
																																														<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@mathsize">
																																														<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@mathcolor">
																																														<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@mathbackground">
																																														<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@lquote">
																																														<xsl:attribute name="lquote" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@rquote">
																																														<xsl:attribute name="rquote" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="node()">
																																														<xsl:if test="fn:boolean(self::text())">
																																															<xsl:sequence select="fn:string(.)"/>
																																														</xsl:if>
																																														<xsl:variable name="var180_test_resultof_node_name_equal_qname" as="node()?">
																																															<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																<xsl:sequence select="."/>
																																															</xsl:if>
																																														</xsl:variable>
																																														<xsl:for-each select="$var180_test_resultof_node_name_equal_qname">
																																															<mglyph>
																																																<xsl:call-template name="tbf:tbf1_mglyph">
																																																	<xsl:with-param name="input" select="." as="node()"/>
																																																</xsl:call-template>
																																															</mglyph>
																																														</xsl:for-each>
																																														<xsl:variable name="var181_test_resultof_node_name_equal_qname" as="node()?">
																																															<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																<xsl:sequence select="."/>
																																															</xsl:if>
																																														</xsl:variable>
																																														<xsl:for-each select="$var181_test_resultof_node_name_equal_qname">
																																															<malignmark>
																																																<xsl:for-each select="@edge">
																																																	<xsl:attribute name="edge" select="fn:string(.)"/>
																																																</xsl:for-each>
																																															</malignmark>
																																														</xsl:for-each>
																																													</xsl:for-each>
																																												</ms>
																																											</xsl:for-each>
																																											<xsl:for-each select="mathnl:mspace">
																																												<mspace>
																																													<xsl:for-each select="@width">
																																														<xsl:attribute name="width" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@height">
																																														<xsl:attribute name="height" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@depth">
																																														<xsl:attribute name="depth" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@linebreak">
																																														<xsl:attribute name="linebreak" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@xlink:href">
																																														<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@class">
																																														<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@style">
																																														<xsl:attribute name="style" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@id">
																																														<xsl:attribute name="id" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@xref">
																																														<xsl:attribute name="xref" select="fn:string(.)"/>
																																													</xsl:for-each>
																																												</mspace>
																																											</xsl:for-each>
																																											<xsl:for-each select="mathnl:mrow">
																																												<mrow>
																																													<xsl:sequence select="()"/>
																																												</mrow>
																																											</xsl:for-each>
																																											<xsl:for-each select="mathnl:mfrac">
																																												<mfrac>
																																													<xsl:sequence select="()"/>
																																												</mfrac>
																																											</xsl:for-each>
																																											<xsl:for-each select="mathnl:msqrt">
																																												<msqrt>
																																													<xsl:sequence select="()"/>
																																												</msqrt>
																																											</xsl:for-each>
																																											<xsl:for-each select="mathnl:mroot">
																																												<mroot>
																																													<xsl:sequence select="()"/>
																																												</mroot>
																																											</xsl:for-each>
																																											<xsl:for-each select="mathnl:menclose">
																																												<menclose>
																																													<xsl:sequence select="()"/>
																																												</menclose>
																																											</xsl:for-each>
																																											<xsl:for-each select="mathnl:merror">
																																												<merror>
																																													<xsl:for-each select="@xlink:href">
																																														<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@class">
																																														<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@style">
																																														<xsl:attribute name="style" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@id">
																																														<xsl:attribute name="id" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="@xref">
																																														<xsl:attribute name="xref" select="fn:string(.)"/>
																																													</xsl:for-each>
																																													<xsl:for-each select="mathnl:mi">
																																														<mi>
																																															<xsl:for-each select="@xlink:href">
																																																<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@class">
																																																<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@style">
																																																<xsl:attribute name="style" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@id">
																																																<xsl:attribute name="id" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@xref">
																																																<xsl:attribute name="xref" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mathvariant">
																																																<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mathsize">
																																																<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mathcolor">
																																																<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mathbackground">
																																																<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="node()">
																																																<xsl:if test="fn:boolean(self::text())">
																																																	<xsl:sequence select="fn:string(.)"/>
																																																</xsl:if>
																																																<xsl:variable name="var182_test_resultof_node_name_equal_qname" as="node()?">
																																																	<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																		<xsl:sequence select="."/>
																																																	</xsl:if>
																																																</xsl:variable>
																																																<xsl:for-each select="$var182_test_resultof_node_name_equal_qname">
																																																	<mglyph>
																																																		<xsl:call-template name="tbf:tbf1_mglyph">
																																																			<xsl:with-param name="input" select="." as="node()"/>
																																																		</xsl:call-template>
																																																	</mglyph>
																																																</xsl:for-each>
																																																<xsl:variable name="var183_test_resultof_node_name_equal_qname" as="node()?">
																																																	<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																		<xsl:sequence select="."/>
																																																	</xsl:if>
																																																</xsl:variable>
																																																<xsl:for-each select="$var183_test_resultof_node_name_equal_qname">
																																																	<malignmark>
																																																		<xsl:for-each select="@edge">
																																																			<xsl:attribute name="edge" select="fn:string(.)"/>
																																																		</xsl:for-each>
																																																	</malignmark>
																																																</xsl:for-each>
																																															</xsl:for-each>
																																														</mi>
																																													</xsl:for-each>
																																													<xsl:for-each select="mathnl:mn">
																																														<mn>
																																															<xsl:for-each select="@xlink:href">
																																																<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@class">
																																																<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@style">
																																																<xsl:attribute name="style" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@id">
																																																<xsl:attribute name="id" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@xref">
																																																<xsl:attribute name="xref" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mathvariant">
																																																<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mathsize">
																																																<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mathcolor">
																																																<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mathbackground">
																																																<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="node()">
																																																<xsl:if test="fn:boolean(self::text())">
																																																	<xsl:sequence select="fn:string(.)"/>
																																																</xsl:if>
																																																<xsl:variable name="var184_test_resultof_node_name_equal_qname" as="node()?">
																																																	<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																		<xsl:sequence select="."/>
																																																	</xsl:if>
																																																</xsl:variable>
																																																<xsl:for-each select="$var184_test_resultof_node_name_equal_qname">
																																																	<mglyph>
																																																		<xsl:call-template name="tbf:tbf1_mglyph">
																																																			<xsl:with-param name="input" select="." as="node()"/>
																																																		</xsl:call-template>
																																																	</mglyph>
																																																</xsl:for-each>
																																																<xsl:variable name="var185_test_resultof_node_name_equal_qname" as="node()?">
																																																	<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																		<xsl:sequence select="."/>
																																																	</xsl:if>
																																																</xsl:variable>
																																																<xsl:for-each select="$var185_test_resultof_node_name_equal_qname">
																																																	<malignmark>
																																																		<xsl:for-each select="@edge">
																																																			<xsl:attribute name="edge" select="fn:string(.)"/>
																																																		</xsl:for-each>
																																																	</malignmark>
																																																</xsl:for-each>
																																															</xsl:for-each>
																																														</mn>
																																													</xsl:for-each>
																																													<xsl:for-each select="mathnl:mo">
																																														<mo>
																																															<xsl:for-each select="@xlink:href">
																																																<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@class">
																																																<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@style">
																																																<xsl:attribute name="style" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@id">
																																																<xsl:attribute name="id" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@xref">
																																																<xsl:attribute name="xref" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mathvariant">
																																																<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mathsize">
																																																<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mathcolor">
																																																<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mathbackground">
																																																<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@form">
																																																<xsl:attribute name="form" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@fence">
																																																<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@separator">
																																																<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@lspace">
																																																<xsl:attribute name="lspace" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@rspace">
																																																<xsl:attribute name="rspace" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@stretchy">
																																																<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@symmetric">
																																																<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@maxsize">
																																																<xsl:attribute name="maxsize" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@minsize">
																																																<xsl:attribute name="minsize" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@largeop">
																																																<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@movablelimits">
																																																<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@accent">
																																																<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="node()">
																																																<xsl:if test="fn:boolean(self::text())">
																																																	<xsl:sequence select="fn:string(.)"/>
																																																</xsl:if>
																																																<xsl:variable name="var186_test_resultof_node_name_equal_qname" as="node()?">
																																																	<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																		<xsl:sequence select="."/>
																																																	</xsl:if>
																																																</xsl:variable>
																																																<xsl:for-each select="$var186_test_resultof_node_name_equal_qname">
																																																	<mglyph>
																																																		<xsl:call-template name="tbf:tbf1_mglyph">
																																																			<xsl:with-param name="input" select="." as="node()"/>
																																																		</xsl:call-template>
																																																	</mglyph>
																																																</xsl:for-each>
																																																<xsl:variable name="var187_test_resultof_node_name_equal_qname" as="node()?">
																																																	<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																		<xsl:sequence select="."/>
																																																	</xsl:if>
																																																</xsl:variable>
																																																<xsl:for-each select="$var187_test_resultof_node_name_equal_qname">
																																																	<malignmark>
																																																		<xsl:for-each select="@edge">
																																																			<xsl:attribute name="edge" select="fn:string(.)"/>
																																																		</xsl:for-each>
																																																	</malignmark>
																																																</xsl:for-each>
																																															</xsl:for-each>
																																														</mo>
																																													</xsl:for-each>
																																													<xsl:for-each select="mathnl:mtext">
																																														<mtext>
																																															<xsl:for-each select="@xlink:href">
																																																<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@class">
																																																<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@style">
																																																<xsl:attribute name="style" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@id">
																																																<xsl:attribute name="id" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@xref">
																																																<xsl:attribute name="xref" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mathvariant">
																																																<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mathsize">
																																																<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mathcolor">
																																																<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mathbackground">
																																																<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="node()">
																																																<xsl:if test="fn:boolean(self::text())">
																																																	<xsl:sequence select="fn:string(.)"/>
																																																</xsl:if>
																																																<xsl:variable name="var188_test_resultof_node_name_equal_qname" as="node()?">
																																																	<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																		<xsl:sequence select="."/>
																																																	</xsl:if>
																																																</xsl:variable>
																																																<xsl:for-each select="$var188_test_resultof_node_name_equal_qname">
																																																	<mglyph>
																																																		<xsl:call-template name="tbf:tbf1_mglyph">
																																																			<xsl:with-param name="input" select="." as="node()"/>
																																																		</xsl:call-template>
																																																	</mglyph>
																																																</xsl:for-each>
																																																<xsl:variable name="var189_test_resultof_node_name_equal_qname" as="node()?">
																																																	<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																		<xsl:sequence select="."/>
																																																	</xsl:if>
																																																</xsl:variable>
																																																<xsl:for-each select="$var189_test_resultof_node_name_equal_qname">
																																																	<malignmark>
																																																		<xsl:for-each select="@edge">
																																																			<xsl:attribute name="edge" select="fn:string(.)"/>
																																																		</xsl:for-each>
																																																	</malignmark>
																																																</xsl:for-each>
																																															</xsl:for-each>
																																														</mtext>
																																													</xsl:for-each>
																																													<xsl:for-each select="mathnl:ms">
																																														<ms>
																																															<xsl:for-each select="@xlink:href">
																																																<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@class">
																																																<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@style">
																																																<xsl:attribute name="style" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@id">
																																																<xsl:attribute name="id" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@xref">
																																																<xsl:attribute name="xref" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mathvariant">
																																																<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mathsize">
																																																<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mathcolor">
																																																<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mathbackground">
																																																<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@lquote">
																																																<xsl:attribute name="lquote" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@rquote">
																																																<xsl:attribute name="rquote" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="node()">
																																																<xsl:if test="fn:boolean(self::text())">
																																																	<xsl:sequence select="fn:string(.)"/>
																																																</xsl:if>
																																																<xsl:variable name="var190_test_resultof_node_name_equal_qname" as="node()?">
																																																	<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																		<xsl:sequence select="."/>
																																																	</xsl:if>
																																																</xsl:variable>
																																																<xsl:for-each select="$var190_test_resultof_node_name_equal_qname">
																																																	<mglyph>
																																																		<xsl:call-template name="tbf:tbf1_mglyph">
																																																			<xsl:with-param name="input" select="." as="node()"/>
																																																		</xsl:call-template>
																																																	</mglyph>
																																																</xsl:for-each>
																																																<xsl:variable name="var191_test_resultof_node_name_equal_qname" as="node()?">
																																																	<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																		<xsl:sequence select="."/>
																																																	</xsl:if>
																																																</xsl:variable>
																																																<xsl:for-each select="$var191_test_resultof_node_name_equal_qname">
																																																	<malignmark>
																																																		<xsl:for-each select="@edge">
																																																			<xsl:attribute name="edge" select="fn:string(.)"/>
																																																		</xsl:for-each>
																																																	</malignmark>
																																																</xsl:for-each>
																																															</xsl:for-each>
																																														</ms>
																																													</xsl:for-each>
																																													<xsl:for-each select="mathnl:mspace">
																																														<mspace>
																																															<xsl:for-each select="@width">
																																																<xsl:attribute name="width" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@height">
																																																<xsl:attribute name="height" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@depth">
																																																<xsl:attribute name="depth" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@linebreak">
																																																<xsl:attribute name="linebreak" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@xlink:href">
																																																<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@class">
																																																<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@style">
																																																<xsl:attribute name="style" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@id">
																																																<xsl:attribute name="id" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@xref">
																																																<xsl:attribute name="xref" select="fn:string(.)"/>
																																															</xsl:for-each>
																																														</mspace>
																																													</xsl:for-each>
																																													<xsl:for-each select="mathnl:mrow">
																																														<mrow>
																																															<xsl:sequence select="()"/>
																																														</mrow>
																																													</xsl:for-each>
																																													<xsl:for-each select="mathnl:mfrac">
																																														<mfrac>
																																															<xsl:sequence select="()"/>
																																														</mfrac>
																																													</xsl:for-each>
																																													<xsl:for-each select="mathnl:msqrt">
																																														<msqrt>
																																															<xsl:sequence select="()"/>
																																														</msqrt>
																																													</xsl:for-each>
																																													<xsl:for-each select="mathnl:mroot">
																																														<mroot>
																																															<xsl:sequence select="()"/>
																																														</mroot>
																																													</xsl:for-each>
																																													<xsl:for-each select="mathnl:menclose">
																																														<menclose>
																																															<xsl:sequence select="()"/>
																																														</menclose>
																																													</xsl:for-each>
																																													<xsl:for-each select="mathnl:mstyle">
																																														<mstyle>
																																															<xsl:for-each select="@xlink:href">
																																																<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@class">
																																																<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@style">
																																																<xsl:attribute name="style" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@id">
																																																<xsl:attribute name="id" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@xref">
																																																<xsl:attribute name="xref" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@color">
																																																<xsl:attribute name="color" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mathvariant">
																																																<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mathsize">
																																																<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mathcolor">
																																																<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mathbackground">
																																																<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@form">
																																																<xsl:attribute name="form" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@fence">
																																																<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@separator">
																																																<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@lspace">
																																																<xsl:attribute name="lspace" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@rspace">
																																																<xsl:attribute name="rspace" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@stretchy">
																																																<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@symmetric">
																																																<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@maxsize">
																																																<xsl:attribute name="maxsize" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@minsize">
																																																<xsl:attribute name="minsize" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@largeop">
																																																<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@movablelimits">
																																																<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@accent">
																																																<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@linethickness">
																																																<xsl:attribute name="linethickness" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@scriptlevel">
																																																<xsl:attribute name="scriptlevel" select="xs:string(xs:integer(fn:string(.)))"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@scriptsizemultiplier">
																																																<xsl:attribute name="scriptsizemultiplier" select="xs:string(xs:decimal(fn:string(.)))"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@scriptminsize">
																																																<xsl:attribute name="scriptminsize" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@background">
																																																<xsl:attribute name="background" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@veryverythinmathspace">
																																																<xsl:attribute name="veryverythinmathspace" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@verythinmathspace">
																																																<xsl:attribute name="verythinmathspace" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@thinmathspace">
																																																<xsl:attribute name="thinmathspace" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@mediummathspace">
																																																<xsl:attribute name="mediummathspace" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@thickmathspace">
																																																<xsl:attribute name="thickmathspace" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@verythickmathspace">
																																																<xsl:attribute name="verythickmathspace" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@veryverythickmathspace">
																																																<xsl:attribute name="veryverythickmathspace" select="fn:string(.)"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="@displaystyle">
																																																<xsl:attribute name="displaystyle" select="xs:string(xs:boolean(fn:string(.)))"/>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:mi">
																																																<mi>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@mathvariant">
																																																		<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@mathsize">
																																																		<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@mathcolor">
																																																		<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@mathbackground">
																																																		<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="node()">
																																																		<xsl:if test="fn:boolean(self::text())">
																																																			<xsl:sequence select="fn:string(.)"/>
																																																		</xsl:if>
																																																		<xsl:variable name="var192_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var192_test_resultof_node_name_equal_qname">
																																																			<mglyph>
																																																				<xsl:call-template name="tbf:tbf1_mglyph">
																																																					<xsl:with-param name="input" select="." as="node()"/>
																																																				</xsl:call-template>
																																																			</mglyph>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var193_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var193_test_resultof_node_name_equal_qname">
																																																			<malignmark>
																																																				<xsl:for-each select="@edge">
																																																					<xsl:attribute name="edge" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																			</malignmark>
																																																		</xsl:for-each>
																																																	</xsl:for-each>
																																																</mi>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:mn">
																																																<mn>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@mathvariant">
																																																		<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@mathsize">
																																																		<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@mathcolor">
																																																		<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@mathbackground">
																																																		<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="node()">
																																																		<xsl:if test="fn:boolean(self::text())">
																																																			<xsl:sequence select="fn:string(.)"/>
																																																		</xsl:if>
																																																		<xsl:variable name="var194_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var194_test_resultof_node_name_equal_qname">
																																																			<mglyph>
																																																				<xsl:call-template name="tbf:tbf1_mglyph">
																																																					<xsl:with-param name="input" select="." as="node()"/>
																																																				</xsl:call-template>
																																																			</mglyph>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var195_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var195_test_resultof_node_name_equal_qname">
																																																			<malignmark>
																																																				<xsl:for-each select="@edge">
																																																					<xsl:attribute name="edge" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																			</malignmark>
																																																		</xsl:for-each>
																																																	</xsl:for-each>
																																																</mn>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:mo">
																																																<mo>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@mathvariant">
																																																		<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@mathsize">
																																																		<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@mathcolor">
																																																		<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@mathbackground">
																																																		<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@form">
																																																		<xsl:attribute name="form" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@fence">
																																																		<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@separator">
																																																		<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@lspace">
																																																		<xsl:attribute name="lspace" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@rspace">
																																																		<xsl:attribute name="rspace" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@stretchy">
																																																		<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@symmetric">
																																																		<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@maxsize">
																																																		<xsl:attribute name="maxsize" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@minsize">
																																																		<xsl:attribute name="minsize" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@largeop">
																																																		<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@movablelimits">
																																																		<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@accent">
																																																		<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="node()">
																																																		<xsl:if test="fn:boolean(self::text())">
																																																			<xsl:sequence select="fn:string(.)"/>
																																																		</xsl:if>
																																																		<xsl:variable name="var196_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var196_test_resultof_node_name_equal_qname">
																																																			<mglyph>
																																																				<xsl:call-template name="tbf:tbf1_mglyph">
																																																					<xsl:with-param name="input" select="." as="node()"/>
																																																				</xsl:call-template>
																																																			</mglyph>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var197_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var197_test_resultof_node_name_equal_qname">
																																																			<malignmark>
																																																				<xsl:for-each select="@edge">
																																																					<xsl:attribute name="edge" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																			</malignmark>
																																																		</xsl:for-each>
																																																	</xsl:for-each>
																																																</mo>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:mtext">
																																																<mtext>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@mathvariant">
																																																		<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@mathsize">
																																																		<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@mathcolor">
																																																		<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@mathbackground">
																																																		<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="node()">
																																																		<xsl:if test="fn:boolean(self::text())">
																																																			<xsl:sequence select="fn:string(.)"/>
																																																		</xsl:if>
																																																		<xsl:variable name="var198_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var198_test_resultof_node_name_equal_qname">
																																																			<mglyph>
																																																				<xsl:call-template name="tbf:tbf1_mglyph">
																																																					<xsl:with-param name="input" select="." as="node()"/>
																																																				</xsl:call-template>
																																																			</mglyph>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var199_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var199_test_resultof_node_name_equal_qname">
																																																			<malignmark>
																																																				<xsl:for-each select="@edge">
																																																					<xsl:attribute name="edge" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																			</malignmark>
																																																		</xsl:for-each>
																																																	</xsl:for-each>
																																																</mtext>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:ms">
																																																<ms>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@mathvariant">
																																																		<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@mathsize">
																																																		<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@mathcolor">
																																																		<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@mathbackground">
																																																		<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@lquote">
																																																		<xsl:attribute name="lquote" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@rquote">
																																																		<xsl:attribute name="rquote" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="node()">
																																																		<xsl:if test="fn:boolean(self::text())">
																																																			<xsl:sequence select="fn:string(.)"/>
																																																		</xsl:if>
																																																		<xsl:variable name="var200_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var200_test_resultof_node_name_equal_qname">
																																																			<mglyph>
																																																				<xsl:call-template name="tbf:tbf1_mglyph">
																																																					<xsl:with-param name="input" select="." as="node()"/>
																																																				</xsl:call-template>
																																																			</mglyph>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var201_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var201_test_resultof_node_name_equal_qname">
																																																			<malignmark>
																																																				<xsl:for-each select="@edge">
																																																					<xsl:attribute name="edge" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																			</malignmark>
																																																		</xsl:for-each>
																																																	</xsl:for-each>
																																																</ms>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:mspace">
																																																<mspace>
																																																	<xsl:for-each select="@width">
																																																		<xsl:attribute name="width" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@height">
																																																		<xsl:attribute name="height" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@depth">
																																																		<xsl:attribute name="depth" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@linebreak">
																																																		<xsl:attribute name="linebreak" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																</mspace>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:mrow">
																																																<mrow>
																																																	<xsl:sequence select="()"/>
																																																</mrow>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:mfrac">
																																																<mfrac>
																																																	<xsl:sequence select="()"/>
																																																</mfrac>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:msqrt">
																																																<msqrt>
																																																	<xsl:sequence select="()"/>
																																																</msqrt>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:mroot">
																																																<mroot>
																																																	<xsl:sequence select="()"/>
																																																</mroot>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:menclose">
																																																<menclose>
																																																	<xsl:sequence select="()"/>
																																																</menclose>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:mstyle">
																																																<mstyle>
																																																	<xsl:sequence select="()"/>
																																																</mstyle>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:merror">
																																																<merror>
																																																	<xsl:sequence select="()"/>
																																																</merror>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:mpadded">
																																																<mpadded>
																																																	<xsl:sequence select="()"/>
																																																</mpadded>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:mphantom">
																																																<mphantom>
																																																	<xsl:sequence select="()"/>
																																																</mphantom>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:mfenced">
																																																<mfenced>
																																																	<xsl:sequence select="()"/>
																																																</mfenced>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:msub">
																																																<msub>
																																																	<xsl:sequence select="()"/>
																																																</msub>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:msup">
																																																<msup>
																																																	<xsl:sequence select="()"/>
																																																</msup>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:msubsup">
																																																<msubsup>
																																																	<xsl:sequence select="()"/>
																																																</msubsup>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:munder">
																																																<munder>
																																																	<xsl:sequence select="()"/>
																																																</munder>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:mover">
																																																<mover>
																																																	<xsl:sequence select="()"/>
																																																</mover>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:munderover">
																																																<munderover>
																																																	<xsl:sequence select="()"/>
																																																</munderover>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:mmultiscripts">
																																																<mmultiscripts>
																																																	<xsl:sequence select="()"/>
																																																</mmultiscripts>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:mtable">
																																																<mtable>
																																																	<xsl:sequence select="()"/>
																																																</mtable>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:maligngroup">
																																																<maligngroup>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@groupalign">
																																																		<xsl:attribute name="groupalign" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																</maligngroup>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:malignmark">
																																																<malignmark>
																																																	<xsl:for-each select="@edge">
																																																		<xsl:attribute name="edge" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																</malignmark>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:maction">
																																																<maction>
																																																	<xsl:sequence select="()"/>
																																																</maction>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:ci">
																																																<xsl:variable name="var239_type" as="node()?" select="@type"/>
																																																<ci>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="$var239_type">
																																																		<xsl:attribute name="xlink:type" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="$var239_type">
																																																		<xsl:attribute name="type" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@definitionURL">
																																																		<xsl:attribute name="definitionURL" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@encoding">
																																																		<xsl:attribute name="encoding" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="node()">
																																																		<xsl:if test="fn:boolean(self::text())">
																																																			<xsl:sequence select="fn:string(.)"/>
																																																		</xsl:if>
																																																		<xsl:variable name="var202_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mi)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var202_test_resultof_node_name_equal_qname">
																																																			<mi>
																																																				<xsl:for-each select="@xlink:href">
																																																					<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@class">
																																																					<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@style">
																																																					<xsl:attribute name="style" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@id">
																																																					<xsl:attribute name="id" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@xref">
																																																					<xsl:attribute name="xref" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathvariant">
																																																					<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathsize">
																																																					<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathcolor">
																																																					<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathbackground">
																																																					<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="node()">
																																																					<xsl:if test="fn:boolean(self::text())">
																																																						<xsl:sequence select="fn:string(.)"/>
																																																					</xsl:if>
																																																					<xsl:variable name="var203_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var203_test_resultof_node_name_equal_qname">
																																																						<mglyph>
																																																							<xsl:call-template name="tbf:tbf1_mglyph">
																																																								<xsl:with-param name="input" select="." as="node()"/>
																																																							</xsl:call-template>
																																																						</mglyph>
																																																					</xsl:for-each>
																																																					<xsl:variable name="var204_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var204_test_resultof_node_name_equal_qname">
																																																						<malignmark>
																																																							<xsl:for-each select="@edge">
																																																								<xsl:attribute name="edge" select="fn:string(.)"/>
																																																							</xsl:for-each>
																																																						</malignmark>
																																																					</xsl:for-each>
																																																				</xsl:for-each>
																																																			</mi>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var205_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mn)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var205_test_resultof_node_name_equal_qname">
																																																			<mn>
																																																				<xsl:for-each select="@xlink:href">
																																																					<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@class">
																																																					<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@style">
																																																					<xsl:attribute name="style" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@id">
																																																					<xsl:attribute name="id" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@xref">
																																																					<xsl:attribute name="xref" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathvariant">
																																																					<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathsize">
																																																					<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathcolor">
																																																					<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathbackground">
																																																					<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="node()">
																																																					<xsl:if test="fn:boolean(self::text())">
																																																						<xsl:sequence select="fn:string(.)"/>
																																																					</xsl:if>
																																																					<xsl:variable name="var206_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var206_test_resultof_node_name_equal_qname">
																																																						<mglyph>
																																																							<xsl:call-template name="tbf:tbf1_mglyph">
																																																								<xsl:with-param name="input" select="." as="node()"/>
																																																							</xsl:call-template>
																																																						</mglyph>
																																																					</xsl:for-each>
																																																					<xsl:variable name="var207_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var207_test_resultof_node_name_equal_qname">
																																																						<malignmark>
																																																							<xsl:for-each select="@edge">
																																																								<xsl:attribute name="edge" select="fn:string(.)"/>
																																																							</xsl:for-each>
																																																						</malignmark>
																																																					</xsl:for-each>
																																																				</xsl:for-each>
																																																			</mn>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var208_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mo)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var208_test_resultof_node_name_equal_qname">
																																																			<mo>
																																																				<xsl:for-each select="@xlink:href">
																																																					<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@class">
																																																					<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@style">
																																																					<xsl:attribute name="style" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@id">
																																																					<xsl:attribute name="id" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@xref">
																																																					<xsl:attribute name="xref" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathvariant">
																																																					<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathsize">
																																																					<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathcolor">
																																																					<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathbackground">
																																																					<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@form">
																																																					<xsl:attribute name="form" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@fence">
																																																					<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@separator">
																																																					<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@lspace">
																																																					<xsl:attribute name="lspace" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@rspace">
																																																					<xsl:attribute name="rspace" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@stretchy">
																																																					<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@symmetric">
																																																					<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@maxsize">
																																																					<xsl:attribute name="maxsize" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@minsize">
																																																					<xsl:attribute name="minsize" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@largeop">
																																																					<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@movablelimits">
																																																					<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@accent">
																																																					<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="node()">
																																																					<xsl:if test="fn:boolean(self::text())">
																																																						<xsl:sequence select="fn:string(.)"/>
																																																					</xsl:if>
																																																					<xsl:variable name="var209_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var209_test_resultof_node_name_equal_qname">
																																																						<mglyph>
																																																							<xsl:call-template name="tbf:tbf1_mglyph">
																																																								<xsl:with-param name="input" select="." as="node()"/>
																																																							</xsl:call-template>
																																																						</mglyph>
																																																					</xsl:for-each>
																																																					<xsl:variable name="var210_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var210_test_resultof_node_name_equal_qname">
																																																						<malignmark>
																																																							<xsl:for-each select="@edge">
																																																								<xsl:attribute name="edge" select="fn:string(.)"/>
																																																							</xsl:for-each>
																																																						</malignmark>
																																																					</xsl:for-each>
																																																				</xsl:for-each>
																																																			</mo>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var211_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mtext)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var211_test_resultof_node_name_equal_qname">
																																																			<mtext>
																																																				<xsl:for-each select="@xlink:href">
																																																					<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@class">
																																																					<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@style">
																																																					<xsl:attribute name="style" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@id">
																																																					<xsl:attribute name="id" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@xref">
																																																					<xsl:attribute name="xref" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathvariant">
																																																					<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathsize">
																																																					<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathcolor">
																																																					<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathbackground">
																																																					<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="node()">
																																																					<xsl:if test="fn:boolean(self::text())">
																																																						<xsl:sequence select="fn:string(.)"/>
																																																					</xsl:if>
																																																					<xsl:variable name="var212_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var212_test_resultof_node_name_equal_qname">
																																																						<mglyph>
																																																							<xsl:call-template name="tbf:tbf1_mglyph">
																																																								<xsl:with-param name="input" select="." as="node()"/>
																																																							</xsl:call-template>
																																																						</mglyph>
																																																					</xsl:for-each>
																																																					<xsl:variable name="var213_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var213_test_resultof_node_name_equal_qname">
																																																						<malignmark>
																																																							<xsl:for-each select="@edge">
																																																								<xsl:attribute name="edge" select="fn:string(.)"/>
																																																							</xsl:for-each>
																																																						</malignmark>
																																																					</xsl:for-each>
																																																				</xsl:for-each>
																																																			</mtext>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var214_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:ms)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var214_test_resultof_node_name_equal_qname">
																																																			<ms>
																																																				<xsl:for-each select="@xlink:href">
																																																					<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@class">
																																																					<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@style">
																																																					<xsl:attribute name="style" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@id">
																																																					<xsl:attribute name="id" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@xref">
																																																					<xsl:attribute name="xref" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathvariant">
																																																					<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathsize">
																																																					<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathcolor">
																																																					<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathbackground">
																																																					<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@lquote">
																																																					<xsl:attribute name="lquote" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@rquote">
																																																					<xsl:attribute name="rquote" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="node()">
																																																					<xsl:if test="fn:boolean(self::text())">
																																																						<xsl:sequence select="fn:string(.)"/>
																																																					</xsl:if>
																																																					<xsl:variable name="var215_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var215_test_resultof_node_name_equal_qname">
																																																						<mglyph>
																																																							<xsl:call-template name="tbf:tbf1_mglyph">
																																																								<xsl:with-param name="input" select="." as="node()"/>
																																																							</xsl:call-template>
																																																						</mglyph>
																																																					</xsl:for-each>
																																																					<xsl:variable name="var216_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var216_test_resultof_node_name_equal_qname">
																																																						<malignmark>
																																																							<xsl:for-each select="@edge">
																																																								<xsl:attribute name="edge" select="fn:string(.)"/>
																																																							</xsl:for-each>
																																																						</malignmark>
																																																					</xsl:for-each>
																																																				</xsl:for-each>
																																																			</ms>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var217_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mspace)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var217_test_resultof_node_name_equal_qname">
																																																			<mspace>
																																																				<xsl:for-each select="@width">
																																																					<xsl:attribute name="width" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@height">
																																																					<xsl:attribute name="height" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@depth">
																																																					<xsl:attribute name="depth" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@linebreak">
																																																					<xsl:attribute name="linebreak" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@xlink:href">
																																																					<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@class">
																																																					<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@style">
																																																					<xsl:attribute name="style" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@id">
																																																					<xsl:attribute name="id" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@xref">
																																																					<xsl:attribute name="xref" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																			</mspace>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var218_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mrow)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var218_test_resultof_node_name_equal_qname">
																																																			<mrow>
																																																				<xsl:sequence select="()"/>
																																																			</mrow>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var219_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mfrac)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var219_test_resultof_node_name_equal_qname">
																																																			<mfrac>
																																																				<xsl:sequence select="()"/>
																																																			</mfrac>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var220_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:msqrt)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var220_test_resultof_node_name_equal_qname">
																																																			<msqrt>
																																																				<xsl:sequence select="()"/>
																																																			</msqrt>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var221_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mroot)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var221_test_resultof_node_name_equal_qname">
																																																			<mroot>
																																																				<xsl:sequence select="()"/>
																																																			</mroot>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var222_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:menclose)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var222_test_resultof_node_name_equal_qname">
																																																			<menclose>
																																																				<xsl:sequence select="()"/>
																																																			</menclose>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var223_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mstyle)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var223_test_resultof_node_name_equal_qname">
																																																			<mstyle>
																																																				<xsl:sequence select="()"/>
																																																			</mstyle>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var224_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:merror)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var224_test_resultof_node_name_equal_qname">
																																																			<merror>
																																																				<xsl:sequence select="()"/>
																																																			</merror>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var225_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mpadded)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var225_test_resultof_node_name_equal_qname">
																																																			<mpadded>
																																																				<xsl:sequence select="()"/>
																																																			</mpadded>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var226_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mphantom)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var226_test_resultof_node_name_equal_qname">
																																																			<mphantom>
																																																				<xsl:sequence select="()"/>
																																																			</mphantom>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var227_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mfenced)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var227_test_resultof_node_name_equal_qname">
																																																			<mfenced>
																																																				<xsl:sequence select="()"/>
																																																			</mfenced>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var228_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:msub)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var228_test_resultof_node_name_equal_qname">
																																																			<msub>
																																																				<xsl:sequence select="()"/>
																																																			</msub>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var229_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:msup)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var229_test_resultof_node_name_equal_qname">
																																																			<msup>
																																																				<xsl:sequence select="()"/>
																																																			</msup>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var230_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:msubsup)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var230_test_resultof_node_name_equal_qname">
																																																			<msubsup>
																																																				<xsl:sequence select="()"/>
																																																			</msubsup>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var231_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:munder)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var231_test_resultof_node_name_equal_qname">
																																																			<munder>
																																																				<xsl:sequence select="()"/>
																																																			</munder>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var232_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mover)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var232_test_resultof_node_name_equal_qname">
																																																			<mover>
																																																				<xsl:sequence select="()"/>
																																																			</mover>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var233_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:munderover)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var233_test_resultof_node_name_equal_qname">
																																																			<munderover>
																																																				<xsl:sequence select="()"/>
																																																			</munderover>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var234_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mmultiscripts)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var234_test_resultof_node_name_equal_qname">
																																																			<mmultiscripts>
																																																				<xsl:sequence select="()"/>
																																																			</mmultiscripts>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var235_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mtable)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var235_test_resultof_node_name_equal_qname">
																																																			<mtable>
																																																				<xsl:sequence select="()"/>
																																																			</mtable>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var236_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:maligngroup)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var236_test_resultof_node_name_equal_qname">
																																																			<maligngroup>
																																																				<xsl:for-each select="@xlink:href">
																																																					<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@class">
																																																					<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@style">
																																																					<xsl:attribute name="style" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@id">
																																																					<xsl:attribute name="id" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@xref">
																																																					<xsl:attribute name="xref" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@groupalign">
																																																					<xsl:attribute name="groupalign" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																			</maligngroup>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var237_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var237_test_resultof_node_name_equal_qname">
																																																			<malignmark>
																																																				<xsl:for-each select="@edge">
																																																					<xsl:attribute name="edge" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																			</malignmark>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var238_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:maction)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var238_test_resultof_node_name_equal_qname">
																																																			<maction>
																																																				<xsl:sequence select="()"/>
																																																			</maction>
																																																		</xsl:for-each>
																																																	</xsl:for-each>
																																																</ci>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:csymbol">
																																																<csymbol>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@encoding">
																																																		<xsl:attribute name="encoding" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@definitionURL">
																																																		<xsl:attribute name="definitionURL" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="node()">
																																																		<xsl:if test="fn:boolean(self::text())">
																																																			<xsl:sequence select="fn:string(.)"/>
																																																		</xsl:if>
																																																		<xsl:variable name="var240_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mi)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var240_test_resultof_node_name_equal_qname">
																																																			<mi>
																																																				<xsl:for-each select="@xlink:href">
																																																					<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@class">
																																																					<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@style">
																																																					<xsl:attribute name="style" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@id">
																																																					<xsl:attribute name="id" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@xref">
																																																					<xsl:attribute name="xref" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathvariant">
																																																					<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathsize">
																																																					<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathcolor">
																																																					<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathbackground">
																																																					<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="node()">
																																																					<xsl:if test="fn:boolean(self::text())">
																																																						<xsl:sequence select="fn:string(.)"/>
																																																					</xsl:if>
																																																					<xsl:variable name="var241_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var241_test_resultof_node_name_equal_qname">
																																																						<mglyph>
																																																							<xsl:call-template name="tbf:tbf1_mglyph">
																																																								<xsl:with-param name="input" select="." as="node()"/>
																																																							</xsl:call-template>
																																																						</mglyph>
																																																					</xsl:for-each>
																																																					<xsl:variable name="var242_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var242_test_resultof_node_name_equal_qname">
																																																						<malignmark>
																																																							<xsl:for-each select="@edge">
																																																								<xsl:attribute name="edge" select="fn:string(.)"/>
																																																							</xsl:for-each>
																																																						</malignmark>
																																																					</xsl:for-each>
																																																				</xsl:for-each>
																																																			</mi>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var243_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mn)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var243_test_resultof_node_name_equal_qname">
																																																			<mn>
																																																				<xsl:for-each select="@xlink:href">
																																																					<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@class">
																																																					<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@style">
																																																					<xsl:attribute name="style" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@id">
																																																					<xsl:attribute name="id" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@xref">
																																																					<xsl:attribute name="xref" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathvariant">
																																																					<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathsize">
																																																					<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathcolor">
																																																					<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathbackground">
																																																					<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="node()">
																																																					<xsl:if test="fn:boolean(self::text())">
																																																						<xsl:sequence select="fn:string(.)"/>
																																																					</xsl:if>
																																																					<xsl:variable name="var244_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var244_test_resultof_node_name_equal_qname">
																																																						<mglyph>
																																																							<xsl:call-template name="tbf:tbf1_mglyph">
																																																								<xsl:with-param name="input" select="." as="node()"/>
																																																							</xsl:call-template>
																																																						</mglyph>
																																																					</xsl:for-each>
																																																					<xsl:variable name="var245_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var245_test_resultof_node_name_equal_qname">
																																																						<malignmark>
																																																							<xsl:for-each select="@edge">
																																																								<xsl:attribute name="edge" select="fn:string(.)"/>
																																																							</xsl:for-each>
																																																						</malignmark>
																																																					</xsl:for-each>
																																																				</xsl:for-each>
																																																			</mn>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var246_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mo)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var246_test_resultof_node_name_equal_qname">
																																																			<mo>
																																																				<xsl:for-each select="@xlink:href">
																																																					<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@class">
																																																					<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@style">
																																																					<xsl:attribute name="style" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@id">
																																																					<xsl:attribute name="id" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@xref">
																																																					<xsl:attribute name="xref" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathvariant">
																																																					<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathsize">
																																																					<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathcolor">
																																																					<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathbackground">
																																																					<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@form">
																																																					<xsl:attribute name="form" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@fence">
																																																					<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@separator">
																																																					<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@lspace">
																																																					<xsl:attribute name="lspace" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@rspace">
																																																					<xsl:attribute name="rspace" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@stretchy">
																																																					<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@symmetric">
																																																					<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@maxsize">
																																																					<xsl:attribute name="maxsize" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@minsize">
																																																					<xsl:attribute name="minsize" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@largeop">
																																																					<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@movablelimits">
																																																					<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@accent">
																																																					<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="node()">
																																																					<xsl:if test="fn:boolean(self::text())">
																																																						<xsl:sequence select="fn:string(.)"/>
																																																					</xsl:if>
																																																					<xsl:variable name="var247_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var247_test_resultof_node_name_equal_qname">
																																																						<mglyph>
																																																							<xsl:call-template name="tbf:tbf1_mglyph">
																																																								<xsl:with-param name="input" select="." as="node()"/>
																																																							</xsl:call-template>
																																																						</mglyph>
																																																					</xsl:for-each>
																																																					<xsl:variable name="var248_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var248_test_resultof_node_name_equal_qname">
																																																						<malignmark>
																																																							<xsl:for-each select="@edge">
																																																								<xsl:attribute name="edge" select="fn:string(.)"/>
																																																							</xsl:for-each>
																																																						</malignmark>
																																																					</xsl:for-each>
																																																				</xsl:for-each>
																																																			</mo>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var249_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mtext)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var249_test_resultof_node_name_equal_qname">
																																																			<mtext>
																																																				<xsl:for-each select="@xlink:href">
																																																					<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@class">
																																																					<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@style">
																																																					<xsl:attribute name="style" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@id">
																																																					<xsl:attribute name="id" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@xref">
																																																					<xsl:attribute name="xref" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathvariant">
																																																					<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathsize">
																																																					<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathcolor">
																																																					<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathbackground">
																																																					<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="node()">
																																																					<xsl:if test="fn:boolean(self::text())">
																																																						<xsl:sequence select="fn:string(.)"/>
																																																					</xsl:if>
																																																					<xsl:variable name="var250_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var250_test_resultof_node_name_equal_qname">
																																																						<mglyph>
																																																							<xsl:call-template name="tbf:tbf1_mglyph">
																																																								<xsl:with-param name="input" select="." as="node()"/>
																																																							</xsl:call-template>
																																																						</mglyph>
																																																					</xsl:for-each>
																																																					<xsl:variable name="var251_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var251_test_resultof_node_name_equal_qname">
																																																						<malignmark>
																																																							<xsl:for-each select="@edge">
																																																								<xsl:attribute name="edge" select="fn:string(.)"/>
																																																							</xsl:for-each>
																																																						</malignmark>
																																																					</xsl:for-each>
																																																				</xsl:for-each>
																																																			</mtext>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var252_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:ms)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var252_test_resultof_node_name_equal_qname">
																																																			<ms>
																																																				<xsl:for-each select="@xlink:href">
																																																					<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@class">
																																																					<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@style">
																																																					<xsl:attribute name="style" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@id">
																																																					<xsl:attribute name="id" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@xref">
																																																					<xsl:attribute name="xref" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathvariant">
																																																					<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathsize">
																																																					<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathcolor">
																																																					<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathbackground">
																																																					<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@lquote">
																																																					<xsl:attribute name="lquote" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@rquote">
																																																					<xsl:attribute name="rquote" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="node()">
																																																					<xsl:if test="fn:boolean(self::text())">
																																																						<xsl:sequence select="fn:string(.)"/>
																																																					</xsl:if>
																																																					<xsl:variable name="var253_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var253_test_resultof_node_name_equal_qname">
																																																						<mglyph>
																																																							<xsl:call-template name="tbf:tbf1_mglyph">
																																																								<xsl:with-param name="input" select="." as="node()"/>
																																																							</xsl:call-template>
																																																						</mglyph>
																																																					</xsl:for-each>
																																																					<xsl:variable name="var254_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var254_test_resultof_node_name_equal_qname">
																																																						<malignmark>
																																																							<xsl:for-each select="@edge">
																																																								<xsl:attribute name="edge" select="fn:string(.)"/>
																																																							</xsl:for-each>
																																																						</malignmark>
																																																					</xsl:for-each>
																																																				</xsl:for-each>
																																																			</ms>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var255_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mspace)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var255_test_resultof_node_name_equal_qname">
																																																			<mspace>
																																																				<xsl:for-each select="@width">
																																																					<xsl:attribute name="width" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@height">
																																																					<xsl:attribute name="height" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@depth">
																																																					<xsl:attribute name="depth" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@linebreak">
																																																					<xsl:attribute name="linebreak" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@xlink:href">
																																																					<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@class">
																																																					<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@style">
																																																					<xsl:attribute name="style" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@id">
																																																					<xsl:attribute name="id" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@xref">
																																																					<xsl:attribute name="xref" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																			</mspace>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var256_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mrow)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var256_test_resultof_node_name_equal_qname">
																																																			<mrow>
																																																				<xsl:sequence select="()"/>
																																																			</mrow>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var257_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mfrac)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var257_test_resultof_node_name_equal_qname">
																																																			<mfrac>
																																																				<xsl:sequence select="()"/>
																																																			</mfrac>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var258_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:msqrt)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var258_test_resultof_node_name_equal_qname">
																																																			<msqrt>
																																																				<xsl:sequence select="()"/>
																																																			</msqrt>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var259_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mroot)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var259_test_resultof_node_name_equal_qname">
																																																			<mroot>
																																																				<xsl:sequence select="()"/>
																																																			</mroot>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var260_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:menclose)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var260_test_resultof_node_name_equal_qname">
																																																			<menclose>
																																																				<xsl:sequence select="()"/>
																																																			</menclose>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var261_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mstyle)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var261_test_resultof_node_name_equal_qname">
																																																			<mstyle>
																																																				<xsl:sequence select="()"/>
																																																			</mstyle>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var262_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:merror)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var262_test_resultof_node_name_equal_qname">
																																																			<merror>
																																																				<xsl:sequence select="()"/>
																																																			</merror>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var263_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mpadded)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var263_test_resultof_node_name_equal_qname">
																																																			<mpadded>
																																																				<xsl:sequence select="()"/>
																																																			</mpadded>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var264_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mphantom)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var264_test_resultof_node_name_equal_qname">
																																																			<mphantom>
																																																				<xsl:sequence select="()"/>
																																																			</mphantom>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var265_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mfenced)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var265_test_resultof_node_name_equal_qname">
																																																			<mfenced>
																																																				<xsl:sequence select="()"/>
																																																			</mfenced>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var266_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:msub)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var266_test_resultof_node_name_equal_qname">
																																																			<msub>
																																																				<xsl:sequence select="()"/>
																																																			</msub>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var267_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:msup)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var267_test_resultof_node_name_equal_qname">
																																																			<msup>
																																																				<xsl:sequence select="()"/>
																																																			</msup>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var268_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:msubsup)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var268_test_resultof_node_name_equal_qname">
																																																			<msubsup>
																																																				<xsl:sequence select="()"/>
																																																			</msubsup>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var269_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:munder)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var269_test_resultof_node_name_equal_qname">
																																																			<munder>
																																																				<xsl:sequence select="()"/>
																																																			</munder>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var270_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mover)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var270_test_resultof_node_name_equal_qname">
																																																			<mover>
																																																				<xsl:sequence select="()"/>
																																																			</mover>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var271_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:munderover)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var271_test_resultof_node_name_equal_qname">
																																																			<munderover>
																																																				<xsl:sequence select="()"/>
																																																			</munderover>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var272_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mmultiscripts)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var272_test_resultof_node_name_equal_qname">
																																																			<mmultiscripts>
																																																				<xsl:sequence select="()"/>
																																																			</mmultiscripts>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var273_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mtable)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var273_test_resultof_node_name_equal_qname">
																																																			<mtable>
																																																				<xsl:sequence select="()"/>
																																																			</mtable>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var274_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:maligngroup)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var274_test_resultof_node_name_equal_qname">
																																																			<maligngroup>
																																																				<xsl:for-each select="@xlink:href">
																																																					<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@class">
																																																					<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@style">
																																																					<xsl:attribute name="style" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@id">
																																																					<xsl:attribute name="id" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@xref">
																																																					<xsl:attribute name="xref" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@groupalign">
																																																					<xsl:attribute name="groupalign" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																			</maligngroup>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var275_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var275_test_resultof_node_name_equal_qname">
																																																			<malignmark>
																																																				<xsl:for-each select="@edge">
																																																					<xsl:attribute name="edge" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																			</malignmark>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var276_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:maction)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var276_test_resultof_node_name_equal_qname">
																																																			<maction>
																																																				<xsl:sequence select="()"/>
																																																			</maction>
																																																		</xsl:for-each>
																																																	</xsl:for-each>
																																																</csymbol>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:cn">
																																																<xsl:variable name="var315_type" as="node()?" select="@type"/>
																																																<cn>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="$var315_type">
																																																		<xsl:attribute name="xlink:type" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="$var315_type">
																																																		<xsl:attribute name="type" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@base">
																																																		<xsl:attribute name="base" select="xs:string(xs:integer(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@definitionURL">
																																																		<xsl:attribute name="definitionURL" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@encoding">
																																																		<xsl:attribute name="encoding" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="node()">
																																																		<xsl:if test="fn:boolean(self::text())">
																																																			<xsl:sequence select="fn:string(.)"/>
																																																		</xsl:if>
																																																		<xsl:variable name="var277_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:sep)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var277_test_resultof_node_name_equal_qname">
																																																			<sep>
																																																				<xsl:sequence select="()"/>
																																																			</sep>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var278_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mi)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var278_test_resultof_node_name_equal_qname">
																																																			<mi>
																																																				<xsl:for-each select="@xlink:href">
																																																					<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@class">
																																																					<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@style">
																																																					<xsl:attribute name="style" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@id">
																																																					<xsl:attribute name="id" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@xref">
																																																					<xsl:attribute name="xref" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathvariant">
																																																					<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathsize">
																																																					<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathcolor">
																																																					<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathbackground">
																																																					<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="node()">
																																																					<xsl:if test="fn:boolean(self::text())">
																																																						<xsl:sequence select="fn:string(.)"/>
																																																					</xsl:if>
																																																					<xsl:variable name="var279_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var279_test_resultof_node_name_equal_qname">
																																																						<mglyph>
																																																							<xsl:call-template name="tbf:tbf1_mglyph">
																																																								<xsl:with-param name="input" select="." as="node()"/>
																																																							</xsl:call-template>
																																																						</mglyph>
																																																					</xsl:for-each>
																																																					<xsl:variable name="var280_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var280_test_resultof_node_name_equal_qname">
																																																						<malignmark>
																																																							<xsl:for-each select="@edge">
																																																								<xsl:attribute name="edge" select="fn:string(.)"/>
																																																							</xsl:for-each>
																																																						</malignmark>
																																																					</xsl:for-each>
																																																				</xsl:for-each>
																																																			</mi>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var281_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mn)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var281_test_resultof_node_name_equal_qname">
																																																			<mn>
																																																				<xsl:for-each select="@xlink:href">
																																																					<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@class">
																																																					<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@style">
																																																					<xsl:attribute name="style" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@id">
																																																					<xsl:attribute name="id" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@xref">
																																																					<xsl:attribute name="xref" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathvariant">
																																																					<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathsize">
																																																					<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathcolor">
																																																					<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathbackground">
																																																					<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="node()">
																																																					<xsl:if test="fn:boolean(self::text())">
																																																						<xsl:sequence select="fn:string(.)"/>
																																																					</xsl:if>
																																																					<xsl:variable name="var282_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var282_test_resultof_node_name_equal_qname">
																																																						<mglyph>
																																																							<xsl:call-template name="tbf:tbf1_mglyph">
																																																								<xsl:with-param name="input" select="." as="node()"/>
																																																							</xsl:call-template>
																																																						</mglyph>
																																																					</xsl:for-each>
																																																					<xsl:variable name="var283_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var283_test_resultof_node_name_equal_qname">
																																																						<malignmark>
																																																							<xsl:for-each select="@edge">
																																																								<xsl:attribute name="edge" select="fn:string(.)"/>
																																																							</xsl:for-each>
																																																						</malignmark>
																																																					</xsl:for-each>
																																																				</xsl:for-each>
																																																			</mn>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var284_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mo)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var284_test_resultof_node_name_equal_qname">
																																																			<mo>
																																																				<xsl:for-each select="@xlink:href">
																																																					<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@class">
																																																					<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@style">
																																																					<xsl:attribute name="style" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@id">
																																																					<xsl:attribute name="id" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@xref">
																																																					<xsl:attribute name="xref" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathvariant">
																																																					<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathsize">
																																																					<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathcolor">
																																																					<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathbackground">
																																																					<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@form">
																																																					<xsl:attribute name="form" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@fence">
																																																					<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@separator">
																																																					<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@lspace">
																																																					<xsl:attribute name="lspace" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@rspace">
																																																					<xsl:attribute name="rspace" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@stretchy">
																																																					<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@symmetric">
																																																					<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@maxsize">
																																																					<xsl:attribute name="maxsize" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@minsize">
																																																					<xsl:attribute name="minsize" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@largeop">
																																																					<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@movablelimits">
																																																					<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@accent">
																																																					<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="node()">
																																																					<xsl:if test="fn:boolean(self::text())">
																																																						<xsl:sequence select="fn:string(.)"/>
																																																					</xsl:if>
																																																					<xsl:variable name="var285_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var285_test_resultof_node_name_equal_qname">
																																																						<mglyph>
																																																							<xsl:call-template name="tbf:tbf1_mglyph">
																																																								<xsl:with-param name="input" select="." as="node()"/>
																																																							</xsl:call-template>
																																																						</mglyph>
																																																					</xsl:for-each>
																																																					<xsl:variable name="var286_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var286_test_resultof_node_name_equal_qname">
																																																						<malignmark>
																																																							<xsl:for-each select="@edge">
																																																								<xsl:attribute name="edge" select="fn:string(.)"/>
																																																							</xsl:for-each>
																																																						</malignmark>
																																																					</xsl:for-each>
																																																				</xsl:for-each>
																																																			</mo>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var287_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mtext)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var287_test_resultof_node_name_equal_qname">
																																																			<mtext>
																																																				<xsl:for-each select="@xlink:href">
																																																					<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@class">
																																																					<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@style">
																																																					<xsl:attribute name="style" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@id">
																																																					<xsl:attribute name="id" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@xref">
																																																					<xsl:attribute name="xref" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathvariant">
																																																					<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathsize">
																																																					<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathcolor">
																																																					<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathbackground">
																																																					<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="node()">
																																																					<xsl:if test="fn:boolean(self::text())">
																																																						<xsl:sequence select="fn:string(.)"/>
																																																					</xsl:if>
																																																					<xsl:variable name="var288_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var288_test_resultof_node_name_equal_qname">
																																																						<mglyph>
																																																							<xsl:call-template name="tbf:tbf1_mglyph">
																																																								<xsl:with-param name="input" select="." as="node()"/>
																																																							</xsl:call-template>
																																																						</mglyph>
																																																					</xsl:for-each>
																																																					<xsl:variable name="var289_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var289_test_resultof_node_name_equal_qname">
																																																						<malignmark>
																																																							<xsl:for-each select="@edge">
																																																								<xsl:attribute name="edge" select="fn:string(.)"/>
																																																							</xsl:for-each>
																																																						</malignmark>
																																																					</xsl:for-each>
																																																				</xsl:for-each>
																																																			</mtext>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var290_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:ms)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var290_test_resultof_node_name_equal_qname">
																																																			<ms>
																																																				<xsl:for-each select="@xlink:href">
																																																					<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@class">
																																																					<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@style">
																																																					<xsl:attribute name="style" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@id">
																																																					<xsl:attribute name="id" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@xref">
																																																					<xsl:attribute name="xref" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathvariant">
																																																					<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathsize">
																																																					<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathcolor">
																																																					<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@mathbackground">
																																																					<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@lquote">
																																																					<xsl:attribute name="lquote" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@rquote">
																																																					<xsl:attribute name="rquote" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="node()">
																																																					<xsl:if test="fn:boolean(self::text())">
																																																						<xsl:sequence select="fn:string(.)"/>
																																																					</xsl:if>
																																																					<xsl:variable name="var291_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var291_test_resultof_node_name_equal_qname">
																																																						<mglyph>
																																																							<xsl:call-template name="tbf:tbf1_mglyph">
																																																								<xsl:with-param name="input" select="." as="node()"/>
																																																							</xsl:call-template>
																																																						</mglyph>
																																																					</xsl:for-each>
																																																					<xsl:variable name="var292_test_resultof_node_name_equal_qname" as="node()?">
																																																						<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																							<xsl:sequence select="."/>
																																																						</xsl:if>
																																																					</xsl:variable>
																																																					<xsl:for-each select="$var292_test_resultof_node_name_equal_qname">
																																																						<malignmark>
																																																							<xsl:for-each select="@edge">
																																																								<xsl:attribute name="edge" select="fn:string(.)"/>
																																																							</xsl:for-each>
																																																						</malignmark>
																																																					</xsl:for-each>
																																																				</xsl:for-each>
																																																			</ms>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var293_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mspace)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var293_test_resultof_node_name_equal_qname">
																																																			<mspace>
																																																				<xsl:for-each select="@width">
																																																					<xsl:attribute name="width" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@height">
																																																					<xsl:attribute name="height" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@depth">
																																																					<xsl:attribute name="depth" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@linebreak">
																																																					<xsl:attribute name="linebreak" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@xlink:href">
																																																					<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@class">
																																																					<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@style">
																																																					<xsl:attribute name="style" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@id">
																																																					<xsl:attribute name="id" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@xref">
																																																					<xsl:attribute name="xref" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																			</mspace>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var294_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mrow)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var294_test_resultof_node_name_equal_qname">
																																																			<mrow>
																																																				<xsl:sequence select="()"/>
																																																			</mrow>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var295_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mfrac)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var295_test_resultof_node_name_equal_qname">
																																																			<mfrac>
																																																				<xsl:sequence select="()"/>
																																																			</mfrac>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var296_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:msqrt)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var296_test_resultof_node_name_equal_qname">
																																																			<msqrt>
																																																				<xsl:sequence select="()"/>
																																																			</msqrt>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var297_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mroot)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var297_test_resultof_node_name_equal_qname">
																																																			<mroot>
																																																				<xsl:sequence select="()"/>
																																																			</mroot>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var298_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:menclose)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var298_test_resultof_node_name_equal_qname">
																																																			<menclose>
																																																				<xsl:sequence select="()"/>
																																																			</menclose>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var299_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mstyle)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var299_test_resultof_node_name_equal_qname">
																																																			<mstyle>
																																																				<xsl:sequence select="()"/>
																																																			</mstyle>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var300_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:merror)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var300_test_resultof_node_name_equal_qname">
																																																			<merror>
																																																				<xsl:sequence select="()"/>
																																																			</merror>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var301_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mpadded)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var301_test_resultof_node_name_equal_qname">
																																																			<mpadded>
																																																				<xsl:sequence select="()"/>
																																																			</mpadded>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var302_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mphantom)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var302_test_resultof_node_name_equal_qname">
																																																			<mphantom>
																																																				<xsl:sequence select="()"/>
																																																			</mphantom>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var303_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mfenced)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var303_test_resultof_node_name_equal_qname">
																																																			<mfenced>
																																																				<xsl:sequence select="()"/>
																																																			</mfenced>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var304_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:msub)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var304_test_resultof_node_name_equal_qname">
																																																			<msub>
																																																				<xsl:sequence select="()"/>
																																																			</msub>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var305_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:msup)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var305_test_resultof_node_name_equal_qname">
																																																			<msup>
																																																				<xsl:sequence select="()"/>
																																																			</msup>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var306_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:msubsup)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var306_test_resultof_node_name_equal_qname">
																																																			<msubsup>
																																																				<xsl:sequence select="()"/>
																																																			</msubsup>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var307_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:munder)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var307_test_resultof_node_name_equal_qname">
																																																			<munder>
																																																				<xsl:sequence select="()"/>
																																																			</munder>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var308_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mover)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var308_test_resultof_node_name_equal_qname">
																																																			<mover>
																																																				<xsl:sequence select="()"/>
																																																			</mover>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var309_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:munderover)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var309_test_resultof_node_name_equal_qname">
																																																			<munderover>
																																																				<xsl:sequence select="()"/>
																																																			</munderover>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var310_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mmultiscripts)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var310_test_resultof_node_name_equal_qname">
																																																			<mmultiscripts>
																																																				<xsl:sequence select="()"/>
																																																			</mmultiscripts>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var311_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:mtable)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var311_test_resultof_node_name_equal_qname">
																																																			<mtable>
																																																				<xsl:sequence select="()"/>
																																																			</mtable>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var312_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:maligngroup)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var312_test_resultof_node_name_equal_qname">
																																																			<maligngroup>
																																																				<xsl:for-each select="@xlink:href">
																																																					<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@class">
																																																					<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@style">
																																																					<xsl:attribute name="style" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@id">
																																																					<xsl:attribute name="id" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@xref">
																																																					<xsl:attribute name="xref" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																				<xsl:for-each select="@groupalign">
																																																					<xsl:attribute name="groupalign" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																			</maligngroup>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var313_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var313_test_resultof_node_name_equal_qname">
																																																			<malignmark>
																																																				<xsl:for-each select="@edge">
																																																					<xsl:attribute name="edge" select="fn:string(.)"/>
																																																				</xsl:for-each>
																																																			</malignmark>
																																																		</xsl:for-each>
																																																		<xsl:variable name="var314_test_resultof_node_name_equal_qname" as="node()?">
																																																			<xsl:if test="fn:boolean(self::mathnl:maction)">
																																																				<xsl:sequence select="."/>
																																																			</xsl:if>
																																																		</xsl:variable>
																																																		<xsl:for-each select="$var314_test_resultof_node_name_equal_qname">
																																																			<maction>
																																																				<xsl:sequence select="()"/>
																																																			</maction>
																																																		</xsl:for-each>
																																																	</xsl:for-each>
																																																</cn>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:integers">
																																																<integers>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@definitionURL">
																																																		<xsl:attribute name="definitionURL" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@encoding">
																																																		<xsl:attribute name="encoding" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																</integers>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:reals">
																																																<reals>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@definitionURL">
																																																		<xsl:attribute name="definitionURL" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@encoding">
																																																		<xsl:attribute name="encoding" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																</reals>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:rationals">
																																																<rationals>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@definitionURL">
																																																		<xsl:attribute name="definitionURL" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@encoding">
																																																		<xsl:attribute name="encoding" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																</rationals>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:naturalnumbers">
																																																<naturalnumbers>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@definitionURL">
																																																		<xsl:attribute name="definitionURL" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@encoding">
																																																		<xsl:attribute name="encoding" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																</naturalnumbers>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:complexes">
																																																<complexes>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@definitionURL">
																																																		<xsl:attribute name="definitionURL" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@encoding">
																																																		<xsl:attribute name="encoding" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																</complexes>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:primes">
																																																<primes>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@definitionURL">
																																																		<xsl:attribute name="definitionURL" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@encoding">
																																																		<xsl:attribute name="encoding" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																</primes>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:exponentiale">
																																																<exponentiale>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@definitionURL">
																																																		<xsl:attribute name="definitionURL" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@encoding">
																																																		<xsl:attribute name="encoding" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																</exponentiale>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:imaginaryi">
																																																<imaginaryi>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@definitionURL">
																																																		<xsl:attribute name="definitionURL" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@encoding">
																																																		<xsl:attribute name="encoding" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																</imaginaryi>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:notanumber">
																																																<notanumber>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@definitionURL">
																																																		<xsl:attribute name="definitionURL" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@encoding">
																																																		<xsl:attribute name="encoding" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																</notanumber>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:true">
																																																<true>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@definitionURL">
																																																		<xsl:attribute name="definitionURL" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@encoding">
																																																		<xsl:attribute name="encoding" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																</true>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:false">
																																																<false>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@definitionURL">
																																																		<xsl:attribute name="definitionURL" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@encoding">
																																																		<xsl:attribute name="encoding" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																</false>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:emptyset">
																																																<emptyset>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@definitionURL">
																																																		<xsl:attribute name="definitionURL" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@encoding">
																																																		<xsl:attribute name="encoding" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																</emptyset>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:pi">
																																																<pi>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@definitionURL">
																																																		<xsl:attribute name="definitionURL" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@encoding">
																																																		<xsl:attribute name="encoding" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																</pi>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:eulergamma">
																																																<eulergamma>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@definitionURL">
																																																		<xsl:attribute name="definitionURL" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@encoding">
																																																		<xsl:attribute name="encoding" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																</eulergamma>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:infinity">
																																																<infinity>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@definitionURL">
																																																		<xsl:attribute name="definitionURL" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@encoding">
																																																		<xsl:attribute name="encoding" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																</infinity>
																																															</xsl:for-each>
																																															<xsl:for-each select="mathnl:set">
																																																<xsl:variable name="var3278_type" as="node()?" select="@type"/>
																																																<set>
																																																	<xsl:for-each select="@xlink:href">
																																																		<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="$var3278_type">
																																																		<xsl:attribute name="xlink:type" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@class">
																																																		<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@style">
																																																		<xsl:attribute name="style" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@id">
																																																		<xsl:attribute name="id" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="@xref">
																																																		<xsl:attribute name="xref" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="$var3278_type">
																																																		<xsl:attribute name="type" select="fn:string(.)"/>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="mathnl:csymbol">
																																																		<csymbol>
																																																			<xsl:for-each select="@xlink:href">
																																																				<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="@class">
																																																				<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="@style">
																																																				<xsl:attribute name="style" select="fn:string(.)"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="@id">
																																																				<xsl:attribute name="id" select="fn:string(.)"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="@xref">
																																																				<xsl:attribute name="xref" select="fn:string(.)"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="@encoding">
																																																				<xsl:attribute name="encoding" select="fn:string(.)"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="@definitionURL">
																																																				<xsl:attribute name="definitionURL" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="node()">
																																																				<xsl:if test="fn:boolean(self::text())">
																																																					<xsl:sequence select="fn:string(.)"/>
																																																				</xsl:if>
																																																				<xsl:variable name="var316_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mi)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var316_test_resultof_node_name_equal_qname">
																																																					<mi>
																																																						<xsl:for-each select="@xlink:href">
																																																							<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@class">
																																																							<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@style">
																																																							<xsl:attribute name="style" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@id">
																																																							<xsl:attribute name="id" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@xref">
																																																							<xsl:attribute name="xref" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathvariant">
																																																							<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathsize">
																																																							<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathcolor">
																																																							<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathbackground">
																																																							<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="node()">
																																																							<xsl:if test="fn:boolean(self::text())">
																																																								<xsl:sequence select="fn:string(.)"/>
																																																							</xsl:if>
																																																							<xsl:variable name="var317_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var317_test_resultof_node_name_equal_qname">
																																																								<mglyph>
																																																									<xsl:call-template name="tbf:tbf1_mglyph">
																																																										<xsl:with-param name="input" select="." as="node()"/>
																																																									</xsl:call-template>
																																																								</mglyph>
																																																							</xsl:for-each>
																																																							<xsl:variable name="var318_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var318_test_resultof_node_name_equal_qname">
																																																								<malignmark>
																																																									<xsl:for-each select="@edge">
																																																										<xsl:attribute name="edge" select="fn:string(.)"/>
																																																									</xsl:for-each>
																																																								</malignmark>
																																																							</xsl:for-each>
																																																						</xsl:for-each>
																																																					</mi>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var319_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mn)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var319_test_resultof_node_name_equal_qname">
																																																					<mn>
																																																						<xsl:for-each select="@xlink:href">
																																																							<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@class">
																																																							<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@style">
																																																							<xsl:attribute name="style" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@id">
																																																							<xsl:attribute name="id" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@xref">
																																																							<xsl:attribute name="xref" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathvariant">
																																																							<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathsize">
																																																							<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathcolor">
																																																							<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathbackground">
																																																							<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="node()">
																																																							<xsl:if test="fn:boolean(self::text())">
																																																								<xsl:sequence select="fn:string(.)"/>
																																																							</xsl:if>
																																																							<xsl:variable name="var320_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var320_test_resultof_node_name_equal_qname">
																																																								<mglyph>
																																																									<xsl:call-template name="tbf:tbf1_mglyph">
																																																										<xsl:with-param name="input" select="." as="node()"/>
																																																									</xsl:call-template>
																																																								</mglyph>
																																																							</xsl:for-each>
																																																							<xsl:variable name="var321_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var321_test_resultof_node_name_equal_qname">
																																																								<malignmark>
																																																									<xsl:for-each select="@edge">
																																																										<xsl:attribute name="edge" select="fn:string(.)"/>
																																																									</xsl:for-each>
																																																								</malignmark>
																																																							</xsl:for-each>
																																																						</xsl:for-each>
																																																					</mn>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var322_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mo)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var322_test_resultof_node_name_equal_qname">
																																																					<mo>
																																																						<xsl:for-each select="@xlink:href">
																																																							<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@class">
																																																							<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@style">
																																																							<xsl:attribute name="style" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@id">
																																																							<xsl:attribute name="id" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@xref">
																																																							<xsl:attribute name="xref" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathvariant">
																																																							<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathsize">
																																																							<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathcolor">
																																																							<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathbackground">
																																																							<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@form">
																																																							<xsl:attribute name="form" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@fence">
																																																							<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@separator">
																																																							<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@lspace">
																																																							<xsl:attribute name="lspace" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@rspace">
																																																							<xsl:attribute name="rspace" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@stretchy">
																																																							<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@symmetric">
																																																							<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@maxsize">
																																																							<xsl:attribute name="maxsize" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@minsize">
																																																							<xsl:attribute name="minsize" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@largeop">
																																																							<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@movablelimits">
																																																							<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@accent">
																																																							<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="node()">
																																																							<xsl:if test="fn:boolean(self::text())">
																																																								<xsl:sequence select="fn:string(.)"/>
																																																							</xsl:if>
																																																							<xsl:variable name="var323_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var323_test_resultof_node_name_equal_qname">
																																																								<mglyph>
																																																									<xsl:call-template name="tbf:tbf1_mglyph">
																																																										<xsl:with-param name="input" select="." as="node()"/>
																																																									</xsl:call-template>
																																																								</mglyph>
																																																							</xsl:for-each>
																																																							<xsl:variable name="var324_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var324_test_resultof_node_name_equal_qname">
																																																								<malignmark>
																																																									<xsl:for-each select="@edge">
																																																										<xsl:attribute name="edge" select="fn:string(.)"/>
																																																									</xsl:for-each>
																																																								</malignmark>
																																																							</xsl:for-each>
																																																						</xsl:for-each>
																																																					</mo>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var325_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mtext)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var325_test_resultof_node_name_equal_qname">
																																																					<mtext>
																																																						<xsl:for-each select="@xlink:href">
																																																							<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@class">
																																																							<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@style">
																																																							<xsl:attribute name="style" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@id">
																																																							<xsl:attribute name="id" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@xref">
																																																							<xsl:attribute name="xref" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathvariant">
																																																							<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathsize">
																																																							<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathcolor">
																																																							<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathbackground">
																																																							<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="node()">
																																																							<xsl:if test="fn:boolean(self::text())">
																																																								<xsl:sequence select="fn:string(.)"/>
																																																							</xsl:if>
																																																							<xsl:variable name="var326_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var326_test_resultof_node_name_equal_qname">
																																																								<mglyph>
																																																									<xsl:call-template name="tbf:tbf1_mglyph">
																																																										<xsl:with-param name="input" select="." as="node()"/>
																																																									</xsl:call-template>
																																																								</mglyph>
																																																							</xsl:for-each>
																																																							<xsl:variable name="var327_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var327_test_resultof_node_name_equal_qname">
																																																								<malignmark>
																																																									<xsl:for-each select="@edge">
																																																										<xsl:attribute name="edge" select="fn:string(.)"/>
																																																									</xsl:for-each>
																																																								</malignmark>
																																																							</xsl:for-each>
																																																						</xsl:for-each>
																																																					</mtext>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var328_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:ms)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var328_test_resultof_node_name_equal_qname">
																																																					<ms>
																																																						<xsl:for-each select="@xlink:href">
																																																							<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@class">
																																																							<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@style">
																																																							<xsl:attribute name="style" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@id">
																																																							<xsl:attribute name="id" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@xref">
																																																							<xsl:attribute name="xref" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathvariant">
																																																							<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathsize">
																																																							<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathcolor">
																																																							<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathbackground">
																																																							<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@lquote">
																																																							<xsl:attribute name="lquote" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@rquote">
																																																							<xsl:attribute name="rquote" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="node()">
																																																							<xsl:if test="fn:boolean(self::text())">
																																																								<xsl:sequence select="fn:string(.)"/>
																																																							</xsl:if>
																																																							<xsl:variable name="var329_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var329_test_resultof_node_name_equal_qname">
																																																								<mglyph>
																																																									<xsl:call-template name="tbf:tbf1_mglyph">
																																																										<xsl:with-param name="input" select="." as="node()"/>
																																																									</xsl:call-template>
																																																								</mglyph>
																																																							</xsl:for-each>
																																																							<xsl:variable name="var330_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var330_test_resultof_node_name_equal_qname">
																																																								<malignmark>
																																																									<xsl:for-each select="@edge">
																																																										<xsl:attribute name="edge" select="fn:string(.)"/>
																																																									</xsl:for-each>
																																																								</malignmark>
																																																							</xsl:for-each>
																																																						</xsl:for-each>
																																																					</ms>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var331_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mspace)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var331_test_resultof_node_name_equal_qname">
																																																					<mspace>
																																																						<xsl:for-each select="@width">
																																																							<xsl:attribute name="width" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@height">
																																																							<xsl:attribute name="height" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@depth">
																																																							<xsl:attribute name="depth" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@linebreak">
																																																							<xsl:attribute name="linebreak" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@xlink:href">
																																																							<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@class">
																																																							<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@style">
																																																							<xsl:attribute name="style" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@id">
																																																							<xsl:attribute name="id" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@xref">
																																																							<xsl:attribute name="xref" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																					</mspace>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var332_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mrow)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var332_test_resultof_node_name_equal_qname">
																																																					<mrow>
																																																						<xsl:sequence select="()"/>
																																																					</mrow>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var333_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mfrac)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var333_test_resultof_node_name_equal_qname">
																																																					<mfrac>
																																																						<xsl:sequence select="()"/>
																																																					</mfrac>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var334_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:msqrt)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var334_test_resultof_node_name_equal_qname">
																																																					<msqrt>
																																																						<xsl:sequence select="()"/>
																																																					</msqrt>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var335_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mroot)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var335_test_resultof_node_name_equal_qname">
																																																					<mroot>
																																																						<xsl:sequence select="()"/>
																																																					</mroot>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var336_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:menclose)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var336_test_resultof_node_name_equal_qname">
																																																					<menclose>
																																																						<xsl:sequence select="()"/>
																																																					</menclose>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var337_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mstyle)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var337_test_resultof_node_name_equal_qname">
																																																					<mstyle>
																																																						<xsl:sequence select="()"/>
																																																					</mstyle>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var338_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:merror)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var338_test_resultof_node_name_equal_qname">
																																																					<merror>
																																																						<xsl:sequence select="()"/>
																																																					</merror>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var339_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mpadded)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var339_test_resultof_node_name_equal_qname">
																																																					<mpadded>
																																																						<xsl:sequence select="()"/>
																																																					</mpadded>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var340_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mphantom)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var340_test_resultof_node_name_equal_qname">
																																																					<mphantom>
																																																						<xsl:sequence select="()"/>
																																																					</mphantom>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var341_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mfenced)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var341_test_resultof_node_name_equal_qname">
																																																					<mfenced>
																																																						<xsl:sequence select="()"/>
																																																					</mfenced>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var342_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:msub)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var342_test_resultof_node_name_equal_qname">
																																																					<msub>
																																																						<xsl:sequence select="()"/>
																																																					</msub>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var343_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:msup)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var343_test_resultof_node_name_equal_qname">
																																																					<msup>
																																																						<xsl:sequence select="()"/>
																																																					</msup>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var344_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:msubsup)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var344_test_resultof_node_name_equal_qname">
																																																					<msubsup>
																																																						<xsl:sequence select="()"/>
																																																					</msubsup>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var345_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:munder)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var345_test_resultof_node_name_equal_qname">
																																																					<munder>
																																																						<xsl:sequence select="()"/>
																																																					</munder>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var346_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mover)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var346_test_resultof_node_name_equal_qname">
																																																					<mover>
																																																						<xsl:sequence select="()"/>
																																																					</mover>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var347_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:munderover)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var347_test_resultof_node_name_equal_qname">
																																																					<munderover>
																																																						<xsl:sequence select="()"/>
																																																					</munderover>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var348_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mmultiscripts)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var348_test_resultof_node_name_equal_qname">
																																																					<mmultiscripts>
																																																						<xsl:sequence select="()"/>
																																																					</mmultiscripts>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var349_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mtable)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var349_test_resultof_node_name_equal_qname">
																																																					<mtable>
																																																						<xsl:sequence select="()"/>
																																																					</mtable>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var350_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:maligngroup)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var350_test_resultof_node_name_equal_qname">
																																																					<maligngroup>
																																																						<xsl:for-each select="@xlink:href">
																																																							<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@class">
																																																							<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@style">
																																																							<xsl:attribute name="style" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@id">
																																																							<xsl:attribute name="id" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@xref">
																																																							<xsl:attribute name="xref" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@groupalign">
																																																							<xsl:attribute name="groupalign" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																					</maligngroup>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var351_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var351_test_resultof_node_name_equal_qname">
																																																					<malignmark>
																																																						<xsl:for-each select="@edge">
																																																							<xsl:attribute name="edge" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																					</malignmark>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var352_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:maction)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var352_test_resultof_node_name_equal_qname">
																																																					<maction>
																																																						<xsl:sequence select="()"/>
																																																					</maction>
																																																				</xsl:for-each>
																																																			</xsl:for-each>
																																																		</csymbol>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="mathnl:ci">
																																																		<xsl:variable name="var390_type" as="node()?" select="@type"/>
																																																		<ci>
																																																			<xsl:for-each select="@xlink:href">
																																																				<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="$var390_type">
																																																				<xsl:attribute name="xlink:type" select="fn:string(.)"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="@class">
																																																				<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="@style">
																																																				<xsl:attribute name="style" select="fn:string(.)"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="@id">
																																																				<xsl:attribute name="id" select="fn:string(.)"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="@xref">
																																																				<xsl:attribute name="xref" select="fn:string(.)"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="$var390_type">
																																																				<xsl:attribute name="type" select="fn:string(.)"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="@definitionURL">
																																																				<xsl:attribute name="definitionURL" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="@encoding">
																																																				<xsl:attribute name="encoding" select="fn:string(.)"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="node()">
																																																				<xsl:if test="fn:boolean(self::text())">
																																																					<xsl:sequence select="fn:string(.)"/>
																																																				</xsl:if>
																																																				<xsl:variable name="var353_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mi)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var353_test_resultof_node_name_equal_qname">
																																																					<mi>
																																																						<xsl:for-each select="@xlink:href">
																																																							<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@class">
																																																							<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@style">
																																																							<xsl:attribute name="style" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@id">
																																																							<xsl:attribute name="id" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@xref">
																																																							<xsl:attribute name="xref" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathvariant">
																																																							<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathsize">
																																																							<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathcolor">
																																																							<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathbackground">
																																																							<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="node()">
																																																							<xsl:if test="fn:boolean(self::text())">
																																																								<xsl:sequence select="fn:string(.)"/>
																																																							</xsl:if>
																																																							<xsl:variable name="var354_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var354_test_resultof_node_name_equal_qname">
																																																								<mglyph>
																																																									<xsl:call-template name="tbf:tbf1_mglyph">
																																																										<xsl:with-param name="input" select="." as="node()"/>
																																																									</xsl:call-template>
																																																								</mglyph>
																																																							</xsl:for-each>
																																																							<xsl:variable name="var355_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var355_test_resultof_node_name_equal_qname">
																																																								<malignmark>
																																																									<xsl:for-each select="@edge">
																																																										<xsl:attribute name="edge" select="fn:string(.)"/>
																																																									</xsl:for-each>
																																																								</malignmark>
																																																							</xsl:for-each>
																																																						</xsl:for-each>
																																																					</mi>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var356_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mn)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var356_test_resultof_node_name_equal_qname">
																																																					<mn>
																																																						<xsl:for-each select="@xlink:href">
																																																							<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@class">
																																																							<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@style">
																																																							<xsl:attribute name="style" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@id">
																																																							<xsl:attribute name="id" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@xref">
																																																							<xsl:attribute name="xref" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathvariant">
																																																							<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathsize">
																																																							<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathcolor">
																																																							<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathbackground">
																																																							<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="node()">
																																																							<xsl:if test="fn:boolean(self::text())">
																																																								<xsl:sequence select="fn:string(.)"/>
																																																							</xsl:if>
																																																							<xsl:variable name="var357_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var357_test_resultof_node_name_equal_qname">
																																																								<mglyph>
																																																									<xsl:call-template name="tbf:tbf1_mglyph">
																																																										<xsl:with-param name="input" select="." as="node()"/>
																																																									</xsl:call-template>
																																																								</mglyph>
																																																							</xsl:for-each>
																																																							<xsl:variable name="var358_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var358_test_resultof_node_name_equal_qname">
																																																								<malignmark>
																																																									<xsl:for-each select="@edge">
																																																										<xsl:attribute name="edge" select="fn:string(.)"/>
																																																									</xsl:for-each>
																																																								</malignmark>
																																																							</xsl:for-each>
																																																						</xsl:for-each>
																																																					</mn>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var359_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mo)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var359_test_resultof_node_name_equal_qname">
																																																					<mo>
																																																						<xsl:for-each select="@xlink:href">
																																																							<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@class">
																																																							<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@style">
																																																							<xsl:attribute name="style" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@id">
																																																							<xsl:attribute name="id" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@xref">
																																																							<xsl:attribute name="xref" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathvariant">
																																																							<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathsize">
																																																							<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathcolor">
																																																							<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathbackground">
																																																							<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@form">
																																																							<xsl:attribute name="form" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@fence">
																																																							<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@separator">
																																																							<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@lspace">
																																																							<xsl:attribute name="lspace" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@rspace">
																																																							<xsl:attribute name="rspace" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@stretchy">
																																																							<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@symmetric">
																																																							<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@maxsize">
																																																							<xsl:attribute name="maxsize" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@minsize">
																																																							<xsl:attribute name="minsize" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@largeop">
																																																							<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@movablelimits">
																																																							<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@accent">
																																																							<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="node()">
																																																							<xsl:if test="fn:boolean(self::text())">
																																																								<xsl:sequence select="fn:string(.)"/>
																																																							</xsl:if>
																																																							<xsl:variable name="var360_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var360_test_resultof_node_name_equal_qname">
																																																								<mglyph>
																																																									<xsl:call-template name="tbf:tbf1_mglyph">
																																																										<xsl:with-param name="input" select="." as="node()"/>
																																																									</xsl:call-template>
																																																								</mglyph>
																																																							</xsl:for-each>
																																																							<xsl:variable name="var361_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var361_test_resultof_node_name_equal_qname">
																																																								<malignmark>
																																																									<xsl:for-each select="@edge">
																																																										<xsl:attribute name="edge" select="fn:string(.)"/>
																																																									</xsl:for-each>
																																																								</malignmark>
																																																							</xsl:for-each>
																																																						</xsl:for-each>
																																																					</mo>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var362_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mtext)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var362_test_resultof_node_name_equal_qname">
																																																					<mtext>
																																																						<xsl:for-each select="@xlink:href">
																																																							<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@class">
																																																							<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@style">
																																																							<xsl:attribute name="style" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@id">
																																																							<xsl:attribute name="id" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@xref">
																																																							<xsl:attribute name="xref" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathvariant">
																																																							<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathsize">
																																																							<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathcolor">
																																																							<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathbackground">
																																																							<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="node()">
																																																							<xsl:if test="fn:boolean(self::text())">
																																																								<xsl:sequence select="fn:string(.)"/>
																																																							</xsl:if>
																																																							<xsl:variable name="var363_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var363_test_resultof_node_name_equal_qname">
																																																								<mglyph>
																																																									<xsl:call-template name="tbf:tbf1_mglyph">
																																																										<xsl:with-param name="input" select="." as="node()"/>
																																																									</xsl:call-template>
																																																								</mglyph>
																																																							</xsl:for-each>
																																																							<xsl:variable name="var364_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var364_test_resultof_node_name_equal_qname">
																																																								<malignmark>
																																																									<xsl:for-each select="@edge">
																																																										<xsl:attribute name="edge" select="fn:string(.)"/>
																																																									</xsl:for-each>
																																																								</malignmark>
																																																							</xsl:for-each>
																																																						</xsl:for-each>
																																																					</mtext>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var365_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:ms)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var365_test_resultof_node_name_equal_qname">
																																																					<ms>
																																																						<xsl:for-each select="@xlink:href">
																																																							<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@class">
																																																							<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@style">
																																																							<xsl:attribute name="style" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@id">
																																																							<xsl:attribute name="id" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@xref">
																																																							<xsl:attribute name="xref" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathvariant">
																																																							<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathsize">
																																																							<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathcolor">
																																																							<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathbackground">
																																																							<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@lquote">
																																																							<xsl:attribute name="lquote" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@rquote">
																																																							<xsl:attribute name="rquote" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="node()">
																																																							<xsl:if test="fn:boolean(self::text())">
																																																								<xsl:sequence select="fn:string(.)"/>
																																																							</xsl:if>
																																																							<xsl:variable name="var366_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var366_test_resultof_node_name_equal_qname">
																																																								<mglyph>
																																																									<xsl:call-template name="tbf:tbf1_mglyph">
																																																										<xsl:with-param name="input" select="." as="node()"/>
																																																									</xsl:call-template>
																																																								</mglyph>
																																																							</xsl:for-each>
																																																							<xsl:variable name="var367_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var367_test_resultof_node_name_equal_qname">
																																																								<malignmark>
																																																									<xsl:for-each select="@edge">
																																																										<xsl:attribute name="edge" select="fn:string(.)"/>
																																																									</xsl:for-each>
																																																								</malignmark>
																																																							</xsl:for-each>
																																																						</xsl:for-each>
																																																					</ms>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var368_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mspace)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var368_test_resultof_node_name_equal_qname">
																																																					<mspace>
																																																						<xsl:for-each select="@width">
																																																							<xsl:attribute name="width" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@height">
																																																							<xsl:attribute name="height" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@depth">
																																																							<xsl:attribute name="depth" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@linebreak">
																																																							<xsl:attribute name="linebreak" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@xlink:href">
																																																							<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@class">
																																																							<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@style">
																																																							<xsl:attribute name="style" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@id">
																																																							<xsl:attribute name="id" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@xref">
																																																							<xsl:attribute name="xref" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																					</mspace>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var369_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mrow)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var369_test_resultof_node_name_equal_qname">
																																																					<mrow>
																																																						<xsl:sequence select="()"/>
																																																					</mrow>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var370_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mfrac)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var370_test_resultof_node_name_equal_qname">
																																																					<mfrac>
																																																						<xsl:sequence select="()"/>
																																																					</mfrac>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var371_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:msqrt)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var371_test_resultof_node_name_equal_qname">
																																																					<msqrt>
																																																						<xsl:sequence select="()"/>
																																																					</msqrt>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var372_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mroot)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var372_test_resultof_node_name_equal_qname">
																																																					<mroot>
																																																						<xsl:sequence select="()"/>
																																																					</mroot>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var373_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:menclose)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var373_test_resultof_node_name_equal_qname">
																																																					<menclose>
																																																						<xsl:sequence select="()"/>
																																																					</menclose>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var374_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mstyle)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var374_test_resultof_node_name_equal_qname">
																																																					<mstyle>
																																																						<xsl:sequence select="()"/>
																																																					</mstyle>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var375_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:merror)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var375_test_resultof_node_name_equal_qname">
																																																					<merror>
																																																						<xsl:sequence select="()"/>
																																																					</merror>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var376_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mpadded)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var376_test_resultof_node_name_equal_qname">
																																																					<mpadded>
																																																						<xsl:sequence select="()"/>
																																																					</mpadded>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var377_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mphantom)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var377_test_resultof_node_name_equal_qname">
																																																					<mphantom>
																																																						<xsl:sequence select="()"/>
																																																					</mphantom>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var378_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mfenced)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var378_test_resultof_node_name_equal_qname">
																																																					<mfenced>
																																																						<xsl:sequence select="()"/>
																																																					</mfenced>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var379_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:msub)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var379_test_resultof_node_name_equal_qname">
																																																					<msub>
																																																						<xsl:sequence select="()"/>
																																																					</msub>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var380_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:msup)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var380_test_resultof_node_name_equal_qname">
																																																					<msup>
																																																						<xsl:sequence select="()"/>
																																																					</msup>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var381_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:msubsup)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var381_test_resultof_node_name_equal_qname">
																																																					<msubsup>
																																																						<xsl:sequence select="()"/>
																																																					</msubsup>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var382_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:munder)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var382_test_resultof_node_name_equal_qname">
																																																					<munder>
																																																						<xsl:sequence select="()"/>
																																																					</munder>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var383_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mover)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var383_test_resultof_node_name_equal_qname">
																																																					<mover>
																																																						<xsl:sequence select="()"/>
																																																					</mover>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var384_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:munderover)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var384_test_resultof_node_name_equal_qname">
																																																					<munderover>
																																																						<xsl:sequence select="()"/>
																																																					</munderover>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var385_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mmultiscripts)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var385_test_resultof_node_name_equal_qname">
																																																					<mmultiscripts>
																																																						<xsl:sequence select="()"/>
																																																					</mmultiscripts>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var386_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mtable)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var386_test_resultof_node_name_equal_qname">
																																																					<mtable>
																																																						<xsl:sequence select="()"/>
																																																					</mtable>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var387_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:maligngroup)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var387_test_resultof_node_name_equal_qname">
																																																					<maligngroup>
																																																						<xsl:for-each select="@xlink:href">
																																																							<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@class">
																																																							<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@style">
																																																							<xsl:attribute name="style" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@id">
																																																							<xsl:attribute name="id" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@xref">
																																																							<xsl:attribute name="xref" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@groupalign">
																																																							<xsl:attribute name="groupalign" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																					</maligngroup>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var388_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var388_test_resultof_node_name_equal_qname">
																																																					<malignmark>
																																																						<xsl:for-each select="@edge">
																																																							<xsl:attribute name="edge" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																					</malignmark>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var389_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:maction)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var389_test_resultof_node_name_equal_qname">
																																																					<maction>
																																																						<xsl:sequence select="()"/>
																																																					</maction>
																																																				</xsl:for-each>
																																																			</xsl:for-each>
																																																		</ci>
																																																	</xsl:for-each>
																																																	<xsl:for-each select="mathnl:cn">
																																																		<xsl:variable name="var429_type" as="node()?" select="@type"/>
																																																		<cn>
																																																			<xsl:for-each select="@xlink:href">
																																																				<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="$var429_type">
																																																				<xsl:attribute name="xlink:type" select="fn:string(.)"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="@class">
																																																				<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="@style">
																																																				<xsl:attribute name="style" select="fn:string(.)"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="@id">
																																																				<xsl:attribute name="id" select="fn:string(.)"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="@xref">
																																																				<xsl:attribute name="xref" select="fn:string(.)"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="$var429_type">
																																																				<xsl:attribute name="type" select="fn:string(.)"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="@base">
																																																				<xsl:attribute name="base" select="xs:string(xs:integer(fn:string(.)))"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="@definitionURL">
																																																				<xsl:attribute name="definitionURL" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="@encoding">
																																																				<xsl:attribute name="encoding" select="fn:string(.)"/>
																																																			</xsl:for-each>
																																																			<xsl:for-each select="node()">
																																																				<xsl:if test="fn:boolean(self::text())">
																																																					<xsl:sequence select="fn:string(.)"/>
																																																				</xsl:if>
																																																				<xsl:variable name="var391_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:sep)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var391_test_resultof_node_name_equal_qname">
																																																					<sep>
																																																						<xsl:sequence select="()"/>
																																																					</sep>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var392_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mi)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var392_test_resultof_node_name_equal_qname">
																																																					<mi>
																																																						<xsl:for-each select="@xlink:href">
																																																							<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@class">
																																																							<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@style">
																																																							<xsl:attribute name="style" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@id">
																																																							<xsl:attribute name="id" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@xref">
																																																							<xsl:attribute name="xref" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathvariant">
																																																							<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathsize">
																																																							<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathcolor">
																																																							<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathbackground">
																																																							<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="node()">
																																																							<xsl:if test="fn:boolean(self::text())">
																																																								<xsl:sequence select="fn:string(.)"/>
																																																							</xsl:if>
																																																							<xsl:variable name="var393_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var393_test_resultof_node_name_equal_qname">
																																																								<mglyph>
																																																									<xsl:call-template name="tbf:tbf1_mglyph">
																																																										<xsl:with-param name="input" select="." as="node()"/>
																																																									</xsl:call-template>
																																																								</mglyph>
																																																							</xsl:for-each>
																																																							<xsl:variable name="var394_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var394_test_resultof_node_name_equal_qname">
																																																								<malignmark>
																																																									<xsl:for-each select="@edge">
																																																										<xsl:attribute name="edge" select="fn:string(.)"/>
																																																									</xsl:for-each>
																																																								</malignmark>
																																																							</xsl:for-each>
																																																						</xsl:for-each>
																																																					</mi>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var395_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mn)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var395_test_resultof_node_name_equal_qname">
																																																					<mn>
																																																						<xsl:for-each select="@xlink:href">
																																																							<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@class">
																																																							<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@style">
																																																							<xsl:attribute name="style" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@id">
																																																							<xsl:attribute name="id" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@xref">
																																																							<xsl:attribute name="xref" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathvariant">
																																																							<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathsize">
																																																							<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathcolor">
																																																							<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathbackground">
																																																							<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="node()">
																																																							<xsl:if test="fn:boolean(self::text())">
																																																								<xsl:sequence select="fn:string(.)"/>
																																																							</xsl:if>
																																																							<xsl:variable name="var396_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var396_test_resultof_node_name_equal_qname">
																																																								<mglyph>
																																																									<xsl:call-template name="tbf:tbf1_mglyph">
																																																										<xsl:with-param name="input" select="." as="node()"/>
																																																									</xsl:call-template>
																																																								</mglyph>
																																																							</xsl:for-each>
																																																							<xsl:variable name="var397_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var397_test_resultof_node_name_equal_qname">
																																																								<malignmark>
																																																									<xsl:for-each select="@edge">
																																																										<xsl:attribute name="edge" select="fn:string(.)"/>
																																																									</xsl:for-each>
																																																								</malignmark>
																																																							</xsl:for-each>
																																																						</xsl:for-each>
																																																					</mn>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var398_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mo)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var398_test_resultof_node_name_equal_qname">
																																																					<mo>
																																																						<xsl:for-each select="@xlink:href">
																																																							<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@class">
																																																							<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@style">
																																																							<xsl:attribute name="style" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@id">
																																																							<xsl:attribute name="id" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@xref">
																																																							<xsl:attribute name="xref" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathvariant">
																																																							<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathsize">
																																																							<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathcolor">
																																																							<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathbackground">
																																																							<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@form">
																																																							<xsl:attribute name="form" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@fence">
																																																							<xsl:attribute name="fence" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@separator">
																																																							<xsl:attribute name="separator" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@lspace">
																																																							<xsl:attribute name="lspace" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@rspace">
																																																							<xsl:attribute name="rspace" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@stretchy">
																																																							<xsl:attribute name="stretchy" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@symmetric">
																																																							<xsl:attribute name="symmetric" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@maxsize">
																																																							<xsl:attribute name="maxsize" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@minsize">
																																																							<xsl:attribute name="minsize" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@largeop">
																																																							<xsl:attribute name="largeop" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@movablelimits">
																																																							<xsl:attribute name="movablelimits" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@accent">
																																																							<xsl:attribute name="accent" select="xs:string(xs:boolean(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="node()">
																																																							<xsl:if test="fn:boolean(self::text())">
																																																								<xsl:sequence select="fn:string(.)"/>
																																																							</xsl:if>
																																																							<xsl:variable name="var399_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var399_test_resultof_node_name_equal_qname">
																																																								<mglyph>
																																																									<xsl:call-template name="tbf:tbf1_mglyph">
																																																										<xsl:with-param name="input" select="." as="node()"/>
																																																									</xsl:call-template>
																																																								</mglyph>
																																																							</xsl:for-each>
																																																							<xsl:variable name="var400_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var400_test_resultof_node_name_equal_qname">
																																																								<malignmark>
																																																									<xsl:for-each select="@edge">
																																																										<xsl:attribute name="edge" select="fn:string(.)"/>
																																																									</xsl:for-each>
																																																								</malignmark>
																																																							</xsl:for-each>
																																																						</xsl:for-each>
																																																					</mo>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var401_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mtext)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var401_test_resultof_node_name_equal_qname">
																																																					<mtext>
																																																						<xsl:for-each select="@xlink:href">
																																																							<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@class">
																																																							<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@style">
																																																							<xsl:attribute name="style" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@id">
																																																							<xsl:attribute name="id" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@xref">
																																																							<xsl:attribute name="xref" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathvariant">
																																																							<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathsize">
																																																							<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathcolor">
																																																							<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathbackground">
																																																							<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="node()">
																																																							<xsl:if test="fn:boolean(self::text())">
																																																								<xsl:sequence select="fn:string(.)"/>
																																																							</xsl:if>
																																																							<xsl:variable name="var402_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var402_test_resultof_node_name_equal_qname">
																																																								<mglyph>
																																																									<xsl:call-template name="tbf:tbf1_mglyph">
																																																										<xsl:with-param name="input" select="." as="node()"/>
																																																									</xsl:call-template>
																																																								</mglyph>
																																																							</xsl:for-each>
																																																							<xsl:variable name="var403_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var403_test_resultof_node_name_equal_qname">
																																																								<malignmark>
																																																									<xsl:for-each select="@edge">
																																																										<xsl:attribute name="edge" select="fn:string(.)"/>
																																																									</xsl:for-each>
																																																								</malignmark>
																																																							</xsl:for-each>
																																																						</xsl:for-each>
																																																					</mtext>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var404_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:ms)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var404_test_resultof_node_name_equal_qname">
																																																					<ms>
																																																						<xsl:for-each select="@xlink:href">
																																																							<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@class">
																																																							<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@style">
																																																							<xsl:attribute name="style" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@id">
																																																							<xsl:attribute name="id" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@xref">
																																																							<xsl:attribute name="xref" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathvariant">
																																																							<xsl:attribute name="mathvariant" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathsize">
																																																							<xsl:attribute name="mathsize" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathcolor">
																																																							<xsl:attribute name="mathcolor" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@mathbackground">
																																																							<xsl:attribute name="mathbackground" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@lquote">
																																																							<xsl:attribute name="lquote" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@rquote">
																																																							<xsl:attribute name="rquote" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="node()">
																																																							<xsl:if test="fn:boolean(self::text())">
																																																								<xsl:sequence select="fn:string(.)"/>
																																																							</xsl:if>
																																																							<xsl:variable name="var405_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:mglyph)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var405_test_resultof_node_name_equal_qname">
																																																								<mglyph>
																																																									<xsl:call-template name="tbf:tbf1_mglyph">
																																																										<xsl:with-param name="input" select="." as="node()"/>
																																																									</xsl:call-template>
																																																								</mglyph>
																																																							</xsl:for-each>
																																																							<xsl:variable name="var406_test_resultof_node_name_equal_qname" as="node()?">
																																																								<xsl:if test="fn:boolean(self::mathnl:malignmark)">
																																																									<xsl:sequence select="."/>
																																																								</xsl:if>
																																																							</xsl:variable>
																																																							<xsl:for-each select="$var406_test_resultof_node_name_equal_qname">
																																																								<malignmark>
																																																									<xsl:for-each select="@edge">
																																																										<xsl:attribute name="edge" select="fn:string(.)"/>
																																																									</xsl:for-each>
																																																								</malignmark>
																																																							</xsl:for-each>
																																																						</xsl:for-each>
																																																					</ms>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var407_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mspace)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var407_test_resultof_node_name_equal_qname">
																																																					<mspace>
																																																						<xsl:for-each select="@width">
																																																							<xsl:attribute name="width" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@height">
																																																							<xsl:attribute name="height" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@depth">
																																																							<xsl:attribute name="depth" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@linebreak">
																																																							<xsl:attribute name="linebreak" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@xlink:href">
																																																							<xsl:attribute name="xlink:href" select="xs:string(xs:anyURI(fn:string(.)))"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@class">
																																																							<xsl:attribute name="class" select="fn:string-join(fn:tokenize(fn:string(.), ' '), ' ')"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@style">
																																																							<xsl:attribute name="style" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@id">
																																																							<xsl:attribute name="id" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																						<xsl:for-each select="@xref">
																																																							<xsl:attribute name="xref" select="fn:string(.)"/>
																																																						</xsl:for-each>
																																																					</mspace>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var408_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mrow)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var408_test_resultof_node_name_equal_qname">
																																																					<mrow>
																																																						<xsl:sequence select="()"/>
																																																					</mrow>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var409_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mfrac)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var409_test_resultof_node_name_equal_qname">
																																																					<mfrac>
																																																						<xsl:sequence select="()"/>
																																																					</mfrac>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var410_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:msqrt)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var410_test_resultof_node_name_equal_qname">
																																																					<msqrt>
																																																						<xsl:sequence select="()"/>
																																																					</msqrt>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var411_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:mroot)">
																																																						<xsl:sequence select="."/>
																																																					</xsl:if>
																																																				</xsl:variable>
																																																				<xsl:for-each select="$var411_test_resultof_node_name_equal_qname">
																																																					<mroot>
																																																						<xsl:sequence select="()"/>
																																																					</mroot>
																																																				</xsl:for-each>
																																																				<xsl:variable name="var412_test_resultof_node_name_equal_qname" as="node()?">
																																																					<xsl:if test="fn:boolean(self::mathnl:menclose)">
																																																						<xsl:sequence select="."/>
																							