<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:fnx="http://www.example.com/fnx" exclude-result-prefixes="#all">
  <xsl:import href="common_style.xsl"/>
  <xsl:include href="retrieve_component_status.xsl"/>
  
  
  
  <!-- 2020-07:
        * updates to make table rows sortable
          - grouping rule violations/exceptions by rule
        * show/hide exceptions over 10 
        
        2020-11-12:
        * if previous schema directory was provided and new/modified components were identified, 
          then indicate component revision status with rule violations (where new/modified are sorted at the top)
        * sort by error type (if spell out table column as: "Warning", "Manual", "Failed", "Passed", "Deleted"
        
        2021-09-13:
        * updated from two passes through schematron results to single pass using xsl:merge to organize results by Rule
        
        2024-08-22:
        * add link to Referenced component lookup resource
        
        NEED TO DO:
        > update the way exceptions are handled so that flattened Schemas can be validated with the same exceptions as design schemas...
        > improve the comparison between two schema versions so different nesting levels doesn't matter...
    -->
  
  <!--
    two passes through Schematron results:
      1. set of all SVRL activated patterns (and their status, rule, and uri); each SVRL is in rule order...problem is have to group starting with active-pattern (if merge purely based on failed-assert, need way to pull out rule)
      2. group by rule and overall status
    
    to produce report, loops through previously captured st96rules (from st96rulesFile) 
        finds matching rule from resultsPass2, and outputs results in table form (by rule)
    
    consider: xslt3.0 with merge (but no streaming)
    
  -->

  <!-- Either svrlSingleFile or svrlDir must be set -->
  <xsl:param name="svrlSingleFile"/>
  <xsl:param name="svrlDir"/>

  <!-- When svrlSingleFile is set, these params must be set. -->
  <xsl:param name="xsdSingleFile"/>

  <!-- When svrlDir is set, these params must be set. -->
  <xsl:param name="inputDirShort"/><!-- unescaped directory with no file protocol -->
  
  <xsl:variable name="namespaces" select="doc('../BaselineNamespaces.xml')/Namespaces/Namespace/@component"/>

  <xsl:variable name="st96rulesFile" select="concat($devDir, '/st96rules.xml')"/>
  <xsl:variable name="schFile" select="concat($devDir, '/schemas/wipo_xsd.sch')"/>
 
  <xsl:variable name="svrlSingleFileFullPath" select="concat($devDir, '/', $svrlSingleFile)"/>
  <xsl:variable name="svrlDirFullPath" select="concat($devDir, '/', $svrlDir)"/>

    <xsl:variable name="kWhereToApproveExceptions" select="if (doc-available('../ApprovedExceptions.xml')) then doc('../ApprovedExceptions.xml')/*/@whereToApproveExceptions else 'InReport'"/>
  <!--
      Configure whereToApproveExceptions IN THE FILE to one of the following values:
      'InReport'
          Allow summary.html to report which XSDs violations are approved.
      'InSchematronRules'
          Trim approved exception violation notices immediately in Schematron.
  -->
  
  <xsl:key name="component-by-uri" match="component" use="@uri"/>
  
  <!-- exceptions are now checked when $resultsPass is generated by common.xsl -->
  

  <xsl:output encoding="UTF-8" method="html" indent="no"/>
  <xsl:strip-space elements="*"/>

  <xsl:include href="common.xsl"/>

  <xsl:template match="/">
    <xsl:message>was reference schema provided? <xsl:value-of select="$previousSchemaComponentsFound"/></xsl:message>
    <html>
      <head>
        <title>ST96XSDValidator Validation Results - ST.96 Conformance Checking via Schematron</title>
         <xsl:sequence select="fnx:include-css()"/>
        <script type="text/javascript">
          <xsl:text disable-output-escaping="yes">
          function hideShowRemaining(st96RuleId, startNum, endNum, resultType) {
            var which = 'none';
            //console.log("st96RuleId: "+st96RuleId);
            var hideShowEl = document.getElementById(st96RuleId + '_more');
            var hideShowText = hideShowEl.innerHTML;
            if (hideShowText.startsWith('Show remaining ')) {
              which = '';
              hideShowEl.innerHTML = 'Hide remaining '+resultType;
            } else {
              which = 'none';
              hideShowEl.innerHTML = 'Show remaining '+resultType;
            }
            for (var i = startNum; i &lt; endNum; i++) {
              document.getElementById(st96RuleId + '_' + i).style.display = which;
            }
          }
          </xsl:text>
        </script>
        
        <script type="text/javascript">
             <!--  <xsl:text>/*!
 * sortable 
 * https://github.com/tofsjonas/sortable/blob/master/LICENSE 
*/ </xsl:text>
               <xsl:text disable-output-escaping="yes">document.addEventListener("click",function(d){function f(a,b){a.className=a.className.replace(h,"")+b}var h=/ dir-(u|d) /,a=/\bsortable\b/,b=d.target;if("TH"==b.nodeName&amp;&amp;(d=b.offsetParent,a.test(d.className))){var e,c=b.parentNode.cells;for(a=0;a&lt;c.length;a++)c[a]===b?e=a:f(c[a],"");a=" dir-d ";-1!==b.className.indexOf(" dir-d ")&amp;&amp;(a=" dir-u ");f(b,a);b=d.tBodies[0];c=[].slice.call(b.cloneNode(!0).rows,0);var k=" dir-u "==a;c.sort(function(a,b){a=a.cells[e].innerText;b=b.cells[e].innerText;if(k){var c=
a;a=b;b=c}return isNaN(a-b)?a.localeCompare(b):a-b});var g=b.cloneNode();for(a=0;a&lt;c.length;a++)g.appendChild(c[a]);d.replaceChild(g,b)}});
</xsl:text>-->
          <xsl:text disable-output-escaping="yes">/**
 * sortable advanced 1.0
 *
 * Makes html tables sortable (has not been tested in ie9)
 *
 * If you only want simple sorting, use the standard one
 *
 * This is a bit more flexible, but will slow it down, since there are
 * extra conditions and function calls
 *
 * Styling is done in css.
 *
 * Copyleft 2017 Jonas Earendel
 *
 * This is free and unencumbered software released into the public domain.
 *
 * Anyone is free to copy, modify, publish, use, compile, sell, or
 * distribute this software, either in source code form or as a compiled
 * binary, for any purpose, commercial or non-commercial, and by any
 * means.
 *
 * In jurisdictions that recognize copyright laws, the author or authors
 * of this software dedicate any and all copyright interest in the
 * software to the public domain. We make this dedication for the benefit
 * of the public at large and to the detriment of our heirs and
 * successors. We intend this dedication to be an overt act of
 * relinquishment in perpetuity of all present and future rights to this
 * software under copyright law.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * For more information, please refer to &lt;http://unlicense.org&gt;
 *
 */
document.addEventListener("click",function(e){var a=" dir-d ",r=" dir-u ",t=/ dir-(u|d) /,n=e.target;function l(e,a){e.className=e.className.replace(t,"")+a||""}function o(e){return(e=e.cells[s]).getAttribute("data-sort")||e.innerText}if("TH"==n.nodeName){var c=n.offsetParent;if(/\bsortable\b/.test(c.className)){for(var s,i=n.parentNode.cells,d=0;d&lt;i.length;d++)i[d]===n?s=d:l(i[d]);var f=a;-1!==n.className.indexOf(a)&amp;&amp;(f=r),l(n,f);var u=c.tBodies[0],N=[].slice.call(u.cloneNode(!0).rows,0),v=f==r;N.sort(function(e,a){var r;return e=o(e),a=o(a),v&amp;&amp;(r=e,e=a,a=r),isNaN(e-a)?e.localeCompare(a):e-a});for(var m=u.cloneNode(),d=0;d&lt;N.length;d++)m.appendChild(N[d]);c.replaceChild(m,u)}}});</xsl:text>
            </script>
        <style>.methodSummaryTd{min-width:8ch;}.ruleIdTd{min-width:10ch;/*70px*/}.ruleIdTd,.methodSummaryTd{vertical-align:top;}table.sortable th{cursor:pointer;}.sortable th{content:"  ";}.sortable th.dir-d::after {color: inherit;content: " \025B4";}
.sortable th.dir-u::after {color: inherit;content: " \025BE";}</style>
      </head>
      <body>
		  <h1 align="center" class="noWrap"><xsl:call-template name="genXSDValidatorVersionInfo"/> Validation Results </h1>
		  <h2 align="center" class="noWrap">ST.96 Conformance Checking via Schematron</h2>     
		   <xsl:sequence select="fnx:time-run()"/>
         <div class="drcVersionDiv">
		  <hr/>
		  <xsl:call-template name="genDrcVersionInfo"/>
          There are <xsl:value-of
          select="$totalST96ruleCount"/><xsl:text> </xsl:text><a
          href="../../doc/03-96-i.pdf" target="_blank">ST96 Design Rules And Conventions</a> (DRC) rules:
          <xsl:value-of select="$gdST96ruleCount"/> General Design
          (GD) rules and <xsl:value-of select="$sdST96ruleCount"/>
          Schema Design (SD) rules.
          <p>See also:  [<a href="integritycheck.html" target="_blank">Schema Integrity Check Report</a>], [<a href="namelist.html" target="_blank">Component Name Report</a>], and [<a href="referencedcomponents.html" target="_blank">Referenced Component Lookup</a>]</p>
          <hr/>
        </div>

        <h2>
          <xsl:text>Conformance Checking of </xsl:text>
          <xsl:value-of select="$numXSDs"/>
          <xsl:if test="$xsdSingleFile"> XSD: </xsl:if>
          <xsl:if test="not($xsdSingleFile)"> XSDs: </xsl:if>
          <span class="code">
            <xsl:value-of select="if ($xsdSingleFile) then $xsdSingleFile else $inputDirShort"/>
          </span>
        </h2>
        <xsl:if test="$previousSchemaComponentsFound">
          <h3>
            Reference XSDs (for comparison): <span class="code">
              <xsl:value-of select="$previousSchemaInputDir"/>
            </span>
          </h3>
          <div class="summaryDiv">Based on comparison to reference XSD's, comparison status may be:
            <ul>
              <li>New</li>
              <li>Modified (including changes to documentation)</li>
              <li>Unchanged</li>
              <li>Unknown</li>
            </ul>
            
          </div>
        </xsl:if>

        <div class="summaryDiv">
          <dl>
            
          <dt>
            <span class="rulesSummaryTally"><xsl:value-of select="$autoCount"/> rules</span>
            <xsl:text> are checked automatically: </xsl:text></dt>
            <dd><span class="rulesSummaryTally"><xsl:value-of select="$auto-passCount"/> rules </span>
            <span class="passSpan label label-success subtle">passed </span>
            <xsl:text>; </xsl:text>
            </dd><dd><span class="rulesSummaryTally"><xsl:value-of select="$auto-warnCount"/> rules </span>
            <span class="warnSpan label label-warning subtle">warned </span>
            <xsl:text>; </xsl:text>
            </dd><dd><b><xsl:value-of select="$auto-failCount"/></b>
            <xsl:text> rules </xsl:text>
            <span class="failSpan label label-danger subtle">failed </span>
          </dd>
          <dt>
            <span class="rulesSummaryTally"><xsl:value-of select="$partialCount"/> rules</span>
            <xsl:text> are partially automated: </xsl:text></dt>
            <dd><span class="rulesSummaryTally"><xsl:value-of select="$partial-passCount"/> rules </span>
            <span class="manualSpan label label-primary subtle"> partially passed and require manual check (manual*) </span>
            <xsl:text>; </xsl:text></dd>
            <dd><span class="rulesSummaryTally"><xsl:value-of select="$partial-warnCount"/> rules </span>
            <span class="warnSpan label label-warning subtle">warned* </span>
            <xsl:text>; </xsl:text></dd>
            <dd><b><xsl:value-of select="$partial-failCount"/></b>
            <xsl:text> rules </xsl:text>
            <span class="failSpan label label-danger subtle">failed* </span>
          </dd>
          <dt>
            <span class="rulesSummaryTally"><xsl:value-of select="$manualCount"/> rules</span> must be checked <span class="manualSpan label label-primary subtle">manually </span>
          </dt>
          <dt class="tallyDiv">
            <span class="rulesSummaryTally tallySpan"><xsl:value-of select="$unaddressedCount"/> rules</span> have not yet been addressed <span class="ruleStatusIcon">(?)</span>;
            <span class="rulesSummaryTally"><xsl:value-of select="$deletedCount"/></span> <xsl:value-of select="if ($deletedCount = 1) then ' rule has' else ' rules have'"/> been <span class="deletedSpan label label-default subtle">deleted </span>
          </dt>
            </dl>
          <div style="margin-bottom: 16px">
            <span class="rulesSummaryTally"><xsl:value-of select="$totalST96ruleCount"/> rules</span> total
          </div>
          <xsl:if test="$kWhereToApproveExceptions eq 'InSchematronRules'">
            <div>Exceptions were processed during validation. They will not appear in this report. To see any rules which have exceptions, please change the attribute @whereToApproveExceptions in the ApprovedExceptions.xml file to &apos;InReport&apos;</div>
          </xsl:if>
        </div>

        <!--<xsl:result-document href="../resultsPass.xml" method="xml">
          <xsl:copy-of select="$resultsPass"/>
        </xsl:result-document>-->
          <!--    For Debugging/Diagnostics Only
         <h2>resultsPassNew</h2>
        <xsl:call-template name="DebugInfo">
          <xsl:with-param name="xmlInfo" select="$resultsPass/patterns/pattern[position() &lt; 120]"/>
        </xsl:call-template>-->
     
        <!--<h2>components</h2>
        <xsl:if test="exists($components/components/component)">
        <xsl:call-template name="DebugInfo">
          <xsl:with-param name="xmlInfo" select="$components/components/component"/>
        </xsl:call-template>
        </xsl:if>-->

        <table class="sortable table table-bordered table-condensed table-striped table-primary results">
          <colgroup>
            <col width="72px"/>
            <col width="32px"/>
          </colgroup>
          <thead><tr>
            <th class="ruleIdTh dir-d ">Rule ID</th>
            <th title="Status: Pass (&#10003;); Fail (X); Manual (M); Unaddressed (?)" class="statusTh">Status</th>
            <th>Description / Results</th>
          </tr></thead>
          
          
          <xsl:for-each select="$resultsPass/patterns/pattern">
            <xsl:variable name="st96ruleId" select="@st96ruleId"/>
            <xsl:variable name="method" select="@method"/>
            <xsl:variable name="status" select="@status"/>
            <xsl:variable name="violationResultElementsOfThisRule" as="node()*">
              <xsl:for-each select="result">
                <!-- result has error message, and attributes: component, is-exception, namespace, type, and uri  -->
                <xsl:variable name="component-name" select="if (boolean(string-length(@component))) then (@component) else (replace(tokenize(@uri,'/')[last()],'(_V\d+_\d+[^\.]*)?\.xsd',''))"/><!-- default to filename if component name unable to be retrieved due to rule context -->
                <xsl:variable name="revision-status" select="if ($previousSchemaComponentsFound) then key('component-by-name-and-namespace',concat($component-name,@namespace),$components)/@status else ()"/>
                <xsl:element name="{local-name()}">
                    <xsl:copy-of select="@*"/>
                    <xsl:attribute name="component-revision-status">
                      <!-- what about when flattened schema?? -->
                      <xsl:if test="$previousSchemaComponentsFound and count(distinct-values($revision-status))!=1"><xsl:message>Component status for <xsl:value-of select="@component"/> (<xsl:value-of select="@namespace"/>) is unknown because revision status is <xsl:sequence select="$revision-status"/></xsl:message></xsl:if>
                      <xsl:value-of select="if (count(distinct-values($revision-status))=1) then distinct-values($revision-status) else 'Unknown'"/>
                    </xsl:attribute>
                  <xsl:attribute name="component-moved-indicator"><xsl:value-of select="if ($revision-status/parent::node()/@moved-namespaces) then ($revision-status/parent::node()/@moved-namespaces) else ('false')"/></xsl:attribute>
                  <xsl:choose><!-- don't check for exceptions if kWhereToApproveExceptions != 'inReport' -->
                    <!--<xsl:when test="$method = 'Manual' and $status = 'unknown' and $revision-status != 'unchanged'">
                      <!-\- manual inspection rules: ignore unchanged components by marking it as an 'exception'; obviously this will not work if the previous schema is not provided -\->
                      <xsl:attribute name="is-exception">true</xsl:attribute>
                    </xsl:when>-->
                    <xsl:when test="$kWhereToApproveExceptions != 'InReport'">
                      <xsl:attribute name="is-exception">false</xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:copy-of select="@is-exception"/>
                    </xsl:otherwise>
                  </xsl:choose>
                    <xsl:copy-of select="node()"/>
                  </xsl:element>
              </xsl:for-each>
            </xsl:variable>
            
            <xsl:variable name="numApprovedViolationsOfThisRule" select="count($violationResultElementsOfThisRule[@is-exception = 'true'])"/>
            <xsl:variable name="numViolationsOfThisRule" select="count($violationResultElementsOfThisRule[@is-exception = 'false'])"/>
            <xsl:variable name="numXSDsViolatingThisRule" select="count(distinct-values($violationResultElementsOfThisRule[@is-exception = 'false']/@uri))"/>

            <xsl:variable name="calculatedStatus"><!-- success only if all passed... -->
              <xsl:choose>
                <xsl:when test="$numViolationsOfThisRule > 0">
                  <xsl:value-of select="@status"/>
                </xsl:when>
                <xsl:otherwise>success</xsl:otherwise>
              </xsl:choose>
            </xsl:variable>
            <xsl:variable name="isDeleted" select="@status = 'deleted'"/>
            <xsl:variable name="trClass" select="if ($isDeleted) then 'deletedTr' else fnx:make_tr_class($calculatedStatus, $method)"/>
            
            <tr class="{$trClass}">
              <xsl:variable name="deletedClass" select="if ($isDeleted) then 'deletedRule' else ''"/>
              <td class="ruleIdTd {$deletedClass}">
                <xsl:value-of select="$st96ruleId"/>
              </td>
              <td title="Status: Pass (&#10003;); Warn (W); Fail (F); Manual (M); Deleted (D); Unaddressed (?)" class="methodSummaryTd">
                <xsl:choose>
                  <xsl:when test="$method eq 'Partial'">
                    <xsl:choose>
                      <xsl:when test="$calculatedStatus eq 'failure'">
                        <xsl:attribute name="title">Status: Failed; Requires manual check</xsl:attribute>
                        <xsl:attribute name="data-sort">X*</xsl:attribute>
                        <span class="label label-danger subtle">Failed*</span>
                      </xsl:when>
                      <xsl:when test="$calculatedStatus eq 'warning'">
                        <xsl:attribute name="title">Status: Warning; Requires manual check</xsl:attribute>
                        <xsl:attribute name="data-sort">W*</xsl:attribute>
                        <span class="label label-warning subtle">Warning*</span>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:attribute name="title">Requires manual check</xsl:attribute>
                        <xsl:attribute name="data-sort">M*</xsl:attribute>
                        <span class="label label-primary subtle">Manual*</span>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:when test="$method eq 'Manual'">
                    <xsl:attribute name="title">Status: Manual</xsl:attribute>
                    <xsl:attribute name="data-sort">M</xsl:attribute>
                    <span class="label label-primary subtle">Manual</span>
                  </xsl:when>
                  <xsl:when test="$isDeleted">
                    <xsl:attribute name="title">Status: Deleted</xsl:attribute>
                    <xsl:attribute name="data-sort">D</xsl:attribute>
                    <span class="deletedIcon label label-default subtle">Deleted</span>
                  </xsl:when>
                  <xsl:when test="$method eq 'Auto'">
                    <xsl:choose>
                      <xsl:when test="$calculatedStatus eq 'failure'">
                        <xsl:attribute name="title">Status: Failed</xsl:attribute>
                        <xsl:attribute name="data-sort">X</xsl:attribute>
                        <span class="label label-danger subtle">Failed</span>
                      </xsl:when>
                      <xsl:when test="$calculatedStatus eq 'warning'">
                        <xsl:attribute name="title">Status: Warning</xsl:attribute>
                        <xsl:attribute name="data-sort">W</xsl:attribute>
                        <span class="label label-warning subtle">Warning</span>
                      </xsl:when>
                      <xsl:when test="$calculatedStatus eq 'unknown'"><!-- typically happens when @role not populated in schematron -->
                        <xsl:attribute name="title">Status: Unaddressed</xsl:attribute>
                        <xsl:attribute name="data-sort">?</xsl:attribute>
                        <span class="unaddressedIcon">?</span>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:attribute name="title">Status: Passed</xsl:attribute>
                        <xsl:attribute name="data-sort">&#10003;</xsl:attribute>
                        <span class="label label-success subtle">Passed</span>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:when test="$method eq 'Unaddressed'">
                    <xsl:attribute name="title">Status: Unaddressed</xsl:attribute>
                    <xsl:attribute name="data-sort">?</xsl:attribute>
                    <span class="unaddressedIcon">?</span>
                  </xsl:when>
                  <xsl:otherwise>[???]</xsl:otherwise>
                </xsl:choose>
              </td>
              <td colspan="2" class="descriptionTd"><!-- group other rows under this table cell... -->
                <!--<textarea editable="false">
                  <xsl:copy-of select="$violationResultElementsOfThisRule"/>
                </textarea>-->
                <xsl:choose>
                  <xsl:when test="$isDeleted">
                    <i>Deleted</i>
                  </xsl:when>
                  <xsl:when test="$method ne 'Manual'">
                    <xsl:value-of select="description"/>
                    <!-- embed results as nested table -->
                    <table class="table table-bordered table-condensed table-striped">
                      <xsl:if test="$calculatedStatus eq 'failure' or $calculatedStatus eq 'warning'">
                        <xsl:if test="$calculatedStatus != 'success'">
                          <xsl:choose>
                            <xsl:when test="$numXSDs &gt; 10 and $numXSDsViolatingThisRule = $numXSDs">
                              <tr class="{$trClass}">
                                
                                <xsl:if test="$previousSchemaComponentsFound"><td class="violationHeaderTd"><xsl:text>Comparison status:</xsl:text></td></xsl:if>
                                
                                <td class="violationHeaderTd">All <xsl:value-of select="$numXSDs"/> XSDs violate rule <xsl:value-of select="$st96ruleId"/>. <xsl:if test="$numViolationsOfThisRule gt 10">
                                   Here are the first 10 violations:
                                </xsl:if></td>
                                <td class="violationHeaderTd">Violation details:</td><!-- 2021-02-09: include details of violation even if all violate-->
                              </tr>
                            </xsl:when>
                            <xsl:otherwise>
                              <tr class="{$trClass}">
                                
                                <xsl:if test="$previousSchemaComponentsFound"><td class="violationHeaderTd">
                                  <xsl:text>Comparison status:</xsl:text>
                                </td></xsl:if>
                                <td class="violationHeaderTd"><xsl:value-of select="$numXSDsViolatingThisRule"/> XSDs violate rule <xsl:value-of select="$st96ruleId"/>. <xsl:if test="$numViolationsOfThisRule gt 10">
                                   Here are the first 10 violations:
                                </xsl:if></td>
                                <td class="violationHeaderTd">Violation details:</td>
                              </tr>
                                </xsl:otherwise>
                          </xsl:choose>
                          <xsl:for-each select="$violationResultElementsOfThisRule[@is-exception = 'false']">
                                <xsl:sort select="for $x in @component-revision-status return ((number($x = 'new')*1) + (number($x = 'modified')*2) + (number($x = 'unchanged') * 3))" data-type="number" order="ascending"/>
                                <xsl:variable name="uri" select="@uri"/>
                                <xsl:variable name="shortenedUri" select="substring-after($uri,concat(resolve-uri($inputDirShort),'/'))"/>
                                <xsl:if test="position() eq 10">
                                  <tr class="{$trClass}">
                                     <td/>
                                    <td class="showRemainingTd">[ <a id="{$st96ruleId}_more" class="showRemainingA" href="javascript:hideShowRemaining('{$st96ruleId}', 10, {$numViolationsOfThisRule},'violations')">Show remaining violations</a> ]</td>
                                    <td/>
                                  </tr>
                                </xsl:if>
                                <tr class="{$trClass}">
                                  <xsl:if test="position() ge 10">
                                    <xsl:attribute name="id"><xsl:value-of select="concat($st96ruleId,'_',position())"/></xsl:attribute>
                                    <xsl:attribute name="style">display:none</xsl:attribute>
                                  </xsl:if>
                                  
                                  <xsl:if test="$previousSchemaComponentsFound"><td class="componentStatusTd">
                                    <xsl:variable name="status" select="@component-revision-status"/>
                                    <xsl:choose>
                                      <xsl:when test="$status = 'new' or $status = 'modified'">
                                        <b>
                                          <xsl:value-of select="concat(upper-case(substring($status,1,1)),substring($status,2))"/>
                                          <xsl:if test="@component-moved-indicator = 'true'"><xsl:text> (Moved)</xsl:text></xsl:if></b>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="concat(upper-case(substring($status,1,1)),substring($status,2))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </td></xsl:if>
                              <td class="fileNameTd">
                                <xsl:variable name="filename" select="fnx:BreakBeforeSlash($shortenedUri)"/>
                                <a href="{$uri}" target="_blank">
                                  <xsl:copy-of select="$filename"/>
                                </a>
                                <xsl:if test="not(matches(string-join($filename,''),concat(@namespace,'/')))">
                                  <xsl:value-of select="concat(' (', @namespace, '/', @component, ')')"/>
                                </xsl:if>
                              </td>
                                  <td class="reportTextTd">
                                    <xsl:copy-of select="fnx:BreakBeforeSlash(text())"/>
                                  </td>
                                </tr>
                              </xsl:for-each>
                        </xsl:if>
                      </xsl:if>
            <!-- List Approved Exceptions -->
                      <xsl:if test="$numApprovedViolationsOfThisRule > 0">
                        <tr class="approvedExceptionTr">
                         <xsl:if test="$previousSchemaComponentsFound"> <td class="violationHeaderTd">
                            <xsl:text>Comparison status:</xsl:text>
                          </td></xsl:if>
                          <td class="violationHeaderTd">These <xsl:value-of select="
                              if ($numApprovedViolationsOfThisRule &gt; 3) then
                                $numApprovedViolationsOfThisRule
                              else
                                ''"/> XSDs violate rule <xsl:value-of select="$st96ruleId"/> but are approved exceptions:</td>
                          <td class="violationHeaderTd">Violation details:</td>
                        </tr>
                        
                        <xsl:for-each select="$violationResultElementsOfThisRule[@is-exception = 'true']">
                          <xsl:sort select="for $x in @component-revision-status return ((number($x = 'new')*1) + (number($x = 'modified')*2) + (number($x = 'unchanged') * 3))" data-type="number" order="ascending"/>
                          <xsl:variable name="uri" select="@uri"/>
                          <xsl:variable name="shortenedUri" select="substring-after($uri,concat(resolve-uri($inputDirShort),'/'))"/>
                          <xsl:if test="position() eq 10 and position() != last()">
                            <tr class="approvedExceptionTr">
                               <xsl:if test="$previousSchemaComponentsFound"><td/></xsl:if>
                              <td class="showRemainingTd">[ <a id="exception_{$st96ruleId}_more" class="showRemainingA" href="javascript:hideShowRemaining('exception_{$st96ruleId}', 10, {$numApprovedViolationsOfThisRule},'exceptions')">Show remaining exceptions</a> ]</td>
                              <td />
                            </tr>
                          </xsl:if>
                          <tr id="exception_{$st96ruleId}_{position()}" class="approvedExceptionTr">
                            <xsl:if test="position() ge 10">
                              <xsl:attribute name="style">display:none</xsl:attribute>
                            </xsl:if>
                            
                            <xsl:if test="$previousSchemaComponentsFound"><td class="componentStatusTd"><xsl:variable name="status" select="@component-revision-status"/><xsl:choose>
                              <xsl:when test="$status = 'new' or $status = 'modified'">
                                <b><xsl:value-of select="concat(upper-case(substring($status,1,1)),substring($status,2))"/></b><xsl:if test="@component-moved-indicator = 'true'"><xsl:text> (Moved)</xsl:text></xsl:if>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="concat(upper-case(substring($status,1,1)),substring($status,2))"/>
                              </xsl:otherwise>
                            </xsl:choose></td></xsl:if>
                            <td class="fileNameTd">
                              <xsl:variable name="filename" select="fnx:BreakBeforeSlash($shortenedUri)"/>
                              <a href="{$uri}" target="_blank"><!-- add component name if flattened schema being checked?? -->
                                <a href="{$uri}" target="_blank">
                                  <xsl:copy-of select="$filename"/>
                                </a>
                                <xsl:if test="not(matches(string-join($filename,''),concat(@namespace,'/')))">
                                  <xsl:value-of select="concat(' (', @namespace, '/', @component, ')')"/>
                                </xsl:if>
                              </a>
                              
                            </td>
                            <td class="reportTextTd">
                              <xsl:copy-of select="fnx:BreakBeforeSlash(text())"/>
                            </td>
                          </tr>
                        </xsl:for-each>
                        
                      </xsl:if>
                    </table>
                  </xsl:when>
                  <xsl:otherwise>
                    <!-- Manual -->
                    <xsl:value-of select="fnx:BreakBeforeSlash(description)"/>
                    <xsl:choose>
                      <xsl:when test="$st96ruleId = 'GD-04' or $st96ruleId = 'GD-05'">
                        <!-- 2021-08-16 -->
                        <div><br/>Refer to <a href="integritycheck.html">Integrity Check</a> for possible misspelled terms or improper use of acronyms and abbreviations. </div>
                      </xsl:when>
                      <xsl:when test="exists($violationResultElementsOfThisRule[@is-exception = 'false'])"><!-- 2021-08-16: Manual, but can be checked inline...?? -->

                        <table class="table table-bordered table-condensed table-striped">
                          <tr class="{$trClass}">
                            <xsl:if test="$previousSchemaComponentsFound">
                              <td class="violationHeaderTd">
                                <xsl:text>Comparison status:</xsl:text>
                              </td>
                            </xsl:if>
                            <td class="violationHeaderTd"><xsl:value-of select="$numXSDsViolatingThisRule"/> XSDs require manual review of this rule <xsl:value-of select="$st96ruleId"/>. <xsl:if test="$numApprovedViolationsOfThisRule gt 10"> Here are the first 10 components: </xsl:if></td>
                            <td class="violationHeaderTd">Details:</td>
                          </tr>
                          <xsl:for-each select="$violationResultElementsOfThisRule[@is-exception = 'false']">
                            <xsl:sort select="
                                for $x in @component-revision-status
                                return
                                  ((number($x = 'new') * 1) + (number($x = 'modified') * 2) + (number($x = 'unchanged') * 3))" data-type="number" order="ascending"/>
                            <xsl:variable name="uri" select="@uri"/>
                            <xsl:variable name="shortenedUri" select="substring-after($uri,concat(resolve-uri($inputDirShort),'/'))"/>
                            <xsl:if test="position() eq 10">
                              <tr class="{$trClass}">
                                <td/>
                                <td class="showRemainingTd">[ <a id="{$st96ruleId}_more" class="showRemainingA" href="javascript:hideShowRemaining('{$st96ruleId}', 10, {$numViolationsOfThisRule},'components')">Show remaining components</a> ]</td>
                                <td/>
                              </tr>
                            </xsl:if>
                            <tr class="{$trClass}">
                              <xsl:if test="position() ge 10">
                                <xsl:attribute name="id">
                                  <xsl:value-of select="concat($st96ruleId, '_', position())"/>
                                </xsl:attribute>
                                <xsl:attribute name="style">display:none</xsl:attribute>
                              </xsl:if>
                              <xsl:if test="$previousSchemaComponentsFound">
                                <td class="componentStatusTd">
                                  <xsl:variable name="status" select="@component-revision-status"/>
                                  <xsl:choose>
                                    <xsl:when test="$status = 'new' or $status = 'modified'">
                                      <b>
                                        <xsl:value-of select="concat(upper-case(substring($status,1,1)),substring($status,2))"/>
                                      </b><xsl:if test="@component-moved-indicator = 'true'"><xsl:text> (Moved)</xsl:text></xsl:if>
                                    </xsl:when>
                                    <xsl:otherwise>
                                      <xsl:value-of select="concat(upper-case(substring($status,1,1)),substring($status,2))"/>
                                    </xsl:otherwise>
                                  </xsl:choose>
                                </td>
                              </xsl:if>
                              <td class="fileNameTd">
                                <xsl:variable name="filename" select="fnx:BreakBeforeSlash($shortenedUri)"/>
                                  <a href="{$uri}" target="_blank">
                                  <xsl:copy-of select="$filename"/>
                                </a>
                                <xsl:if test="not(matches(string-join($filename,''),concat(@namespace,'/')))">
                                  <xsl:value-of select="concat(' (', @namespace, '/', @component, ')')"/>
                                </xsl:if>
                              </td>
                              <td class="reportTextTd">
                                <xsl:copy-of select="fnx:BreakBeforeSlash(text())"/>
                              </td>
                            </tr>
                          </xsl:for-each>
                        </table>
                      </xsl:when>
                    </xsl:choose>
                  </xsl:otherwise>
                </xsl:choose>
              </td>
            </tr>
          </xsl:for-each>
        </table>
      </body>
    </html>
  </xsl:template>

  <xsl:function name="fnx:ShortenName">
   <xsl:param name="uri"/>
    <xsl:value-of select="replace(substring-after($uri, 'dev/svrl/'), '.svrl', '.xsd')"/>
  </xsl:function>

  <xsl:function name="fnx:except-any-atomic" as="xs:anyAtomicType*">
    <xsl:param name="a1" as="xs:anyAtomicType*"/>
    <xsl:param name="a2" as="xs:anyAtomicType*"/>
    <xsl:sequence select="distinct-values($a1[not(.=$a2)])"/>
  </xsl:function>
  
  <xsl:function name="fnx:BreakBeforeSlash" as="item()+">
    <xsl:param name="text"/>
    <xsl:variable name="return-node"><xsl:analyze-string select="$text" regex="/">
      <xsl:matching-substring><wbr/><!-- represents a word break opportunity --><xsl:text>/</xsl:text></xsl:matching-substring>
        <xsl:non-matching-substring><xsl:value-of select="current()"/></xsl:non-matching-substring>
      </xsl:analyze-string></xsl:variable>
    <xsl:sequence select="$return-node"/>
  </xsl:function>

</xsl:stylesheet>
