<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    exclude-result-prefixes="xs"
    version="2.0">
    
    <!-- use textarea and diff.js -->
    <xsl:param name="previousSchemaInputDir"/>
    <xsl:param name="inputDirShort"/>
    
    <xsl:variable name="previous-schema-collection" select="collection(concat('file:///',$previousSchemaInputDir,'?select=*.xsd&amp;recurse=yes'))"/>
    
    <xsl:key name="schema-by-name-and-namespace" match="*:schema/*[@name]" use="concat(@name,tokenize(parent::*:schema/@targetNamespace,'[/:]')[last()])"/>
    
    <xsl:variable name="namespace-prefixes" select="string-join((doc('../BaselineNamespaces.xml')/Namespaces/Namespace/@ns-prefix,'xsd'),'|')"/>
    
    <xsl:template match="components">
        <html>
            <head>
                <title>Component Modifications Report</title>
                <!--<script src="../diff.js"> </script>-->
                <script type="text/javascript"><xsl:value-of select="unparsed-text('../diff.js')"/></script>
<script type="text/javascript">document.addEventListener("DOMContentLoaded", function () {
    var titles = document.getElementById('schema-comparisons');
    if (!(!(typeof (titles) != 'undefined') || !(titles != null))) {
        schemas = titles.getElementsByTagName('table'); 
        for (let schema of schemas) {
        console.log(schema);
        var cTh = document.createElement('div');
        cTh.appendChild(document.createTextNode('Simple Comparison (TESTING)'));
        schema.rows[0].cells[0].appendChild(cTh);
        for (var x = 1, row; row = schema.rows[x]; x++) {
            var diff = JsDiff[ 'diffWords'](row.cells[1].textContent.replace(/(\W)(<xsl:value-of select="$namespace-prefixes"/>):/g, '$1$2_'), row.cells[2].textContent.replace(/(\W)(<xsl:value-of select="$namespace-prefixes"/>):/g, '$1$2_'));
            var fragment = document.createDocumentFragment();
            for (var i = 0; i != diff.length; i++) {
                if (!(! diff[i].added || ! diff[i + 1] || ! diff[i + 1].removed)) {
                    var swap = diff[i]; diff[i] = diff[i + 1]; diff[i + 1] = swap;
                }
                var resultText = diff[i].value.replace(/(\W|^)(<xsl:value-of select="$namespace-prefixes"/>)_/g, '$1$2:');
                var node, result;
                if (diff[i].removed) {
                    node = document.createElement('del');
                    node.appendChild(document.createTextNode(resultText));
                } else if (diff[i].added) {
                    node = document.createElement('ins');
                    node.appendChild(document.createTextNode(resultText));
                } else {
                    node = document.createTextNode(resultText);
                }
                fragment.appendChild(node);
            }
            result = document.createElement('div');
            result.textContent = '';
            result.appendChild(fragment);
            row.cells[0].appendChild(result);
        }
    }
    }
});</script>
<style>
    table{width:100%;border:solid black 1px;border-collapse:collapse;}
    body table tr:nth-child(even){background: #e8f4f8;}
    td,th{vertical-align:top;border:solid black 1px;padding:2px;}
    td{white-space:pre-line;font-size:smaller;}
    ins{color:green;font-style:italic;font-weight:550;/*700 is bold */text-decoration:none; white-space:pre-line;}
    del{color:red;font-weight:550;white-space:pre-line;}
</style>                
            </head>
            <body>
                <h1>Inline schema component comparison</h1>
                <h2><xsl:value-of select="count(component[@status = 'modified'])"/> modifications</h2>
                <!--<h3><xsl:for-each select="component[@status = 'modified']">
                    <p><xsl:value-of select="concat(@namespace,'/',@name)"/></p>
                </xsl:for-each></h3>-->
                <h5>Current Schema directory: <xsl:value-of select="$inputDirShort"/><br></br>
                Previous Schema directory: <xsl:value-of select="$previousSchemaInputDir"/>
                </h5>
                <div><u>Note:</u> this is a simple text comparison of the schema components. The XML tags may differ slightly from this presentation<br></br></div>
                <h5><xsl:value-of select="format-dateTime(current-dateTime(),'[D01]-[MNn,3-3]-[Y0001] [H01]:[m01] [P]')"/></h5>
                <div id="schema-comparisons">
                            <xsl:for-each-group select="component[@status = 'modified']" group-by="@namespace">
                                <h4><xsl:value-of select="current-grouping-key()"/> (<xsl:value-of select="count(current-group())"/>)</h4>
                                <table>
                        <thead>
                            <tr>
                                <th>Component Name</th>
                                <th>Previous Schema</th>
                                <th>Current Schema</th>
                            </tr>
                        </thead>
                        <tbody>
                                <xsl:for-each select="current-group()">
                                    <xsl:sort select="lower-case(@name)"/>
                                    <xsl:variable name="componentName" select="@name"/>
                                    <xsl:variable name="namespaceName" select="current-grouping-key()"/>
                                    
                                <tr>
                                    <td><div><b><xsl:value-of select="concat($componentName, ' (',@namespace,')')"/></b></div></td>
                                    <td>
                                        
<!--                                        <textarea editable="false" spellcheck="false" cols="20">-->
<!--                                            <xsl:copy-of select="$previous-schema-collection/key('component-by-name', $componentName)"/>-->
                                            <xsl:apply-templates select="$previous-schema-collection/key('schema-by-name-and-namespace', concat($componentName,$namespaceName))" mode="copy"/>
                                        <!--</textarea>-->
                                    </td>
                                    <td>
<!--                                        <textarea editable="false" spellcheck="false" cols="20">-->
<!--                                            <xsl:copy-of select="doc(current()/@uri)/*:schema/*[@name eq $componentName]"/>-->
                                            <xsl:apply-templates select="doc(current()/@uri)/*:schema/*[@name eq $componentName]" mode="copy"/>
                                        <!--</textarea>-->
                                    </td>
                                </tr></xsl:for-each>
                        </tbody>
                                </table>
                            </xsl:for-each-group>
                </div></body></html>
        
    </xsl:template>
    
    <xsl:template match="*" mode="copy">
        <xsl:value-of select="concat('&lt;',name(),string-join(for $x in @* return concat(' ',$x/name(),'=&quot;',$x,'&quot;'),' '))"/>
        <xsl:if test="child::node()"><xsl:text>&gt;</xsl:text></xsl:if>
        <xsl:apply-templates mode="#current"/>
        <xsl:choose>
            <xsl:when test="child::node()">
                <xsl:value-of select="concat('&lt;/',name(),'&gt;')"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>/&gt;</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
</xsl:stylesheet>