<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">

    <xsl:variable name="components" select="
            if (doc-available('../components.xml')) then
                doc('../components.xml')
            else
                ()"/><!-- components.xml generated by xsl/component_status.xsl -->
    <xsl:variable name="previousSchemaComponentsFound" select="exists($components/components/component)"/>

    <xsl:key name="component-by-status-and-namespace" match="component" use="concat(@status, @namespace)"/>
    <xsl:key name="component-by-name-and-namespace" match="component" use="concat(@name, @namespace)"/>
    <xsl:key name="component-status-by-filename-and-namespace" match="/components/component/@status" use="string-join((tokenize(parent::node()/@uri, '/')[last()], parent::node()/@namespace), ',')"/>

    <xsl:param name="previousSchemaInputDir"/>

</xsl:stylesheet>