<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fnx="http://www.example.com/fnx" exclude-result-prefixes="fnx" version="2.0">
    <!-- creates a cross-reference report of the components which use referenced components
            uses refs.configxml as a source
    -->
    <xsl:output method="html" indent="no"/>
    <xsl:import href="common_style.xsl"/>
    <xsl:import href="retrieve_component_status.xsl"/>
    <xsl:param name="namespaces" select="doc('../BaselineNamespaces.xml')/Namespaces"/>
    <xsl:param name="reportInDir"/><!-- schema input directory -->
    
    <xsl:variable name="st96Version" select="doc(/names/@st96VersionXSDURI)/*/@version"/>
    
    <xsl:key name="namespace-by-uri" match="Namespace/@subdir" use="parent::node()/@ns"/>
    <xsl:key name="namespace-by-prefix" match="Namespace/@subdir" use="parent::node()/@ns-prefix"/>
    
    <xsl:template match="/">
        <html>
            <head>
                <title>Referenced Component Lookup</title>
                <xsl:sequence select="fnx:include-css()"/>
                <style>body table tr:nth-child(even){background: #e8f4f8;}span.misspelled{color:red;background-image: linear-gradient(to right, red 50%, transparent 50%);background-position: 0 1.04em;background-repeat: repeat-x;background-size: 6px 3px; /*text-decoration-line: underline;text-decoration-color:red;text-decoration-style: dashed;*/}th{text-align:left;}table.sortable th{cursor:pointer;}tr td:nth-child(3){width:10em;min-width:11ch;}table *{font-size:small;}.sortable th.dir-d::after {color: inherit;content: " \025B4";}.sortable th.dir-u::after {color: inherit;content: " \025BE";}
                .top{background-color:white;}.modified:after{content:"\00A0Mod";font-size:xx-small;vertical-align:top;}.modified.only-annotation:after{content:"\00A0Mod Annot"}.new:after{content:"\00A0New";font-size:xx-small;vertical-align:top;}p.new.moved:after{content:"\00A0New (Moved)";font-size:xx-small;vertical-align:top;}.deleted:after{content:"\00A0""Del";font-size:xx-small;vertical-align:top;}.deleted.moved:after{content:"\00A0""Del (Moved))";font-size:xx-small;vertical-align:top;}.deleted a{background-color:lightgrey;color:black;}
                </style>
<!--            <script type="text/javascript" src="../sortable.min.js"/>-->
            <script type="text/javascript">
               <xsl:text>/*!
 * sortable 
 * https://github.com/tofsjonas/sortable/blob/master/LICENSE 
*/ </xsl:text>
               <xsl:text disable-output-escaping="yes">document.addEventListener("click",function(d){function f(a,b){a.className=a.className.replace(h,"")+b}var h=/ dir-(u|d) /,a=/\bsortable\b/,b=d.target;if("TH"==b.nodeName&amp;&amp;(d=b.offsetParent,a.test(d.className))){var e,c=b.parentNode.cells;for(a=0;a&lt;c.length;a++)c[a]===b?e=a:f(c[a],"");a=" dir-d ";-1!==b.className.indexOf(" dir-d ")&amp;&amp;(a=" dir-u ");f(b,a);b=d.tBodies[0];c=[].slice.call(b.cloneNode(!0).rows,0);var k=" dir-u "==a;c.sort(function(a,b){a=a.cells[e].innerText;b=b.cells[e].innerText;if(k){var c=
a;a=b;b=c}return isNaN(a-b)?a.localeCompare(b):a-b});var g=b.cloneNode();for(a=0;a&lt;c.length;a++)g.appendChild(c[a]);d.replaceChild(g,b)}});
</xsl:text>
            </script>
            </head>
            <body>
                <a style="position: fixed; bottom:5px;right:5px;" href="#" title="Click to go to top">Go to top</a>
                <h1 align="center">Referenced Component Lookup</h1>
                <xsl:sequence select="fnx:time-run()"/>
                <hr/>
                <div><p>See also:  [<a href="summary.html" target="_blank">ST.96 Conformance Checking Report</a>], [<a href="integritycheck.html" target="_blank">Schema Integrity Check Report</a>] and [<a href="namelist.html" target="_blank">Component Name Report</a>]</p></div>
                <h2>
               <p><b>Schema input directory:</b> <xsl:value-of select="$reportInDir"/></p></h2>
                <xsl:if test="$previousSchemaInputDir">
               <p class="header"><b>Reference XSDs (for comparison): </b>  <xsl:value-of select="$previousSchemaInputDir"/>  </p>
            </xsl:if>
                <table id="referenced-component-list" class="sortable">
                    <thead><tr>
                        <xsl:if test="$previousSchemaComponentsFound">
                            <th>Comparison Status</th>
                        </xsl:if>
                        <th>Referenced component namespace</th><th>Referenced component name</th><th>Used by</th>
                    </tr></thead>
                    <tbody>
                        <xsl:apply-templates select="names/ref">
                            <xsl:sort select="key('namespace-by-uri',@ns,$namespaces)"/>
                            <xsl:sort select="@name"/>
                        </xsl:apply-templates>
                    </tbody>
                </table>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template match="ref[empty(key('namespace-by-uri', @ns, $namespaces))]" priority="2"/>
    <xsl:template match="ref[key('namespace-by-uri',@ns,$namespaces)[not(parent::node()/@std!='external')]]" priority="2"/>
    
    <xsl:template match="ref">
        <xsl:variable name="this-namespace" select="key('namespace-by-uri',@ns,$namespaces)"/>
        <xsl:variable name="component" select="if ($previousSchemaComponentsFound) then key('component-by-name-and-namespace',concat(@name, $this-namespace),$components) else ()"/>
        <tr>
            <xsl:if test="$component/@status">
                <td>
                    <xsl:choose>
                        <xsl:when test="$component/@status != 'unchanged'">
                            <b>
                                <xsl:value-of select="$component/@status"/>
                                <xsl:if test="$component/@only-modified-annotation = 'true'">
                                    <xsl:text> (annotation changes only)</xsl:text>
                                </xsl:if>
                                <xsl:if test="$component/@moved-namespace = 'true'">
                                    <xsl:text> (Moved)</xsl:text>
                                </xsl:if>
                            </b>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$component/@status"/>
                        </xsl:otherwise>
                    </xsl:choose>
                    
                </td>
            </xsl:if>
            <td>
                <xsl:value-of select="$this-namespace"/>
            </td>
            <td>
                <a href="{resolve-uri(concat('../',$this-namespace,'/',@name,'.xsd'),parent::node()/@st96VersionXSDURI)}" target="_blank">
                    <xsl:value-of select="@name"/>
                </a>
            </td>
            <td>
                <xsl:analyze-string select="@used-by" regex="\S+">
                    <xsl:matching-substring>
                        <xsl:variable name="referencing-component" select="substring-after(regex-group(0), ':')"/>
                        <xsl:variable name="ns" select="key('namespace-by-prefix', substring-before(regex-group(0), ':'), $namespaces)"/>
                        
                        <xsl:variable name="ref-component-status" select="
                                if ($previousSchemaComponentsFound) then
                                    key('component-by-name-and-namespace', concat($referencing-component, $ns), $components)
                                else
                                    ()"/>
                        <span class="name-p">
                            <xsl:if test="$ref-component-status/@status">
                                <xsl:attribute name="class">name-p <xsl:value-of select="$ref-component-status/@status"/> <xsl:if test="$ref-component-status/@only-modified-annotation = 'true'"><xsl:text> only-annotation</xsl:text></xsl:if><xsl:if test="$component/@moved-namespaces = 'true'"><xsl:text> moved</xsl:text></xsl:if></xsl:attribute>
                                <xsl:if test="$ref-component-status/@status != 'unchanged'">
                                    <xsl:attribute name="title">
                                        <xsl:value-of select="$ref-component-status/@status"/>
                                        <xsl:if test="$ref-component-status/@only-modified-annotation = 'true'">
                                            <xsl:text> (annotation changes only)</xsl:text>
                                        </xsl:if>
                                    </xsl:attribute>
                                </xsl:if>
                            </xsl:if>
                            <xsl:choose>
                                <xsl:when test="$ns[(parent::node()/@std != 'external')] and doc-available(concat($reportInDir, '/', $ns, '/', $referencing-component, '.xsd'))">
                                    <a href="{concat($reportInDir,'/',$ns,'/',$referencing-component,'.xsd')}" target="_blank">
                                        <xsl:value-of select="regex-group(0)"/>
                                    </a>
                                </xsl:when>
                                <xsl:when test="$ns[(parent::node()/@std != 'external')] and doc-available(concat($reportInDir, '/', $ns, '/Document/', $referencing-component, '_', $st96Version, '.xsd'))"> <a href="{concat($reportInDir,'/',$ns,'/Document/',$referencing-component,'_',$st96Version,'.xsd')}" target="_blank"> <xsl:value-of select="regex-group(0)"/> </a> [Document] </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="regex-group(0)"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </span>
                    </xsl:matching-substring>
                    <xsl:non-matching-substring>
                        <xsl:value-of select="current()"/>
                    </xsl:non-matching-substring>
                </xsl:analyze-string>
            </td>
        </tr>
    </xsl:template>
</xsl:stylesheet>