<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fnx="http://www.example.com/fnx" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
   <xsl:import href="common_style.xsl"/>
   <xsl:import href="retrieve_component_status.xsl"/>
   
   <!-- generate Component Name Report
         include comparison status if reference schemas were provided
   -->
   <xsl:template match="/">
      <html xmlns="http://www.w3.org/1999/xhtml">
         <head>
            <title>Component Name Report</title>
            <xsl:sequence select="fnx:include-css()"/>
            <style>.top{background-color:white;}p.modified:after{content:"\00A0Mod";font-size:xx-small;vertical-align:top;}p.modified.only-annotation:after{content:"\00A0Mod Annot"}p.new:after{content:"\00A0New";font-size:xx-small;vertical-align:top;}p.new.moved:after{content:"\00A0New (Moved)";font-size:xx-small;vertical-align:top;}p.deleted:after{content:"\00A0""Del";font-size:xx-small;vertical-align:top;}p.deleted.moved:after{content:"\00A0""Del (Moved)";font-size:xx-small;vertical-align:top;}p.deleted a{background-color:lightgrey;color:black;}</style>
            <script type="text/javascript">
                     <xsl:text disable-output-escaping="yes">
document.addEventListener('DOMContentLoaded', function () {
     document.getElementById("modified-checkbox").addEventListener("change", function (changeType) {toggle("modified");});
    document.getElementById("new-checkbox").addEventListener("change", function (changeType) {toggle("new");});
    document.getElementById("deleted-checkbox").addEventListener("change", function (changeType) {toggle("deleted");});
    document.getElementById("unchanged-checkbox").addEventListener("change", function (changeType) {toggle("unchanged");});
});

function toggle(changeType){
    var components = document.querySelectorAll(".name-p."+changeType);
        if (document.getElementById(changeType+"-checkbox").checked) {
            // Checkbox is checked..
            components.forEach(function (i) {
                i.style.display = "block";
            });
        } else {
            // Checkbox is not checked..
            components.forEach(function (i) {
                i.style.display = "none";
            });
        }
}
</xsl:text>
                </script>
         </head>
         <body><a style="position: fixed; bottom:5px;right:5px;" href="#" title="Click to go to top">Go to top</a>
            <h1 align="center">Component Name Report</h1>
            <xsl:sequence select="fnx:time-run()"/>
            <hr/>
            <div><p>See also:  [<a href="summary.html" target="_blank">ST.96 Conformance Checking Report</a>], [<a href="integritycheck.html" target="_blank">Schema Integrity Check Report</a>], and [<a href="referencedcomponents.html" target="_blank">Referenced Component Lookup</a>]</p></div>
            <xsl:if test="$previousSchemaComponentsFound">
               <h3>Show: <span> <input type="checkbox" id="modified-checkbox" checked="checked" /><label for="modified-checkbox">Modified</label> </span><span> <input type="checkbox" id="new-checkbox" checked="checked" /><label for="new-checkbox">New</label></span><span> <input type="checkbox" id="deleted-checkbox" checked="checked" /><label for="deleted-checkbox">Deleted</label></span><span> <input type="checkbox" id="unchanged-checkbox" checked="checked" /><label for="unchanged-checkbox">Unchanged</label></span></h3>
            </xsl:if>
            <xsl:sequence select="fnx:input()"/>
            <xsl:if test="$previousSchemaInputDir">
               <p class="header">
            <b>Reference XSDs (for comparison): </b>  <xsl:value-of select="$previousSchemaInputDir"/>  </p>
            </xsl:if>
           
            <p class="name-p">
               <xsl:for-each-group select="$input-collection" group-by="@namespace">
                  <xsl:sort select="(number(matches(current-grouping-key() , 'common','i')) * 10) + (number(matches(current-grouping-key() , 'patent','i')) * 9) + (number(matches(current-grouping-key() , 'trademark','i')) * 8) + (number(matches(current-grouping-key() , 'design','i')) * 7) + (number(matches(current-grouping-key() , 'geographical','i')) * 6) " data-type="number" order="descending"/><!-- TO DO: combine with below to improve performance... -->
                  <xsl:text> [</xsl:text>
                  <a href="#N{position()}">
                     <xsl:value-of select="fnx:ns-display-name(current-grouping-key())"/>
                  </a>
                  <xsl:text>] &#160; </xsl:text>
               </xsl:for-each-group>
            </p>
            <xsl:for-each-group select="$input-collection" group-by="@namespace">
               <xsl:sort select="(number(matches(current-grouping-key() , 'common','i')) * 10) + (number(matches(current-grouping-key() , 'patent','i')) * 9) + (number(matches(current-grouping-key() , 'trademark','i')) * 8) + (number(matches(current-grouping-key() , 'design','i')) * 7) + (number(matches(current-grouping-key() , 'geographical','i')) * 6) " data-type="number" order="descending"/>
               <xsl:variable name="namespace" select="fnx:ns-display-name(current-grouping-key())"/>
               <h2 id="N{position()}">
                  <xsl:value-of select="$namespace"/>
                  <xsl:text> Components [</xsl:text><xsl:value-of select="count(current-group())"/><xsl:text>]</xsl:text><!-- this is actually a count of files?? check for flattened -->
               </h2>
               <xsl:if test="$previousSchemaComponentsFound">
                  <xsl:variable name="modifiedInNamespace" select="key('component-by-status-and-namespace',concat('modified',tokenize(current-grouping-key(),'[/:]')[last()]),$components)"/>
                  <xsl:variable name="newInNamespace" select="key('component-by-status-and-namespace',concat('new',tokenize(current-grouping-key(),'[/:]')[last()]),$components)"/>
                  <xsl:variable name="deletedInNamespace" select="key('component-by-status-and-namespace',concat('deleted',tokenize(current-grouping-key(),'[/:]')[last()]),$components)"/>
                  <xsl:variable name="unchangedInNamespace" select="key('component-by-status-and-namespace',concat('unchanged',tokenize(current-grouping-key(),'[/:]')[last()]),$components)"/>
                  <h4>
                     <xsl:if test="$modifiedInNamespace">
                        <xsl:value-of select="concat(' Modified: ',count($modifiedInNamespace))"/><br></br>
                     </xsl:if>
                     <xsl:if test="$newInNamespace">
                        <xsl:value-of select="concat(' New: ',count($newInNamespace))"/> (Moved: <xsl:value-of select="count($newInNamespace[@moved-namespaces ='true'])"/>)<br></br>
                     </xsl:if>
                     <xsl:if test="$deletedInNamespace">
                        <xsl:value-of select="concat(' Deleted: ',count($deletedInNamespace))"/> (Moved: <xsl:value-of select="count($deletedInNamespace[@moved-namespaces='true'])"/>)<br></br>
                     </xsl:if>
                     <xsl:value-of select="concat(' Unchanged: ',count($unchangedInNamespace))"/>
                  </h4>
               </xsl:if>
               <table>
                  <tr>
                     <xsl:sequence select="fnx:display-section('Elements',(current-group()/element,$components/components/component[@status='deleted'][@namespace=$namespace][@type = 'element']))"/>
                     <xsl:sequence select="fnx:display-section('Complex Types',(current-group()/complexType,$components/components/component[@status='deleted'][@namespace=$namespace][@type = 'complexType']))"/>
                     <xsl:sequence select="fnx:display-section('Simple Types',(current-group()/simpleType,$components/components/component[@status='deleted'][@namespace=$namespace][@type = 'simpleType']))"/>
                     <xsl:sequence select="fnx:display-section('Attributes',(current-group()/attribute,$components/components/component[@status='deleted'][@namespace=$namespace][@type = 'attribute']))"/>
                  </tr>
               </table>
            </xsl:for-each-group>
         </body>
      </html>
   </xsl:template>
   
   <xsl:function name="fnx:display-section"><!-- override imported -->
      <xsl:param name="title"/>
      <xsl:param name="definitions"/>
      <td class="{$definitions[local-name() != 'component'][1]/local-name()}">
         <p class="name-header">
            <i>
               <xsl:value-of select="$title"/>
            </i>
            [<xsl:value-of select="count(distinct-values($definitions/@name))"/>]
         </p>
         <xsl:for-each-group select="$definitions" group-by="@name">
            <xsl:sort select="@name"/>
            <xsl:sort select="(number(matches(../@file,concat('^',../@namespace,'_'))) * 1) + (number(not(matches(../@file,concat('^',../@namespace,'_')))) * 2)" data-type="number"/>
            <p class="name-p">
               <xsl:choose>
                  <xsl:when test="local-name() != 'component'">
                     <xsl:variable name="component" select="if ($previousSchemaComponentsFound) then key('component-by-name-and-namespace',concat(@name, tokenize(current-group()[1]/parent::node()/@namespace, '[/:]')[last()]),$components) else ()"/>
                     <xsl:if test="$component/@status">
                        <xsl:attribute name="class">name-p <xsl:value-of select="$component/@status"/> <xsl:if test="$component/@only-modified-annotation = 'true'"><xsl:text> only-annotation</xsl:text></xsl:if><xsl:if test="$component/@moved-namespaces = 'true'"><xsl:text> moved</xsl:text></xsl:if></xsl:attribute>
                        <xsl:if test="$component/@status != 'unchanged'">
                           <xsl:attribute name="title">
                              <xsl:value-of select="$component/@status"/>
                              <xsl:if test="$component/@only-modified-annotation = 'true'">
                                 <xsl:text> (annotation changes only)</xsl:text>
                              </xsl:if>
                              <xsl:if test="$component/@moved-namespaces = 'true'">
                                 <xsl:text> (moved)</xsl:text>
                              </xsl:if>
                           </xsl:attribute>
                        </xsl:if>
                     </xsl:if>
                     <a href="{../@file}" target="_blank">
                        <xsl:value-of select="@name"/>
                     </a>
                     <xsl:if test="matches($component/@uri,'\WDocument\W[^/\\]+.xsd')">
                        [Document]
                     </xsl:if>
                  </xsl:when>
                  <xsl:otherwise><!-- link to deleted component -->
                     <xsl:attribute name="class">name-p <xsl:value-of select="current-group()[1]/@status"/><xsl:if test="current-group()[1]/@moved-namespaces = 'true'"> moved</xsl:if></xsl:attribute>
                     <xsl:attribute name="title">
                        <xsl:value-of select="current-group()[1]/@status"/>
                        <xsl:if test="current-group()[1]/@moved-namespaces = 'true'"> (Moved)</xsl:if>
                     </xsl:attribute>
                      <a href="{current-group()[1]/@uri}" target="_blank">
                        <xsl:value-of select="@name"/>
                     </a>
                     <xsl:if test="matches(current()/@uri,'\WDocument\W[^/\\]+.xsd')"> [Document] </xsl:if>
                  </xsl:otherwise>
               </xsl:choose>
            </p>
         </xsl:for-each-group>
      </td>
   </xsl:function>
</xsl:stylesheet>
