<?xml version="1.0" encoding="UTF-8"?>
<!--
    Check schema integrity
     - unused imports/includes
     - unresolveable imports/includes
     - unused namespaces
     - orphan components
     - duplication of common components
     - spellcheck results (with suggestions) (currently excludes spell check of enumeration documentation) 
     
     Run on each schemaFile
     
     
     *** NEED TO DO: reorg so that instead of custom elements describing problem (because any updates here require updates to the integritycheck_style.xsl), have single element type which describes the following:
      <th class=" dir-d ">Namespace</th>
                     <th>File</th>
                     <th>Error Type</th>
                     <th>Details</th>
-->

<!-- for includes, must exactly match (case) the components referenced -->

<!-- ** NEED TO DO: update for flattened schemas... -->

<xsl:stylesheet version="2.0" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dty="http://www.datypic.com" xmlns:fnx="http://www.example.com/fnx" exclude-result-prefixes="xsd xsl dty fnx">
   <xsl:import href="wipo_xsd.xsl"/><!-- need in order to reuse splitCamelCase function -->
   
   <xsl:output encoding="UTF-8" method="xml" indent="yes"/>
   <xsl:strip-space elements="*"/>

   <xsl:param name="reportInDir"/><!-- schema input directory -->
   <xsl:param name="spellcheckResultsFile"/>
   <xsl:param name="spellcheckAnnotationResultsFile"/>
   <xsl:param name="schemaFiles"/><!-- does not have file protocol -->
   
   <xsl:variable name="misspelled-words" select="if (doc-available($spellcheckResultsFile)) then doc($spellcheckResultsFile) else ()"/>
   <xsl:variable name="misspelled-descriptions" select="if (doc-available($spellcheckAnnotationResultsFile)) then doc($spellcheckAnnotationResultsFile) else ()"/>
   <xsl:variable name="misspelled-words-in-descriptions" select="$misspelled-descriptions/*/entry/@word"/>
   <xsl:key name="misspelled-by-word" match="entry" use="@word"/>
   <xsl:key name="enumeration-by-description" match="xsd:enumeration" use="xsd:annotation/xsd:documentation/normalize-space(.)"/>
   <xsl:key name="component-in-appinfo" match="xsd:schema/xsd:annotation/xsd:appinfo" use="*/name()"/>
   
   <xsl:param name="approvedAcronyms" select="
         (if (doc-available('../AcronymsAndAbbreviations.xml')) then
            (doc('../AcronymsAndAbbreviations.xml'))
         else
            (),
         if (doc-available('../AcronymsAndAbbreviationsLocal.xml')) then
            (doc('../AcronymsAndAbbreviationsLocal.xml'))
         else
            ())"/>
   
   <xsl:template match="/"><!-- need this to ensure this stylesheet first -->
      <xsl:if test="doc-available($misspelled-words) eq false() and doc-available($misspelled-descriptions) eq false()">
         <xsl:message>No spell check results found.</xsl:message>
      </xsl:if>
      <xsl:apply-templates/>
   </xsl:template>

   <xsl:template match="xsd:schema">
      <xsl:variable name="integrity-info" select="doc('../integritycheck/refs.configxml')/names"/>
      <!-- <names>
   <ref name="string" ns="http://www.w3.org/2001/XMLSchema"/>
   <ref name="NameType"
        ns="http://www.wipo.int/standards/XMLSchema/ST96/Common"/>
   <ref name="AdditionalRemarkType"
        ns="http://www.wipo.int/standards/XMLSchema/ST96/Common"/>
   <ref name="P" ns="http://www.wipo.int/standards/XMLSchema/ST96/Common"/>
   <ref name="languageCode"
        ns="http://www.wipo.int/standards/XMLSchema/ST96/Common"/>
   <ref name="AddressLineCategoryType"
        ns="http://www.wipo.int/standards/XMLSchema/ST96/Common"/>
      -->
      <xsl:variable name="nsUsedPrefixesElements" select="//*/substring-before(name(),':')" as="xsd:string*"/>
      <xsl:variable name="nsUsedPrefixesAttrs" select="//(@type|@ref|@itemType|@refer|@base)/substring-before(., ':')" as="xsd:string*"/>
      <xsl:variable name="nsUsedPrefixesMemberTypes" select="
            for $val in //@memberTypes/tokenize(.,'\s+')
            return
               substring-before($val, ':')" as="xsd:string*"/>
      <xsl:variable name="nsUsedPrefixes" select="distinct-values(($nsUsedPrefixesElements, $nsUsedPrefixesAttrs, $nsUsedPrefixesMemberTypes))"/>
      <xsl:variable name="tns" select="/xsd:schema/@targetNamespace"/>
      <xsl:variable name="nsUnusedPrefixes" as="xsd:string*">
         <xsl:for-each select="/xsd:schema/namespace::*">
            <xsl:variable name="nsPrefix" select="name()"/>
            <xsl:variable name="nsURI" select="."/>
            <xsl:if test="$nsPrefix != 'xml' and $nsURI != $tns and empty(index-of($nsUsedPrefixes, $nsPrefix))">
               <xsl:value-of select="$nsPrefix"/>
            </xsl:if>
         </xsl:for-each>
      </xsl:variable>
      <xsl:variable name="UsedNamesAttrs" select="//(@type|@ref|@itemType|@refer|@base)/dty:resolve-name-in-attr(.)" as="xsd:QName*"/>
      <xsl:variable name="UsedNamesMemberTypes" as="xsd:QName*">
         <xsl:for-each select="//@memberTypes">
            <xsl:variable name="el" select=".."/>
            <xsl:for-each select="tokenize(.,'\s+')">
               <xsl:sequence select="resolve-QName(.,$el)"/>
            </xsl:for-each>
         </xsl:for-each>
      </xsl:variable>
      <xsl:variable name="UsedNames" select="distinct-values(($UsedNamesAttrs, $UsedNamesMemberTypes))" as="xsd:QName*"/>
      <xsl:variable name="names-one-level-down" select="dty:names-one-level-down(.)" as="xsd:QName*"/><!-- check: why languageCode not included -->
      <xsl:variable name="NamesNotCoveredDirectly" select="$UsedNames[not(namespace-uri-from-QName(.) = 'http://www.w3.org/2001/XMLSchema')][not(. = $names-one-level-down)]" as="xsd:QName*"/>
      <xsl:variable name="isFlattened" select="boolean(count(/xsd:schema/*[@name]) > 1)"/><!-- TO DO: use this to adjust integrity check rules if flattened schemas are run... -->
      
      
      <integrity-info file="{base-uri()}" namespace="{@targetNamespace}">
         <xsl:if test="count($nsUnusedPrefixes) > 0">
            <unused-prefixes prefixes="{$nsUnusedPrefixes}"/>
         </xsl:if>
         <!-- get the names used one level deep.  if they are all accounted for, any imported file that doesn't have any names 
           is unnecessary.  This eliminates the performance issue associated with unnecessary imports of huge 
           schemas like PhraseType -->
         <xsl:if test="exists($NamesNotCoveredDirectly)">
            <missing-import names="{string-join(for $n in $NamesNotCoveredDirectly return string($n),', ')}" namespace="{@targetNamespace}"/>
         </xsl:if>
         <xsl:for-each-group select="xsd:import|xsd:include" group-by="@schemaLocation">
            <xsl:if test="count(current-group()) gt 1">
               <duplicate-import-include referenced-file="{current-grouping-key()}"/>
            </xsl:if>
         </xsl:for-each-group>
         
         <xsl:apply-templates select="xsd:import|xsd:include">
            <xsl:with-param name="UsedNames" select="$UsedNames"/>
            <xsl:with-param name="NamesNotCoveredDirectly" select="$NamesNotCoveredDirectly"/>
         </xsl:apply-templates>
         <xsl:apply-templates select="xsd:include" mode="check-schemaLocation">
            <xsl:with-param name="tns" select="@targetNamespace"/>
         </xsl:apply-templates>
         <xsl:if test="not(contains(base-uri(),'/Document/'))"><!-- if not Document schema -->
            <xsl:apply-templates select="xsd:element|xsd:attribute|xsd:complexType|xsd:simpleType" mode="orphan">
               <xsl:with-param name="tns" select="@targetNamespace"/>
               <xsl:with-param name="integrity-info" select="$integrity-info"/>
            </xsl:apply-templates>
            
            <xsl:apply-templates select="xsd:simpleType[xsd:restriction[xsd:enumeration]]" mode="dup-enumeration">               <xsl:with-param name="tns" select="@targetNamespace"/>
               <xsl:with-param name="integrity-info" select="$integrity-info"/>
            </xsl:apply-templates>

            <xsl:apply-templates select="xsd:simpleType[xsd:restriction[xsd:enumeration]]" mode="dup-enumeration-description">
               <xsl:with-param name="tns" select="@targetNamespace"/>
               <xsl:with-param name="integrity-info" select="$integrity-info"/>
            </xsl:apply-templates>
            
            <xsl:apply-templates select="*[ends-with(local-name(), 'Type') or local-name() eq 'element' or local-name() eq 'attribute'][local-name() ne 'complexType'][not(@*:type or (local-name() eq 'simpleType' and (*:restriction/@*:base or *:union/@*:memberTypes)))]" mode="missing-datatype">
               
               <xsl:with-param name="tns" select="@targetNamespace"/>
               <xsl:with-param name="integrity-info" select="$integrity-info"/>
            </xsl:apply-templates>
            
            <xsl:apply-templates select="xsd:element[@type]|xsd:complexType[*:attribute[@ref='com:st96Version'] and *:attribute[@ref='com:ipoVersion']]" mode="possible-document-schema">
               <xsl:with-param name="tns" select="@targetNamespace"/>
               <xsl:with-param name="integrity-info" select="$integrity-info"/>
            </xsl:apply-templates>
         </xsl:if>
         <xsl:apply-templates select="xsd:element | xsd:attribute | xsd:complexType | xsd:simpleType" mode="misspelled-names">
            <xsl:with-param name="tns" select="@targetNamespace"/>
            <xsl:with-param name="integrity-info" select="$integrity-info"/>
         </xsl:apply-templates>
         <xsl:apply-templates select="xsd:simpleType[xsd:restriction[xsd:enumeration]][not(matches(base-uri(), '(/ISO|/.*ST3CodeType.xsd)'))]" mode="misspelled-enumeration">
            <!-- spelling was not checked for ISO or ST3 codes -->
            
            <xsl:with-param name="tns" select="@targetNamespace"/>
            <xsl:with-param name="integrity-info" select="$integrity-info"/>
         </xsl:apply-templates>
         
         <xsl:apply-templates select="*[@name][xsd:annotation[1]/xsd:documentation[1]]" mode="misspelled-description"><!-- not including documentation for enumeration values *[descendant::xsd:annotation[1]/xsd:documentation[1]]-->
            <xsl:with-param name="tns" select="@targetNamespace" tunnel="yes"/>
            <xsl:with-param name="integrity-info" select="$integrity-info" tunnel="yes"/>
         </xsl:apply-templates>
         <xsl:apply-templates select="*[@name]/xsd:restriction/xsd:enumeration[xsd:annotation[1]/xsd:documentation[1]]" mode="misspelled-description"><!-- including documentation for enumeration values -->
            <xsl:with-param name="tns" select="@targetNamespace" tunnel="yes"/>
            <xsl:with-param name="integrity-info" select="$integrity-info" tunnel="yes"/>
         </xsl:apply-templates>


         <xsl:if test="not(@targetNamespace = ($kCommonNamespace,$kIPOCommonNamespace))">
            <xsl:apply-templates select="xsd:element|xsd:attribute|xsd:complexType|xsd:simpleType" mode="dup-common">
               <xsl:with-param name="tns" select="@targetNamespace"/>
               <xsl:with-param name="integrity-info" select="$integrity-info"/>
            </xsl:apply-templates>
         </xsl:if>
         
         <xsl:apply-templates select="xsd:complexType[xsd:complexContent/xsd:extension[@base]]" mode="duplicate-in-extension">
            <xsl:with-param name="tns" select="@targetNamespace" />
         </xsl:apply-templates>
         
         <xsl:apply-templates select="*[@name][descendant::*[@ref][xsd:annotation[1]/xsd:documentation[1]][1]]" mode="description-in-referenced-component">
            <xsl:with-param name="tns" select="@targetNamespace"/>
            <xsl:with-param name="integrity-info" select="$integrity-info" />
         </xsl:apply-templates>
         
         <xsl:apply-templates select="xsd:simpleType[@name = ('WIPOST3CodeType' )]" mode="bad-acronym">
            <xsl:with-param name="tns" select="@targetNamespace"/>
            <xsl:with-param name="integrity-info" select="$integrity-info"/>
         </xsl:apply-templates>
         
          <xsl:apply-templates select="xsd:complexType[descendant::*[(self::xsd:choice or self::xsd:sequence)][1]]" mode="unnecessary-nested-structure">
            <xsl:with-param name="tns" select="@targetNamespace" tunnel="yes"/>
            <xsl:with-param name="integrity-info" select="$integrity-info" tunnel="yes"/>
         </xsl:apply-templates>
         
         <xsl:apply-templates select="xsd:complexType[not(@mixed='true')][descendant::xsd:element[@ref][1]]" mode="improper-nesting">
            <xsl:with-param name="tns" select="@targetNamespace" />
            <xsl:with-param name="integrity-info" select="$integrity-info" />
         </xsl:apply-templates>
         
      </integrity-info>
   </xsl:template>
   
   <xsl:template match="xsd:simpleType" mode="bad-acronym">
      <xsl:param name="tns"/>
      <xsl:param name="integrity-info"/>
      <xsl:variable name="component-name" select="@name"/>
      
      <xsl:for-each select="xsd:restriction/xsd:enumeration/@value[. = ($approvedAcronyms/AAs/AA/short[not(. = ('AF','GI','IB','ID','LI'))])]">
         <bad-acronym type="complexType" name="{$component-name}" namespace="{$tns}" acronym="{.}" acronym-description="{$approvedAcronyms/AAs/AA[short = current()]/long}"/>
      </xsl:for-each>
      <!-- check against acronym list -->
   </xsl:template>
   
   
   
   <xsl:template match="xsd:import|xsd:include">
      <xsl:param name="UsedNames"/>
      <xsl:param name="NamesNotCoveredDirectly"/>
      <xsl:variable name="ImportedFile" select="resolve-uri(@schemaLocation,document-uri(/))"/>
      <!--<xsl:message select="$ImportedFile"/>-->
      <xsl:choose>
         <xsl:when test="doc-available($ImportedFile)">
            <xsl:variable name="imported" select="doc($ImportedFile)"/>
            <xsl:variable name="DefinedNames" select="dty:names-in-schema($imported)"/>
            <xsl:variable name="filepath" select="replace($ImportedFile, '/[^/]+\.xsd', '/', 'i')"/>
            
            <xsl:if test="not(contains($ImportedFile, '/ExternalStandards/'))">
               <xsl:variable name="imported-filename" select="substring-after(replace($ImportedFile,'%20',' '), $reportInDir)"/>
               <xsl:if test="empty(index-of(tokenize($schemaFiles, ';'), $imported-filename))">
                  <included-file-different-case element="{local-name(.)}" included-file="{@schemaLocation}" namespace="{parent::node()/@targetNamespace}" schema-file="{tokenize(tokenize($schemaFiles,';')[lower-case(.) = lower-case($imported-filename)],'/')[last()]}"/>
               </xsl:if>
            </xsl:if>

            <xsl:if test="not($DefinedNames = $UsedNames)">
               <xsl:choose>
                  <xsl:when test="empty($NamesNotCoveredDirectly)">
                     <!-- no need to go recursively checking in this import because all names are accounted for
                          in other imports - saves a lot of time -->
                     <import-unused element="{local-name(.)}" imported-file="{@schemaLocation}" namespace="{parent::node()/@targetNamespace}"/>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:variable name="used-recursive" select="dty:name-used-recursive($imported, $ImportedFile, $UsedNames)"/>
                     <xsl:choose>
                        <xsl:when test="exists($used-recursive)">
                           <import-unused-directly element="{local-name(.)}" imported-file="{@schemaLocation}" namespace="{parent::node()/@targetNamespace}"/>
                        </xsl:when>
                        <xsl:otherwise>
                           <import-unused element="{local-name(.)}" imported-file="{@schemaLocation}" namespace="{parent::node()/@targetNamespace}"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:if>
         </xsl:when>
         <xsl:otherwise>
            <import-file-not-found element="{local-name(.)}" imported-file="{@schemaLocation}" namespace="{parent::node()/@targetNamespace}"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="text()"/>
   <xsl:template match="xsd:include" mode="check-schemaLocation">
      <xsl:param name="tns"/>
      <xsl:if test="matches(@schemaLocation,'[/\\][^\.]+[/\\]')">
         <include-path-not-local element="{local-name(.)}" include-file="{@schemaLocation}" namespace="{$tns}"/>
      </xsl:if>
   </xsl:template>
   
   <xsl:template match="xsd:complexType|xsd:complexType[xsd:complexContent/xsd:extension[(xsd:sequence|xsd:choice)]]" mode="min-elements" priority="0.5"/>
   
   <xsl:template match="xsd:complexType[xsd:complexContent/xsd:extension[(xsd:sequence|xsd:choice)]]" mode="min-elements">
      <!-- check extension only after check the component that it is extending...not sure if this works -->
      <!--<xsd:complexType name="DocumentIncludedType">
		<xsd:complexContent>
			<xsd:extension base="com:DocumentType">
				<xsd:sequence>
					<xsd:element ref="com:IPOfficeCodeBag" minOccurs="0"/>
				</xsd:sequence>
			</xsd:extension>
		</xsd:complexContent>
	</xsd:complexType>-->
      <xsl:param name="integrity-info"/>
      <xsl:param name="tns"/>
      <xsl:param name="base-complexType"/>
      <xsl:if test="(not(@mixed='true') and xsd:complexContent/xsd:extension/(xsd:choice|xsd:sequence)[(@minOccurs='0')]) or (xsd:complexContent/xsd:extension/(xsd:choice|xsd:sequence)[not(@minOccurs='0') and not (some $x in child::*[name() !='xsd:attribute'] satisfies $x[not(@minOccurs='0')])])">
         <xsl:if test="($base-complexType/min-elements/@name) = local-name(xsd:complexContent/xsd:extension/@base) and (namespace-uri-from-QName(resolve-QName(xsd:complexContent/xsd:extension/@base,.)) = $tns)">
            <min-elements type="{local-name(.)}" name="{@name}" namespace="{$tns}"/>
         </xsl:if>
            
      </xsl:if>
   </xsl:template>
   
   <xsl:template match="xsd:complexType[(xsd:choice|xsd:sequence)[not(@minOccurs='0') and not (some $x in child::*[name() !='xsd:attribute'] satisfies $x[not(@minOccurs='0')])]] | xsd:complexType[xsd:complexContent/xsd:restriction/(xsd:choice|xsd:sequence)[not(@minOccurs='0') and not (some $x in child::*[name() !='xsd:attribute'] satisfies $x[not(@minOccurs='0')])]]" mode="min-elements" priority="10">
      <!--  For data exchange, at least, one element should be mandatory.  --><!-- moved to SD-50 -->
      <xsl:param name="integrity-info"/>
      <xsl:param name="tns"/>
      <min-elements type="{local-name(.)}" name="{@name}" namespace="{$tns}"/>
   </xsl:template>
   
   <xsl:template match="xsd:complexType[not(@mixed='true') and (xsd:choice|xsd:sequence)[(@minOccurs='0')]] | xsd:complexType[not(@mixed='true') and xsd:complexContent/xsd:restriction/(xsd:choice|xsd:sequence)[(@minOccurs='0')]]" mode="min-elements" priority="10">
      <!--  For data exchange, at least, one element should be mandatory.  --><!-- moved to SD-50 -->
      <xsl:param name="integrity-info"/>
      <xsl:param name="tns"/>
      <min-elements type="{local-name(.)}" name="{@name}" namespace="{$tns}"/>
   </xsl:template>
   
   <xsl:template match="xsd:element|xsd:attribute|xsd:complexType|xsd:simpleType" mode="orphan">
      <xsl:param name="integrity-info"/>
      <xsl:param name="tns"/>
      <xsl:if test="not($integrity-info/ref[@name = current()/@name and @ns=$tns]) and empty(collection(concat('file:///', replace($reportInDir, '\\', '/'), '?select=*.xsd&amp;recurse=yes'))[not(contains(base-uri(.),'/ExternalStandards/'))]/key('component-in-appinfo',string-join((current()/namespace::*[. = $tns]/name(),current()/@name),':')))">
         <orphan type="{local-name(.)}" name="{@name}" namespace="{$tns}"/>
      </xsl:if>
   </xsl:template>
   <xsl:template match="xsd:element|xsd:attribute|xsd:complexType|xsd:simpleType" mode="dup-common">
      <xsl:param name="integrity-info"/>
      <xsl:param name="tns"/>
      <xsl:variable name="common-component" select="$integrity-info/common-name[@name = current()/@name]"/>
      <xsl:if test="$common-component">
         <dup-common type="{local-name(.)}" name="{@name}" namespace="{$tns}" common-namespace="{$common-component/@ns}"/>
      </xsl:if>
   </xsl:template>
   <xsl:template match="xsd:simpleType[xsd:restriction[count(distinct-values(xsd:enumeration/@value/lower-case(.))) ne count(xsd:enumeration/@value/lower-case(.))]]" mode="dup-enumeration" priority="2">
      <!-- 2020-06-15 -->
      <xsl:param name="integrity-info"/>
      <xsl:param name="tns"/>
      <dup-enumeration type="{local-name(.)}" name="{@name}" namespace="{$tns}" duplicates="{string-join(xsd:restriction/xsd:enumeration[exists(index-of(following-sibling::*/@*:value/lower-case(.),@*:value/lower-case(.)))]/@value,', ')}"> </dup-enumeration>
   </xsl:template>
   
   <xsl:template match="xsd:simpleType[xsd:restriction[count(distinct-values(xsd:enumeration/xsd:annotation/xsd:documentation/normalize-space(lower-case(.)))) ne count(xsd:enumeration/xsd:annotation/xsd:documentation/normalize-space(lower-case(.)))]]" mode="dup-enumeration-description" priority="2">
      <xsl:param name="integrity-info"/>
      <xsl:param name="tns"/>
      <dup-enumeration-description type="{local-name(.)}" name="{@name}" namespace="{$tns}">
         <xsl:attribute name="duplicates">
            <xsl:for-each-group select="xsd:restriction/xsd:enumeration[count(key('enumeration-by-description', xsd:annotation/xsd:documentation/normalize-space(.), parent::xsd:restriction)) gt 1]" group-by="normalize-space(xsd:annotation/xsd:documentation)">
               <xsl:if test="position() != 1"><xsl:text>|</xsl:text></xsl:if>
               <xsl:for-each select="current-group()">
                  <xsl:text>|</xsl:text>
                  <xsl:value-of select="concat(current()/@value, ': &quot;', current()/xsd:annotation/xsd:documentation, '&quot;')"/>
               </xsl:for-each>
            </xsl:for-each-group>
         </xsl:attribute>
      </dup-enumeration-description>
   </xsl:template>
   
   <xsl:template match="xsd:simpleType" priority="1" mode="dup-enumeration"/>
   <xsl:template match="xsd:simpleType" priority="1" mode="dup-enumeration-description"/>
   
   
   <xsl:template match="*[ends-with(local-name(), 'Type') or local-name() eq 'element' or local-name() eq 'attribute'][local-name() ne 'complexType'][not(@*:type or (local-name() eq 'simpleType' and (*:restriction/@*:base or *:union/@*:memberTypes)))]" mode="missing-datatype">
      <xsl:param name="integrity-info"/>
      <xsl:param name="tns"/>
      <!--<item namespace="{$tns}" category="Missing explicit data type" name="{@name}" type="{local-name(.)}">
         <xsl:value-of select="concat('The ',@type)"/>
      </item>-->
      <missing-explicit-datatype type="{local-name(.)}" name="{@name}" namespace="{$tns}"/>
   </xsl:template>
   
   
   <xsl:template match="xsd:element|xsd:attribute|xsd:complexType|xsd:simpleType" mode="misspelled-description">
      <xsl:apply-templates mode="#current"/>
   </xsl:template>
   
   <xsl:template match="xsd:annotation" mode="misspelled-description"></xsl:template>
   
   <xsl:template match="*[matches(xsd:annotation[1]/xsd:documentation[1],concat('(^|[^a-zA-Z\-])',replace(string-join($misspelled-words-in-descriptions,'|'),'([\.\(\)\[\]\*\+\?\$\^])','\\$1'),'($|[^a-zA-Z\-])'))]" mode="misspelled-description" priority="10"><!-- ** NEED TO DO: if misspelled words can't be located... -->
      <xsl:param name="tns" tunnel="yes"/>
      <xsl:param name="integrity-info" />
      <!--<xsl:message>
         misspelling in description of <xsl:value-of select="@name"/> (<xsl:value-of select="string-join($misspelled-words-in-descriptions,'|')"/>)
      </xsl:message>-->
      <xsl:variable name="misspelled">
         <misspelled-description type="{local-name(.)}" name="{@name}" namespace="{$tns}">
            <xsl:if test="self::xsd:enumeration">
               <xsl:attribute name="name">
                  <xsl:value-of select="ancestor::*[@name][1]/@name"/>
               </xsl:attribute>
               <xsl:attribute name="enumeration-value">
                  <xsl:value-of select="@value"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:analyze-string select="xsd:annotation/xsd:documentation" regex="(^|[^a-zA-Z\-])({replace(string-join($misspelled-words-in-descriptions,'|'),'([\.\(\)\[\]\*\+\?\$\^])','\\$1')})($|[^a-zA-Z\-])">
               <xsl:matching-substring>
                  <xsl:value-of select="regex-group(1)"/>
                  <span class="misspelled">
                     <xsl:attribute name="data-suggestion"><xsl:value-of select="$misspelled-descriptions/key('misspelled-by-word',regex-group(2))/@suggestions"/></xsl:attribute>
                     <xsl:value-of select="regex-group(2)"/>
                  </span>
                  <xsl:value-of select="regex-group(3)"/>
               </xsl:matching-substring>
               <xsl:non-matching-substring>
                  <xsl:value-of select="current()"/>
               </xsl:non-matching-substring>
            </xsl:analyze-string>
         </misspelled-description>
      </xsl:variable>
      <xsl:if test="$misspelled/*/span">
         <xsl:copy-of select="$misspelled"/>
      </xsl:if>
   </xsl:template>

   <xsl:template match="xsd:element | xsd:complexType | xsd:simpleType" mode="misspelled-names">
      <xsl:param name="integrity-info"/>
      <xsl:param name="tns"/>
      <xsl:variable name="words" select="fnx:splitCamelCase(@name)" />

      <xsl:variable name="misspelled-components-found" select="for $x in $words[not(matches(.,'^[A-Z][A-Z0-9]+$'))][empty(index-of($approvedAcronyms/AAs/AA/short, .))] return $misspelled-words/key('misspelled-by-word',$x)" /><!-- exclude those caught by GD-14 -->
      
      <xsl:if test="exists($misspelled-components-found)">
      <!--   <xsl:message>misspelled names: <xsl:value-of select="string-join($misspelled-components-found,', ')"/> </xsl:message>
         <xsl:message>retrieve suggestion from <xsl:value-of select="string-join($misspelled-component-names/@suggestion,',')"/>: <xsl:value-of select="string-join($misspelled-component-names[exists(index-of($misspelled-components-found,.))]/@suggestion,'; ')"/></xsl:message>-->
         <misspelled-name type="{local-name(.)}" name="{@name}" namespace="{$tns}" misspelled="{string-join($misspelled-components-found/@word,', ')}" suggestions="{string-join($misspelled-components-found/@suggestions,'; ')}"/>
      </xsl:if>
   </xsl:template>
   
   <xsl:template match="xsd:attribute" mode="misspelled-names">
      <xsl:param name="integrity-info"/>
      <xsl:param name="tns"/>
      <xsl:variable name="words" select="fnx:splitCamelCase(@name)" as="item()+"/>
      <xsl:variable name="approvedacronym-first" select="$words[1][exists(index-of($approvedAcronyms/AAs/AA/short/lower-case(.),.))]"/>
      <xsl:variable name="misspelled-components-found" select="for $x in $words[. ne $approvedacronym-first and not(matches(.,'^[A-Z][A-Z0-9]+$'))] return $misspelled-words/key('misspelled-by-word',$x)" as="item()*"/><!-- exclude those caught by GD-13 -->
     
      <xsl:if test="exists($misspelled-components-found)">
        <!-- <xsl:message>misspelled: <xsl:value-of select="string-join($misspelled-component-names, '| ')"/></xsl:message>
         <xsl:message>retrieve suggestion: <xsl:value-of select="string-join($misspelled-component-names[exists(index-of($misspelled-components-found,.))]/@suggestion,'; ')"/></xsl:message>-->
         <misspelled-name type="{local-name(.)}" name="{@name}" namespace="{$tns}" misspelled="{string-join($misspelled-components-found/@word,', ')}" suggestions="{string-join($misspelled-components-found/@suggestions,'; ')}"/>
      </xsl:if>
   </xsl:template>
   <xsl:template match="xsd:simpleType" mode="misspelled-enumeration"/>
   <xsl:template match="xsd:simpleType[xsd:restriction[xsd:enumeration[matches(@value, '[a-zA-Z][a-z]+')]]]" mode="misspelled-enumeration" priority="10">
      <xsl:param name="integrity-info"/>
      <xsl:param name="tns"/>
      <xsl:variable name="type" select="local-name(.)"/>
      <xsl:variable name="name" select="@name"/>

      <xsl:for-each select="
            *:restriction/*:enumeration/@value[every $x in tokenize(., '\s+')
               satisfies empty(index-of($approvedAcronyms/AAs/AA/short, $x))]">
         <xsl:variable name="words" select="fnx:splitEnumeration(.)"/>
         
         <xsl:message>Enumerations with conversion of underscore (to space) and camelcasing (to space): <xsl:value-of select="string-join($words, ', ')"/></xsl:message>
         <xsl:variable name="misspelled-enumerations-found" select="for $x in $words return $misspelled-words/key('misspelled-by-word',$x)"/>
         
         <xsl:if test="exists($misspelled-enumerations-found)">
           <!-- <xsl:message>misspelled: <xsl:value-of select="string-join($misspelled-enumerations-found, '| ')"/></xsl:message>
            <xsl:message>retrieve suggestion: <xsl:value-of select="string-join($misspelled-enumeration-values[exists(index-of($misspelled-enumerations-found,.))]/@suggestion,'; ')"/></xsl:message>-->
            <misspelled-enumeration type="{$type}" name="{$name}" namespace="{$tns}" misspelled="{string-join($misspelled-enumerations-found/@word,', ')}" suggestions="{string-join($misspelled-enumerations-found/@suggestions,'; ')}" enumeration="{current()}"/>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
   
   <xsl:template match="*[@name][descendant::*[@ref][xsd:annotation[1]/xsd:documentation[1]][1]]" mode="description-in-referenced-component">
      <xsl:param name="integrity-info"/>
      <xsl:param name="tns"/>
      <description-in-referenced-component type="{local-name(.)}" name="{@name}" namespace="{$tns}" annotation-location="{string-join(descendant::*[@ref][xsd:annotation[1]/xsd:documentation[1]]/@ref,', ')}"/>
   </xsl:template> 
   
   <xsl:template match="xsd:element" mode="possible-document-schema">
      <xsl:param name="integrity-info"/>
      <xsl:param name="tns"/>
      <xsl:variable name="included" select="for $x in /xsd:schema/*:include[@schemaLocation]/@schemaLocation return doc(resolve-uri($x,base-uri(.)))"/>
      <xsl:if test="$included/xsd:schema/*:complexType[@name][*:attribute[@ref='com:st96Version'] and *:attribute[@ref='com:ipoVersion']]">
         <possible-document-schema type="{local-name(.)}" name="{@name}" namespace="{$tns}" />
      </xsl:if>
   </xsl:template>
   <xsl:template match="xsd:complexType" mode="possible-document-schema">
      <xsl:param name="integrity-info"/>
      <xsl:param name="tns"/>
      
      <possible-document-schema type="{local-name(.)}" name="{@name}" namespace="{$tns}" />
   </xsl:template>
    <xsl:template match="xsd:complexType[xsd:complexContent/xsd:extension[@base]]" mode="duplicate-in-extension">
       <xsl:param name="tns"/>
       <xsl:variable name="imported-included" select="for $x in /xsd:schema/*[@schemaLocation]/@schemaLocation return doc(resolve-uri($x,base-uri(.)))"/>
       <xsl:variable name="name" select="@name"/>
      <xsl:for-each select="xsd:complexContent/xsd:extension">
         <xsl:variable name="base-component-name" select="substring-after(@base, ':')"/>
         <xsl:variable name="base-namespace-prefix" select="substring-before(@base, ':')"/>
         
         <xsl:variable name="base-components" select="$imported-included/xsd:schema/*[@name = $base-component-name]/descendant::xsd:element[@ref]/@ref"/>
         <xsl:variable name="base-attributes" select="$imported-included/xsd:schema/*[@name = $base-component-name]/*:attribute/@ref"/>
         <xsl:for-each select="*[exists($base-components)]/descendant::xsd:element[@ref[not(matches($base-namespace-prefix, '(com|tbl|mathml)$') and not(starts-with(., concat($base-namespace-prefix, ':'))))]]">
            <!-- check @ref after reconciling namespace prefixes -->

            <xsl:variable name="referenced-component-name" select="@ref"/>
            <!-- Note: if base component is in common or external standards, don't need to check extension components which are NOT in common -->
            <xsl:message>checking <xsl:value-of select="$referenced-component-name"/> against <xsl:value-of select="string-join($base-components, ', ')"/></xsl:message>
            <xsl:if test="$referenced-component-name = ($base-components)">
               <duplicate-component-in-extension name="{$name}" namespace="{$tns}" duplicate="{$referenced-component-name}" base="{ancestor::xsd:extension[1]/@base}"/>
            </xsl:if>
         </xsl:for-each>
         <!-- altova will report on duplicate attributes -->
         
      </xsl:for-each>
      
    </xsl:template>
   
   <xsl:template match="xsd:complexType" mode="unnecessary-nested-structure">
       <xsl:param name="integrity-info"/>
      <xsl:param name="tns"/>
      <xsl:variable name="name" select="@name"/>
      <xsl:variable name="type" select="name()"/>
      <xsl:for-each select=".//(xsd:choice|xsd:sequence)[(not(@minOccurs) or @minOccurs = '1') and (not(@maxOccurs) or @maxOccurs='1')][not(child::*[2])]/(xsd:choice|xsd:sequence)[not(@minOccurs) or @minOccurs = '1'][not(@maxOccurs) or @maxOccurs='1']">
         <unnecessary-nesting type="{$type}" structure="{parent::node()/name(.)}" name="{$name}" namespace="{$tns}"/>
      </xsl:for-each>
   </xsl:template>
   
   <xsl:template match="xsd:complexType[descendant::xsd:element[@ref][1]]" mode="improper-nesting">
      <xsl:param name="integrity-info"/>
      <xsl:param name="tns"/>
      <xsl:variable name="name" select="@name"/>
      <xsl:for-each select="descendant::xsd:element[resolve-QName(@ref,..) = QName($tns,replace($name,'Type$',''))]">
         <!-- assume Type name is identical to element name, if it references itself, that is problematic with the exception of ClaimTextType -->
         <recursive-type type="complexType" name="{$name}" namespace="{$tns}"/>
      </xsl:for-each>
   </xsl:template>
   
   <xsl:function name="dty:resolve-name-in-attr" as="xsd:QName">
      <xsl:param name="prefixed-name" as="attribute()"/>
      <!-- for @ref, @type, @base, etc. -->
      <xsl:sequence select="resolve-QName($prefixed-name,$prefixed-name/parent::*)"/>
   </xsl:function>
   <xsl:function name="dty:schema-name" as="xsd:QName">
      <xsl:param name="unprefixed-name" as="attribute()"/>
      <!-- for @name -->
      <xsl:sequence select="QName($unprefixed-name/ancestor::xsd:schema/@targetNamespace,$unprefixed-name)"/>
   </xsl:function>
   <xsl:function name="dty:names-in-schema" as="xsd:QName*">
      <xsl:param name="doc"/>
      <xsl:sequence select="$doc//@name/dty:schema-name(.)"/>
   </xsl:function>
   <xsl:function name="dty:name-used-recursive" as="xsd:boolean*">
      <xsl:param name="doc"/>
      <xsl:param name="used-uris"/>
      <xsl:param name="used-names"/>
      <xsl:choose>
         <xsl:when test="not($doc/xsd:schema/(xsd:import|xsd:include))">
            <xsl:sequence select="()"/>
         </xsl:when>
         <xsl:when test="$used-names = dty:names-one-level-down($doc)">
            <xsl:sequence select="true()"/>
         </xsl:when>
         <xsl:otherwise>
            <!-- go down one more level -->
            <xsl:for-each select="$doc/xsd:schema/(xsd:import|xsd:include)">
               <xsl:variable name="ImportedFile" select="resolve-uri(@schemaLocation,document-uri($doc))"/>
               <xsl:if test="not($ImportedFile = $used-uris) and doc-available($ImportedFile)">
                  <xsl:variable name="imported" select="doc($ImportedFile)"/>
                  <xsl:sequence select="dty:name-used-recursive($imported, ($used-uris,$ImportedFile),$used-names)"/>
               </xsl:if>
            </xsl:for-each>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:function>
   <xsl:function name="dty:names-one-level-down" as="xsd:QName*">
      <xsl:param name="doc"/>
      <xsl:for-each select="$doc//(xsd:import|xsd:include)">
         <xsl:variable name="ImportedFile" select="resolve-uri(@schemaLocation,document-uri(root($doc)))"/>
         <xsl:if test="doc-available($ImportedFile)">
            <xsl:variable name="imported" select="doc($ImportedFile)"/>
            <xsl:sequence select="dty:names-in-schema($imported)"/>
         </xsl:if>
      </xsl:for-each>
   </xsl:function>
</xsl:stylesheet>
