<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    exclude-result-prefixes="xs"
    version="2.0">
    
    <!-- extract approved acronyms to custom dictionary -->
    <!-- <AAs>
  <AA>
    <short>Alt</short>
    <long>Alternate text for image</long>
  </AA> -->
    
    <xsl:param name="approvedAcronyms" select="(if (doc-available('../AcronymsAndAbbreviations.xml')) then (doc('../AcronymsAndAbbreviations.xml')) else (),if (doc-available('../AcronymsAndAbbreviationsLocal.xml')) then (doc('../AcronymsAndAbbreviationsLocal.xml')) else ())"/>
    
    <xsl:param name="currentCustomWords"/>
    
    <xsl:output method="text" encoding="UTF-8"/>
    
    <xsl:template match="/">
        <xsl:for-each select="$approvedAcronyms/AAs/AA/short">
            <xsl:message>adding approved acronym/abbreviation: <xsl:value-of select="."/></xsl:message>
            <xsl:value-of select="."/>
            <xsl:text>&#13;&#xa;</xsl:text>
        </xsl:for-each>
    </xsl:template>
    
</xsl:stylesheet>