<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dty="http://www.datypic.com" exclude-result-prefixes="xsd xsl dty">
   <xsl:output encoding="UTF-8" method="xml" indent="yes"/>
   <xsl:strip-space elements="*"/>
   <xsl:param name="reportInDir"/>
   <xsl:template match="/">
      <xsl:variable name="schema-collection" select="collection(concat('file:///', replace($reportInDir, '\\', '/'), '?select=*.xsd&amp;recurse=yes'))[not(contains(base-uri(.),'/ExternalStandards/'))]/*"/>
      <xsl:variable name="names" as="xsd:QName*">
         <xsl:sequence select="$schema-collection//(@ref|@type|@base|@itemType)/dty:resolve-name-in-attr(.)"/>
         <xsl:for-each select="$schema-collection//@memberTypes">
            <xsl:variable name="el" select=".."/>
            <xsl:for-each select="tokenize(.,'\s+')">
               <xsl:sequence select="resolve-QName(.,$el)"/>
            </xsl:for-each>
         </xsl:for-each>
      </xsl:variable>
      <xsl:variable name="common-names" as="xsd:QName*">
         <xsl:for-each select="$schema-collection">
            <xsl:if test="@targetNamespace = ('http://www.wipo.int/standards/XMLSchema/ST96/Common','urn:us:gov:doc:uspto:common')">
                <xsl:sequence select="*/@name/dty:schema-name(.)"/>
            </xsl:if>
         </xsl:for-each>     
      </xsl:variable>
       <names>
          <xsl:for-each-group select="$schema-collection/namespace::*" group-by="."><!-- copy namespaces for later retrieval -->
             <xsl:copy-of select="."/>
          </xsl:for-each-group>
          <xsl:attribute name="st96VersionXSDURI" select="($schema-collection/*:attribute[@name eq 'st96Version'][1]/base-uri())[1]"/>
         
          <xsl:for-each-group select="$schema-collection//(@ref|@type|@base|@itemType|@memberTypes)" group-by="tokenize(.)[not(starts-with(.,'xsd:'))]">
             <ref name="{local-name-from-QName(resolve-QName(current-grouping-key(),..))}" ns="{namespace-uri-from-QName(resolve-QName(current-grouping-key(),..))}">
                <xsl:attribute name="used-by">
                   <xsl:variable name="referencing-elements" select="distinct-values(current-group()/ancestor::*[@name][1]/concat(namespace::*[/*/@targetNamespace =  .]/name(),':',@name))"/>
                   <xsl:for-each select="$referencing-elements">
                      <xsl:sort select="substring-after(.,':')"/>
                      <xsl:value-of select="."/>
                      <xsl:if test="position() != last()"><xsl:text> </xsl:text></xsl:if>
                   </xsl:for-each>
                </xsl:attribute>
             </ref>
          </xsl:for-each-group>
        <xsl:for-each select="$common-names">
            <common-name name="{local-name-from-QName(.)}" ns="{namespace-uri-from-QName(.)}"/>
         </xsl:for-each>
      </names>
   </xsl:template>
   <xsl:function name="dty:resolve-name-in-attr" as="xsd:QName">
      <xsl:param name="prefixed-name" as="attribute()"/>
      <!-- for @ref, @type, @base, etc. -->
      <xsl:sequence select="resolve-QName($prefixed-name,$prefixed-name/parent::*)"/>
   </xsl:function>
   <xsl:function name="dty:schema-name" as="xsd:QName">
      <xsl:param name="unprefixed-name" as="attribute()"/>
      <!-- for @name -->
      <xsl:sequence select="QName($unprefixed-name/ancestor::xsd:schema/@targetNamespace,$unprefixed-name)"/>
   </xsl:function>
</xsl:stylesheet>
