<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    exclude-result-prefixes="xs"
    version="3.0">
    
    <!-- SD-05: Schemas SHOULD use elements and types defined in existing schemas to the maximum
extent possible.
    
    For this portion, check if there are any component names shared between Common and the non-Common namespace...
    -->
    <xsl:output encoding="UTF-8" method="xml" indent="yes"/>
    <xsl:strip-space elements="*"/>
    <xsl:param name="reportInDir"/>
    <xsl:import href="wipo_xsd.xsl"/>
    
    <xsl:template match="/"> 
    <xsl:variable name="schema-collection" select="collection(concat('file:///', replace($reportInDir, '\\', '/'), '?select=*.xsd&amp;recurse=yes'))[not(contains(base-uri(.),'/ExternalStandards/'))]"/>
        <duplicate-of-common>
            <xsl:merge>
                <xsl:merge-source name="common-components" select="snapshot($schema-collection/*:schema[@targetNamespace = ($kCommonNamespace,$kIPOCommonNamespace)]/(*:element|*:complexType|*:simpleType)[@name])" sort-before-merge="true">
                    <xsl:merge-key select="@name"/>
                </xsl:merge-source>
                <xsl:merge-source name="ip-components" select="snapshot($schema-collection/*:schema[not(@targetNamespace = ($kCommonNamespace,$kIPOCommonNamespace))]/(*:element|*:complexType|*:simpleType)[@name])" sort-before-merge="true">
                    <xsl:merge-key select="@name"/>
                </xsl:merge-source>
                <xsl:merge-action>
                    <xsl:if test="exists(current-merge-group('common-components')) and exists(current-merge-group('ip-components'))">
                        <!--<xsl:message>found duplicate with common in <xsl:value-of select="string-join(current-merge-group('ip-components')/@name,', ')"/></xsl:message>-->
                        <xsl:for-each-group select="current-merge-group('ip-components')" group-by="parent::node()/@targetNamespace">
                            <xsl:for-each select="current-group()">
                                <component name="{current()/@name}" ns="{tokenize(parent::node()/@targetNamespace,'[/:]')[last()]}" uri="{substring-after(base-uri(),concat(resolve-uri($reportInDir),'/'))}"/>
                            </xsl:for-each>
                        </xsl:for-each-group>
                    </xsl:if>
                </xsl:merge-action>
            </xsl:merge>
            
        </duplicate-of-common>
    </xsl:template>
    
</xsl:stylesheet>
