<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    exclude-result-prefixes="xs"
    version="3.0">
    <!-- for each namespace, check if there are any duplicate models;
        run once prior to launching the schematron (more efficient).
        as a fallback, the schematron can check every time an XSD is validated
    -->
    <xsl:strip-space elements="*"/><!-- ignore superficial whitespace differences in pretty-printed XSDs -->
    <xsl:output indent="yes"/>
    <xsl:import href="wipo_xsd.xsl"/>
    
    <xsl:param name="reportInDir"/>
    
    <xsl:template match="/">
        <duplicate-models>
            <xsl:merge>
                <xsl:merge-source name="common-components" select="collection(concat('file:///', replace($reportInDir, '\\', '/'), '?select=*.xsd&amp;recurse=yes'))[not(contains(base-uri(.),'/ExternalStandards/'))]/*:schema[@targetNamespace=($kCommonNamespace,$kIPOCommonNamespace)]/*[local-name() = ('complexType','simpleType')][@name]" sort-before-merge="true">
                    <xsl:merge-key select="string-join(descendant::*[not(local-name() = 'annotation')]/(name(),for $x in @* return concat($x/name(),$x)), ',')"/>
                    <xsl:merge-key select="
                            string-join(for $x in @*[not(local-name() = 'name')]
                            return
                                concat($x/name(), $x), ',')"/>
                </xsl:merge-source>
                <xsl:merge-source select="collection(concat('file:///', replace($reportInDir, '\\', '/'), '?select=*.xsd&amp;recurse=yes'))[not(contains(base-uri(.),'/ExternalStandards/'))]/*:schema[not(@targetNamespace=($kCommonNamespace,$kIPOCommonNamespace))]/*[local-name() = ('complexType','simpleType')][@name]" sort-before-merge="true">
                    <xsl:merge-key select="string-join(descendant::*[not(local-name() = 'annotation')]/(name(),for $x in @* return concat($x/name(),$x)), ',')"/>
                    <xsl:merge-key select="
                            string-join(for $x in @*[not(local-name() = 'name')]
                            return
                                concat($x/name(), $x), ',')"/>
                </xsl:merge-source>
                <xsl:merge-action>
                    <xsl:for-each-group select="current-merge-group()" group-adjacent="parent::node()/@targetNamespace">
                        <xsl:if test="count((current-group()[not(parent::node()/@targetNamespace = ($kIPOCommonNamespace,$kCommonNamespace))],current-merge-group('common-components'))) gt 1">
                            <duplicates ns="{tokenize(current-grouping-key(),'[/:]')[last()]}">
                                <xsl:for-each select="current-group()">
                                    <component name="{@name}" ns="{current-grouping-key()}" prefix="{namespace::node()[. = current-grouping-key()]/name()}"/>
                                </xsl:for-each>

                                <xsl:if test="not(current-grouping-key() = ($kCommonNamespace,$kIPOCommonNamespace))">
                                    <!--<xsl:message>duplicate with common: <xsl:value-of select="string-join(current-merge-group('common-components')/@name,', ')"/></xsl:message>-->
                                    <xsl:for-each select="current-merge-group('common-components')">
                                        <xsl:variable name="common-namespace" select="parent::node()/@targetNamespace"/>
                                        <component name="{@name}" ns="{$common-namespace}" prefix="{namespace::node()[. = $common-namespace]/name()}"/>
                                    </xsl:for-each>
                                </xsl:if>
                            </duplicates>
                        </xsl:if>
                    </xsl:for-each-group>
                    
                </xsl:merge-action>
            </xsl:merge>
        </duplicate-models>
    </xsl:template>
    
    
</xsl:stylesheet>