<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    exclude-result-prefixes="xs"
    version="2.0">
    <!-- for each namespace, check for duplicate schema component names (realistically this would only occur in a flattened schema and/or when nested directories occur)  -->
    
    <xsl:output encoding="UTF-8" method="xml" indent="yes"/>
    <xsl:strip-space elements="*"/>
    <xsl:param name="reportInDir"/>
    <xsl:template match="/">
        <xsl:variable name="schema-collection" select="collection(concat('file:///', replace($reportInDir, '\\', '/'), '?select=*.xsd&amp;recurse=yes'))[not(contains(base-uri(.),'/ExternalStandards/'))]"/>
        <duplicate-names>
            <xsl:for-each-group select="$schema-collection/*:schema/*[@name]" group-by="parent::node()/@targetNamespace">
                <xsl:for-each-group select="current-group()" group-by="@name">
                    <xsl:if test="count(current-group()) gt 1">
                        <xsl:for-each select="current-group()">
                            <component name="{current()/@name}" ns="{tokenize(parent::node()/@targetNamespace,'[/:]')[last()]}" uri="{substring-after(base-uri(),resolve-uri($reportInDir))}"/>
                        </xsl:for-each>
                    </xsl:if>
                </xsl:for-each-group>
            </xsl:for-each-group>
        </duplicate-names>
    </xsl:template>
    
</xsl:stylesheet>