<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:sch="http://purl.oclc.org/dsdl/schematron"
     xmlns:xs="http://www.w3.org/2001/XMLSchema"
    version="3.0">
  
  <xsl:output method="xml" indent="yes"/>
  
  <xsl:mode use-accumulators="#all"/>
  <xsl:accumulator name="test-count" initial-value="0" as="xs:integer">
    <xsl:accumulator-rule match="sch:pattern" select="0"/>
    <xsl:accumulator-rule match="sch:assert|sch:report" select="$value + 1"/>
  </xsl:accumulator>
  
  <xsl:template match="@* | node()" mode="build-pattern-file check-local">
    <xsl:copy>
      <xsl:apply-templates select="@* | node()" mode="#current"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="node()[self::comment()]" mode="build-pattern-file"/>
  <xsl:template match="sch:schema/text()" mode="build-pattern-file"/>

  <!-- So that unit testing (status.xsl) can be affected by ApprovedExceptions.xml settings -->
  <xsl:template match="sch:let[@name='kWhereToApproveExceptions']" mode="build-pattern-file">
    <let xmlns="http://purl.oclc.org/dsdl/schematron" name="kWhereToApproveExceptions" value="'InReport'"/>
  </xsl:template>
  
  <xsl:template match="sch:let[@name='st96Version']" mode="build-pattern-file">
    <let xmlns="http://purl.oclc.org/dsdl/schematron" name="st96Version" value="doc(resolve-uri('../../input/SD-28/Common/st96Version.xsd'))//*:attribute[@name eq 'st96Version'][1]/@*:fixed"/>
  </xsl:template>
  
  <xsl:template match="sch:let[@name='approvedExceptions']" mode="build-pattern-file">
    <let xmlns="http://purl.oclc.org/dsdl/schematron" name="approvedExceptions" value="doc('../ApprovedExceptions.xml')"/>
  </xsl:template>
  

  <xsl:template match="sch:pattern" mode="build-pattern-file">
    <xsl:param name="guidelineId" tunnel="yes"/>
    <xsl:if test="sch:title = $guidelineId">
      <xsl:copy>
        <xsl:apply-templates mode="build-pattern-file">
          <xsl:with-param name="guidelineId" select="$guidelineId" tunnel="yes"/>
        </xsl:apply-templates>
      </xsl:copy>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="sch:rule[sch:let/@value[matches(.,'doc-available\(\$[gs]d\d\dOutputFile\)')]]" mode="build-pattern-file">
    <!-- duplicate rules that are externally processed, to ensure the built-in tests also work -->
    <xsl:param name="guidelineId" tunnel="yes"/>

    <xsl:copy>
      <xsl:apply-templates select="@*" mode="build-pattern-file"/>
      <xsl:apply-templates select="node()" mode="build-pattern-file"/>
      
      <xsl:for-each-group select="*" group-starting-with=".[self::sch:let[@value[matches(.,'doc-available\(\$[gs]d\d\dOutputFile\)')]]]">
        <xsl:choose>
          <xsl:when test="current-group()[1][self::sch:let[@value[matches(.,'doc-available\(\$[gs]d\d\dOutputFile\)')]]]">
            <sch:let name="{current-group()[1]/@name}" value="{replace(current-group()[1]/@value,'(doc-available\(\$[gs]d\d\dOutputFile\))','doc-available(''dummy'')')}">
              
            </sch:let>
            <xsl:apply-templates select="current-group()[position() != 1]" mode="check-local"/>
          </xsl:when>
        </xsl:choose>
      </xsl:for-each-group>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="sch:report|sch:assert" mode="check-local">
    <xsl:copy>
      <xsl:apply-templates select="@*" mode="#current"/>
      <xsl:text>Locally run: </xsl:text> 
      <xsl:apply-templates select="node()" mode="#current"/>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="sch:rule/sch:assert|sch:rule/sch:report" mode="build-pattern-file">
    <xsl:param name="guidelineId" tunnel="yes"/>
      <xsl:copy><!-- add id to assertions/reports -->
        <xsl:attribute name="id"><xsl:value-of select="string-join(($guidelineId,accumulator-after('test-count')),'_')"/></xsl:attribute>
        <xsl:apply-templates select="@*|node()" mode="build-pattern-file"/>
      </xsl:copy>
  </xsl:template>

  <xsl:template match="/">
    <xsl:for-each select="sch:schema/sch:pattern">
      <xsl:variable name="title" select="sch:title"/>
      <xsl:result-document href="split_guidelines/{$title}.sch">
        <xsl:apply-templates select="/" mode="build-pattern-file">
          <xsl:with-param name="guidelineId" select="$title" tunnel="yes"/>
        </xsl:apply-templates>
      </xsl:result-document>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>
