<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:sch="http://purl.oclc.org/dsdl/schematron" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:fnx="http://www.example.com/fnx" version="2.0">

    <!-- need to update to XSPEC, so can check individual assertions/reports without relying on the message content and total counts -->
    <xsl:variable name="ipoConfig" select="doc('../BaselineNamespaces.xml')"/>

    <xsl:function name="fnx:expect" as="xsd:string">
        <xsl:param name="expected" as="xsd:string"/>
        <xsl:param name="svrlRoot" as="node()"/>

        <xsl:choose>
            <xsl:when test="not($svrlRoot/svrl:schematron-output/(svrl:failed-assert|svrl:successful-report)/*[local-name() != 'diagnostic-reference'][normalize-space() eq normalize-space($expected)])">
                <xsl:value-of select="
                        concat('Failed to find expected error message: ', '&quot;', $expected, '&quot;.', ' Found: ', string-join(for $x in $svrlRoot/svrl:schematron-output/(svrl:failed-assert|svrl:successful-report)/*[local-name() != 'diagnostic-reference']
                        return
                            concat('&quot;', normalize-space($x), '&quot;'), ', '))"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat('Successfully identified error: ', $expected)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <xsl:function name="fnx:expect-infile" as="xsd:string">
        <!-- use this when test is in one schema file which has includes/imports
            This requires the exact error message expected
        -->
        <xsl:param name="expected" as="xsd:string"/>
        <xsl:param name="ifFileName" as="xsd:string"/>
        <xsl:param name="inFileName" as="xsd:string"/>
        <xsl:param name="svrlRoot" as="node()"/>

        <xsl:choose>
            <xsl:when test="$inFileName eq $ifFileName and not($svrlRoot/svrl:schematron-output/(svrl:failed-assert|svrl:successful-report)/*[local-name() != 'diagnostic-reference'][normalize-space() eq normalize-space($expected)])">
                <xsl:value-of select="
                        concat('Failed to find expected error message: &quot;', $expected, '&quot;.', ' Found: ', string-join(for $x in $svrlRoot/svrl:schematron-output/(svrl:failed-assert|svrl:successful-report)/*[local-name() != 'diagnostic-reference']
                        return
                            concat('&quot;', normalize-space($x), '&quot;'), ', '))"/>
            </xsl:when>
            <xsl:when test="$inFileName eq $ifFileName">
                <xsl:value-of select="concat('Successfully identified error: ', $expected)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="''"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>
    
    <xsl:function name="fnx:expect-infile-by-component" as="xsd:string">
        <xsl:param name="componentName" as="xsd:string"/>
        <xsl:param name="ifFileName" as="xsd:string"/>
        <xsl:param name="inFileName" as="xsd:string"/>
        <xsl:param name="svrlRoot" as="node()"/>
        <xsl:variable name="errorFound" select="$svrlRoot/svrl:schematron-output/(svrl:failed-assert|svrl:successful-report)[$componentName eq '' or svrl:diagnostic-reference[@diagnostic eq 'componentName'] eq $componentName]/*[local-name() != 'diagnostic-reference']"/>
        <xsl:variable name="firedRule" select="$svrlRoot/svrl:schematron-output/svrl:fired-rule[1]"/>
        <xsl:choose>
            <xsl:when test="$inFileName eq $ifFileName and exists($errorFound) and string($componentName)">
                <xsl:value-of select="concat('Identified error for component:  &quot;', $componentName, '&quot;. ', string-join($errorFound,'| '))"/>
            </xsl:when>
            <xsl:when test="$inFileName eq $ifFileName and exists($errorFound)">
                <xsl:value-of select="concat('Identified error for schema: ', $firedRule/preceding-sibling::svrl:active-pattern[1]/@document/tokenize(.,'/')[last()], '. ', string-join($errorFound,'| '))"/>
            </xsl:when>
            <xsl:when test="$inFileName eq $ifFileName and empty($firedRule)">
                <xsl:value-of select="concat('Failed to check component: &quot;', $componentName, '&quot;. Rule was not activated.')"/>
            </xsl:when>
            <xsl:when test="$inFileName eq $ifFileName and string($componentName)">
                <xsl:value-of select="concat('No error for component: &quot;', $componentName, '&quot;.')"/>
            </xsl:when>
            <xsl:when test="$inFileName eq $ifFileName">
                <xsl:value-of select="concat('No error for schema: ', $firedRule/preceding-sibling::svrl:active-pattern[1]/@document/tokenize(.,'/')[last()],'.')"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="''"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>
    
    <xsl:function name="fnx:rule-test-outcome" as="xsd:string">
        <xsl:param name="expectedOutcomePass" as="xsd:boolean"/>
        <xsl:param name="testResult" as="xsd:string"/>
        <xsl:choose>
            <xsl:when test="$expectedOutcomePass">
                <xsl:value-of select="
                        concat(if (starts-with($testResult, 'No error')) then
                            ('Successfully validated: ')
                        else
                            ('Failed: '), $testResult)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="
                        concat(if (starts-with($testResult, 'Identified')) then
                            ('Successfully validated: ')
                        else
                            ('Failed: '), $testResult)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <xsl:function name="fnx:wrong-error-count-message" as="xsd:string">
        <xsl:param name="expected" as="xsd:integer"/>
        <xsl:param name="n" as="node()"/>

        <xsl:value-of select="concat('Expected ', $expected, ' failures but got ', count($n/(svrl:failed-assert|svrl:successful-report)), ' failures. ', count($n/svrl:fired-rule), ' fired rules.')"/>
    </xsl:function>

    <xsl:function name="fnx:failed-assert-count-is" as="xsd:boolean">
        <xsl:param name="expected" as="xsd:integer"/>
        <xsl:param name="n" as="node()"/>

        <xsl:sequence select="count($n/(svrl:failed-assert|svrl:successful-report)) = $expected"/>
    </xsl:function>

    <xsl:function name="fnx:failed-assert-count-is-infile" as="xsd:boolean">
        <!-- use this when schema being tested has imports/includes; or testing multiple schema files -->
        <xsl:param name="expected" as="xsd:integer"/>
        <xsl:param name="ifFileName" as="xsd:string"/>
        <xsl:param name="inFileName" as="xsd:string"/>
        <xsl:param name="n" as="node()"/>

        <xsl:sequence select="not($inFileName eq $ifFileName) or count($n/(svrl:failed-assert|svrl:successful-report)) = $expected"/>
    </xsl:function>

    <xsl:function name="fnx:no-fail-infile" as="xsd:boolean">
        <xsl:param name="failmsg" as="xsd:string"/>
        <xsl:param name="ifFileName" as="xsd:string"/>
        <xsl:param name="inFileName" as="xsd:string"/>

        <xsl:sequence select="not($inFileName eq $ifFileName) or $failmsg = ''"/>
    </xsl:function>

    <xsl:function name="fnx:ipo-has" as="xsd:boolean">
        <xsl:param name="area" as="xsd:string"/>
        <xsl:param name="part" as="xsd:string"/>
        <xsl:param name="val" as="xsd:string"/>

        <!--<xsl:value-of select="$ipoConfig/ipo/*[name() = $area]/@*[name() = $part] = $val"/>-->
        <xsl:sequence select="$ipoConfig/Namespaces/Namespace[@std = 'USPTO'][@component = $area]/@*[name() = $part] = $val"/>
    </xsl:function>

</xsl:stylesheet>
