<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>SD-64</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

      <let name="failtest1" value="fnx:expect-infile-by-component('','badC_V2_1.svrl',$inFileName,/)"/>
      <report test="$failtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR"  see="#SD-64">
        <value-of select="fnx:rule-test-outcome(false(),$failtest1)"/>
      </report>
      <let name="failtest2" value="fnx:expect-infile-by-component('','badC_V1_0.svrl',$inFileName,/)"/>
      <report test="$failtest2 != ''" flag="AUTO" diagnostics="uri" role="ERROR"  see="#SD-64">
        <value-of select="fnx:rule-test-outcome(false(),$failtest2)"/>
      </report>
      <let name="failtest3" value="fnx:expect-infile-by-component('','badD.svrl',$inFileName,/)"/>
      <report test="$failtest3 != ''" flag="AUTO" diagnostics="uri" role="ERROR"  see="#SD-64">
        <value-of select="fnx:rule-test-outcome(false(),$failtest3)"/>
      </report>
      <let name="failtest4" value="fnx:expect-infile-by-component('','bad_V2_0.svrl',$inFileName,/)"/>
      <report test="$failtest4 != ''" flag="AUTO" diagnostics="uri" role="ERROR"  see="#SD-64">
        <value-of select="fnx:rule-test-outcome(false(),$failtest4)"/>
      </report>
      <let name="failtest5" value="fnx:expect-infile-by-component('','badA_V2_0.svrl',$inFileName,/)"/>
      <report test="$failtest5 != ''" flag="AUTO" diagnostics="uri" role="ERROR"  see="#SD-64">
        <value-of select="fnx:rule-test-outcome(false(),$failtest5)"/>
      </report>
      <let name="failtest6" value="fnx:expect-infile-by-component('','badC.svrl',$inFileName,/)"/>
      <report test="$failtest6 != ''" flag="AUTO" diagnostics="uri" role="ERROR"  see="#SD-64">
        <value-of select="fnx:rule-test-outcome(false(),$failtest6)"/>
      </report>
      <let name="failtest7" value="fnx:expect-infile-by-component('','badC_V2.0.svrl',$inFileName,/)"/>
      <report test="$failtest7 != ''" flag="AUTO" diagnostics="uri" role="ERROR"  see="#SD-64">
        <value-of select="fnx:rule-test-outcome(false(),$failtest7)"/>
      </report>
      <let name="failtest8" value="fnx:expect-infile-by-component('','badC_v2_0.svrl',$inFileName,/)"/>
      <report test="$failtest8 != ''" flag="AUTO" diagnostics="uri" role="ERROR"  see="#SD-64">
        <value-of select="fnx:rule-test-outcome(false(),$failtest8)"/>
      </report>
      <let name="failtest9" value="fnx:expect-infile-by-component('','badC_V2_0_0.svrl',$inFileName,/)"/>
      <report test="$failtest9 != ''" flag="AUTO" diagnostics="uri" role="ERROR"  see="#SD-64">
        <value-of select="fnx:rule-test-outcome(false(),$failtest9)"/>
      </report>
      <let name="passtest10" value="fnx:expect-infile-by-component('','good.svrl',$inFileName,/)"/>
      <report test="$passtest10 != ''" flag="AUTO" diagnostics="uri" role="ERROR"  see="#SD-64">
        <value-of select="fnx:rule-test-outcome(true(),$passtest10)"/>
      </report>
      <let name="passtest11" value="fnx:expect-infile-by-component('','goodA.svrl',$inFileName,/)"/>
      <report test="$passtest11 != ''" flag="AUTO" diagnostics="uri" role="ERROR"  see="#SD-64">
        <value-of select="fnx:rule-test-outcome(true(),$passtest11)"/>
      </report>
      <let name="passtest12" value="fnx:expect-infile-by-component('','goodB.svrl',$inFileName,/)"/>
      <report test="$passtest12 != ''" flag="AUTO" diagnostics="uri" role="ERROR"  see="#SD-64">
        <value-of select="fnx:rule-test-outcome(true(),$passtest12)"/>
      </report>
      <let name="passtest13" value="fnx:expect-infile-by-component('','goodC_V2_0.svrl',$inFileName,/)"/>
      <report test="$passtest13 != ''" flag="AUTO" diagnostics="uri" role="ERROR"  see="#SD-64">
        <value-of select="fnx:rule-test-outcome(true(),$passtest13)"/>
      </report>
      <let name="passtest14" value="fnx:expect-infile-by-component('','goodD_V2_0.svrl',$inFileName,/)"/>
      <report test="$passtest14 != ''" flag="AUTO" diagnostics="uri" role="ERROR"  see="#SD-64">
        <value-of select="fnx:rule-test-outcome(true(),$passtest14)"/>
      </report>

    </rule>
	</pattern>
<diagnostics><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>
