<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>SD-49</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="failmsg0" value="fnx:expect('@minOccurs is set to the default value (1) for xs:element (e3).', /)"/>
      <let name="failmsg1" value="fnx:expect('@maxOccurs is set to the default value (1) for xs:element (e4).', /)"/>
      <let name="failmsg2" value="fnx:expect('@minOccurs is set to the default value (1) for xs:sequence.', /)"/>
      <let name="failmsg3" value="fnx:expect('@maxOccurs is set to the default value (1) for xs:sequence.', /)"/>
      <let name="failmsg4" value="fnx:expect('@minOccurs is set to the default value (1) for xs:any.', /)"/>
      <let name="failmsg5" value="fnx:expect('@maxOccurs is set to the default value (1) for xs:any.', /)"/>
      <let name="failmsg6" value="fnx:expect('@minOccurs is set to the default value (1) for xs:all.', /)"/>
      <let name="failmsg7" value="fnx:expect('@maxOccurs is set to the default value (1) for xs:all.', /)"/>
      <let name="failmsg8" value="fnx:expect('@minOccurs is set to the default value (1) for xs:choice.', /)"/>
      <let name="failmsg9" value="fnx:expect('@maxOccurs is set to the default value (1) for xs:choice.', /)"/>
      <let name="failmsg10" value="fnx:expect('@minOccurs is set to the default value (1) for xs:group.', /)"/>
      <let name="failmsg11" value="fnx:expect('@maxOccurs is set to the default value (1) for xs:group.', /)"/>

      <!-- Assertions -->

      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>
      <let name="passtest1" value="fnx:expect-infile-by-component('e', '1.svrl', $inFileName, /)"/>
      <report test="$passtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-49">
        <value-of select="fnx:rule-test-outcome(true(), $passtest1)"/>
      </report>

      <let name="failtest2" value="fnx:expect-infile-by-component('', '2.svrl', $inFileName, /)"/>
      <report test="$failtest2 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-49">
        <value-of select="fnx:rule-test-outcome(false(), $failtest2)"/>
      </report>

      <let name="failtest3" value="fnx:expect-infile-by-component('', '3.svrl', $inFileName, /)"/>
      <report test="$failtest3 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-49">
        <value-of select="fnx:rule-test-outcome(false(), $failtest3)"/>
      </report>

      <let name="passtest4" value="fnx:expect-infile-by-component('ct1', '4.svrl', $inFileName, /)"/>
      <report test="$passtest4 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-49">
        <value-of select="fnx:rule-test-outcome(true(), $passtest4)"/>
      </report>

      <let name="failtest5" value="fnx:expect-infile-by-component('ct2', '5.svrl', $inFileName, /)"/>
      <report test="$failtest5 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-49">
        <value-of select="fnx:rule-test-outcome(false(), $failtest5)"/>
      </report>

      <let name="failtest6" value="fnx:expect-infile-by-component('ct3', '6.svrl', $inFileName, /)"/>
      <report test="$failtest6 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-49">
        <value-of select="fnx:rule-test-outcome(false(), $failtest6)"/>
      </report>

      <let name="passtest7" value="fnx:expect-infile-by-component('ct4', '7.svrl', $inFileName, /)"/>
      <report test="$passtest7 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-49">
        <value-of select="fnx:rule-test-outcome(true(), $passtest7)"/>
      </report>

      <let name="failtest8" value="fnx:expect-infile-by-component('ct5', '8.svrl', $inFileName, /)"/>
      <report test="$failtest8 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-49">
        <value-of select="fnx:rule-test-outcome(false(), $failtest8)"/>
      </report>

      <let name="failtest9" value="fnx:expect-infile-by-component('ct6', '9.svrl', $inFileName, /)"/>
      <report test="$failtest9 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-49">
        <value-of select="fnx:rule-test-outcome(false(), $failtest9)"/>
      </report>

      <let name="passtest10" value="fnx:expect-infile-by-component('ct7', '11.svrl', $inFileName, /)"/>
      <report test="$passtest10 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-49">
        <value-of select="fnx:rule-test-outcome(true(), $passtest10)"/>
      </report>

      <let name="failtest11" value="fnx:expect-infile-by-component('ct8', '12.svrl', $inFileName, /)"/>
      <report test="$failtest11 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-49">
        <value-of select="fnx:rule-test-outcome(false(), $failtest11)"/>
      </report>

      <let name="failtest12" value="fnx:expect-infile-by-component('ct9', '13.svrl', $inFileName, /)"/>
      <report test="$failtest12 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-49">
        <value-of select="fnx:rule-test-outcome(false(), $failtest12)"/>
      </report>

      <let name="passtest130" value="fnx:expect-infile-by-component('ct10', '14.svrl', $inFileName, /)"/>
      <report test="$passtest130 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-49">
        <value-of select="fnx:rule-test-outcome(true(), $passtest130)"/>
      </report>

      <let name="failtest14" value="fnx:expect-infile-by-component('ct11', '15.svrl', $inFileName, /)"/>
      <report test="$failtest14 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-49">
        <value-of select="fnx:rule-test-outcome(false(), $failtest14)"/>
      </report>

      <let name="failtest16" value="fnx:expect-infile-by-component('ct12', '16.svrl', $inFileName, /)"/>
      <report test="$failtest16 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-49">
        <value-of select="fnx:rule-test-outcome(false(), $failtest16)"/>
      </report>
      
        <let name="passtest17" value="fnx:expect-infile-by-component('g1', '17.svrl', $inFileName, /)"/>
      <report test="$passtest17 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-49">
        <value-of select="fnx:rule-test-outcome(true(), $passtest17)"/>
      </report>
      
        <let name="passtest18" value="fnx:expect-infile-by-component('ct13', '18.svrl', $inFileName, /)"/>
      <report test="$passtest18 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-49">
        <value-of select="fnx:rule-test-outcome(true(), $passtest18)"/>
      </report>
      
         <let name="failtest19" value="fnx:expect-infile-by-component('ct14', '19.svrl', $inFileName, /)"/>
      <report test="$failtest19 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-49">
        <value-of select="fnx:rule-test-outcome(false(), $failtest19)"/>
      </report>
         <let name="failtest20" value="fnx:expect-infile-by-component('ct15', '20.svrl', $inFileName, /)"/>
      <report test="$failtest20 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-49">
        <value-of select="fnx:rule-test-outcome(false(), $failtest20)"/>
      </report>
      

    </rule>
	</pattern>
<diagnostics><diagnostic id="SD-49"/><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>