<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>SD-43</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>
      <let name="failmsg1" value="fnx:expect-infile('Element DateOfBirth_BAD must use xsd:date for date data.', '1.svrl', $inFileName, /)"/>
      <let name="failmsg2" value="fnx:expect-infile('Element TimeOfBirth_BAD must use xsd:time for time data.', '1.svrl', $inFileName, /)"/>
      <let name="failmsg3" value="fnx:expect-infile('Element DateOfBirthA_BAD must use xsd:date for date data.', '1.svrl', $inFileName, /)"/>
      <let name="failmsg4" value="fnx:expect-infile('Element x_BAD must use xsd:date for date data.', '1.svrl', $inFileName, /)"/>
      <let name="failmsg5" value="fnx:expect-infile('Element DateOfBirthD_BAD must use xsd:date for date data.', '1.svrl', $inFileName, /)"/>
      <let name="failmsg6" value="fnx:expect-infile('Element DateOfBirthE_BAD must use xsd:date for date data.', '1.svrl', $inFileName, /)"/>
      <!-- Assertions -->
      <let name="passtest1" value="fnx:expect-infile-by-component('DateOfBirth', '1.svrl', $inFileName, /)"/>
      <report test="$passtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-43">
        <value-of select="fnx:rule-test-outcome(true(), $passtest1)"/>
      </report>
      <let name="passtest2" value="fnx:expect-infile-by-component('TimeOfBirth', '2.svrl', $inFileName, /)"/>
      <report test="$passtest2 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-43">
        <value-of select="fnx:rule-test-outcome(true(), $passtest2)"/>
      </report>
      <let name="passtest3" value="fnx:expect-infile-by-component('x', '3.svrl', $inFileName, /)"/>
      <report test="$passtest3 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-43">
        <value-of select="fnx:rule-test-outcome(true(), $passtest3)"/>
      </report>
      <let name="passtest4" value="fnx:expect-infile-by-component('DateOfBirthB', '4.svrl', $inFileName, /)"/>
      <report test="$passtest4 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-43">
        <value-of select="fnx:rule-test-outcome(true(), $passtest4)"/>
      </report>
      <let name="passtest5" value="fnx:expect-infile-by-component('DateOfBirthD', '5.svrl', $inFileName, /)"/>
      <report test="$passtest5 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-43">
        <value-of select="fnx:rule-test-outcome(true(), $passtest5)"/>
      </report>
      <let name="passtest6" value="fnx:expect-infile-by-component('DateOfBirthE', '6.svrl', $inFileName, /)"/>
      <report test="$passtest6 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-43">
        <value-of select="fnx:rule-test-outcome(true(), $passtest6)"/>
      </report>
      <let name="passtest7" value="fnx:expect-infile-by-component('DocumentLoadedDateTime', '7.svrl', $inFileName, /)"/>
      <report test="$passtest7 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-43">
        <value-of select="fnx:rule-test-outcome(true(), $passtest7)"/>
      </report>
      
      <let name="failtest8" value="fnx:expect-infile-by-component('DateOfBirth_BAD', '8.svrl', $inFileName, /)"/>
      <report test="$failtest8 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-43">
        <value-of select="fnx:rule-test-outcome(false(), $failtest8)"/>
      </report>
       <let name="failtest9" value="fnx:expect-infile-by-component('TimeOfBirth_BAD', '8.svrl', $inFileName, /)"/>
      <report test="$failtest9 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-43">
        <value-of select="fnx:rule-test-outcome(false(), $failtest9)"/>
      </report>
       <let name="failtest10" value="fnx:expect-infile-by-component('DateOfBirthA_BAD', '8.svrl', $inFileName, /)"/>
      <report test="$failtest10 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-43">
        <value-of select="fnx:rule-test-outcome(false(), $failtest10)"/>
      </report>
       <let name="failtest11" value="fnx:expect-infile-by-component('x_BAD', '8.svrl', $inFileName, /)"/>
      <report test="$failtest11 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-43">
        <value-of select="fnx:rule-test-outcome(false(), $failtest11)"/>
      </report>
       <let name="failtest12" value="fnx:expect-infile-by-component('DateOfBirthD_BAD', '8.svrl', $inFileName, /)"/>
      <report test="$failtest12 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-43">
        <value-of select="fnx:rule-test-outcome(false(), $failtest12)"/>
      </report>
       <let name="failtest13" value="fnx:expect-infile-by-component('DateOfBirthE_BAD', '8.svrl', $inFileName, /)"/>
      <report test="$failtest13 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-43">
        <value-of select="fnx:rule-test-outcome(false(), $failtest13)"/>
      </report>
      
        <let name="passtest14" value="fnx:expect-infile-by-component('creationDate', 'creationDate.svrl', $inFileName, /)"/>
      <report test="$passtest14 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-43">
        <value-of select="fnx:rule-test-outcome(true(), $passtest14)"/>
      </report>
      
      <let name="passtest15" value="fnx:expect-infile-by-component('LegalEffectStartTimeCategory', 'LegalEffectStartTimeCategory.svrl', $inFileName, /)"/>
      <report test="$passtest15 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-43">
        <value-of select="fnx:rule-test-outcome(true(), $passtest15)"/>
      </report>
      
       <let name="passtest16" value="fnx:expect-infile-by-component('otherDateCategory', 'otherDateCategory.svrl', $inFileName, /)"/>
      <report test="$passtest16 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-43">
        <value-of select="fnx:rule-test-outcome(true(), $passtest16)"/>
      </report>
    </rule>
	</pattern>
<diagnostics><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>