<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns="http://purl.oclc.org/dsdl/schematron">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
	<ns prefix="fnx" uri="http://www.example.com/fnx"/>
	<ns prefix="xsl" uri="http://www.w3.org/1999/XSL/Transform"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
  <pattern>
    <title>SD-34</title>
    <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

    <rule context="svrl:schematron-output" role="ERROR">

      <let name="failmsg3" value="fnx:expect-infile('Element MathStuff: mathml:math should be used for math data.', '3.svrl', $inFileName, /)"/>

      <let name="failmsg5" value="fnx:expect-infile('Element MathJunk: mathml:math should be used for math data.', '5.svrl', $inFileName, /)"/>

      <let name="failmsg6" value="fnx:expect-infile('Element AlgebraThing: mathml:math should be used for math data.', '6.svrl', $inFileName, /)"/>



      <let name="failtest1" value="fnx:expect-infile-by-component('', '1.svrl', $inFileName, /)"/>
      <report test="$failtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-34">
        <value-of select="fnx:rule-test-outcome(false(), $failtest1)"/>
      </report>

      <let name="failtest2" value="fnx:expect-infile-by-component('', '3.svrl', $inFileName, /)"/>
      <report test="$failtest2 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-34">
        <value-of select="fnx:rule-test-outcome(false(), $failtest2)"/>
      </report>

      <let name="passtest3" value="fnx:expect-infile-by-component('', '4.svrl', $inFileName, /)"/>
      <report test="$passtest3 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-34">
        <value-of select="fnx:rule-test-outcome(true(), $passtest3)"/>
      </report>

      <let name="failtest4" value="fnx:expect-infile-by-component('', '5.svrl', $inFileName, /)"/>
      <report test="$failtest4 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-34">
        <value-of select="fnx:rule-test-outcome(false(), $failtest4)"/>
      </report>

      <let name="failtest5" value="fnx:expect-infile-by-component('', '6.svrl', $inFileName, /)"/>
      <report test="$failtest5 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-34">
        <value-of select="fnx:rule-test-outcome(false(), $failtest5)"/>
      </report>

      <let name="passtest6" value="fnx:expect-infile-by-component('', '7.svrl', $inFileName, /)"/>
      <report test="$passtest6 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-34">
        <value-of select="fnx:rule-test-outcome(true(), $passtest6)"/>
      </report>
      
      <let name="passtest7" value="fnx:expect-infile-by-component('', '8.svrl', $inFileName, /)"/>
      <report test="$passtest7 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-34">
        <value-of select="fnx:rule-test-outcome(true(), $passtest7)"/>
      </report>
    </rule>
  </pattern>
<diagnostics><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>