<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>SD-30</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

      <let name="failmsg1" value="fnx:expect-infile(
                                  'The version attribute is not specified.',
                                  'bad.svrl', $inFileName, /)"/>
      <let name="failmsg2" value="fnx:expect-infile(
                                  '&quot;1.0&quot; does not follow the form &quot;V&lt;MajorNumber&gt;_&lt;MinorNumber&gt;_&lt;OptionalPatchNumber&gt;&quot;',
                                  'bad2.svrl', $inFileName, /)"/>
      <let name="failmsg3" value="fnx:expect-infile(
        '&quot;V4_01&quot; does not follow the form &quot;V&lt;MajorNumber&gt;_&lt;MinorNumber&gt;_&lt;OptionalPatchNumber&gt;&quot;',
        'OrphanWorkAlternativeTitleBag.svrl', $inFileName,/
        )"/>
      <let name="failmsg4" value="fnx:expect-infile(
        '&quot;V4_01&quot; does not follow the form &quot;V&lt;MajorNumber&gt;_&lt;MinorNumber&gt;_&lt;OptionalPatchNumber&gt;&quot;',
        'OrphanWorkTitleBagType.svrl', $inFileName,/
        )"/>
      <!-- Assertions -->
      <let name="failtest1" value="fnx:expect-infile-by-component('', 'bad.svrl', $inFileName, /)" />
      <report test="$failtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-30">
        <value-of select="fnx:rule-test-outcome(false(), $failtest1)"/>
      </report>
      <let name="failtest2" value="fnx:expect-infile-by-component('', 'bad2.svrl', $inFileName, /)" />
      <report test="$failtest2 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-30">
        <value-of select="fnx:rule-test-outcome(false(), $failtest2)"/>
      </report>
       <let name="failtest3" value="fnx:expect-infile-by-component('', 'OrphanWorkAlternativeTitleBag.svrl', $inFileName, /)" />
      <report test="$failtest3 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-30">
        <value-of select="fnx:rule-test-outcome(false(), $failtest3)"/>
      </report>
       <let name="failtest4" value="fnx:expect-infile-by-component('', 'OrphanWorkTitleBagType.svrl', $inFileName, /)" />
      <report test="$failtest4 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-30">
        <value-of select="fnx:rule-test-outcome(false(), $failtest4)"/>
      </report>
         <let name="passtest5" value="fnx:expect-infile-by-component('', 'good.svrl', $inFileName, /)" />
      <report test="$passtest5 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-30">
        <value-of select="fnx:rule-test-outcome(true(), $passtest5)"/>
      </report>
         <let name="passtest6" value="fnx:expect-infile-by-component('', 'good2.svrl', $inFileName, /)" />
      <report test="$passtest6 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-30">
        <value-of select="fnx:rule-test-outcome(true(), $passtest6)"/>
      </report>
    </rule>
	</pattern>
<diagnostics><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>