<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>

  <pattern>
    <title>SD-19</title>
    <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="failmsg2" value="fnx:expect-infile('For XSD found in the Patent subdirectory, @targetNamespace (http://www.wipo.int/standards/XMLSchema/ST96/BAD) must equal http://www.wipo.int/standards/XMLSchema/ST96/Patent', '2.svrl', $inFileName, /)"/>
      <let name="failmsg4" value="fnx:expect-infile('For XSD found in the Patent subdirectory, @targetNamespace (http://www.wipo.int/standards/XMLSchema/ST96/BAD) must equal http://www.wipo.int/standards/XMLSchema/ST96/Patent', '4.svrl', $inFileName, /)"/>
      <let name="failmsg6" value="fnx:expect-infile('For XSD found in the USPatent subdirectory, @targetNamespace (urn:us:gov:doc:uspto:bad) must equal urn:us:gov:doc:uspto:patent', '6.svrl', $inFileName, /)"/>
      <let name="failmsg8" value="fnx:expect-infile('For XSD found in the USPatent subdirectory, @targetNamespace (urn:us:gov:doc:uspto:bad) must equal urn:us:gov:doc:uspto:patent', '8.svrl', $inFileName, /)"/>
      <!-- Assertions -->
      <let name="passtest1" value="fnx:expect-infile-by-component('', '1.svrl', $inFileName, /)"/>
      <report test="$passtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-19">
        <value-of select="fnx:rule-test-outcome(true(), $passtest1)"/>
      </report>
      <let name="failtest2" value="fnx:expect-infile-by-component('', '2.svrl', $inFileName, /)"/>
      <report test="$failtest2 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-19">
        <value-of select="fnx:rule-test-outcome(false(), $failtest2)"/>
      </report>
      <let name="passtest3" value="fnx:expect-infile-by-component('', '3.svrl', $inFileName, /)"/>
      <report test="$passtest3 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-19">
        <value-of select="fnx:rule-test-outcome(true(), $passtest3)"/>
      </report>
      <let name="failtest4" value="fnx:expect-infile-by-component('', '4.svrl', $inFileName, /)"/>
      <report test="$failtest4 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-19">
        <value-of select="fnx:rule-test-outcome(false(), $failtest4)"/>
      </report>
    </rule>
  </pattern>
<diagnostics><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>