<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>SD-18</title>
    <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="failmsg2" value="fnx:expect-infile(
                                  'For XSD found in the Common subdirectory, @targetNamespace (http://www.wipo.int/standards/XMLSchema/ST96/BAD) must equal http://www.wipo.int/standards/XMLSchema/ST96/Common',
                                  '2.svrl', $inFileName, /)"/>
     <let name="failmsg3" value="fnx:expect-infile(
                                  'For XSD found in the Common subdirectory, @targetNamespace (urn:us:gov:doc:uspto:common) must equal http://www.wipo.int/standards/XMLSchema/ST96/Common',
                                  '3.svrl', $inFileName, /)"/>
     <let name="failmsg4" value="fnx:expect-infile(
                                  'For XSD found in the USCommon subdirectory, @targetNamespace (http://www.wipo.int/standards/XMLSchema/ST96/Common) must equal urn:us:gov:doc:uspto:common',
                                  '4.svrl', $inFileName, /)"/>
     <let name="failmsg5" value="fnx:expect-infile(
                                  'For XSD found in the USCommon subdirectory, @targetNamespace (http://www.wipo.int/standards/XMLSchema/ST96/BAD) must equal urn:us:gov:doc:uspto:common',
                                  '5.svrl', $inFileName, /)"/>
      <!-- Assertions -->
    <let name="passtest1" value="fnx:expect-infile-by-component('', '1.svrl', $inFileName, /)"/>
      <report test="$passtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-18">
        <value-of select="fnx:rule-test-outcome(true(), $passtest1)"/>
      </report>
<let name="failtest1" value="fnx:expect-infile-by-component('', '2.svrl', $inFileName, /)"/>
      <report test="$failtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-18">
        <value-of select="fnx:rule-test-outcome(false(), $failtest1)"/>
      </report>
      <let name="failtest1" value="fnx:expect-infile-by-component('', '3.svrl', $inFileName, /)"/>
      <report test="$failtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-18">
        <value-of select="fnx:rule-test-outcome(false(), $failtest1)"/>
      </report>
    </rule>
	</pattern>
<diagnostics><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>