<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>SD-15</title>
    <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

    <rule context="svrl:schematron-output" role="WARNING">
      <let name="failmsg2" value="fnx:expect-infile('com: prefix (not co:) must be used for the http://www.wipo.int/standards/XMLSchema/ST96/Common namespace., pat: prefix (not pa:) must be used for the http://www.wipo.int/standards/XMLSchema/ST96/Patent namespace., dgn: prefix (not dg:) must be used for the http://www.wipo.int/standards/XMLSchema/ST96/Design namespace., tmk: prefix (not tm:) must be used for the http://www.wipo.int/standards/XMLSchema/ST96/Trademark namespace., tbl: prefix (not tb:) must be used for the http://www.oasis-open.org/tables/exchange/1.0 namespace., mathml: prefix (not ma:) must be used for the http://www.w3.org/1998/Math/MathML3 namespace.', '2.svrl', $inFileName, /)"/>
      <let name="failmsg5" value="fnx:expect-infile('uscom: prefix (not usco:) must be used for the urn:us:gov:doc:uspto:common namespace., uspat: prefix (not uspa:) must be used for the urn:us:gov:doc:uspto:patent namespace., usdgn: prefix (not usdg:) must be used for the urn:us:gov:doc:uspto:design namespace., ustmk: prefix (not ustm:) must be used for the urn:us:gov:doc:uspto:trademark namespace., uscor: prefix (not uscorp:) must be used for the urn:us:gov:doc:uspto:corporate namespace., usdis: prefix (not usdi:) must be used for the urn:us:gov:doc:uspto:dissemination namespace., usleg: prefix (not usle:) must be used for the urn:us:gov:doc:uspto:legal namespace., tbl: prefix (not tb:) must be used for the http://www.oasis-open.org/tables/exchange/1.0 namespace., mathml: prefix (not ma:) must be used for the http://www.w3.org/1998/Math/MathML3 namespace.', '5.svrl', $inFileName, /)"/>

      <!-- Assertions -->
      <let name="passtest1" value="fnx:expect-infile-by-component('', '1.svrl', $inFileName, /)"/>
      <report test="$passtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-15">
        <value-of select="fnx:rule-test-outcome(true(), $passtest1)"/>
      </report>
      <let name="failtest2" value="fnx:expect-infile-by-component('', '2.svrl', $inFileName, /)"/>
      <report test="$failtest2 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-15">
        <value-of select="fnx:rule-test-outcome(false(), $failtest2)"/>
      </report>
      <let name="passtest3" value="fnx:expect-infile-by-component('', '3.svrl', $inFileName, /)"/>
      <report test="$passtest3 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-15">
        <value-of select="fnx:rule-test-outcome(true(), $passtest3)"/>
      </report>
      <let name="passtest4" value="fnx:expect-infile-by-component('', '4.svrl', $inFileName, /)"/>
      <report test="$passtest4 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-15">
        <value-of select="fnx:rule-test-outcome(true(), $passtest4)"/>
      </report>
       <let name="failtest5" value="fnx:expect-infile-by-component('', '5.svrl', $inFileName, /)"/>
      <report test="$failtest5 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-15">
        <value-of select="fnx:rule-test-outcome(false(), $failtest5)"/>
      </report>
    </rule>
	</pattern>
<diagnostics><diagnostic id="SD-15"/><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>