<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>SD-14</title>
    <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="failmsg3" value="fnx:expect-infile('Namespace http://www.wipo.int/standards/XMLSchema/ST96/BAD does not follow the proper form.', '3.svrl', $inFileName, /)"/>
      <let name="failmsg4" value="fnx:expect-infile('Namespace http://www.wipo.int/standards/XMLSchema/ST96/BAD/Common does not follow the proper form.', '4.svrl', $inFileName, /)"/>
      <let name="failmsg7" value="fnx:expect-infile('Namespace http://www.wipo.int/standards/XMLSchema/ST96/BAD does not follow the proper form.', '7.svrl', $inFileName, /)"/>
      <let name="failmsg11" value="fnx:expect-infile('Namespace urn:us:gov:doc:uspto:bad does not follow the proper form. Expected namespace urn:us:gov:doc:uspto:corporate based on subdirectory name USCorporate.', '11.svrl', $inFileName, /)"/>

      <let name="failmsg19" value="fnx:expect-infile('Namespace http://www.wipo.int/standards/XMLSchema/ST96/BAD does not follow the proper form.', '19.svrl', $inFileName, /)"/>
      <let name="failmsg21" value="fnx:expect-infile('Namespace urn:us:gov:doc:uspto:bad does not follow the proper form. Expected namespace urn:us:gov:doc:uspto:corporate based on subdirectory name USCorporate.', '21.svrl', $inFileName, /)"/>

      <!-- Assertions -->
 

      <let name="passtest1" value="fnx:expect-infile-by-component('', '1.svrl', $inFileName, /)"/>
      <report test="$passtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-14">
        <value-of select="fnx:rule-test-outcome(true(), $passtest1)"/>
      </report>
      <let name="passtest2" value="fnx:expect-infile-by-component('', '2.svrl', $inFileName, /)"/>
      <report test="$passtest2 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-14">
        <value-of select="fnx:rule-test-outcome(true(), $passtest2)"/>
      </report>
      <let name="failtest3" value="fnx:expect-infile-by-component('', '3.svrl', $inFileName, /)"/>
      <report test="$failtest3 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-14">
        <value-of select="fnx:rule-test-outcome(false(), $failtest3)"/>
      </report>

      <let name="failtest4" value="fnx:expect-infile-by-component('', '4.svrl', $inFileName, /)"/>
      <report test="$failtest4 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-14">
        <value-of select="fnx:rule-test-outcome(false(), $failtest4)"/>
      </report>
      <let name="passtest5" value="fnx:expect-infile-by-component('', '5.svrl', $inFileName, /)"/>
      <report test="$passtest5 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-14">
        <value-of select="fnx:rule-test-outcome(true(), $passtest5)"/>
      </report>
      <let name="passtest6" value="fnx:expect-infile-by-component('', '6.svrl', $inFileName, /)"/>
      <report test="$passtest6 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-14">
        <value-of select="fnx:rule-test-outcome(true(), $passtest6)"/>
      </report>
      <let name="failtest7" value="fnx:expect-infile-by-component('', '7.svrl', $inFileName, /)"/>
      <report test="$failtest7 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-14">
        <value-of select="fnx:rule-test-outcome(false(), $failtest7)"/>
      </report>
      
       <let name="passtest8" value="fnx:expect-infile-by-component('', '8.svrl', $inFileName, /)"/>
      <report test="$passtest8 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-14">
        <value-of select="fnx:rule-test-outcome(true(), $passtest8)"/>
      </report>
      <let name="passtest9" value="fnx:expect-infile-by-component('', '9.svrl', $inFileName, /)"/>
      <report test="$passtest9 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-14">
        <value-of select="fnx:rule-test-outcome(true(), $passtest9)"/>
      </report>
      
       <let name="passtest10" value="fnx:expect-infile-by-component('', '18.svrl', $inFileName, /)"/>
      <report test="$passtest10 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-14">
        <value-of select="fnx:rule-test-outcome(true(), $passtest10)"/>
      </report>
      
       <let name="failtest11" value="fnx:expect-infile-by-component('', '19.svrl', $inFileName, /)"/>
      <report test="$failtest11 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-14">
        <value-of select="fnx:rule-test-outcome(false(), $failtest11)"/>
      </report>
    </rule>
	</pattern>
<diagnostics><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>