<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>SD-12</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

      <let name="failmsg1" value="fnx:expect-infile(
                                  '@targetNamespace= is not a valid URI.',
                                  '1.svrl', $inFileName, /)"/>
      <let name="failmsg2" value="fnx:expect-infile(
                                  '@targetNamespace=NOT-A-URI is not a valid URI.',
                                  '2.svrl', $inFileName, /)"/>
      <!-- Assertions -->

       <let name="passtest1" value="fnx:expect-infile-by-component('', '1.svrl', $inFileName, /)"/>
      <report test="$passtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-12">
        <value-of select="fnx:rule-test-outcome(true(), $passtest1)"/>
      </report>
      <let name="passtest2" value="fnx:expect-infile-by-component('', '2.svrl', $inFileName, /)"/>
      <report test="$passtest2 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-12">
        <value-of select="fnx:rule-test-outcome(true(), $passtest2)"/>
      </report>
   <let name="passtest3" value="fnx:expect-infile-by-component('', '1.svrl', $inFileName, /)"/>
      <report test="$passtest3 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-12">
        <value-of select="fnx:rule-test-outcome(true(), $passtest3)"/>
      </report>
      <let name="failtest4" value="fnx:expect-infile-by-component('', '4.svrl', $inFileName, /)"/>
      <report test="$failtest4 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-12">
        <value-of select="fnx:rule-test-outcome(false(), $failtest4)"/>
      </report>
      <let name="failtest5" value="fnx:expect-infile-by-component('', '5.svrl', $inFileName, /)"/>
      <report test="$failtest5 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-12">
        <value-of select="fnx:rule-test-outcome(false(), $failtest5)"/>
      </report>
      
      <let name="failtest6" value="fnx:expect-infile-by-component('', '6.svrl', $inFileName, /)"/>
      <report test="$failtest6 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-12">
        <value-of select="fnx:rule-test-outcome(false(), $failtest6)"/>
      </report>
    </rule>

	</pattern>
<diagnostics><diagnostic id="SD-12"/><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>