<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>SD-07</title>
    <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="failmsg1" value="fnx:expect-infile('xsd:redefine must not be used.', 'redefine.svrl', $inFileName, /)"/>
      <!-- Assertions -->

      <assert test="fnx:failed-assert-count-is-infile(0, 'address.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-07" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, 'v1.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-07" role="ERROR">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      

      <let name="failtest1" value="fnx:expect-infile-by-component('', 'redefine.svrl', $inFileName, /)"/>
      <report test="$failtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-07">
        <value-of select="fnx:rule-test-outcome(false(), $failtest1)"/>
      </report>
    
    </rule>

	</pattern>
<diagnostics><diagnostic id="SD-07"/><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>
