<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>SD-03</title>

    <rule context="svrl:schematron-output" role="WARNING">
      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

      <let name="failmsg1b" value="fnx:expect-infile('XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Patent namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Trademark, http://www.wipo.int/standards/XMLSchema/ST96/Design.', '1b.svrl', $inFileName, /)"/>
      <let name="failmsg1c" value="fnx:expect-infile('XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Patent namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:trademark, urn:us:gov:doc:uspto:design, urn:us:gov:doc:uspto:corporate, urn:us:gov:doc:uspto:dissemination, urn:us:gov:doc:uspto:legal.', '1c.svrl', $inFileName, /)"/>
      <let name="failmsg2b" value="fnx:expect-infile('XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Trademark namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Patent, http://www.wipo.int/standards/XMLSchema/ST96/Design.', '2b.svrl', $inFileName, /)"/>
      <let name="failmsg2c" value="fnx:expect-infile('XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Trademark namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:patent, urn:us:gov:doc:uspto:design, urn:us:gov:doc:uspto:corporate, urn:us:gov:doc:uspto:dissemination, urn:us:gov:doc:uspto:legal.', '2c.svrl', $inFileName, /)"/>
      <let name="failmsg3b" value="fnx:expect-infile('XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Design namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Trademark, http://www.wipo.int/standards/XMLSchema/ST96/Patent.', '3b.svrl', $inFileName, /)"/>
      <let name="failmsg3c" value="fnx:expect-infile('XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Design namespace may not refer to XSDs in the following namespace(s):         urn:us:gov:doc:uspto:trademark, urn:us:gov:doc:uspto:patent, urn:us:gov:doc:uspto:corporate, urn:us:gov:doc:uspto:dissemination, urn:us:gov:doc:uspto:legal.', '3c.svrl', $inFileName, /)"/>
      <let name="failmsg4b" value="fnx:expect-infile('XSDs in the urn:us:gov:doc:uspto:patent namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Trademark, http://www.wipo.int/standards/XMLSchema/ST96/Design.', '4b.svrl', $inFileName, /)"/>
      <let name="failmsg4c" value="fnx:expect-infile('XSDs in the urn:us:gov:doc:uspto:patent namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:trademark, urn:us:gov:doc:uspto:design, urn:us:gov:doc:uspto:corporate, urn:us:gov:doc:uspto:dissemination, urn:us:gov:doc:uspto:legal.', '4c.svrl', $inFileName, /)"/>
      <let name="failmsg5b" value="fnx:expect-infile('XSDs in the urn:us:gov:doc:uspto:trademark namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Patent, http://www.wipo.int/standards/XMLSchema/ST96/Design.', '5b.svrl', $inFileName, /)"/>
      <let name="failmsg5c" value="fnx:expect-infile('XSDs in the urn:us:gov:doc:uspto:trademark namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:patent, urn:us:gov:doc:uspto:design, urn:us:gov:doc:uspto:corporate, urn:us:gov:doc:uspto:dissemination, urn:us:gov:doc:uspto:legal.', '5c.svrl', $inFileName, /)"/>
      <let name="failmsg6b" value="fnx:expect-infile('XSDs in the urn:us:gov:doc:uspto:design namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Trademark, http://www.wipo.int/standards/XMLSchema/ST96/Patent.', '6b.svrl', $inFileName, /)"/>
      <let name="failmsg6c" value="fnx:expect-infile('XSDs in the urn:us:gov:doc:uspto:design namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:trademark, urn:us:gov:doc:uspto:patent, urn:us:gov:doc:uspto:corporate, urn:us:gov:doc:uspto:dissemination, urn:us:gov:doc:uspto:legal.', '6c.svrl', $inFileName, /)"/>
      <let name="failmsg7b" value="fnx:expect-infile('XSDs in the urn:us:gov:doc:uspto:corporate namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Patent, http://www.wipo.int/standards/XMLSchema/ST96/Trademark, http://www.wipo.int/standards/XMLSchema/ST96/Design.', '7b.svrl', $inFileName, /)"/>
      <let name="failmsg7c" value="fnx:expect-infile('XSDs in the urn:us:gov:doc:uspto:corporate namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:patent, urn:us:gov:doc:uspto:trademark, urn:us:gov:doc:uspto:design, urn:us:gov:doc:uspto:dissemination, urn:us:gov:doc:uspto:legal.', '7c.svrl', $inFileName, /)"/>
      <let name="failmsg8b" value="fnx:expect-infile('XSDs in the urn:us:gov:doc:uspto:dissemination namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Patent, http://www.wipo.int/standards/XMLSchema/ST96/Trademark, http://www.wipo.int/standards/XMLSchema/ST96/Design.', '8b.svrl', $inFileName, /)"/>
      <let name="failmsg8c" value="fnx:expect-infile('XSDs in the urn:us:gov:doc:uspto:dissemination namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:patent, urn:us:gov:doc:uspto:trademark, urn:us:gov:doc:uspto:design, urn:us:gov:doc:uspto:corporate, urn:us:gov:doc:uspto:legal.', '8c.svrl', $inFileName, /)"/>
      <let name="failmsg9b" value="fnx:expect-infile('XSDs in the urn:us:gov:doc:uspto:legal namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Patent, http://www.wipo.int/standards/XMLSchema/ST96/Trademark, http://www.wipo.int/standards/XMLSchema/ST96/Design.', '9b.svrl', $inFileName, /)"/>
      <let name="failmsg9c" value="fnx:expect-infile('XSDs in the urn:us:gov:doc:uspto:legal namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:patent, urn:us:gov:doc:uspto:trademark, urn:us:gov:doc:uspto:design, urn:us:gov:doc:uspto:corporate, urn:us:gov:doc:uspto:dissemination.', '9c.svrl', $inFileName, /)"/>

      <!-- Assertions -->
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '2.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '3.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '4.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '5.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '6.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '7.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '8.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, '9.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '1b.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '2b.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '3b.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, 'GIComponentType.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(0, 'TrademarkComponentType.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>

      <assert test="not(fnx:ipo-has('trademark', 'ns-prefix', 'ustmk')) or not(fnx:ipo-has('design', 'ns-prefix', 'usdgn')) or fnx:failed-assert-count-is-infile(1, '4b.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('patent', 'ns-prefix', 'uspat')) or not(fnx:ipo-has('design', 'ns-prefix', 'usdgn')) or fnx:failed-assert-count-is-infile(1, '5b.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('trademark', 'ns-prefix', 'ustmk')) or not(fnx:ipo-has('patent', 'ns-prefix', 'uspat')) or fnx:failed-assert-count-is-infile(1, '6b.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '7b.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '8b.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '9b.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('trademark', 'ns-prefix', 'ustmk')) or not(fnx:ipo-has('design', 'ns-prefix', 'usdgn')) or fnx:failed-assert-count-is-infile(1, '1c.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('patent', 'ns-prefix', 'uspat')) or not(fnx:ipo-has('design', 'ns-prefix', 'usdgn')) or fnx:failed-assert-count-is-infile(1, '2c.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('trademark', 'ns-prefix', 'ustmk')) or not(fnx:ipo-has('patent', 'ns-prefix', 'uspat')) or fnx:failed-assert-count-is-infile(1, '3c.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('trademark', 'ns-prefix', 'ustmk')) or not(fnx:ipo-has('design', 'ns-prefix', 'usdgn')) or fnx:failed-assert-count-is-infile(1, '4c.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('patent', 'ns-prefix', 'uspat')) or not(fnx:ipo-has('design', 'ns-prefix', 'usdgn')) or fnx:failed-assert-count-is-infile(1, '5c.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="not(fnx:ipo-has('trademark', 'ns-prefix', 'ustmk')) or not(fnx:ipo-has('patent', 'ns-prefix', 'uspat')) or fnx:failed-assert-count-is-infile(1, '6c.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '7c.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '8c.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
      <assert test="fnx:failed-assert-count-is-infile(1, '9c.svrl', $inFileName, .)" flag="AUTO" diagnostics="uri " see="#SD-03" role="WARNING">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>

      <let name="failtest1" value="fnx:expect-infile-by-component('', '1b.svrl', $inFileName, /)"/>
      <report test="$failtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-03">
        <value-of select="fnx:rule-test-outcome(false(), $failtest1)"/>
      </report>
      <let name="failtest2" value="fnx:expect-infile-by-component('', '1c.svrl', $inFileName, /)"/>
      <report test="$failtest2 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-03">
        <value-of select="fnx:rule-test-outcome(false(), $failtest2)"/>
      </report>
      <let name="failtest3" value="fnx:expect-infile-by-component('', '2b.svrl', $inFileName, /)"/>
      <report test="$failtest3 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-03">
        <value-of select="fnx:rule-test-outcome(false(), $failtest3)"/>
      </report>
      <let name="failtest4" value="fnx:expect-infile-by-component('', '2c.svrl', $inFileName, /)"/>
      <report test="$failtest4 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-03">
        <value-of select="fnx:rule-test-outcome(false(), $failtest4)"/>
      </report>
      <let name="failtest5" value="fnx:expect-infile-by-component('', '3b.svrl', $inFileName, /)"/>
      <report test="$failtest5 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-03">
        <value-of select="fnx:rule-test-outcome(false(), $failtest5)"/>
      </report>
      <let name="failtest6" value="fnx:expect-infile-by-component('', '3c.svrl', $inFileName, /)"/>
      <report test="$failtest6 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-03">
        <value-of select="fnx:rule-test-outcome(false(), $failtest6)"/>
      </report>
      <let name="failtest7" value="fnx:expect-infile-by-component('', '4b.svrl', $inFileName, /)"/>
      <report test="$failtest7 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-03">
        <value-of select="fnx:rule-test-outcome(false(), $failtest7)"/>
      </report>
      <let name="failtest8" value="fnx:expect-infile-by-component('', '4c.svrl', $inFileName, /)"/>
      <report test="$failtest8 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-03">
        <value-of select="fnx:rule-test-outcome(false(), $failtest8)"/>
      </report>
      <let name="failtest9" value="fnx:expect-infile-by-component('', '5b.svrl', $inFileName, /)"/>
      <report test="$failtest9 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-03">
        <value-of select="fnx:rule-test-outcome(false(), $failtest9)"/>
      </report>
      <let name="failtest10" value="fnx:expect-infile-by-component('', '5c.svrl', $inFileName, /)"/>
      <report test="$failtest10 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-03">
        <value-of select="fnx:rule-test-outcome(false(), $failtest10)"/>
      </report>
      <let name="failtest11" value="fnx:expect-infile-by-component('', '6b.svrl', $inFileName, /)"/>
      <report test="$failtest11 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-03">
        <value-of select="fnx:rule-test-outcome(false(), $failtest11)"/>
      </report>
      <let name="failtest12" value="fnx:expect-infile-by-component('', '6c.svrl', $inFileName, /)"/>
      <report test="$failtest12 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-03">
        <value-of select="fnx:rule-test-outcome(false(), $failtest12)"/>
      </report>
      <let name="failtest13" value="fnx:expect-infile-by-component('', '7b.svrl', $inFileName, /)"/>
      <report test="$failtest13 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-03">
        <value-of select="fnx:rule-test-outcome(false(), $failtest13)"/>
      </report>
      <let name="failtest14" value="fnx:expect-infile-by-component('', '7c.svrl', $inFileName, /)"/>
      <report test="$failtest14 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-03">
        <value-of select="fnx:rule-test-outcome(false(), $failtest14)"/>
      </report>
      <let name="failtest15" value="fnx:expect-infile-by-component('', '8b.svrl', $inFileName, /)"/>
      <report test="$failtest15 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-03">
        <value-of select="fnx:rule-test-outcome(false(), $failtest15)"/>
      </report>
      <let name="failtest16" value="fnx:expect-infile-by-component('', '8c.svrl', $inFileName, /)"/>
      <report test="$failtest16 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-03">
        <value-of select="fnx:rule-test-outcome(false(), $failtest16)"/>
      </report>
      <let name="failtest17" value="fnx:expect-infile-by-component('', '9b.svrl', $inFileName, /)"/>
      <report test="$failtest17 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-03">
        <value-of select="fnx:rule-test-outcome(false(), $failtest17)"/>
      </report>
      <let name="failtest18" value="fnx:expect-infile-by-component('', '9c.svrl', $inFileName, /)"/>
      <report test="$failtest18 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-03">
        <value-of select="fnx:rule-test-outcome(false(), $failtest18)"/>
      </report>
      <let name="passtest1" value="fnx:expect-infile-by-component('','DesignPatentBibliographicDataType_V8_1.svrl',$inFileName,/)"/>
      <report test="$passtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-03">
        <value-of select="fnx:rule-test-outcome(true(), $passtest1)"/>
      </report>
      <let name="passtest2" value="fnx:expect-infile-by-component('','GIComponentType.svrl',$inFileName,/)"/>
      <report test="$passtest2 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-03">
        <value-of select="fnx:rule-test-outcome(true(), $passtest2)"/>
      </report>
      <let name="passtest3" value="fnx:expect-infile-by-component('','TrademarkComponentType.svrl',$inFileName,/)"/>
      <report test="$passtest3 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-03">
        <value-of select="fnx:rule-test-outcome(true(), $passtest3)"/>
      </report>
      
    </rule>

	</pattern>
<diagnostics><diagnostic id="SD-03"/><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>