<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>SD-02</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

      <let name="failmsg2b" value="fnx:expect-infile('XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Common namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Patent.', '2b.svrl', $inFileName, /)"/>
      <let name="failmsg3b" value="fnx:expect-infile('XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Common namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Trademark.', '3b.svrl', $inFileName, /)"/>
      <let name="failmsg4b" value="fnx:expect-infile('XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Common namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Design.', '4b.svrl', $inFileName, /)"/>
      <let name="failmsg5b" value="fnx:expect-infile('XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Common namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:patent.', '5b.svrl', $inFileName, /)"/>
      <let name="failmsg6b" value="fnx:expect-infile('XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Common namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:trademark.', '6b.svrl', $inFileName, /)"/>
      <let name="failmsg7b" value="fnx:expect-infile('XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Common namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:design.', '7b.svrl', $inFileName, /)"/>
      <let name="failmsg9b" value="fnx:expect-infile('XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Common namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:corporate.', '9b.svrl', $inFileName, /)"/>
      <let name="failmsg10b" value="fnx:expect-infile('XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Common namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:dissemination.', '10b.svrl', $inFileName, /)"/>
      <let name="failmsg11b" value="fnx:expect-infile('XSDs in the http://www.wipo.int/standards/XMLSchema/ST96/Common namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:legal.', '11b.svrl', $inFileName, /)"/>
      <let name="failmsg2a" value="fnx:expect-infile('XSDs in the urn:us:gov:doc:uspto:common namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Patent.', '2a.svrl', $inFileName, /)"/>
      <let name="failmsg3a" value="fnx:expect-infile('XSDs in the urn:us:gov:doc:uspto:common namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Trademark.', '3a.svrl', $inFileName, /)"/>
      <let name="failmsg4a" value="fnx:expect-infile('XSDs in the urn:us:gov:doc:uspto:common namespace may not refer to XSDs in the following namespace(s): http://www.wipo.int/standards/XMLSchema/ST96/Design.', '4a.svrl', $inFileName, /)"/>
      <let name="failmsg5a" value="fnx:expect-infile('XSDs in the urn:us:gov:doc:uspto:common namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:patent.', '5a.svrl', $inFileName, /)"/>
      <let name="failmsg6a" value="fnx:expect-infile('XSDs in the urn:us:gov:doc:uspto:common namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:trademark.', '6a.svrl', $inFileName, /)"/>
      <let name="failmsg7a" value="fnx:expect-infile('XSDs in the urn:us:gov:doc:uspto:common namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:design.', '7a.svrl', $inFileName, /)"/>
      <let name="failmsg9a" value="fnx:expect-infile('XSDs in the urn:us:gov:doc:uspto:common namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:corporate.', '9a.svrl', $inFileName, /)"/>
      <let name="failmsg10a" value="fnx:expect-infile('XSDs in the urn:us:gov:doc:uspto:common namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:dissemination.', '10a.svrl', $inFileName, /)"/>
      <let name="failmsg11a" value="fnx:expect-infile('XSDs in the urn:us:gov:doc:uspto:common namespace may not refer to XSDs in the following namespace(s): urn:us:gov:doc:uspto:legal.', '11a.svrl', $inFileName, /)"/>

      <!-- Assertions -->

      <let name="passtest1" value="fnx:expect-infile-by-component('', '1a.svrl', $inFileName, /)"/>
      <report test="$passtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-02">
        <value-of select="fnx:rule-test-outcome(true(), $passtest1)"/>
      </report>

      <let name="passtest3" value="fnx:expect-infile-by-component('', '1b.svrl', $inFileName, /)"/>
      <report test="$passtest3 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-02">
        <value-of select="fnx:rule-test-outcome(true(), $passtest3)"/>
      </report>

      <let name="failtest4" value="fnx:expect-infile-by-component('', '2a.svrl', $inFileName, /)"/>
      <report test="$failtest4 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-02">
        <value-of select="fnx:rule-test-outcome(false(), $failtest4)"/>
      </report>

      <let name="failtest5" value="fnx:expect-infile-by-component('', '2b.svrl', $inFileName, /)"/>
      <report test="$failtest5 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-02">
        <value-of select="fnx:rule-test-outcome(false(), $failtest5)"/>
      </report>

      <let name="failtest6" value="fnx:expect-infile-by-component('', '3a.svrl', $inFileName, /)"/>
      <report test="$failtest6 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-02">
        <value-of select="fnx:rule-test-outcome(false(), $failtest6)"/>
      </report>

      <let name="failtest7" value="fnx:expect-infile-by-component('', '3b.svrl', $inFileName, /)"/>
      <report test="$failtest7 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-02">
        <value-of select="fnx:rule-test-outcome(false(), $failtest7)"/>
      </report>

      <let name="failtest8" value="fnx:expect-infile-by-component('', '4a.svrl', $inFileName, /)"/>
      <report test="$failtest8 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-02">
        <value-of select="fnx:rule-test-outcome(false(), $failtest8)"/>
      </report>

      <let name="failtest9" value="fnx:expect-infile-by-component('', '4b.svrl', $inFileName, /)"/>
      <report test="$failtest9 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-02">
        <value-of select="fnx:rule-test-outcome(false(), $failtest9)"/>
      </report>

      <let name="failtest10" value="fnx:expect-infile-by-component('', '5a.svrl', $inFileName, /)"/>
      <report test="$failtest10 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-02">
        <value-of select="fnx:rule-test-outcome(false(), $failtest10)"/>
      </report>

      <let name="failtest11" value="fnx:expect-infile-by-component('', '5b.svrl', $inFileName, /)"/>
      <report test="$failtest11 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-02">
        <value-of select="fnx:rule-test-outcome(false(), $failtest11)"/>
      </report>

      <let name="failtest12" value="fnx:expect-infile-by-component('', '6a.svrl', $inFileName, /)"/>
      <report test="$failtest12 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-02">
        <value-of select="fnx:rule-test-outcome(false(), $failtest12)"/>
      </report>

      <let name="failtest13" value="fnx:expect-infile-by-component('', '6b.svrl', $inFileName, /)"/>
      <report test="$failtest13 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-02">
        <value-of select="fnx:rule-test-outcome(false(), $failtest13)"/>
      </report>

      <let name="failtest14" value="fnx:expect-infile-by-component('', '7a.svrl', $inFileName, /)"/>
      <report test="$failtest14 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-02">
        <value-of select="fnx:rule-test-outcome(false(), $failtest14)"/>
      </report>

      <let name="failtest15" value="fnx:expect-infile-by-component('', '7b.svrl', $inFileName, /)"/>
      <report test="$failtest15 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-02">
        <value-of select="fnx:rule-test-outcome(false(), $failtest15)"/>
      </report>

      <let name="passtest16" value="fnx:expect-infile-by-component('', '8a.svrl', $inFileName, /)"/>
      <report test="$passtest16 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-02">
        <value-of select="fnx:rule-test-outcome(true(), $passtest16)"/>
      </report>

      <let name="passtest17" value="fnx:expect-infile-by-component('', '8b.svrl', $inFileName, /)"/>
      <report test="$passtest17 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-02">
        <value-of select="fnx:rule-test-outcome(true(), $passtest17)"/>
      </report>

      <let name="failtest18" value="fnx:expect-infile-by-component('', '9a.svrl', $inFileName, /)"/>
      <report test="$failtest18 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-02">
        <value-of select="fnx:rule-test-outcome(false(), $failtest18)"/>
      </report>

      <let name="failtest19" value="fnx:expect-infile-by-component('', '9b.svrl', $inFileName, /)"/>
      <report test="$failtest19 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-02">
        <value-of select="fnx:rule-test-outcome(false(), $failtest19)"/>
      </report>

      <let name="failtest20" value="fnx:expect-infile-by-component('', '10a.svrl', $inFileName, /)"/>
      <report test="$failtest20 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-02">
        <value-of select="fnx:rule-test-outcome(false(), $failtest20)"/>
      </report>

      <let name="failtest21" value="fnx:expect-infile-by-component('', '10b.svrl', $inFileName, /)"/>
      <report test="$failtest21 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-02">
        <value-of select="fnx:rule-test-outcome(false(), $failtest21)"/>
      </report>

      <let name="failtest22" value="fnx:expect-infile-by-component('', '11a.svrl', $inFileName, /)"/>
      <report test="$failtest22 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-02">
        <value-of select="fnx:rule-test-outcome(false(), $failtest22)"/>
      </report>

      <let name="failtest23" value="fnx:expect-infile-by-component('', '11b.svrl', $inFileName, /)"/>
      <report test="$failtest23 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-02">
        <value-of select="fnx:rule-test-outcome(false(), $failtest23)"/>
      </report>


    </rule>

	</pattern>
<diagnostics><diagnostic id="SD-02"/><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>