<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>SD-01</title>

    <rule context="svrl:schematron-output" role="WARNING">
      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

      <let name="failmsg1b" value="fnx:expect-infile('XSDs in the patent namespace that have declared a common namespace prefix must use xsd:import to reference common component schema modules.', '1b.svrl', $inFileName, /)"/>
      <let name="failmsg2b" value="fnx:expect-infile('XSDs in the trademark namespace that have declared a common namespace prefix must use xsd:import to reference common component schema modules.', '2b.svrl', $inFileName, /)"/>
      <let name="failmsg3b" value="fnx:expect-infile('XSDs in the design namespace that have declared a common namespace prefix must use xsd:import to reference common component schema modules.', '3b.svrl', $inFileName, /)"/>

      <let name="failmsg4b" value="fnx:expect-infile('XSDs in the patent namespace must use xsd:import to reference common component schema modules.', '4b.svrl', $inFileName, /)"/>
      <let name="failmsg5b" value="fnx:expect-infile('XSDs in the trademark namespace must use xsd:import to reference common component schema modules.', '5b.svrl', $inFileName, /)"/>
      <let name="failmsg6b" value="fnx:expect-infile('XSDs in the design namespace must use xsd:import to reference common component schema modules.', '6b.svrl', $inFileName, /)"/>

      <!-- Assertions -->
     

      <let name="failtest1" value="fnx:expect-infile-by-component('', '1b.svrl', $inFileName, /)"/>
      <report test="$failtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-01">
        <value-of select="fnx:rule-test-outcome(false(), $failtest1)"/>
      </report>
      <let name="failtest2" value="fnx:expect-infile-by-component('', '2b.svrl', $inFileName, /)"/>
      <report test="$failtest2 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-01">
        <value-of select="fnx:rule-test-outcome(false(), $failtest2)"/>
      </report>
      <!--<let name="failtest3" value="fnx:expect-infile-by-component('', '3b.svrl', $inFileName, /)"/>
      <report test="$failtest3 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-01">
        <value-of select="fnx:rule-test-outcome(false(), $failtest3)"/>
      </report>-->
      <let name="failtest4" value="fnx:expect-infile-by-component('', '4b.svrl', $inFileName, /)"/>
      <report test="$failtest4 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-01">
        <value-of select="fnx:rule-test-outcome(false(), $failtest4)"/>
      </report>
      <let name="failtest5" value="fnx:expect-infile-by-component('', '5b.svrl', $inFileName, /)"/>
      <report test="$failtest5 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-01">
        <value-of select="fnx:rule-test-outcome(false(), $failtest5)"/>
      </report>
      <let name="failtest6" value="fnx:expect-infile-by-component('', '6b.svrl', $inFileName, /)"/>
      <report test="$failtest6 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-01">
        <value-of select="fnx:rule-test-outcome(false(), $failtest6)"/>
      </report>
       <let name="passtest7" value="fnx:expect-infile-by-component('', '1.svrl', $inFileName, /)"/>
      <report test="$passtest7 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-01">
        <value-of select="fnx:rule-test-outcome(true(), $passtest7)"/>
      </report>
       <let name="passtest8" value="fnx:expect-infile-by-component('', '1c.svrl', $inFileName, /)"/>
      <report test="$passtest8 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-01">
        <value-of select="fnx:rule-test-outcome(true(), $passtest8)"/>
      </report>
      <let name="passtest9" value="fnx:expect-infile-by-component('', '2.svrl', $inFileName, /)"/>
      <report test="$passtest9 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-01">
        <value-of select="fnx:rule-test-outcome(true(), $passtest9)"/>
      </report>
      <let name="passtest10" value="fnx:expect-infile-by-component('', '2c.svrl', $inFileName, /)"/>
      <report test="$passtest10 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-01">
        <value-of select="fnx:rule-test-outcome(true(), $passtest10)"/>
      </report>
       <let name="passtest11" value="fnx:expect-infile-by-component('', '3.svrl', $inFileName, /)"/>
      <report test="$passtest11 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-01">
        <value-of select="fnx:rule-test-outcome(true(), $passtest11)"/>
      </report>
         <let name="passtest12" value="fnx:expect-infile-by-component('', '3c.svrl', $inFileName, /)"/>
      <report test="$passtest12 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-01">
        <value-of select="fnx:rule-test-outcome(true(), $passtest12)"/>
      </report>
               <let name="passtest13" value="fnx:expect-infile-by-component('', '4.svrl', $inFileName, /)"/>
      <report test="$passtest13 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-01">
        <value-of select="fnx:rule-test-outcome(true(), $passtest13)"/>
      </report>
               <let name="passtest14" value="fnx:expect-infile-by-component('', '4c.svrl', $inFileName, /)"/>
      <report test="$passtest14 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-01">
        <value-of select="fnx:rule-test-outcome(true(), $passtest14)"/>
      </report>
               <let name="passtest15" value="fnx:expect-infile-by-component('', '5.svrl', $inFileName, /)"/>
      <report test="$passtest15 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-01">
        <value-of select="fnx:rule-test-outcome(true(), $passtest15)"/>
      </report>
               <let name="passtest16" value="fnx:expect-infile-by-component('', '5c.svrl', $inFileName, /)"/>
      <report test="$passtest16 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-01">
        <value-of select="fnx:rule-test-outcome(true(), $passtest16)"/>
      </report>
               <let name="passtest17" value="fnx:expect-infile-by-component('', '6.svrl', $inFileName, /)"/>
      <report test="$passtest17 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-01">
        <value-of select="fnx:rule-test-outcome(true(), $passtest17)"/>
      </report>
               <let name="passtest18" value="fnx:expect-infile-by-component('', '6c.svrl', $inFileName, /)"/>
      <report test="$passtest18 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-01">
        <value-of select="fnx:rule-test-outcome(true(), $passtest18)"/>
      </report>
      <let name="failtest18" value="fnx:expect-infile-by-component('', '1d.svrl', $inFileName, /)"/>
      <report test="$failtest18 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#SD-01">
        <value-of select="fnx:rule-test-outcome(false(), $failtest18)"/>
      </report>
      
    </rule>

	</pattern>
<diagnostics><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>