<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
    <pattern>
		<title>GD-33</title>
    <rule context="svrl:schematron-output" role="ERROR">
      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>
      <let name="failtest1" value="fnx:expect-infile-by-component('','Bad_V1_0_t3.svrl', $inFileName, /)"/>
      <report test="$failtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-33">
        <value-of select="fnx:rule-test-outcome(false(), $failtest1)"/>
      </report>
      <let name="failtest2" value="fnx:expect-infile-by-component('','Bad_1_0_T3.svrl', $inFileName, /)"/>
      <report test="$failtest2 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-33">
        <value-of select="fnx:rule-test-outcome(false(), $failtest2)"/>
      </report>
      <let name="failtest3" value="fnx:expect-infile-by-component('','BadComponent_V1_0_T2.svrl', $inFileName, /)"/>
      <report test="$failtest3 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-33">
        <value-of select="fnx:rule-test-outcome(false(), $failtest3)"/>
      </report>
      <let name="failtest4" value="fnx:expect-infile-by-component('','Bad_T1.svrl',$inFileName,/)"/>
      <report test="$failtest4 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-33">
        <value-of select="fnx:rule-test-outcome(false(), $failtest4)"/>
      </report>
      <let name="passtest5" value="fnx:expect-infile-by-component('','Good_V1_0_T2.svrl',$inFileName,/)"/>
      <report test="$passtest5 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-33">
        <value-of select="fnx:rule-test-outcome(true(), $passtest5)"/>
      </report>

    </rule>
    </pattern>
<diagnostics><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>