<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>GD-32</title>
    <rule context="svrl:schematron-output" role="ERROR">
      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

      <let name="failMsgSuffix" value="'{_V&#x003C;MajorVersionNumber&#x003E;_&#x003C;MinorVersionNumber&#x003E;_D&#x003C;RevisionNumber&#x003E;}.&#x003C;FileExtension&#x003E;'"/>

      <let name="failmsg1" value="fnx:expect-infile(concat('The file name Bad_1_0_D3.xsd does not follow the required format for drafts: &#x003C;Bad&#x003E;', $failMsgSuffix), 'Bad_1_0_D3.svrl', $inFileName, /)"/>
      <let name="failmsg2" value="fnx:expect-infile(concat('The file name Bad_V1_0_d3.xsd does not follow the required format for drafts: &#x003C;Bad&#x003E;', $failMsgSuffix), 'Bad_V1_0_d3.svrl', $inFileName, /)"/>
      <let name="failmsg3" value="fnx:expect-infile(concat('The file name Bad_V1_0_draft.xsd does not follow the required format for drafts: &lt;DummyText&gt;', $failMsgSuffix), 'Bad_V1_0_draft.svrl', $inFileName, /)"/>
      <let name="failmsg4" value="fnx:expect-infile('The version in XSD name Bad_V1_0_D2.xsd (V1_0) is inconsistent with the version given by schema/@version (V2_0).', 'Bad_V1_0_D2.svrl', $inFileName, /)"/>
      <!--
                           TODO:  check schema@version for consistency too
      -->

      <!-- Assertions -->
      <let name="passtest1" value="fnx:expect-infile-by-component('', 'Good_D1.svrl', $inFileName, /)"/>
      <report test="$passtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-32">
        <value-of select="fnx:rule-test-outcome(true(), $passtest1)"/>
      </report>
      <let name="passtest2" value="fnx:expect-infile-by-component('', 'Good_V1_0_D2.svrl', $inFileName, /)"/>
      <report test="$passtest2 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-32">
        <value-of select="fnx:rule-test-outcome(true(), $passtest2)"/>
      </report>
      <let name="failtest3" value="fnx:expect-infile-by-component('', 'Bad_1_0_D3.svrl', $inFileName, /)"/>
      <report test="$failtest3 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-32">
        <value-of select="fnx:rule-test-outcome(false(), $failtest3)"/>
      </report>
      <let name="failtest4" value="fnx:expect-infile-by-component('', 'Bad_V1_0_d3.svrl', $inFileName, /)"/>
      <report test="$failtest4 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-32">
        <value-of select="fnx:rule-test-outcome(false(), $failtest4)"/>
      </report>
      <let name="failtest5" value="fnx:expect-infile-by-component('', 'Bad_V1_0_draft.svrl', $inFileName, /)"/>
      <report test="$failtest5 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-32">
        <value-of select="fnx:rule-test-outcome(false(), $failtest5)"/>
      </report>
      <let name="failtest6" value="fnx:expect-infile-by-component('', 'Bad_V1_0_D2.svrl', $inFileName, /)"/>
      <report test="$failtest6 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-32">
        <value-of select="fnx:rule-test-outcome(false(), $failtest6)"/>
      </report>

    </rule>
	</pattern>
<diagnostics><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>