<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>GD-31</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>

      <let name="failmsg1" value="fnx:expect-infile('The file name Bad_V1.0.xsd does not follow the required format &#x003C;Bad&#x003E;{_V&#x003C;MajorVersionNumber&#x003E;_&#x003C;MinorVersionNumber&#x003E;_&#x003C;OptionalPatchVersionNumber&#x003E;}.&#x003C;FileExtension&#x003E;', 'Bad_V1.0.svrl', $inFileName, /)"/>
      <let name="failmsg2" value="fnx:expect-infile('The file name Bad_1_0.xsd does not follow the required format &#x003C;Bad&#x003E;{_V&#x003C;MajorVersionNumber&#x003E;_&#x003C;MinorVersionNumber&#x003E;_&#x003C;OptionalPatchVersionNumber&#x003E;}.&#x003C;FileExtension&#x003E;', 'Bad_1_0.svrl', $inFileName, /)"/>
      <let name="failmsg3" value="fnx:expect-infile('The file name DesignClaimBagTextType.xsd does not follow the required format &#x003C;DesignClaimTextBagType&#x003E;{_V&#x003C;MajorVersionNumber&#x003E;_&#x003C;MinorVersionNumber&#x003E;_&#x003C;OptionalPatchVersionNumber&#x003E;}.&#x003C;FileExtension&#x003E;', 'DesignClaimBagTextType.svrl', $inFileName, /)"/>
      <let name="failmsg4" value="fnx:expect-infile('The file name Bad_V3_2_2.xsd does not follow the required format &lt;DummyText>{_V&lt;MajorVersionNumber>_&lt;MinorVersionNumber>_&lt;OptionalPatchVersionNumber>}.&lt;FileExtension>', 'Bad_V3_2_2.svrl', $inFileName, /)"/>
      <let name="failmsg5" value="fnx:expect-infile('The file name BibliographicData_V1_0.xsd does not match the @version attribute value V4_2', 'BibliographicData_V1_0.svrl', $inFileName, /)"/>

      <!-- Assertions -->
      <let name="failtest1" value="fnx:expect-infile-by-component('', 'Bad_1_0.svrl', $inFileName, /)"/>
      <report test="$failtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-31">
        <value-of select="fnx:rule-test-outcome(false(), $failtest1)"/>
      </report>

      <let name="failtest2" value="fnx:expect-infile-by-component('', 'Bad_1.0.svrl', $inFileName, /)"/>
      <report test="$failtest2 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-31">
        <value-of select="fnx:rule-test-outcome(false(), $failtest2)"/>
      </report>

      <let name="failtest3" value="fnx:expect-infile-by-component('', 'Bad_3_2_2.svrl', $inFileName, /)"/>
      <report test="$failtest3 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-31">
        <value-of select="fnx:rule-test-outcome(false(), $failtest3)"/>
      </report>
      
        <let name="failtest4" value="fnx:expect-infile-by-component('', 'DesignClaimBagTextType.svrl', $inFileName, /)"/>
      <report test="$failtest4 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-31">
        <value-of select="fnx:rule-test-outcome(false(), $failtest4)"/>
      </report>
      
      <let name="passtest5" value="fnx:expect-infile-by-component('', 'Good.svrl', $inFileName, /)"/>
      <report test="$passtest5 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-31">
        <value-of select="fnx:rule-test-outcome(true(), $passtest5)"/>
      </report>
       <let name="passtest6" value="fnx:expect-infile-by-component('', 'Good_V1_0.svrl', $inFileName, /)"/>
      <report test="$passtest6 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-31">
        <value-of select="fnx:rule-test-outcome(true(), $passtest6)"/>
      </report>
      <let name="passtest7" value="fnx:expect-infile-by-component('', 'Good_V1_0_D1.svrl', $inFileName, /)"/>
      <report test="$passtest7 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-31">
        <value-of select="fnx:rule-test-outcome(true(), $passtest7)"/>
      </report>
          <let name="passtest8" value="fnx:expect-infile-by-component('', 'BadDraft.svrl', $inFileName, /)"/>
      <report test="$passtest8 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-31">
        <value-of select="fnx:rule-test-outcome(false(), $passtest8)"/>
      </report>
         <let name="passtest9" value="fnx:expect-infile-by-component('', 'GoodPatch_V4_2_1.svrl', $inFileName, /)"/>
      <report test="$passtest9 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-31">
        <value-of select="fnx:rule-test-outcome(true(), $passtest9)"/>
      </report>
      <let name="failtest10" value="fnx:expect-infile-by-component('', 'BibliographicData_V1_0.svrl', $inFileName, /)"/>
      <report test="$failtest10 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-31">
        <value-of select="fnx:rule-test-outcome(false(), $failtest10)"/>
      </report>

    </rule>
	</pattern>
<diagnostics><diagnostic id="GD-31"/><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>