<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
  <!-- "the term component refers to type, element or attribute" -->

	<pattern>
		<title>GD-27</title>

    <rule context="svrl:schematron-output" role="WARNING">
      <let name="failmsg1" value="fnx:expect(&quot;Name of element BadAndWorse contains the connecting word(s) And.&quot;, /)"/>
      <let name="failmsg2" value="fnx:expect(&quot;Name of element FigureOfSpeech contains the connecting word(s) Of.&quot;, /)"/>
      <let name="failmsg3" value="fnx:expect(&quot;Name of element BreakTheRule contains the connecting word(s) The.&quot;, /)"/>
      <let name="failmsg4" value="fnx:expect(&quot;Name of element TheViolationIsFirst contains the connecting word(s) The.&quot;, /)"/>


      <!-- Assertions -->
      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>
      <let name="passtest1" value="fnx:expect-infile-by-component('Good', '1.svrl', $inFileName, /)"/>
      <report test="$passtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-27">
        <value-of select="fnx:rule-test-outcome(true(), $passtest1)"/>
      </report>
      <let name="passtest2" value="fnx:expect-infile-by-component('BadandWorse', '2.svrl', $inFileName, /)"/>
      <report test="$passtest2 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-27">
        <value-of select="fnx:rule-test-outcome(true(), $passtest2)"/>
      </report>


      <let name="failtest3" value="fnx:expect-infile-by-component('BadAndWorse', '3.svrl', $inFileName, /)"/>
      <report test="$failtest3 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-27">
        <value-of select="fnx:rule-test-outcome(false(), $failtest3)"/>
      </report>

      <let name="failtest4" value="fnx:expect-infile-by-component('FigureOfSpeech', '3.svrl', $inFileName, /)"/>
      <report test="$failtest4 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-27">
        <value-of select="fnx:rule-test-outcome(false(), $failtest4)"/>
      </report>
      <let name="failtest5" value="fnx:expect-infile-by-component('BreakTheRule', '3.svrl', $inFileName, /)"/>
      <report test="$failtest5 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-27">
        <value-of select="fnx:rule-test-outcome(false(), $failtest5)"/>
      </report>
      <let name="failtest6" value="fnx:expect-infile-by-component('TheViolationIsFirst', '3.svrl', $inFileName, /)"/>
      <report test="$failtest6 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-27">
        <value-of select="fnx:rule-test-outcome(false(), $failtest6)"/>
      </report>
    </rule>
	</pattern>
<diagnostics><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>
