<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
  <!-- "the term component refers to type, element or attribute" -->

  <pattern>
    <title>GD-26</title>

    <rule context="svrl:schematron-output" role="WARNING">
      <let name="failmsg1" value="fnx:expect(&quot;The &apos;BList&apos; element is a collection, but its name lacks a &apos;Bag&apos; suffix.&quot;, /)"/>
      <let name="failmsg2" value="fnx:expect(&quot;The &apos;CBag&apos; element is not a collection, but its name has a &apos;Bag&apos; suffix.&quot;, /)"/>
      <let name="failmsg3" value="fnx:expect(&quot;The &apos;DBagType&apos; simpleType is not a collection, but its name has a &apos;BagType&apos; suffix.&quot;, /)"/>
      <let name="failmsg4" value="fnx:expect(&quot;The &apos;FType&apos; complexType is a collection, but its name lacks a &apos;BagType&apos; suffix.&quot;, /)"/>
      <let name="failmsg5" value="fnx:expect(&quot;The &apos;GBagType&apos; complexType is not a collection, but its name has a &apos;BagType&apos; suffix.&quot;, /)"/>
      <let name="failmsg8" value="fnx:expect(&quot;The &apos;NBag&apos; element is not a collection, but its name has a &apos;Bag&apos; suffix.&quot;, /)"/>
      <let name="failmsg9" value="fnx:expect(&quot;The &apos;OBagType&apos; complexType is not a collection, but its name has a &apos;BagType&apos; suffix.&quot;, /)"/>
      <let name="failmsg10" value="fnx:expect(&quot;The &apos;BoundaryData2BagType&apos; complexType is not a collection, but its name has a &apos;BagType&apos; suffix.&quot;, /)"/>



      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>
      <let name="failtest1" value="fnx:expect-infile-by-component('BList', '1.svrl', $inFileName, /)"/>
      <report test="$failtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-26">
        <value-of select="fnx:rule-test-outcome(false(), $failtest1)"/>
      </report>
      <let name="failtest2" value="fnx:expect-infile-by-component('CBag', '1.svrl', $inFileName, /)"/>
      <report test="$failtest2 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-26">
        <value-of select="fnx:rule-test-outcome(false(), $failtest2)"/>
      </report>
      <let name="failtest3" value="fnx:expect-infile-by-component('DBagType', '1.svrl', $inFileName, /)"/>
      <report test="$failtest3 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-26">
        <value-of select="fnx:rule-test-outcome(false(), $failtest3)"/>
      </report>
      <let name="failtest4" value="fnx:expect-infile-by-component('FType', '1.svrl', $inFileName, /)"/>
      <report test="$failtest4 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-26">
        <value-of select="fnx:rule-test-outcome(false(), $failtest4)"/>
      </report>
      <let name="failtest5" value="fnx:expect-infile-by-component('GBagType', '1.svrl', $inFileName, /)"/>
      <report test="$failtest5 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-26">
        <value-of select="fnx:rule-test-outcome(false(), $failtest5)"/>
      </report>
      <let name="failtest6" value="fnx:expect-infile-by-component('HType', '1.svrl', $inFileName, /)"/>
      <report test="$failtest6 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-26">
        <value-of select="fnx:rule-test-outcome(false(), $failtest6)"/>
      </report>
      <let name="failtest7" value="fnx:expect-infile-by-component('NBag', '1.svrl', $inFileName, /)"/>
      <report test="$failtest7 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-26">
        <value-of select="fnx:rule-test-outcome(false(), $failtest7)"/>
      </report>
      <let name="failtest8" value="fnx:expect-infile-by-component('OBagType', '1.svrl', $inFileName, /)"/>
      <report test="$failtest8 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-26">
        <value-of select="fnx:rule-test-outcome(false(), $failtest8)"/>
      </report>
      <let name="failtest9" value="fnx:expect-infile-by-component('BoundaryData2BagType', '1.svrl', $inFileName, /)"/>
      <report test="$failtest9 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-26">
        <value-of select="fnx:rule-test-outcome(false(), $failtest9)"/>
      </report>

      <let name="passtest10" value="fnx:expect-infile-by-component('ABag', '2.svrl', $inFileName, /)"/>
      <report test="$passtest10 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-26">
        <value-of select="fnx:rule-test-outcome(true(), $passtest10)"/>
      </report>
      <let name="passtest11" value="fnx:expect-infile-by-component('EBagType', '3.svrl', $inFileName, /)"/>
      <report test="$passtest11 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-26">
        <value-of select="fnx:rule-test-outcome(true(), $passtest11)"/>
      </report>
      <let name="passtest12" value="fnx:expect-infile-by-component('HIBagType', '4.svrl', $inFileName, /)"/>
      <report test="$passtest12 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-26">
        <value-of select="fnx:rule-test-outcome(true(), $passtest12)"/>
      </report>
      <let name="passtest13" value="fnx:expect-infile-by-component('IBagType', '5.svrl', $inFileName, /)"/>
      <report test="$passtest13 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-26">
        <value-of select="fnx:rule-test-outcome(true(), $passtest13)"/>
      </report>
      <let name="passtest14" value="fnx:expect-infile-by-component('LBag', '6.svrl', $inFileName, /)"/>
      <report test="$passtest14 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-26">
        <value-of select="fnx:rule-test-outcome(true(), $passtest14)"/>
      </report>
      <let name="passtest15" value="fnx:expect-infile-by-component('MBag', '7.svrl', $inFileName, /)"/>
      <report test="$passtest15 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-26">
        <value-of select="fnx:rule-test-outcome(true(), $passtest15)"/>
      </report>
      <let name="passtest16" value="fnx:expect-infile-by-component('BoundaryDataBagType', '8.svrl', $inFileName, /)"/>
      <report test="$passtest16 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-26">
        <value-of select="fnx:rule-test-outcome(true(), $passtest16)"/>
      </report>
    </rule>
  </pattern>
<diagnostics><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>
