<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
  <!-- "the term component refers to type, element or attribute" -->

	<pattern>
		<title>GD-23</title>
    <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>
    <rule context="svrl:schematron-output" role="ERROR">

      <let name="failmsg0" value="fnx:expect-infile('E0Text must have Amount as a representation term, not Text.', '1.svrl', $inFileName, /)"/>
      <let name="failmsg1" value="fnx:expect-infile('E1Rate must have Category, Code, Identifier, Number, Text or Name as a representation term, not Rate.', '1.svrl', $inFileName, /)"/>
      <let name="failmsg2" value="fnx:expect-infile('E2Percent must have Category, Code, Identifier, Number, Text or Name as a representation term, not Percent.', '1.svrl', $inFileName, /)"/>
      <let name="failmsg3" value="fnx:expect-infile('E3Time must have Date as a representation term, not Time.', '1.svrl', $inFileName, /)"/>
      <let name="failmsg4" value="fnx:expect-infile('E4Time must have Date as a representation term, not Time.', '1.svrl', $inFileName, /)"/>
      <!--      <let name="failmsg5" value="fnx:expect-infile('E5Text must have Category, Code, Identifier or Number as a representation term, not Text.', '1.svrl', $inFileName, /)"/>-->
      <let name="failmsg6" value="fnx:expect-infile('E6Identifier must have Indicator as a representation term, not Identifier.', '1.svrl', $inFileName, /)"/>
      <let name="failmsg7" value="fnx:expect-infile('E7Rate must have Measure as a representation term, not Rate.', '1.svrl', $inFileName, /)"/>
      <let name="failmsg8" value="fnx:expect-infile('E8Quantity must have Text, Name, Number, Identifier or Category as a representation term, not Quantity.', '1.svrl', $inFileName, /)"/>
      <let name="failmsg9" value="fnx:expect-infile('E9URI must have Number as a representation term, not URI.', '1.svrl', $inFileName, /)"/>
      <let name="failmsg10" value="fnx:expect-infile('E10Percent must have Text, Name, Number, Identifier or Category as a representation term, not Percent.', '1.svrl', $inFileName, /)"/>
      <!--      <let name="failmsg11" value="fnx:expect-infile('E11Text must have Category, Code, Identifier or Number as a representation term, not Text.', '1.svrl', $inFileName, /)"/>-->
      <let name="failmsg12" value="fnx:expect-infile('E12Category must have Percent, Rate or Quantity as a representation term, not Category.', '1.svrl', $inFileName, /)"/>
      <let name="failmsg13" value="fnx:expect-infile('E13 must have Quantity as a representation term, but it has none.', '1.svrl', $inFileName, /)"/>
      <let name="failmsg14" value="fnx:expect-infile('E14 must have Quantity as a representation term, but it has none.', '1.svrl', $inFileName, /)"/>
      <let name="failmsg15" value="fnx:expect-infile('E15 must have Percent, Rate or Quantity as a representation term, but it has none.', '1.svrl', $inFileName, /)"/>
      <let name="failmsg16" value="fnx:expect-infile('E16 must have Text, Name, Number, Identifier or Category as a representation term, but it has none.', '1.svrl', $inFileName, /)"/>
      <let name="failmsg17" value="fnx:expect-infile('E17 must have Text, Name or Number as a representation term, but it has none.', '1.svrl', $inFileName, /)"/>
      <let name="failmsg18" value="fnx:expect-infile('E18 must have Time as a representation term, but it has none.', '1.svrl', $inFileName, /)"/>
      <let name="failmsg19" value="fnx:expect-infile('E19 must have DateTime as a representation term, but it has none.', '1.svrl', $inFileName, /)"/>
      <let name="failmsg20" value="fnx:expect-infile('E20 must have URI as a representation term, but it has none.', '1.svrl', $inFileName, /)"/>
      <let name="failmsg21" value="fnx:expect-infile('CategoryKind must have Category, Code, Identifier or Number as a representation term, but it has none.', '1.svrl', $inFileName, /)"/>
      <!-- Assertions -->

      <let name="failtest1" value="fnx:expect-infile-by-component('E0Text', '1.svrl', $inFileName, /)"/>
      <report test="$failtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest1)"/>
      </report>
      <let name="failtest2" value="fnx:expect-infile-by-component('E1Rate', '1.svrl', $inFileName, /)"/>
      <report test="$failtest2 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest2)"/>
      </report>
      <let name="failtest3" value="fnx:expect-infile-by-component('E2Percent', '1.svrl', $inFileName, /)"/>
      <report test="$failtest3 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest3)"/>
      </report>
      <let name="failtest4" value="fnx:expect-infile-by-component('E3Time', '1.svrl', $inFileName, /)"/>
      <report test="$failtest4 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest4)"/>
      </report>
      <let name="failtest5" value="fnx:expect-infile-by-component('E4Time', '1.svrl', $inFileName, /)"/>
      <report test="$failtest5 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest5)"/>
      </report>
      <let name="failtest6" value="fnx:expect-infile-by-component('E6Identifier', '1.svrl', $inFileName, /)"/>
      <report test="$failtest6 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest6)"/>
      </report>
      <let name="failtest7" value="fnx:expect-infile-by-component('E7Rate', '1.svrl', $inFileName, /)"/>
      <report test="$failtest7 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest7)"/>
      </report>
      <let name="failtest8" value="fnx:expect-infile-by-component('E8Quantity', '1.svrl', $inFileName, /)"/>
      <report test="$failtest8 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest8)"/>
      </report>
      <let name="failtest9" value="fnx:expect-infile-by-component('E9URI', '1.svrl', $inFileName, /)"/>
      <report test="$failtest9 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest9)"/>
      </report>
      <let name="failtest10" value="fnx:expect-infile-by-component('E10Percent', '1.svrl', $inFileName, /)"/>
      <report test="$failtest10 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest10)"/>
      </report>
      <let name="failtest11" value="fnx:expect-infile-by-component('E12Category', '1.svrl', $inFileName, /)"/>
      <report test="$failtest11 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest11)"/>
      </report>
      
      <let name="failtest12" value="fnx:expect-infile-by-component('E13', '1.svrl', $inFileName, /)"/>
      <report test="$failtest12 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest12)"/>
      </report>
      <let name="failtest13" value="fnx:expect-infile-by-component('E14', '1.svrl', $inFileName, /)"/>
      <report test="$failtest13 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest13)"/>
      </report>
      <let name="failtest14" value="fnx:expect-infile-by-component('E15', '1.svrl', $inFileName, /)"/>
      <report test="$failtest14 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest14)"/>
      </report>
      <let name="failtest15" value="fnx:expect-infile-by-component('E16', '1.svrl', $inFileName, /)"/>
      <report test="$failtest15 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest15)"/>
      </report>
      <let name="failtest16" value="fnx:expect-infile-by-component('E17', '1.svrl', $inFileName, /)"/>
      <report test="$failtest16 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest16)"/>
      </report>
      <let name="failtest17" value="fnx:expect-infile-by-component('E18', '1.svrl', $inFileName, /)"/>
      <report test="$failtest17 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest17)"/>
      </report>
      <let name="failtest18" value="fnx:expect-infile-by-component('E19', '1.svrl', $inFileName, /)"/>
      <report test="$failtest18 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest18)"/>
      </report>
      <let name="failtest19" value="fnx:expect-infile-by-component('E20', '1.svrl', $inFileName, /)"/>
      <report test="$failtest19 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest19)"/>
      </report>
     <!-- <let name="failtest20" value="fnx:expect-infile-by-component('CategoryKind', '1.svrl', $inFileName, /)"/>
      <report test="$failtest20 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest20)"/>
      </report>-->
      
      <let name="passtest21" value="fnx:expect-infile-by-component('E1Date','2.svrl',$inFileName,/)"/>
      <report test="$passtest21 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(true(), $passtest21)"/>
      </report>
      <let name="passtest22" value="fnx:expect-infile-by-component('EAmount','3.svrl',$inFileName,/)"/>
      <report test="$passtest22 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(true(), $passtest22)"/>
      </report>
      <let name="passtest23" value="fnx:expect-infile-by-component('E1Category','4.svrl',$inFileName,/)"/>
      <report test="$passtest23 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(true(), $passtest23)"/>
      </report>
      <let name="passtest24" value="fnx:expect-infile-by-component('E2Date','5.svrl',$inFileName,/)"/>
      <report test="$passtest24 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(true(), $passtest24)"/>
      </report>
      <let name="passtest25" value="fnx:expect-infile-by-component('EIdentifier','6.svrl',$inFileName,/)"/>
      <report test="$passtest25 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(true(), $passtest25)"/>
      </report>
      
      <let name="passtest26" value="fnx:expect-infile-by-component('EIndicator','7.svrl',$inFileName,/)"/>
      <report test="$passtest26 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(true(), $passtest26)"/>
      </report>
       <let name="passtest27" value="fnx:expect-infile-by-component('EMeasure','8.svrl',$inFileName,/)"/>
      <report test="$passtest27 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(true(), $passtest27)"/>
      </report>
       <let name="passtest28" value="fnx:expect-infile-by-component('EName','9.svrl',$inFileName,/)"/>
      <report test="$passtest28 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(true(), $passtest28)"/>
      </report>
       <let name="passtest29" value="fnx:expect-infile-by-component('E1Number','10.svrl',$inFileName,/)"/>
      <report test="$passtest29 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(true(), $passtest29)"/>
      </report>
       <let name="passtest30" value="fnx:expect-infile-by-component('E2Number','11.svrl',$inFileName,/)"/>
      <report test="$passtest30 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(true(), $passtest30)"/>
      </report>
       <let name="passtest31" value="fnx:expect-infile-by-component('E3Number','12.svrl',$inFileName,/)"/>
      <report test="$passtest31 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(true(), $passtest31)"/>
      </report>
       <let name="passtest32" value="fnx:expect-infile-by-component('EPercent','13.svrl',$inFileName,/)"/>
      <report test="$passtest32 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(true(), $passtest32)"/>
      </report>
       <let name="passtest33" value="fnx:expect-infile-by-component('E1Quantity','14.svrl',$inFileName,/)"/>
      <report test="$passtest33 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(true(), $passtest33)"/>
      </report>
       <let name="passtest34" value="fnx:expect-infile-by-component('E2Quantity','15.svrl',$inFileName,/)"/>
      <report test="$passtest34 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(true(), $passtest34)"/>
      </report>
       <let name="passtest35" value="fnx:expect-infile-by-component('ERate','16.svrl',$inFileName,/)"/>
      <report test="$passtest35 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(true(), $passtest35)"/>
      </report>
      
      <let name="passtest36" value="fnx:expect-infile-by-component('E1Text','17.svrl',$inFileName,/)"/>
      <report test="$passtest36 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(true(), $passtest36)"/>
      </report>
      <let name="passtest37" value="fnx:expect-infile-by-component('E2Text','18.svrl',$inFileName,/)"/>
      <report test="$passtest37 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(true(), $passtest37)"/>
      </report>
      <let name="passtest38" value="fnx:expect-infile-by-component('ETime','19.svrl',$inFileName,/)"/>
      <report test="$passtest38 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(true(), $passtest38)"/>
      </report>
      <let name="passtest39" value="fnx:expect-infile-by-component('EDateTime','20.svrl',$inFileName,/)"/>
      <report test="$passtest39 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(true(), $passtest39)"/>
      </report>
      <let name="passtest40" value="fnx:expect-infile-by-component('E_URI','21.svrl',$inFileName,/)"/>
      <report test="$passtest40 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(true(), $passtest40)"/>
      </report>
      
      <let name="passtest41" value="fnx:expect-infile-by-component('NonBasicElementWithoutRepresentationTerm','22.svrl',$inFileName,/)"/>
      <report test="$passtest41 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(true(), $passtest41)"/>
      </report>
      <let name="passtest42" value="fnx:expect-infile-by-component('NonBasicElementWithoutRepresentationTermText','23.svrl',$inFileName,/)"/>
      <report test="$passtest42 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(true(), $passtest42)"/>
      </report>
      <let name="passtest43" value="fnx:expect-infile-by-component('E5Text','24.svrl',$inFileName,/)"/>
      <report test="$passtest43 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(true(), $passtest43)"/>
      </report>
      
      <let name="failtest44" value="fnx:expect-infile-by-component('IPRightDurationPeriod','IPRightDurationPeriod.svrl',$inFileName,/)"/>
      <report test="$failtest44 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest44)"/>
      </report>
      
      <let name="failtest45" value="fnx:expect-infile-by-component('GIApplicantGroupID','GIApplicantGroupID.svrl',$inFileName,/)"/>
      <report test="$failtest45 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest45)"/>
      </report>
      <let name="failtest46" value="fnx:expect-infile-by-component('ProductionMaximumAmountQuantity','ProductionMaximumAmountQuantity.svrl',$inFileName,/)"/>
      <report test="$failtest46 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest46)"/>
      </report>
      <let name="failtest47" value="fnx:expect-infile-by-component('SequenceCancelledIdentifier','SequenceCancelledIdentifier.svrl',$inFileName,/)"/>
      <report test="$failtest47 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest47)"/>
      </report>
      
         <let name="passtest44" value="fnx:expect-infile-by-component('endnoteNumber','endnoteNumber.svrl',$inFileName,/)"/>
      <report test="$passtest44 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(true(), $passtest44)"/>
      </report>
      
      <let name="failtest48" value="fnx:expect-infile-by-component('BadDuration','25.svrl',$inFileName,/)"/>
      <report test="$failtest48 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-23">
        <value-of select="fnx:rule-test-outcome(false(), $failtest48)"/>
      </report>
    </rule>

	</pattern>
<diagnostics><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>
