<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>GD-14</title>
    <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>
<!-- need to update these use cases due to new method of splitting by camelcase...-->
    <rule context="svrl:schematron-output" role="ERROR">
      <let name="passtest1" value="fnx:expect-infile-by-component('NoAbbreviationsAnyway', '1.svrl', $inFileName, /)"/>
      <report test="$passtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-14">
        <value-of select="fnx:rule-test-outcome(true(), $passtest1)"/>
      </report>
       <let name="passtest2" value="fnx:expect-infile-by-component('AltThis', '2.svrl', $inFileName, /)"/>
      <report test="$passtest2 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-14">
        <value-of select="fnx:rule-test-outcome(true(), $passtest2)"/>
      </report>
      <let name="passtest3" value="fnx:expect-infile-by-component('HasIButIsGoodAnyway', '3.svrl', $inFileName, /)"/>
      <report test="$passtest3 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-14">
        <value-of select="fnx:rule-test-outcome(true(), $passtest3)"/>
      </report>
         <let name="failtest4" value="fnx:expect-infile-by-component('ISOthis', '4.svrl', $inFileName, /)"/>
      <report test="$failtest4 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-14">
        <value-of select="fnx:rule-test-outcome(false(), $failtest4)"/>
      </report>
      <let name="passtest5" value="fnx:expect-infile-by-component('SomeBioDepositThing', '5.svrl', $inFileName, /)"/>
      <report test="$passtest5 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-14">
        <value-of select="fnx:rule-test-outcome(true(), $passtest5)"/>
      </report>
      
      <let name="failtest6" value="fnx:expect-infile-by-component('isoThis', '6.svrl', $inFileName, /)"/>
      <report test="$failtest6 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-14">
        <value-of select="fnx:rule-test-outcome(false(), $failtest6)"/>
      </report>
      
      <let name="failtest7" value="fnx:expect-infile-by-component('IsOthis', '6.svrl', $inFileName, /)"/>
      <!--<report test="$failtest7 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-14">
        <value-of select="fnx:rule-test-outcome(false(), $failtest7)"/>
      </report>-->
      
       <let name="failtest8" value="fnx:expect-infile-by-component('Isothis', '6.svrl', $inFileName, /)"/>
      <!--<report test="$failtest8 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-14">
        <value-of select="fnx:rule-test-outcome(false(), $failtest8)"/>
      </report>-->
      
        <let name="failtest9" value="fnx:expect-infile-by-component('HasLoweriso', '6.svrl', $inFileName, /)"/>
      <!--<report test="$failtest9 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-14">
        <value-of select="fnx:rule-test-outcome(false(), $failtest9)"/>
      </report>-->
      
        <let name="failtest10" value="fnx:expect-infile-by-component('HasCapitalizedIso', '6.svrl', $inFileName, /)"/>
      <report test="$failtest10 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-14">
        <value-of select="fnx:rule-test-outcome(false(), $failtest10)"/>
      </report>
      
      <let name="failtest11" value="fnx:expect-infile-by-component('CPCAbccpc', '6.svrl', $inFileName, /)"/>
      <!--<report test="$failtest11 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-14">
        <value-of select="fnx:rule-test-outcome(false(), $failtest11)"/>
      </report>-->
      <let name="failtest12" value="fnx:expect-infile-by-component('CPCAbccpciso', '6.svrl', $inFileName, /)"/>
      <!--<report test="$failtest12 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-14">
        <value-of select="fnx:rule-test-outcome(false(), $failtest12)"/>
      </report>-->
    </rule>
	</pattern>
<diagnostics><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>
