<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
  <!-- "the term component refers to type, element or attribute" -->

	<pattern>
		<title>GD-07</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>


      <let name="passtest1" value="fnx:expect-infile-by-component('ThisElementNameHas34CharactersAAAA', '1.svrl', $inFileName, /)"/>
      <report test="$passtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-07">
        <value-of select="fnx:rule-test-outcome(true(), $passtest1)"/>
      </report>

      <let name="failtest2" value="fnx:expect-infile-by-component('ThisElementNameHas36CharactersAAAAAA', '2.svrl', $inFileName, /)"/>
      <report test="$failtest2 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-07">
        <value-of select="fnx:rule-test-outcome(false(), $failtest2)"/>
      </report>

      <let name="failtest3" value="fnx:expect-infile-by-component('ThisAttributeNameHas36CharactersAAAA', '2.svrl', $inFileName, /)"/>
      <report test="$failtest3 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-07">
        <value-of select="fnx:rule-test-outcome(false(), $failtest3)"/>
      </report>
      <let name="failtest4" value="fnx:expect-infile-by-component('ThisSimpleTypeNameHas41CharactersAAAAAAAA', '2.svrl', $inFileName, /)"/>
      <report test="$failtest4 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-07">
        <value-of select="fnx:rule-test-outcome(false(), $failtest4)"/>
      </report>
      <let name="failtest5" value="fnx:expect-infile-by-component('ThisComplexTypeNameHas40Characters123456', '2.svrl', $inFileName, /)"/>
      <report test="$failtest5 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-07">
        <value-of select="fnx:rule-test-outcome(false(), $failtest5)"/>
      </report>

      <let name="passtest6" value="fnx:expect-infile-by-component('ThisAttributeNameHas34CharactersAA', '3.svrl', $inFileName, /)"/>
      <report test="$passtest6 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-07">
        <value-of select="fnx:rule-test-outcome(true(), $passtest6)"/>
      </report>
      <let name="passtest7" value="fnx:expect-infile-by-component('ThisSimpleTypeNameHas34CharactersA', '4.svrl', $inFileName, /)"/>
      <report test="$passtest7 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-07">
        <value-of select="fnx:rule-test-outcome(true(), $passtest7)"/>
      </report>
      <let name="passtest8" value="fnx:expect-infile-by-component('ThisComplexTypeNameHas34Characters', '5.svrl', $inFileName, /)"/>
      <report test="$passtest8 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-07">
        <value-of select="fnx:rule-test-outcome(true(), $passtest8)"/>
      </report>
      <let name="passtest9" value="fnx:expect-infile-by-component('ThisElementNameHas35CharactersAAAAA', '6.svrl', $inFileName, /)"/>
      <report test="$passtest9 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-07">
        <value-of select="fnx:rule-test-outcome(true(), $passtest9)"/>
      </report>
      <let name="passtest10" value="fnx:expect-infile-by-component('ThisAttributeNameHas35CharactersAAA', '7.svrl', $inFileName, /)"/>
      <report test="$passtest10 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-07">
        <value-of select="fnx:rule-test-outcome(true(), $passtest10)"/>
      </report>
      <let name="passtest11" value="fnx:expect-infile-by-component('ThisSimpleTypeNameHas35CharactersAA', '8.svrl', $inFileName, /)"/>
      <report test="$passtest11 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-07">
        <value-of select="fnx:rule-test-outcome(true(), $passtest11)"/>
      </report>
      <let name="passtest12" value="fnx:expect-infile-by-component('ThisComplexTypeNameHas35CharactersA', '9.svrl', $inFileName, /)"/>
      <report test="$passtest12 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-07">
        <value-of select="fnx:rule-test-outcome(true(), $passtest12)"/>
      </report>
      <let name="passtest13" value="fnx:expect-infile-by-component('ThisComplexTypeNameHas39CharactersAAAAA','2.svrl',$inFileName,/)"/>
      <report test="$passtest13 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-07">
        <value-of select="fnx:rule-test-outcome(true(), $passtest13)"/>
      </report>

    </rule>
	</pattern>
<diagnostics><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>