<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2"
        schemaVersion="1.0"
        xmlns:fnx="http://www.example.com/fnx"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
        xmlns="http://purl.oclc.org/dsdl/schematron">
	<title>ST.96 Conformance Checker - Test Suite Results</title>
	<ns prefix="svrl" uri="http://purl.oclc.org/dsdl/svrl"/>
	<ns prefix="xsl" uri="http://www.w3.org/1999/XSL/Transform"/>
	<ns prefix="fnx" uri="http://www.example.com/fnx"/>

  <xsl:include href="test_common.xsl"/>
  <!-- 
    Instructions:
    - create variables with expected failmsg for *.svrl file which is expected to fail assertion
    - - create assertion to check for this failmsg
    >  <assert test="fnx:no-fail-infile($failmsg2, '2.svrl', $inFileName)" flag="AUTO">
        <value-of select="$failmsg2"/>
      </assert>
    - create assertion for pass tests: 
      <assert test="fnx:failed-assert-count-is-infile(0, '1.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(0, .)"/>
      </assert>
    - create assertion for fail tests:
      <assert test="fnx:failed-assert-count-is-infile(1, '2.svrl', $inFileName, .)" flag="AUTO">
        <xsl:value-of select="fnx:wrong-error-count-message(1, .)"/>
      </assert>
  -->
	<pattern>
		<title>GD-06</title>

    <rule context="svrl:schematron-output" role="ERROR">
      <let name="inFileName" value="tokenize(base-uri(), '/')[last()]"/>
      
      <let name="failmsg0" value="fnx:expect('The name of element BAD_element contains invalid characters.', /)"/>
      <let name="failmsg1" value="fnx:expect('The name of element BAD.element contains invalid characters.', /)"/>
      <let name="failmsg2" value="fnx:expect('The name of element BAD-element contains invalid characters.', /)"/>
      <let name="failmsg3" value="fnx:expect('The name of element BADΔelement contains invalid characters.', /)"/>
      <let name="failmsg4" value="fnx:expect('The name of attribute BAD_attribute contains invalid characters.', /)"/>
      <let name="failmsg5" value="fnx:expect('The name of attribute BAD.attribute contains invalid characters.', /)"/>
      <let name="failmsg6" value="fnx:expect('The name of attribute BAD-attribute contains invalid characters.', /)"/>
      <let name="failmsg7" value="fnx:expect('The name of attribute BADΔattribute contains invalid characters.', /)"/>
      <let name="failmsg8" value="fnx:expect('The name of simpleType BAD_simpleType contains invalid characters.', /)"/>
      <let name="failmsg9" value="fnx:expect('The name of simpleType BAD.simpleType contains invalid characters.', /)"/>
      <let name="failmsg10" value="fnx:expect('The name of simpleType BAD-simpleType contains invalid characters.', /)"/>
      <let name="failmsg11" value="fnx:expect('The name of simpleType BADΔsimpleType contains invalid characters.', /)"/>
      <let name="failmsg12" value="fnx:expect('The name of complexType BAD_complexType contains invalid characters.', /)"/>
      <let name="failmsg13" value="fnx:expect('The name of complexType BAD.complexType contains invalid characters.', /)"/>
      <let name="failmsg14" value="fnx:expect('The name of complexType BAD-complexType contains invalid characters.', /)"/>
      <let name="failmsg15" value="fnx:expect('The name of complexType BADΔcomplexType contains invalid characters.', /)"/>
      <!-- Assertions -->

      <let name="failtest1" value="fnx:expect-infile-by-component('BAD_element', '1.svrl', $inFileName, /)"/>
      <report test="$failtest1 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-06">
        <value-of select="fnx:rule-test-outcome(false(), $failtest1)"/>
      </report>
      <let name="failtest2" value="fnx:expect-infile-by-component('BAD.element', '1.svrl', $inFileName, /)"/>
      <report test="$failtest2 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-06">
        <value-of select="fnx:rule-test-outcome(false(), $failtest2)"/>
      </report>
      <let name="failtest3" value="fnx:expect-infile-by-component('BAD-element', '1.svrl', $inFileName, /)"/>
      <report test="$failtest3 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-06">
        <value-of select="fnx:rule-test-outcome(false(), $failtest3)"/>
      </report>
      <let name="failtest4" value="fnx:expect-infile-by-component('BADΔelement', '1.svrl', $inFileName, /)"/>
      <report test="$failtest4 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-06">
        <value-of select="fnx:rule-test-outcome(false(), $failtest4)"/>
      </report>
      <let name="failtest5" value="fnx:expect-infile-by-component('BAD_attribute', '1.svrl', $inFileName, /)"/>
      <report test="$failtest5 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-06">
        <value-of select="fnx:rule-test-outcome(false(), $failtest5)"/>
      </report>
      <let name="failtest6" value="fnx:expect-infile-by-component('BAD.attribute', '1.svrl', $inFileName, /)"/>
      <report test="$failtest6 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-06">
        <value-of select="fnx:rule-test-outcome(false(), $failtest6)"/>
      </report>
      <let name="failtest7" value="fnx:expect-infile-by-component('BAD-attribute', '1.svrl', $inFileName, /)"/>
      <report test="$failtest7 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-06">
        <value-of select="fnx:rule-test-outcome(false(), $failtest7)"/>
      </report>
      <let name="failtest8" value="fnx:expect-infile-by-component('BADΔattribute', '1.svrl', $inFileName, /)"/>
      <report test="$failtest8 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-06">
        <value-of select="fnx:rule-test-outcome(false(), $failtest8)"/>
      </report>
      <let name="failtest9" value="fnx:expect-infile-by-component('BAD_simpleType', '1.svrl', $inFileName, /)"/>
      <report test="$failtest9 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-06">
        <value-of select="fnx:rule-test-outcome(false(), $failtest9)"/>
      </report>
       <let name="failtest10" value="fnx:expect-infile-by-component('BAD.simpleType', '1.svrl', $inFileName, /)"/>
      <report test="$failtest10 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-06">
        <value-of select="fnx:rule-test-outcome(false(), $failtest10)"/>
      </report>
      <let name="failtest11" value="fnx:expect-infile-by-component('BAD-simpleType', '1.svrl', $inFileName, /)"/>
      <report test="$failtest11 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-06">
        <value-of select="fnx:rule-test-outcome(false(), $failtest11)"/>
      </report>
       <let name="failtest12" value="fnx:expect-infile-by-component('BADΔsimpleType', '1.svrl', $inFileName, /)"/>
      <report test="$failtest12 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-06">
        <value-of select="fnx:rule-test-outcome(false(), $failtest12)"/>
      </report>
        <let name="failtest13" value="fnx:expect-infile-by-component('BAD_complexType', '1.svrl', $inFileName, /)"/>
      <report test="$failtest13 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-06">
        <value-of select="fnx:rule-test-outcome(false(), $failtest13)"/>
      </report>
      <let name="failtest14" value="fnx:expect-infile-by-component('BAD.complexType', '1.svrl', $inFileName, /)"/>
      <report test="$failtest14 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-06">
        <value-of select="fnx:rule-test-outcome(false(), $failtest14)"/>
      </report>
        <let name="failtest15" value="fnx:expect-infile-by-component('BAD-complexType', '1.svrl', $inFileName, /)"/>
      <report test="$failtest15 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-06">
        <value-of select="fnx:rule-test-outcome(false(), $failtest15)"/>
      </report>
      <let name="failtest16" value="fnx:expect-infile-by-component('BADΔcomplexType', '1.svrl', $inFileName, /)"/>
      <report test="$failtest16 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-06">
        <value-of select="fnx:rule-test-outcome(false(), $failtest16)"/>
      </report>
      
      <let name="passtest17" value="fnx:expect-infile-by-component('GOODelementABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789', '2.svrl', $inFileName, /)"/>
      <report test="$passtest17 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-06">
        <value-of select="fnx:rule-test-outcome(true(), $passtest17)"/>
      </report>
      
       <let name="passtest18" value="fnx:expect-infile-by-component('GOODattributeABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789', '3.svrl', $inFileName, /)"/>
      <report test="$passtest18 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-06">
        <value-of select="fnx:rule-test-outcome(true(), $passtest18)"/>
      </report>
      <let name="passtest19" value="fnx:expect-infile-by-component('GOODsimpleTypeABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890', '4.svrl', $inFileName, /)"/>
      <report test="$passtest19 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-06">
        <value-of select="fnx:rule-test-outcome(true(), $passtest19)"/>
      </report>
      <let name="passtest20" value="fnx:expect-infile-by-component('GOODcomplexTypeABCDEFGHIJKLMNOPQRSTUVWXYZ2345678901abcdefghijklmnopqrstuvwxyz', '4.svrl', $inFileName, /)"/>
      <report test="$passtest20 != ''" flag="AUTO" diagnostics="uri" role="ERROR" see="#GD-06">
        <value-of select="fnx:rule-test-outcome(true(), $passtest20)"/>
      </report>

    </rule>

	</pattern>
<diagnostics><diagnostic id="GD-06"/><diagnostic id="uri"> <value-of select="document-uri(/)"/> </diagnostic></diagnostics></schema>