<?xml version="1.0" encoding="UTF-8"?>
<schema queryBinding="xslt2" schemaVersion="1.0" xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:sch="http://purl.oclc.org/dsdl/schematron" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fnx="http://www.example.com/fnx" xmlns:d="http://www.example.com/data" xmlns:mathml="http://www.w3.org/1998/Math/MathML" xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common" xmlns:tbl="http://www.oasis-open.org/tables/exchange/1.0" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
  <title>WIPO ST.96 Conformance Validation</title>
  <ns prefix="fnx" uri="http://www.example.com/fnx"/>
   <ns prefix="d" uri="http://www.example.com/data"/>
   <ns prefix="m3" uri="http://www.w3.org/1998/Math/MathML3"/>
   <ns prefix="m" uri="http://www.w3.org/1998/Math/MathML"/>
   <ns prefix="tbl" uri="http://www.oasis-open.org/tables/exchange/1.0"/>
   <ns prefix="com" uri="http://www.wipo.int/standards/XMLSchema/ST96/Common"/>
   <ns prefix="xsd" uri="http://www.w3.org/2001/XMLSchema"/>
   
    <let name="localFile" value="replace(base-uri(.),'^.*[\\/](.*)','$1')"/>
    <let name="inSubdirName" value="tokenize(base-uri(), '/')[last()-1]"/>
    <let name="inComponentSubdirName" value="tokenize(replace(base-uri(),'/Document/','/'), '/')[last()-1]"/>
    <let name="gd24OutputFile" value="'../output/gd-24.tmp'"/><!-- performance improvements if rule GD-24 is run outside of this schematron, since it requires access to the full set of schemas, but this schematron is run on each individual design schema  -->
    <let name="sd04OutputFile" value="'../output/sd-04.tmp'"/><!-- performance improvements if rule SD-04 is run outside of this schematron, since it requires access to the full set of schemas, but this schematron is run on each individual design schema  -->
    <let name="sd05OutputFile" value="'../output/sd-05.tmp'"/><!-- performance improvements if rule SD-05 is run outside of this schematron, since it requires access to the full set of schemas, but this schematron is run on each individual design schema  -->
   
    <let name="kRegexReleaseDir" value="concat('.*/([^/]+)/((',(string-join($namespaces/@subdir,'|')),')/(Document/)?)?$')"/><!-- can be:  ST96XMLSchema_VM_n/Namespace/*.xsd,  ST96XMLSchema_VM_n/Namespace/Document/*.xsd, or  ST96XMLSchema_VM_n_Flattened/*.xsd 
   conventionally folder name starts as "ST96XMLSchema", but this is not specified in the rule -->
   <let name="kRegexReleaseVersion" value="'V(0|[1-9][0-9]*)_(0|[1-9][0-9]*)(_([1-9][0-9]*))?'"/><!-- use for SD-30, SD-31, SD-63, SD-64 -->
   <let name="kRegexLocalFileVersion" value="'_V([0-9]+)_([0-9]+)(_([1-9][0-9]*))?\.[a-zA-Z0-9]+$'"/><!-- use for SD-64 -->
   
  <let name="kWhereToApproveExceptions" value="if (doc-available('../ApprovedExceptions.xml')) then doc('../ApprovedExceptions.xml')/*/@whereToApproveExceptions else 'InReport'"/>
  <!--
      Configure whereToApproveExceptions to one of the following values:
      'InReport'
          Allow summary.html to report which XSDs violations are approved.
      'InSchematronRules'
          Trim approved exception violation notices immediately in Schematron.
          Caveat: if 'InSchematronRules', a schema amy be listed as an exception even if it did not violate the rule.
          
      For all failures:
        provides svrl:diagnostic-reference elements (@diagnostic='componentName' and @diagnostic='namespaceName') 
  -->
  <!-- NOTE:
      if you change the assert message content, you must also update the corresponding *.sch in dev/test/schemas/split_guidelines_tests/ for unit testing. (NEED TO UPDATE to leverage XSpec schematron unit testing)
  -->
  
  <let name="kRepresentationTerms" value="('Amount', 'Category', 'Code', 'Date', 'Identifier',
              'Indicator', 'Measure', 'Name', 'Number', 'Percent',
              'Quantity', 'Rate', 'Text', 'Time', 'DateTime', 'URI')"/>
   <let name="kNamespaceWIPObase" value="'http://www.wipo.int/standards/XMLSchema/ST96/'"/>
   <let name="kCommonNamespace" value="concat($kNamespaceWIPObase, 'Common')"/>
   <let name="kPatentNamespace" value="concat($kNamespaceWIPObase, 'Patent')"/>
   <let name="kTrademarkNamespace" value="concat($kNamespaceWIPObase, 'Trademark')"/>
   <let name="kDesignNamespace" value="concat($kNamespaceWIPObase, 'Design')"/>
   <let name="kGeographicalIndicationNamespace" value="concat($kNamespaceWIPObase, 'GeographicalIndication')"/>
   <let name="kCopyrightNamespace" value="concat($kNamespaceWIPObase, 'Copyright')"/>
   <let name="kXMLSchemaNamespace" value="'http://www.w3.org/2001/XMLSchema'"/>
   <let name="kMathMLNamespace" value="'http://www.w3.org/1998/Math/MathML'"/>
   <let name="kOASISTableNamespace" value="'http://www.oasis-open.org/tables/exchange/1.0'"/>
   <let name="kIPOCommonNamespace" value="fnx:ipo-ns('common', 'ns')"/>
   <let name="kIPOPatentNamespace" value="fnx:ipo-ns('patent', 'ns')"/>
   <let name="kIPOTrademarkNamespace" value="fnx:ipo-ns('trademark', 'ns')"/>
   <let name="kIPODesignNamespace" value="fnx:ipo-ns('design', 'ns')"/>
    <let name="kIPOGeographicalIndicationNamespace" value="fnx:ipo-ns('geographicalindication', 'ns')"/>
    <let name="kIPOCopyrightNamespace" value="fnx:ipo-ns('copyright', 'ns')"/>
   <let name="kIPOCommonNamespacePrefix" value="fnx:ipo-ns('common', 'ns-prefix')"/>
   <let name="prefixTable" value="fnx:buildPrefixTable(/xsd:schema)"/>
   <let name="approvedAcronyms" value="doc('../AcronymsAndAbbreviations.xml'), doc('../AcronymsAndAbbreviationsLocal.xml')"/>
   <let name="approvedExceptions" value="if (doc-available('../ApprovedExceptions.xml')) then doc('../ApprovedExceptions.xml') else false()"/>
   <let name="definitions" value="fnx:gatherDefinitionsRoot(/xsd:schema, 0)"/>
   <let name="connectingWords" value="doc('../ConnectingWords.xml')/Words/Word"/>
   <let name="legalReferencePrefixes" value="doc('../LegalReferencePrefixes.xml')/Prefixes/Prefix"/>
   <let name="namespaces" value="doc('../BaselineNamespaces.xml')/Namespaces/Namespace"/>
   <let name="lookupTable" value="fnx:buildLookupTable()"/><!-- this contains duplicates... -->
   <let name="st3Codes" value="doc('../WIPOST3Codes.xml')/Codes/Code"/><!-- automatically updated by build based on the corresponding XSD file -->
   <let name="st96Version" value="if (doc-available('../st96Version.xml')) then (doc('../st96Version.xml')//*:attribute[@name eq 'st96Version'][1]/@*:fixed) else ($allSchemasInDir/*:schema[*:attribute[@name eq 'st96Version']][1]/*:attribute[@name eq 'st96Version'][1]/@*:fixed)"/><!-- this file is created by the ant build first as an alternative to feed parameters... if this is run outside of Ant build, then it will be super slow.... -->
  
  <let name="ipoVersion" value="if (doc-available('../ipoVersion.xml')) then (doc('../ipoVersion.xml')//*:attribute[@name eq 'ipoVersion'][1]/@*:fixed) else ($allSchemasInDir/*:schema[*:attribute[@name eq 'ipoVersion']][1]/*:attribute[@name eq 'ipoVersion'][1]/@*:fixed)"/><!-- SD-63, SD-30, SD-28; filename and version: SD-64, GD-31, GD-32  -->

  <let name="isFlattened" value="boolean(count(/xsd:schema/*[@name]) > 1)"/>
  <let name="kIPONonCommonNamespaces" value="($kIPOPatentNamespace,$kIPOTrademarkNamespace,$kIPODesignNamespace,$kIPOGeographicalIndicationNamespace,$kIPOCopyrightNamespace)"/>
  <let name="kNonCommonNamespaces" value="($kPatentNamespace,$kTrademarkNamespace,$kDesignNamespace,$kGeographicalIndicationNamespace,$kCopyrightNamespace)"/>
  <let name="kAllowedCrossrefNamespaces" value="($kTrademarkNamespace,$kGeographicalIndicationNamespace)"/>
  
  <let name="targetNamespaceName" value="tokenize(/xsd:schema/@targetNamespace,'[/:]')[last()]"/>
  
  <let name="allSchemasInDir" value="collection(concat(replace(replace(translate(base-uri(),'\','/'),'[^\\/]+/(Document/)?([^\\/]+\.xsd)','$2','i'),'/[^/]+$','/') ,'?select=*xsd&amp;recurse=yes'))[not(contains(base-uri(.),'/ExternalStandards/'))]"/>
  <xsl:key name="component-by-name" match="*[@name]" use="@name"/>
  <xsl:key name="exception-by-rule-namespace-name" match="ApprovedExceptions/ApprovedException" use="concat(@ruleID,':',@subdir,':',@file/replace(.,'(.+/)?([A-Za-z][a-zA-Z0-9]*)(_V\d+_\d+[^\.]*)?\.xsd', '$2'))"/>
  
  <xsl:function name="fnx:is-exception" as="xs:boolean"><!-- *** NEED TO UPDATE so that flattened schemas can use the same exceptions... -->
    <xsl:param name="ruleID" as="xs:string"/>
    <xsl:param name="componentName" as="xs:string"/>
    
    <xsl:choose>
      <xsl:when test="($kWhereToApproveExceptions = 'InSchematronRules')">
        <xsl:choose>
          <xsl:when test="$isFlattened = false()">
            <xsl:value-of select="$approvedExceptions and boolean($approvedExceptions/ApprovedExceptions/ApprovedException[@ruleID=$ruleID][not(@subdir) or @subdir=$inSubdirName][@file=$localFile])"/>
          </xsl:when>
          <xsl:otherwise>
            
            <xsl:variable name="ns" select="
                if (contains($componentName, ':')) then
                  ($namespaces[@ns-prefix = substring-before($componentName, ':')]/@subdir)
                else
                  ($targetNamespaceName)"/>
            <xsl:message> <xsl:value-of select="$ruleID"/>: check if <xsl:value-of select="concat($ns,'/',$componentName)"/> is in list of exceptions  </xsl:message>
            <xsl:value-of select="$approvedExceptions and exists($approvedExceptions/key('exception-by-rule-namespace-name',concat($ruleID,':',$ns,':',$componentName)))"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="false()"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>

  <xsl:function name="fnx:ipo-ns" as="xs:string?">
    <xsl:param name="area" as="xs:string"/>
    <xsl:param name="part" as="xs:string"/>
       <xsl:sequence select="$namespaces[not(@std ='external' or @std = 'ST96')][@component = $area]/@*[name() = $part]"/>
  </xsl:function>

  <xsl:function name="fnx:xsdVersionFromFileName" as="xs:string?">
    <xsl:param name="fname" as="xs:string"/>
    <xsl:analyze-string select="$fname"
                        regex="^.+_(V[0-9]+_[0-9]+(_[1-9][0-9]*)?)(_[DT]([0-9]+))?\.[a-zA-Z0-9]+$">
      <xsl:matching-substring>
        <xsl:value-of select="regex-group(1)"/>
      </xsl:matching-substring>
    </xsl:analyze-string>
  </xsl:function>

  <xsl:function name="fnx:buildPrefixTable" as="element()">
    <!-- limitation: does not include prefix-namespace bindings from included/imported XSDs -->
    <xsl:param name="root" as="node()"/>
    <d:prefixBindings>
      <!-- http://stackoverflow.com/a/123005/290085 -->
      <xsl:for-each select="$root/namespace::*">
        <d:prefixBinding nsPrefix="{name()}" nsName="{.}"/>
      </xsl:for-each>
    </d:prefixBindings>
  </xsl:function>

  <xsl:function name="fnx:buildLookupTable" as="element()">
    <d:lookUp>
      <xsl:for-each-group select="$definitions//d:namespace" group-by="@ns">
        <xsl:variable name="ns" select="current-grouping-key()"/>
        <d:entry ns="{$ns}">
          <xsl:for-each-group select="current-group()/*[local-name() != 'namespace']" group-by="@name">
            <xsl:copy-of select="current-group()[1]"/>
          </xsl:for-each-group>
        </d:entry>
      </xsl:for-each-group>
    </d:lookUp>
  </xsl:function>

  <!-- Build first-pass structure of nested namespaces that will then
       be collapsed into a proper symbol table array -->
  <xsl:function name="fnx:gatherDefinitionsRoot" as="element()*">
    <xsl:param name="schemaRoot" as="node()"/>
    <xsl:param name="depth" as="xsd:integer"/>
    <d:defs>
      <xsl:sequence select="fnx:gatherDefinitions($schemaRoot, 0)"/>
    </d:defs>
  </xsl:function>

  <xsl:function name="fnx:gatherDefinitions" as="element()*">
    <xsl:param name="schemaRoot" as="node()?"/>
    <xsl:param name="depth" as="xsd:integer"/>

    <xsl:if test="$depth &lt; 5"> <!-- performance concession and loop avoidance  -->
      <xsl:variable name="nsName" select="if ($schemaRoot/@targetNamespace) then $schemaRoot/@targetNamespace else 'DEFAULT'"/>

      <d:namespace ns="{$nsName}">
        <xsl:for-each select="$schemaRoot/(xsd:include|xsd:import)[doc-available(resolve-uri(@schemaLocation,base-uri()))]">
          <xsl:sequence select="fnx:gatherDefinitions(document(@schemaLocation)/xsd:schema, $depth + 1)"/>
        </xsl:for-each>

        <xsl:sequence select="$schemaRoot/(xsd:element|xsd:attribute|xsd:complexType|xsd:simpleType)"/>

      </d:namespace>
    </xsl:if>
  </xsl:function>

  <xsl:function name="fnx:same-position-LC" as="xs:boolean">
    <xsl:param name="str" as="xs:string"/>
    <xsl:param name="substr" as="xs:string"/>

    <xsl:variable name="strLC" select="lower-case($str)"/>
    <xsl:variable name="substrLC" select="lower-case($substr)"/>

    <xsl:value-of select="contains($str, $substr)
                          and lower-case(substring-after($str, $substr))
                            = substring-after($strLC, $substrLC)"/>
  </xsl:function>

  <!--
      Recursive function.  Do not call directly because does not
      special-case the start of string.  Call main entry point at
      fnx:find-improper-embedded-abbreviation-in-attribute() instead.
      It is assumed that the lower-case check of $abbrev against the
      beginning of the attribute name has already taken place prior to
      calling this function.
  -->
  <xsl:function name="fnx:find-improper-embedded-abbreviation-rest" as="xs:string*">
      <xsl:param name="nameRest" as="xs:string"/>
      <xsl:param name="abbrev" as="xs:string"/>
      <xsl:if test="$nameRest != ''">
         <xsl:variable name="nameRestLC" select="lower-case($nameRest)"/>
         <xsl:variable name="abbrevLC" select="lower-case($abbrev)"/>
         <xsl:if test="contains($nameRestLC, $abbrevLC)">
            <xsl:choose>
               <xsl:when test="not(fnx:same-position-LC($nameRest, $abbrev))">
                  <xsl:value-of select="$abbrev"/>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:variable name="rest" select="substring-after($nameRest, $abbrev)"/>
                  <xsl:value-of select="fnx:find-improper-embedded-abbreviation-rest($rest, $abbrev)"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:if>
      </xsl:if>
   </xsl:function>

  <xsl:function name="fnx:find-improper-embedded-abbreviation-in-attribute" as="xs:string*"><!-- not used anymore -->
    <xsl:param name="attrName" as="xs:string"/>
    
    <xsl:variable name="attrNameLC" select="lower-case($attrName)"/>
    <xsl:for-each select="$approvedAcronyms/AAs/AA/short[string-length() > 2]">
      <xsl:variable name="abbrev" select="."/>
      <xsl:variable name="abbrevLC" select="lower-case($abbrev)"/>
      <xsl:choose>
        <!-- An abbreviation at the beginning of a name must be in lower-case. -->
        <xsl:when test="starts-with($attrNameLC, $abbrevLC) and not(starts-with($attrName, $abbrevLC))">
          <xsl:value-of select="$abbrev"/>
        </xsl:when>
        <!-- Check the rest of an attribute name that properly starts with a lower-cased abbreviation.   -->
        <xsl:when test="starts-with($attrNameLC, $abbrevLC) and starts-with($attrName, $abbrevLC)">
         <xsl:value-of select="fnx:find-improper-embedded-abbreviation-rest(substring-after($attrName, $abbrevLC), $abbrev)"/>
        </xsl:when>
        <!-- Check the entire attribute name without regard to the special start-of-name condition. -->
<xsl:otherwise>
               <xsl:value-of select="fnx:find-improper-embedded-abbreviation-rest($attrName, $abbrev)"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:for-each>
   </xsl:function>
   <xsl:function name="fnx:find-improper-embedded-abbreviation-in-element-or-type" as="xs:string*">
      <xsl:param name="elName" as="xs:string"/>
      <xsl:for-each select="$approvedAcronyms/AAs/AA/short[string-length() > 2]">
         <xsl:variable name="abbrev" select="."/>
         <xsl:value-of select="fnx:find-improper-embedded-abbreviation-rest($elName, $abbrev)"/>
      </xsl:for-each>
   </xsl:function>
  
  <xsl:function name="fnx:words-from-name" as="xs:string*">
      <xsl:param name="name"/>
      <!-- eliminates acronyms; only checks words -->
      <xsl:sequence select="tokenize(replace(replace($name,'([A-Z]*)([A-Z][^A-Z]+)',' $2'),'[A-Z]+$',''),' ')"/>
   </xsl:function>
  <xsl:function name="fnx:getRepTerm" as="xs:string">
    <xsl:param name="name" as="xs:string"/>
    <xsl:choose>
      <!--
          Specially check DateTime and Time because their mutually
          identical ending foils the for-expression approache below.
      -->
      <xsl:when test="ends-with($name, 'DateTime')">DateTime</xsl:when>
      <xsl:when test="ends-with($name, 'Time')">Time</xsl:when>
      <xsl:otherwise>
      <xsl:value-of select="string-join(
                            (for $repTerm in $kRepresentationTerms
                             return
                               if (ends-with(lower-case($name),
                                             lower-case($repTerm))
                                   or
                                   ends-with(lower-case($name),
                                             lower-case(concat($repTerm, 'Type')))
                                  )
                               then $repTerm
                               else ''),
                               '')"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>

  <xsl:function name="fnx:getDataType" as="xsd:string*">
    <!-- closely tied to allowedRepTerms -->
    <xsl:param name="n" as="node()"/>
    
    <xsl:choose>
      <xsl:when test="not($n)">
        <xsl:value-of select="()"/>
      </xsl:when>
      <xsl:when test="((local-name($n) = 'element') or (local-name($n) = 'attribute')) and not($n/@type)">
        <xsl:value-of select="()"/>
      </xsl:when>
      <xsl:when test="$n/xsd:union">
        <!-- check DocumentName.xsd -->
        <xsl:value-of select="'union of simpleTypes'"/>
      </xsl:when>
      <xsl:when test="$n/@type or $n/xsd:restriction or $n/xsd:simpleContent/*/@base or $n/*/@base">
        <xsl:variable name="basicType" select="($n/@type, $n/xsd:restriction/@base, $n/xsd:simpleContent/*/@base, $n/*/@base)[1]"/>
        <xsl:choose>
          <xsl:when test="$basicType">
            <xsl:value-of select="$basicType"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="()"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="()"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>

  <xsl:function name="fnx:allowedRepTerms" as="xsd:string*">
    <!-- given a node, return the allowed representation term for the node type -->
    <xsl:param name="n" as="node()"/>
    
    <!--<xsl:message>
      fnx:allowedRepTerms(<xsl:value-of select="$n/@name"/>) starting...<xsl:value-of select="$n/name()"/>
    </xsl:message>-->
    
    <!-- full set:
      Amount, Category, Code, Date, Identifier, Indicator, Measure, Name, Number, Percent, Quantity, Rate, Text, Time, DateTime, URI
    -->
    
      <xsl:variable name="result" as="xsd:string*">
      <xsl:choose>
        <xsl:when test="not($n)">
          <xsl:value-of select="()"/>
        </xsl:when>
        <xsl:when test="((local-name($n) = 'element') or (local-name($n) = 'attribute')) and not($n/@type)">
          <!-- use xsd:string for default -->
          <xsl:value-of select="('Text', 'Name', 'Number')"/><!-- check: @type='xsd:string' does not allow 'CreativeWorkIdentifier' -->
        </xsl:when>
        <xsl:when test="$n/xsd:union"><!-- check DocumentName.xsd -->
          <xsl:value-of select="('Category', 'Code', 'Identifier', 'Number')"/>
        </xsl:when>
        <xsl:when test="$n/@type or $n/xsd:restriction or $n/xsd:simpleContent/*/@base or $n/*/@base">
          <xsl:variable name="basicType" select="($n/@type, $n/xsd:restriction/@base, $n/xsd:simpleContent/*/@base, $n/*/@base)[1]"/>
          <!--<xsl:message>
            fnx:allowedRepTerms(<xsl:value-of select="$n/@name"/>): basicType = <xsl:value-of select="$basicType"/>
          </xsl:message>-->

          <xsl:choose>
            <xsl:when test="resolve-QName($basicType,$n) = xs:QName('com:AmountType')">
              <xsl:value-of select="('Amount')"/>
            </xsl:when>
            <xsl:when test="resolve-QName($basicType,$n) = xs:QName('xsd:token')"><!-- ProductionMaximumAmount must have Category, Code, Identifier or Number as a representation term, not Amount.
 -->
            <!-- ProductOenologicalPracticeText must have Category, Code, Identifier or Number as a representation term, not Text.
 -->
              <!-- transliterationScriptName must have Category, Code, Identifier, Number or Text as a representation term, not Name.
 -->
              <xsl:value-of select="('Category', 'Code', 'Identifier', 'Number', 'Text', 'Name')"/>
            </xsl:when>
            <xsl:when test="resolve-QName($basicType,$n) = xs:QName('xsd:boolean')">
              <xsl:value-of select="('Indicator')"/>
            </xsl:when>
            <xsl:when test="(resolve-QName($basicType,$n) = xs:QName('com:DateType')) or (resolve-QName($basicType,$n) = xs:QName('xsd:date'))"><!-- what about xsd:gYearMonth?? -->
              <xsl:value-of select="('Date')"/>
            </xsl:when>
            <xsl:when test="resolve-QName($basicType,$n) = xs:QName('com:MeasureType')">
              <xsl:value-of select="('Measure')"/>
            </xsl:when>
            <xsl:when test="resolve-QName($basicType,$n) = (xs:QName('xsd:positiveInteger'),xs:QName('xsd:integer'))">
              <xsl:value-of select="('Number')"/>
            </xsl:when>
            <xsl:when test="(resolve-QName($basicType,$n) = xs:QName('com:QuantityType')) or (resolve-QName($basicType,$n) = xs:QName('xsd:nonNegativeInteger'))">
              <xsl:value-of select="('Quantity')"/>
            </xsl:when>
            <xsl:when test="(resolve-QName($basicType,$n) = xs:QName('xsd:decimal'))"><!-- VerticalResolutionQuantity must have Percent or Rate as a representation term, not Quantity.
 -->
              <!-- Appendix B: A quantity is a counted number of non-monetary units, possibly including fractions... QuantityType should be used for components that require unit information; and xsd:nonNegativeInteger should be used for countable components which do not need unit information. -->
              <!-- QuantityType is xsd:decimal with required attribute com:unitCode -->
              <xsl:value-of select="('Percent', 'Rate', 'Quantity')"/>
            </xsl:when>
            <xsl:when test="resolve-QName($basicType,$n) = xs:QName('xsd:string')"><!-- should be roughly same as xsd:token --><!-- RightsHolderCategory must have Text, Name, Number or Identifier as a representation term, not Category.
 --><!-- LackingInventionUnityConsequenceCategory must have Text, Name, Number or Identifier as a representation term, not Category.
 -->
              <xsl:value-of select="('Text', 'Name', 'Number', 'Identifier', 'Category')"/><!-- added Identifier and Category 2020-07-23 -->
            </xsl:when>
            <xsl:when test="(resolve-QName($basicType,$n) = xs:QName('xsd:time'))">
              <xsl:value-of select="('Time')"/>
            </xsl:when>
            <xsl:when test="(resolve-QName($basicType,$n) = xs:QName('xsd:dateTime'))">
              <xsl:value-of select="('DateTime')"/>
            </xsl:when>
            <xsl:when test="(resolve-QName($basicType,$n) = xs:QName('xsd:anyURI'))">
              <xsl:value-of select="('URI')"/>
            </xsl:when>
            <xsl:when test="(resolve-QName($basicType,$n) = xs:QName('xsd:anySimpleType'))
                            or (resolve-QName($basicType,$n) = xs:QName('xsd:ID'))
                            or (resolve-QName($basicType,$n) = xs:QName('xsd:IDREF'))
                            or (resolve-QName($basicType,$n) = xs:QName('xsd:IDREFS'))
                            ">
              <xsl:value-of select="('EXEMPT')"/>
            </xsl:when>
            <xsl:when test="(resolve-QName($basicType,$n) = xs:QName('com:IdentifierType'))">
              <xsl:value-of select="('Identifier')"/>
            </xsl:when>
            <xsl:when test="(resolve-QName($basicType,$n) = (xs:QName('com:LocalizedTextType'),xs:QName('com:OrderedTextType'),xs:QName('com:PhraseType')))">
              <xsl:value-of select="('Text')"/>
            </xsl:when>
            <xsl:when test="$n/xsd:simpleContent/*/@base"> <!-- but matched none of the above -->
               <!--<xsl:message>
                   fnx:allowedRepTerms(<xsl:value-of select="$n/@name"/>) recursing with $basicType = <xsl:value-of select="$basicType"/>  1...
                   </xsl:message> -->
              <xsl:value-of select="fnx:allowedRepTerms(fnx:get-xsd-definition(root($n), $basicType))"/>
            </xsl:when>
            <xsl:when test="not(prefix-from-QName(resolve-QName($basicType,$n)) = 'xsd') and $n/@type"><!-- in case didn't enumerate all built-in xsd types... -->
            <!--   <xsl:message>
                fnx:allowedRepTerms(<xsl:value-of select="$n/@name"/>) recursing 2...
              </xsl:message>-->
              <xsl:value-of select="fnx:allowedRepTerms(fnx:get-xsd-definition(root($n), $n/@type))"/>
            </xsl:when>
            <xsl:when test="$n/xsd:restriction/xsd:enumeration">
               <!-- e.g. PageDocumentFormatCategoryType is basic type com:DocumentFormatCategoryType-->
              <xsl:value-of select="('Category', 'Code')"/>
            </xsl:when>
            <xsl:otherwise>
              <!--<xsl:message><xsl:value-of select="$basicType"/> doesn't match anything</xsl:message>-->
              <xsl:value-of select="()"/></xsl:otherwise>
          </xsl:choose>
        </xsl:when>
<xsl:otherwise><xsl:value-of select="()"/></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <!-- <xsl:message>
    fnx:allowedRepTerms(<xsl:value-of select="$n/@name"/>) returns <xsl:value-of select="$result"/>
    </xsl:message>-->
    <xsl:value-of select="$result"/>
  </xsl:function>

  <xsl:function name="fnx:usesAllowedRepTerm" as="xsd:boolean">
    <!-- a function that computes atomic values should use xsl:sequence rather than xsl:value-of -->
    <xsl:param name="repTerm" as="xs:string"/>    
    <xsl:param name="allowedRepTerms" as="xs:string?"/>
    <xsl:sequence select="contains(concat(' ', $allowedRepTerms, ' '), concat(' ', $repTerm, ' '))"/>
  </xsl:function>

  <!-- A Basic Component refers to a W3C Built-in Datatype, simple
       Type or complex Type with xsd:simpleContent definition.  It is
       represented by an element or an attribute.  For example,
       FirstName (string), PhoneNumberCategory
       (PhoneNumberCategoryType).-->
  <xsl:function name="fnx:isBasicComponent" as="xsd:boolean">
    <xsl:param name="n" as="node()"/>
    <!--<xsl:message>
        fnx:isBasicComponent(name=<xsl:value-of select="$n/@name"/> type=<xsl:value-of select="$n/@type"/>)
        </xsl:message>-->
    <xsl:variable name="result">
      <xsl:choose>
        <xsl:when test="local-name($n) = 'attribute'"><!-- an attribute is automatically a basic component -->
          <xsl:value-of select="true()"/>
        </xsl:when>
        <xsl:when test="not((local-name($n) = 'element') or (local-name($n) = 'attribute'))">
          <xsl:value-of select="false()"/>
        </xsl:when>
        <xsl:when test="not($n)">
          <xsl:value-of select="false()"/>
        </xsl:when>
        <xsl:when test="not($n/@type) and $n/*">
          <xsl:message>WARNING: <xsd:value-of select="$n/@name"/>:  XSD styles with nested type definitions are not currently supported.</xsl:message>
          <xsl:value-of select="false()"/>
        </xsl:when>
        <xsl:when test="not($n/@type)">
          <!-- no data type; default is xsd:string -->
          <xsl:value-of select="true()"/>
        </xsl:when>
        <!-- 2024-08-20: added IdentifierType, LocalizedTextType, OrderedTextType;
        PhraseType has emphasis, but is still considered basic
        -->
        <xsl:when test="
          resolve-QName($n/@type,$n) = xs:QName('com:AmountType')
                        or resolve-QName($n/@type,$n) = xs:QName('xsd:token')
                        or resolve-QName($n/@type,$n) = xs:QName('com:DateType')
                        or resolve-QName($n/@type,$n) = xs:QName('xsd:date')
                        or resolve-QName($n/@type,$n) = xs:QName('xsd:boolean')
                        or resolve-QName($n/@type,$n) = xs:QName('com:MeasureType')
                        or resolve-QName($n/@type,$n) = xs:QName('xsd:string')
                        or resolve-QName($n/@type,$n) = xs:QName('xsd:positiveInteger')
                        or resolve-QName($n/@type,$n) = xs:QName('xsd:decimal')
                        or resolve-QName($n/@type,$n) = xs:QName('com:QuantityType')
                        or resolve-QName($n/@type,$n) = xs:QName('xsd:nonNegativeInteger')
                        or resolve-QName($n/@type,$n) = xs:QName('xsd:time')
                        or resolve-QName($n/@type,$n) = xs:QName('xsd:dateTime')
                        or resolve-QName($n/@type,$n) = xs:QName('xsd:anyURI')
                        or resolve-QName($n/@type,$n) = xs:QName('com:IdentifierType')
                        or resolve-QName($n/@type,$n) = xs:QName('com:LocalizedTextType')
                        or resolve-QName($n/@type,$n) = xs:QName('com:OrderedTextType')
                        or resolve-QName($n/@type,$n) = xs:QName('com:PhraseType')
                        or resolve-QName($n/@type,$n) = (xs:QName('xsd:float'),xs:QName('xsd:double'),xs:QName('xsd:duration'),xs:QName('xsd:gYearMonth'),xs:QName('xsd:gYear'),xs:QName('xsd:gMonthDay'),xs:QName('xsd:gDay'),xs:QName('xsd:gMonth'),xs:QName('xsd:hexBinary'),xs:QName('xsd:base64Binary'),xs:QName('xsd:QName'),xs:QName('xsd:NOTATION'),xs:QName('xsd:normalizedString'),xs:QName('xsd:language'),xs:QName('xsd:NMTOKEN'),xs:QName('xsd:NMTOKENS'),xs:QName('xsd:Name'),xs:QName('xsd:NCName'),xs:QName('xsd:ID'),xs:QName('xsd:IDREF'),xs:QName('xsd:IDREFS'),xs:QName('xsd:ENTITY'),xs:QName('xsd:ENTITIES'),xs:QName('xsd:integer'),xs:QName('xsd:nonPositiveInteger'),xs:QName('xsd:negativeInteger'),xs:QName('xsd:long'),xs:QName('xsd:int'),xs:QName('xsd:short'),xs:QName('xsd:byte'),xs:QName('xsd:unsignedLong'),xs:QName('xsd:unsignedInt'),xs:QName('xsd:unsignedShort'),xs:QName('xsd:unsignedByte'))"><!-- 2025-03-13: added list of leftover XSD primitive and derived datatypes not mentioned by Annex I -->
          <xsl:value-of select="true()"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="typeDef" select="fnx:get-xsd-definition(root($n), $n/@type)"/>
          <xsl:choose>
            <xsl:when test="local-name($typeDef) = 'simpleType'">
              <xsl:value-of select="true()"/>
            </xsl:when>
            <xsl:when test="$typeDef/xsd:simpleContent">
              <xsl:value-of select="true()"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="false()"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <!--
    <xsl:message>
      fnx:isBasicComponent(<xsl:value-of select="$n/@name"/>) = <xsl:value-of select="$result"/>
    </xsl:message>
    -->
    <xsl:value-of select="$result"/>
  </xsl:function>


  <xsl:function name="fnx:makeCommaList" as="xsd:string">
    <xsl:param name="sList" as="xs:string*"/>
    <xsl:param name="orOrAnd" as="xs:string"/>

    <xsl:variable name="commaList" as="xs:string*">
      <xsl:for-each select="$sList">
        <xsl:choose>
          <xsl:when test="position() = 1">
            <xsl:value-of select="."/>
          </xsl:when>
          <xsl:when test="position() = last() and position() != 1">
            <xsl:text> </xsl:text>
            <xsl:value-of select="$orOrAnd"/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="."/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>, </xsl:text>
            <xsl:value-of select="."/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:variable>
    <xsl:value-of select="string-join($commaList, '')"/>
  </xsl:function>

  <xsl:function name="fnx:isTableRelated" as="xs:boolean">
    <xsl:param name="name" as="xs:string?"/>
    <xsl:sequence select="$name
                          and fnx:contains-i($name, 'table')
                          and not(ends-with($name,'Indicator'))
                          and not(matches($name, 'tablebody', 'i'))
                          and not(matches($name, 'tablegroup', 'i'))
                          and not(matches($name, 'tableimage', 'i'))
                          and not(matches($name, 'tabletitle', 'i'))
                          and not(matches($name, 'tabledata', 'i'))
                          and not(matches($name, 'tablecell', 'i'))
                          and not(matches($name, 'tabledatacell', 'i'))
                          and not(matches($name, 'tablefooter', 'i'))
                          and not(matches($name, 'tablehead', 'i'))
                          and not(matches($name, 'tableheadercell', 'i'))
                          and not(matches($name, 'tablerow', 'i'))
                          "/>
  </xsl:function>

  <xsl:function name="fnx:hasRepeatingElements" as="xs:boolean">
    <xsl:param name="complexType" as="element()?"/>
    <!--
         1. Has to be at least one xs:element[@maxOccurs='unbounded'].
         If there are multiple xs:elements, then all must be
         @maxOccurs='unbounded'
         or 
         2. Unbounded can be on xs:choice.
         or
         3. Any xs:element under an xs:choice can be unbounded.
         
         2025-03-24: cannot check bag of bag, but extend 
         - allow unbounded OR >1 
         - allow at least one required and repeating element
    -->
    <xsl:sequence select="exists($complexType[not(@mixed='true' or xsd:simpleContent[1] or xsd:complexContent[1][@mixed='true'])])
                          and
                          (exists($complexType/xsd:choice[not(@minOccurs='0')][@maxOccurs = 'unbounded' or @maxOccurs[. castable as xs:integer]/xs:integer(.) gt 1]/xsd:element[not(@minOccurs='0')][1])
                           or
                           exists($complexType/xsd:choice[not(@minOccurs='0')][not(@maxOccurs = 'unbounded' or @maxOccurs[. castable as xs:integer]/xs:integer(.) gt 1) and not(xsd:element[not(@maxOccurs = 'unbounded' or @maxOccurs[. castable as xs:integer]/xs:integer(.) gt 1)][1] or xsd:sequence[1] or xsd:choice[1])]/xsd:element[not(@minOccurs='0')][@maxOccurs = 'unbounded' or @maxOccurs[. castable as xs:integer]/xs:integer(.) gt 1][1])
                           or
                           exists($complexType/xsd:sequence[not(@minOccurs='0')][not(@maxOccurs = 'unbounded' or @maxOccurs[. castable as xs:integer]/xs:integer(.) gt 1) and not(xsd:element[not(@maxOccurs = 'unbounded')][1] or xsd:sequence[1] or xsd:choice[1])]/xsd:element[not(@minOccurs='0')][@maxOccurs = 'unbounded' or @maxOccurs[. castable as xs:integer]/xs:integer(.) gt 1][1])
                           or
                           exists($complexType/*[local-name() ne 'sequence' and local-name() ne 'choice']/xsd:choice[not(@minOccurs='0')][@maxOccurs = 'unbounded' or @maxOccurs[. castable as xs:integer]/xs:integer(.) gt 1]/xsd:element[not(@minOccurs='0')][1])
                           
                           
                           
                           or
                           exists($complexType/xsd:choice[not(@minOccurs='0')][not(@maxOccurs = 'unbounded' or @maxOccurs[. castable as xs:integer]/xs:integer(.) gt 1)]/xsd:element[not(@minOccurs='0')][@maxOccurs = 'unbounded' or @maxOccurs[. castable as xs:integer]/xs:integer(.) gt 1][1])
                           or
                           exists($complexType/xsd:sequence[not(@minOccurs='0')][not(@maxOccurs = 'unbounded' or @maxOccurs[. castable as xs:integer]/xs:integer(.) gt 1)]/xsd:element[not(@minOccurs='0')][@maxOccurs = 'unbounded' or @maxOccurs[. castable as xs:integer]/xs:integer(.) gt 1][1])
                           or
                           exists($complexType/xsd:choice[not(@minOccurs='0')]/xsd:choice[not(@minOccurs='0')][@maxOccurs = 'unbounded' or @maxOccurs[. castable as xs:integer]/xs:integer(.) gt 1]/xsd:element[not(@minOccurs='0')][1])
                           or
                          exists($complexType/xsd:sequence[not(@minOccurs='0')]/xsd:choice[not(@minOccurs='0')][@maxOccurs = 'unbounded' or @maxOccurs[. castable as xs:integer]/xs:integer(.) gt 1]/xsd:element[not(@minOccurs='0')][1])
                           or
                           exists($complexType/        xsd:sequence[not(@minOccurs='0')]/xsd:choice[not(@minOccurs='0')][not(@maxOccurs) or @maxOccurs='1']/xsd:element[not(@minOccurs='0')][@maxOccurs = 'unbounded' or @maxOccurs[. castable as xs:integer]/xs:integer(.) gt 1][1])
                           or
                           exists($complexType/        xsd:sequence[not(@minOccurs='0')]/xsd:sequence[not(@minOccurs='0')][@maxOccurs = 'unbounded' or @maxOccurs[. castable as xs:integer]/xs:integer(.) gt 1]/xsd:element[not(@minOccurs='0')][1])
                           
                          )"/>
  </xsl:function>

   <xsl:function name="fnx:hasCorrectMixOfUnboundedChildrenToBeACollection" as="xs:boolean">
    <xsl:param name="complexType" as="element()?"/>
    <!--
         1. Has to be at least one xs:element[@maxOccurs='unbounded'].
         If there are multiple xs:elements, then all must be
         @maxOccurs='unbounded'
         or 
         2. Unbounded can be on xs:choice.
         or
         3. Any xs:element under an xs:choice can be unbounded.
    -->
     <!--  the difference between complex types with simple content and complex types with complex content is that the former do not allow element children while the latter do -->
    <xsl:sequence select="exists($complexType[not(@mixed='true' or xsd:simpleContent[1])])
                          and
                          (exists($complexType/xsd:choice[not(@minOccurs='0')][@maxOccurs = 'unbounded']/xsd:element[not(@minOccurs='0')][1])
                           or
                           exists($complexType/xsd:choice[not(@minOccurs='0')][not(@maxOccurs = 'unbounded') and not(xsd:element[not(@maxOccurs = 'unbounded')][1] or xsd:sequence or xsd:choice)]/xsd:element[not(@minOccurs='0')][@maxOccurs = 'unbounded'][1])
                           or
                           exists($complexType/xsd:sequence[not(@minOccurs='0')][not(@maxOccurs = 'unbounded') and not(xsd:element[not(@maxOccurs = 'unbounded')][1] or xsd:sequence or xsd:choice)]/xsd:element[not(@minOccurs='0')][@maxOccurs = 'unbounded'][1])
                           or
                           exists($complexType/*[local-name() ne 'sequence' and local-name() ne 'choice']/xsd:choice[not(@minOccurs='0')][@maxOccurs = 'unbounded']/xsd:element[not(@minOccurs='0')][1])
                          )"/>
<!--
                           (boolean($complexType/*/xs:element[@maxOccurs = 'unbounded'])
                            and
                            boolean(every $el in $complexType/*/xs:element satisfies $el/@maxOccurs = 'unbounded')
                           )
-->
  </xsl:function>

  <xsl:function name="fnx:isACollection" as="xs:boolean">
    <xsl:param name="e" as="element()?"/>

    <xsl:variable name="eIsACollection" as="xs:boolean">
      <xsl:choose>
        <xsl:when test="not($e)">
          <xsl:value-of select="false()"/>
        </xsl:when>
        <xsl:when test="$e/@mixed = 'true'">
          <xsl:value-of select="false()"/>
        </xsl:when>
        <xsl:when test="local-name($e) = 'element'">
          <!-- *** NEED TO DO: ProductCategoryBagType: update to allow maxOccurs over 1 -->
          <xsl:value-of select="    fnx:hasCorrectMixOfUnboundedChildrenToBeACollection($e/xsd:complexType)
                                or ($e/@type and fnx:isACollection(fnx:get-xsd-definition(root($e), $e/@type)))"/>
        </xsl:when>
        <xsl:when test="local-name($e) = 'complexType'">
          <xsl:value-of select="fnx:hasCorrectMixOfUnboundedChildrenToBeACollection($e)"/>
          <!--<xsl:message>
            <xsl:value-of select="concat('complex-type ', $e/@name, ': ', fnx:hasCorrectMixOfUnboundedChildrenToBeACollection($e))"/>
          </xsl:message>-->
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="false()"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <!-- Useful debugging diagnostic:
    <xsl:choose>
      <xsl:when test="$eIsACollection">
        <xsl:message><xsl:value-of select="local-name($e)"/>: <xsl:value-of select="$e/@name"/> IS a collection</xsl:message>
      </xsl:when>
      <xsl:otherwise>
        <xsl:message><xsl:value-of select="local-name($e)"/>: <xsl:value-of select="$e/@name"/> is NOT a collection</xsl:message>
      </xsl:otherwise>
    </xsl:choose>
    -->
    <xsl:value-of select="$eIsACollection"/>
  </xsl:function>
  
  <xsl:function name="fnx:hasAnEnumerationList" as="xs:boolean">
    <xsl:param name="elem" as="element()?"/>
   <!-- true as long as some (nested) component has simpleType/restriction/enumeration  -->
    <xsl:choose>
      <xsl:when test="$elem/self::xsd:simpleType/xsd:restriction/xsd:enumeration">
        <xsl:value-of select="true()"/>
      </xsl:when>
      <xsl:when test="$elem/self::xsd:simpleType/xsd:restriction/xsd:pattern">
        <xsl:value-of select="false()"/>
      </xsl:when>
      <xsl:when test="$elem/self::xsd:element/@type[namespace-uri-from-QName(resolve-QName(., $elem)) eq $kXMLSchemaNamespace]">
        <xsl:value-of select="false()"/>
      </xsl:when>
      <xsl:when test="$elem/self::xsd:element[@type]">
       <!-- <xsl:message><xsl:value-of select="string-join(for $x in $elem/@type,
              $ns in namespace-uri-from-QName(resolve-QName($x, $elem))
            return local-name-from-QName(resolve-QName($x, $elem)),'|')"/>
        </xsl:message>
        <xsl:message>check <xsl:value-of select="for $x in $elem/@type,
              $ns in namespace-uri-from-QName(resolve-QName($x, $elem)) return $lookupTable/d:entry[@ns eq $ns]/*[@name eq replace($x,'^.+:','')]/@name"/></xsl:message>-->
        <xsl:value-of select="
            some $x in $elem/@type,
              $ns in namespace-uri-from-QName(resolve-QName($x, $elem))
            satisfies
              (fnx:hasAnEnumerationList($lookupTable/d:entry[@ns eq $ns]/*[@name eq replace($x,'^.+:','')]))"/>
        </xsl:when>
      <xsl:when test="$elem/self::xsd:attribute/@type[namespace-uri-from-QName(resolve-QName(., $elem)) eq $kXMLSchemaNamespace]">
        <xsl:value-of select="false()"/>
      </xsl:when>
      <xsl:when test="$elem/self::xsd:attribute[@type]">
      <!--  <xsl:message><xsl:value-of select="string-join(for $x in $elem/@type,
              $ns in namespace-uri-from-QName(resolve-QName($x, $elem))
            return local-name-from-QName(resolve-QName($x, $elem)),'|')"/>
        </xsl:message>
        <xsl:message>check <xsl:value-of select="for $x in $elem/@type,
              $ns in namespace-uri-from-QName(resolve-QName($x, $elem)) return $lookupTable/d:entry[@ns eq $ns]/*[@name eq replace($x,'^.+:','')]/@name"/></xsl:message>-->
        <xsl:value-of select="
            some $x in $elem/@type,
              $ns in namespace-uri-from-QName(resolve-QName($x, $elem))
            satisfies
              (fnx:hasAnEnumerationList($lookupTable/d:entry[@ns eq $ns]/*[@name eq replace($x,'^.+:','')]))"/>
      </xsl:when>
      <xsl:when test="$elem/self::xsd:simpleType/xsd:union">
      <!--  <xsl:message><xsl:value-of select="string-join(for $x in tokenize(normalize-space($elem/xsd:union/@memberTypes), ' '),
              $ns in namespace-uri-from-QName(resolve-QName($x, $elem))
            return local-name-from-QName(resolve-QName($x, $elem)),'|')"/>
        </xsl:message>
        <xsl:message>check <xsl:value-of select="for $x in tokenize(normalize-space($elem/xsd:union/@memberTypes), ' '),
              $ns in namespace-uri-from-QName(resolve-QName($x, $elem)) return $lookupTable/d:entry[@ns eq $ns]/*[@name eq replace($x,'^.+:','')]/@name"/></xsl:message>-->
        <xsl:value-of select="
            some $x in tokenize(normalize-space($elem/xsd:union/@memberTypes), ' '),
              $ns in namespace-uri-from-QName(resolve-QName($x, $elem))
              satisfies (for $m in $lookupTable/d:entry[@ns eq $ns]/*[@name eq replace($x, '^.+:','')]
              return
                (fnx:hasAnEnumerationList($m)))"/>
      </xsl:when>
      <xsl:when test="$elem/self::xsd:complexType/xsd:simpleContent/xsd:extension/@base">
        <!--<xsl:message><xsl:value-of select="string-join(for $x in $elem/self::xsd:complexType/xsd:simpleContent/xsd:extension/@base,
              $ns in namespace-uri-from-QName(resolve-QName($x, $elem))
            return local-name-from-QName(resolve-QName($x, $elem)),'|')"/>
        </xsl:message>
        <xsl:message>check <xsl:value-of select="for $x in $elem/self::xsd:complexType/xsd:simpleContent/xsd:extension/@base,
              $ns in namespace-uri-from-QName(resolve-QName($x, $elem)) return $lookupTable/d:entry[@ns eq $ns]/*[@name eq replace($x,'^.+:','')]/@name"/></xsl:message>-->
        <xsl:value-of select="
            some $x in $elem/self::xsd:complexType/xsd:simpleContent/xsd:extension/@base,
              $ns in namespace-uri-from-QName(resolve-QName($x, $elem))
            satisfies
              (fnx:hasAnEnumerationList($lookupTable/d:entry[@ns eq $ns]/*[@name eq replace($x,'^.+:','')]))"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="false()"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>

 <xsl:function name="fnx:splitCamelCase" as="xsd:string*"><!-- also used by integritycheck.xsl via import -->
    <xsl:param name="componentName" as="xsd:string"/>
    <!-- won't catch if ending in a single capital letter CPCAbcDeCPCFGhicpcJ -->
   <xsl:variable name="split"><xsl:value-of select="replace(replace(replace(replace($componentName,
'([a-z0-9]*)([A-Z0-9]{2,})?([A-Z0-9]([a-z]))','$1 $2 $3'),
'([a-z0-9])([A-Z][A-Z0-9]*)','$1 $2'),
'_(V\d+_\d+)',' _$1'),'(^| )([A-Z][a-z]+)(\d[a-z]+)','$1$2 $3')"/></xsl:variable>
    <xsl:sequence select="tokenize($split,'[\s]+')[matches(.,'\w')]"/>
 </xsl:function>
  
  <xsl:function name="fnx:splitEnumeration" as="xsd:string*"><!-- not used here, but via import to integrity check -->
      <xsl:param name="enumerationValue" as="xsd:string"/>
      <xsl:variable name="split">
         <xsl:value-of select="replace(replace($enumerationValue,'([a-z0-9]*)([A-Z0-9]{2,})?([A-Z0-9]([a-z]))','$1 $2 $3'),'([a-z0-9])([A-Z][A-Z0-9]+)','$1 $2')"/>
      </xsl:variable>
      <xsl:sequence select="tokenize(translate($split,'_',' '), '[\s]+')[matches(., '\w')]"/>
   </xsl:function>
  
   <xsl:function name="fnx:getNSPrefix" as="xs:string">
    <xsl:param name="n" as="node()"/>
    <xsl:param name="nsName" as="xs:string"/>
    <xsl:variable name="nsNode" select="$n/namespace::node()[.=$nsName]"/>
    <xsl:value-of select="local-name($nsNode)"/>
  </xsl:function>

  <xsl:function name="fnx:assertSpecificNSPrefix" as="xs:string?">
    <xsl:param name="n" as="node()"/>
    <xsl:param name="nsName" as="xs:string"/>
    <xsl:param name="shouldBePrefix" as="xs:string"/>
    <xsl:variable name="prefix" select="fnx:getNSPrefix($n, $nsName)"/>
    <xsl:choose>
      <xsl:when test="$prefix = '' or $prefix = $shouldBePrefix">
        <xsl:sequence select="()"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="concat($shouldBePrefix, ': prefix (not ', $prefix, ':) must be used for the ', $nsName, ' namespace.')"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>

  <xsl:function name="fnx:assertAnyNSPrefix" as="xs:string">
    <xsl:param name="n" as="node()"/>
    <xsl:param name="nsName" as="xs:string"/>

    <xsl:variable name="prefix" select="fnx:getNSPrefix($n, $nsName)"/>
    <xsl:choose>
      <xsl:when test="$prefix = ''">
        <xsl:value-of select="concat('A namespace prefix must be used for the ', $nsName, ' namespace.')"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="''"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>

  <xsl:function name="fnx:contains-i" as="xs:boolean">
    <!-- a function that computes atomic values should use xsl:sequence rather than xsl:value-of -->
    <xsl:param name="s" as="xs:string"/>
    <xsl:param name="subs" as="xs:string"/>
    <xsl:sequence select="contains(lower-case($s), lower-case($subs))"/>
  </xsl:function>

  <xsl:function name="fnx:find-i" as="xs:boolean">
    <!-- a function that computes atomic values should use xsl:sequence rather than xsl:value-of -->
    <xsl:param name="s" as="xs:string"/>
    <xsl:param name="subs" as="xs:string"/>
    <xsl:sequence select="contains(lower-case($s), lower-case($subs))"/>
  </xsl:function>

  <xsl:function name="fnx:get-xsd-definition" as="node()?">
    <xsl:param name="schemaRoot" as="node()"/>
    <xsl:param name="typeName" as="xsd:string"/>

    <!--<xsl:message>get-xsd-definition(<xsl:sequence select="$typeName"/>)</xsl:message>-->

    <xsl:variable name="typeNameNoPrefix" select="if (contains($typeName, ':')) then substring-after($typeName, ':') else $typeName"/>
    
    <xsl:variable name="nsPrefix" as="xsd:string" select="substring-before($typeName, ':')"/>
    
    <xsl:variable name="nsName" as="xsd:string">
      <xsl:choose>
        <xsl:when test="$nsPrefix = '' and $schemaRoot/xsd:schema/@targetNamespace">
          <xsl:value-of select="$schemaRoot/xsd:schema/@targetNamespace"/>
        </xsl:when>
        <xsl:when test="$nsPrefix = 'com'"> <!-- Fixes bug related to missing com namespace in non-common components --> 
          <xsl:value-of select="$kCommonNamespace"/>
        </xsl:when>
        <xsl:when test="$nsPrefix = ''">
          <xsl:value-of select="'DEFAULT'"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$prefixTable/d:prefixBinding[@nsPrefix = $nsPrefix]/@nsName"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    	
    <xsl:variable name="result" select="$lookupTable/d:entry[@ns=$nsName]/*[@name=$typeNameNoPrefix][1]"/><!-- limited to max depth in fnx:gatherDefinitions (depth < 5) -->

    <!--
    <xsl:message>$result=|<xsl:sequence select="$result"/>|</xsl:message>
    -->
    <xsl:sequence select="$result"/>
  </xsl:function>

  <xsl:function name="fnx:starts-with-ST3-code" as="xsd:boolean">
    <!-- a function that computes atomic values should use xsl:sequence rather than xsl:value-of -->
    <xsl:param name="s" as="xsd:string"/>

    <xsl:sequence select="exists(index-of($st3Codes,substring($s,1,2)))"/>
  </xsl:function>

  <xsl:function name="fnx:has-fixed-attribute" as="xsd:boolean">
    <xsl:param name="el" as="element()"/>
    <xsl:param name="attName" as="xsd:string"/>
    <xsl:param name="use" as="xsd:string"/>
    <xsl:param name="fixedRegex" as="xsd:string"/>

    <xsl:variable name="def" select="fnx:get-xsd-definition(root($el), $el/@type)"/>
    <xsl:variable name="attdef1" select="fnx:get-attributes-from-type-recursive($def,$attName)"/>
      <xsl:variable name="attdef2" select="if ($attdef1/@name) then $attdef1 else fnx:get-xsd-definition(root($el), $attdef1/@ref)"/>
      <xsl:value-of select="boolean($attdef1[@use=$use or (not(@use) and $use = 'optional')] and ($attdef1|$attdef2)[matches(@fixed, $fixedRegex)])"/>
   </xsl:function>
  <xsl:function name="fnx:has-attribute" as="xsd:boolean">
      <xsl:param name="el" as="element()"/>
      <xsl:param name="attName" as="xsd:string"/>
      <xsl:param name="use" as="xsd:string"/>
      
      <xsl:variable name="def" select="fnx:get-xsd-definition(root($el), $el/@type)"/>
      <xsl:variable name="attdef1" select="fnx:get-attributes-from-type-recursive($def,$attName)"/>
      
      <xsl:message>
          checking <xsl:value-of select="concat($attName, ' ', $use)"/>
      </xsl:message>
      <xsl:variable name="attdef2" select="if ($attdef1/@name) then $attdef1 else fnx:get-xsd-definition(root($el), $attdef1/@ref)"/>
      <xsl:value-of select="boolean($attdef1[@use=$use or (not(@use) and $use = 'optional')])"/>
  </xsl:function>
  
  <xsl:function name="fnx:get-attributes-from-type-recursive" as="element()*">
      <xsl:param name="ty" as="element()?"/>
      <xsl:param name="attName" as="xsd:string"/>
      <xsl:variable name="local-def" select="$ty//xsd:attribute[(@name=$attName or ends-with(@ref,$attName))]"/>
      <xsl:choose>
         <xsl:when test="$local-def">
            <xsl:sequence select="$local-def"/>
         </xsl:when>
         <xsl:otherwise>
          <xsl:variable name="extension" select="$ty/(xsd:complexContent|xsd:simpleContent)/xsd:extension"/>
          <xsl:choose>
             <xsl:when test="$extension">
               <xsl:variable name="base-def-ext" select="fnx:get-xsd-definition(root($ty), $extension/@base)"/>
              <xsl:sequence select="fnx:get-attributes-from-type-recursive($base-def-ext,$attName)"/>
             </xsl:when>
             <xsl:otherwise>
               <xsl:variable name="restriction" select="$ty/(xsd:complexContent|xsd:simpleContent)/xsd:restriction"/>
             <xsl:if test="$restriction">
               <xsl:variable name="base-def-res" select="fnx:get-xsd-definition(root($ty), $restriction/@base)"/>
              <xsl:sequence select="fnx:get-attributes-from-type-recursive($base-def-res,$attName)"/>
             </xsl:if>
           </xsl:otherwise>
          </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:function>
  <xsl:function name="fnx:duplicate-type-model" as="element()*">
    <xsl:param name="thisType" as="node()"/>
        <xsl:message>Fallback since can't find <xsl:value-of select="$sd04OutputFile"/></xsl:message>
        <xsl:sequence select="$allSchemasInDir/*:schema[@targetNamespace = ($kCommonNamespace,$kIPOCommonNamespace,$definitions/d:namespace/@ns)]/*[local-name() = ('complexType','simpleType')][@name != $thisType/@name][deep-equal((descendant::*[not(local-name() = 'annotation')]/name(),descendant::*[not(local-name() = 'annotation')]/@*,@*[not(local-name() = 'name')]),($thisType/descendant::*[not(local-name() = 'annotation')]/name(),$thisType/descendant::*[not(local-name() = 'annotation')]/@*,$thisType/@*[not(local-name() = 'name')]))]"/>
  </xsl:function>
  <xsl:function name="fnx:duplicate-name" as="xs:string*">
    <xsl:param name="component" as="node()"/>
        <xsl:message>Fallback since can't find <xsl:value-of select="$gd24OutputFile"/></xsl:message>
        <xsl:variable name="duplicateFound" select="$allSchemasInDir/xsd:schema[tokenize(@targetNamespace,'[/:]')[last()] eq $targetNamespaceName]/*[@name eq $component/@name]"/>
        <xsl:if test="count($duplicateFound) gt 1">
          <xsl:sequence select="$duplicateFound/replace(base-uri(),'.*/([^/]+/)(Document/)?([^/]+)$','$1$3')"/>
        </xsl:if>
  </xsl:function>
  <xsl:function name="fnx:duplicate-of-common" as="xsd:string*">
    <xsl:param name="component" as="node()"/>
    <xsl:param name="componentNamespace" as="xsd:string"/>
    <xsl:if test="not($componentNamespace = ($kCommonNamespace,$kIPOCommonNamespace))">
    <xsl:message>fallback: check collection from wipo_xsd.sch</xsl:message>
      <xsl:variable name="duplicateFoundInCommon" select="$allSchemasInDir/*:schema[@targetNamespace = ($kIPOCommonNamespace,$kCommonNamespace)]/key('component-by-name',$component/@name)"/>
      <xsl:if test="exists($duplicateFoundInCommon)">
        <xsl:sequence select="$duplicateFoundInCommon/@name"/>
      </xsl:if>
    </xsl:if>
  </xsl:function>
  <xsl:function name="fnx:uses-type" as="xsd:boolean">
    <!-- Rough estimation of whether the given XSD node, n, uses the
         given type, typeName.  Reproducing all of XSD type semantics
         here would be a monumental task; the goal is just to cover
         many of the common cases.
    -->
    <xsl:param name="n" as="node()?"/>
    <xsl:param name="usesTypeName" as="xsd:string"/>
    <xsl:param name="depth" as="xsd:integer"/>

    <xsl:choose>
      <xsl:when test="$depth &lt; 7"> <!-- performance concession and loop avoidance -->
        <xsl:variable name="result">
          <xsl:choose>
            <xsl:when test="empty($n)">
              <xsl:value-of select="false()"/>
            </xsl:when>
            <xsl:when test="local-name($n) = 'extension'">
              <xsl:value-of select="$n/@base = $usesTypeName
                                    or
                                    fnx:uses-type(fnx:get-xsd-definition(root($n), $n/@base), $usesTypeName, $depth+1)
                                    or
                                    fnx:uses-type($n/*[1], $usesTypeName, $depth+1)
                                    "/>
            </xsl:when>
            <xsl:when test="local-name($n) = 'element'">
              <xsl:choose>
                <xsl:when test="$n/@type and $n[@type = $usesTypeName]">
                  <xsl:value-of select="true()"/>
                </xsl:when>
                <xsl:when test="$n/@type">
                  <xsl:value-of select="fnx:uses-type(fnx:get-xsd-definition(root($n), $n/@type), $usesTypeName, $depth+1)"/>
                </xsl:when>
                <xsl:when test="$n/@ref and $n[@ref = $usesTypeName]">
                  <xsl:value-of select="true()"/>
                </xsl:when>
                <xsl:when test="$n/@ref">
                  <xsl:value-of select="fnx:uses-type(fnx:get-xsd-definition(root($n), $n/@ref), $usesTypeName, $depth+1)"/>
                </xsl:when>
                <xsl:otherwise><xsl:value-of select="false()"/></xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:when test="local-name($n) = 'attribute'">
              <xsl:choose>
                <xsl:when test="$n/@type and $n[@type = $usesTypeName]">
                  <xsl:value-of select="true()"/>
                </xsl:when>
                <xsl:when test="$n/@type">
                  <xsl:value-of select="fnx:uses-type(fnx:get-xsd-definition(root($n), $n/@type), $usesTypeName, $depth+1)"/>
                </xsl:when>
                <xsl:otherwise>
                  <!-- TBD -->
                  <xsl:value-of select="false()"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:when test="local-name($n) = 'complexType'">
              <xsl:choose>
                <!-- For now, if type is used anywhere beneath the
                     complexType by an xsd:element or xsd:extension/@base,
                     we'll say it's good enough for us. Could handle
                     xsd:sequence, xsd:choice, etc differently. -->
                <xsl:when test="$n/@name = $usesTypeName"><xsl:value-of select="true()"/></xsl:when>
                <xsl:when test="some $child in $n//(xsd:element|xsd:extension) satisfies fnx:uses-type($child, $usesTypeName, $depth+1)"><xsl:value-of select="true()"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="false()"/></xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:when test="local-name($n) = 'simpleType'">
              <xsl:choose>
                <xsl:when test="$n/xsd:union">
                  <xsl:value-of select="contains($n/xsd:union/@memberTypes, $usesTypeName)"/>
                </xsl:when>
                <xsl:otherwise><xsl:value-of select="false()"/></xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="false()"/></xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <!--<xsl:message>*** fnx:uses-type() is returning <xsl:value-of select="$result"/> ***</xsl:message>-->
        <xsl:value-of select="$result"/>
        
        <!--<xsl:message>checking <xsl:value-of select="concat($n/name(),' ',$n/@*[1]/local-name(),' (',$n/@*[local-name() eq 'name' or local-name() eq 'type' or local-name() eq 'ref'][1],')')"/> for <xsl:value-of select="$usesTypeName"/> (<xsl:value-of select="$result"/>)</xsl:message>-->
      </xsl:when>
      <xsl:otherwise><xsl:value-of select="false()"/></xsl:otherwise>
    </xsl:choose>
  </xsl:function>

<!--
  <pattern id="tp">
    <title>TESTpattern</title>
    <p>This is paragraph 1.</p>
    <p>This is paragraph 2.</p>
    <p class="note">note goes here</p>
    <p class="description">description goes here</p>
    <p class="ruleDescription">rule description goes here</p>
    <p class="autoNotes">auto notes go here</p>
    <rule context="/xsd:schema" role="INFO">
      <report test="." flag="MANUAL" fpi="WIPO ST.96 Conformance Validation">This is the INFO message from TESTpattern.</report>
    </rule>
  </pattern>
-->

<!-- A Rule Conformance Method is considered:
      Auto if there is no @flag set to 'MANUAL' or 'DELETED'
      Partial if there are both @flag = 'MANUAL' and asserts without that flag
      Manual if there is only @flag = 'MANUAL'
      Deleted if @flag = 'DELETED'
      else 'UNKNOWN'
  
  -->
  <!--  
       Assert tests results in failed-assert when not every condition is true 
       Report only fires when the condition is met 
        Note: <report test="false()", is technically nonsensical, but setting to true results in major performance problems...these reports are still used in calculating the method (partial, auto, manual)
  -->
  
  <!-- Use diagnostics to return component name (instead of relying on filename, b/c there may be discrepancies in design schemas, or when validating flattened schemas):
        <svrl:active-pattern document="file:/C:/Users/hello/Documents/Schema/ApplicationBody_V4_0.xsd"
                              name="GD-07"/>
         <svrl:fired-rule context="  xsd:complexType[@name]                    | xsd:simpleType[@name]                    | xsd:element[@name]                    | xsd:attribute[@name]"/>
         <svrl:failed-assert test="fnx:is-exception('GD-07',@name) or string-length(@name) &lt;= 35"
                             flag="AUTO"
                             role="WARNING"
                             location="/*:schema[namespace-uri()='http://www.w3.org/2001/XMLSchema'][1]/*:element[namespace-uri()='http://www.w3.org/2001/XMLSchema'][18]">
            <svrl:text>
              The length of the
              element
              named
              DepositedBiologicalMaterialReference
              is
              36.
            </svrl:text>
            <svrl:diagnostic-reference diagnostic="giveComponentName">DepositedBiologicalMaterialReference</svrl:diagnostic-reference>
         </svrl:failed-assert>
  
  -->
  
  
<!-- In a pattern
       * the first rule with a @context matching the element is applied
       * subsequent rules in the same pattern that match the element are ignored  -->
  <pattern>
    <title>GD-01</title>
    <rule context="/">
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  <pattern>
    <title>GD-02</title>
    <rule context="/">
      <report test="false()" flag="MANUAL"/>
      <assert test="xsd:schema" flag="AUTO" role="ERROR" diagnostics="namespaceName uri" see="#GD-02">The root element is not an xsd:schema element.</assert>
    </rule>
    <rule context="xsd:simpleType/xsd:restriction[not(@base/resolve-QName(.,parent::node()) = ( resolve-QName('xsd:token',.), resolve-QName('xsd:string',.)))][xsd:enumeration]">
      <!-- XML Editors would validate this, but just in case... -->
      <let name="base-type-definition" value="fnx:get-xsd-definition(root(.),@base)"/>
      <assert test="every $x in xsd:enumeration/@value satisfies $x = ($base-type-definition/xsd:restriction/xsd:enumeration/@value)" flag="AUTO" role="ERROR" diagnostics="namespaceName uri" see="#GD-02">
        Schema is invalid. The values <value-of select="string-join(for $x in xsd:enumeration/@value return $x[not(. = ($base-type-definition/xsd:restriction/xsd:enumeration/@value))],' | ')"/> must be specified by the enumerations of type <value-of select="@base"/>. 
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>GD-03</title>
    <rule context="/">
        <let name="this-as-text" value="unparsed-text(document-uri(/))"/>
        <let name="first-line" value="replace($this-as-text,'^(.*?)[\n\r]+.*$','$1','s')"/>
        <assert test="matches($first-line,'encoding\s*=\s*&quot;(UTF|utf)-8&quot;')" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#GD-03">The XML declaration (first line) of the document does not indicate an encoding of UTF-8.</assert>
    </rule>
  </pattern>
  <pattern>
    <title>GD-04</title>
    <!-- Type, element and attribute names MUST be composed of words in the English language, using the primary English spellings provided in the Oxford English Dictionary. The only permitted exceptions are the acronyms, abbreviations and other word truncations listed in Appendix C. -->
    <!-- after splitting camelcased component name, should run words against dictionary check, with exceptions as provided in Appendix C (must be done in integrity check instead of here) -->
    <rule context="/">
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  <pattern>
    <title>GD-05</title>
    <rule context="/">
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  <pattern>
    <title>GD-06</title>
    <rule context="  xsd:complexType[@name]
                   | xsd:simpleType[@name]
                   | xsd:element[@name]
                   | xsd:attribute[@name]">
      <assert test="matches(@name, '^[a-zA-Z0-9]+$')"
              flag="AUTO"
              role="ERROR" diagnostics="componentName namespaceName uri" see="#GD-06">
        The name of
        <value-of select="concat(local-name(.), ' ', @name)"/>
        contains invalid characters.
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>GD-07</title>
    <rule context="xsd:complexType[@name]
                   | xsd:simpleType[@name]
                   | xsd:element[@name]
                   | xsd:attribute[@name]">
      
      <assert test="fnx:is-exception('GD-07',@name) or (string-length(@name) le 35 and local-name() = ('element','attribute')) or (string-length(@name) le (35+4) and local-name() = ('complexType','simpleType'))"
              flag="AUTO"
              role="WARNING" diagnostics="componentName namespaceName uri" see="#GD-07">
        The length of the
        <value-of select="local-name(.)"/>
        named
        <value-of select="@name"/>
        is
        <value-of select="string-length(@name)"/>.
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>GD-08</title>
    <rule context="/">
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  <!-- Note: All UCC rules are only partially checked.  Without
       consulting a full dictionary and making assumption about word
       boundaries, we cannot check interior capitalizations.  Examples
       we catch: 'badElementName' and 'BADELEMENTNAME'.  Examples we
       miss: 'BadelementName' and 'BadElementname'. -->
  <pattern>
    <title>GD-09</title>
    <rule context="xsd:element[@name]">
      <assert test="matches(@name,'^[A-Z]')" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#GD-09">
        The element name <value-of select="@name"/> does not start with an upper-case letter.
      </assert>
      <assert test="not(matches(@name,'^[A-Z][A-Z][A-Z]+$')) or
                    (@name = $approvedAcronyms/AAs/AA/short)" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#GD-09">
        The element name <value-of select="@name"/> contains all
        upper-case letters instead of using camel case.
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>GD-10</title>
    <rule context="xsd:complexType[@name] | xsd:simpleType[@name]">
      <assert test="matches(@name,'^[A-Z]')" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#GD-10">
        The <value-of select="local-name()"/> name <value-of
        select="@name"/> does not start with an upper-case letter.
      </assert>
      <assert test="not(matches(@name,'^[A-Z][A-Z]+$'))"
              flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#GD-10">
        The <value-of select="local-name()"/> name <value-of
        select="@name"/> contains all upper-case letters instead of
        using camel case.
      </assert>
      <assert test="ends-with(@name,'Type')" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#GD-10">
        The <value-of select="local-name()"/> name <value-of
        select="@name"/> does not end with Type.
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>GD-11</title>
    <rule context="xsd:attribute[@name]">
      <assert test="matches(@name,'^[a-z]')" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#GD-11">
        Attribute name <value-of select="@name"/> does not start with
        a lower-case letter.
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>GD-12</title>
    <!-- Limitations: 
      if long value has descriptive text instead of just an expansion of the acronym/abbreviation, then this rule will not be triggered 
      
      GD-13 covers acronyms in attributes 
      GD-14 covers acronyms in type and element names
    -->
    <rule context="xsd:element[@name]">
      <let name="name" value="@name"/>
      <let name="aaEntry" value="$approvedAcronyms/AAs/AA[contains(replace(lower-case($name), ' ', ''), replace(lower-case(long), ' ', ''))]"/>
         <assert test="fnx:is-exception('GD-12',@name) or not($aaEntry)" role="ERROR" flag="AUTO" diagnostics="componentName namespaceName uri" see="#GD-12">
            <value-of select="replace($aaEntry/long, ' ', '')"/> in <value-of select="@name"/> should be abbreviated as <value-of select="$aaEntry/short"/>.
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>GD-13</title>
    <!--
        Automation concerns:

        (1) Single-letter and double-letter abbreviations cannot be
        detected apart from regular single and double letters within
        words.

        (2) Embedded multi-letter sequences can appear naturally
        within words without being abbreviations.

        Assumption to automate:

        (1) Don’t automate single-letter and double-letter
        abbreviations.

        (2) Accept some false-positive reports.
    -->
    <rule context="xsd:attribute[@name]">
      
       <let name="words" value="fnx:splitCamelCase(@name)"/>
       <let name="unapprovedAbbreviationOrAcronym" value="$words[position() ne 1][matches(.,'[A-Z][A-Z0-9]+')][empty(index-of($approvedAcronyms/AAs/AA/short,.))]"/>
        <let name="approvedAcronymWrongCase" value="$words[position() ne 1][exists(index-of($approvedAcronyms/AAs/AA/short/lower-case(.),lower-case(.))) and empty(index-of($approvedAcronyms/AAs/AA/short,.))]"/>
        <let name="firstWordAcronym" value="$words[1][exists(index-of($approvedAcronyms/AAs/AA/short/lower-case(.),lower-case(.)))]"/><!-- proper first word which is acronym must be ALL lowercase -->
      <!-- what about abbreviations like:
          BioDeposit, ExtRef, ThreeDM, ThreeDS
      -->
      <!--<xsl:message>words: <xsl:value-of select="$words"/></xsl:message>
      <xsl:message><xsl:value-of select="concat('unapproved abbreviation: ',$unapprovedAbbreviationOrAcronym)"/></xsl:message>
      <xsl:message><xsl:value-of select="concat('improper case abbreviation: ',$approvedAcronymWrongCase)"/></xsl:message>-->
      <assert test="fnx:is-exception('GD-13',@name) or (empty($unapprovedAbbreviationOrAcronym) and empty($approvedAcronymWrongCase) and not(exists($firstWordAcronym) and lower-case($firstWordAcronym) ne $firstWordAcronym))" role="ERROR" flag="AUTO" diagnostics="componentName namespaceName uri" see="#GD-13">
        Attribute <value-of select="@name"/> contains these improperly capitalized abbreviations: <value-of select="string-join(distinct-values(($firstWordAcronym[lower-case(.) ne .],$unapprovedAbbreviationOrAcronym,$approvedAcronymWrongCase)), ', ')"/>.</assert>
    </rule>
  </pattern>
  <pattern>
    <title>GD-14</title>
    <rule context="xsd:element[@name]|xsd:complexType[@name]|xsd:simpleType[@name]">
        <let name="words" value="fnx:splitCamelCase(@name)"/> 
        
      <!-- assume properly camel-cased, or else would catch in manual checking (against dictionary) for GD-04 and GD-05 -->
        <let name="abbreviationOrAcronym" value="$words[matches(.,'[A-Z][A-Z0-9]+')][empty(index-of($approvedAcronyms/AAs/AA/short,.))]"/>
        <let name="approvedAcronymWrongCase" value="$words[exists(index-of($approvedAcronyms/AAs/AA/short/lower-case(.),lower-case(.))) and empty(index-of($approvedAcronyms/AAs/AA/short,.))]"/>
      <assert test="fnx:is-exception('GD-14',@name) or empty(($abbreviationOrAcronym,$approvedAcronymWrongCase))" role="ERROR" flag="AUTO" diagnostics="componentName namespaceName uri" see="#GD-14">
         Component <value-of select="@name"/> contains these improperly capitalized abbreviations: <value-of select="string-join(distinct-values(($abbreviationOrAcronym,$approvedAcronymWrongCase)), ', ')"/>.
      </assert>
      </rule>
  </pattern>
  <pattern>
    <title>GD-15</title>
    <!-- Complex type names SHOULD include a meaningful Object Class Term.
 -->
    <rule context="xsd:complexType[@name]">
      <report test="false()" flag="MANUAL"/>
      <let name="words" value="fnx:splitCamelCase(@name)"/>
      <assert test="fnx:is-exception('GD-15',@name) or (some $x in $words satisfies not($x = ('Type',$kRepresentationTerms)))" see="#GD-15" role="WARNING" flag="AUTO" diagnostics="componentName namespaceName uri">
        No Object Class Term was found in the complexType name <value-of select="@name"/>. Object Class refers to an activity or object within a business context and represents the logical data grouping or aggregation (in a logical data model) to which a Property belongs.
      </assert>
    </rule>
    
  </pattern>
  <pattern>
    <title>GD-16</title>
    <rule context="/">
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  <pattern>
    <title>GD-17</title>
    <rule context="xsd:element[@name]">
      <report test="false()" flag="MANUAL"/>
      <let name="words" value="fnx:splitCamelCase(@name)"/>
      <assert test="fnx:is-exception('GD-17',@name) or not(fnx:isBasicComponent(.)) or (count($words) gt 1)" diagnostics="componentName namespaceName uri" see="#GD-17" role="WARNING">
        Name consists only of <value-of select="string-join($words,', ')"/>. Missing Object Class Term and/or Property Term. Object Class refers to an activity or object within a business context and represents the logical data grouping or aggregation (in a logical data model) to which a Property belongs. Property Term identifies characteristics of the Object Class.
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>GD-18</title>
    <rule context="/">
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  <pattern>
    <title>GD-19</title>
    <rule context="/">
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  <pattern>
    <title>GD-20</title>
    <rule context="/">
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  <pattern>
    <title>GD-21</title>
    <rule context="/">
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  <pattern>
    <title>GD-22</title>
    <rule context="xsd:element[@name] | xsd:attribute[@name] | xsd:simpleType[@name] | xsd:complexType[@name]">
      <let name="name" value="@name"/>
      <let name="nameWithRepeatedRepTerm" value="string-join(
                                                 (for $repTerm in $kRepresentationTerms
                                                 return 
                                                 if (contains(lower-case($name),
                                                 lower-case(concat($repTerm, $repTerm))))
                                                 then $repTerm
                                                 else ''),
                                                 '')"/>
      <assert test="$nameWithRepeatedRepTerm = ''" role="ERROR" flag="AUTO" diagnostics="componentName namespaceName uri" see="#GD-22">
        <value-of select="$name"/> contains a repeated representation term (<value-of select="$nameWithRepeatedRepTerm"/>).
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>GD-23</title>
    <!-- Where a representation term is required, the Representation Terms in Appendix B MUST be used for representation terms in Basic component names
    
    related to GD-17:
    Names of basic elements (those based on a simple or complex type that do not permit children) SHOULD consist of an Object Class Term, Property Term, and where applicable a Representation Term. Qualifier Terms may precede the Object Class term and Property Term.
    
    requirements based on data type mapping in Appendix B
    implied that all components must have explicit type (integrity check, not rule)
    -->
    <rule context="xsd:element[@name[not(ends-with(.,'Code'))]]
                   | xsd:attribute[@name[not(ends-with(.,'Code'))]]">
<!-- exclude 'Code' from checking if a diff rep term should be used, since SD-38 already covers, and it is a manual/semi-manual check -->
      <let name="name" value="@name"/>
      <let name="repTerm" value="fnx:getRepTerm($name)"/>
      <let name="allowedRepTerms" value="fnx:allowedRepTerms(.)"/>
      <assert test="fnx:is-exception('GD-23',@name)
                    or not(fnx:isBasicComponent(.)) 
                    or (fnx:isBasicComponent(.) and (fnx:usesAllowedRepTerm($repTerm, $allowedRepTerms) or $allowedRepTerms = 'EXEMPT'))"
              role="ERROR" flag="AUTO" diagnostics="componentName namespaceName uri datatype" see="#GD-23">
        <value-of select="$name"/>
        must have
        <value-of select="if ($allowedRepTerms = '') then ' no representation term, ' else concat(fnx:makeCommaList(tokenize($allowedRepTerms, ' '), 'or'), ' as a representation term,')"/>
        <value-of select="if ($repTerm = '') then ' but it has none.' else concat(' not ', $repTerm, '.')"/><!-- additional info if type is typically reserved for Rep term -->
        <value-of select="if (resolve-QName(@type,..) =  (xs:QName('xsd:boolean'),xs:QName('com:DateType'),xs:QName('xsd:date'),xs:QName('xsd:time'),xs:QName('xsd:dateTime'),xs:QName('com:MeasureType'),xs:QName('com:QuantityType'), xs:QName('com:IdentifierType'),xs:QName('xsd:anyURI'))) then concat(' ',$name,' uses ',@type) else ()"/>
      </assert>
      <assert test="fnx:is-exception('GD-23',@name) or not(fnx:isBasicComponent(.)) or (fnx:isBasicComponent(.) and ((string-length($repTerm) or $allowedRepTerms = 'EXEMPT') or string-length($allowedRepTerms)))" role="ERROR" flag="AUTO" diagnostics="componentName namespaceName uri datatype" see="#GD-23">
        <value-of select="$name"/> is a basic component which must have a representation term, but it has none. Representation terms from Appendix B are: <value-of select="string-join($kRepresentationTerms,', ')"/>.  
      </assert>
      
    </rule>
  </pattern>
  <pattern>
    <title>GD-24</title><!-- Within a namespace, all type, element and attribute names MUST be unique. -->
    <rule context="xsd:element[@name] | xsd:attribute[@name] | xsd:simpleType[@name] | xsd:complexType[@name]">
      <let name="thisName" value="@name"/>
      <let name="componentName" value="local-name()"/>
      <let name="count" value="count(//*[@name = $thisName])"/>
      <assert test="$count = 1" role="ERROR" flag="AUTO" diagnostics="componentName namespaceName uri" see="#GD-24">
        <value-of select="$componentName"/> Name <value-of select="$thisName"/> is not unique.
      </assert>
      <let name="duplicatesFound" value="if (doc-available($gd24OutputFile)) then (doc($gd24OutputFile)/duplicate-names/component[@name eq $thisName][@ns eq $targetNamespaceName]/@uri) else (for $x in fnx:duplicate-name(.) return concat($x,'*'))"/>
      <assert test="empty($duplicatesFound) or $isFlattened" role="ERROR" flag="AUTO" diagnostics="componentName namespaceName uri" see="#GD-24">
        Name <value-of select="$thisName"/> is not unique. Found <value-of select="$componentName"/> in <value-of select="string-join($duplicatesFound,', ')"/>
        
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>GD-25</title>
    
    <rule context="xsd:element[@name] | xsd:attribute[@name] | xsd:simpleType[@name] | xsd:complexType[@name]">
      <let name="words" value="fnx:splitCamelCase(replace(@name,'GoodsServices',''))"/>
      <let name="possible-plural" value="for $x in $words[. != 'Claims'] return $x[matches(.,'[a-zA-Z]{2,}[^usi]s(\s|$)')]"/>
      
      <assert test="fnx:is-exception('GD-25',@name) or 
        empty($possible-plural)" role="WARNING" flag="AUTO" diagnostics="componentName namespaceName uri" see="#GD-25">
        Possible plural form in name of component <value-of select="@name"/>: <value-of select="string-join($possible-plural,', ')"/>
      </assert>
      
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  <pattern>
    <title>GD-26</title>

    <!-- A collection must be named with Bag suffix -->
    <!-- ** NEED TO DO: improve what is a bag/what is not a bag..... -->
    <rule context="/xsd:schema/xsd:element[@name and fnx:isACollection(.)]"><!-- exclude if already in a bag??? -->
      <assert test="fnx:is-exception('GD-26',@name) or
                    .[ends-with(@name, 'Bag')]" role="WARNING" flag="AUTO" diagnostics="componentName namespaceName uri" see="#GD-26">
        The '<value-of select="@name"/>' element is a collection, but its name lacks a 'Bag' suffix.
      </assert>
      <report test="false()" flag="MANUAL"/>
    </rule>

    <rule context="/xsd:schema/xsd:complexType[@name and fnx:isACollection(.)]">
      <assert test="fnx:is-exception('GD-26',@name) or
                    .[ends-with(@name, 'BagType')]" role="WARNING" flag="AUTO" diagnostics="componentName namespaceName uri" see="#GD-26">
        The '<value-of select="@name"/>' complexType is a collection, but its name lacks a 'BagType' suffix.
      </assert>
      <report test="false()" flag="MANUAL"/>
    </rule>

    <!-- A non-collection must not be named with Bag suffix -->

    <rule context="/xsd:schema/xsd:element[@name and not(fnx:isACollection(.))]">
      <assert test="fnx:is-exception('GD-26',@name) or
                    .[not(ends-with(@name, 'Bag'))]" role="WARNING" flag="AUTO" diagnostics="componentName namespaceName uri" see="#GD-26">
        The '<value-of select="@name"/>' element is not a collection, but its name has a 'Bag' suffix. It does not have at least one element which repeats. 
      </assert>
      <report test="false()" flag="MANUAL"/>
    </rule>
    
    <rule context="/xsd:schema/xsd:complexType[@name][xsd:simpleContent]">
      <assert test="fnx:is-exception('GD-26',@name) or .[not(ends-with(@name, 'BagType'))]" role="WARNING" flag="AUTO" diagnostics="componentName namespaceName uri" see="#GD-26">
        The '<value-of select="@name"/>' complexType is not a collection (it has simpleContent), but its name has a 'BagType' suffix. It does not have at least one element which repeats.
      </assert>
    </rule>
    
    <rule context="/xsd:schema/xsd:complexType[@name and not(fnx:isACollection(.))]">
      <!-- ** double-check -->
      <assert test="fnx:is-exception('GD-26',@name) or .[not(ends-with(@name, 'BagType'))]" role="WARNING" flag="AUTO" diagnostics="componentName namespaceName uri" see="#GD-26">
        The '<value-of select="@name"/>' complexType is not a collection, but its name has a 'BagType' suffix. It does not have at least one element which repeats.
      </assert>
      <report test="false()" flag="MANUAL"/>
    </rule>

    <rule context="/xsd:schema/xsd:simpleType[@name]">
      <!-- simpleTypes cannot contain element children... -->
      <assert test="fnx:is-exception('GD-26',@name) or
                    .[not(ends-with(@name, 'BagType'))]" role="WARNING" flag="AUTO" diagnostics="componentName namespaceName uri" see="#GD-26">
        The '<value-of select="@name"/>' simpleType is not a collection of elements, but its name has a 'BagType' suffix. 
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>GD-27</title>
    <rule context="xsd:complexType[@name]|xsd:simpleType[@name]|xsd:element[@name]|xsd:attribute[@name]">
         <let name="nameparts" value="fnx:words-from-name(@name)"/>
         <let name="connectingWordsInName" value="string-join($connectingWords[. = $nameparts], ', ')"/>
         <assert test="fnx:is-exception('GD-27',@name) or $connectingWordsInName=''" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#GD-27">
        Name of <value-of select="concat(local-name(.),' ',@name)"/>
        contains the connecting word(s) <value-of select="$connectingWordsInName"/>.
      </assert>
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  <pattern>
    <title>GD-28</title>
    <rule context="/">
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  <pattern>
    <title>GD-29</title>
    <!-- Type and element names MUST NOT refer to article and rule numbers. For example, PCTRule702C for the PCT. -->
      <rule context="xsd:element[@name]|xsd:complexType[@name]">
         <let name="name" value="@name"/>
         <let name="legalReferenceMatches" value="$legalReferencePrefixes[matches($name,concat(.,'\d'))]"/>
         <assert test="fnx:is-exception('GD-29',@name) or
                    not($legalReferenceMatches)" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#GD-29">
        The name <value-of select="@name"/> contains an article or rule number (<value-of select="$legalReferenceMatches"/> followed by a digit).
      </assert>
         <report test="false()" flag="MANUAL"/>
      </rule>
  </pattern>
  <pattern>
    <title>GD-30</title>
    <rule context="/">
         <assert test="matches($localFile,'^[a-zA-Z0-9_.]+$')" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#GD-30">
        The file name <value-of select="$localFile"/> contains invalid
        characters.
      </assert>
      </rule>
  </pattern>
  <pattern>
    <title>GD-31</title>
    <!-- A Schema filename MUST consist of two compulsory parts with one delimiter and optional version information with two additional delimiters, i.e.: <component name>{“_”“V”<major version number>“_”<minor version number>“}.”<file extension>. For example, EmailAddressType.xsd, languageCode.xsd, ApplicationBody_V1_0.xsd. -->
    
    <!-- Why is there nothing in GD-31 about the version in the file
         name matching schema/@version?  GD-32 addresses it but for
         drafts. 
         VH: put this check in SD-31 (implied by "The schema for a Document component MUST declare a required attribute named st96Version on the root element with a fixed value that matches the ST.96 XML Schema release version")??
         SD-28 ensures all version attributes are consistent across schemas
         SD-30 covers format of version attribute
         SD-63 The schema for a Document component MUST declare an optional ipoVersion attribute on the root element with a fixed value that matches the IPO’s implementation release version...
    -->
    <!-- overlaps with SD-64: Schema release folder, a document level schema filename and a flattened schema filename MUST contain matching version information comprising the major and minor version number. -->
    <!-- for flattened:
          one Common_VM_n.xsd
          FlattenedMathML3.xsd
          OASISTable_VM_n.xsd
          
    -->
    <rule context="/xsd:schema[(count(*[@name]) lt 2) or ($inSubdirName = 'Document')]"><!-- refers to design schemas, or document schemas for components; exclude flattened schemas; separate from rules for GD-32 (draft) and GD-33 (test) -->
      <let name="fileNameVersion"
           value="fnx:xsdVersionFromFileName($localFile)"
           />
      <let name="fileNamePart" value="replace($localFile,'^([^_]+)_.+','$1')"/>
      <let name="componentName" value="*[@name]/@name"/>
      <let name="isDocumentComponent" value="$inSubdirName = 'Document'"/>
      <!-- TEST:
          -  <component name>{“_”“V”<major version number>“_”<minor version number>“_”<patch version number>}“.”<file extension>
          -  A Schema filename MUST consist of component name,
          -  A Schema filename must consist of version information of form VM_n_p
          -  version information applies only to document-level schemas
      -->
      
          <assert test="matches($localFile, '(_[DT]\d|_draft|_test)', 'i') or (matches($localFile,concat('^',$componentName,'(_V[0-9]+_[0-9]+(_[1-9]\d*)?)?','\.[a-zA-Z0-9]+$')))" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#GD-31">
            The file name <value-of select="$localFile"/> does not follow the required format &#x003C;<value-of select="$componentName"/>&#x003E;{_V&#x003C;MajorVersionNumber&#x003E;_&#x003C;MinorVersionNumber&#x003E;_&#x003C;OptionalPatchVersionNumber&#x003E;}.&#x003C;FileExtension&#x003E;
          </assert>
      <assert test="matches($localFile, '(_[DT]\d|_draft|_test)', 'i') or matches($localFile,concat(@version,'\.[a-zA-Z0-9]+$')) or not($inSubdirName = 'Document')" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#GD-31">
        The file name <value-of select="$localFile"/> does not match the @version attribute value <value-of select="@version"/>
      </assert>
         
    </rule>
  </pattern>
  <pattern>
    <title>GD-32</title>
    <!-- A draft Schema filename MUST consist of four compulsory parts with two delimiters and optional version information with two additional delimiters, i.e.: <component name>{“_”“V”<major version number>“_”<minor version number>“}_”“D”<revision number>“.”<file extension>, for example, Contact_D3.xsd, TrademarkApplication_V1_1_D1. If a draft schema is based on an existing schema and has version information in its filename, the major and minor version numbers in the draft schema filename SHOULD be the same as specified in the schema file that the draft schema is based on. If a draft schema is new, the major version number in the draft schema filename SHOULD be the same number as specified in the corresponding namespace and a minor version number in the draft schema file SHOULD be zero “0”.
 -->
    <rule context="/xsd:schema[(count(*[@name]) lt 2) or ($inSubdirName = 'Document')]">
      <!--<let name="xsdNameIsOk"
           value="(not(matches($localFile, 'draft', 'i'))
                    and not(matches($localFile, '_D[0-9]+', 'i')))
                    or
                    matches($localFile,'^[a-zA-Z0-9]+(_V[0-9]+_[0-9]+)?_D[0-9]+\.[a-zA-Z0-9]+$')"/>-->
      <let name="fileNamePart" value="replace($localFile,'^([^_]+)_.+','$1')"/>
      <let name="componentName" value="*[@name]/@name"/>
      <let name="fileNameVersion"
           value="fnx:xsdVersionFromFileName($localFile)"
           />
      <let name="attVersion"
           value="@version"
           />
      <let name="nameVersionIsConsistentWithAttributeVersion"
           value="not($fileNameVersion) or $fileNameVersion = $attVersion"
           />

      <assert test="fnx:is-exception('GD-32',$componentName) or
                    (not(matches($localFile, '(_[D][0-9]+|_draft)', 'i')))
                    or
                    (matches($localFile,concat('^',$componentName,'(_V[0-9]+_[0-9]+)?_D[0-9]+\.[a-zA-Z0-9]+$')))" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#GD-32">
        The file name <value-of select="$localFile"/>  does not follow the required format for drafts: &#x003C;<value-of select="$componentName"/>&#x003E;{_V&#x003C;MajorVersionNumber&#x003E;_&#x003C;MinorVersionNumber&#x003E;_D&#x003C;RevisionNumber&#x003E;}.&#x003C;FileExtension&#x003E;
      </assert>

      <assert test="fnx:is-exception('GD-32','') or
                    (not(matches($localFile, '(_[D][0-9]+|_draft)', 'i'))
                    or
                    matches($localFile,concat('^','(_V[0-9]+_[0-9]+)?_D[0-9]+\.[a-zA-Z0-9]+$'))) or $nameVersionIsConsistentWithAttributeVersion" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#GD-32">
        The version in XSD name <value-of select="$localFile"/> (<value-of select="$fileNameVersion"/>) is inconsistent with the version given by schema/@version (<value-of select="$attVersion"/>).
      </assert>

    </rule>
  </pattern>
  <pattern>
    <title>GD-33</title>
    <rule context="/xsd:schema[(count(*[@name]) lt 2) or ($inSubdirName = 'Document')]">
      <let name="fileNamePart" value="replace($localFile,'^([^_]+)_.+','$1')"/>
      <let name="componentName" value="*[@name]/@name"/>
      <let name="fileNameVersion"
           value="fnx:xsdVersionFromFileName($localFile)"
           />
      <!-- A test document level Schema filename MUST consist of twofour compulsory parts with onetwo delimiterscomponent name, optional  and optional version information, and file extension with two additional delimiters, i.e., <component name>{ {“_”“V”<major version number>“_”<minor version number>“_”“T”<revision number>} }“.”<file extension>; , and the version information applies only to document level schemas, for example, TrademarkApplication_V4_0_T1.xsdST96XMLSchema_V4_1_T1.zip -->
      <assert test="fnx:is-exception('GD-33',$componentName) or
                    (not(matches($localFile, '(_T[0-9]+|_test)', 'i')))
                    or
                    (matches($localFile,concat('^',$componentName,'(_V[0-9]+_[0-9]+)_T[0-9]+\.[a-zA-Z0-9]+$')))" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#GD-33">
        The file name <value-of select="$localFile"/> does not follow the required format for test schemas: &#x003C;<value-of select="$componentName"/>&#x003E;{_V&#x003C;MajorVersionNumber&#x003E;_&#x003C;MinorVersionNumber&#x003E;_T&#x003C;RevisionNumber&#x003E;}.&#x003C;FileExtension&#x003E;
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>SD-01</title>
    <!-- SD-01: "Patent Component schema modules, Trademark Component
         schema modules, and Design Component schema modules MUST use
         the xsd:import construct to reference Common Component schema
         modules."

         That xsd:import is required to use components from another
         namespace is already implied by XML Schema itself.  Repeating
         this as a guideline adds nothing on its own and should
         probably be removed as a ST.96 rule.  Worse, it appears to
         require that Common be imported even when not used.  It's
         confusing.  Per meeting with Narith and Sunil, implement this
         check as follows: If a Patent, Trademark, or Design component
         module indicates an intention to use Common by declaring its
         namespace prefix on xsd:schema, then make sure that there is
         actually an xsd:import of Common.  Warning when a Common
         namespace prefix is present without an associated xsd:import
         of Common will at least catch dangling namespace prefixes
         declarations.
    -->
    <!-- should only check if attempt to include or import a common component... 
    Note an XSD can still be valid if import is empty
    -->
    <rule context="/xsd:schema[(@targetNamespace = $kPatentNamespace) and (fnx:getNSPrefix(., $kCommonNamespace) = 'com') and *[local-name() eq 'import']]">
      <let name="namespaces-used" value="$definitions/d:namespace/@ns"/>
      <assert test="not(($namespaces-used) = $kCommonNamespace) or
                    (xsd:import[@namespace = $kCommonNamespace] and (($namespaces-used) = $kCommonNamespace))" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-01">
        XSDs in the patent namespace that have declared a common namespace prefix must use xsd:import to reference common component schema modules. 
      </assert>
      <assert test="xsd:import[matches(@schemaLocation,'.xsd$','i')] or not(xsd:import)" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-01">
        The xsd:import construct must reference a schema module using the attribute @schemaLocation
      </assert>
    </rule>
    <rule context="/xsd:schema[(@targetNamespace = $kTrademarkNamespace) and (fnx:getNSPrefix(., $kCommonNamespace) = 'com') and *[local-name() eq 'import']]">
      <let name="namespaces-used" value="$definitions/d:namespace/@ns"/>
      <assert test="not(($namespaces-used) = $kCommonNamespace) or
                    (xsd:import[@namespace = $kCommonNamespace] and (($namespaces-used) = $kCommonNamespace))" role="WARNING" flag="AUTO" diagnostics="componentName namespaceName uri" see="#SD-01">
        XSDs in the trademark namespace that have declared a common namespace prefix must use xsd:import to reference common component schema modules. 
      </assert>
       <assert test="xsd:import[matches(@schemaLocation,'.xsd$','i')] or not(xsd:import)" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-01">
        The xsd:import construct must reference a schema module using the attribute @schemaLocation
      </assert>
    </rule>
    <rule context="/xsd:schema[(@targetNamespace = $kDesignNamespace) and (fnx:getNSPrefix(., $kCommonNamespace) = 'com') and *[local-name() eq 'import']]">
      <let name="namespaces-used" value="$definitions/d:namespace/@ns"/>
      <assert test="not(($namespaces-used) = $kCommonNamespace) or 
                    (xsd:import[@namespace = $kCommonNamespace] and (($namespaces-used) = $kCommonNamespace))" role="WARNING" flag="AUTO" diagnostics="componentName namespaceName uri" see="#SD-01">
        XSDs in the design namespace that have declared a common namespace prefix must use xsd:import to reference common component schema modules. 
      </assert>
       <assert test="xsd:import[matches(@schemaLocation,'.xsd$','i')] or not(xsd:import)" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-01">
        The xsd:import construct must reference a schema module using the attribute @schemaLocation
      </assert>
    </rule>
    <rule context="/xsd:schema[(@targetNamespace = $kGeographicalIndicationNamespace) and (fnx:getNSPrefix(., $kCommonNamespace) = 'com') and *[local-name() eq 'import']]">
      <let name="namespaces-used" value="$definitions/d:namespace/@ns"/>
      <assert test="not(($namespaces-used) = $kCommonNamespace) or 
                    (xsd:import[@namespace = $kCommonNamespace] and (($namespaces-used) = $kCommonNamespace))" role="WARNING" flag="AUTO" diagnostics="componentName namespaceName uri" see="#SD-01">
        XSDs in the geographical indication namespace that have declared a common namespace prefix must use xsd:import to reference common component schema modules. 
      </assert>
       <assert test="xsd:import[matches(@schemaLocation,'.xsd$','i')] or not(xsd:import)" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-01">
        The xsd:import construct must reference a schema module using the attribute @schemaLocation
      </assert>
    </rule>
    <rule context="/xsd:schema[(@targetNamespace = $kCopyrightNamespace) and (fnx:getNSPrefix(., $kCommonNamespace) = 'com') and *[local-name() eq 'import']]">
      <let name="namespaces-used" value="$definitions/d:namespace/@ns"/>
      <assert test="not(($namespaces-used) = $kCommonNamespace) or
                    (xsd:import[@namespace = $kCommonNamespace] and (($namespaces-used) = $kCommonNamespace))" role="WARNING" flag="AUTO" diagnostics="componentName namespaceName uri" see="#SD-01">
        XSDs in the copyright namespace that have declared a common namespace prefix must use xsd:import to reference common component schema modules. 
      </assert>
       <assert test="xsd:import[matches(@schemaLocation,'.xsd$','i')] or not(xsd:import)" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-01">
        The xsd:import construct must reference a schema module using the attribute @schemaLocation
      </assert>
    </rule>
	<rule context="/xsd:schema[(@targetNamespace = $kIPONonCommonNamespaces) and (fnx:getNSPrefix(., $kIPOCommonNamespace) = $kIPOCommonNamespacePrefix) and *[local-name() eq 'import']]">
         <let name="namespaces-used" value="$definitions/d:namespace/@ns"/>
	  <assert test="not(($namespaces-used) = $kIPOCommonNamespace) or 
                    (xsd:import[@namespace = $kIPOCommonNamespace] and (($namespaces-used) = $kIPOCommonNamespace))" role="WARNING" flag="AUTO" diagnostics="componentName namespaceName uri" see="#SD-01">
        XSDs in an IPO namespace that have declared a common namespace prefix must use xsd:import to reference IPO common component schema modules.
      </assert>
	   <assert test="xsd:import[matches(@schemaLocation,'.xsd$','i')] or not(xsd:import)" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-01">
        The xsd:import construct must reference a schema module using the attribute @schemaLocation
      </assert>
      </rule>
    
    </pattern>
   <pattern>
    <title>SD-02</title>
     <!-- Common Component schema modules MUST NOT refer to Patent Component schema modules, Trademark Component schema modules, Design Component schema modules, Geographical Indication Component schema modules or Copyright Component schema modules. -->
    <rule context="/xsd:schema[@targetNamespace = $kCommonNamespace or @targetNamespace = $kIPOCommonNamespace]">
         <let name="illegalImport" value="xsd:import
                  [  not(@namespace = ($kMathMLNamespace,$namespaces[@ns-prefix='mathml']/@ns, $kOASISTableNamespace, $kCommonNamespace)) ]"/>
        <let name="bad-namespaces" value="$namespaces[@component!='common' and not(@std='external')]/@ns"/>
      <let name="illegalReference" value="namespace::node()[exists(index-of($bad-namespaces,.))]"/><!-- namespace::node()[.='http://www.w3.org/2001/XMLSchema'] -->
        
         <assert test="not($illegalImport or $illegalReference)" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-02">
        XSDs in the <value-of select="@targetNamespace"/> namespace
        may not refer to XSDs in the following namespace(s):
        <value-of select="string-join(distinct-values(($illegalImport/@namespace,$illegalReference)),', ')"/>.
      </assert>
      </rule>
   </pattern>
   <pattern>
    <title>SD-03</title>
     <!-- non-common can only import:
          > common
          > external standards
          > trademark (if geographicalindication)
          > geographicalindication (if trademark)
          > patent (if design)
          > design (if patent)
     -->
    <rule context="/xsd:schema[@targetNamespace != ($kCommonNamespace, $kIPOCommonNamespace)]">
      <!-- there is no need to check if it is the same as the target namespace because
              this is disallowed by XSD -->
      <let name="tns" value="@targetNamespace"/>
      <let name="tns-component" value="$namespaces[@ns = $tns]/@component"/>
      <let name="bad-namespaces" value="$namespaces[@component != 'common' and @component != $tns-component and not(($tns-component = 'geographicalindication' or $tns-component = 'trademark') and (@component = 'geographicalindication' or @component = 'trademark')) and not(($tns-component = 'design' or $tns-component = 'patent') and (@component = 'design' or @component = 'patent'))]/@ns"/>
      <let name="illegalImport" value="xsd:import[@namespace = $bad-namespaces]"/>
      <let name="illegalReference" value="namespace::node()[exists(index-of($bad-namespaces, .))]"/><!-- allow GeographicalIndication to cross reference Trademark, and vice versa; 2020-12-23: check for references, even if not imported -->
      <assert test="not($illegalImport or $illegalReference)" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-03"> XSDs in the <value-of select="@targetNamespace"/> namespace may not refer to XSDs in the following namespace(s): <value-of select="string-join(distinct-values(($illegalImport/@namespace,$illegalReference)), ', ')"/>. </assert>
    </rule>
    <!--<rule context="/xsd:schema[@targetNamespace]">
      <report test="true()">
        <value-of select="@targetNamespace"/> is not one of <value-of select="string-join($kNonCommonNamespaces,', ')"/> or <value-of select="string-join($kIPONonCommonNamespaces,', ')"/>
      </report>
    </rule>-->
   </pattern>
   <pattern>
    <title>SD-04</title>
    <rule context="xsd:complexType[@name]|xsd:simpleType[@name]">
      <report test="false()" flag="MANUAL"/>
      <let name="thisType" value="."/>
      <let name="duplicate-model" value="if (doc-available($sd04OutputFile)) then (doc($sd04OutputFile)/duplicate-models/duplicates[@ns eq $targetNamespaceName][component[@ns = $definitions/d:namespace/@ns and (@name = $thisType/@name)]]/component[not((@ns = $definitions/d:namespace/@ns) and (@name = $thisType/@name))]/concat(@prefix,':',@name)) else ( fnx:duplicate-type-model(.)/concat(namespace::node()[. = $definitions/d:namespace/@ns]/name(),':',@name,'*'))"/>
      <assert test="fnx:is-exception('SD-04', @name) or empty($duplicate-model)" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-04"> The <value-of select="concat(local-name(.),' ',@name)"/> has an identical model with <value-of select="string-join($duplicate-model, ', ')"/>. Consider reusing existing complexTypes based on business needs. 
      </assert>
    </rule>
     <rule context="xsd:element[@name]|xsd:attribute[@name]">
       <report test="false()" flag="MANUAL"/>
     </rule>
  </pattern>
  <pattern>
    <title>SD-05</title>
    <!-- Schemas SHOULD use elements and types defined in existing schemas to the maximum
extent possible. -->
    <!-- 2025-03-11: moved from integrity check -->
    <rule context="xsd:element[@name] | xsd:complexType[@name] | xsd:simpleType[@name]">
      <report test="false()" flag="MANUAL"/>
      <let name="component-name" value="@name"/>
      <let name="duplicate-in-common" value="if (doc-available($sd05OutputFile)) then (doc($sd05OutputFile)/duplicate-of-common/component[@ns eq $targetNamespaceName][@name eq $component-name]/@name) else  (for $x in fnx:duplicate-of-common(.,$definitions/d:namespace/@ns) return concat($x,'*'))"/>
      <assert test="fnx:is-exception('SD-05',@name) or empty($duplicate-in-common)" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-05">
        The <value-of select="concat(name(),' ',fnx:getNSPrefix(.,/xsd:schema/@targetNamespace),':',$component-name)"/> has a duplicate name with <value-of select="string-join(for $x in $duplicate-in-common return concat('com:',$x),', ')"/>. Consider whether the Common component should be used instead.
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>SD-06</title>
    <rule context="xsd:element | xsd:attribute | xsd:simpleType | xsd:complexType">
      <assert test="@ref or parent::xsd:schema" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-06"><!-- there should be no exceptions --> <value-of select="@name"/> (<value-of select="name()"/>) is declared locally.</assert>
      <assert test="not(@ref) or (some $x in @ref, $ns in namespace-uri-from-QName(resolve-QName($x,.)) satisfies exists($definitions//d:namespace[@ns eq $ns]/*[@name eq local-name-from-QName(resolve-QName($x,.))]))" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-06"> <value-of select="@ref"/> (<value-of select="name()"/>) is referenced but not declared. Check imports/includes. <value-of select="ancestor::xsd:schema/*/@schemaLocation[ doc-available(resolve-uri(.,base-uri())) = false()]/concat(.,' is referenced but cannot be found.')"/> 
        </assert>
    </rule>
   </pattern>
   <pattern>
    <title>SD-07</title>
    <!--<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns="http://datypic.com/prod" targetNamespace="http://datypic.com/prod">
      <xs:redefine schemaLocation="prod1.xsd">
        <xs:simpleType name="DressSizeType">
          <xs:restriction base="DressSizeType">
            <xs:minInclusive value="2"/>
            <xs:maxInclusive value="16"/>
          </xs:restriction>
        </xs:simpleType>
      </xs:redefine>
      <xs:element name="newSize" type="DressSizeType"/>
    </xs:schema>-->
    <rule context="xsd:redefine">
         <assert test="false()" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-07">
        xsd:redefine must not be used.
      </assert>
      </rule>
  </pattern>
  <pattern>
    <title>SD-08</title>
    <rule context="/xsd:schema">
      <assert test="@targetNamespace" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-08">
        xsd:schema has no targetNamespace attribute.
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>SD-09</title>
    <rule context="/xsd:schema">
         <assert test="fnx:is-exception('SD-09','') or
                    @targetNamespace = $namespaces/@ns" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-09">
        Target namespace <value-of select="@targetNamespace"/> is not one of the baseline namespaces.
      </assert>
         <report test="false()" flag="MANUAL"/>
      </rule>
      <rule context="xsd:import">
         <assert test="fnx:is-exception('SD-09','') or
                    @namespace = $namespaces/@ns" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-09">
        Imported namespace <value-of select="@namespace"/> is not one of the baseline namespaces.
      </assert>
      </rule>
   </pattern>
  <pattern>
    <title>SD-10</title>
    <rule context="/*">
      <assert test="namespace::node()[.='http://www.w3.org/2001/XMLSchema']" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-10">
        Schema does not declare the XML Schema namespace
        (http://www.w3.org/2001/XMLSchema).
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>SD-11</title>
    <!-- SD-11 ("Schemas MUST use namespace qualifications for all W3C
         Schema constructs.") is already implied by XML Schema
         constraints in general.  It adds nothing on its own and
         should probably be removed as a ST.96 rule.  Perhaps it is
         trying to say that Schemas must use namespace prefixes for
         all W3C Schema constructs?  Yet per
         http://www.w3.org/TR/REC-xml-names/#dt-qualname [Definition:
         A qualified name is a name subject to namespace
         interpretation [...] Syntactically, they are either prefixed
         names or unprefixed names.  Will assume intent of SD-11 is to
         insist that *some* namespace prefix MUST be used to reference
         XSD constructs, whereas SD-15 says that specifically "xsd"
         SHOULD be used. ]
    -->
    <rule context="/xsd:schema">
      <let name="xsdAssertionError"
           value="fnx:assertAnyNSPrefix(., $kXMLSchemaNamespace)"/>

      <assert test="$xsdAssertionError = ''" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-11">
        <value-of select="$xsdAssertionError"/>
      </assert>

    </rule>
  </pattern>
  <xsl:function name="fnx:isURI" as="xs:boolean">
    <!-- a function that computes atomic values should use xsl:sequence rather than xsl:value-of -->
    <xsl:param name="targetNamespace" as="xs:string?"/>
    <!-- Could be more thorough here, but this should adequately cover
         common cases. -->
    <xsl:sequence select="$targetNamespace and
                          (starts-with($targetNamespace, 'http:')
                          or starts-with($targetNamespace, 'https:')
                          or starts-with($targetNamespace, 'urn:'))
                          "/>
  </xsl:function>
  <pattern>
    <title>SD-12</title>
    <rule context="/xsd:schema">
      <assert test="(fnx:isURI(@targetNamespace) and (iri-to-uri(@targetNamespace) = @targetNamespace))" role="ERROR"  flag="AUTO" diagnostics="componentName namespaceName uri" see="#SD-12">
        @targetNamespace=<value-of select="@targetNamespace"/> is not a valid URI.
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>SD-13</title>
    <rule context="/xsd:schema">
      <assert test="@elementFormDefault = 'qualified'" role="ERROR" flag="AUTO" diagnostics="componentName namespaceName uri" see="#SD-13">
        @elementFormDefault must be qualified.
      </assert>
      <assert test="@attributeFormDefault = 'qualified'" role="ERROR" flag="AUTO" diagnostics="componentName namespaceName uri" see="#SD-13">
        @attributeFormDefault must be qualified.
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>SD-14</title>
    <rule context="/xsd:schema">
         <assert test="not($inComponentSubdirName = ('Common', 'Patent', 'Trademark', 'Design'))
                     or ($inComponentSubdirName = 'Common' and @targetNamespace = $kCommonNamespace)
                     or ($inComponentSubdirName = 'Patent' and @targetNamespace = $kPatentNamespace)
                     or ($inComponentSubdirName = 'Trademark' and @targetNamespace = $kTrademarkNamespace)
                     or ($inComponentSubdirName = 'Design' and @targetNamespace = $kDesignNamespace)
                     or ($inComponentSubdirName = 'GeographicalIndication' and @targetNamespace = $kGeographicalIndicationNamespace)
                     or ($inComponentSubdirName = 'Copyright' and @targetNamespace = $kCopyrightNamespace)
                    " flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-14">
        Namespace <value-of select="@targetNamespace"/> does not follow the proper form.
      </assert>
      
      <let name="tns" value="@targetNamespace"/>
      <assert test="not($inComponentSubdirName = ($namespaces[not(@std ='external' or @std = 'ST96')]/@subdir))
                  or ($namespaces[@subdir = $inComponentSubdirName and @ns=$tns])" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-14">
        Namespace <value-of select="@targetNamespace"/> does not follow the proper form. Expected namespace <value-of select="$namespaces[@subdir=$inComponentSubdirName]/@ns"/> based on subdirectory name <value-of select="$inComponentSubdirName"/>.
      </assert>
      </rule>
  </pattern>

 
  <pattern>
      <title>SD-15</title>
      <rule context="/xsd:schema">
        <let name="schema" value="."/>
         <let name="errors" value="$namespaces/fnx:assertSpecificNSPrefix($schema, @ns, @ns-prefix)"/>
         <assert test="fnx:is-exception('SD-15','') or empty($errors)" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-15">
            <value-of select="string-join($errors,', ')"/>
         </assert>
      </rule>
   </pattern>
  <pattern>
    <title>SD-16</title>
    <rule context="/xsd:schema">
      <assert test="@targetNamespace" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-16">
        xsd:schema has no targetNamespace attribute.
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>SD-17</title>
    <rule context="/xsd:schema">
         <assert test="@targetNamespace != $kXMLSchemaNamespace" role="ERROR" flag="AUTO" diagnostics="componentName namespaceName uri" see="#SD-17">
        @targetNamespace must not equal <value-of select="$kXMLSchemaNamespace"/>.
         </assert>
         <let name="tns" value="@targetNamespace"/>
         <assert test="namespace::node()[.=$tns]" role="ERROR" flag="AUTO" diagnostics="componentName namespaceName uri" see="#SD-17">
           @targetNamespace must be one of the declared namespaces. 
         </assert>
      </rule>
  </pattern>
  <pattern>
    <title>SD-18</title>
     <!-- Ascertain Common vs Patent vs Trademark vs Design based upon
         name of containing subdirectory -->
      <rule context="/xsd:schema">
         <assert test="$inComponentSubdirName != 'Common' or @targetNamespace = $kCommonNamespace" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-18">
        For XSD found in the Common subdirectory, @targetNamespace
        (<value-of select="@targetNamespace"/>) must equal <value-of select="$kCommonNamespace"/>
         </assert>
            <assert test="not($inComponentSubdirName = ($namespaces[not(@std ='external' or @std = 'ST96')][@component='common']/@subdir)) or @targetNamespace = $kIPOCommonNamespace" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-18">
           For XSD found in the <value-of select="$inComponentSubdirName"/> subdirectory, @targetNamespace
           (<value-of select="@targetNamespace"/>) must equal <value-of select="$kIPOCommonNamespace"/>
            </assert>
      </rule>
   </pattern>
  <pattern>
    <title>SD-19</title>
    <!-- Ascertain Common vs Patent vs Trademark vs Design based upon
         name of containing subdirectory -->
      <rule context="/xsd:schema">
         <assert test="$inComponentSubdirName != 'Patent' or @targetNamespace = $kPatentNamespace" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-19">
        For XSD found in the Patent subdirectory, @targetNamespace
        (<value-of select="@targetNamespace"/>) must equal <value-of select="$kPatentNamespace"/>
         </assert>
         <assert test="not($inComponentSubdirName = ($namespaces[not(@std ='external' or @std = 'ST96')][@component='patent']/@subdir)) or @targetNamespace = $kIPOPatentNamespace" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-19">
        For XSD found in the <value-of select="$inComponentSubdirName"/> subdirectory, @targetNamespace
        (<value-of select="@targetNamespace"/>) must equal <value-of select="$kIPOPatentNamespace"/>
         </assert>
      </rule>
   </pattern>
  <pattern>
    <title>SD-20</title>
    <!-- Ascertain Common vs Patent vs Trademark vs Design based upon
         name of containing subdirectory -->
      <rule context="/xsd:schema">
         <assert test="$inComponentSubdirName != 'Trademark' or @targetNamespace = $kTrademarkNamespace" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-20">
        For XSD found in the Trademark subdirectory, @targetNamespace
        (<value-of select="@targetNamespace"/>) must equal <value-of select="$kTrademarkNamespace"/>
         </assert>
         <assert test="not($inComponentSubdirName = ($namespaces[not(@std ='external' or @std = 'ST96')][@component='trademark']/@subdir)) or @targetNamespace = $kIPOTrademarkNamespace" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-20">
        For XSD found in the <value-of select="$inComponentSubdirName"/> subdirectory, @targetNamespace
        (<value-of select="@targetNamespace"/>) must equal <value-of select="$kIPOTrademarkNamespace"/>
         </assert>
      </rule>
  </pattern>
  <pattern>
    <title>SD-21</title>
    <!-- Ascertain Common vs Patent vs Trademark vs Design based upon
         name of containing subdirectory -->
      <rule context="/xsd:schema">
         <assert test="$inComponentSubdirName != 'Design' or @targetNamespace = $kDesignNamespace" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-21">
        For XSD found in the Design subdirectory, @targetNamespace
        (<value-of select="@targetNamespace"/>) must equal <value-of select="$kDesignNamespace"/>
         </assert>
         <assert test="not($inComponentSubdirName = ($namespaces[not(@std ='external' or @std = 'ST96')][@component='design']/@subdir)) or @targetNamespace = $kIPODesignNamespace" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-21">
        For XSD found in the <value-of select="$inComponentSubdirName"/> subdirectory, @targetNamespace
        (<value-of select="@targetNamespace"/>) must equal <value-of select="$kIPODesignNamespace"/>
         </assert>
      </rule>
  </pattern>
  <pattern>
    <title>SD-22</title>
    <rule context="/xsd:schema">
      <assert test="fnx:is-exception('SD-22','') or
                    not(in-scope-prefixes(.) = '')" role="WARNING" flag="AUTO" diagnostics="componentName namespaceName uri" see="#SD-22">
        xsd:schema uses default namespace <value-of select="namespace-uri-for-prefix('',.)"/>.
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>SD-23</title>
    <rule context="/">
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  <pattern>
    <title>SD-24</title>
    <rule context="/">
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  <pattern>
    <title>SD-25</title>
    <rule context="/">
      <report test="false()" flag="DELETED"/>
    </rule>
  </pattern>
  <pattern>
    <title>SD-26</title>
    <rule context="/">
      <report test="false()" flag="DELETED"/>
    </rule>
  </pattern>
  <pattern>
    <title>SD-27</title>
    <rule context="/">
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  <pattern>
    <title>SD-28</title>
    <!-- When any schema construct is altered, all schemas in the release MUST undergo the same version number increment.
        implicit if check against st96Version of ipoVersion?
    -->
    <!-- check that ALL schemas have the same version number (authoritative version is st96Version) -->
    <!-- this should be ipoVersion for ipo implementations, otherwise st96Version -->
    <rule context="/xsd:schema">
      <let name="ipoImplementation" value="@targetNamespace = ($kIPOCommonNamespace,$kIPONonCommonNamespaces)"/>
      <assert test="($ipoImplementation = false() and @version eq $st96Version) or ($ipoImplementation and @version eq replace($ipoVersion,'^[A-Z][A-Z]_',''))" flag="AUTO" diagnostics="componentName namespaceName uri" see="#SD-28" role="ERROR">
        &quot;<value-of select="@version"/>&quot; does not match <value-of select="if ($ipoImplementation) then (concat('ipoVersion &quot;',$ipoVersion,'&quot;')) else (concat('st96Version &quot;',$st96Version,'&quot;'))"/>
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>SD-29</title>
    <rule context="/">
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  <pattern>
    <title>SD-30</title>
    <!-- The W3C Schema version attribute MUST consist of both major version number and a minor version number for each schema file in the following format: “V”<major version number>”_”<minor version number>. -->
    
    <let name="fileNameVersion"
           value="fnx:xsdVersionFromFileName($localFile)"
           />
    <rule context="/xsd:schema">
      <assert test="@version" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-30">
        The version attribute is not specified.
      </assert>
      <assert test="not(@version) or matches(@version,concat('^',$kRegexReleaseVersion,'$'))" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-30">
        &quot;<value-of select="@version"/>&quot; does not follow the
        form "V&lt;MajorNumber&gt;_&lt;MinorNumber&gt;_&lt;OptionalPatchNumber&gt;"
      </assert>
      <assert test="(@version = $fileNameVersion) or not($fileNameVersion)" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-30">
        The version in XSD name <value-of select="$localFile"/> (<value-of select="$fileNameVersion"/>) is inconsistent with the version given by schema/@version (<value-of select="@version"/>).
      </assert><!-- How to check that EVERY FILE matches the same version?? use integrity check?? -->
    </rule>
  </pattern>
  <pattern>
    <title>SD-31</title>
    <rule context="/xsd:schema[not(xsd:element[2])]/xsd:element">
      <assert test="$inSubdirName != 'Document'
                    or fnx:has-fixed-attribute(., 'st96Version', 'required', concat('^',$kRegexReleaseVersion,'$'))"
              flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-31"><!-- assume document level if it has 1 complexType component... -->
        Document components must require root elements to have a st96Version attribute value of the form V&lt;major version number&gt;_&lt;minor version number&gt;{_&lt;patch version number&gt;}.
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>SD-32</title>
    <rule context="/">
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  <pattern>
    <title>SD-33</title>
    <!-- Enumerations contained in Schemas SHOULD NOT include the values “Other” or “Unknown” unless they are needed. -->
    <!-- 2021-02-10: changed from ../../@name b/c of nested simpleTypes due to union...
      
       <xsd:simpleType>
       <xsd:union>
         <xsd:simpleType>
           <xsd:restriction base="xsd:positiveInteger">
             <xsd:minInclusive value="8"/>
             <xsd:maxInclusive value="72"/>
           </xsd:restriction>
         </xsd:simpleType>
         <xsd:simpleType>
           <xsd:restriction base="xsd:NMTOKEN">
             <xsd:enumeration value="small"/>
             <xsd:enumeration value="medium"/>
             <xsd:enumeration value="large"/>
           </xsd:restriction>
         </xsd:simpleType>
       </xsd:union>
     </xsd:simpleType>
    -->
    <rule context="xsd:enumeration"><!-- [not(ancestor::xsd:schema/@targetNamespace = ($kMathMLNamespace,$kOASISTableNamespace))] -->
      <let name="componentName" value="ancestor::*[@name][1]/@name"/>
      <assert test="fnx:is-exception('SD-33',$componentName) or
                    not(matches(@value,'^other$', 'i'))" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-33">The <value-of select="$componentName"/> enumeration should not include &quot;<value-of select="@value"/>&quot; value unless needed.</assert><!-- changed message -->
      <assert test="fnx:is-exception('SD-33',$componentName) or
                    not(matches(@value,'^unknown$', 'i'))" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-33">The <value-of select="$componentName"/> enumeration should not include &quot;<value-of select="@value"/>&quot; value unless needed.</assert><!-- changed message -->
    </rule>
  </pattern>
  <pattern>
    <title>SD-34</title>
    <!-- MathML, version 3, SHOULD be used for mathematical formulas.
 -->
    <!-- add rules for old versions of mathml -->
    <!-- check that http:​/​/www.w3.org​/1998​/Math​/MathML is used -->
    <rule context="xsd:element[(@name and fnx:contains-i(@name, 'math')) or (@type and fnx:contains-i(@type, 'math'))]">
      <let name="math-namespace-used" value="if (@type) then namespace-uri-for-prefix(
         'mathml',fnx:get-xsd-definition(root(.), @type)) else namespace-uri-for-prefix('mathml',.)"/>
         <assert test="fnx:is-exception('SD-34',@name) or
                    (fnx:uses-type(., 'mathml:math', 0) and $math-namespace-used = ($kMathMLNamespace)) or fnx:uses-type(., 'InlineFormula', 0)" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-34">
        Element <value-of select="@name"/>: mathml:math should be used for math data. Uses namespace <value-of select="$math-namespace-used"/> and not <value-of select="$kMathMLNamespace"/>.
         </assert>
      </rule>
    <rule context="xsd:complexType[(@name and fnx:contains-i(@name, 'math')) ]">
      <let name="math-namespace-used" value="namespace-uri-for-prefix('mathml',.)"/>
      <assert test="fnx:is-exception('SD-34', @name) or (fnx:uses-type(., 'mathml:math', 0) and $math-namespace-used = ($kMathMLNamespace)) or fnx:uses-type(., 'InlineFormula', 0)" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-34"> ComplexType <value-of select="@name"/>: mathml:math should be used for math data. Uses namespace <value-of select="$math-namespace-used"/> and not <value-of select="$kMathMLNamespace"/>.  </assert>
    </rule>
  </pattern>
  <pattern>
    <title>SD-35</title>
    <!-- OASISTable.xsd, based on the OASIS Exchange Table schema, SHOULD be used for tables.
 -->
    <!-- check elements that are table-related but not table parts -->
    
    <rule context="xsd:element[fnx:isTableRelated(@name) or fnx:isTableRelated(@type)]">
      <assert test="fnx:is-exception('SD-35',@name) or
                    fnx:uses-type(., 'tbl:OASISTableType', 0)" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-35">
        Element <value-of select="@name"/> must use tbl:OASISTableType for table data.
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>SD-36</title>
    <!-- allow both versions of mathml -->
    <rule context="xsd:import">
         <assert test="fnx:is-exception('SD-36','') or starts-with(@namespace,$kNamespaceWIPObase) or 
                   @namespace = ($kMathMLNamespace,$namespaces[@ns-prefix='mathml']/@ns,$kOASISTableNamespace,$kIPOCommonNamespace,$kIPONonCommonNamespaces)" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-36">
        Import of namespace <value-of select="@namespace"/> does not appear to designate MathML, OASIS Table, or a WIPO or IPO namespace.
      </assert>
      </rule>
  </pattern>
  <pattern>
    <title>SD-37</title>
    <!-- Schemas SHOULD use simple types to the maximum extent possible.
 -->
    <rule context="/">
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  <pattern>
    <title>SD-38</title>
    <!-- Code lists SHOULD be declared as an enumeration list in a simple type.
      
      e.g. 
      <xsd:simpleType name="AuthorizedUserCategoryType">
      <xsd:restriction base="xsd:token">
        <xsd:enumeration value="Producer">
          <xsd:annotation>
            <xsd:documentation>Producer</xsd:documentation>
          </xsd:annotation>
        </xsd:enumeration>
        <xsd:enumeration value="Dealer">
          <xsd:annotation>
            <xsd:documentation>Dealer</xsd:documentation>
          </xsd:annotation>
        </xsd:enumeration>
      </xsd:restriction>
      ...
    </xsd:simpleType>
 -->
    <rule context="/xsd:schema/*[matches(@name,'CodeType$')]">
      <assert test="fnx:is-exception('SD-38',@name) or fnx:hasAnEnumerationList(.)" role="WARNING" flag="AUTO" diagnostics="componentName namespaceName uri" see="#SD-38">
        Code list <value-of select="@name"/> is not declared as an enumeration list in a simpleType. It is declared as <value-of select="if (self::xsd:simpleType) then (concat(' ',string-join(descendant-or-self::*/name(),' '))) else (name())"/>.
      </assert>
      <report test="false()" flag="MANUAL"/>
    </rule>
    
    <rule context="xsd:element[ends-with(@name,'Code')]|xsd:attribute[ends-with(@name,'Code')]">
      <!-- need to recurse, in case element is Code, and type is a union of simpleTypes...as above -->
      <let name="definitionType" value="for $x in @type, $ns in namespace-uri-from-QName(resolve-QName($x, .)) return ($definitions//d:namespace[@ns eq $ns]/*[@name eq local-name-from-QName(resolve-QName($x,.))])"/>
      <assert test="fnx:is-exception('SD-38',@name) or fnx:hasAnEnumerationList(.)" role="WARNING" flag="AUTO" diagnostics="componentName namespaceName uri" see="#SD-38">
        Code list <value-of select="@name"/> is not declared as an enumeration list in a simpleType. It is declared as <value-of select="if (namespace-uri-from-QName(resolve-QName(@type,.)) eq $kXMLSchemaNamespace) then (@type) else (if ($definitionType/self::xsd:simpleType) then (concat(' ',string-join($definitionType/descendant-or-self::*/name(),' '))) else ($definitionType/name()))"/>.
      </assert>
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  
  <pattern>
    <title>SD-39</title>
    <!-- A code list MAY be declared as a union of simple types. -->
    <rule context="/xsd:schema/xsd:simpleType[ends-with(@name,'CodeType')][xsd:union]">
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>

  <pattern>
    <title>SD-40</title>
    <rule context="(xsd:element|xsd:attribute)[(@name and matches(@name, 'office$|officecode|contractingparty|authoritycode','i')) or (@type and matches(@type, 'office$|officecode|contractingparty|authoritycode','i'))]">
      <assert test="fnx:is-exception('SD-40',@name) or 
        fnx:uses-type(., 'com:WIPOST3CodeType', 0) or fnx:uses-type(.,'com:ExtendedWIPOST3CodeType',0) or (@type and (every $x in (fnx:get-xsd-definition(root(.), @type)/xsd:restriction/xsd:enumeration/@value) satisfies exists(index-of($st3Codes,$x))))" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-40">
        <value-of select="concat(if (self::xsd:element) then 'Element ' else 'Attribute ',@name)"/> must use com:WIPOST3CodeType or WIPO Standard ST.3 two-letter codes for IP office codes.
      </assert>
    </rule>
    <!--<rule context="(xsd:element|xsd:attribute)[(@name and fnx:contains-i(@name, 'countrycode')) or (@type and fnx:contains-i(@type, 'countrycode'))]">
      <assert test="(fnx:uses-type(., 'com:WIPOST3CodeType', 0) or fnx:uses-type(.,'com:ExtendedWIPOST3CodeType',0)) or (@type and (every $x in (fnx:get-xsd-definition(root(.), @type)/xsd:restriction/xsd:enumeration/@value) satisfies exists(index-of($st3Codes,$x))))" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-40">
        <value-of select="concat(if (self::xsd:element) then 'Element ' else 'Attribute ',@name)"/> must use com:WIPOST3CodeType or WIPO Standard ST.3 two-letter codes for IP office codes.
        TEST uses type ExtendedWIPOST3CodeType <value-of select="fnx:uses-type(., 'com:ExtendedWIPOST3CodeType', 0)"/>
      </assert>
    </rule>-->
    <rule context="(xsd:element|xsd:attribute)[@name or @type][fnx:uses-type(., 'com:WIPOST3CodeType', 0) or fnx:uses-type(.,'com:ExtendedWIPOST3CodeType',0)]"><!-- all other elements/attributes that use ST3 codes -->
      <assert test="fnx:is-exception('SD-40',@name) or not(matches(@name,'residence|domicile','i') or matches(@type,'residence|domicile','i'))" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-40">
        <value-of select="concat(if (self::xsd:element) then 'Element ' else 'Attribute ',@name)"/> uses WIPO Standard ST.3 two-letter codes but has <value-of select="if (matches(@name,'residence|domicile','i') ) then (concat('name ',@name)) else (concat('type ',@type))"/> 
      </assert>
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  <pattern>
    <title>SD-41</title>
    <rule context="(xsd:element|xsd:attribute)[(@name and fnx:contains-i(@name, 'country')) or (@type and fnx:contains-i(@type, 'country'))][not((@name and matches(@name,'designated|priority','i')) or (@type and matches(@type,'designated|priority','i')))]">
      <!-- need to clarify when to use ISO Country code and when to use ST.3 codes -->
      <assert test="fnx:is-exception('SD-41',@name) or
                    fnx:uses-type(., 'com:ISOCountryCodeType', 0)
                    " flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-41">
        <value-of select="if (self::xsd:element) then 'Element ' else 'Attribute '"/> must use com:ISOCountryCodeType for country data and WIPO Standard ST.3 for IPO or designated country/organizations. <value-of select="@name"/> uses <value-of select="if (fnx:uses-type(.,'com:ISOCountryCodeType',0)) then ('ISO Country Codes') else (if (fnx:uses-type(.,'com:ExtendedWIPOST3CodeType',0)) then ('ST.3 Codes') else ())"/>.
      </assert>
      <report test="false()" flag="MANUAL"/>
    </rule>
    <rule context="(xsd:element|xsd:attribute)[@name or @type][fnx:uses-type(., 'com:ExtendedISOCountryCodeType  ', 0) or fnx:uses-type(.,'com:ISOCountryCodeType',0)]"><!-- all other elements/attributes that use ISO Country code -->
      <assert test="fnx:is-exception('SD-41',@name) or not(matches(@name,'priority|designated','i') or matches(@type,'priority|designated','i'))"  flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-41">
        <value-of select="concat(if (self::xsd:element) then 'Element ' else 'Attribute ',@name)"/> uses com:ISOCountryCodeType but  has <value-of select="if (matches(@name,'priority|designated','i') ) then (concat('name ',@name)) else (concat('type ',@type))"/>
      </assert>
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  <pattern>
    <title>SD-42</title>
    <rule context="(xsd:element|xsd:attribute)[(
                   @name
                   and fnx:contains-i(@name, 'language')
                   and not(ends-with(lower-case(@name), 'text'))
                   and not(ends-with(lower-case(@name), 'texttype'))
                   and not(ends-with(lower-case(@name),'indicator'))
                   ) or (
                   @type
                   and fnx:contains-i(@type, 'language')
                   and not(ends-with(lower-case(@type), 'text'))
                   and not(ends-with(lower-case(@type), 'texttype'))
                   and not(ends-with(lower-case(@type),'indicator'))
                   )]">
      <assert test="fnx:is-exception('SD-42',@name) or
                    fnx:uses-type(., 'com:ISOLanguageCodeType', 0) or fnx:uses-type(., 'com:ExtendedISOLanguageCodeType', 0)" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-42">
        <value-of select="concat(if (self::xsd:element) then 'Element ' else 'Attribute ',@name)"/> must use com:ISOLanguageCodeType or com:ExtendedISOLanguageCodeType for language codes.
      </assert>
    </rule>
  </pattern>

  <pattern>
    <title>SD-43</title>
    <!-- Schemas MUST declare elements and attributes for date and time values using W3C schema date and time data types. -->
    
    <rule context="(xsd:element|xsd:attribute)[(@name and fnx:contains-i(@name, 'datetime')) or (@type and fnx:contains-i(@type, 'datetime'))]">
      <let name="words" value="(fnx:splitCamelCase(@name),if (@type) then fnx:splitCamelCase(@type) else ())"/>
      <let name="nameOrType" value="if (@name) then (@name) else (@type)"/>
<!--      <let name="repTerm" value="fnx:getRepTerm($nameOrType)"/> 2024-09-11: don't check against exact rep term, GD-23 will do that -->
      <assert test="fnx:is-exception('SD-43',@name) or fnx:uses-type(., 'xsd:dateTime', 0) or fnx:getRepTerm(@name) = 'Category'" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri datatype" see="#SD-43">
        <value-of select="concat(if (self::xsd:element) then 'Element ' else 'Attribute ',@name)"/> must use xsd:dateTime for date time data.
      </assert>
    </rule>
    <rule context="(xsd:element|xsd:attribute)[(@name and fnx:contains-i(@name, 'date')) or (@type and fnx:contains-i(@type, 'date'))]">
      <let name="words" value="(fnx:splitCamelCase(@name),if (@type) then fnx:splitCamelCase(@type) else ())"/>
      <let name="nameOrType" value="if (@name) then (@name) else (@type)"/>
      <!--      <let name="repTerm" value="fnx:getRepTerm($nameOrType)"/> 2024-09-11: don't check against exact rep term, GD-23 will do that -->
      <assert test="fnx:is-exception('SD-43',@name) or empty(index-of($words,'Date')) or
                    (fnx:uses-type(., 'xsd:date', 1) ) or fnx:getRepTerm(@name) = 'Category'" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri datatype" see="#SD-43"><!-- can go up one depth level, in case use com:DateType -->
        <value-of select="concat(if (self::xsd:element) then 'Element ' else 'Attribute ',@name)"/> must use xsd:date for date data.
      </assert>
    </rule>
    <rule context="(xsd:element|xsd:attribute)[(@name and fnx:contains-i(@name, 'time')) or (@type and fnx:contains-i(@type, 'time'))]">
      <let name="words" value="(fnx:splitCamelCase(@name),if (@type) then fnx:splitCamelCase(@type) else ())"/>
      <let name="nameOrType" value="if (@name) then (@name) else (@type)"/>
      <!--      <let name="repTerm" value="fnx:getRepTerm($nameOrType)"/> 2024-09-11: don't check against exact rep term, GD-23 will do that -->
      <assert test="fnx:is-exception('SD-43',@name) or empty(index-of($words,'Time')) or fnx:uses-type(., 'xsd:time', 0) or fnx:getRepTerm(@name) = 'Category'" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri datatype" see="#SD-43">
        <value-of select="concat(if (self::xsd:element) then 'Element ' else 'Attribute ',@name)"/> must use xsd:time for time data.
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>SD-44</title>
    <rule context="(xsd:element|xsd:attribute)[
                      (@name and (fnx:contains-i(@name, 'currency') or fnx:contains-i(@name, 'money')))
                   or (@type and (fnx:contains-i(@type, 'currency') or fnx:contains-i(@type, 'money')))]">
      <assert test="fnx:is-exception('SD-44',@name) or
                    fnx:uses-type(., 'com:ISOCurrencyCodeType', 0) or fnx:uses-type(.,'com:ExtendedISOCurrencyCodeType',0)" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-44">
        <value-of select="concat(if (self::xsd:element) then 'Element ' else 'Attribute ',@name)"/> must use com:ISOCurrencyCodeType for currency codes.
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>SD-45</title>
    <rule context="xsd:enumeration">
      <assert test="matches(@value,'^[a-zA-Z0-9_ ]+$')" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-45">The enumeration value &quot;<value-of select="@value"/>&quot; has invalid characters: <value-of select="replace(@value,'[a-zA-Z0-9_ ]','')"/>.</assert>
      <!--<assert test="fnx:is-exception('SD-45') or
                    not(matches(@value,'^[0-9]'))" flag="AUTO" role="WARNING">The enumeration value <value-of select="@value"/> starts with a numeric character.</assert>-->
    </rule>
  </pattern>
  <pattern>
    <title>SD-46</title>
    <!-- Enumeration values SHOULD be semantically sufficient, in English, and use as few characters as possible. The values SHOULD be drawn from common industrial property business language. 
    -->
    <rule context="*[xsd:enumeration[matches(@value,'[a-z][a-z]+')]][not(matches(ancestor::*[@name][1]/@name,'^ISO([A-Z][a-z])'))]">
      <report test="true()" flag="MANUAL" diagnostics="componentName namespaceName uri" see="#SD-46" role="WARNING">
        Enumeration values <value-of select="string-join(xsd:enumeration/@value,' / ')"/> SHOULD be semantically sufficient, in English, and use as few characters as possible. 
      </report>
    </rule>
  </pattern>
  <pattern>
    <title>SD-47</title>
    <!-- add something if an element uses a complexType that is abstract -->
    <rule context="xsd:complexType[@abstract='true']">
      <report test="true()" flag="MANUAL" diagnostics="componentName namespaceName uri" see="#SD-47" role="WARNING">
        Abstract complex type was used
      </report>
    </rule>
    <rule context="/">
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  <pattern>
    <title>SD-48</title>
    <rule context="xsd:attribute[@name]">
      <report test="true()" flag="MANUAL" diagnostics="componentName namespaceName uri" see="#SD-48" role="WARNING">
        <value-of select="@name"/> defines &quot;<value-of select="xsd:annotation/xsd:documentation"/>&quot;.
      </report>
    </rule>
  </pattern>
  <pattern>
    <title>SD-49</title>
    <rule context="xsd:element">
         <assert test="fnx:is-exception('SD-49',(@name|@ref)[1]) or
                    not(@minOccurs = '1')" role="WARNING" flag="AUTO" diagnostics="componentName namespaceName uri" see="#SD-49">
        @minOccurs is set to the default value (1) for <value-of select="name()"/> (<value-of select="@name|@ref"/>).
      </assert>
      <assert test="fnx:is-exception('SD-49',(@name|@ref)[1]) or
                    not(@maxOccurs = '1')" role="WARNING" flag="AUTO" diagnostics="componentName namespaceName uri" see="#SD-49">
        @maxOccurs is set to the default value (1) for <value-of select="name()"/> (<value-of select="@name|@ref"/>).
      </assert>
      </rule>
      <rule context="xsd:sequence | xsd:any | xsd:all | xsd:choice | xsd:group ">
         <assert test="fnx:is-exception('SD-49','') or
                    not(@minOccurs = '1')" role="WARNING" flag="AUTO" diagnostics="componentName namespaceName uri" see="#SD-49">
        @minOccurs is set to the default value (1) for <value-of select="name()"/>.
      </assert>
      <assert test="fnx:is-exception('SD-49','') or
                    not(@maxOccurs = '1')" role="WARNING" flag="AUTO" diagnostics="componentName namespaceName uri" see="#SD-49">
        @maxOccurs is set to the default value (1) for <value-of select="name()"/>.
      </assert>
      </rule>
  </pattern>
  <pattern>
    <title>SD-50</title>
    <!-- Empty elements MUST NOT be defined in schemas except for line break. -->
    <!-- If the ref attribute is present, complexType, simpleType, key, keyref, and unique elements and nillable, default, fixed, form, block, and type attributes cannot be present. -->
    <rule context= "xsd:element[not(@ref)]">
      <assert test="@name = 'Br'
                    or (not(xsd:simpleType/xsd:restriction[resolve-QName(@base,..) = xs:QName('xsd:token') or resolve-QName(@base,..) = xs:QName('xsd:string')]/xsd:maxLength[@value=0])
                    and not(xsd:complexType[not(@mixed='true')]/xsd:complexContent[not(@mixed='true')]/xsd:restriction[resolve-QName(@base,..) = xs:QName('xsd:anyType') and not(*)])
                    )" role="ERROR" flag="AUTO" diagnostics="componentName namespaceName uri" see="#SD-50">
        The <value-of select="@name"/> element is empty.
      </assert>
    </rule>
    <!-- from integrity check: min elements -->
    <rule context="xsd:complexType[not(@mixed='true') and (xsd:choice|xsd:sequence)[(@minOccurs='0')]] | xsd:complexType[not(@mixed='true') and xsd:complexContent[not(@mixed='true')]/xsd:restriction/(xsd:choice|xsd:sequence)[(@minOccurs='0')]]">
      <assert test="false()" role="ERROR" flag="AUTO" diagnostics="componentName namespaceName uri" see="#SD-50">
        The complexType <value-of select="@name"/> has no mandatory components. 
      </assert>
    </rule>
    <rule context="xsd:complexType[(xsd:choice|xsd:sequence)[not(@minOccurs='0') and not (some $x in child::*[local-name() !='attribute'] satisfies $x[not(@minOccurs='0')])]] | xsd:complexType[xsd:complexContent/xsd:restriction/(xsd:choice|xsd:sequence)[not(@minOccurs='0') and not (some $x in child::*[local-name() !='attribute'] satisfies $x[not(@minOccurs='0')])]]">
      <assert test="false()" role="ERROR" flag="AUTO" diagnostics="componentName namespaceName uri" see="#SD-50">
        The complexType <value-of select="@name"/> has no mandatory components. 
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>SD-51</title>
    <!-- The use attribute in an attribute usage SHOULD be omitted when the referenced attribute is optional since use="optional" is the default. -->
    <rule context="xsd:attribute">
      <assert test="fnx:is-exception('SD-51',(@ref|@name)) or
                    not(@use = 'optional')" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-51">        Attribute <value-of select="@ref|@name"/> has a
      use of "optional", the default value.</assert>
    </rule>
  </pattern>
  <pattern>
    <title>SD-52</title>
    <rule context="xsd:complexType">
      <assert test="fnx:is-exception('SD-52',ancestor-or-self::*/@name[1]) or
                    not(.//xsd:all)" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-52">&quot;<value-of
      select="ancestor-or-self::*/@name[1]"/>&quot; uses
      xsd:all.</assert>
    </rule>
  </pattern>
  <pattern>
    <title>SD-53</title>
    <rule context="xsd:sequence[@minOccurs | @maxOccurs] | xsd:choice[@minOccurs | @maxOccurs]">
      <!--
          TODO: may want to be manual but check what action we can get
          out of role="PASS" with Oxygen.

          DONE: Oxygen by default does not recognize role="PASS",
          just: warning/warn, fatal information/info, and error.
      -->
      <let name="component-name" value="ancestor-or-self::*[@name]/@name"/>
      <let name="count-children" value="count(child::*)"/>
      <!-- any child, b/c can have:
      <xsd:complexType name="HagueIBToOfficeBagType">
        <xsd:sequence>
          <xsd:element ref="dgn:HagueIBTransactionHeader">
            <xsd:annotation>
              <xsd:documentation>Counts of the Hague IB To Office transactions</xsd:documentation>
            </xsd:annotation>
          </xsd:element>
          <xsd:choice maxOccurs="3">
            <xsd:element ref="dgn:HagueOfficeCopyBag"/>
            <xsd:element ref="dgn:HagueAcknowledgementReceiptBag"/>
            <xsd:element ref="dgn:HagueIrregularityNotificationBag"/>
          </xsd:choice>
        </xsd:sequence>
      </xsd:complexType>
      -->
      
      <assert test="fnx:is-exception('SD-53',$component-name) or (@maxOccurs != 'unbounded' and not(number(@maxOccurs) lt $count-children)) or @maxOccurs = 'unbounded' or exists(@maxOccurs) = false()" flag="MANUAL" diagnostics="componentName namespaceName uri" see="#SD-53" role="WARNING">
        The <value-of select='concat(name(.), " maxOccurs ", @maxOccurs ," is less than the number of components ",$count-children)'/>.
      </assert>
      <assert test="fnx:is-exception('SD-53',$component-name) or (@maxOccurs != 'unbounded' and not(number(@maxOccurs) gt $count-children)) or @maxOccurs = 'unbounded' or exists(@maxOccurs) = false()" flag="MANUAL" diagnostics="componentName namespaceName uri" see="#SD-53" role="WARNING">
        The <value-of select='concat(name(.), " maxOccurs ", @maxOccurs ," is greater than the number of components ",$count-children)'/>.
      </assert>
      <assert test="fnx:is-exception('SD-53',$component-name) or (not(number(@minOccurs) gt $count-children)) or exists(@minOccurs) = false()" flag="MANUAL"  diagnostics="componentName namespaceName uri" see="#SD-53" role="WARNING">
        The <value-of select='concat(name(.), " minOccurs ", @minOccurs ," is greater than the number of components ",$count-children)'/>.
      </assert>
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  <pattern>
    <title>SD-54</title>
    <rule context="xsd:complexType">
      <assert test="not(.//xsd:any)" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-54">&quot;<value-of
      select="ancestor-or-self::*/@name[1]"/>&quot; uses xsd:any.</assert>
    </rule>
  </pattern>
  <pattern>
    <title>SD-55</title>
    <!-- substitutionGroup
The name of an element for which this element can be substituted. This element must have the same type or a type derived from the type of the specified element.

This attribute can be used on any element if the referring element is declared at the global level (parent is schema element). -->
    <rule context="xsd:element[not(@ref)]">
      <assert test="not(@substitutionGroup)" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-55">        Element <value-of select="@name"/> uses
      substitution groups.</assert>
    </rule>
  </pattern>
  <pattern>
    <title>SD-56</title>
    <rule context="/">
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  <pattern>
    <title>SD-57</title>
    <rule context="*[@type and resolve-QName(@type,..) =  (xs:QName('xsd:IDREFS'),xs:QName('xsd:IDREF'),xs:QName('com:idref'),xs:QName('com:idrefs'))]">
      <report test="true()" flag="MANUAL" diagnostics="componentName namespaceName uri" see="#SD-57" role="WARNING">Schema uses <value-of select="@type"/> for a single reference or multiple references within the current XML document.</report>
    </rule>
    <rule context="*[@name][descendant-or-self::*/@ref[resolve-QName(.,..) = (xs:QName('com:idref'),xs:QName('com:idrefs'))]]">
      <report test="true()" flag="MANUAL" diagnostics="componentName namespaceName uri" see="#SD-57" role="WARNING">Schema uses <value-of select="string-join(//@ref[resolve-QName(.,..) = (xs:QName('com:idref'),xs:QName('com:idrefs'))],', ')"/> for a single reference or multiple references within the current XML document.</report>
    </rule>
    <rule context="/">
      <!-- Schemas SHOULD use xsd:ID​/xsd:IDREF​/xsd:IDREFS for a single reference or multiple references within the current XML document to identify constraints as appropriate. -->
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  <pattern>
    <title>SD-58</title>
    <rule context="xsd:element[@name]|xsd:attribute[@name]">
         <assert test="fnx:is-exception('SD-58',@name) or
                    xsd:annotation/xsd:documentation[matches(.,'\w')]" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-58">
        The <value-of select="concat(@name, ' ', local-name(.))"/>
        is missing xsd:documentation.
      </assert>
         <report test="false()" flag="MANUAL"/>
      </rule>
  </pattern>
  <pattern>
    <title>SD-59</title>
    <rule context="/">
      <assert test="fnx:is-exception('SD-59','') or
                    not(comment())" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-59">
        Outside of the root element, there are XML comments containing
        the following text: <value-of select="comment()"/>
      </assert>
    </rule>
    <rule context="*">
      <assert test="fnx:is-exception('SD-59','') or
                    not(./comment())" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-59">
        Element (<value-of select="name(.)"/>) has XML comments
        containing the following text: <value-of select="comment()"/>
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>SD-60</title>
    <!-- Documentation SHOULD NOT be substituted for code lists using enumeration.
      
      e.g. 
      ocrConfidenceCode
      Optical Character Recognition Confidence Code in the form of numerical values in the range of 1 to 9 for each character
      
      can pattern match documentation to see if it says anything about the value  
            
      but only if it is NOT an enumeration....(SD-38)
      kind of an extension of SD-38
 --><rule context="/xsd:schema/*[matches(@name,'CodeType$')][xsd:annotation/xsd:documentation[matches(.,'value','i')]]">
      <assert test="fnx:is-exception('SD-60',@name) or fnx:hasAnEnumerationList(.)" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-60" flag="AUTO">
        Code list <value-of select="@name"/> is not declared as an enumeration list in a simpleType, and documentation states &quot;<value-of select="xsd:annotation/xsd:documentation"/>&quot;.
      </assert>
      <report test="false()" flag="MANUAL"/>
    </rule>
    
    
    <rule context="/xsd:schema/xsd:simpleType[matches(@name,'CodeType$')][xsd:union][xsd:annotation/xsd:documentation[matches(.,'value','i')]]">
      <let name="memberTypes" value="tokenize(normalize-space(xsd:union/@memberTypes), ' ')"/>
      <let name="memberDefinitions" value="for $x in $memberTypes, $ns in namespace-uri-from-QName(resolve-QName($x, .)) return ($definitions//d:namespace[@ns eq $ns]/*[@name eq local-name-from-QName(resolve-QName($x,.))])"/>
      <assert test="fnx:is-exception('SD-60',@name) or fnx:hasAnEnumerationList(.)" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-60" flag="AUTO">
        Code list <value-of select="@name"/> is not declared as an enumeration list in a simpleType, and documentation states &quot;<value-of select="xsd:annotation/xsd:documentation"/>&quot;.
      </assert>
      <report test="false()" flag="MANUAL"/>
    </rule>
    
    <rule context="*[self::xsd:element or self::xsd:attribute][ends-with(@name,'Code')][xsd:annotation/xsd:documentation[matches(.,'value','i')]]">
      <let name="definitionType" value="for $x in @type, $ns in namespace-uri-from-QName(resolve-QName($x, .)) return ($definitions//d:namespace[@ns eq $ns]/*[@name eq local-name-from-QName(resolve-QName($x,.))])"/>
      <assert test="fnx:is-exception('SD-60',@name) or fnx:hasAnEnumerationList(.)" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-60" flag="AUTO">
        Code list <value-of select="@name"/> is not declared as an enumeration list in a simpleType, and documentation states &quot;<value-of select="xsd:annotation/xsd:documentation"/>&quot;.
      </assert>
      <report test="false()" flag="MANUAL"/>
    </rule>
    
  </pattern>
  <pattern>
    <title>SD-61</title>
    <rule context="/xsd:schema">
	  <assert test="$inSubdirName != 'Document'
                    or count(/xsd:schema/xsd:complexType) &gt; 0
                    or (count (/xsd:schema/xsd:annotation/xsd:appinfo) = 1
							and string-length(/xsd:schema/xsd:annotation/xsd:appinfo) &gt; 0)"
              flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-61">
        The xsd:schema does not contain an xsd:annotation/xsd:documentation element.
      </assert>
	  <assert test="$inSubdirName != 'Document'
                    or count(/xsd:schema/xsd:complexType) &gt; 0
                    or not(count (/xsd:schema/xsd:annotation/xsd:appinfo) = 1
							and string-length(/xsd:schema/xsd:annotation/xsd:appinfo) &gt; 0)
                    or (count (/xsd:schema/xsd:annotation/xsd:appinfo/com:SchemaCreatedDate) = 1
							and string-length(/xsd:schema/xsd:annotation/xsd:appinfo/com:SchemaCreatedDate) &gt; 0)"
              flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-61">
        The xsd:annotation/xsd:appinfo element does not contain the required &quot;com:SchemaCreatedDate&quot; element.
      </assert>
	  <assert test="$inSubdirName != 'Document'
                    or count(/xsd:schema/xsd:complexType) &gt; 0
                    or not(count (/xsd:schema/xsd:annotation/xsd:appinfo) = 1
							and string-length(/xsd:schema/xsd:annotation/xsd:appinfo) &gt; 0)
                    or (count (/xsd:schema/xsd:annotation/xsd:appinfo/com:SchemaLastModifiedDate) = 1
							and string-length(/xsd:schema/xsd:annotation/xsd:appinfo/com:SchemaLastModifiedDate) &gt; 0)"
              flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-61">
        The xsd:annotation/xsd:appinfo element does not contain the required &quot;com:SchemaLastModifiedDate&quot; element.
      </assert>
	  <assert test="$inSubdirName != 'Document'
                    or count(/xsd:schema/xsd:complexType) &gt; 0
                    or not(count (/xsd:schema/xsd:annotation/xsd:appinfo) = 1
							and string-length(/xsd:schema/xsd:annotation/xsd:appinfo) &gt; 0)
                    or (count (/xsd:schema/xsd:annotation/xsd:appinfo/com:SchemaContactPoint) = 1
							and string-length(/xsd:schema/xsd:annotation/xsd:appinfo/com:SchemaContactPoint) &gt; 0)"
              flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-61">
        The xsd:annotation/xsd:appinfo element does not contain the required &quot;com:SchemaContactPoint&quot; element.
      </assert>
	  <assert test="fnx:is-exception('SD-61','')
                    or $inSubdirName != 'Document'
                    or count(/xsd:schema/xsd:complexType) &gt; 0
                    or not(count (/xsd:schema/xsd:annotation/xsd:appinfo) = 1
							and string-length(/xsd:schema/xsd:annotation/xsd:appinfo) &gt; 0)
                    or (count (/xsd:schema/xsd:annotation/xsd:appinfo/com:SchemaReleaseNoteURL) = 1
							and string-length(/xsd:schema/xsd:annotation/xsd:appinfo/com:SchemaReleaseNoteURL) &gt; 0)"
              flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-61">
        The xsd:annotation/xsd:appinfo element does not contain the optional &quot;com:SchemaReleaseNoteURL&quot; element.
      </assert>
    </rule>
  </pattern>
  <pattern>
    <title>SD-62</title>
    <rule context="*[child::*[local-name() = ('key','unique','keyref')]]">
      <!-- Schemas SHOULD use xsd:key/xsd:unique/xsd:keyref within a scope where uniqueness has to stay entirely within that scope. -->
      <report test="true()" flag="MANUAL" diagnostics="componentName namespaceName uri" see="#SD-62" role="WARNING">
        Schemas SHOULD use xsd:key/xsd:unique/xsd:keyref within a scope where uniqueness has to stay entirely within that scope. <value-of select="string-join((name(),@name),' ')"/> uses <value-of select="child::*[local-name() = ('key','unique','keyref')]/name()"/>
      </report>
    </rule>
  </pattern>
  <pattern>
    <title>SD-63</title>
    <!-- The schema for a Document component MUST declare an optional ipoVersion attribute on the root element with a fixed value that matches the IPO’s implementation release version in the following format: <ST.3 Code>”_” “V”<major version number>”_”<minor version number>, for example, “US_V2_0”.
      check against pure ST.96 schema will always fail b/c <xsd:attribute name="ipoVersion" type="xsd:token"> without fixed value
     
     message should be three-part
        one whether it declares the ipoVersion attribute
        two whether it declares the ipoVersion attribute as optional (default), or required
        and three whether its ipoVersion is set to @fixed with the pattern...
 -->
    <!-- will always fail UNLESS IPO implementation?
    st96 will always be:
	<xsd:attribute name="ipoVersion" type="xsd:token">
but IPO implementation will be:
	<xsd:attribute name="ipoVersion" type="xsd:token" fixed="US_V8_0">

    -->
    
    <rule context="/xsd:schema[not(xsd:element[2])]/xsd:element">
      <let name="ipoImplementation" value="ancestor::xsd:schema[1]/@targetNamespace = ($kIPOCommonNamespace,$kIPONonCommonNamespaces)"/>
      <assert test="not($ipoImplementation) or (($inSubdirName != 'Document' or fnx:has-attribute(.,'ipoVersion','optional') or fnx:has-attribute(.,'ipoVersion','required')) and $ipoImplementation)" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-63" >
        Root element does not declare the ipoVersion attribute
      </assert>
      <assert test="not($ipoImplementation) or (($inSubdirName != 'Document' or fnx:has-attribute(.,'ipoVersion','optional') or fnx:has-attribute(.,'ipoVersion','required')) and $ipoImplementation)" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-63"><!-- check this, IPO XSD declaring ipoVersion as required is ok? -->
          Root element does not declare the ipoVersion attribute as optional
      </assert>
      <assert test="not($ipoImplementation) or (($inSubdirName != 'Document' or not(fnx:has-attribute(.,'ipoVersion','optional'))
                    or fnx:has-fixed-attribute(., 'ipoVersion', 'optional', concat('^(',string-join($st3Codes,'|'),')_',$kRegexReleaseVersion,'$'))) and $ipoImplementation)"
              flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-63">
        Root element does not declare optional ipoVersion attribute
        with a fixed value of the form &lt;ST3CODE&gt;_V&lt;major version&gt;_&lt;minor version&gt;{_&lt;patch version&gt;}.
      </assert>
    </rule>
    <rule context="xsd:attribute[@fixed][@name = 'ipoVersion']">
      <let name="ipoImplementation" value="ancestor::xsd:schema[1]/@targetNamespace = ($kIPOCommonNamespace,$kIPONonCommonNamespaces)"/>

      <assert test="(fnx:is-exception('SD-63',@name)
                    or matches(@fixed,concat('^(',string-join($st3Codes,'|'),')_')))"
              flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-63"><!-- as long as fixed, check value, irrespective of whether IPO specific schema -->
        @ipoVersion=<value-of select="@fixed"/> is fixed but does not start with a valid ST.3 code.
      </assert>
      <assert test="matches(@fixed,concat('^[A-Z][A-Z]','_',$kRegexReleaseVersion,'$'))" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-63">
        @ipoVersion=<value-of select="@fixed"/> is fixed but does not have the format &lt;ST.3 Code&gt;_V&lt;major version number&gt;_&lt;minor version number&gt;_&lt;optional patch number&gt;.
      </assert>
    </rule>
  </pattern>

  <pattern>
    <title>SD-64</title>
<!--
OLD: none
NEW: Schema release folder, a document level schema filename and a flattened schema filename MUST contain matching version information comprising the major and minor version number.
-->    <!-- directory structure as of V3_0:
          zip:
            ST96XMLSchema_VM_n
            > Namespace
            >> Document 
            >>> xsds
            >> xsds
            
          zip for flattened:
           ST96XMLSchema_V3_0_Flattened
           > xsds
           
    -->
    <!-- **** check:
          schema release folder AND versions match with document level schema filename, OR
          schema release folder AND versions match with flattened schema filename
    -->
    <!-- Schema release folder, a document level schema filename and a flattened schema filename MUST contain matching version information comprising the major and minor version number. -->
    <!--<let name="releaseDirName" value="if (matches(base-uri(.),$kRegexReleaseDir)) then replace(base-uri(.), $kRegexReleaseDir, '$1') else ''"/>-->
    <let name="releaseDirName" value="replace(base-uri(.),concat('((',string-join($namespaces/@subdir,'|'),')/(Document/)?)?[^/]+$'),'')"/><!-- remove namespace (and Document) folder along with filename to retrieve the directory -->
    <let name="releaseMajorVersionNum"
         value="if (matches($releaseDirName,concat($kRegexReleaseVersion,'/$'))) then replace($releaseDirName,'.*V([0-9]+)_.*/$','$1') else ''"/>
    <let name="releaseMinorVersionNum"
         value="if (matches($releaseDirName,concat($kRegexReleaseVersion,'/$'))) then replace($releaseDirName,'.*V([0-9]+)_([0-9]+).*/$','$2') else ''"/>
    <let name="releasePatchVersionNum" value="if (matches($releaseDirName,concat($kRegexReleaseVersion,'/$'))) then replace($releaseDirName,'.*V([0-9]+)_([0-9]+).*(_([0-9]+))?.*/$','$4') else ''"/>
    <let name="fileMajorVersionNum"
         value="if (matches($localFile,$kRegexLocalFileVersion)) then replace($localFile,concat('^.*',$kRegexLocalFileVersion),'$1') else ''"/>
    <let name="fileMinorVersionNum"
         value="if (matches($localFile,$kRegexLocalFileVersion)) then replace($localFile,concat('^.*',$kRegexLocalFileVersion),'$2') else ''"/>
    <let name="filePatchVersionNum" value="if (matches($localFile,$kRegexLocalFileVersion)) then replace($localFile,concat('^.*',$kRegexLocalFileVersion),'$4') else ''"/>
    <rule context="/">
      <assert test="not($isFlattened)
                    or matches($localFile, $kRegexLocalFileVersion)" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-64">
        The flattened schema file name <value-of select="$localFile"/> does not contain version information in the required format &#x003C;ComponentName&#x003E;{_V&#x003C;MajorVersionNumber&#x003E;_&#x003C;MinorVersionNumber&#x003E;_&#x003C;OptionalPatchVersionNumber&#x003E;}.&#x003C;FileExtension&#x003E;
      </assert>
      <assert test="matches($releaseDirName,$kRegexReleaseDir)" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-64">
        Schema release folder <value-of select="$releaseDirName"/> does not have required &quot;_V&#x003C;MajorVersionNumber&#x003E;_&#x003C;MinorVersionNumber&#x003C;_&#x003C;OptionalPatchVersionNumber&#x003E;&quot; for flattened XSD named <value-of select="$localFile"/>.
      </assert>
      <assert test="$inSubdirName != 'Document'
                    or matches($localFile, $kRegexLocalFileVersion)" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-64">
        The Document schema file name <value-of select="$localFile"/> does not contain version information in the required format &#x003C;ComponentName&#x003E;{_V&#x003C;MajorVersionNumber&#x003E;_&#x003C;MinorVersionNumber&#x003E;_&#x003C;OptionalPatchVersionNumber&#x003E;}.&#x003C;FileExtension&#x003E;
      </assert>
      <!--<report test="true()">
        is document? <value-of select="$inSubdirName = 'Document'"/>
        Schema release folder <value-of select="$releaseDirName"/> 
        filename <value-of select="$localFile"/>
        regex <value-of select="$kRegexReleaseDir"/>
      </report>-->

      <assert test="$inSubdirName != 'Document'
                    or ($releaseDirName != ''
                        and $releaseMajorVersionNum != ''
                        and $releaseMinorVersionNum != '')" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-64"><!-- may have a mix of versions, since controlled by /schema/@version, and ipo implementation could have: USImplementationPatent_V7_1/Patent/V7_1/Schema/Patent/Document/ApplicationBodyType_V2_1.xsd -->
        No schema release folder was found with the required version information V&#x003C;MajorVersionNumber&#x003E;_&#x003C;MinorVersionNumber&#x003E;{_&lt;OptionalPatchNumber&gt;} for Document XSD named <value-of select="$localFile"/>. In the ST.96 schema release folder structure, the release version number is followed by component types. For example, the version 3.0 of Contact component is placed in the folder, ST96/V3_0/Common.
      </assert>

      <assert test="not($isFlattened)
                    or $releaseMajorVersionNum = ''
                    or $releaseMinorVersionNum = ''
                    or $fileMajorVersionNum = ''
                    or $fileMinorVersionNum = ''
                    or ($releaseMajorVersionNum = $fileMajorVersionNum)" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-64">
        The flattened schema file name <value-of select="$localFile"/> has a major version number (<value-of select="$fileMajorVersionNum"/>) that does not match the release major version number (<value-of select="$releaseMajorVersionNum"/>).
      </assert>
      <assert test="not($isFlattened)
                    or $releaseMajorVersionNum = ''
                    or $releaseMinorVersionNum = ''
                    or $fileMajorVersionNum = ''
                    or $fileMinorVersionNum = ''
                    or ($releaseMinorVersionNum = $fileMinorVersionNum)
                    " flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-64">
        The flattened schema file name <value-of select="$localFile"/> has a minor version number (<value-of select="$fileMinorVersionNum"/>) that does not match the release minor version number (<value-of select="$releaseMinorVersionNum"/>).
      </assert>
      <assert test="not($isFlattened)
                    or $releaseMajorVersionNum = ''
                    or $releaseMinorVersionNum = ''
                    or $fileMajorVersionNum = ''
                    or $fileMinorVersionNum = ''
                    or ($releasePatchVersionNum = $filePatchVersionNum)
                    " flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-64">
        The flattened schema file name <value-of select="$localFile"/> has a patch version number (<value-of select="$filePatchVersionNum"/>) that does not match the release patch version number (<value-of select="$releasePatchVersionNum"/>).
      </assert>

      <assert test="$inSubdirName != 'Document'
                    or $releaseMajorVersionNum = ''
                    or $releaseMinorVersionNum = ''
                    or $fileMajorVersionNum = ''
                    or $fileMinorVersionNum = ''
                    or ($releaseMajorVersionNum = $fileMajorVersionNum)
                    " flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-64">
        The Document schema file name <value-of select="$localFile"/> has a major version number (<value-of select="$fileMajorVersionNum"/>) that does not match the release major version number (<value-of select="$releaseMajorVersionNum"/>).
      </assert>
      <assert test="$inSubdirName != 'Document'
                    or $releaseMajorVersionNum = ''
                    or $releaseMinorVersionNum = ''
                    or $fileMajorVersionNum = ''
                    or $fileMinorVersionNum = ''
                    or ($releaseMinorVersionNum = $fileMinorVersionNum)
                    " flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-64">
        The Document schema file name <value-of select="$localFile"/> has a minor version number (<value-of select="$fileMinorVersionNum"/>) that does not match the release minor version number (<value-of select="$releaseMinorVersionNum"/>).
      </assert>

      <assert test="$inSubdirName != 'Document'
                    or $releaseMajorVersionNum = ''
                    or $releaseMinorVersionNum = ''
                    or $fileMajorVersionNum = ''
                    or $fileMinorVersionNum = ''
                    or ($releasePatchVersionNum = $filePatchVersionNum)
                    " flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-64">
        The Document schema file name <value-of select="$localFile"/> has a patch version number (<value-of select="$filePatchVersionNum"/>) that does not match the release patch version number (<value-of select="$releasePatchVersionNum"/>).
      </assert>
      <!--
      <assert test="false()" flag="AUTO">
        base-uri(.)=<value-of select="base-uri(.)"/>
        inSubdirName=<value-of select="$inSubdirName"/>
        localFile=<value-of select="$localFile"/>
        releaseDirName=<value-of select="$releaseDirName"/>
        releaseMajorVersionNum=<value-of select="$releaseMajorVersionNum"/>
        releaseMinorVersionNum=<value-of select="$releaseMinorVersionNum"/>
        fileMajorVersionNum=<value-of select="$fileMajorVersionNum"/>
        fileMinorVersionNum=<value-of select="$fileMinorVersionNum"/>
      </assert>
      -->
    </rule>
  </pattern>


  <pattern>
    <title>SD-65</title>
    <!-- Ascertain Common vs GeographicalIndication based upon
         name of containing subdirectory -->
      <rule context="/xsd:schema">
         <assert test="$inComponentSubdirName != 'GeographicalIndication' or @targetNamespace = $kGeographicalIndicationNamespace" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-65">
        For XSD found in the GeographicalIndication subdirectory, @targetNamespace
        (<value-of select="@targetNamespace"/>) must equal <value-of select="$kGeographicalIndicationNamespace"/>
         </assert>
        <assert test="fnx:is-exception('SD-65','') or
                       not($inComponentSubdirName = ($namespaces[not(@std ='external' or @std = 'ST96')][@component='geographicalindication']/@subdir)) or @targetNamespace = $kIPOGeographicalIndicationNamespace" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-65">
           For XSD found in the <value-of select="$inComponentSubdirName"/> subdirectory, @targetNamespace
           (<value-of select="@targetNamespace"/>) must equal <value-of select="$kIPOGeographicalIndicationNamespace"/>
            </assert>
      </rule>
  </pattern>
  
  <pattern>
    <title>SD-66</title>
    <!-- Ascertain Common vs Copyright based upon
         name of containing subdirectory -->
      <rule context="/xsd:schema">
         <assert test="$inComponentSubdirName != 'Copyright' or @targetNamespace = $kCopyrightNamespace" flag="AUTO" role="ERROR" diagnostics="componentName namespaceName uri" see="#SD-66">
        For XSD found in the Copyright subdirectory, @targetNamespace
        (<value-of select="@targetNamespace"/>) must equal <value-of select="$kCopyrightNamespace"/>
         </assert>
        <assert test="fnx:is-exception('SD-66','') or
                       not($inComponentSubdirName = ($namespaces[not(@std ='external' or @std = 'ST96')][@component='copyright']/@subdir)) or @targetNamespace = $kCopyrightNamespace" flag="AUTO" role="WARNING" diagnostics="componentName namespaceName uri" see="#SD-66">
           For XSD found in the <value-of select="$inComponentSubdirName"/> subdirectory, @targetNamespace
           (<value-of select="@targetNamespace"/>) must equal <value-of select="$kCopyrightNamespace"/>
            </assert>
      </rule>
  </pattern>
  
  <pattern>
    <title>SD-67</title>
    <!-- [SD-67]	A patched version MAY not be able to validate all instance documents created with previous minor versions.  -->
    <rule context="/">
      <report test="false()" flag="MANUAL"/>
    </rule>
  </pattern>
  
  <diagnostics>
    <diagnostic id="componentName">
      <value-of select="ancestor-or-self::*[@name][1]/@name"/>
    </diagnostic>
    <diagnostic id="namespaceName">
      <value-of select="$targetNamespaceName"/>
    </diagnostic>
    <diagnostic id="uri">
      <value-of select="document-uri(/)"/>
    </diagnostic>
    <!-- overly redundant, but added so can merge svrl results purely based on failed-assert/successful-report -->
    <diagnostic id="datatype">
      <value-of select="fnx:getDataType(.)"/>
    </diagnostic>
  </diagnostics>
</schema>
