/*
 * Decompiled with CFR 0.152.
 */
package com.atlascopco.hunspell;

import com.atlascopco.hunspell.HunspellLibrary;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bridj.Pointer;
import org.bridj.PointerIO;

public class Hunspell
implements Closeable {
    private Pointer<HunspellLibrary.Hunhandle> handle;
    private Exception closedAt;

    public Hunspell(String dictionaryPath, String affixPath) {
        Pointer<Byte> affpath = Pointer.pointerToCString(affixPath);
        Pointer<Byte> dpath = Pointer.pointerToCString(dictionaryPath);
        this.handle = HunspellLibrary.Hunspell_create(affpath, dpath);
        if (this.handle == null) {
            throw new RuntimeException("Unable to instantiate Hunspell handle.");
        }
    }

    public Hunspell(String dictionaryPath, String affixPath, String key) {
        Pointer<Byte> affpath = Pointer.pointerToCString(affixPath);
        Pointer<Byte> dpath = Pointer.pointerToCString(dictionaryPath);
        Pointer<Byte> keyCString = Pointer.pointerToCString(key);
        this.handle = HunspellLibrary.Hunspell_create_key(affpath, dpath, keyCString);
        if (this.handle == null) {
            throw new RuntimeException("Unable to instantiate Hunspell handle.");
        }
    }

    public boolean spell(String word) {
        this.checkHandle();
        this.checkWord("word", word);
        Pointer<Byte> wordCString = this.toEncodedCString(word);
        int result = HunspellLibrary.Hunspell_spell(this.handle, wordCString);
        return result != 0;
    }

    public boolean isCorrect(String word) {
        return this.spell(word);
    }

    private Charset getDictionaryCharset() {
        return Charset.forName(this.getDictionaryEncoding());
    }

    public String getDictionaryEncoding() {
        this.checkHandle();
        Pointer<Byte> dictionaryEncoding = HunspellLibrary.Hunspell_get_dic_encoding(this.handle);
        return dictionaryEncoding.getCString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> suggest(String word) {
        this.checkHandle();
        this.checkWord("word", word);
        Pointer<Byte> wordCString = this.toEncodedCString(word);
        Pointer<Pointer<Pointer<Byte>>> slst = Pointer.allocatePointerPointer(Byte.class);
        int numResults = 0;
        List<String> suggestions = Collections.emptyList();
        try {
            numResults = HunspellLibrary.Hunspell_suggest(this.handle, slst, wordCString);
            suggestions = this.encodedCStringListToStringList(slst, numResults);
        }
        finally {
            if (slst != null) {
                this.free_list(slst, numResults);
            }
        }
        return suggestions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> analyze(String word) {
        this.checkHandle();
        this.checkWord("word", word);
        Pointer<Byte> wordCString = this.toEncodedCString(word);
        Pointer<Pointer<Pointer<Byte>>> slst = Pointer.allocatePointerPointer(Byte.class);
        int numResults = 0;
        List<String> suggestions = Collections.emptyList();
        try {
            numResults = HunspellLibrary.Hunspell_analyze(this.handle, slst, wordCString);
            suggestions = this.encodedCStringListToStringList(slst, numResults);
        }
        finally {
            if (slst != null) {
                this.free_list(slst, numResults);
            }
        }
        return suggestions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> stem(String word) {
        this.checkHandle();
        this.checkWord("word", word);
        Pointer<Byte> wordCString = this.toEncodedCString(word);
        Pointer<Pointer<Pointer<Byte>>> slst = Pointer.allocatePointerPointer(Byte.class);
        int numResults = 0;
        List<String> suggestions = Collections.emptyList();
        try {
            numResults = HunspellLibrary.Hunspell_stem(this.handle, slst, wordCString);
            suggestions = this.encodedCStringListToStringList(slst, numResults);
        }
        finally {
            if (slst != null) {
                this.free_list(slst, numResults);
            }
        }
        return suggestions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> stem(List<String> analysis) {
        this.checkHandle();
        Pointer<Pointer<Pointer<Byte>>> slst = Pointer.allocatePointerPointer(Byte.class);
        Pointer<Pointer<Byte>> analysisCStrings = this.toEncodedCStringList(analysis);
        int numResults = 0;
        List<String> suggestions = Collections.emptyList();
        try {
            numResults = HunspellLibrary.Hunspell_stem2(this.handle, slst, analysisCStrings, analysis.size());
            suggestions = this.encodedCStringListToStringList(slst, numResults);
        }
        finally {
            if (slst != null) {
                this.free_list(slst, numResults);
            }
        }
        return suggestions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> generate(String word, String basedOn) {
        this.checkHandle();
        this.checkWord("word", word);
        this.checkWord("basedOn", basedOn);
        Pointer<Pointer<Pointer<Byte>>> slst = Pointer.allocatePointerPointer(Byte.class);
        Pointer<Byte> wordCString = this.toEncodedCString(word);
        Pointer<Byte> word2CString = this.toEncodedCString(basedOn);
        int numResults = 0;
        List<String> suggestions = Collections.emptyList();
        try {
            numResults = HunspellLibrary.Hunspell_generate(this.handle, slst, wordCString, word2CString);
            suggestions = this.encodedCStringListToStringList(slst, numResults);
        }
        finally {
            if (slst != null) {
                this.free_list(slst, numResults);
            }
        }
        return suggestions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> generate(String word, List<String> basedOnAnalysis) {
        this.checkHandle();
        this.checkWord("word", word);
        Pointer<Pointer<Pointer<Byte>>> slst = Pointer.allocatePointerPointer(Byte.class);
        Pointer<Byte> wordCString = this.toEncodedCString(word);
        Pointer<Pointer<Byte>> analysisCStrings = this.toEncodedCStringList(basedOnAnalysis);
        int numResults = 0;
        List<String> suggestions = Collections.emptyList();
        try {
            numResults = HunspellLibrary.Hunspell_generate2(this.handle, slst, wordCString, analysisCStrings, basedOnAnalysis.size());
            suggestions = this.encodedCStringListToStringList(slst, numResults);
        }
        finally {
            if (slst != null) {
                this.free_list(slst, numResults);
            }
        }
        return suggestions;
    }

    public void addDic(String dpath) {
        this.checkHandle();
        Pointer<Byte> dpathCString = Pointer.pointerToCString(dpath);
        int result = HunspellLibrary.Hunspell_add_dic(this.handle, dpathCString);
        if (result != 0) {
            throw new RuntimeException("No available slot to add dictionary.");
        }
    }

    public void add(String word) {
        this.checkHandle();
        this.checkWord("word", word);
        Pointer<Byte> wordCString = this.toEncodedCString(word);
        int result = HunspellLibrary.Hunspell_add(this.handle, wordCString);
        if (result != 0) {
            throw new RuntimeException("An error occurred when calling Hunspell_add: " + result);
        }
    }

    public void addWithAffix(String word, String exampleWord) {
        this.checkHandle();
        this.checkWord("word", word);
        this.checkWord("exampleWord", exampleWord);
        Pointer<Byte> wordCString = this.toEncodedCString(word);
        Pointer<Byte> example = this.toEncodedCString(exampleWord);
        int result = HunspellLibrary.Hunspell_add_with_affix(this.handle, wordCString, example);
        if (result != 0) {
            throw new RuntimeException("An error occurred when calling Hunspell_add_with_affix: " + result);
        }
    }

    public void remove(String word) {
        this.checkHandle();
        this.checkWord("word", word);
        Pointer<Byte> wordCString = this.toEncodedCString(word);
        int result = HunspellLibrary.Hunspell_remove(this.handle, wordCString);
        if (result != 0) {
            throw new RuntimeException("An error occurred when calling Hunspell_remove: " + result);
        }
    }

    private void free_list(Pointer<Pointer<Pointer<Byte>>> slst, int n) {
        HunspellLibrary.Hunspell_free_list(this.handle, slst, n);
    }

    private void checkWord(String parameterName, String value) {
        if (value.length() > 256) {
            throw new IllegalArgumentException("Word '" + parameterName + "' greater than max acceptable length (" + 256 + "): " + value);
        }
    }

    private void checkHandle() {
        if (this.handle == null && this.closedAt != null) {
            throw new IllegalStateException("This instance has already been closed.", this.closedAt);
        }
        if (this.handle == null) {
            throw new IllegalStateException("Hunspell handle is null, but instance has not been closed.");
        }
    }

    @Override
    public void close() {
        if (this.closedAt != null) {
            return;
        }
        if (this.handle == null) {
            return;
        }
        HunspellLibrary.Hunspell_destroy(this.handle);
        this.handle = null;
        this.closedAt = new Exception();
    }

    protected void finalize() throws Throwable {
        if (this.closedAt == null) {
            this.close();
            System.err.println("Hunspell instance was not closed!");
        }
        super.finalize();
    }

    private byte[] encodeCStringBytes(String str) {
        byte[] strBytes = str.getBytes(this.getDictionaryCharset());
        byte[] cStringBytes = new byte[strBytes.length + 1];
        System.arraycopy(strBytes, 0, cStringBytes, 0, strBytes.length);
        cStringBytes[cStringBytes.length - 1] = 0;
        return cStringBytes;
    }

    private Pointer<Byte> toEncodedCString(String str) {
        byte[] cStringBytes = this.encodeCStringBytes(str);
        Pointer<Byte> ptrBytes = Pointer.pointerToBytes(cStringBytes);
        return ptrBytes;
    }

    public Pointer<Pointer<Byte>> toEncodedCStringList(final List<String> strings) {
        if (strings == null) {
            return null;
        }
        final int len = strings.size();
        final Pointer[] pointers = new Pointer[len];
        Pointer<Pointer<Byte>> mem = Pointer.allocateArray(PointerIO.getPointerInstance(Byte.class), len, new Pointer.Releaser(){

            @Override
            public void release(Pointer<?> p) {
                Pointer<?> mem = p;
                Charset dictionaryCharset = Hunspell.this.getDictionaryCharset();
                for (int i = 0; i < len; ++i) {
                    Pointer pp = (Pointer)mem.get(i);
                    if (pp != null) {
                        strings.set(i, pp.getString(Pointer.StringType.C, dictionaryCharset));
                    }
                    if ((pp = pointers[i]) == null) continue;
                    pp.release();
                }
            }
        });
        for (int i = 0; i < len; ++i) {
            pointers[i] = this.toEncodedCString(strings.get(i));
            mem.set(i, pointers[i]);
        }
        return mem;
    }

    private String encodedCStringToJavaString(Pointer<Byte> cString) {
        return cString.getStringAtOffset(0L, Pointer.StringType.C, this.getDictionaryCharset());
    }

    private List<String> encodedCStringListToStringList(Pointer<Pointer<Pointer<Byte>>> slst, int numResults) {
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < numResults; ++i) {
            strings.add(this.encodedCStringToJavaString(slst.get().get(i)));
        }
        return strings;
    }
}

