/*
 * Decompiled with CFR 0.152.
 */
import com.atlascopco.hunspell.Hunspell;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Scanner;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;

public class ST96SpellChecker {
    protected static void printUsage() {
        String nl = System.getProperty("line.separator");
        StringBuffer msg = new StringBuffer();
        msg.append("usage: ST96SpellChecker [mandatory] 1 2 3 [optional] -a 4 -c 5 -o 6" + nl + nl);
        msg.append("mandatory arguments: " + nl);
        msg.append(" 1. words file path=<path>\tpath to file containing words to be checked, e.g st96words.txt" + nl);
        msg.append(" 2. dictionary file path=<path>\tpath to language dictionary file, e.g. en_GB-large.dic" + nl);
        msg.append(" 3. affix file path=<path>\tpath to language affix file, e.g. en_GB-large.aff" + nl + nl);
        msg.append("optional: " + nl);
        msg.append(" -a  4. words affix file path=<path>\tpath to custom affix file containing words to be checked, e.g CustomWords-ST96-aff.txt" + nl);
        msg.append(" -c  5. custom words file path=<path>\tpath to custom words file, e.g. CustomWords-ST96.txt" + nl);
        msg.append(" -o  6. output xml file path=<path>\tpath to output file, e.g. output.xml" + nl + nl);
        msg.append("  -help, -h, -?          print this message" + nl);
        System.out.println(msg.toString());
    }

    public static void main(String[] args) throws Exception {
        Object arg;
        if (args.length < 3) {
            ST96SpellChecker.printUsage();
            return;
        }
        ArrayList<String> wordList = new ArrayList<String>();
        File file = new File(args[0]);
        File outputFile = new File("output.xml");
        String hunspellDictionaryPath = args[1];
        String hunspellDictionaryTreePath = args[2];
        Hunspell hunspell = new Hunspell(hunspellDictionaryPath, hunspellDictionaryTreePath);
        for (int i = 0; i < args.length; ++i) {
            Throwable throwable;
            arg = args[i];
            if (((String)arg).equals("-help") || ((String)arg).equals("-h") || ((String)arg).equals("-?")) {
                ST96SpellChecker.printUsage();
                return;
            }
            if (((String)arg).equals("-a")) {
                File cusfilef = new File(args[i + 1]);
                try {
                    throwable = null;
                    try (Scanner scanf = new Scanner(cusfilef);){
                        while (scanf.hasNextLine()) {
                            String[] wfl = scanf.nextLine().split(":");
                            if (wfl.length <= 1) continue;
                            hunspell.addWithAffix(wfl[0], wfl[1]);
                        }
                        scanf.close();
                    }
                    catch (Throwable wfl) {
                        throwable = wfl;
                        throw wfl;
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
            if (((String)arg).equals("-c")) {
                File cusfile = new File(args[i + 1]);
                try {
                    throwable = null;
                    try (Scanner scan = new Scanner(cusfile);){
                        while (scan.hasNextLine()) {
                            hunspell.add(scan.nextLine());
                        }
                        scan.close();
                    }
                    catch (Throwable wfl) {
                        throwable = wfl;
                        throw wfl;
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
            if (!((String)arg).equals("-o")) continue;
            outputFile = new File(args[i + 1]);
        }
        try {
            Scanner scan = new Scanner((InputStream)new FileInputStream(file), StandardCharsets.UTF_8.name());
            arg = null;
            try {
                while (scan.hasNextLine()) {
                    wordList.add(scan.nextLine());
                }
                scan.close();
            }
            catch (Throwable cusfile) {
                arg = cusfile;
                throw cusfile;
            }
            finally {
                if (scan != null) {
                    if (arg != null) {
                        try {
                            scan.close();
                        }
                        catch (Throwable cusfile) {
                            ((Throwable)arg).addSuppressed(cusfile);
                        }
                    } else {
                        scan.close();
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        HashSet<String> set = new HashSet<String>();
        for (int j = 0; j < wordList.size(); ++j) {
            String[] words;
            for (String word : words = ((String)wordList.get(j)).split(",")) {
                set.add(word);
            }
        }
        ArrayList sortedWords = new ArrayList(set);
        Collections.sort(sortedWords);
        Iterator it = sortedWords.iterator();
        String word = "";
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = factory.createXMLStreamWriter(new FileWriter(outputFile));
        writer.writeStartDocument();
        writer.writeStartElement("ST96SpellingIssues");
        writer.writeCharacters("\n");
        while (it.hasNext()) {
            word = it.next().toString();
            if (hunspell.spell(word)) continue;
            writer.writeStartElement("entry");
            writer.writeAttribute("word", word);
            writer.writeAttribute("suggestions", hunspell.suggest(word).toString().replace("[", "").replace("]", ""));
            writer.writeEndElement();
            writer.writeCharacters("\n");
        }
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
        writer.close();
    }
}

