<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:WIPO="http://www.altova.com/MapForce/UDF/WIPO" xmlns:vmf="http://www.altova.com/MapForce/UDF/vmf" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common" xmlns:dgn="http://www.wipo.int/standards/XMLSchema/ST96/Design" exclude-result-prefixes="WIPO vmf xs fn com dgn">
	<xsl:output method="xml" encoding="UTF-8" byte-order-mark="no" indent="yes"/>
	<xsl:param name="st86model-V1-010" select="'st86model-V1-0.xml'"/>
	<xsl:param name="st86model-V1-011" select="'st86model-V1-0.xml'"/>
	<xsl:param name="st86model-V1-012" select="'st86model-V1-0.xml'"/>
	<xsl:param name="st86model-V1-013" select="'st86model-V1-0.xml'"/>
	<xsl:param name="st86model-V1-014" select="'st86model-V1-0.xml'"/>
	<xsl:param name="st86model-V1-015" select="'st86model-V1-0.xml'"/>
	<xsl:param name="st86model-V1-016" select="'st86model-V1-0.xml'"/>
	<xsl:param name="st86model-V1-017" select="'st86model-V1-0.xml'"/>
	<xsl:param name="st86model-V1-03" select="'st86model-V1-0.xml'"/>
	<xsl:param name="st86model-V1-04" select="'st86model-V1-0.xml'"/>
	<xsl:param name="st86model-V1-05" select="'st86model-V1-0.xml'"/>
	<xsl:param name="st86model-V1-06" select="'st86model-V1-0.xml'"/>
	<xsl:param name="st86model-V1-07" select="'st86model-V1-0.xml'"/>
	<xsl:param name="st86model-V1-08" select="'st86model-V1-0.xml'"/>
	<xsl:param name="st86model-V1-09" select="'st86model-V1-0.xml'"/>
	<xsl:template name="WIPO:ST86PublicationToST96Publication">
		<xsl:param name="Publication" select="()"/>
		<dgn:Publication>
			<xsl:for-each select="$Publication/dgn:PublicationIdentifier">
				<com:PublicationIdentifier xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="fn:string(.)"/>
				</com:PublicationIdentifier>
			</xsl:for-each>
			<xsl:for-each select="$Publication/dgn:PublicationSection">
				<xsl:variable name="var1_resultof_vmf__inputtoresult" as="xs:string?">
					<xsl:call-template name="vmf:vmf5_inputtoresult">
						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_vmf__inputtoresult">
					<PublicationSectionCategory>
						<xsl:sequence select="."/>
					</PublicationSectionCategory>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Publication/dgn:PublicationSubsection">
				<com:PublicationSubsection xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="fn:string(.)"/>
				</com:PublicationSubsection>
			</xsl:for-each>
			<xsl:for-each select="$Publication/dgn:PublicationDate">
				<com:PublicationDate xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</com:PublicationDate>
			</xsl:for-each>
			<xsl:for-each select="$Publication/dgn:PublicationPage">
				<com:PublicationPage xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="fn:string(.)"/>
				</com:PublicationPage>
			</xsl:for-each>
		</dgn:Publication>
	</xsl:template>
	<xsl:template name="WIPO:ST86DesignEventToST96DesignEvent">
		<xsl:param name="DesignEvent" select="()"/>
		<dgn:DesignEvent>
			<xsl:for-each select="$DesignEvent/dgn:DesignEventCode">
				<xsl:variable name="var1_resultof_vmf__inputtoresult" as="xs:string?">
					<xsl:call-template name="vmf:vmf6_inputtoresult">
						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_vmf__inputtoresult">
					<DesignEventCategory>
						<xsl:sequence select="."/>
					</DesignEventCategory>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$DesignEvent/dgn:DesignEventResponseDate">
				<DesignEventResponseDate>
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</DesignEventResponseDate>
			</xsl:for-each>
			<xsl:for-each select="$DesignEvent/dgn:Comment">
				<com:CommentText xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:for-each select="@languageCode">
						<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:sequence select="fn:string(.)"/>
				</com:CommentText>
			</xsl:for-each>
			<xsl:for-each select="$DesignEvent/dgn:DesignEventDate">
				<DesignEventDate>
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</DesignEventDate>
			</xsl:for-each>
			<xsl:for-each select="$DesignEvent/dgn:DesignEventDateTime">
				<DesignEventDateTime>
					<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
				</DesignEventDateTime>
			</xsl:for-each>
		</dgn:DesignEvent>
	</xsl:template>
	<xsl:template name="WIPO:ST86ApplicantToST96Applicant">
		<xsl:param name="Applicant" select="()"/>
		<dgn:Applicant>
			<xsl:for-each select="$Applicant/@operationCode">
				<xsl:variable name="var1_resultof_vmf__inputtoresult" as="xs:string?">
					<xsl:call-template name="vmf:vmf7_inputtoresult">
						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_vmf__inputtoresult">
					<xsl:attribute name="com:operationCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="."/>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Applicant/dgn:ApplicantSequenceNumber">
				<xsl:attribute name="com:sequenceNumber" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="xs:string(xs:integer(fn:string(.)))"/>
			</xsl:for-each>
			<xsl:for-each select="$Applicant/dgn:ApplicantNationalityCode">
				<com:NationalityCode xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="fn:string(.)"/>
				</com:NationalityCode>
			</xsl:for-each>
			<xsl:for-each select="$Applicant/dgn:ApplicantLegalEntity">
				<com:LegalEntityName xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="fn:string(.)"/>
				</com:LegalEntityName>
			</xsl:for-each>
			<xsl:for-each select="$Applicant/dgn:ApplicantIncorporationCountryCode">
				<com:IncorporationCountryCode xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="fn:string(.)"/>
				</com:IncorporationCountryCode>
			</xsl:for-each>
			<xsl:for-each select="$Applicant/dgn:ApplicantIncorporationState">
				<com:IncorporationState xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="fn:string(.)"/>
				</com:IncorporationState>
			</xsl:for-each>
			<xsl:for-each select="$Applicant/dgn:Comment">
				<com:CommentText xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:for-each select="@languageCode">
						<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:sequence select="fn:string(.)"/>
				</com:CommentText>
			</xsl:for-each>
			<xsl:for-each select="$Applicant/dgn:ApplicantEntitlement">
				<Entitlement>
					<xsl:for-each select="dgn:EntitlementNationalityCode">
						<com:EntitlementNationalityCode xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
							<xsl:sequence select="fn:string(.)"/>
						</com:EntitlementNationalityCode>
					</xsl:for-each>
					<xsl:for-each select="dgn:HabitualResidence">
						<HabitualResidence>
							<xsl:for-each select="dgn:HabitualResidenceCode">
								<HabitualResidenceCode>
									<xsl:sequence select="fn:string(.)"/>
								</HabitualResidenceCode>
							</xsl:for-each>
							<xsl:for-each select="dgn:HabitualResidenceAddressBook">
								<xsl:variable name="var2_resultof_ST__AddressbookToST__Contact" as="node()?">
									<xsl:call-template name="WIPO:ST86AddressbookToST96Contact">
										<xsl:with-param name="AddressBook" as="node()">
											<AddressBookType>
												<xsl:sequence select="(./@node(), ./node())"/>
											</AddressBookType>
										</xsl:with-param>
									</xsl:call-template>
								</xsl:variable>
								<xsl:for-each select="$var2_resultof_ST__AddressbookToST__Contact">
									<com:Contact xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
										<xsl:sequence select="(./@node(), ./node())"/>
									</com:Contact>
								</xsl:for-each>
							</xsl:for-each>
						</HabitualResidence>
					</xsl:for-each>
					<xsl:for-each select="dgn:EntitlementEstablishment">
						<com:EntitlementEstablishment xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
							<xsl:for-each select="dgn:EntitlementEstablishmentCode">
								<com:EntitlementEstablishmentCode>
									<xsl:sequence select="fn:string(.)"/>
								</com:EntitlementEstablishmentCode>
							</xsl:for-each>
						</com:EntitlementEstablishment>
					</xsl:for-each>
					<xsl:for-each select="dgn:EntitlementDomiciled">
						<com:EntitlementDomiciled xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
							<xsl:for-each select="dgn:EntitlementDomiciledCode">
								<com:EntitlementDomiciledCode>
									<xsl:sequence select="fn:string(.)"/>
								</com:EntitlementDomiciledCode>
							</xsl:for-each>
							<xsl:for-each select="dgn:EntitlementDomiciledAddressBook">
								<xsl:variable name="var3_resultof_ST__AddressbookToST__Contact" as="node()?">
									<xsl:call-template name="WIPO:ST86AddressbookToST96Contact">
										<xsl:with-param name="AddressBook" as="node()">
											<dgn:AddressBookType>
												<xsl:sequence select="(./@node(), ./node())"/>
											</dgn:AddressBookType>
										</xsl:with-param>
									</xsl:call-template>
								</xsl:variable>
								<xsl:for-each select="$var3_resultof_ST__AddressbookToST__Contact">
									<com:Contact>
										<xsl:sequence select="(./@node(), ./node())"/>
									</com:Contact>
								</xsl:for-each>
							</xsl:for-each>
						</com:EntitlementDomiciled>
					</xsl:for-each>
				</Entitlement>
			</xsl:for-each>
			<xsl:for-each select="$Applicant/dgn:ApplicantContractingParty">
				<ApplicantContractingParty>
					<xsl:sequence select="fn:string(.)"/>
				</ApplicantContractingParty>
			</xsl:for-each>
			<xsl:for-each select="$Applicant/dgn:ApplicantVersion">
				<com:Version xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:for-each select="dgn:Comment">
						<com:CommentText>
							<xsl:for-each select="@languageCode">
								<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:sequence select="fn:string(.)"/>
						</com:CommentText>
					</xsl:for-each>
					<xsl:for-each select="dgn:VersionNumber">
						<com:VersionNumber>
							<xsl:sequence select="fn:string(.)"/>
						</com:VersionNumber>
					</xsl:for-each>
					<xsl:for-each select="dgn:VersionDate">
						<com:VersionDate>
							<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
						</com:VersionDate>
					</xsl:for-each>
					<xsl:for-each select="dgn:VersionDateTime">
						<com:VersionDateTime>
							<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
						</com:VersionDateTime>
					</xsl:for-each>
				</com:Version>
			</xsl:for-each>
			<xsl:for-each select="$Applicant/dgn:ApplicantIdentifier">
				<com:PartyIdentifier xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="fn:string(.)"/>
				</com:PartyIdentifier>
			</xsl:for-each>
			<xsl:for-each select="$Applicant/dgn:ApplicantAddressBook">
				<xsl:variable name="var4_resultof_ST__AddressbookToST__Contact" as="node()?">
					<xsl:call-template name="WIPO:ST86AddressbookToST96Contact">
						<xsl:with-param name="AddressBook" as="node()">
							<dgn:AddressBookType>
								<xsl:sequence select="(./@node(), ./node())"/>
							</dgn:AddressBookType>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var4_resultof_ST__AddressbookToST__Contact">
					<com:Contact xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
						<xsl:sequence select="(./@node(), ./node())"/>
					</com:Contact>
				</xsl:for-each>
			</xsl:for-each>
		</dgn:Applicant>
	</xsl:template>
	<xsl:template name="WIPO:ST86RelatedApplicationToST96RelatedApplication">
		<xsl:param name="RelatedApplication" select="()"/>
		<dgn:RelatedApplication>
			<xsl:for-each select="$RelatedApplication/dgn:RelatedApplicationKind">
				<xsl:variable name="var1_resultof_vmf__inputtoresult" as="xs:string?">
					<xsl:call-template name="vmf:vmf8_inputtoresult">
						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_vmf__inputtoresult">
					<RelatedApplicationCategory>
						<xsl:sequence select="."/>
					</RelatedApplicationCategory>
				</xsl:for-each>
			</xsl:for-each>
			<RelatedApplicationNumber>
				<xsl:for-each select="$RelatedApplication/dgn:RelatedApplicationNumber">
					<com:ApplicationNumberText xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
						<xsl:sequence select="fn:string(.)"/>
					</com:ApplicationNumberText>
				</xsl:for-each>
			</RelatedApplicationNumber>
			<xsl:for-each select="$RelatedApplication/dgn:RelatedApplicationDate">
				<RelatedApplicationDate>
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</RelatedApplicationDate>
			</xsl:for-each>
			<xsl:for-each select="$RelatedApplication/dgn:RelatedApplicationReference">
				<RelatedApplicationReference>
					<xsl:sequence select="fn:string(.)"/>
				</RelatedApplicationReference>
			</xsl:for-each>
			<xsl:for-each select="$RelatedApplication/dgn:RelatedApplicationRegistrationNumber">
				<RelatedApplicationRegistrationNumber>
					<xsl:sequence select="fn:string(.)"/>
				</RelatedApplicationRegistrationNumber>
			</xsl:for-each>
		</dgn:RelatedApplication>
	</xsl:template>
	<xsl:template name="WIPO:ST86DesignerToST96Designer">
		<xsl:param name="Designer" select="()"/>
		<dgn:Designer>
			<xsl:for-each select="$Designer/@operationCode">
				<xsl:variable name="var1_resultof_vmf__inputtoresult" as="xs:string?">
					<xsl:call-template name="vmf:vmf9_inputtoresult">
						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_vmf__inputtoresult">
					<xsl:attribute name="com:operationCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="."/>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Designer/dgn:DesignerSequenceNumber">
				<xsl:attribute name="com:sequenceNumber" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="xs:string(xs:integer(fn:string(.)))"/>
			</xsl:for-each>
			<xsl:for-each select="$Designer/dgn:DesignerNationalityCode">
				<com:NationalityCode xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="fn:string(.)"/>
				</com:NationalityCode>
			</xsl:for-each>
			<xsl:for-each select="$Designer/dgn:Comment">
				<com:CommentText xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="fn:string(.)"/>
				</com:CommentText>
			</xsl:for-each>
			<xsl:for-each select="$Designer/dgn:DesignerIdentifier">
				<com:PartyIdentifier xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="fn:string(.)"/>
				</com:PartyIdentifier>
			</xsl:for-each>
			<xsl:for-each select="$Designer/dgn:DesignerAddressBook">
				<xsl:variable name="var2_resultof_ST__AddressbookToST__Contact" as="node()?">
					<xsl:call-template name="WIPO:ST86AddressbookToST96Contact">
						<xsl:with-param name="AddressBook" as="node()">
							<dgn:AddressBookType>
								<xsl:sequence select="(./@node(), ./node())"/>
							</dgn:AddressBookType>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_ST__AddressbookToST__Contact">
					<com:Contact xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
						<xsl:sequence select="(./@node(), ./node())"/>
					</com:Contact>
				</xsl:for-each>
			</xsl:for-each>
		</dgn:Designer>
	</xsl:template>
	<xsl:template name="WIPO:ST86RepresentativeToST96Representative">
		<xsl:param name="Representative" select="()"/>
		<com:Representative>
			<xsl:for-each select="$Representative/@operationCode">
				<xsl:variable name="var1_resultof_vmf___inputtoresult" as="xs:string?">
					<xsl:call-template name="vmf:vmf10_inputtoresult">
						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_vmf___inputtoresult">
					<xsl:attribute name="operationCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="."/>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Representative/dgn:RepresentativeSequenceNumber">
				<xsl:attribute name="sequenceNumber" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="xs:string(xs:integer(fn:string(.)))"/>
			</xsl:for-each>
			<xsl:for-each select="$Representative/dgn:RepresentativeLegalEntity">
				<LegalEntityName>
					<xsl:sequence select="fn:string(.)"/>
				</LegalEntityName>
			</xsl:for-each>
			<xsl:for-each select="$Representative/dgn:RepresentativeIdentifier">
				<PartyIdentifier>
					<xsl:sequence select="fn:string(.)"/>
				</PartyIdentifier>
			</xsl:for-each>
			<xsl:for-each select="$Representative/dgn:RepresentativeAddressBook">
				<xsl:variable name="var2_resultof_ST__AddressbookToST__Contact" as="node()?">
					<xsl:call-template name="WIPO:ST86AddressbookToST96Contact">
						<xsl:with-param name="AddressBook" as="node()">
							<dgn:AddressBookType>
								<xsl:sequence select="(./@node(), ./node())"/>
							</dgn:AddressBookType>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_ST__AddressbookToST__Contact">
					<Contact>
						<xsl:sequence select="(./@node(), ./node())"/>
					</Contact>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Representative/dgn:RepresentativeNationalityCode">
				<NationalityCode>
					<xsl:sequence select="fn:string(.)"/>
				</NationalityCode>
			</xsl:for-each>
			<xsl:for-each select="$Representative/dgn:RepresentativeIncorporationCountryCode">
				<IncorporationCountryCode>
					<xsl:sequence select="fn:string(.)"/>
				</IncorporationCountryCode>
			</xsl:for-each>
			<xsl:for-each select="$Representative/dgn:RepresentativeIncorporationState">
				<IncorporationState>
					<xsl:sequence select="fn:string(.)"/>
				</IncorporationState>
			</xsl:for-each>
			<xsl:for-each select="$Representative/dgn:RepresentativeKindCode">
				<xsl:variable name="var3_resultof_vmf___inputtoresult" as="xs:string?">
					<xsl:call-template name="vmf:vmf11_inputtoresult">
						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var3_resultof_vmf___inputtoresult">
					<RepresentativeCategory>
						<xsl:sequence select="."/>
					</RepresentativeCategory>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Representative/dgn:Comment">
				<CommentText>
					<xsl:for-each select="@languageCode">
						<xsl:attribute name="languageCode" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:sequence select="fn:string(.)"/>
				</CommentText>
			</xsl:for-each>
			<xsl:for-each select="$Representative/dgn:RepresentativeVersion">
				<Version>
					<xsl:for-each select="dgn:Comment">
						<CommentText>
							<xsl:for-each select="@languageCode">
								<xsl:attribute name="languageCode" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:sequence select="fn:string(.)"/>
						</CommentText>
					</xsl:for-each>
					<xsl:for-each select="dgn:VersionNumber">
						<VersionNumber>
							<xsl:sequence select="fn:string(.)"/>
						</VersionNumber>
					</xsl:for-each>
					<xsl:for-each select="dgn:VersionDate">
						<VersionDate>
							<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
						</VersionDate>
					</xsl:for-each>
					<xsl:for-each select="dgn:VersionDateTime">
						<VersionDateTime>
							<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
						</VersionDateTime>
					</xsl:for-each>
				</Version>
			</xsl:for-each>
		</com:Representative>
	</xsl:template>
	<xsl:template name="WIPO:ST86ExhibitionPriorityToST96ExhibitionPriority">
		<xsl:param name="ExhibitionPriority" select="()"/>
		<com:ExhibitionPriority>
			<xsl:for-each select="$ExhibitionPriority/dgn:ExhibitionCountryCode">
				<ExhibitionCountryCode>
					<xsl:sequence select="fn:string(.)"/>
				</ExhibitionCountryCode>
			</xsl:for-each>
			<xsl:for-each select="$ExhibitionPriority/dgn:ExhibitionCityName">
				<ExhibitionCityName>
					<xsl:sequence select="fn:string(.)"/>
				</ExhibitionCityName>
			</xsl:for-each>
			<xsl:for-each select="$ExhibitionPriority/dgn:ExhibitionName">
				<ExhibitionName>
					<xsl:sequence select="fn:string(.)"/>
				</ExhibitionName>
			</xsl:for-each>
			<xsl:for-each select="$ExhibitionPriority/dgn:ExhibitionDate">
				<ExhibitionDate>
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</ExhibitionDate>
			</xsl:for-each>
			<xsl:for-each select="$ExhibitionPriority/dgn:ExhibitionFirstDisplayDate">
				<ExhibitionFirstDisplayDate>
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</ExhibitionFirstDisplayDate>
			</xsl:for-each>
			<xsl:for-each select="$ExhibitionPriority/dgn:ExhibitionStatusCode">
				<xsl:variable name="var1_resultof_vmf___inputtoresult" as="xs:string?">
					<xsl:call-template name="vmf:vmf12_inputtoresult">
						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_vmf___inputtoresult">
					<ExhibitionStatusCategory>
						<xsl:sequence select="."/>
					</ExhibitionStatusCategory>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$ExhibitionPriority/dgn:ExhibitionStatusDate">
				<ExhibitionStatusDate>
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</ExhibitionStatusDate>
			</xsl:for-each>
			<xsl:for-each select="$ExhibitionPriority/dgn:Comment">
				<CommentText>
					<xsl:for-each select="@languageCode">
						<xsl:attribute name="languageCode" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:sequence select="fn:string(.)"/>
				</CommentText>
			</xsl:for-each>
			<xsl:for-each select="$ExhibitionPriority/dgn:ExhibitionDocument">
				<ExhibitionDocument>
					<xsl:for-each select="dgn:DocumentLanguageCode">
						<xsl:attribute name="languageCode" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:for-each select="dgn:DocumentName">
						<DocumentName>
							<xsl:sequence select="fn:string(.)"/>
						</DocumentName>
					</xsl:for-each>
					<xsl:for-each select="dgn:DocumentFilename">
						<FileName>
							<xsl:sequence select="fn:string(.)"/>
						</FileName>
					</xsl:for-each>
					<xsl:for-each select="dgn:DocumentFileFormat">
						<xsl:variable name="var2_resultof_vmf___inputtoresult" as="xs:string?">
							<xsl:call-template name="vmf:vmf13_inputtoresult">
								<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var2_resultof_vmf___inputtoresult">
							<DocumentFormatCategory>
								<xsl:sequence select="."/>
							</DocumentFormatCategory>
						</xsl:for-each>
					</xsl:for-each>
					<xsl:for-each select="dgn:DocumentDate">
						<DocumentDate>
							<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
						</DocumentDate>
					</xsl:for-each>
					<xsl:for-each select="dgn:DocumentMedia">
						<xsl:variable name="var3_resultof_vmf___inputtoresult" as="xs:string?">
							<xsl:call-template name="vmf:vmf14_inputtoresult">
								<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var3_resultof_vmf___inputtoresult">
							<DocumentMediaCategory>
								<xsl:sequence select="."/>
							</DocumentMediaCategory>
						</xsl:for-each>
					</xsl:for-each>
					<xsl:for-each select="dgn:DocumentLocation">
						<DocumentLocationURI>
							<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
						</DocumentLocationURI>
					</xsl:for-each>
					<xsl:for-each select="dgn:DocumentVersion">
						<DocumentVersion>
							<xsl:sequence select="fn:string(.)"/>
						</DocumentVersion>
					</xsl:for-each>
					<xsl:for-each select="dgn:DocumentSizeInByte">
						<DocumentSizeQuantity>
							<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
						</DocumentSizeQuantity>
					</xsl:for-each>
					<xsl:for-each select="dgn:Comment">
						<CommentText>
							<xsl:for-each select="@languageCode">
								<xsl:attribute name="languageCode" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:sequence select="fn:string(.)"/>
						</CommentText>
					</xsl:for-each>
				</ExhibitionDocument>
			</xsl:for-each>
		</com:ExhibitionPriority>
	</xsl:template>
	<xsl:template name="WIPO:ST86PriorityToST96Priority">
		<xsl:param name="Priority" select="()"/>
		<dgn:Priority>
			<xsl:for-each select="$Priority/dgn:PriorityCountryCode">
				<com:PriorityCountryCode xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="fn:string(.)"/>
				</com:PriorityCountryCode>
			</xsl:for-each>
			<com:ApplicationNumber xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
				<xsl:for-each select="$Priority/dgn:PriorityNumber">
					<com:ApplicationNumberText>
						<xsl:sequence select="fn:string(.)"/>
					</com:ApplicationNumberText>
				</xsl:for-each>
			</com:ApplicationNumber>
			<xsl:for-each select="$Priority/dgn:PriorityDate">
				<com:PriorityApplicationFilingDate xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</com:PriorityApplicationFilingDate>
			</xsl:for-each>
			<xsl:for-each select="$Priority/dgn:PriorityHolderName">
				<com:PriorityHolderName xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="fn:string(.)"/>
				</com:PriorityHolderName>
			</xsl:for-each>
			<xsl:for-each select="$Priority/dgn:PriorityStatusCode">
				<xsl:variable name="var1_resultof_vmf___inputtoresult" as="xs:string?">
					<xsl:call-template name="vmf:vmf15_inputtoresult">
						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_vmf___inputtoresult">
					<com:PriorityStatusCategory xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
						<xsl:sequence select="."/>
					</com:PriorityStatusCategory>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Priority/dgn:PriorityStatusDate">
				<com:PriorityStatusDate xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</com:PriorityStatusDate>
			</xsl:for-each>
			<xsl:for-each select="$Priority/dgn:Comment">
				<com:CommentText xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:for-each select="@languageCode">
						<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:sequence select="fn:string(.)"/>
				</com:CommentText>
			</xsl:for-each>
			<xsl:for-each select="$Priority/dgn:PriorityDocument">
				<com:PriorityDocument xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:for-each select="dgn:DocumentLanguageCode">
						<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:for-each select="dgn:DocumentName">
						<com:DocumentName>
							<xsl:sequence select="fn:string(.)"/>
						</com:DocumentName>
					</xsl:for-each>
					<xsl:for-each select="dgn:DocumentFilename">
						<com:FileName>
							<xsl:sequence select="fn:string(.)"/>
						</com:FileName>
					</xsl:for-each>
					<xsl:for-each select="dgn:DocumentFileFormat">
						<xsl:variable name="var2_resultof_vmf___inputtoresult" as="xs:string?">
							<xsl:call-template name="vmf:vmf13_inputtoresult">
								<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var2_resultof_vmf___inputtoresult">
							<com:DocumentFormatCategory>
								<xsl:sequence select="."/>
							</com:DocumentFormatCategory>
						</xsl:for-each>
					</xsl:for-each>
					<xsl:for-each select="dgn:DocumentDate">
						<com:DocumentDate>
							<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
						</com:DocumentDate>
					</xsl:for-each>
					<xsl:for-each select="dgn:DocumentMedia">
						<xsl:variable name="var3_resultof_vmf___inputtoresult" as="xs:string?">
							<xsl:call-template name="vmf:vmf14_inputtoresult">
								<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var3_resultof_vmf___inputtoresult">
							<com:DocumentMediaCategory>
								<xsl:sequence select="."/>
							</com:DocumentMediaCategory>
						</xsl:for-each>
					</xsl:for-each>
					<xsl:for-each select="dgn:DocumentLocation">
						<com:DocumentLocationURI>
							<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
						</com:DocumentLocationURI>
					</xsl:for-each>
					<xsl:for-each select="dgn:DocumentVersion">
						<com:DocumentVersion>
							<xsl:sequence select="fn:string(.)"/>
						</com:DocumentVersion>
					</xsl:for-each>
					<xsl:for-each select="dgn:DocumentSizeInByte">
						<com:DocumentSizeQuantity>
							<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
						</com:DocumentSizeQuantity>
					</xsl:for-each>
					<xsl:for-each select="dgn:Comment">
						<com:CommentText>
							<xsl:for-each select="@languageCode">
								<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:sequence select="fn:string(.)"/>
						</com:CommentText>
					</xsl:for-each>
				</com:PriorityDocument>
			</xsl:for-each>
		</dgn:Priority>
	</xsl:template>
	<xsl:template name="WIPO:ST86DesignSpecimenToST96DesignSpecimen">
		<xsl:param name="DesignSpecimen" select="()"/>
		<dgn:DesignSpecimen>
			<xsl:for-each select="$DesignSpecimen/dgn:SpecimenIdentifier">
				<SpecimenIdentifier>
					<xsl:sequence select="fn:string(.)"/>
				</SpecimenIdentifier>
			</xsl:for-each>
			<xsl:for-each select="$DesignSpecimen/dgn:SpecimenKind">
				<xsl:variable name="var1_resultof_vmf___inputtoresult" as="xs:string?">
					<xsl:call-template name="vmf:vmf16_inputtoresult">
						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_vmf___inputtoresult">
					<DesignSpecimenCategory>
						<xsl:sequence select="."/>
					</DesignSpecimenCategory>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$DesignSpecimen/dgn:SpecimenDescription">
				<SpecimenDescriptionText>
					<xsl:for-each select="@languageCode">
						<xsl:attribute name="com:languageCode" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:sequence select="fn:string(.)"/>
				</SpecimenDescriptionText>
			</xsl:for-each>
			<xsl:for-each select="$DesignSpecimen/dgn:SpecimenFilename">
				<com:FileName xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="fn:string(.)"/>
				</com:FileName>
			</xsl:for-each>
			<xsl:for-each select="$DesignSpecimen/dgn:SpecimenFileFormat">
				<xsl:variable name="var2_resultof_vmf___inputtoresult" as="xs:string?">
					<xsl:call-template name="vmf:vmf17_inputtoresult">
						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_vmf___inputtoresult">
					<com:ImageFormatCategory xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
						<xsl:sequence select="."/>
					</com:ImageFormatCategory>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$DesignSpecimen/dgn:SpecimenColourIndicator">
				<com:ColourIndicator xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
				</com:ColourIndicator>
			</xsl:for-each>
			<xsl:for-each select="$DesignSpecimen/dgn:Comment">
				<com:CommentText xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:for-each select="@languageCode">
						<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:sequence select="fn:string(.)"/>
				</com:CommentText>
			</xsl:for-each>
		</dgn:DesignSpecimen>
	</xsl:template>
	<xsl:template name="WIPO:ST86OppositionEventToST96OppositionEvent">
		<xsl:param name="OppositionEvent" select="()"/>
		<dgn:OppositionEvent>
			<xsl:for-each select="$OppositionEvent/dgn:OppositionEventCode">
				<xsl:variable name="var1_resultof_vmf___inputtoresult" as="xs:string?">
					<xsl:call-template name="vmf:vmf18_inputtoresult">
						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_vmf___inputtoresult">
					<OppositionEventCategory>
						<xsl:sequence select="."/>
					</OppositionEventCategory>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$OppositionEvent/dgn:OppositionEventResponseDate">
				<com:OppositionEventResponseDate xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</com:OppositionEventResponseDate>
			</xsl:for-each>
			<xsl:for-each select="$OppositionEvent/dgn:Comment">
				<com:CommentText xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:for-each select="@languageCode">
						<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:sequence select="fn:string(.)"/>
				</com:CommentText>
			</xsl:for-each>
			<xsl:for-each select="$OppositionEvent/dgn:OppositionEventDate">
				<com:OppositionEventDate xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</com:OppositionEventDate>
			</xsl:for-each>
			<xsl:for-each select="$OppositionEvent/dgn:OppositionEventDateTime">
				<com:OppositionEventDateTime xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
				</com:OppositionEventDateTime>
			</xsl:for-each>
		</dgn:OppositionEvent>
	</xsl:template>
	<xsl:template name="WIPO:ST86AddressbookToST96Contact">
		<xsl:param name="AddressBook" select="()"/>
		<xsl:variable name="var6_FormattedNameAddress" as="node()*" select="$AddressBook/dgn:FormattedNameAddress"/>
		<xsl:variable name="var7_ContactInformationDetails" as="node()*" select="$AddressBook/dgn:ContactInformationDetails"/>
		<com:Contact>
			<xsl:for-each select="$AddressBook/dgn:AddressLanguageCode">
				<xsl:attribute name="languageCode" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="fn:string(.)"/>
			</xsl:for-each>
			<com:Name>
				<xsl:for-each select="($var6_FormattedNameAddress/dgn:Name/dgn:FormattedName)[fn:exists(dgn:LastName)]">
					<com:PersonName>
						<com:PersonStructuredName>
							<xsl:for-each select="dgn:NamePrefix">
								<com:NamePrefix>
									<xsl:sequence select="fn:string(.)"/>
								</com:NamePrefix>
							</xsl:for-each>
							<xsl:for-each select="dgn:FirstName">
								<com:FirstName>
									<xsl:sequence select="fn:string(.)"/>
								</com:FirstName>
							</xsl:for-each>
							<xsl:for-each select="dgn:MiddleName">
								<com:LastName>
									<xsl:sequence select="fn:string(.)"/>
								</com:LastName>
							</xsl:for-each>
							<xsl:for-each select="dgn:SecondLastName">
								<com:SecondLastName>
									<xsl:sequence select="fn:string(.)"/>
								</com:SecondLastName>
							</xsl:for-each>
							<xsl:for-each select="dgn:NameSuffix">
								<NameSuffix>
									<xsl:sequence select="fn:string(.)"/>
								</NameSuffix>
							</xsl:for-each>
							<xsl:for-each select="dgn:NameSynonym">
								<com:PersonOtherName>
									<xsl:sequence select="fn:string(.)"/>
								</com:PersonOtherName>
							</xsl:for-each>
						</com:PersonStructuredName>
					</com:PersonName>
				</xsl:for-each>
				<xsl:for-each select="$var6_FormattedNameAddress/dgn:Name/dgn:FormattedName">
					<xsl:variable name="var2_cur" as="node()" select="."/>
					<xsl:for-each select="dgn:OrganizationName">
						<xsl:variable name="var1_cur_as_string" as="xs:string" select="fn:string(.)"/>
						<com:OrganizationName>
							<xsl:attribute name="languageCode" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="$var1_cur_as_string"/>
							<OrganizationStandardName>
								<xsl:sequence select="$var1_cur_as_string"/>
							</OrganizationStandardName>
							<xsl:for-each select="$var2_cur/dgn:OrganizationDepartment">
								<OrganizationOtherName>
									<xsl:attribute name="organizationNameCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'Department'"/>
									<xsl:sequence select="fn:string(.)"/>
								</OrganizationOtherName>
							</xsl:for-each>
						</com:OrganizationName>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:for-each select="$var6_FormattedNameAddress/dgn:Name/dgn:FreeFormatName">
					<xsl:variable name="var3_cur" as="node()" select="."/>
					<xsl:for-each select="(./dgn:FreeFormatNameDetails/dgn:FreeFormatNameLine)[fn:not(fn:exists($var3_cur/dgn:NameKind))]">
						<com:EntityName>
							<xsl:for-each select="@languageCode">
								<xsl:attribute name="languageCode" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:sequence select="fn:string(.)"/>
						</com:EntityName>
					</xsl:for-each>
				</xsl:for-each>
			</com:Name>
			<com:PostalAddressBag>
				<xsl:for-each select="$var6_FormattedNameAddress/dgn:Address">
					<xsl:variable name="var4_cur" as="node()" select="."/>
					<com:PostalAddress>
						<xsl:for-each select="dgn:FormattedAddress">
							<com:PostalStructuredAddress>
								<xsl:for-each select="$var4_cur/dgn:FreeFormatAddress/dgn:FreeFormatAddressLine">
									<com:AddressLineText>
										<xsl:for-each select="@sequenceNumber">
											<xsl:attribute name="sequenceNumber" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="xs:string(xs:integer(fn:string(.)))"/>
										</xsl:for-each>
										<xsl:sequence select="fn:string(.)"/>
									</com:AddressLineText>
								</xsl:for-each>
								<xsl:for-each select="dgn:AddressRoom">
									<com:AddressLineText>
										<xsl:attribute name="addressLineCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'Room'"/>
										<xsl:sequence select="fn:string(.)"/>
									</com:AddressLineText>
								</xsl:for-each>
								<xsl:for-each select="dgn:AddressFloor">
									<com:AddressLineText>
										<xsl:attribute name="addressLineCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'Floor'"/>
										<xsl:sequence select="fn:string(.)"/>
									</com:AddressLineText>
								</xsl:for-each>
								<xsl:for-each select="dgn:AddressBuilding">
									<com:AddressLineText>
										<xsl:attribute name="addressLineCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'Building'"/>
										<xsl:sequence select="fn:string(.)"/>
									</com:AddressLineText>
								</xsl:for-each>
								<xsl:for-each select="dgn:AddressStreet">
									<com:AddressLineText>
										<xsl:attribute name="addressLineCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'Street'"/>
										<xsl:sequence select="fn:string(.)"/>
									</com:AddressLineText>
								</xsl:for-each>
								<xsl:for-each select="dgn:AddressLine">
									<com:AddressLineText>
										<xsl:for-each select="@sequenceNumber">
											<xsl:attribute name="sequenceNumber" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="xs:string(xs:integer(fn:string(.)))"/>
										</xsl:for-each>
										<xsl:sequence select="fn:string(.)"/>
									</com:AddressLineText>
								</xsl:for-each>
								<xsl:for-each select="dgn:AddressCity">
									<com:CityName>
										<xsl:sequence select="fn:string(.)"/>
									</com:CityName>
								</xsl:for-each>
								<xsl:for-each select="dgn:AddressCounty">
									<com:GeographicRegionName>
										<xsl:attribute name="geographicRegionCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'County'"/>
										<xsl:sequence select="fn:string(.)"/>
									</com:GeographicRegionName>
								</xsl:for-each>
								<xsl:for-each select="dgn:AddressState">
									<com:GeographicRegionName>
										<xsl:attribute name="geographicRegionCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'State'"/>
										<xsl:sequence select="fn:string(.)"/>
									</com:GeographicRegionName>
								</xsl:for-each>
								<xsl:for-each select="dgn:FormattedAddressCountryCode">
									<com:CountryCode>
										<xsl:sequence select="fn:string(.)"/>
									</com:CountryCode>
								</xsl:for-each>
								<xsl:for-each select="dgn:AddressPostcode">
									<com:PostalCode>
										<xsl:sequence select="fn:string(.)"/>
									</com:PostalCode>
								</xsl:for-each>
								<xsl:for-each select="dgn:AddressMailCode">
									<com:PostalCode>
										<xsl:sequence select="fn:string(.)"/>
									</com:PostalCode>
								</xsl:for-each>
							</com:PostalStructuredAddress>
						</xsl:for-each>
						<xsl:for-each select="$AddressBook/dgn:PostalAddress">
							<com:PostalAddressText>
								<xsl:sequence select="fn:string(.)"/>
							</com:PostalAddressText>
						</xsl:for-each>
					</com:PostalAddress>
				</xsl:for-each>
			</com:PostalAddressBag>
			<com:FaxNumberBag>
				<xsl:for-each select="$var7_ContactInformationDetails/dgn:Fax">
					<com:FaxNumber>
						<xsl:sequence select="fn:string(.)"/>
					</com:FaxNumber>
				</xsl:for-each>
			</com:FaxNumberBag>
			<com:EmailAddressBag>
				<xsl:for-each select="$var7_ContactInformationDetails/dgn:Email">
					<com:EmailAddressText>
						<xsl:sequence select="fn:string(.)"/>
					</com:EmailAddressText>
				</xsl:for-each>
			</com:EmailAddressBag>
			<com:WebAddressBag>
				<xsl:for-each select="$var7_ContactInformationDetails/dgn:URL">
					<com:WebAddressURI>
						<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
					</com:WebAddressURI>
				</xsl:for-each>
			</com:WebAddressBag>
			<com:PhoneNumberBag>
				<xsl:for-each select="$var7_ContactInformationDetails/dgn:Phone">
					<com:PhoneNumber>
						<xsl:for-each select="@phoneKind">
							<xsl:variable name="var5_resultof_vmf___inputtoresult" as="xs:string?">
								<xsl:call-template name="vmf:vmf19_inputtoresult">
									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
								</xsl:call-template>
							</xsl:variable>
							<xsl:for-each select="$var5_resultof_vmf___inputtoresult">
								<xsl:attribute name="phoneNumberCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="."/>
							</xsl:for-each>
						</xsl:for-each>
						<xsl:sequence select="fn:string(.)"/>
					</com:PhoneNumber>
				</xsl:for-each>
			</com:PhoneNumberBag>
			<com:OtherElectronicAddressBag>
				<xsl:for-each select="$var7_ContactInformationDetails/dgn:OtherElectronicAddress">
					<com:OtherElectronicAddressText>
						<xsl:sequence select="fn:string(.)"/>
					</com:OtherElectronicAddressText>
				</xsl:for-each>
			</com:OtherElectronicAddressBag>
		</com:Contact>
	</xsl:template>
	<xsl:template name="WIPO:ST86OpponentToST96Opponent">
		<xsl:param name="Opponent" select="()"/>
		<dgn:Opponent>
			<xsl:for-each select="$Opponent/dgn:OpponentNationalityCode">
				<com:NationalityCode xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="fn:string(.)"/>
				</com:NationalityCode>
			</xsl:for-each>
			<xsl:for-each select="$Opponent/dgn:OpponentLegalEntity">
				<com:LegalEntityName xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="fn:string(.)"/>
				</com:LegalEntityName>
			</xsl:for-each>
			<xsl:for-each select="$Opponent/dgn:OpponentIncorporationCountryCode">
				<com:IncorporationCountryCode xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="fn:string(.)"/>
				</com:IncorporationCountryCode>
			</xsl:for-each>
			<xsl:for-each select="$Opponent/dgn:OpponentIncorporationState">
				<com:IncorporationState xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="fn:string(.)"/>
				</com:IncorporationState>
			</xsl:for-each>
			<xsl:for-each select="$Opponent/dgn:Comment">
				<com:CommentText xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:for-each select="@languageCode">
						<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:sequence select="fn:string(.)"/>
				</com:CommentText>
			</xsl:for-each>
			<xsl:for-each select="$Opponent/dgn:OpponentEntitlement">
				<Entitlement>
					<xsl:for-each select="dgn:EntitlementNationalityCode">
						<com:EntitlementNationalityCode xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
							<xsl:sequence select="fn:string(.)"/>
						</com:EntitlementNationalityCode>
					</xsl:for-each>
					<xsl:for-each select="dgn:HabitualResidence">
						<HabitualResidence>
							<xsl:for-each select="dgn:HabitualResidenceCode">
								<HabitualResidenceCode>
									<xsl:sequence select="fn:string(.)"/>
								</HabitualResidenceCode>
							</xsl:for-each>
							<xsl:for-each select="dgn:HabitualResidenceAddressBook">
								<xsl:variable name="var1_resultof_ST__AddressbookToST__Contact" as="node()?">
									<xsl:call-template name="WIPO:ST86AddressbookToST96Contact">
										<xsl:with-param name="AddressBook" as="node()">
											<dgn:AddressBookType>
												<xsl:sequence select="(./@node(), ./node())"/>
											</dgn:AddressBookType>
										</xsl:with-param>
									</xsl:call-template>
								</xsl:variable>
								<xsl:for-each select="$var1_resultof_ST__AddressbookToST__Contact">
									<com:Contact xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
										<xsl:sequence select="(./@node(), ./node())"/>
									</com:Contact>
								</xsl:for-each>
							</xsl:for-each>
						</HabitualResidence>
					</xsl:for-each>
					<xsl:for-each select="dgn:EntitlementEstablishment">
						<com:EntitlementEstablishment xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
							<xsl:for-each select="dgn:EntitlementEstablishmentCode">
								<com:EntitlementEstablishmentCode>
									<xsl:sequence select="fn:string(.)"/>
								</com:EntitlementEstablishmentCode>
							</xsl:for-each>
							<xsl:for-each select="dgn:EntitlementEstablishmentAddressBook">
								<xsl:variable name="var2_resultof_ST__AddressbookToST__Contact" as="node()?">
									<xsl:call-template name="WIPO:ST86AddressbookToST96Contact">
										<xsl:with-param name="AddressBook" as="node()">
											<dgn:AddressBookType>
												<xsl:sequence select="(./@node(), ./node())"/>
											</dgn:AddressBookType>
										</xsl:with-param>
									</xsl:call-template>
								</xsl:variable>
								<xsl:for-each select="$var2_resultof_ST__AddressbookToST__Contact">
									<com:Contact>
										<xsl:sequence select="(./@node(), ./node())"/>
									</com:Contact>
								</xsl:for-each>
							</xsl:for-each>
						</com:EntitlementEstablishment>
					</xsl:for-each>
					<xsl:for-each select="dgn:EntitlementDomiciled">
						<com:EntitlementDomiciled xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
							<xsl:for-each select="dgn:EntitlementDomiciledCode">
								<com:EntitlementDomiciledCode>
									<xsl:sequence select="fn:string(.)"/>
								</com:EntitlementDomiciledCode>
							</xsl:for-each>
							<xsl:for-each select="dgn:EntitlementDomiciledAddressBook">
								<xsl:variable name="var3_resultof_ST__AddressbookToST__Contact" as="node()?">
									<xsl:call-template name="WIPO:ST86AddressbookToST96Contact">
										<xsl:with-param name="AddressBook" as="node()">
											<dgn:AddressBookType>
												<xsl:sequence select="(./@node(), ./node())"/>
											</dgn:AddressBookType>
										</xsl:with-param>
									</xsl:call-template>
								</xsl:variable>
								<xsl:for-each select="$var3_resultof_ST__AddressbookToST__Contact">
									<com:Contact>
										<xsl:sequence select="(./@node(), ./node())"/>
									</com:Contact>
								</xsl:for-each>
							</xsl:for-each>
						</com:EntitlementDomiciled>
					</xsl:for-each>
				</Entitlement>
			</xsl:for-each>
			<xsl:for-each select="$Opponent/dgn:OpponentIdentifier">
				<com:PartyIdentifier xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="fn:string(.)"/>
				</com:PartyIdentifier>
			</xsl:for-each>
			<xsl:for-each select="$Opponent/dgn:OpponentAddressBook">
				<xsl:variable name="var4_resultof_ST__AddressbookToST__Contact" as="node()?">
					<xsl:call-template name="WIPO:ST86AddressbookToST96Contact">
						<xsl:with-param name="AddressBook" as="node()">
							<dgn:AddressBookType>
								<xsl:sequence select="(./@node(), ./node())"/>
							</dgn:AddressBookType>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var4_resultof_ST__AddressbookToST__Contact">
					<com:Contact xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
						<xsl:sequence select="(./@node(), ./node())"/>
					</com:Contact>
				</xsl:for-each>
			</xsl:for-each>
		</dgn:Opponent>
	</xsl:template>
	<xsl:template name="WIPO:ST86DesignRepresentationSheetToST96DesignRepresentationSheet">
		<xsl:param name="DesignRepresentationSheet" select="()"/>
		<dgn:DesignRepresentation>
			<dgn:DesignRepresentationSheetBag>
				<dgn:DesignRepresentationSheet>
					<xsl:for-each select="$DesignRepresentationSheet/dgn:RepresentationSheetFilename">
						<com:FileName xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
							<xsl:sequence select="fn:string(.)"/>
						</com:FileName>
					</xsl:for-each>
					<xsl:for-each select="$DesignRepresentationSheet/dgn:RepresentationSheetFileFormat">
						<xsl:variable name="var1_resultof_vmf___inputtoresult" as="xs:string?">
							<xsl:call-template name="vmf:vmf20_inputtoresult">
								<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var1_resultof_vmf___inputtoresult">
							<com:ImageFormatCategory xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
								<xsl:sequence select="."/>
							</com:ImageFormatCategory>
						</xsl:for-each>
					</xsl:for-each>
					<xsl:for-each select="$DesignRepresentationSheet/dgn:RepresentationSheetColourIndicator">
						<com:ColourIndicator xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
							<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
						</com:ColourIndicator>
					</xsl:for-each>
				</dgn:DesignRepresentationSheet>
			</dgn:DesignRepresentationSheetBag>
			<xsl:for-each select="$DesignRepresentationSheet/dgn:ViewDetails">
				<ViewBag>
					<xsl:for-each select="dgn:View">
						<xsl:variable name="var2_ViewRepresentationSize" as="node()*" select="dgn:ViewRepresentationSize"/>
						<View>
							<xsl:for-each select="dgn:ViewFilename">
								<com:FileName xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="fn:string(.)"/>
								</com:FileName>
							</xsl:for-each>
							<xsl:for-each select="dgn:ViewFileFormat">
								<ViewFileFormatCategory>
									<xsl:sequence select="fn:string(.)"/>
								</ViewFileFormatCategory>
							</xsl:for-each>
							<xsl:for-each select="dgn:ViewTitle">
								<com:Caption xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="fn:string(.)"/>
								</com:Caption>
							</xsl:for-each>
							<xsl:for-each select="dgn:ViewColourIndicator">
								<com:ColourIndicator xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
								</com:ColourIndicator>
							</xsl:for-each>
							<xsl:for-each select="dgn:ViewKind">
								<RepresentationFormCategory>
									<xsl:sequence select="fn:string(.)"/>
								</RepresentationFormCategory>
							</xsl:for-each>
							<xsl:for-each select="dgn:ViewCategory">
								<ViewClassification>
									<com:FigurativeElementClassificationBag xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
										<com:NationalFigurativeElementClassificationBag>
											<xsl:for-each select="dgn:CategoryVersion">
												<com:NationalClassificationEdition>
													<xsl:sequence select="fn:string(.)"/>
												</com:NationalClassificationEdition>
											</xsl:for-each>
											<xsl:for-each select="dgn:CategoryCodeDetails/dgn:CategoryCode">
												<com:NationalFigurativeElementClassification>
													<xsl:sequence select="fn:string(.)"/>
												</com:NationalFigurativeElementClassification>
											</xsl:for-each>
										</com:NationalFigurativeElementClassificationBag>
									</com:FigurativeElementClassificationBag>
								</ViewClassification>
							</xsl:for-each>
							<xsl:for-each select="$var2_ViewRepresentationSize/dgn:Height">
								<com:HeightMeasure xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
								</com:HeightMeasure>
							</xsl:for-each>
							<xsl:for-each select="$var2_ViewRepresentationSize/dgn:Width">
								<com:WidthMeasure xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
									<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
								</com:WidthMeasure>
							</xsl:for-each>
						</View>
					</xsl:for-each>
				</ViewBag>
			</xsl:for-each>
		</dgn:DesignRepresentation>
	</xsl:template>
	<xsl:template name="WIPO:ST86EarlierDesignToST96EarlierDesign">
		<xsl:param name="EarlierDesign" select="()"/>
		<dgn:EarlierDesign>
			<xsl:for-each select="$EarlierDesign/dgn:DesignApplicationDate">
				<com:ApplicationDate xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</com:ApplicationDate>
			</xsl:for-each>
			<dgn:DesignRepresentationBag>
				<xsl:for-each select="$EarlierDesign/dgn:DesignRepresentationSheetDetails/dgn:DesignRepresentationSheet">
					<xsl:variable name="var1_resultof_ST__DesignRepresentationSheetToST__DesignRepresentationSheet" as="node()?">
						<xsl:call-template name="WIPO:ST86DesignRepresentationSheetToST96DesignRepresentationSheet">
							<xsl:with-param name="DesignRepresentationSheet" as="node()">
								<dgn:DesignRepresentationSheetType>
									<xsl:sequence select="(./@node(), ./node())"/>
								</dgn:DesignRepresentationSheetType>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:for-each select="$var1_resultof_ST__DesignRepresentationSheetToST__DesignRepresentationSheet">
						<dgn:DesignRepresentation>
							<xsl:for-each select="dgn:DesignRepresentationSheetBag">
								<dgn:DesignRepresentationSheetBag>
									<xsl:sequence select="()"/>
								</dgn:DesignRepresentationSheetBag>
							</xsl:for-each>
						</dgn:DesignRepresentation>
					</xsl:for-each>
				</xsl:for-each>
			</dgn:DesignRepresentationBag>
			<xsl:for-each select="$EarlierDesign/dgn:DesignApplicationIdentifier">
				<dgn:DesignApplicationIdentifier>
					<xsl:sequence select="fn:string(.)"/>
				</dgn:DesignApplicationIdentifier>
			</xsl:for-each>
			<xsl:for-each select="$EarlierDesign/dgn:DesignRegistrationIdentifier">
				<dgn:DesignRegistrationIdentifier>
					<xsl:sequence select="fn:string(.)"/>
				</dgn:DesignRegistrationIdentifier>
			</xsl:for-each>
			<xsl:for-each select="$EarlierDesign/dgn:DesignRegistrationDate">
				<dgn:DesignRegistrationDate>
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</dgn:DesignRegistrationDate>
			</xsl:for-each>
			<xsl:for-each select="$EarlierDesign/dgn:EarlierDesignCountryCode">
				<dgn:EarlierDesignCountryCode>
					<xsl:sequence select="fn:string(.)"/>
				</dgn:EarlierDesignCountryCode>
			</xsl:for-each>
			<xsl:for-each select="$EarlierDesign/dgn:EarlierDesignKind">
				<xsl:variable name="var2_resultof_vmf___inputtoresult" as="xs:string?">
					<xsl:call-template name="vmf:vmf21_inputtoresult">
						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_vmf___inputtoresult">
					<dgn:EarlierDesignCategory>
						<xsl:sequence select="."/>
					</dgn:EarlierDesignCategory>
				</xsl:for-each>
			</xsl:for-each>
		</dgn:EarlierDesign>
	</xsl:template>
	<xsl:template name="WIPO:ST86OppositionToST96Opposition">
		<xsl:param name="Opposition" select="()"/>
		<dgn:Opposition>
			<xsl:for-each select="$Opposition/dgn:OppositionIdentifier">
				<com:OppositionIdentifier xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="fn:string(.)"/>
				</com:OppositionIdentifier>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/dgn:OppositionDate">
				<com:OppositionDate xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</com:OppositionDate>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/dgn:OppositionReference">
				<com:OppositionReference xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="fn:string(.)"/>
				</com:OppositionReference>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/dgn:OppositionLanguageCode">
				<com:OppositionLanguageCode xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="fn:string(.)"/>
				</com:OppositionLanguageCode>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/dgn:ProceedingLanguageCode">
				<com:ProceedingLanguageCode xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="fn:string(.)"/>
				</com:ProceedingLanguageCode>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/dgn:EarlierRightDate">
				<com:EarlierRightDate xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</com:EarlierRightDate>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/dgn:EarlierRightKind">
				<xsl:variable name="var1_resultof_vmf___inputtoresult" as="xs:string?">
					<xsl:call-template name="vmf:vmf22_inputtoresult">
						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var1_resultof_vmf___inputtoresult">
					<com:EarlierRightCategory xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
						<xsl:sequence select="."/>
					</com:EarlierRightCategory>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/dgn:OppositionBasisCode">
				<xsl:variable name="var2_resultof_vmf___inputtoresult" as="xs:string?">
					<xsl:call-template name="vmf:vmf23_inputtoresult">
						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var2_resultof_vmf___inputtoresult">
					<OppositionBasisCategory>
						<xsl:sequence select="."/>
					</OppositionBasisCategory>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/dgn:OppositionGroundText">
				<com:OppositionGroundsText xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:for-each select="@languageCode">
						<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:sequence select="fn:string(.)"/>
				</com:OppositionGroundsText>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/dgn:OppositionExtentText">
				<com:OppositionExtentText xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:for-each select="@languageCode">
						<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
					</xsl:for-each>
					<xsl:sequence select="fn:string(.)"/>
				</com:OppositionExtentText>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/dgn:OppositionCurrentStatusCode">
				<xsl:variable name="var3_resultof_vmf___inputtoresult" as="xs:string?">
					<xsl:call-template name="vmf:vmf24_inputtoresult">
						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var3_resultof_vmf___inputtoresult">
					<OppositionCurrentStatusCategory>
						<xsl:sequence select="."/>
					</OppositionCurrentStatusCategory>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/dgn:OppositionCurrentStatusDate">
				<com:OppositionCurrentStatusDate xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</com:OppositionCurrentStatusDate>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/dgn:EarlierDesignDetails">
				<EarlierDesignBag>
					<xsl:for-each select="dgn:EarlierDesign">
						<xsl:variable name="var4_resultof_ST__EarlierDesignToST__EarlierDesign" as="node()?">
							<xsl:call-template name="WIPO:ST86EarlierDesignToST96EarlierDesign">
								<xsl:with-param name="EarlierDesign" as="node()">
									<dgn:EarlierDesignType>
										<xsl:sequence select="(./@node(), ./node())"/>
									</dgn:EarlierDesignType>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var4_resultof_ST__EarlierDesignToST__EarlierDesign">
							<dgn:EarlierDesign>
								<xsl:sequence select="(./@node(), ./node())"/>
							</dgn:EarlierDesign>
						</xsl:for-each>
					</xsl:for-each>
				</EarlierDesignBag>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/dgn:OpponentDetails">
				<dgn:OpponentBag>
					<xsl:for-each select="dgn:Opponent">
						<xsl:variable name="var5_resultof_ST__OpponentToST__Opponent" as="node()?">
							<xsl:call-template name="WIPO:ST86OpponentToST96Opponent">
								<xsl:with-param name="Opponent" as="node()">
									<dgn:OpponentType>
										<xsl:sequence select="(./@node(), ./node())"/>
									</dgn:OpponentType>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var5_resultof_ST__OpponentToST__Opponent">
							<dgn:Opponent>
								<xsl:sequence select="(./@node(), ./node())"/>
							</dgn:Opponent>
						</xsl:for-each>
					</xsl:for-each>
				</dgn:OpponentBag>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/dgn:OppositionEventDetails">
				<dgn:OppositionEventBag>
					<xsl:for-each select="dgn:OppositionEvent">
						<xsl:variable name="var6_resultof_ST__OppositionEventToST__OppositionEvent" as="node()?">
							<xsl:call-template name="WIPO:ST86OppositionEventToST96OppositionEvent">
								<xsl:with-param name="OppositionEvent" as="node()">
									<dgn:OppositionEventType>
										<xsl:sequence select="(./@node(), ./node())"/>
									</dgn:OppositionEventType>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var6_resultof_ST__OppositionEventToST__OppositionEvent">
							<dgn:OppositionEvent>
								<xsl:sequence select="(./@node(), ./node())"/>
							</dgn:OppositionEvent>
						</xsl:for-each>
					</xsl:for-each>
				</dgn:OppositionEventBag>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/dgn:OppositionDocumentDetails">
				<com:OppositionDocumentBag xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
					<xsl:for-each select="dgn:OppositionDocument">
						<com:OppositionDocument>
							<xsl:for-each select="dgn:DocumentLanguageCode">
								<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="dgn:DocumentName">
								<com:DocumentName>
									<xsl:sequence select="fn:string(.)"/>
								</com:DocumentName>
							</xsl:for-each>
							<xsl:for-each select="dgn:DocumentFilename">
								<com:FileName>
									<xsl:sequence select="fn:string(.)"/>
								</com:FileName>
							</xsl:for-each>
							<xsl:for-each select="dgn:DocumentFileFormat">
								<xsl:variable name="var7_resultof_vmf___inputtoresult" as="xs:string?">
									<xsl:call-template name="vmf:vmf13_inputtoresult">
										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
									</xsl:call-template>
								</xsl:variable>
								<xsl:for-each select="$var7_resultof_vmf___inputtoresult">
									<com:DocumentFormatCategory>
										<xsl:sequence select="."/>
									</com:DocumentFormatCategory>
								</xsl:for-each>
							</xsl:for-each>
							<xsl:for-each select="dgn:DocumentDate">
								<com:DocumentDate>
									<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
								</com:DocumentDate>
							</xsl:for-each>
							<xsl:for-each select="dgn:DocumentMedia">
								<xsl:variable name="var8_resultof_vmf___inputtoresult" as="xs:string?">
									<xsl:call-template name="vmf:vmf14_inputtoresult">
										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
									</xsl:call-template>
								</xsl:variable>
								<xsl:for-each select="$var8_resultof_vmf___inputtoresult">
									<com:DocumentMediaCategory>
										<xsl:sequence select="."/>
									</com:DocumentMediaCategory>
								</xsl:for-each>
							</xsl:for-each>
							<xsl:for-each select="dgn:DocumentLocation">
								<com:DocumentLocationURI>
									<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
								</com:DocumentLocationURI>
							</xsl:for-each>
							<xsl:for-each select="dgn:DocumentVersion">
								<com:DocumentVersion>
									<xsl:sequence select="fn:string(.)"/>
								</com:DocumentVersion>
							</xsl:for-each>
							<xsl:for-each select="dgn:DocumentSizeInByte">
								<com:DocumentSizeQuantity>
									<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
								</com:DocumentSizeQuantity>
							</xsl:for-each>
							<xsl:for-each select="dgn:Comment">
								<com:CommentText>
									<xsl:for-each select="@languageCode">
										<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
									</xsl:for-each>
									<xsl:sequence select="fn:string(.)"/>
								</com:CommentText>
							</xsl:for-each>
						</com:OppositionDocument>
					</xsl:for-each>
				</com:OppositionDocumentBag>
			</xsl:for-each>
		</dgn:Opposition>
	</xsl:template>
	<xsl:template name="vmf:vmf1_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Design E-Filing'">
				<xsl:copy-of select="'Design eFiling'"/>
			</xsl:when>
			<xsl:when test="$input='Design B2B-Filing'">
				<xsl:copy-of select="'Design B2B filing'"/>
			</xsl:when>
			<xsl:when test="$input='Design Information'">
				<xsl:copy-of select="'Design information'"/>
			</xsl:when>
			<xsl:when test="$input='Design Identifier List'">
				<xsl:copy-of select="'Design identifier list'"/>
			</xsl:when>
			<xsl:when test="$input='Design List'">
				<xsl:copy-of select="'Design list'"/>
			</xsl:when>
			<xsl:when test="$input='Design Opposition E-Filing'">
				<xsl:copy-of select="'Design opposition eFiling'"/>
			</xsl:when>
			<xsl:when test="$input='Design Opposition Information'">
				<xsl:copy-of select="'Design opposition information'"/>
			</xsl:when>
			<xsl:when test="$input='Design Opposition Identifier List'">
				<xsl:copy-of select="'Design opposition identifier list'"/>
			</xsl:when>
			<xsl:when test="$input='Representative Appointment'">
				<xsl:copy-of select="'Representative appointment'"/>
			</xsl:when>
			<xsl:when test="$input='Amendment Registered Design'">
				<xsl:copy-of select="'Amendment registered design'"/>
			</xsl:when>
			<xsl:when test="$input='Amendment Application'">
				<xsl:copy-of select="'Amendment application'"/>
			</xsl:when>
			<xsl:when test="$input='Convention Application'">
				<xsl:copy-of select="'Convention application'"/>
			</xsl:when>
			<xsl:when test="$input='Additional Application'">
				<xsl:copy-of select="'Additional application'"/>
			</xsl:when>
			<xsl:when test="$input='Subsequent Application'">
				<xsl:copy-of select="'Subsequent application'"/>
			</xsl:when>
			<xsl:when test="$input='Divisional Application'">
				<xsl:copy-of select="'Divisional application'"/>
			</xsl:when>
			<xsl:when test="$input='Assignment Application'">
				<xsl:copy-of select="'Assignment application'"/>
			</xsl:when>
			<xsl:when test="$input='Assignment Registered Design'">
				<xsl:copy-of select="'Assignment registered design'"/>
			</xsl:when>
			<xsl:when test="$input='Request Certified Copies'">
				<xsl:copy-of select="'Request certified copies'"/>
			</xsl:when>
			<xsl:when test="$input='Request Extension Time'">
				<xsl:copy-of select="'Request extension time'"/>
			</xsl:when>
			<xsl:when test="$input='Request Hearing'">
				<xsl:copy-of select="'Request hearing'"/>
			</xsl:when>
			<xsl:when test="$input='Opposition First Extension'">
				<xsl:copy-of select="'Opposition first extension'"/>
			</xsl:when>
			<xsl:when test="$input='Opposition Various Renewal/Extension of Registration Restoration'">
				<xsl:copy-of select="'Opposition various renewal or extension of registration restoration'"/>
			</xsl:when>
			<xsl:when test="$input='Withdrawal'">
				<xsl:copy-of select="'Withdrawal'"/>
			</xsl:when>
			<xsl:when test="$input='Withdraw Application'">
				<xsl:copy-of select="'Withdraw application'"/>
			</xsl:when>
			<xsl:when test="$input='Withdraw Design'">
				<xsl:copy-of select="'Withdraw design'"/>
			</xsl:when>
			<xsl:when test="$input='Response Examination Report'">
				<xsl:copy-of select="'Response examination report'"/>
			</xsl:when>
			<xsl:when test="$input='Statement Support'">
				<xsl:copy-of select="'Statement support'"/>
			</xsl:when>
			<xsl:when test="$input='Withdraw Service Request'">
				<xsl:copy-of select="'Withdraw service request'"/>
			</xsl:when>
			<xsl:when test="$input='Request Publication'">
				<xsl:copy-of select="'Request publication'"/>
			</xsl:when>
			<xsl:when test="$input='Request Registration'">
				<xsl:copy-of select="'Request registration'"/>
			</xsl:when>
			<xsl:when test="$input='Offer Surrender'">
				<xsl:copy-of select="'Offer surrender'"/>
			</xsl:when>
			<xsl:when test="$input='Request Exclusion'">
				<xsl:copy-of select="'Request exclusion'"/>
			</xsl:when>
			<xsl:when test="$input='Request Conversion'">
				<xsl:copy-of select="'Request conversion'"/>
			</xsl:when>
			<xsl:when test="$input='Duplicate Certificate'">
				<xsl:copy-of select="'Duplicate certificate'"/>
			</xsl:when>
			<xsl:when test="$input='Request Supply Documents'">
				<xsl:copy-of select="'Request supply documents'"/>
			</xsl:when>
			<xsl:when test="$input='Request Delayed Registration'">
				<xsl:copy-of select="'Request delayed registration'"/>
			</xsl:when>
			<xsl:when test="$input='Request Accelerated Examination'">
				<xsl:copy-of select="'Request accelerated examination'"/>
			</xsl:when>
			<xsl:when test="$input='Expiry Notice'">
				<xsl:copy-of select="'Expiry notice'"/>
			</xsl:when>
			<xsl:when test="$input='Refusal Withdrawal Notification'">
				<xsl:copy-of select="'Refusal withdrawal notification'"/>
			</xsl:when>
			<xsl:when test="$input='Division International Registration Notification'">
				<xsl:copy-of select="'Division international registration notification'"/>
			</xsl:when>
			<xsl:when test="$input='Refusal Notification'">
				<xsl:copy-of select="'Refusal notification'"/>
			</xsl:when>
			<xsl:when test="$input='Providing Certificate To Holder'">
				<xsl:copy-of select="'Providing certificate to holder'"/>
			</xsl:when>
			<xsl:when test="$input='Transmittal Application To IB'">
				<xsl:copy-of select="'Transmittal application to IB'"/>
			</xsl:when>
			<xsl:when test="$input='Irregularities'">
				<xsl:copy-of select="'Irregularities'"/>
			</xsl:when>
			<xsl:when test="$input='Invalidation Notification'">
				<xsl:copy-of select="'Invalidation notification'"/>
			</xsl:when>
			<xsl:when test="$input='Cancellation Representative Appointment'">
				<xsl:copy-of select="'Cancellation representative appointment'"/>
			</xsl:when>
			<xsl:when test="$input='Application Receipt'">
				<xsl:copy-of select="'Application receipt'"/>
			</xsl:when>
			<xsl:when test="$input='Notice Document By Design Formality Examination'">
				<xsl:copy-of select="'Notice document by design formality examination'"/>
			</xsl:when>
			<xsl:when test="$input='Notice Document By Design Substantial Examination'">
				<xsl:copy-of select="'Notice document by design substantial examination'"/>
			</xsl:when>
			<xsl:when test="$input='Notice Document By Design Registration'">
				<xsl:copy-of select="'Notice document by design registration'"/>
			</xsl:when>
			<xsl:when test="$input='Notice Document By Trial Examination - Invitation'">
				<xsl:copy-of select="'Notice document by trial examination_invitation'"/>
			</xsl:when>
			<xsl:when test="$input='Notice Document By Trial Examination'">
				<xsl:copy-of select="'Notice document by trial examination'"/>
			</xsl:when>
			<xsl:when test="$input='Notice Document By Trial Examination - Decision'">
				<xsl:copy-of select="'Notice document by trial examination_decision'"/>
			</xsl:when>
			<xsl:when test="$input='Memo By Design Formality Examination'">
				<xsl:copy-of select="'Memo by design formality examination'"/>
			</xsl:when>
			<xsl:when test="$input='Memo By Design Substantial Examination'">
				<xsl:copy-of select="'Memo by design substantial examination'"/>
			</xsl:when>
			<xsl:when test="$input='Memo By Trial Examination'">
				<xsl:copy-of select="'Memo by trial examination'"/>
			</xsl:when>
			<xsl:when test="$input='Memo By Trial Notice'">
				<xsl:copy-of select="'Memo by trial notice'"/>
			</xsl:when>
			<xsl:when test="$input='Memo By Trial Examination - Correction'">
				<xsl:copy-of select="'Memo by trial examination_correction'"/>
			</xsl:when>
			<xsl:when test="$input='Accept Design Application Document'">
				<xsl:copy-of select="'Accept design application document'"/>
			</xsl:when>
			<xsl:when test="$input='Accept Design Applicant Document'">
				<xsl:copy-of select="'Accept design applicant document'"/>
			</xsl:when>
			<xsl:when test="$input='Accept Design Attorney Document'">
				<xsl:copy-of select="'Accept design attorney document'"/>
			</xsl:when>
			<xsl:when test="$input='Accept Design Withdrawal And Abandonment Document'">
				<xsl:copy-of select="'Accept design withdrawal and abandonment document'"/>
			</xsl:when>
			<xsl:when test="$input='Accept Design Response Document'">
				<xsl:copy-of select="'Accept design response document'"/>
			</xsl:when>
			<xsl:when test="$input='Accept Design Submission Document'">
				<xsl:copy-of select="'Accept design submission document'"/>
			</xsl:when>
			<xsl:when test="$input='Accept Design Amendment Document'">
				<xsl:copy-of select="'Accept design amendment document'"/>
			</xsl:when>
			<xsl:when test="$input='Accept Design Request For Inspection'">
				<xsl:copy-of select="'Accept design request for inspection'"/>
			</xsl:when>
			<xsl:when test="$input='Accept Demand For A Trial'">
				<xsl:copy-of select="'Accept demand for a trial'"/>
			</xsl:when>
			<xsl:when test="$input='Accept Trial Intermediate Document'">
				<xsl:copy-of select="'Accept trial intermediate document'"/>
			</xsl:when>
			<xsl:when test="$input='Inspection Accept Design Application Document'">
				<xsl:copy-of select="'Inspection accept design application document'"/>
			</xsl:when>
			<xsl:when test="$input='Inspection Accept Design Applicant Document'">
				<xsl:copy-of select="'Inspection accept design applicant document'"/>
			</xsl:when>
			<xsl:when test="$input='Inspection Accept Design Attorney Document'">
				<xsl:copy-of select="'Inspection accept design attorney document'"/>
			</xsl:when>
			<xsl:when test="$input='Inspection Accept Design Withdrawal And Abandonment Document'">
				<xsl:copy-of select="'Inspection accept design withdrawal and abandonment document'"/>
			</xsl:when>
			<xsl:when test="$input='Inspection Accept Design Response Document'">
				<xsl:copy-of select="'Inspection accept design response document'"/>
			</xsl:when>
			<xsl:when test="$input='Inspection Accept Design Submission Document'">
				<xsl:copy-of select="'Inspection accept design submission document'"/>
			</xsl:when>
			<xsl:when test="$input='Inspection Accept Design Amendment Document'">
				<xsl:copy-of select="'Inspection accept design amendment document'"/>
			</xsl:when>
			<xsl:when test="$input='Inspection Accept Design Request For Inspection'">
				<xsl:copy-of select="'Inspection accept design request for inspection'"/>
			</xsl:when>
			<xsl:when test="$input='Inspection Accept Demand For A Trial'">
				<xsl:copy-of select="'Inspection accept demand for a trial'"/>
			</xsl:when>
			<xsl:when test="$input='Inspection Accept Trial Intermediate Document'">
				<xsl:copy-of select="'Inspection accept trial intermediate document'"/>
			</xsl:when>
			<xsl:when test="$input='Inspection Notice Document By Design Formality Examination'">
				<xsl:copy-of select="'Inspection notice document by design formality examination'"/>
			</xsl:when>
			<xsl:when test="$input='Inspection Notice Document By Design Substantial Examination'">
				<xsl:copy-of select="'Inspection notice document by design substantial examination'"/>
			</xsl:when>
			<xsl:when test="$input='Inspection Notice Document By Design Registration'">
				<xsl:copy-of select="'Inspection notice document by design registration'"/>
			</xsl:when>
			<xsl:when test="$input='Inspection Notice Document By Trial Examination - Invitation'">
				<xsl:copy-of select="'Inspection notice document by trial examination_invitation'"/>
			</xsl:when>
			<xsl:when test="$input='Inspection Notice Document By Trial Examination'">
				<xsl:copy-of select="'Inspection notice document by trial examination'"/>
			</xsl:when>
			<xsl:when test="$input='Inspection Notice Document By Trial Examination - Decision'">
				<xsl:copy-of select="'Inspection notice document by trial examination_decision'"/>
			</xsl:when>
			<xsl:when test="$input='Inspection Memo By Design Formality Examination'">
				<xsl:copy-of select="'Inspection memo by design formality examination'"/>
			</xsl:when>
			<xsl:when test="$input='Inspection Memo By Design Substantial Examination'">
				<xsl:copy-of select="'Inspection memo by design substantial examination'"/>
			</xsl:when>
			<xsl:when test="$input='Inspection Memo By Trial Examination'">
				<xsl:copy-of select="'Inspection memo by trial examination'"/>
			</xsl:when>
			<xsl:when test="$input='Inspection Memo By Trial Notice'">
				<xsl:copy-of select="'Inspection memo by trial notice'"/>
			</xsl:when>
			<xsl:when test="$input='Certified Copy Notice Document By Design Formality Examination'">
				<xsl:copy-of select="'Certified copy notice document by design formality examination'"/>
			</xsl:when>
			<xsl:when test="$input='Certified Copy Notice Document By Design Substantial Examination'">
				<xsl:copy-of select="'Certified copy Notice document by design substantial examination'"/>
			</xsl:when>
			<xsl:when test="$input='Certified Copy Notice Document By Design Registration'">
				<xsl:copy-of select="'Certified copy notice document by design registration'"/>
			</xsl:when>
			<xsl:when test="$input='Certified Copy Notice Document By Trial Examination - Invitation'">
				<xsl:copy-of select="'Certified copy notice document by trial examination_invitation'"/>
			</xsl:when>
			<xsl:when test="$input='Certified Copy Notice Document By Trial Examination'">
				<xsl:copy-of select="'Certified copy notice document by trial examination'"/>
			</xsl:when>
			<xsl:when test="$input='Certified Copy Notice Document By Trial Examination - Decision'">
				<xsl:copy-of select="'Certified copy notice document by trial examination_decision'"/>
			</xsl:when>
			<xsl:when test="$input='Accept Document List'">
				<xsl:copy-of select="'Accept document list'"/>
			</xsl:when>
			<xsl:when test="$input='Notice Document List'">
				<xsl:copy-of select="'Notice document list'"/>
			</xsl:when>
			<xsl:when test="$input='Application Information'">
				<xsl:copy-of select="'Application information'"/>
			</xsl:when>
			<xsl:when test="$input='Balance Sheet Reference'">
				<xsl:copy-of select="'Balance sheet reference'"/>
			</xsl:when>
			<xsl:when test="$input='Division Number List'">
				<xsl:copy-of select="'Division number list'"/>
			</xsl:when>
			<xsl:when test="$input='Record Licence'">
				<xsl:copy-of select="'Record licence'"/>
			</xsl:when>
			<xsl:when test="$input='Record Mortgagee'">
				<xsl:copy-of select="'Record mortgagee'"/>
			</xsl:when>
			<xsl:when test="$input='Terminate Licence'">
				<xsl:copy-of select="'Terminate licence'"/>
			</xsl:when>
			<xsl:when test="$input='Discharge Mortgagee'">
				<xsl:copy-of select="'Discharge mortgagee'"/>
			</xsl:when>
			<xsl:when test="$input='Change of Name'">
				<xsl:copy-of select="'Change of name'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf2_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Accelerated Registration'">
				<xsl:copy-of select="'Accelerated registration'"/>
			</xsl:when>
			<xsl:when test="$input='Normal'">
				<xsl:copy-of select="'Normal'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf3_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='InYear'">
				<xsl:copy-of select="'In year'"/>
			</xsl:when>
			<xsl:when test="$input='InMonth'">
				<xsl:copy-of select="'In month'"/>
			</xsl:when>
			<xsl:when test="$input='InWeek'">
				<xsl:copy-of select="'In week'"/>
			</xsl:when>
			<xsl:when test="$input='InDay'">
				<xsl:copy-of select="'In day'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf4_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Filed'">
				<xsl:copy-of select="'Filed'"/>
			</xsl:when>
			<xsl:when test="$input='Withdrawn'">
				<xsl:copy-of select="'Withdrawn'"/>
			</xsl:when>
			<xsl:when test="$input='Rejected'">
				<xsl:copy-of select="'Rejected'"/>
			</xsl:when>
			<xsl:when test="$input='Registered'">
				<xsl:copy-of select="'Registered'"/>
			</xsl:when>
			<xsl:when test="$input='Cancelled'">
				<xsl:copy-of select="'Cancelled'"/>
			</xsl:when>
			<xsl:when test="$input='Expired'">
				<xsl:copy-of select="'Expired'"/>
			</xsl:when>
			<xsl:when test="$input='Undefined'">
				<xsl:copy-of select="'Undefined'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf5_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Applications'">
				<xsl:copy-of select="'Applications'"/>
			</xsl:when>
			<xsl:when test="$input='Amendments to applications'">
				<xsl:copy-of select="'Amendments to applications'"/>
			</xsl:when>
			<xsl:when test="$input='Correction of errors on applications'">
				<xsl:copy-of select="'Correction of errors on applications'"/>
			</xsl:when>
			<xsl:when test="$input='Withdrawals'">
				<xsl:copy-of select="'Withdrawals'"/>
			</xsl:when>
			<xsl:when test="$input='Limitations'">
				<xsl:copy-of select="'Limitations'"/>
			</xsl:when>
			<xsl:when test="$input='Total refusals'">
				<xsl:copy-of select="'Total refusals'"/>
			</xsl:when>
			<xsl:when test="$input='Partial refusals'">
				<xsl:copy-of select="'Partial refusals'"/>
			</xsl:when>
			<xsl:when test="$input='Registrations with no amendments'">
				<xsl:copy-of select="'Registrations with no amendments'"/>
			</xsl:when>
			<xsl:when test="$input='Registrations with amendments'">
				<xsl:copy-of select="'Registrations with amendments'"/>
			</xsl:when>
			<xsl:when test="$input='Correction of errors on registrations'">
				<xsl:copy-of select="'Correction of errors on registrations'"/>
			</xsl:when>
			<xsl:when test="$input='Total transfers'">
				<xsl:copy-of select="'Total transfers'"/>
			</xsl:when>
			<xsl:when test="$input='Partial transfers'">
				<xsl:copy-of select="'Partial transfers'"/>
			</xsl:when>
			<xsl:when test="$input='Change of name and address of proprietor'">
				<xsl:copy-of select="'Change of name and address of proprietor'"/>
			</xsl:when>
			<xsl:when test="$input='Change of name and professional address of representative'">
				<xsl:copy-of select="'Change of name and professional address of representative'"/>
			</xsl:when>
			<xsl:when test="$input='Replacement of representative'">
				<xsl:copy-of select="'Replacement of representative'"/>
			</xsl:when>
			<xsl:when test="$input='Appointment of a new representative'">
				<xsl:copy-of select="'Appointment of a new representative'"/>
			</xsl:when>
			<xsl:when test="$input='Deletion of the representative'">
				<xsl:copy-of select="'Deletion of the representative'"/>
			</xsl:when>
			<xsl:when test="$input='Total surrender of designs'">
				<xsl:copy-of select="'Total surrender of designs'"/>
			</xsl:when>
			<xsl:when test="$input='Partial surrender of designs'">
				<xsl:copy-of select="'Partial surrender of designs'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf6_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Withdrawn'">
				<xsl:copy-of select="'Withdrawn'"/>
			</xsl:when>
			<xsl:when test="$input='Registered'">
				<xsl:copy-of select="'Registered'"/>
			</xsl:when>
			<xsl:when test="$input='Expired'">
				<xsl:copy-of select="'Expired'"/>
			</xsl:when>
			<xsl:when test="$input='Undefined'">
				<xsl:copy-of select="'Undefined'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf7_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Insert'">
				<xsl:copy-of select="'Insert'"/>
			</xsl:when>
			<xsl:when test="$input='Update'">
				<xsl:copy-of select="'Update'"/>
			</xsl:when>
			<xsl:when test="$input='Delete'">
				<xsl:copy-of select="'Delete'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf8_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Division'">
				<xsl:copy-of select="'Division'"/>
			</xsl:when>
			<xsl:when test="$input='Related Design'">
				<xsl:copy-of select="'Related design'"/>
			</xsl:when>
			<xsl:when test="$input='Design Application Based on Patent or Utility Model'">
				<xsl:copy-of select="'Design application based on patent or utility model'"/>
			</xsl:when>
			<xsl:when test="$input='New Application for Amended Design'">
				<xsl:copy-of select="'New application for amended design'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf9_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Insert'">
				<xsl:copy-of select="'Insert'"/>
			</xsl:when>
			<xsl:when test="$input='Update'">
				<xsl:copy-of select="'Update'"/>
			</xsl:when>
			<xsl:when test="$input='Delete'">
				<xsl:copy-of select="'Delete'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf10_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Insert'">
				<xsl:copy-of select="'Insert'"/>
			</xsl:when>
			<xsl:when test="$input='Update'">
				<xsl:copy-of select="'Update'"/>
			</xsl:when>
			<xsl:when test="$input='Delete'">
				<xsl:copy-of select="'Delete'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf11_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Association'">
				<xsl:copy-of select="'Association'"/>
			</xsl:when>
			<xsl:when test="$input='Employee'">
				<xsl:copy-of select="'Employee'"/>
			</xsl:when>
			<xsl:when test="$input='Other'">
				<xsl:copy-of select="'Other'"/>
			</xsl:when>
			<xsl:when test="$input='Lawyer'">
				<xsl:copy-of select="'Lawyer'"/>
			</xsl:when>
			<xsl:when test="$input='Professional Representative'">
				<xsl:copy-of select="'Professional representative'"/>
			</xsl:when>
			<xsl:when test="$input='Undefined'">
				<xsl:copy-of select="'Undefined'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf12_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Claimed'">
				<xsl:copy-of select="'Claimed'"/>
			</xsl:when>
			<xsl:when test="$input='Accepted'">
				<xsl:copy-of select="'Accepted'"/>
			</xsl:when>
			<xsl:when test="$input='Refused'">
				<xsl:copy-of select="'Refused'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf13_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='JPEG'">
				<xsl:copy-of select="'JPEG'"/>
			</xsl:when>
			<xsl:when test="$input='TIFF'">
				<xsl:copy-of select="'TIFF'"/>
			</xsl:when>
			<xsl:when test="$input='PNG'">
				<xsl:copy-of select="'PNG'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf14_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Paper'">
				<xsl:copy-of select="'Paper'"/>
			</xsl:when>
			<xsl:when test="$input='Fax'">
				<xsl:copy-of select="'Fax'"/>
			</xsl:when>
			<xsl:when test="$input='File'">
				<xsl:copy-of select="'File'"/>
			</xsl:when>
			<xsl:when test="$input='Other'">
				<xsl:copy-of select="'Other'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf15_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Abandoned'">
				<xsl:copy-of select="'Abandoned'"/>
			</xsl:when>
			<xsl:when test="$input='Accepted'">
				<xsl:copy-of select="'Accepted'"/>
			</xsl:when>
			<xsl:when test="$input='Claimed'">
				<xsl:copy-of select="'Claimed'"/>
			</xsl:when>
			<xsl:when test="$input='Partially Refused'">
				<xsl:copy-of select="'Partially refused'"/>
			</xsl:when>
			<xsl:when test="$input='Refused'">
				<xsl:copy-of select="'Refused'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf16_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Object'">
				<xsl:copy-of select="'Object'"/>
			</xsl:when>
			<xsl:when test="$input='Model'">
				<xsl:copy-of select="'Model'"/>
			</xsl:when>
			<xsl:when test="$input='Sample'">
				<xsl:copy-of select="'Sample'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf17_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='JPEG'">
				<xsl:copy-of select="'JPEG'"/>
			</xsl:when>
			<xsl:when test="$input='TIFF'">
				<xsl:copy-of select="'TIFF'"/>
			</xsl:when>
			<xsl:when test="$input='PNG'">
				<xsl:copy-of select="'PNG'"/>
			</xsl:when>
			<xsl:when test="$input='GIF'">
				<xsl:copy-of select="'GIF'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf18_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Opposition filed'">
				<xsl:copy-of select="'Opposition filed'"/>
			</xsl:when>
			<xsl:when test="$input='Admissibility checked'">
				<xsl:copy-of select="'Admissibility checked'"/>
			</xsl:when>
			<xsl:when test="$input='Agreement between parties'">
				<xsl:copy-of select="'Agreement between parties'"/>
			</xsl:when>
			<xsl:when test="$input='Final decision'">
				<xsl:copy-of select="'Final decision'"/>
			</xsl:when>
			<xsl:when test="$input='Undefined'">
				<xsl:copy-of select="'Undefined'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf19_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Fixed'">
				<xsl:copy-of select="'Business fixed'"/>
			</xsl:when>
			<xsl:when test="$input='Mobile Phone'">
				<xsl:copy-of select="'Business mobile'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf20_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='JPEG'">
				<xsl:copy-of select="'JPEG'"/>
			</xsl:when>
			<xsl:when test="$input='TIFF'">
				<xsl:copy-of select="'TIFF'"/>
			</xsl:when>
			<xsl:when test="$input='PNG'">
				<xsl:copy-of select="'PNG'"/>
			</xsl:when>
			<xsl:when test="$input='GIF'">
				<xsl:copy-of select="'GIF'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf21_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Registered design'">
				<xsl:copy-of select="'Registered design'"/>
			</xsl:when>
			<xsl:when test="$input='Unregistered design'">
				<xsl:copy-of select="'Unregistered design'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf22_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Filing date'">
				<xsl:copy-of select="'Filing date'"/>
			</xsl:when>
			<xsl:when test="$input='Registration date'">
				<xsl:copy-of select="'Registration date'"/>
			</xsl:when>
			<xsl:when test="$input='Use date'">
				<xsl:copy-of select="'Use date'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf23_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Design application'">
				<xsl:copy-of select="'Design application'"/>
			</xsl:when>
			<xsl:when test="$input='Registered design'">
				<xsl:copy-of select="'Registered design'"/>
			</xsl:when>
			<xsl:when test="$input='Non-registered design'">
				<xsl:copy-of select="'Non-registered design'"/>
			</xsl:when>
			<xsl:when test="$input='Trade mark'">
				<xsl:copy-of select="'Trademark'"/>
			</xsl:when>
			<xsl:when test="$input='Patent'">
				<xsl:copy-of select="'Patent'"/>
			</xsl:when>
			<xsl:when test="$input='Utility model'">
				<xsl:copy-of select="'Utility model'"/>
			</xsl:when>
			<xsl:when test="$input='Undefined'">
				<xsl:copy-of select="'Undefined'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf24_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Opposition filed'">
				<xsl:copy-of select="'Opposition filed'"/>
			</xsl:when>
			<xsl:when test="$input='Admissibility checked'">
				<xsl:copy-of select="'Admissibility checked'"/>
			</xsl:when>
			<xsl:when test="$input='Agreement between parties'">
				<xsl:copy-of select="'Agreement between parties'"/>
			</xsl:when>
			<xsl:when test="$input='Final decision'">
				<xsl:copy-of select="'Final decision'"/>
			</xsl:when>
			<xsl:when test="$input='Undefined'">
				<xsl:copy-of select="'Undefined'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="/">
		<xsl:variable name="var20_Transaction" as="node()?" select="dgn:Transaction"/>
		<dgn:DesignTransaction xmlns:dgn="http://www.wipo.int/standards/XMLSchema/ST96/Design" xmlns:tbl="http://www.oasis-open.org/tables/exchange/1.0" xmlns:mathml="http://www.w3.org/1998/Math/MathML3" xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
			<xsl:attribute name="xsi:schemaLocation" namespace="http://www.w3.org/2001/XMLSchema-instance" select="'http://www.wipo.int/standards/XMLSchema/ST96/Design DesignTransaction_V7_0.xsd'"/>
			<xsl:for-each select="$var20_Transaction">
				<xsl:attribute name="com:st96Version" select="'V7_0'"/>
			</xsl:for-each>
			<xsl:for-each select="$var20_Transaction">
				<xsl:for-each select="dgn:TransactionHeader">
					<com:TransactionHeader>
						<xsl:for-each select="dgn:SenderDetails">
							<com:SenderBag>
								<xsl:for-each select="dgn:RequestIdentifier">
									<com:RequestIdentifier>
										<xsl:sequence select="fn:string(.)"/>
									</com:RequestIdentifier>
								</xsl:for-each>
								<xsl:for-each select="dgn:RequestLanguageCode">
									<com:RequestLanguageCode>
										<xsl:sequence select="fn:string(.)"/>
									</com:RequestLanguageCode>
								</xsl:for-each>
								<xsl:for-each select="dgn:RequestXSDVersion">
									<com:RequestXSDVersion>
										<xsl:sequence select="fn:string(.)"/>
									</com:RequestXSDVersion>
								</xsl:for-each>
								<xsl:for-each select="dgn:RequestFilename">
									<com:FileName>
										<xsl:sequence select="fn:string(.)"/>
									</com:FileName>
								</xsl:for-each>
								<xsl:for-each select="dgn:RequestStatus">
									<com:RequestStatusCategory>
										<xsl:sequence select="fn:string(.)"/>
									</com:RequestStatusCategory>
								</xsl:for-each>
								<xsl:for-each select="dgn:RequestProducer">
									<com:RequestProducer>
										<xsl:sequence select="fn:string(.)"/>
									</com:RequestProducer>
								</xsl:for-each>
								<xsl:for-each select="dgn:RequestReceivingOfficeCode">
									<com:RequestReceivingOfficeCode>
										<xsl:sequence select="fn:string(.)"/>
									</com:RequestReceivingOfficeCode>
								</xsl:for-each>
								<xsl:for-each select="dgn:LoginInformation">
									<com:LoginInformation>
										<xsl:for-each select="dgn:Login">
											<com:Login>
												<xsl:sequence select="fn:string(.)"/>
											</com:Login>
										</xsl:for-each>
										<xsl:for-each select="dgn:LoginEmail">
											<com:LoginEmail>
												<xsl:sequence select="fn:string(.)"/>
											</com:LoginEmail>
										</xsl:for-each>
										<xsl:for-each select="dgn:Password">
											<com:Password>
												<xsl:sequence select="fn:string(.)"/>
											</com:Password>
										</xsl:for-each>
									</com:LoginInformation>
								</xsl:for-each>
								<xsl:for-each select="dgn:RequestProducerDate">
									<com:RequestDate>
										<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
									</com:RequestDate>
								</xsl:for-each>
								<xsl:for-each select="dgn:RequestProducerDateTime">
									<com:RequestDateTime>
										<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
									</com:RequestDateTime>
								</xsl:for-each>
							</com:SenderBag>
						</xsl:for-each>
						<xsl:for-each select="dgn:ReceiverDetails">
							<com:ReceiverBag>
								<xsl:for-each select="dgn:ReceiverDateTime">
									<com:ReceiverDateTime>
										<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
									</com:ReceiverDateTime>
								</xsl:for-each>
								<xsl:for-each select="dgn:Comment">
									<com:CommentText>
										<xsl:for-each select="@languageCode">
											<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
										</xsl:for-each>
										<xsl:sequence select="fn:string(.)"/>
									</com:CommentText>
								</xsl:for-each>
							</com:ReceiverBag>
						</xsl:for-each>
					</com:TransactionHeader>
				</xsl:for-each>
				<xsl:for-each select="dgn:DesignTransactionBody">
					<dgn:DesignTransactionBody>
						<xsl:attribute name="com:st96Version" select="'V7_0'"/>
						<xsl:for-each select="dgn:TransactionErrorDetails">
							<com:TransactionErrorBag>
								<xsl:for-each select="dgn:TransactionError">
									<com:TransactionError>
										<xsl:for-each select="dgn:TransactionErrorCode">
											<com:TransactionErrorCode>
												<xsl:sequence select="fn:string(.)"/>
											</com:TransactionErrorCode>
										</xsl:for-each>
										<xsl:for-each select="dgn:TransactionErrorText">
											<com:TransactionErrorText>
												<xsl:for-each select="@languageCode">
													<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
												</xsl:for-each>
												<xsl:sequence select="fn:string(.)"/>
											</com:TransactionErrorText>
										</xsl:for-each>
									</com:TransactionError>
								</xsl:for-each>
							</com:TransactionErrorBag>
						</xsl:for-each>
						<xsl:variable name="var19_TransactionContentDetails" as="node()" select="dgn:TransactionContentDetails"/>
						<dgn:TransactionContentBag>
							<xsl:attribute name="com:st96Version" select="'V7_0'"/>
							<xsl:for-each select="$var19_TransactionContentDetails/dgn:TransactionIdentifier">
								<com:TransactionIdentifier>
									<xsl:sequence select="fn:string(.)"/>
								</com:TransactionIdentifier>
							</xsl:for-each>
							<xsl:variable name="var1_resultof_vmf__inputtoresult" as="xs:string?">
								<xsl:call-template name="vmf:vmf1_inputtoresult">
									<xsl:with-param name="input" select="fn:string($var19_TransactionContentDetails/dgn:TransactionCode)" as="xs:string"/>
								</xsl:call-template>
							</xsl:variable>
							<xsl:for-each select="$var1_resultof_vmf__inputtoresult">
								<com:TransactionCategory>
									<xsl:sequence select="."/>
								</com:TransactionCategory>
							</xsl:for-each>
							<xsl:for-each select="$var19_TransactionContentDetails/dgn:TransactionSubCode">
								<xsl:variable name="var2_resultof_vmf__inputtoresult" as="xs:string?">
									<xsl:call-template name="vmf:vmf2_inputtoresult">
										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
									</xsl:call-template>
								</xsl:variable>
								<xsl:for-each select="$var2_resultof_vmf__inputtoresult">
									<com:TransactionSubCode>
										<xsl:sequence select="."/>
									</com:TransactionSubCode>
								</xsl:for-each>
							</xsl:for-each>
							<xsl:variable name="var18_TransactionData" as="node()" select="$var19_TransactionContentDetails/dgn:TransactionData"/>
							<dgn:TransactionData>
								<xsl:attribute name="com:st96Version" select="'V7_0'"/>
								<xsl:for-each select="$var18_TransactionData/dgn:DesignApplicationDetails">
									<dgn:DesignApplicationBag>
										<xsl:attribute name="com:st96Version" select="'V7_0'"/>
										<xsl:for-each select="dgn:DesignApplication">
											<dgn:DesignApplication>
												<xsl:attribute name="com:st96Version" select="'V7_0'"/>
												<xsl:for-each select="dgn:RequestSoftware">
													<com:RequestSoftware>
														<com:RequestSoftwareName>
															<xsl:sequence select="fn:string(dgn:RequestSoftwareName)"/>
														</com:RequestSoftwareName>
														<xsl:for-each select="dgn:RequestSoftwareVersion">
															<com:RequestSoftwareVersion>
																<xsl:sequence select="fn:string(.)"/>
															</com:RequestSoftwareVersion>
														</xsl:for-each>
													</com:RequestSoftware>
												</xsl:for-each>
												<xsl:for-each select="dgn:DesignApplicationFormName">
													<dgn:DesignApplicationFormName>
														<xsl:sequence select="fn:string(.)"/>
													</dgn:DesignApplicationFormName>
												</xsl:for-each>
												<xsl:for-each select="dgn:RequestExamination">
													<com:RequestExamination>
														<xsl:for-each select="dgn:RequestExaminationAuthority">
															<com:RequestExaminationAuthority>
																<xsl:sequence select="fn:string(.)"/>
															</com:RequestExaminationAuthority>
														</xsl:for-each>
														<com:RequestExaminationCategory>
															<xsl:sequence select="fn:string(dgn:RequestExaminationKindCode)"/>
														</com:RequestExaminationCategory>
													</com:RequestExamination>
												</xsl:for-each>
												<com:RegistrationOfficeCode>
													<xsl:sequence select="fn:string(dgn:RegistrationOfficeCode)"/>
												</com:RegistrationOfficeCode>
												<xsl:for-each select="dgn:ReceivingOfficeCode">
													<com:ReceivingOfficeCode>
														<xsl:sequence select="fn:string(.)"/>
													</com:ReceivingOfficeCode>
												</xsl:for-each>
												<xsl:for-each select="dgn:ReceivingOfficeDate">
													<com:ReceivingOfficeDate>
														<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
													</com:ReceivingOfficeDate>
												</xsl:for-each>
												<xsl:for-each select="dgn:ReceiptNumber">
													<dgn:ReceiptNumber>
														<xsl:sequence select="fn:string(.)"/>
													</dgn:ReceiptNumber>
												</xsl:for-each>
												<xsl:for-each select="dgn:SealedDepositIndicator">
													<dgn:SealedDepositIndicator>
														<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
													</dgn:SealedDepositIndicator>
												</xsl:for-each>
												<xsl:for-each select="dgn:FilingPlace">
													<com:FilingPlace>
														<xsl:sequence select="fn:string(.)"/>
													</com:FilingPlace>
												</xsl:for-each>
												<xsl:for-each select="dgn:DesignApplicationReference">
													<com:ApplicantFileReference>
														<xsl:sequence select="fn:string(.)"/>
													</com:ApplicantFileReference>
												</xsl:for-each>
												<xsl:for-each select="dgn:DesignApplicationLanguageCode">
													<dgn:DesignApplicationLanguageCode>
														<xsl:sequence select="fn:string(.)"/>
													</dgn:DesignApplicationLanguageCode>
												</xsl:for-each>
												<xsl:for-each select="dgn:SecondLanguageCode">
													<com:SecondLanguageCode>
														<xsl:sequence select="fn:string(.)"/>
													</com:SecondLanguageCode>
												</xsl:for-each>
												<xsl:for-each select="dgn:CorrespondenceLanguageCode">
													<com:CorrespondenceLanguageCode>
														<xsl:sequence select="fn:string(.)"/>
													</com:CorrespondenceLanguageCode>
												</xsl:for-each>
												<xsl:for-each select="dgn:DesignApplicationCurrentStatusDate">
													<dgn:DesignApplicationCurrentStatusDate>
														<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
													</dgn:DesignApplicationCurrentStatusDate>
												</xsl:for-each>
												<dgn:DesignBag>
													<xsl:for-each select="dgn:DesignDetails/dgn:Design">
														<dgn:Design>
															<xsl:for-each select="dgn:DesignIdentifier">
																<dgn:DesignIdentifier>
																	<xsl:sequence select="fn:string(.)"/>
																</dgn:DesignIdentifier>
															</xsl:for-each>
															<xsl:for-each select="dgn:DesignReference">
																<dgn:DesignReference>
																	<xsl:sequence select="fn:string(.)"/>
																</dgn:DesignReference>
															</xsl:for-each>
															<xsl:for-each select="dgn:RegistrationNumber">
																<com:RegistrationNumber>
																	<xsl:sequence select="fn:string(.)"/>
																</com:RegistrationNumber>
															</xsl:for-each>
															<xsl:for-each select="dgn:RegistrationDate">
																<com:RegistrationDate>
																	<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																</com:RegistrationDate>
															</xsl:for-each>
															<xsl:for-each select="dgn:PublicationKindDescription">
																<dgn:PublicationKindDescription>
																	<xsl:for-each select="@languageCode">
																		<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:sequence select="fn:string(.)"/>
																</dgn:PublicationKindDescription>
															</xsl:for-each>
															<xsl:for-each select="dgn:PartialDesignIndicator">
																<dgn:PartialDesignIndicator>
																	<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																</dgn:PartialDesignIndicator>
															</xsl:for-each>
															<xsl:for-each select="dgn:PublicationDefermentIndicator">
																<dgn:PublicationDefermentIndicator>
																	<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																</dgn:PublicationDefermentIndicator>
															</xsl:for-each>
															<xsl:for-each select="dgn:DefermentPeriod">
																<dgn:DefermentPeriod>
																	<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																</dgn:DefermentPeriod>
															</xsl:for-each>
															<xsl:for-each select="dgn:ColourIndicator">
																<com:ColourIndicator>
																	<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																</com:ColourIndicator>
															</xsl:for-each>
															<xsl:for-each select="dgn:DesignerWaiverIndicator">
																<dgn:DesignerWaiverIndicator>
																	<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																</dgn:DesignerWaiverIndicator>
															</xsl:for-each>
															<xsl:for-each select="dgn:PublicationInColourIndicator">
																<dgn:PublicationInColourIndicator>
																	<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																</dgn:PublicationInColourIndicator>
															</xsl:for-each>
															<xsl:for-each select="dgn:ImmediatePublicationIndicator">
																<dgn:ImmediatePublicationIndicator>
																	<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																</dgn:ImmediatePublicationIndicator>
															</xsl:for-each>
															<xsl:for-each select="dgn:DescriptionPublicationIndicator">
																<dgn:DescriptionPublicationIndicator>
																	<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																</dgn:DescriptionPublicationIndicator>
															</xsl:for-each>
															<xsl:for-each select="dgn:DesignOpenToLicensingIndicator">
																<dgn:DesignOpenToLicensingIndicator>
																	<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																</dgn:DesignOpenToLicensingIndicator>
															</xsl:for-each>
															<xsl:for-each select="dgn:ExpiryDate">
																<com:ExpiryDate>
																	<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																</com:ExpiryDate>
															</xsl:for-each>
															<xsl:for-each select="dgn:DesignCurrentStatusDate">
																<dgn:DesignCurrentStatusDate>
																	<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																</dgn:DesignCurrentStatusDate>
															</xsl:for-each>
														</dgn:Design>
													</xsl:for-each>
												</dgn:DesignBag>
												<xsl:for-each select="dgn:Authorization">
													<com:Authorization>
														<xsl:for-each select="dgn:AuthorizationIdentifier">
															<com:AuthorizationIdentifier>
																<xsl:sequence select="fn:string(.)"/>
															</com:AuthorizationIdentifier>
														</xsl:for-each>
														<xsl:for-each select="dgn:AuthorizationDate">
															<com:AuthorizationDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:AuthorizationDate>
														</xsl:for-each>
														<xsl:for-each select="dgn:AuthorizationDocument">
															<com:AuthorizationDocument>
																<xsl:for-each select="dgn:DocumentName">
																	<com:DocumentName>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:DocumentName>
																</xsl:for-each>
																<xsl:for-each select="dgn:DocumentDate">
																	<com:DocumentDate>
																		<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																	</com:DocumentDate>
																</xsl:for-each>
																<xsl:for-each select="dgn:DocumentVersion">
																	<com:DocumentVersion>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:DocumentVersion>
																</xsl:for-each>
															</com:AuthorizationDocument>
														</xsl:for-each>
													</com:Authorization>
												</xsl:for-each>
												<xsl:for-each select="dgn:DesignApplicationDate">
													<com:ApplicationDate>
														<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
													</com:ApplicationDate>
												</xsl:for-each>
												<xsl:for-each select="dgn:DesignApplicationDateTime">
													<com:ApplicationDateTime>
														<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
													</com:ApplicationDateTime>
												</xsl:for-each>
												<xsl:for-each select="dgn:CorrespondenceAddress">
													<com:CorrespondenceAddress>
														<xsl:sequence select="()"/>
													</com:CorrespondenceAddress>
												</xsl:for-each>
											</dgn:DesignApplication>
										</xsl:for-each>
									</dgn:DesignApplicationBag>
								</xsl:for-each>
								<xsl:for-each select="$var18_TransactionData/dgn:DesignDetails">
									<dgn:DesignBag>
										<xsl:for-each select="dgn:Design">
											<dgn:Design>
												<xsl:for-each select="dgn:DesignIdentifier">
													<dgn:DesignIdentifier>
														<xsl:sequence select="fn:string(.)"/>
													</dgn:DesignIdentifier>
												</xsl:for-each>
												<xsl:for-each select="dgn:DesignReference">
													<dgn:DesignReference>
														<xsl:sequence select="fn:string(.)"/>
													</dgn:DesignReference>
												</xsl:for-each>
												<xsl:for-each select="dgn:RegistrationNumber">
													<com:RegistrationNumber>
														<xsl:sequence select="fn:string(.)"/>
													</com:RegistrationNumber>
												</xsl:for-each>
												<xsl:for-each select="dgn:RegistrationDate">
													<com:RegistrationDate>
														<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
													</com:RegistrationDate>
												</xsl:for-each>
												<xsl:for-each select="dgn:DesignTitle">
													<dgn:DesignTitleText>
														<xsl:for-each select="@languageCode">
															<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
														</xsl:for-each>
														<xsl:sequence select="fn:string(.)"/>
													</dgn:DesignTitleText>
												</xsl:for-each>
												<xsl:for-each select="dgn:DesignDescription">
													<dgn:DesignDescriptionText>
														<xsl:for-each select="@languageCode">
															<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
														</xsl:for-each>
														<xsl:for-each select="@sequenceNumber">
															<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string(.)))"/>
														</xsl:for-each>
														<xsl:sequence select="fn:string(.)"/>
													</dgn:DesignDescriptionText>
												</xsl:for-each>
												<xsl:for-each select="dgn:PublicationKindDescription">
													<dgn:PublicationKindDescription>
														<xsl:for-each select="@languageCode">
															<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
														</xsl:for-each>
														<xsl:sequence select="fn:string(.)"/>
													</dgn:PublicationKindDescription>
												</xsl:for-each>
												<xsl:for-each select="dgn:NoveltyStatement">
													<dgn:NoveltyStatementText>
														<xsl:for-each select="@languageCode">
															<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
														</xsl:for-each>
														<xsl:sequence select="fn:string(.)"/>
													</dgn:NoveltyStatementText>
												</xsl:for-each>
												<xsl:for-each select="dgn:PartialDesignIndicator">
													<dgn:PartialDesignIndicator>
														<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
													</dgn:PartialDesignIndicator>
												</xsl:for-each>
												<xsl:for-each select="dgn:PartialDisclaimer">
													<dgn:PartialDisclaimerText>
														<xsl:for-each select="@languageCode">
															<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
														</xsl:for-each>
														<xsl:sequence select="fn:string(.)"/>
													</dgn:PartialDisclaimerText>
												</xsl:for-each>
												<xsl:for-each select="dgn:DefermentPeriod">
													<dgn:DefermentPeriod>
														<xsl:for-each select="@periodCode">
															<xsl:variable name="var3_resultof_vmf__inputtoresult" as="xs:string?">
																<xsl:call-template name="vmf:vmf3_inputtoresult">
																	<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																</xsl:call-template>
															</xsl:variable>
															<xsl:for-each select="$var3_resultof_vmf__inputtoresult">
																<xsl:attribute name="com:periodCategory" select="."/>
															</xsl:for-each>
														</xsl:for-each>
														<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
													</dgn:DefermentPeriod>
												</xsl:for-each>
												<xsl:for-each select="dgn:ColourIndicator">
													<com:ColourIndicator>
														<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
													</com:ColourIndicator>
												</xsl:for-each>
												<xsl:for-each select="dgn:DesignerWaiverIndicator">
													<dgn:DesignerWaiverIndicator>
														<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
													</dgn:DesignerWaiverIndicator>
												</xsl:for-each>
												<xsl:for-each select="dgn:PublicationInColourIndicator">
													<dgn:PublicationInColourIndicator>
														<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
													</dgn:PublicationInColourIndicator>
												</xsl:for-each>
												<xsl:for-each select="dgn:ImmediatePublicationIndicator">
													<dgn:ImmediatePublicationIndicator>
														<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
													</dgn:ImmediatePublicationIndicator>
												</xsl:for-each>
												<xsl:for-each select="dgn:DescriptionPublicationIndicator">
													<dgn:DescriptionPublicationIndicator>
														<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
													</dgn:DescriptionPublicationIndicator>
												</xsl:for-each>
												<xsl:for-each select="dgn:DesignOpenToLicensingIndicator">
													<dgn:DesignOpenToLicensingIndicator>
														<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
													</dgn:DesignOpenToLicensingIndicator>
												</xsl:for-each>
												<xsl:for-each select="dgn:TotalSpecimen">
													<dgn:SpecimenTotalQuantity>
														<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
													</dgn:SpecimenTotalQuantity>
												</xsl:for-each>
												<xsl:for-each select="dgn:TotalRepresentationSheet">
													<dgn:RepresentationSheetTotalQuantity>
														<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
													</dgn:RepresentationSheetTotalQuantity>
												</xsl:for-each>
												<xsl:for-each select="dgn:TotalColourView">
													<dgn:ColourViewTotalQuantity>
														<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
													</dgn:ColourViewTotalQuantity>
												</xsl:for-each>
												<xsl:for-each select="dgn:TotalBWView">
													<dgn:BlackWhiteViewTotalQuantity>
														<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
													</dgn:BlackWhiteViewTotalQuantity>
												</xsl:for-each>
												<xsl:for-each select="dgn:ExpiryDate">
													<com:ExpiryDate>
														<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
													</com:ExpiryDate>
												</xsl:for-each>
												<xsl:for-each select="dgn:DesignCurrentStatusCode">
													<xsl:variable name="var4_resultof_vmf__inputtoresult" as="xs:string?">
														<xsl:call-template name="vmf:vmf4_inputtoresult">
															<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
														</xsl:call-template>
													</xsl:variable>
													<xsl:for-each select="$var4_resultof_vmf__inputtoresult">
														<dgn:DesignCurrentStatusCategory>
															<xsl:sequence select="."/>
														</dgn:DesignCurrentStatusCategory>
													</xsl:for-each>
												</xsl:for-each>
												<xsl:for-each select="dgn:DesignCurrentStatusDate">
													<dgn:DesignCurrentStatusDate>
														<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
													</dgn:DesignCurrentStatusDate>
												</xsl:for-each>
												<xsl:for-each select="dgn:DesignSpecimenDetails">
													<dgn:DesignSpecimenBag>
														<xsl:for-each select="dgn:DesignSpecimen">
															<xsl:variable name="var5_resultof_ST__DesignSpecimenToST__DesignSpecimen" as="node()?">
																<xsl:call-template name="WIPO:ST86DesignSpecimenToST96DesignSpecimen">
																	<xsl:with-param name="DesignSpecimen" as="node()">
																		<dgn:DesignSpecimenType>
																			<xsl:sequence select="(./@node(), ./node())"/>
																		</dgn:DesignSpecimenType>
																	</xsl:with-param>
																</xsl:call-template>
															</xsl:variable>
															<xsl:for-each select="$var5_resultof_ST__DesignSpecimenToST__DesignSpecimen">
																<dgn:DesignSpecimen>
																	<xsl:sequence select="()"/>
																</dgn:DesignSpecimen>
															</xsl:for-each>
														</xsl:for-each>
													</dgn:DesignSpecimenBag>
												</xsl:for-each>
												<dgn:DesignRepresentationBag>
													<dgn:DesignRepresentation>
														<xsl:for-each select="dgn:DesignRepresentationSheetDetails">
															<dgn:DesignRepresentationSheetBag>
																<xsl:sequence select="()"/>
															</dgn:DesignRepresentationSheetBag>
														</xsl:for-each>
													</dgn:DesignRepresentation>
												</dgn:DesignRepresentationBag>
												<com:DesignClassificationBag>
													<xsl:for-each select="dgn:IndicationProductDetails/dgn:IndicationProduct">
														<com:NationalDesignClassificationBag>
															<xsl:for-each select="dgn:ClassificationVersion">
																<com:NationalClassificationEdition>
																	<xsl:sequence select="fn:string(.)"/>
																</com:NationalClassificationEdition>
															</xsl:for-each>
															<xsl:for-each select="dgn:IndicationProductDescription">
																<com:NationalDesignProductIndicationText>
																	<xsl:for-each select="@languageCode">
																		<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:for-each select="@sequenceNumber">
																		<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string(.)))"/>
																	</xsl:for-each>
																	<xsl:sequence select="fn:string(.)"/>
																</com:NationalDesignProductIndicationText>
															</xsl:for-each>
														</com:NationalDesignClassificationBag>
													</xsl:for-each>
												</com:DesignClassificationBag>
												<xsl:for-each select="dgn:PriorityDetails">
													<dgn:PriorityBag>
														<xsl:for-each select="dgn:Priority">
															<xsl:variable name="var6_resultof_ST__PriorityToST__Priority" as="node()?">
																<xsl:call-template name="WIPO:ST86PriorityToST96Priority">
																	<xsl:with-param name="Priority" as="node()">
																		<dgn:PriorityType>
																			<xsl:sequence select="(./@node(), ./node())"/>
																		</dgn:PriorityType>
																	</xsl:with-param>
																</xsl:call-template>
															</xsl:variable>
															<xsl:for-each select="$var6_resultof_ST__PriorityToST__Priority">
																<dgn:Priority>
																	<xsl:sequence select="()"/>
																</dgn:Priority>
															</xsl:for-each>
														</xsl:for-each>
													</dgn:PriorityBag>
												</xsl:for-each>
												<xsl:for-each select="dgn:ExhibitionPriorityDetails">
													<com:ExhibitionPriorityBag>
														<xsl:for-each select="dgn:ExhibitionPriority">
															<xsl:variable name="var7_resultof_ST__ExhibitionPriorityToST__ExhibitionPriority" as="node()?">
																<xsl:call-template name="WIPO:ST86ExhibitionPriorityToST96ExhibitionPriority">
																	<xsl:with-param name="ExhibitionPriority" as="node()">
																		<dgn:ExhibitionPriorityType>
																			<xsl:sequence select="(./@node(), ./node())"/>
																		</dgn:ExhibitionPriorityType>
																	</xsl:with-param>
																</xsl:call-template>
															</xsl:variable>
															<xsl:for-each select="$var7_resultof_ST__ExhibitionPriorityToST__ExhibitionPriority">
																<com:ExhibitionPriority>
																	<xsl:sequence select="()"/>
																</com:ExhibitionPriority>
															</xsl:for-each>
														</xsl:for-each>
													</com:ExhibitionPriorityBag>
												</xsl:for-each>
												<xsl:for-each select="dgn:RelatedApplicationDetails">
													<dgn:RelatedApplicationBag>
														<xsl:for-each select="dgn:RelatedApplication">
															<xsl:variable name="var8_resultof_ST__RelatedApplicationToST__RelatedApplication" as="node()?">
																<xsl:call-template name="WIPO:ST86RelatedApplicationToST96RelatedApplication">
																	<xsl:with-param name="RelatedApplication" as="node()">
																		<dgn:RelatedApplicationType>
																			<xsl:sequence select="(./@node(), ./node())"/>
																		</dgn:RelatedApplicationType>
																	</xsl:with-param>
																</xsl:call-template>
															</xsl:variable>
															<xsl:for-each select="$var8_resultof_ST__RelatedApplicationToST__RelatedApplication">
																<dgn:RelatedApplication>
																	<xsl:sequence select="()"/>
																</dgn:RelatedApplication>
															</xsl:for-each>
														</xsl:for-each>
													</dgn:RelatedApplicationBag>
												</xsl:for-each>
												<xsl:for-each select="dgn:StaffDetails">
													<com:StaffBag>
														<xsl:for-each select="dgn:Staff">
															<com:Staff>
																<xsl:sequence select="()"/>
															</com:Staff>
														</xsl:for-each>
													</com:StaffBag>
												</xsl:for-each>
												<xsl:for-each select="dgn:PublicationDetails">
													<dgn:PublicationBag>
														<xsl:for-each select="dgn:Publication">
															<xsl:variable name="var9_resultof_ST__PublicationToST__Publication" as="node()?">
																<xsl:call-template name="WIPO:ST86PublicationToST96Publication">
																	<xsl:with-param name="Publication" as="node()">
																		<dgn:PublicationType>
																			<xsl:sequence select="(./@node(), ./node())"/>
																		</dgn:PublicationType>
																	</xsl:with-param>
																</xsl:call-template>
															</xsl:variable>
															<xsl:for-each select="$var9_resultof_ST__PublicationToST__Publication">
																<dgn:Publication>
																	<xsl:sequence select="()"/>
																</dgn:Publication>
															</xsl:for-each>
														</xsl:for-each>
													</dgn:PublicationBag>
												</xsl:for-each>
												<xsl:for-each select="dgn:CitationReferenceDetails">
													<dgn:PatentIdentificationBag>
														<xsl:for-each select="dgn:CitationReference">
															<xsl:variable name="var10_CitationIdentifier" as="node()?" select="dgn:CitationIdentifier"/>
															<xsl:variable name="var11_CitationDocument" as="node()?" select="dgn:CitationDocument"/>
															<com:CitedPatentDocumentIdentification>
																<xsl:for-each select="$var11_CitationDocument/dgn:DocumentLocation">
																	<xsl:attribute name="com:sourceURI" select="xs:string(xs:anyURI(fn:string(.)))"/>
																</xsl:for-each>
																<xsl:for-each select="$var10_CitationIdentifier/@identifierKindCode">
																	<com:IPOfficeCode>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:IPOfficeCode>
																</xsl:for-each>
																<xsl:for-each select="$var10_CitationIdentifier">
																	<com:DocumentNumber>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:DocumentNumber>
																</xsl:for-each>
																<xsl:for-each select="dgn:CitationKind">
																	<com:PatentDocumentKindCode>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:PatentDocumentKindCode>
																</xsl:for-each>
																<xsl:for-each select="$var11_CitationDocument/dgn:DocumentDate">
																	<com:PatentDocumentDate>
																		<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																	</com:PatentDocumentDate>
																</xsl:for-each>
															</com:CitedPatentDocumentIdentification>
														</xsl:for-each>
													</dgn:PatentIdentificationBag>
												</xsl:for-each>
												<xsl:variable name="var13_ApplicantDetails" as="node()" select="dgn:ApplicantDetails"/>
												<dgn:ApplicantBag>
													<xsl:for-each select="$var13_ApplicantDetails/dgn:ApplicantKey">
														<com:PartyIdentifierBag>
															<xsl:for-each select="dgn:Identifier">
																<com:PartyIdentifier>
																	<xsl:for-each select="@identifierKindCode">
																		<xsl:attribute name="com:officeCode" select="fn:string(.)"/>
																	</xsl:for-each>
																	<xsl:sequence select="fn:string(.)"/>
																</com:PartyIdentifier>
															</xsl:for-each>
														</com:PartyIdentifierBag>
													</xsl:for-each>
													<xsl:for-each select="$var13_ApplicantDetails/dgn:Applicant">
														<xsl:variable name="var12_resultof_ST__ApplicantToST__Applicant" as="node()?">
															<xsl:call-template name="WIPO:ST86ApplicantToST96Applicant">
																<xsl:with-param name="Applicant" as="node()">
																	<dgn:ApplicantType>
																		<xsl:sequence select="(./@node(), ./node())"/>
																	</dgn:ApplicantType>
																</xsl:with-param>
															</xsl:call-template>
														</xsl:variable>
														<xsl:for-each select="$var12_resultof_ST__ApplicantToST__Applicant">
															<dgn:Applicant>
																<xsl:sequence select="()"/>
															</dgn:Applicant>
														</xsl:for-each>
													</xsl:for-each>
												</dgn:ApplicantBag>
												<xsl:for-each select="dgn:RepresentativeDetails">
													<com:RepresentativeBag>
														<xsl:for-each select="dgn:RepresentativeKey">
															<com:PartyIdentifierBag>
																<xsl:sequence select="()"/>
															</com:PartyIdentifierBag>
														</xsl:for-each>
														<xsl:for-each select="dgn:Representative">
															<xsl:variable name="var14_resultof_ST__RepresentativeToST__Representative" as="node()?">
																<xsl:call-template name="WIPO:ST86RepresentativeToST96Representative">
																	<xsl:with-param name="Representative" as="node()">
																		<dgn:RepresentativeType>
																			<xsl:sequence select="(./@node(), ./node())"/>
																		</dgn:RepresentativeType>
																	</xsl:with-param>
																</xsl:call-template>
															</xsl:variable>
															<xsl:for-each select="$var14_resultof_ST__RepresentativeToST__Representative">
																<com:Representative>
																	<xsl:sequence select="()"/>
																</com:Representative>
															</xsl:for-each>
														</xsl:for-each>
													</com:RepresentativeBag>
												</xsl:for-each>
												<xsl:for-each select="dgn:DesignerDetails">
													<dgn:DesignerBag>
														<xsl:for-each select="dgn:DesignerKey">
															<com:PartyIdentifierBag>
																<xsl:for-each select="dgn:Identifier">
																	<com:PartyIdentifier>
																		<xsl:for-each select="@identifierKindCode">
																			<xsl:attribute name="com:officeCode" select="fn:string(.)"/>
																		</xsl:for-each>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:PartyIdentifier>
																</xsl:for-each>
															</com:PartyIdentifierBag>
														</xsl:for-each>
														<xsl:for-each select="dgn:Designer">
															<xsl:variable name="var15_resultof_ST__DesignerToST__Designer" as="node()?">
																<xsl:call-template name="WIPO:ST86DesignerToST96Designer">
																	<xsl:with-param name="Designer" as="node()">
																		<dgn:DesignerType>
																			<xsl:sequence select="(./@node(), ./node())"/>
																		</dgn:DesignerType>
																	</xsl:with-param>
																</xsl:call-template>
															</xsl:variable>
															<xsl:for-each select="$var15_resultof_ST__DesignerToST__Designer">
																<dgn:Designer>
																	<xsl:sequence select="()"/>
																</dgn:Designer>
															</xsl:for-each>
														</xsl:for-each>
													</dgn:DesignerBag>
												</xsl:for-each>
												<xsl:for-each select="dgn:DesignEventDetails">
													<dgn:DesignEventBag>
														<xsl:for-each select="dgn:DesignEvent">
															<xsl:variable name="var16_resultof_ST__DesignEventToST__DesignEvent" as="node()?">
																<xsl:call-template name="WIPO:ST86DesignEventToST96DesignEvent">
																	<xsl:with-param name="DesignEvent" as="node()">
																		<dgn:DesignEventType>
																			<xsl:sequence select="(./@node(), ./node())"/>
																		</dgn:DesignEventType>
																	</xsl:with-param>
																</xsl:call-template>
															</xsl:variable>
															<xsl:for-each select="$var16_resultof_ST__DesignEventToST__DesignEvent">
																<dgn:DesignEvent>
																	<xsl:sequence select="()"/>
																</dgn:DesignEvent>
															</xsl:for-each>
														</xsl:for-each>
													</dgn:DesignEventBag>
												</xsl:for-each>
												<xsl:for-each select="dgn:OppositionDetails">
													<dgn:OppositionBag>
														<xsl:for-each select="dgn:Opposition">
															<xsl:variable name="var17_resultof_ST__OppositionToST__Opposition" as="node()?">
																<xsl:call-template name="WIPO:ST86OppositionToST96Opposition">
																	<xsl:with-param name="Opposition" as="node()">
																		<dgn:OppositionType>
																			<xsl:sequence select="(./@node(), ./node())"/>
																		</dgn:OppositionType>
																	</xsl:with-param>
																</xsl:call-template>
															</xsl:variable>
															<xsl:for-each select="$var17_resultof_ST__OppositionToST__Opposition">
																<dgn:Opposition>
																	<xsl:sequence select="()"/>
																</dgn:Opposition>
															</xsl:for-each>
														</xsl:for-each>
													</dgn:OppositionBag>
												</xsl:for-each>
											</dgn:Design>
										</xsl:for-each>
									</dgn:DesignBag>
								</xsl:for-each>
								<xsl:for-each select="$var18_TransactionData/dgn:ApplicantDetails">
									<dgn:ApplicantBag>
										<xsl:for-each select="dgn:Applicant">
											<dgn:Applicant>
												<xsl:for-each select="dgn:ApplicantContractingParty">
													<dgn:ApplicantContractingParty>
														<xsl:sequence select="fn:string(.)"/>
													</dgn:ApplicantContractingParty>
												</xsl:for-each>
											</dgn:Applicant>
										</xsl:for-each>
									</dgn:ApplicantBag>
								</xsl:for-each>
								<xsl:for-each select="$var18_TransactionData/dgn:RepresentativeDetails">
									<com:RepresentativeBag>
										<xsl:for-each select="dgn:Representative">
											<com:Representative>
												<xsl:sequence select="()"/>
											</com:Representative>
										</xsl:for-each>
									</com:RepresentativeBag>
								</xsl:for-each>
								<xsl:for-each select="$var18_TransactionData/dgn:DesignRecordDetails">
									<dgn:DesignRecordBag>
										<xsl:for-each select="dgn:DesignRecord">
											<dgn:DesignRecord>
												<xsl:for-each select="dgn:DesignBasicRecord">
													<dgn:DesignBasicRecord>
														<xsl:for-each select="dgn:RecordIdentifier">
															<com:RecordIdentifier>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordIdentifier>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordFilingDate">
															<com:RecordFilingDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordFilingDate>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordNotificationDate">
															<com:RecordNotificationDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordNotificationDate>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordEffectiveDate">
															<com:RecordEffectiveDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordEffectiveDate>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordReference">
															<com:RecordReference>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordReference>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordLanguageCode">
															<com:RecordLanguageCode>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordLanguageCode>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordCurrentStatusDate">
															<com:RecordCurrentStatusDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordCurrentStatusDate>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordInterestedOfficeCode">
															<com:RecordInterestedOfficeCode>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordInterestedOfficeCode>
														</xsl:for-each>
													</dgn:DesignBasicRecord>
												</xsl:for-each>
												<xsl:for-each select="dgn:RecordTransfer">
													<dgn:RecordTransfer>
														<xsl:for-each select="dgn:RecordIdentifier">
															<com:RecordIdentifier>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordIdentifier>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordFilingDate">
															<com:RecordFilingDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordFilingDate>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordNotificationDate">
															<com:RecordNotificationDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordNotificationDate>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordEffectiveDate">
															<com:RecordEffectiveDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordEffectiveDate>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordReference">
															<com:RecordReference>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordReference>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordLanguageCode">
															<com:RecordLanguageCode>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordLanguageCode>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordCurrentStatusDate">
															<com:RecordCurrentStatusDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordCurrentStatusDate>
														</xsl:for-each>
														<xsl:for-each select="dgn:CorrespondenceAddress">
															<com:CorrespondenceAddress>
																<xsl:sequence select="()"/>
															</com:CorrespondenceAddress>
														</xsl:for-each>
													</dgn:RecordTransfer>
												</xsl:for-each>
												<xsl:for-each select="dgn:RecordChangeNameAddress">
													<dgn:RecordChangeNameAddress>
														<xsl:for-each select="dgn:RecordIdentifier">
															<com:RecordIdentifier>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordIdentifier>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordFilingDate">
															<com:RecordFilingDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordFilingDate>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordNotificationDate">
															<com:RecordNotificationDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordNotificationDate>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordEffectiveDate">
															<com:RecordEffectiveDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordEffectiveDate>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordReference">
															<com:RecordReference>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordReference>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordLanguageCode">
															<com:RecordLanguageCode>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordLanguageCode>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordCurrentStatusDate">
															<com:RecordCurrentStatusDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordCurrentStatusDate>
														</xsl:for-each>
														<xsl:for-each select="dgn:CorrespondenceAddress">
															<com:CorrespondenceAddress>
																<xsl:sequence select="()"/>
															</com:CorrespondenceAddress>
														</xsl:for-each>
													</dgn:RecordChangeNameAddress>
												</xsl:for-each>
												<xsl:for-each select="dgn:RecordLicence">
													<dgn:RecordLicence>
														<xsl:for-each select="dgn:RecordIdentifier">
															<com:RecordIdentifier>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordIdentifier>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordFilingDate">
															<com:RecordFilingDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordFilingDate>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordNotificationDate">
															<com:RecordNotificationDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordNotificationDate>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordEffectiveDate">
															<com:RecordEffectiveDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordEffectiveDate>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordReference">
															<com:RecordReference>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordReference>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordLanguageCode">
															<com:RecordLanguageCode>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordLanguageCode>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordCurrentStatusDate">
															<com:RecordCurrentStatusDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordCurrentStatusDate>
														</xsl:for-each>
														<xsl:for-each select="dgn:RecordInterestedOfficeCode">
															<com:RecordInterestedOfficeCode>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordInterestedOfficeCode>
														</xsl:for-each>
													</dgn:RecordLicence>
												</xsl:for-each>
											</dgn:DesignRecord>
										</xsl:for-each>
									</dgn:DesignRecordBag>
								</xsl:for-each>
								<xsl:for-each select="$var18_TransactionData/dgn:DesignRecordRelationDetails">
									<dgn:DesignRecordRelationBag>
										<xsl:for-each select="dgn:DesignRecordRelation">
											<dgn:DesignRecordRelation>
												<xsl:sequence select="()"/>
											</dgn:DesignRecordRelation>
										</xsl:for-each>
									</dgn:DesignRecordRelationBag>
								</xsl:for-each>
							</dgn:TransactionData>
						</dgn:TransactionContentBag>
					</dgn:DesignTransactionBody>
				</xsl:for-each>
			</xsl:for-each>
		</dgn:DesignTransaction>
	</xsl:template>
</xsl:stylesheet>
