/*
 * Decompiled with CFR 0.152.
 */
package gov.uspto.xsd.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class XSDFile {
    private String name;
    private String path;
    private String parentFolder;
    private boolean externalTypeDefinition;
    private String externalTypeFile;
    private String declarationText;
    private String componentName;
    private boolean typeDefinition;
    private boolean nameCollision;
    private int numberOfLines;
    private String content = "";
    private String text = "";
    private String fileDocumentationText = "";
    private String componentDocumentationText = "";
    private String namespaceAlias;
    private String targetNamespace;
    private List<String> referredNamespaceEntries = new ArrayList<String>();
    private List<String> otherSchemaTagEntries = new ArrayList<String>();
    private List<String> includes = new ArrayList<String>();
    private List<String> imports = new ArrayList<String>();
    private List<String> importedNamespaces = new ArrayList<String>();
    private HashMap<String, List<XSDFile>> dependencyChain = new HashMap();
    private HashMap<String, HashSet<String>> dependencyReferredNamespaceEntries = new HashMap();
    private HashMap<String, HashSet<String>> dependencyImportedNamespaces = new HashMap();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getParentFolder() {
        return this.parentFolder;
    }

    public void setParentFolder(String parentFolder) {
        this.parentFolder = parentFolder;
    }

    public String getExternalTypeFile() {
        return this.externalTypeFile;
    }

    public void setExternalTypeFile(String externalTypeFile) {
        this.externalTypeFile = externalTypeFile;
    }

    public boolean isExternalTypeDefinition() {
        return this.externalTypeDefinition;
    }

    public void setExternalTypeDefinition(boolean externalTypeDefinition) {
        this.externalTypeDefinition = externalTypeDefinition;
    }

    public String getDeclarationText() {
        return this.declarationText;
    }

    public void setDeclarationText(String declarationText) {
        this.declarationText = declarationText;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public boolean isTypeDefinition() {
        return this.typeDefinition;
    }

    public void setTypeDefinition(boolean typeDefinition) {
        this.typeDefinition = typeDefinition;
    }

    public boolean isNameCollision() {
        return this.nameCollision;
    }

    public void setNameCollision(boolean nameCollision) {
        this.nameCollision = nameCollision;
    }

    public int getNumberOfLines() {
        return this.numberOfLines;
    }

    public void setNumberOfLines(int numberOfLine) {
        this.numberOfLines = numberOfLine;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void addContent(String content) {
        this.content = this.content.concat(content);
        ++this.numberOfLines;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void addText(String text) {
        this.text = this.text.concat(text);
    }

    public String getFileDocumentationText() {
        return this.fileDocumentationText;
    }

    public void setFileDocumentationText(String fileDocumentationText) {
        this.fileDocumentationText = fileDocumentationText;
    }

    public void addFileDocumentationText(String fileDocumentationText) {
        this.fileDocumentationText = this.fileDocumentationText.concat(fileDocumentationText);
    }

    public String getComponentDocumentationText() {
        return this.componentDocumentationText;
    }

    public void setComponentDocumentationText(String componentDocumentationText) {
        this.componentDocumentationText = componentDocumentationText;
    }

    public void addComponentDocumentationText(String componentDocumentationText) {
        this.componentDocumentationText = this.componentDocumentationText.concat(componentDocumentationText);
    }

    public String getNamespaceAlias() {
        return this.namespaceAlias;
    }

    public void setNamespaceAlias(String namespaceAlias) {
        this.namespaceAlias = namespaceAlias;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public List<String> getReferredNamespaceEntries() {
        return this.referredNamespaceEntries;
    }

    public void setReferredNamespaceEntries(List<String> referredNamespaces) {
        this.referredNamespaceEntries = referredNamespaces;
    }

    public void addReferredNamespaceEntry(String referredNamespace) {
        this.referredNamespaceEntries.add(referredNamespace);
    }

    public List<String> getOtherSchemaTagEntries() {
        return this.otherSchemaTagEntries;
    }

    public void setOtherSchemaTagEntries(List<String> otherSchemaTagEntries) {
        this.otherSchemaTagEntries = otherSchemaTagEntries;
    }

    public void addOtherSchemaTagEntry(String otherSchemaTagEntry) {
        this.otherSchemaTagEntries.add(otherSchemaTagEntry);
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public void addInclude(String include) {
        this.includes.add(include);
    }

    public List<String> getImports() {
        return this.imports;
    }

    public void setImports(List<String> imports) {
        this.imports = imports;
    }

    public void addImport(String imp) {
        this.imports.add(imp);
    }

    public List<String> getImportedNamespaces() {
        return this.importedNamespaces;
    }

    public void setImportedNamespaces(List<String> importedNamespaces) {
        this.importedNamespaces = importedNamespaces;
    }

    public void addImportedNamespace(String impNs) {
        this.importedNamespaces.add(impNs);
    }

    public HashMap<String, List<XSDFile>> getDependencyChain() {
        return this.dependencyChain;
    }

    public void setDependencyChain(HashMap<String, List<XSDFile>> dependencyChain) {
        this.dependencyChain = dependencyChain;
    }

    public void addDependencyChain(String namespace, XSDFile dependentXsd) {
        this.addDependencyChain(namespace, dependentXsd, -1);
    }

    public void addDependencyChain(String namespace, XSDFile dependentXsd, int index) {
        List<XSDFile> xsdFls = this.dependencyChain.get(namespace);
        if (xsdFls == null || xsdFls.isEmpty()) {
            xsdFls = new ArrayList<XSDFile>();
        }
        boolean hasIt = false;
        for (XSDFile xsdFl : xsdFls) {
            if (!xsdFl.equals(dependentXsd)) continue;
            hasIt = true;
            break;
        }
        if (!hasIt) {
            if (index != -1) {
                xsdFls.add(index, dependentXsd);
            } else {
                xsdFls.add(dependentXsd);
            }
            this.dependencyChain.put(namespace, xsdFls);
        }
    }

    public HashMap<String, HashSet<String>> getDependencyReferredNamespaceEntries() {
        return this.dependencyReferredNamespaceEntries;
    }

    public void setDependencyReferredNamespaceEntries(HashMap<String, HashSet<String>> dependencyReferredNamespaceEntries) {
        this.dependencyReferredNamespaceEntries = dependencyReferredNamespaceEntries;
    }

    public void addDependencyReferredNamespaceEntries(String namespace, List<String> dependencyReferredNamespaceEntries) {
        HashSet<String> currSet = this.dependencyReferredNamespaceEntries.get(namespace);
        if (currSet == null) {
            currSet = new HashSet();
        }
        currSet.addAll(dependencyReferredNamespaceEntries);
        this.dependencyReferredNamespaceEntries.put(namespace, currSet);
    }

    public void addDependencyReferredNamespaceEntry(String namespace, String dependencyReferredNamespaceEntry) {
        HashSet<String> currSet = this.dependencyReferredNamespaceEntries.get(namespace);
        currSet.add(dependencyReferredNamespaceEntry);
        this.dependencyReferredNamespaceEntries.put(namespace, currSet);
    }

    public HashMap<String, HashSet<String>> getDependencyImportedNamespaces() {
        return this.dependencyImportedNamespaces;
    }

    public void setDependencyImportedNamespaces(HashMap<String, HashSet<String>> dependencyImportedNamespaces) {
        this.dependencyImportedNamespaces = dependencyImportedNamespaces;
    }

    public void addDependencyImportedNamespaces(String namespace, List<String> dependencyImportedNamespaces) {
        HashSet<String> currSet = this.dependencyImportedNamespaces.get(namespace);
        if (currSet == null) {
            currSet = new HashSet();
        }
        currSet.addAll(dependencyImportedNamespaces);
        this.dependencyImportedNamespaces.put(namespace, currSet);
    }

    public void addDependencyImportedNamespace(String namespace, String dependencyImportedNamespace) {
        HashSet<String> currSet = this.dependencyImportedNamespaces.get(namespace);
        currSet.add(dependencyImportedNamespace);
        this.dependencyImportedNamespaces.put(namespace, currSet);
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.name);
        hash = 71 * hash + Objects.hashCode(this.path);
        hash = 71 * hash + Objects.hashCode(this.namespaceAlias);
        hash = 71 * hash + Objects.hashCode(this.targetNamespace);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XSDFile other = (XSDFile)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.path, other.path)) {
            return false;
        }
        if (!Objects.equals(this.namespaceAlias, other.namespaceAlias)) {
            return false;
        }
        return Objects.equals(this.targetNamespace, other.targetNamespace);
    }
}

