/*
 * Decompiled with CFR 0.152.
 */
package gov.uspto.xsd;

import gov.uspto.xsd.model.XSDFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class XSDFlattener {
    private static final String XML_DECL = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String XSD_NS = "http://www.w3.org/2001/XMLSchema";
    private static final String MATHML_BASE = "http://www.w3.org/1998/Math/MathML";
    private static final String OASIS_BASE = "http://www.oasis-open.org/tables/exchange/";
    private static final String SCHEMA_TAG_START = "<xsd:schema";
    private static final String SCHEMA_TAG_END = "</xsd:schema>";
    private static final String SCHEMA_TAG2_START = "<xs:schema";
    private static final String ANOT_TAG_START = "<xsd:annotation>";
    private static final String ANOT_TAG_END = "</xsd:annotation>";
    private static final String ELM_TAG_START = "<xsd:element";
    private static final String ATRB_TAG_START = "<xsd:attribute";
    private static final String COMP_TYP_TAG_START = "<xsd:complexType";
    private static final String SMPL_TYP_TAG_START = "<xsd:simpleType";
    private static final String IMPORT_TAG_START = "<xsd:import ";
    private static final String INCLUDE_TAG_START = "<xsd:include ";
    private static final String XSD_EXT = ".xsd";
    private static final String COM_FLDR = "Common";
    private static final String DOC_FLDR = "Document";
    private static final String EXT_STND_FLDR = "ExternalStandards";
    private static final String XMLNS = "xmlns:";
    private static final String TARGET_NS = "targetNamespace";
    private static final String NS_ATTR = "namespace=";
    private static final String SCHEMA_LOC_ATTR = "schemaLocation=";
    private static final String VERSION_ATTR = "version=";
    private static final String NAME_ATTR = "name=";
    private static final String TYPE_ATTR = "type=";
    private static final String NL = "\n";
    private static final String CR = "\r";
    private static final String SYS_LN_SEP = System.lineSeparator();
    private static final String TAB = "\t";
    private static final String ABKT_END = ">";
    private static final String LSQBKT = "[";
    private static final String RSQBKT = "]";
    private static final String SINGLE_SPACE = " ";
    private static final String DBL_SPACE = "  ";
    private static final String DBL_QT = "\"";
    private static final String EQ = "=";
    private static final String EMPTY = "";
    private static final String FWSL = "/";
    private static final String BWSL = "\\";
    private static final String USCR = "_";
    private static final String COLN = ":";
    private static final String SEMI_COLN = ";";
    private static final String COMMA = ",";
    private static final String DOT = ".";
    private static final String DOTDOT = "..";
    private static final String DASH = "-";
    private static final String PLUS = "+";
    private static final String OWN_FOLDER_OPTION = "-f";
    private static final String VERSION_OPTION = "-version";
    private static final String HELP_OPTION1 = "-help";
    private static final String HELP_OPTION2 = "-?";
    private static final String SUMMARY_FILE_NAME = "Readme.txt";
    private static final String ERROR = "[ERROR] ";
    private static final String INC_ATR_ERROR_MSG = " has inconsistent schema attribute entry: ";
    private static final String VERSION = "1.0.0";
    private static final String USAGE = "java -jar SchemaFlattener.jar [-options] <Input XSDs Folder/File/List-of-Files> <Output XSDs Folder>\n\n        java -jar SchemaFlattener.jar <Input XSDs Folder/File/List-of-Files> <Output XSDs Folder>\n\t       (to flatten Input XSDs from a Folder/File/List-of-Files to Output XSDs Folder)\n\n    or  java -jar SchemaFlattener.jar -f <Input XSDs Folder/File> <Output XSDs Folder>\n\t       (to flatten Input XSDs from a Folder/File/List-of-Files to Output XSDs Folder with a sub-folder for each schema being flattened from input)\n\nOptions:\n\t-f           write output file in its own sub-folder named after flattened input XSD from input\n\t-?           print this help message\n\t-help        print this help message\n\t-version     print SchemaFlattener version\n\n\tNote: \"Input XSDs Folder/File/List-of-Files\" must comply with WIPO Design/Structured format\n\t      \"Output XSDs Folder\"  Folder where flattened XSD file(s) will be written\n";
    private List<String> errors = new ArrayList<String>();

    private void addError(String errorMessage) {
        for (String errMsg : this.errors) {
            if (!errMsg.equals(ERROR.concat(errorMessage).concat(SYS_LN_SEP))) continue;
            return;
        }
        this.errors.add(ERROR.concat(errorMessage).concat(SYS_LN_SEP));
    }

    private List<XSDFile> buildXSDFiles(List<File> files) throws Exception {
        ArrayList<XSDFile> xsdFiles = new ArrayList<XSDFile>();
        if (files.isEmpty()) {
            return xsdFiles;
        }
        for (File file : files) {
            XSDFile xf = null;
            if (file.getParentFile().getName().equals(EXT_STND_FLDR)) {
                xf = this.createXSDFile(file, false);
                this.parseXSDFile(xf, true);
            } else {
                xf = this.createXSDFile(file, true);
                this.parseXSDFile(xf);
            }
            if (xf == null) continue;
            xsdFiles.add(xf);
        }
        return xsdFiles;
    }

    private List<XSDFile> getRootXSDs(List<XSDFile> xsdFiles, List<String> rootComps) throws IOException {
        ArrayList<XSDFile> rootXsds = new ArrayList<XSDFile>();
        if (xsdFiles.isEmpty()) {
            return rootXsds;
        }
        if (rootComps != null && !rootComps.isEmpty()) {
            String[] sortedRootComps = new String[rootComps.size()];
            rootComps.toArray(sortedRootComps);
            Arrays.sort(sortedRootComps, String.CASE_INSENSITIVE_ORDER);
            String[] stringArray = sortedRootComps;
            int n = sortedRootComps.length;
            int n2 = 0;
            while (n2 < n) {
                String rootComp = stringArray[n2];
                if (rootComp.trim().toLowerCase().endsWith(XSD_EXT)) {
                    for (XSDFile xSDFile : xsdFiles) {
                        if (!xSDFile.getPath().equals(rootComp)) continue;
                        rootXsds.add(xSDFile);
                        break;
                    }
                }
                ++n2;
            }
        }
        ArrayList<XSDFile> runDepXsdList = new ArrayList<XSDFile>();
        for (XSDFile rootXsd : rootXsds) {
            ArrayList<XSDFile> xsdFls = new ArrayList<XSDFile>();
            xsdFls.addAll(xsdFiles);
            HashMap<String, List<XSDFile>> depChain = this.getDependencyChain(rootXsd, xsdFls);
            rootXsd.setDependencyChain(depChain);
            for (Map.Entry entry : depChain.entrySet()) {
                for (XSDFile depXsd : (List)entry.getValue()) {
                    if (runDepXsdList.contains(depXsd)) continue;
                    runDepXsdList.add(depXsd);
                }
            }
            xsdFls = null;
        }
        for (XSDFile rootXsd : rootXsds) {
            rootXsd.setNameCollision(this.hasNameCollision(rootXsd.getName(), runDepXsdList));
        }
        return rootXsds;
    }

    private boolean hasNameCollision(String filename, List<XSDFile> files) {
        int fileCnt = 0;
        for (XSDFile file : files) {
            if (!file.getName().equals(filename)) continue;
            ++fileCnt;
        }
        return fileCnt > 1;
    }

    private XSDFile createXSDFile(File file, boolean readEntireFile) throws IOException {
        XSDFile xf = new XSDFile();
        xf.setName(file.getName());
        xf.setPath(file.getPath());
        xf.setParentFolder(file.getParentFile().getName());
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream<String> stream = Files.lines(Paths.get(file.toURI()), StandardCharsets.UTF_8);){
            stream.forEach(s -> {
                if (readEntireFile || !readEntireFile && xf.getNumberOfLines() < 50) {
                    xf.addContent(s.toString().concat(SYS_LN_SEP));
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return xf;
    }

    private HashMap<String, List<XSDFile>> getDependencyChain(XSDFile rootXsdFile, List<XSDFile> xsdFiles) {
        HashMap<String, List<XSDFile>> depXsds = new HashMap<String, List<XSDFile>>();
        List<String> includes = rootXsdFile.getIncludes();
        this.fetchIncludes(rootXsdFile.getName(), rootXsdFile.getTargetNamespace(), this.getIncludedXSDNames(includes), xsdFiles, depXsds);
        if (includes == null || includes.isEmpty()) {
            List<String> imports = rootXsdFile.getImports();
            this.fetchImports(rootXsdFile.getName(), this.getImportedXSDNames(imports), xsdFiles, depXsds);
        }
        for (Map.Entry<String, List<XSDFile>> entry : depXsds.entrySet()) {
            String ns = entry.getKey();
            for (XSDFile xfl : entry.getValue()) {
                List<String> refNss;
                List<String> impNss = xfl.getImportedNamespaces();
                if (impNss != null && !impNss.isEmpty()) {
                    rootXsdFile.addDependencyImportedNamespaces(ns, impNss);
                }
                if ((refNss = xfl.getReferredNamespaceEntries()) == null || refNss.isEmpty()) continue;
                rootXsdFile.addDependencyReferredNamespaceEntries(ns, refNss);
            }
        }
        return depXsds;
    }

    private void fetchIncludes(String xsdFilename, String namespace, List<String> inclFiles, List<XSDFile> xsdFiles, HashMap<String, List<XSDFile>> depXsds) {
        if (inclFiles != null && !inclFiles.isEmpty()) {
            for (String inclFile : inclFiles) {
                XSDFile xsdFile = this.getXSDFile(inclFile, namespace, xsdFiles);
                if (xsdFile != null) {
                    List<XSDFile> xsdList;
                    List<String> imports = xsdFile.getImports();
                    if (imports != null && !imports.isEmpty()) {
                        this.fetchImports(xsdFile.getName(), this.getImportedXSDNames(imports), xsdFiles, depXsds);
                    }
                    if ((xsdList = depXsds.get(namespace)) != null && xsdList.contains(xsdFile)) continue;
                    if (xsdList == null) {
                        xsdList = new ArrayList<XSDFile>();
                    }
                    xsdList.add(xsdFile);
                    ArrayList<String> fls = new ArrayList<String>();
                    for (XSDFile fl : xsdList) {
                        fls.add(fl.getName());
                    }
                    String[] flList = fls.toArray(new String[xsdList.size()]);
                    Arrays.sort(flList, String.CASE_INSENSITIVE_ORDER);
                    ArrayList<XSDFile> sortedFiles = new ArrayList<XSDFile>();
                    String[] stringArray = flList;
                    int n = flList.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fl = stringArray[n2];
                        sortedFiles.add(this.getXSDFile(fl, xsdList));
                        ++n2;
                    }
                    depXsds.put(namespace, sortedFiles);
                    this.fetchIncludes(xsdFile.getName(), namespace, this.getIncludedXSDNames(xsdFile.getIncludes()), xsdFiles, depXsds);
                    continue;
                }
                this.addError("Include entry " + inclFile + " file referenced in " + xsdFilename + " not found.");
            }
        }
    }

    private void fetchImports(String xsdFilename, HashMap<String, List<String>> impFiles, List<XSDFile> xsdFiles, HashMap<String, List<XSDFile>> depXsds) {
        if (impFiles != null && !impFiles.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : impFiles.entrySet()) {
                String namespace = entry.getKey();
                List<String> impFileNames = entry.getValue();
                for (String impFile : impFileNames) {
                    XSDFile xsdFile = this.getXSDFile(impFile, namespace, xsdFiles);
                    if (xsdFile != null) {
                        this.fetchIncludes(xsdFile.getName(), xsdFile.getTargetNamespace(), this.getIncludedXSDNames(xsdFile.getIncludes()), xsdFiles, depXsds);
                        List<XSDFile> xsdList = depXsds.get(namespace);
                        if (xsdList != null && xsdList.contains(xsdFile)) continue;
                        if (xsdList == null) {
                            xsdList = new ArrayList<XSDFile>();
                        }
                        xsdList.add(xsdFile);
                        ArrayList<String> fls = new ArrayList<String>();
                        for (XSDFile fl : xsdList) {
                            fls.add(fl.getName());
                        }
                        String[] flList = fls.toArray(new String[xsdList.size()]);
                        Arrays.sort(flList, String.CASE_INSENSITIVE_ORDER);
                        ArrayList<XSDFile> sortedFiles = new ArrayList<XSDFile>();
                        String[] stringArray = flList;
                        int n = flList.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String fl = stringArray[n2];
                            sortedFiles.add(this.getXSDFile(fl, xsdList));
                            ++n2;
                        }
                        depXsds.put(namespace, sortedFiles);
                        this.fetchImports(xsdFile.getName(), this.getImportedXSDNames(xsdFile.getImports()), xsdFiles, depXsds);
                        continue;
                    }
                    this.addError("Import entry " + impFile + " file referenced in " + xsdFilename + " not found.");
                }
            }
        }
    }

    private void parseXSDFile(XSDFile xf) throws Exception {
        this.parseXSDFile(xf, false);
    }

    private void parseXSDFile(XSDFile xf, boolean scanSchemaTagOnly) throws Exception {
        if (xf != null && xf.getContent().trim().length() > 0) {
            String content = xf.getContent();
            String[] tags = content.split(ABKT_END);
            boolean inTxt = false;
            boolean firstCompDecl = true;
            boolean inFileDoc = false;
            boolean inCompDoc = false;
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if ((tag = tag.concat(ABKT_END)).trim().startsWith(XML_DECL)) {
                    xf.setDeclarationText(tag);
                } else if (tag.trim().startsWith(SCHEMA_TAG_START) || tag.trim().startsWith(SCHEMA_TAG2_START)) {
                    String[] atrbs;
                    String[] stringArray2 = atrbs = tag.replace(TAB, SINGLE_SPACE).replace(DBL_SPACE, SINGLE_SPACE).replace(NL, SINGLE_SPACE).replace(CR, SINGLE_SPACE).split(SINGLE_SPACE);
                    int n3 = atrbs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String atrb = stringArray2[n4];
                        if (atrb.startsWith(XMLNS)) {
                            xf.addReferredNamespaceEntry(atrb);
                        } else if (atrb.startsWith(TARGET_NS)) {
                            xf.setTargetNamespace(atrb.substring(atrb.indexOf(DBL_QT) + 1, atrb.lastIndexOf(DBL_QT)));
                        } else if (!atrb.trim().startsWith(SCHEMA_TAG_START) && !atrb.trim().startsWith(SCHEMA_TAG2_START)) {
                            xf.addOtherSchemaTagEntry(atrb.replace(ABKT_END, EMPTY));
                        }
                        ++n4;
                    }
                    for (String rne : xf.getReferredNamespaceEntries()) {
                        if (xf.getTargetNamespace() == null) {
                            throw new Exception("Missing TargetNamespace attribute for " + xf.getName());
                        }
                        if (!rne.contains(xf.getTargetNamespace()) || !rne.contains(COLN) || !rne.contains(EQ)) continue;
                        xf.setNamespaceAlias(rne.substring(rne.indexOf(COLN) + 1, rne.indexOf(EQ)));
                        break;
                    }
                    inTxt = true;
                    if (scanSchemaTagOnly) {
                        break;
                    }
                } else if (inTxt) {
                    if (!tag.trim().startsWith(SCHEMA_TAG_END) || !tag.trim().endsWith(SCHEMA_TAG_END)) {
                        if (tag.trim().startsWith(IMPORT_TAG_START)) {
                            xf.addImport(tag);
                            String ns = this.getNamespaceFromImportEntry(tag);
                            if (ns != null) {
                                xf.addImportedNamespace(ns);
                            }
                        } else if (tag.trim().startsWith(INCLUDE_TAG_START)) {
                            xf.addInclude(tag);
                        } else {
                            if (tag.trim().startsWith(ANOT_TAG_START)) {
                                inCompDoc = Boolean.TRUE;
                            }
                            if (tag.trim().startsWith(ANOT_TAG_END)) {
                                inCompDoc = Boolean.FALSE;
                                xf.addComponentDocumentationText(tag);
                            }
                            if (inCompDoc) {
                                xf.addComponentDocumentationText(tag);
                            }
                            if (firstCompDecl && (tag.trim().startsWith(ELM_TAG_START) || tag.trim().startsWith(ATRB_TAG_START) || tag.trim().startsWith(COMP_TYP_TAG_START) || tag.trim().startsWith(SMPL_TYP_TAG_START))) {
                                firstCompDecl = Boolean.FALSE;
                                xf.setComponentName(tag.substring(tag.indexOf(DBL_QT, tag.indexOf(NAME_ATTR)) + 1, tag.indexOf(DBL_QT, tag.indexOf(DBL_QT, tag.indexOf(NAME_ATTR)) + 1)));
                                if (tag.trim().startsWith(ELM_TAG_START) || tag.trim().startsWith(ATRB_TAG_START)) {
                                    xf.setTypeDefinition(Boolean.FALSE);
                                } else {
                                    xf.setTypeDefinition(Boolean.TRUE);
                                }
                                if (xf.getParentFolder().equals(DOC_FLDR) && tag.contains(TYPE_ATTR)) {
                                    List<String> impList = xf.getImports();
                                    List<String> inclList = xf.getIncludes();
                                    ArrayList<String> impInclList = new ArrayList<String>();
                                    impInclList.addAll(impList);
                                    impInclList.addAll(inclList);
                                    String typeFile = this.getComponentTypeFile(tag.substring(tag.indexOf(COLN, tag.indexOf(TYPE_ATTR)) + 1, tag.indexOf(DBL_QT, tag.indexOf(COLN, tag.indexOf(TYPE_ATTR)) + 1)), impInclList);
                                    if (typeFile != null) {
                                        xf.setExternalTypeFile(typeFile);
                                        xf.setExternalTypeDefinition(Boolean.TRUE);
                                    }
                                }
                            }
                            xf.addText(tag);
                        }
                    } else {
                        inTxt = false;
                    }
                } else {
                    if (tag.trim().startsWith(ANOT_TAG_START)) {
                        inFileDoc = Boolean.TRUE;
                    }
                    if (tag.trim().startsWith(ANOT_TAG_END)) {
                        inFileDoc = Boolean.FALSE;
                        xf.addFileDocumentationText(tag);
                    }
                    if (inFileDoc) {
                        xf.addFileDocumentationText(tag);
                    }
                }
                ++n2;
            }
        }
    }

    private String getNamespaceFromImportEntry(String importTxt) {
        String retTxt = null;
        int nsAtrbIndx = importTxt.indexOf(NS_ATTR);
        int firstDblQtIndx = importTxt.indexOf(DBL_QT, nsAtrbIndx + NS_ATTR.length());
        int lastDblQtIndx = importTxt.indexOf(DBL_QT.concat(SINGLE_SPACE), firstDblQtIndx);
        retTxt = importTxt.substring(firstDblQtIndx + 1, lastDblQtIndx);
        return retTxt;
    }

    private String getComponentTypeFile(String compName, List<String> impInclList) {
        String compFile = null;
        if (compName != null && compName.trim().length() > 0 && impInclList != null && !impInclList.isEmpty()) {
            for (String impIncl : impInclList) {
                if (!impIncl.contains(compName)) continue;
                compFile = impIncl.substring(impIncl.indexOf(DBL_QT, impIncl.indexOf(SCHEMA_LOC_ATTR)) + 1, impIncl.indexOf(DBL_QT, impIncl.indexOf(DBL_QT, impIncl.indexOf(SCHEMA_LOC_ATTR)) + 1));
                break;
            }
        }
        return compFile;
    }

    private XSDFile getXSDFile(String fileName, List<XSDFile> files) {
        XSDFile retFl = null;
        if (files != null && !files.isEmpty()) {
            for (XSDFile file : files) {
                if (!file.getName().equals(fileName)) continue;
                retFl = file;
                break;
            }
        }
        return retFl;
    }

    private XSDFile getXSDFile(String fileName, String namespace, List<XSDFile> files) {
        XSDFile retFl = null;
        if (files != null && !files.isEmpty()) {
            for (XSDFile file : files) {
                try {
                    if (!file.getName().equals(fileName) || !file.getTargetNamespace().equals(namespace)) continue;
                    retFl = file;
                    break;
                }
                catch (Exception ex) {
                    System.err.println("Error while parsing XSD file: " + file.getName() + ", namespace: " + namespace + NL + ex);
                }
            }
        }
        return retFl;
    }

    private void fetchFiles(String path, List<File> files, boolean includeTypes) throws IOException {
        File dir = new File(path);
        if (dir.isFile()) {
            files.add(dir);
            return;
        }
        if (dir.exists()) {
            File[] fls;
            File[] fileArray = fls = dir.listFiles();
            int n = fls.length;
            int n2 = 0;
            while (n2 < n) {
                File fl = fileArray[n2];
                if (fl.isDirectory()) {
                    this.fetchFiles(fl.getCanonicalPath(), files, includeTypes);
                } else if (fl.canRead()) {
                    if (includeTypes) {
                        files.add(fl);
                    } else if (!fl.getName().endsWith("Type.xsd") && !fl.getName().contains("Type_V")) {
                        files.add(fl);
                    }
                }
                ++n2;
            }
        }
    }

    private void copyExternalStandardsSchemas(String outputFolder, List<File> files) {
        for (File file : files) {
            try {
                String outFile = outputFolder.concat(File.separator).concat(file.getName());
                File f = new File(outFile);
                if (f.exists()) {
                    f.delete();
                }
                if (!f.getParentFile().exists()) {
                    f.getParentFile().mkdir();
                }
                Path src = Paths.get(file.getAbsolutePath(), new String[0]);
                Path dest = Paths.get(outFile, new String[0]);
                Files.copy(src, dest, new CopyOption[0]);
            }
            catch (IOException iOException) {
                System.err.println("Unable to copy " + file.getName());
            }
        }
    }

    public boolean flatten(String inputFolder, String outputFolder, List<String> rootXsdComps, boolean writeInOwnFolder) throws Exception {
        List<XSDFile> xsdRootFiles;
        List<XSDFile> xsdFiles;
        ArrayList<File> extFiles;
        boolean buildMonoliths;
        StringBuilder summaryTxt;
        boolean status;
        block21: {
            ArrayList<String> docXsdList;
            ArrayList<File> files;
            block20: {
                status = false;
                summaryTxt = new StringBuilder();
                files = new ArrayList<File>();
                this.fetchFiles(inputFolder, files, true);
                buildMonoliths = false;
                boolean hasExtFldr = false;
                boolean hasDocFldr = false;
                docXsdList = new ArrayList<String>();
                extFiles = new ArrayList<File>();
                for (File file : files) {
                    if (file.getParentFile().getName().equals(EXT_STND_FLDR)) {
                        hasExtFldr = true;
                        extFiles.add(file);
                    }
                    if (!file.getParentFile().getName().equals(DOC_FLDR)) continue;
                    hasDocFldr = true;
                    if (XSDFlattener.isTypeFile(file)) continue;
                    docXsdList.add(file.getAbsolutePath());
                }
                if (hasExtFldr || hasDocFldr) break block20;
                summaryTxt.append("Invalid input folder ").append(inputFolder);
                XSDFlattener.writeSummaryFile(summaryTxt.toString(), outputFolder);
                return false;
            }
            if (rootXsdComps != null && !rootXsdComps.isEmpty()) {
                docXsdList.clear();
                for (String rootXsdComp : rootXsdComps) {
                    docXsdList.add(rootXsdComp);
                }
            } else {
                buildMonoliths = true;
            }
            xsdFiles = this.buildXSDFiles(files);
            xsdRootFiles = this.getRootXSDs(xsdFiles, docXsdList);
            if (!xsdRootFiles.isEmpty()) break block21;
            summaryTxt.append(inputFolder).append(" has no valid structured XSDs.");
            XSDFlattener.writeSummaryFile(summaryTxt.toString(), outputFolder);
            return false;
        }
        try {
            if (buildMonoliths) {
                this.copyExternalStandardsSchemas(outputFolder, extFiles);
                summaryTxt.append(this.writeNamespaceMonolithicSchemas(xsdFiles, outputFolder)).append(SYS_LN_SEP);
            }
            summaryTxt.append("Total Number of Flattened Schemas: ").append(xsdRootFiles.size()).append(SYS_LN_SEP);
            List<XSDFile> extXSDFiles = null;
            extXSDFiles = this.getExternalXSDFiles(xsdFiles, extFiles);
            int flCntr = 0;
            for (XSDFile flatXsd : xsdRootFiles) {
                ++flCntr;
                String flNm = flatXsd.getName();
                String ownFldrNm = flNm.replace(XSD_EXT, EMPTY);
                if (flatXsd.isNameCollision()) {
                    if (writeInOwnFolder) {
                        ownFldrNm = flatXsd.getNamespaceAlias().toUpperCase().concat(USCR).concat(flatXsd.getName().replace(XSD_EXT, EMPTY));
                    } else {
                        flNm = flatXsd.getNamespaceAlias().toUpperCase().concat(USCR).concat(flatXsd.getName());
                    }
                }
                StringBuilder depTxt = new StringBuilder();
                depTxt.append(flNm).append(" dependency details:").append(SYS_LN_SEP);
                summaryTxt.append(flCntr).append(DOT).append(SINGLE_SPACE);
                if (writeInOwnFolder) {
                    summaryTxt.append((CharSequence)depTxt).append(FWSL.concat(ownFldrNm).concat(SYS_LN_SEP).concat(PLUS).concat(DASH).concat(DASH));
                } else {
                    summaryTxt.append((CharSequence)depTxt);
                }
                String retTxt = this.writeFlattenedSchemas(flatXsd, outputFolder, writeInOwnFolder, extXSDFiles);
                if (writeInOwnFolder) {
                    XSDFlattener.writeSummaryFile(depTxt.append(retTxt).toString(), outputFolder.concat(File.separator).concat(ownFldrNm));
                }
                summaryTxt.append(retTxt).append(SYS_LN_SEP);
            }
        }
        catch (IOException ex) {
            summaryTxt = summaryTxt.append("Exception while processing:").append(SYS_LN_SEP).append(ex.getMessage());
        }
        if (!this.errors.isEmpty()) {
            StringBuilder errorTxt = new StringBuilder();
            for (String error : this.errors) {
                errorTxt.append(error);
            }
            summaryTxt.insert(0, errorTxt.append(SYS_LN_SEP).toString());
            status = false;
        } else {
            status = true;
        }
        XSDFlattener.writeSummaryFile(summaryTxt.toString(), outputFolder);
        return status;
    }

    private List<XSDFile> getExternalXSDFiles(List<XSDFile> xsdFiles, List<File> extFiles) {
        ArrayList<XSDFile> extXsdFiles = new ArrayList<XSDFile>();
        block0: for (File extFile : extFiles) {
            for (XSDFile xsdFile : xsdFiles) {
                if (!extFile.getAbsolutePath().equals(xsdFile.getPath())) continue;
                extXsdFiles.add(xsdFile);
                continue block0;
            }
        }
        return extXsdFiles;
    }

    private static boolean isTypeFile(File file) throws IOException {
        boolean isTypFl = false;
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line = null;
            while ((line = br.readLine()) != null) {
                if (!line.contains(COMP_TYP_TAG_START) && !line.contains(SMPL_TYP_TAG_START)) continue;
                isTypFl = true;
                break;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return isTypFl;
    }

    /*
     * WARNING - void declaration
     */
    private String writeFlattenedSchemas(XSDFile rootXsd, String outputFolder, boolean writeInOwnFolder, List<XSDFile> extXsdFiles) {
        StringBuilder retTxt = new StringBuilder();
        try {
            String rootFilename;
            HashMap<String, List<XSDFile>> depChain = rootXsd.getDependencyChain();
            HashMap flatFlsSet = new HashMap();
            HashSet<String> impFnList = new HashSet<String>();
            String rootNs = rootXsd.getTargetNamespace();
            String ownFolderName = rootFilename = rootXsd.getName();
            if (rootXsd.isNameCollision()) {
                if (writeInOwnFolder) {
                    ownFolderName = rootXsd.getNamespaceAlias().toUpperCase().concat(USCR).concat(rootXsd.getName());
                } else {
                    rootFilename = rootXsd.getNamespaceAlias().toUpperCase().concat(USCR).concat(rootXsd.getName());
                }
            }
            ArrayList<File> extDeps = new ArrayList<File>();
            String newOutputFldr = outputFolder;
            block7: for (Map.Entry<String, List<XSDFile>> entry : depChain.entrySet()) {
                File f;
                String ns = entry.getKey();
                if (ns.contains(MATHML_BASE) || ns.contains(OASIS_BASE)) {
                    for (XSDFile xSDFile : extXsdFiles) {
                        if (!xSDFile.getTargetNamespace().equals(ns)) continue;
                        extDeps.add(new File(xSDFile.getPath()));
                        continue block7;
                    }
                    continue;
                }
                String string = rootFilename;
                List<XSDFile> xsds = entry.getValue();
                if (!ns.equals(rootNs)) {
                    String suffixPart = this.getFlattenedXSDFilenameSuffix(ns, xsds);
                    if (suffixPart.endsWith(XSD_EXT)) {
                        suffixPart = suffixPart.replace(XSD_EXT, EMPTY);
                    }
                    String string2 = string.replace(XSD_EXT, suffixPart.concat(XSD_EXT));
                }
                if (!(f = new File(newOutputFldr = outputFolder.concat(File.separator).concat(writeInOwnFolder ? ownFolderName.replace(XSD_EXT, EMPTY).concat(File.separator) : EMPTY))).exists()) {
                    f.mkdir();
                }
                Throwable throwable = null;
                Object var21_31 = null;
                try {
                    void var17_24;
                    try (BufferedWriter bw = new BufferedWriter(Files.newBufferedWriter(Paths.get(newOutputFldr.concat((String)var17_24), new String[0]), StandardCharsets.UTF_8, new OpenOption[0]));){
                        StringBuilder ent;
                        bw.append(XML_DECL).append(SYS_LN_SEP);
                        bw.append(SCHEMA_TAG_START).append(SINGLE_SPACE);
                        HashSet<String> nsRefs = rootXsd.getDependencyReferredNamespaceEntries().get(ns);
                        String[] nsRefsArr = nsRefs.toArray(new String[nsRefs.size()]);
                        Arrays.sort(nsRefsArr, String.CASE_INSENSITIVE_ORDER);
                        if (nsRefsArr != null && nsRefsArr.length > 0) {
                            String[] stringArray = nsRefsArr;
                            int n = nsRefsArr.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String nsRef = stringArray[n2];
                                bw.append(nsRef).append(SINGLE_SPACE);
                                ++n2;
                            }
                        }
                        bw.append(TARGET_NS).append(EQ).append(DBL_QT).append(ns).append(DBL_QT);
                        List<String> schemaOtherAttrs = rootXsd.getOtherSchemaTagEntries();
                        String incAtrbTxt = this.inconsistentAttributes(schemaOtherAttrs.toArray(new String[schemaOtherAttrs.size()]));
                        if (incAtrbTxt != null && incAtrbTxt.length() > 0) {
                            this.addError(var17_24.concat(INC_ATR_ERROR_MSG).concat(incAtrbTxt));
                        }
                        StringBuilder schemaOtherAttrTxt = new StringBuilder();
                        if (!schemaOtherAttrs.isEmpty()) {
                            for (String schemaOtherAttr : schemaOtherAttrs) {
                                schemaOtherAttrTxt.append(SINGLE_SPACE).append(schemaOtherAttr);
                            }
                        }
                        bw.append(SINGLE_SPACE).append(schemaOtherAttrTxt.toString().trim()).append(ABKT_END).append(SYS_LN_SEP);
                        List<String> impNss = this.getImportableNamespaces(ns, xsds);
                        String impFn = null;
                        if (impNss != null && !impNss.isEmpty()) {
                            impFnList.clear();
                            for (String impNs : impNss) {
                                List<XSDFile> impNsXsds = depChain.get(impNs);
                                String suffixPart = this.getFlattenedXSDFilenameSuffix(impNs, impNsXsds);
                                String importEntry = null;
                                if (suffixPart.endsWith(XSD_EXT)) {
                                    if (suffixPart.startsWith(USCR)) {
                                        suffixPart = suffixPart.substring(1);
                                    }
                                    impFn = suffixPart;
                                } else {
                                    impFn = rootFilename.replace(XSD_EXT, suffixPart.concat(XSD_EXT));
                                }
                                impFnList.add(impFn);
                                importEntry = this.getImportEntry(impNs, impFn);
                                if (importEntry == null || importEntry.trim().length() <= 0) continue;
                                bw.append(TAB).append(importEntry);
                            }
                        }
                        boolean hasExtTypFl = false;
                        String extTypFlNm = rootXsd.getExternalTypeFile();
                        int flCnt = 0;
                        int compCnt = 0;
                        if (ns.equals(rootNs)) {
                            bw.append(rootXsd.getFileDocumentationText());
                            String flTxt = rootXsd.getText();
                            if (flTxt != null && flTxt.startsWith(SYS_LN_SEP)) {
                                flTxt = flTxt.substring(SYS_LN_SEP.length());
                            }
                            if (flTxt != null && (flTxt.startsWith(NL) || flTxt.startsWith(CR))) {
                                flTxt = flTxt.substring(1);
                            }
                            if (flTxt != null && (flTxt.endsWith(NL) || flTxt.endsWith(CR) || flTxt.endsWith(SYS_LN_SEP))) {
                                if (flTxt.endsWith(NL)) {
                                    flTxt = flTxt.substring(0, flTxt.lastIndexOf(NL));
                                } else if (flTxt.endsWith(CR)) {
                                    flTxt = flTxt.substring(0, flTxt.lastIndexOf(CR));
                                } else if (flTxt.endsWith(SYS_LN_SEP)) {
                                    flTxt = flTxt.substring(0, flTxt.lastIndexOf(SYS_LN_SEP));
                                }
                            }
                            bw.append(flTxt).append(SYS_LN_SEP);
                            ++flCnt;
                            ++compCnt;
                            if (extTypFlNm != null) {
                                flTxt = this.getXSDFile(extTypFlNm, xsds).getText();
                                if (flTxt != null && flTxt.startsWith(SYS_LN_SEP)) {
                                    flTxt = flTxt.substring(SYS_LN_SEP.length());
                                } else if (flTxt != null && (flTxt.startsWith(NL) || flTxt.startsWith(CR))) {
                                    flTxt = flTxt.substring(1);
                                } else {
                                    this.addError(String.valueOf(flTxt) + " not found in list of XSDs.");
                                }
                                if (flTxt != null && (flTxt.endsWith(NL) || flTxt.endsWith(CR) || flTxt.endsWith(SYS_LN_SEP))) {
                                    if (flTxt.endsWith(NL)) {
                                        flTxt = flTxt.substring(0, flTxt.lastIndexOf(NL));
                                    } else if (flTxt.endsWith(CR)) {
                                        flTxt = flTxt.substring(0, flTxt.lastIndexOf(CR));
                                    } else if (flTxt.endsWith(SYS_LN_SEP)) {
                                        flTxt = flTxt.substring(0, flTxt.lastIndexOf(SYS_LN_SEP));
                                    }
                                }
                                bw.append(flTxt).append(SYS_LN_SEP);
                                ++flCnt;
                                hasExtTypFl = true;
                            }
                        }
                        for (XSDFile xsdFl : xsds) {
                            String flTxt;
                            if (ns.equals(rootNs) && hasExtTypFl && xsdFl.getName().equals(extTypFlNm)) continue;
                            ++flCnt;
                            if (!xsdFl.isTypeDefinition()) {
                                ++compCnt;
                            }
                            if ((flTxt = xsdFl.getText()) != null && flTxt.startsWith(SYS_LN_SEP)) {
                                flTxt = flTxt.substring(SYS_LN_SEP.length());
                            }
                            if (flTxt != null && (flTxt.startsWith(NL) || flTxt.startsWith(CR))) {
                                flTxt = flTxt.substring(1);
                            }
                            if (flTxt != null && !flTxt.startsWith(TAB)) {
                                flTxt = TAB.concat(flTxt);
                            }
                            if (flTxt != null && (flTxt.endsWith(NL) || flTxt.endsWith(CR) || flTxt.endsWith(SYS_LN_SEP))) {
                                if (flTxt.endsWith(NL)) {
                                    flTxt = flTxt.substring(0, flTxt.lastIndexOf(NL));
                                } else if (flTxt.endsWith(CR)) {
                                    flTxt = flTxt.substring(0, flTxt.lastIndexOf(CR));
                                } else if (flTxt.endsWith(SYS_LN_SEP)) {
                                    flTxt = flTxt.substring(0, flTxt.lastIndexOf(SYS_LN_SEP));
                                }
                            }
                            bw.append(flTxt).append(SYS_LN_SEP);
                        }
                        ArrayList<String> currEnt = (ArrayList<String>)flatFlsSet.get(rootFilename);
                        if (currEnt == null) {
                            currEnt = new ArrayList<String>();
                        }
                        if (var17_24.equals(rootFilename)) {
                            ent = new StringBuilder();
                            ent.append((String)var17_24).append(SINGLE_SPACE).append(LSQBKT).append(flCnt).append(SINGLE_SPACE).append(flCnt == 1 ? " File " : " Files ").append(DASH).append(ABKT_END).append(SINGLE_SPACE).append(compCnt).append(SINGLE_SPACE).append(compCnt == 1 ? " Component" : " Components").append(RSQBKT);
                            ent.append(SYS_LN_SEP);
                            currEnt.add(0, ent.toString());
                            flatFlsSet.put(rootFilename, currEnt);
                        } else {
                            ent = new StringBuilder();
                            ent.append(DBL_SPACE).append(PLUS).append(DASH).append(DASH).append((String)var17_24).append(SINGLE_SPACE).append(LSQBKT).append(flCnt).append(SINGLE_SPACE).append(flCnt == 1 ? " File " : " Files ").append(DASH).append(ABKT_END).append(SINGLE_SPACE).append(compCnt).append(SINGLE_SPACE).append(compCnt == 1 ? " Component" : " Components").append(RSQBKT);
                            if (!impFnList.isEmpty()) {
                                for (String impFl : impFnList) {
                                    if (impFl.equals(var17_24)) continue;
                                    ent.append(SYS_LN_SEP).append(DBL_SPACE).append(DBL_SPACE).append(PLUS).append(DASH).append(DASH).append(impFl);
                                }
                            }
                            ent.append(SYS_LN_SEP);
                            currEnt.add(ent.toString());
                            flatFlsSet.put(rootFilename, currEnt);
                        }
                        bw.append(SCHEMA_TAG_END);
                        bw.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if (!extDeps.isEmpty()) {
                this.copyExternalStandardsSchemas(newOutputFldr, extDeps);
            }
            for (Map.Entry<String, List<XSDFile>> entry : flatFlsSet.entrySet()) {
                List<XSDFile> vals = entry.getValue();
                for (String string : vals) {
                    retTxt.append(string);
                }
            }
        }
        catch (IOException ex) {
            retTxt = retTxt.append("Exception while writing: ").append(rootXsd.getName()).append(ex.getMessage());
        }
        return retTxt.toString();
    }

    private String writeNamespaceMonolithicSchemas(List<XSDFile> xsdFiles, String outputFolder) {
        StringBuilder retTxt = new StringBuilder();
        String fileName = null;
        try {
            String ns;
            HashMap<String, ArrayList<XSDFile>> nsXSDList = new HashMap<String, ArrayList<XSDFile>>();
            HashMap refNsEnts = new HashMap();
            HashMap othrAtrbs = new HashMap();
            HashMap<String, String> nsMonolithFilenames = new HashMap<String, String>();
            HashMap flatFlsSet = new HashMap();
            HashSet<String> impFnList = new HashSet<String>();
            for (XSDFile xSDFile : xsdFiles) {
                List<String> oat;
                HashSet<String> currNsAtrbList;
                ns = xSDFile.getTargetNamespace();
                ArrayList<XSDFile> currNsXsdList = (ArrayList<XSDFile>)nsXSDList.get(ns);
                if (currNsXsdList == null) {
                    currNsXsdList = new ArrayList<XSDFile>();
                }
                currNsXsdList.add(xSDFile);
                nsXSDList.put(ns, currNsXsdList);
                HashSet<String> currNsRefList = (HashSet<String>)refNsEnts.get(ns);
                if (currNsRefList == null) {
                    currNsRefList = new HashSet<String>();
                }
                List<String> rne = xSDFile.getReferredNamespaceEntries();
                List<String> impNss = xSDFile.getImportedNamespaces();
                if (rne != null && !rne.isEmpty()) {
                    for (String rn : rne) {
                        String nsPart = rn.substring(rn.indexOf(EQ) + 1).replace(DBL_QT, EMPTY);
                        if (!(nsPart.contains(MATHML_BASE) || nsPart.contains(OASIS_BASE) || nsPart.contains(XSD_NS) || nsPart.contains(ns))) {
                            if (!impNss.contains(nsPart)) continue;
                            currNsRefList.add(rn);
                            continue;
                        }
                        currNsRefList.add(rn);
                    }
                    refNsEnts.put(ns, currNsRefList);
                }
                if ((currNsAtrbList = (HashSet<String>)othrAtrbs.get(ns)) == null) {
                    currNsAtrbList = new HashSet<String>();
                }
                if ((oat = xSDFile.getOtherSchemaTagEntries()) != null && !oat.isEmpty()) {
                    for (String oa : oat) {
                        currNsAtrbList.add(oa);
                    }
                    othrAtrbs.put(ns, currNsAtrbList);
                }
                if (nsMonolithFilenames.containsKey(ns) || xSDFile.getParentFolder().equals(DOC_FLDR)) continue;
                String fln = xSDFile.getParentFolder();
                if (ns.contains(MATHML_BASE) || ns.contains(OASIS_BASE)) {
                    fln = xSDFile.getName();
                }
                List<String> otAtrs = xSDFile.getOtherSchemaTagEntries();
                for (String otAtr : otAtrs) {
                    if (!otAtr.contains(VERSION_ATTR)) continue;
                    Object verTxt = null;
                    try {
                        verTxt = otAtr.substring(otAtr.indexOf(DBL_QT) + 1, otAtr.lastIndexOf(DBL_QT));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (verTxt == null || ((String)verTxt).trim().length() <= 0) continue;
                    fln = fln.concat(USCR).concat(((String)verTxt).replace(DOT, USCR)).concat(XSD_EXT);
                    break;
                }
                nsMonolithFilenames.put(ns, fln);
            }
            for (Map.Entry entry : nsXSDList.entrySet()) {
                ns = (String)entry.getKey();
                if (ns.contains(MATHML_BASE) || ns.contains(OASIS_BASE)) continue;
                List xsds = (List)entry.getValue();
                fileName = (String)nsMonolithFilenames.get(ns);
                Throwable throwable = null;
                Object var16_23 = null;
                try (BufferedWriter bw = new BufferedWriter(Files.newBufferedWriter(Paths.get(outputFolder.concat(File.separator).concat(fileName), new String[0]), StandardCharsets.UTF_8, new OpenOption[0]));){
                    bw.append(XML_DECL).append(SYS_LN_SEP);
                    bw.append(SCHEMA_TAG_START).append(SINGLE_SPACE);
                    HashSet nsRefs = (HashSet)refNsEnts.get(ns);
                    String[] nsRefsArr = nsRefs.toArray(new String[nsRefs.size()]);
                    Arrays.sort(nsRefsArr, String.CASE_INSENSITIVE_ORDER);
                    if (nsRefsArr != null && nsRefsArr.length > 0) {
                        String[] stringArray = nsRefsArr;
                        int otAtr = nsRefsArr.length;
                        int otAtrs = 0;
                        while (otAtrs < otAtr) {
                            String nsRef = stringArray[otAtrs];
                            bw.append(nsRef).append(SINGLE_SPACE);
                            ++otAtrs;
                        }
                    }
                    bw.append(TARGET_NS).append(EQ).append(DBL_QT).append(ns).append(DBL_QT);
                    HashSet schemaOtherAttrs = (HashSet)othrAtrbs.get(ns);
                    String incAtrbTxt = this.inconsistentAttributes(schemaOtherAttrs.toArray(new String[schemaOtherAttrs.size()]));
                    if (incAtrbTxt != null && incAtrbTxt.length() > 0) {
                        this.addError(fileName.concat(INC_ATR_ERROR_MSG).concat(incAtrbTxt));
                    }
                    StringBuilder schemaOtherAttrTxt = new StringBuilder();
                    if (!schemaOtherAttrs.isEmpty()) {
                        for (String schemaOtherAttr : schemaOtherAttrs) {
                            schemaOtherAttrTxt.append(SINGLE_SPACE).append(schemaOtherAttr);
                        }
                    }
                    bw.append(SINGLE_SPACE).append(schemaOtherAttrTxt.toString().trim()).append(ABKT_END).append(SYS_LN_SEP);
                    List<String> impNss = this.getImportableNamespaces(ns, xsds);
                    String impFn = null;
                    if (impNss != null && !impNss.isEmpty()) {
                        impFnList.clear();
                        for (String impNs : impNss) {
                            impFn = (String)nsMonolithFilenames.get(impNs);
                            if (impFn == null) continue;
                            String importEntry = null;
                            impFnList.add(impFn);
                            importEntry = this.getImportEntry(impNs, impFn);
                            if (importEntry == null || importEntry.trim().length() <= 0) continue;
                            bw.append(TAB).append(importEntry);
                        }
                    }
                    int flCnt = 0;
                    int compCnt = 0;
                    for (XSDFile xsdFl : xsds) {
                        String flTxt;
                        if (xsdFl.getParentFolder().equals(DOC_FLDR)) continue;
                        ++flCnt;
                        if (!xsdFl.isTypeDefinition()) {
                            ++compCnt;
                        }
                        if ((flTxt = xsdFl.getText()) != null && flTxt.startsWith(SYS_LN_SEP)) {
                            flTxt = flTxt.substring(SYS_LN_SEP.length());
                        }
                        if (flTxt != null && (flTxt.startsWith(NL) || flTxt.startsWith(CR))) {
                            flTxt = flTxt.substring(1);
                        }
                        if (flTxt != null && !flTxt.startsWith(TAB)) {
                            flTxt = TAB.concat(flTxt);
                        }
                        if (flTxt != null && (flTxt.endsWith(NL) || flTxt.endsWith(CR) || flTxt.endsWith(SYS_LN_SEP))) {
                            if (flTxt.endsWith(NL)) {
                                flTxt = flTxt.substring(0, flTxt.lastIndexOf(NL));
                            } else if (flTxt.endsWith(CR)) {
                                flTxt = flTxt.substring(0, flTxt.lastIndexOf(CR));
                            } else if (flTxt.endsWith(SYS_LN_SEP)) {
                                flTxt = flTxt.substring(0, flTxt.lastIndexOf(SYS_LN_SEP));
                            }
                        }
                        bw.append(flTxt).append(SYS_LN_SEP);
                    }
                    ArrayList<String> currEnt = (ArrayList<String>)flatFlsSet.get(fileName);
                    if (currEnt == null) {
                        currEnt = new ArrayList<String>();
                    }
                    StringBuilder ent = new StringBuilder();
                    ent.append(fileName).append(SINGLE_SPACE).append(LSQBKT).append(flCnt).append(SINGLE_SPACE).append(flCnt == 1 ? " File " : " Files ").append(DASH).append(ABKT_END).append(SINGLE_SPACE).append(compCnt).append(SINGLE_SPACE).append(compCnt == 1 ? " Component" : " Components").append(RSQBKT);
                    if (!impFnList.isEmpty()) {
                        for (String impFl : impFnList) {
                            if (impFl.equals(fileName)) continue;
                            ent.append(SYS_LN_SEP).append(DBL_SPACE).append(DBL_SPACE).append(PLUS).append(DASH).append(DASH).append(impFl);
                        }
                    }
                    ent.append(SYS_LN_SEP);
                    currEnt.add(0, ent.toString());
                    flatFlsSet.put(fileName, currEnt);
                    bw.append(SYS_LN_SEP).append(SCHEMA_TAG_END);
                    bw.close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            Set set = flatFlsSet.keySet();
            String[] keys = new String[set.size()];
            set.toArray(keys);
            Arrays.sort(keys, String.CASE_INSENSITIVE_ORDER);
            retTxt.append("Total Number of Namespace Monolithic Schemas: ").append(keys.length).append(SYS_LN_SEP);
            int flCntr = 0;
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                retTxt.append(++flCntr).append(DOT).append(SINGLE_SPACE);
                List vals = (List)flatFlsSet.get(key);
                for (String val : vals) {
                    retTxt.append(val).append(SYS_LN_SEP);
                }
                ++n2;
            }
        }
        catch (IOException ex) {
            retTxt = retTxt.append("Exception while writing: ").append(fileName).append(ex.getMessage());
        }
        return retTxt.toString();
    }

    private String inconsistentAttributes(String[] attribs) {
        StringBuilder dupTxt = new StringBuilder();
        if (attribs != null && attribs.length > 0) {
            HashMap<String, String> ent = new HashMap<String, String>();
            String[] stringArray = attribs;
            int n = attribs.length;
            int n2 = 0;
            while (n2 < n) {
                String attrib = stringArray[n2];
                if (attrib != null && attrib.trim().length() > 0) {
                    String key = null;
                    String val = EMPTY;
                    if (attrib.contains(EQ)) {
                        key = attrib.substring(0, attrib.indexOf(EQ));
                        val = attrib.substring(attrib.indexOf(DBL_QT) + 1, attrib.lastIndexOf(DBL_QT));
                    } else {
                        key = attrib;
                        val = EMPTY;
                    }
                    if (ent.containsKey(key)) {
                        dupTxt.append(key.concat(EQ).concat((String)ent.get(key)).concat(COMMA).concat(val).concat(SEMI_COLN).concat(SINGLE_SPACE));
                    }
                    ent.put(key, val);
                }
                ++n2;
            }
        }
        return dupTxt.toString();
    }

    private String getImportEntry(String namespace, String impFile) {
        String retStr = EMPTY;
        if (namespace != null && namespace.trim().length() > 0 && impFile != null && impFile.trim().length() > 0) {
            retStr = retStr.concat(IMPORT_TAG_START).concat(NS_ATTR).concat(DBL_QT).concat(namespace).concat(DBL_QT).concat(SINGLE_SPACE).concat(SCHEMA_LOC_ATTR).concat(DBL_QT).concat(impFile).concat(DBL_QT).concat(FWSL).concat(ABKT_END).concat(SYS_LN_SEP);
        }
        return retStr;
    }

    private String getFlattenedXSDFilenameSuffix(String namespace, List<XSDFile> xsdFiles) {
        String filenameSuffix = EMPTY;
        if (namespace != null && namespace.trim().length() > 0 && xsdFiles != null && !xsdFiles.isEmpty()) {
            for (XSDFile xsd : xsdFiles) {
                if (!xsd.getTargetNamespace().equals(namespace) || xsd.getParentFolder().equals(DOC_FLDR)) continue;
                if (xsd.getParentFolder().equals(EXT_STND_FLDR)) {
                    filenameSuffix = USCR.concat(xsd.getName());
                    break;
                }
                filenameSuffix = USCR.concat(xsd.getParentFolder());
                break;
            }
        }
        return filenameSuffix;
    }

    private List<String> getImportableNamespaces(String currNamespace, List<XSDFile> xsdFiles) {
        ArrayList<String> retList = new ArrayList<String>();
        HashSet<String> importedNamespaces = new HashSet<String>();
        if (xsdFiles != null && !xsdFiles.isEmpty()) {
            for (XSDFile xsdFile : xsdFiles) {
                List<String> refNss;
                if (!xsdFile.getTargetNamespace().equals(currNamespace) || (refNss = xsdFile.getImportedNamespaces()) == null || refNss.isEmpty()) continue;
                importedNamespaces.addAll(refNss);
            }
            for (String importedNamespace : importedNamespaces) {
                if (importedNamespace.contains(currNamespace) || importedNamespace.contains(XSD_NS)) continue;
                retList.add(importedNamespace);
            }
        }
        return retList;
    }

    private HashMap<String, List<String>> getImportedXSDNames(List<String> impList) {
        HashMap<String, List<String>> retList = new HashMap<String, List<String>>();
        if (impList != null && !impList.isEmpty()) {
            for (String imp : impList) {
                String compNs = null;
                compNs = imp.substring(imp.indexOf(DBL_QT, imp.indexOf(NS_ATTR)) + 1, imp.indexOf(DBL_QT, imp.indexOf(DBL_QT, imp.indexOf(NS_ATTR)) + 1));
                String compNm = null;
                String impPartTxt = imp.substring(imp.indexOf(compNs) + compNs.length() + 1);
                compNm = impPartTxt.substring(impPartTxt.indexOf(DBL_QT, impPartTxt.indexOf(SCHEMA_LOC_ATTR)) + 1, impPartTxt.indexOf(DBL_QT, impPartTxt.indexOf(DBL_QT, impPartTxt.indexOf(SCHEMA_LOC_ATTR)) + 1));
                if (compNs == null || compNs.trim().length() <= 0 || compNm == null || compNm.trim().length() <= 0) continue;
                if (compNm.contains(FWSL)) {
                    compNm = compNm.substring(compNm.lastIndexOf(FWSL) + 1);
                }
                if (compNm.contains(BWSL)) {
                    compNm = compNm.substring(compNm.lastIndexOf(BWSL) + 1);
                }
                compNm.replace(DOTDOT, EMPTY);
                List<String> currList = retList.get(compNs);
                if (currList == null) {
                    currList = new ArrayList<String>();
                }
                currList.add(compNm);
                retList.put(compNs, currList);
            }
        }
        return retList;
    }

    private List<String> getIncludedXSDNames(List<String> inclList) {
        ArrayList<String> retList = new ArrayList<String>();
        if (inclList != null && !inclList.isEmpty()) {
            for (String incl : inclList) {
                String compNm = null;
                compNm = incl.substring(incl.indexOf(DBL_QT, incl.indexOf(SCHEMA_LOC_ATTR)) + 1, incl.indexOf(DBL_QT, incl.indexOf(DBL_QT, incl.indexOf(SCHEMA_LOC_ATTR)) + 1));
                if (compNm == null || compNm.trim().length() <= 0) continue;
                if (compNm.contains(FWSL)) {
                    compNm = compNm.substring(compNm.lastIndexOf(FWSL) + 1);
                }
                if (compNm.contains(BWSL)) {
                    compNm = compNm.substring(compNm.lastIndexOf(BWSL) + 1);
                }
                retList.add(compNm.replace(DOTDOT, EMPTY));
            }
        }
        return retList;
    }

    private static String getRootFolder(String file) {
        String rtFldr = null;
        if (file != null && file.trim().length() > 0) {
            File f = new File(file);
            if (f.isDirectory()) {
                File[] dirList;
                File[] fileArray = dirList = f.listFiles();
                int n = dirList.length;
                int n2 = 0;
                while (n2 < n) {
                    File dir = fileArray[n2];
                    if (dir.isDirectory() && dir.getName().equals(EXT_STND_FLDR)) {
                        rtFldr = file;
                        break;
                    }
                    ++n2;
                }
            }
            if (rtFldr == null) {
                rtFldr = XSDFlattener.getRootFolder(f.getParentFile().getAbsolutePath());
            }
        }
        return rtFldr;
    }

    private static boolean isValidWIPOCompliantRootFolder(String folder) {
        boolean validRoot = false;
        boolean hasComFldr = false;
        boolean hasExtFldr = false;
        if (folder != null && folder.trim().length() > 0) {
            File f = new File(folder);
            if (f.isDirectory()) {
                File[] dirList;
                File[] fileArray = dirList = f.listFiles();
                int n = dirList.length;
                int n2 = 0;
                while (n2 < n) {
                    File dir = fileArray[n2];
                    if (dir.isDirectory() && dir.getName().equals(COM_FLDR)) {
                        hasComFldr = true;
                        if (hasExtFldr) break;
                    }
                    if (dir.isDirectory() && dir.getName().equals(EXT_STND_FLDR)) {
                        hasExtFldr = true;
                        if (hasComFldr) break;
                    }
                    ++n2;
                }
            }
            validRoot = hasComFldr && hasExtFldr;
        }
        return validRoot;
    }

    /*
     * WARNING - void declaration
     */
    private static Object[] confirmValidInput(String arg) throws Exception {
        ArrayList<String> files = null;
        Object[] rtFldr = new Object[2];
        boolean canReturn = false;
        if (arg != null && arg.trim().length() > 0) {
            void var9_16;
            String[] argEnt = arg.split(COMMA);
            ArrayList<String> inputEntries = new ArrayList<String>();
            int fileCnt = 0;
            int fldrCnt = 0;
            String[] stringArray = argEnt;
            int n = argEnt.length;
            boolean n2 = false;
            while (var9_16 < n) {
                String string = stringArray[var9_16];
                File f = new File(string);
                if (f.isFile()) {
                    ++fileCnt;
                } else if (f.isDirectory()) {
                    ++fldrCnt;
                }
                inputEntries.add(string.trim());
                ++var9_16;
            }
            if (fileCnt > 0 && fldrCnt > 0) {
                throw new Exception("Invalid input: List must be of the same type files or folders, not the both");
            }
            files = new ArrayList<String>();
            for (String string : inputEntries) {
                File f = new File(string);
                if (f.exists()) {
                    if (f.isDirectory()) {
                        int n3;
                        if (XSDFlattener.isValidWIPOCompliantRootFolder(string)) {
                            files.add(f.getAbsolutePath());
                            continue;
                        }
                        if (f.getName().equals(DOC_FLDR)) {
                            File[] ls = f.listFiles();
                            if (ls.length > 0) {
                                File[] fileArray = ls;
                                n3 = ls.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    File l = fileArray[n4];
                                    if (!XSDFlattener.isTypeFile(l)) {
                                        files.add(l.getAbsolutePath());
                                    }
                                    ++n4;
                                }
                                continue;
                            }
                            throw new Exception("Invalid input - Not a valid WIPO compliant folder structure");
                        }
                        File fldr = new File(f.getAbsolutePath().concat(File.separator).concat(DOC_FLDR));
                        if (!fldr.exists()) continue;
                        File[] ls = fldr.listFiles();
                        if (ls.length > 0) {
                            File[] fileArray = ls;
                            int n5 = ls.length;
                            n3 = 0;
                            while (n3 < n5) {
                                File l = fileArray[n3];
                                if (!XSDFlattener.isTypeFile(l)) {
                                    files.add(l.getAbsolutePath());
                                }
                                ++n3;
                            }
                            continue;
                        }
                        throw new Exception("Invalid input - Not a valid WIPO compliant folder structure");
                    }
                    files.add(string);
                    continue;
                }
                throw new Exception("Invalid input - empty file");
            }
        } else {
            throw new Exception("Invalid input file: null");
        }
        if (!canReturn && files != null && !files.isEmpty()) {
            HashSet<String> fileRoots = new HashSet<String>();
            HashSet<String> invalidFileRoots = new HashSet<String>();
            boolean resetFiles = false;
            for (String file : files) {
                String string = XSDFlattener.getRootFolder(file);
                if (string != null) {
                    fileRoots.add(string);
                    if (!string.equals(file)) continue;
                    resetFiles = true;
                    continue;
                }
                invalidFileRoots.add(file);
            }
            if (resetFiles) {
                files = null;
            }
            if (!invalidFileRoots.isEmpty()) {
                String invldFls = EMPTY;
                for (String string : invalidFileRoots) {
                    invldFls = invldFls.concat(string).concat(SYS_LN_SEP);
                }
                throw new Exception("Invalid input ".concat(invalidFileRoots.size() > 1 ? "files:" : "file:").concat(SYS_LN_SEP).concat(invldFls));
            }
            if (!fileRoots.isEmpty()) {
                void var8_30;
                String rts = EMPTY;
                String string = EMPTY;
                for (String string2 : fileRoots) {
                    rts = rts.concat(string2).concat(SYS_LN_SEP);
                    String string3 = string2;
                }
                if (fileRoots.size() > 1) {
                    throw new Exception("Invalid input - Must be from single root folder: ".concat(arg).concat(SYS_LN_SEP).concat(rts));
                }
                rtFldr[0] = var8_30;
                rtFldr[1] = files;
            }
            if (rtFldr[0] == null) {
                throw new Exception("Invalid input file: " + arg);
            }
        }
        return rtFldr;
    }

    private static void writeSummaryFile(String summaryText, String outputFolder) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedWriter bw = new BufferedWriter(Files.newBufferedWriter(Paths.get(outputFolder.concat(File.separator).concat(SUMMARY_FILE_NAME), new String[0]), StandardCharsets.UTF_8, new OpenOption[0]));){
                bw.append(summaryText);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            System.err.println("Error while writing summary file " + ex);
        }
    }

    public static void main(String[] args) throws Exception {
        boolean writeInItsOwnFolder;
        List rootComps;
        String output;
        String input;
        block24: {
            block28: {
                block25: {
                    block26: {
                        input = null;
                        output = null;
                        rootComps = null;
                        writeInItsOwnFolder = false;
                        if (args != null && (args.length == 2 || args.length == 3)) break block24;
                        if (args == null) break block25;
                        if (args.length != 1) break block26;
                        switch (args[0].trim()) {
                            case "-?": 
                            case "-help": {
                                System.err.println("Usage:  ".concat(USAGE));
                                break;
                            }
                            case "-version": {
                                System.err.println("SchemaFlattener version \"".concat(VERSION).concat(DBL_QT));
                                break;
                            }
                            default: {
                                System.err.println("Invalid Usage!!".concat(SYS_LN_SEP).concat(USAGE));
                                break;
                            }
                        }
                        break block28;
                    }
                    System.err.println("Invalid Usage!!".concat(SYS_LN_SEP).concat(USAGE));
                    break block28;
                }
                System.err.println("Usage:  ".concat(USAGE));
            }
            return;
        }
        if (args.length == 3) {
            if (args[0].trim().equals(OWN_FOLDER_OPTION)) {
                writeInItsOwnFolder = true;
                String[] argv = new String[]{args[1], args[2]};
                args = argv;
            } else {
                System.err.println("Invalid Usage!!".concat(SYS_LN_SEP).concat(USAGE));
                return;
            }
        }
        try {
            Object[] argZero = XSDFlattener.confirmValidInput(args[0]);
            input = (String)argZero[0];
            rootComps = (List)argZero[1];
        }
        catch (Exception ex) {
            System.err.println("Invalid Usage!!".concat(SYS_LN_SEP).concat(ex.getMessage()));
            System.err.println(USAGE);
            return;
        }
        File f = new File(args[1].trim());
        if (!f.exists()) {
            if (!f.mkdir() || !f.getParentFile().canWrite()) {
                System.err.println("Invalid Usage!!".concat(SYS_LN_SEP).concat("Cannot write output folder: ").concat(args[1]));
                System.err.println(USAGE);
                return;
            }
        } else if (!f.isDirectory()) {
            System.err.println("Invalid Usage!!".concat(SYS_LN_SEP).concat("Output must be a folder: ").concat(args[1]));
            System.err.println(USAGE);
            return;
        }
        output = args[1].trim();
        XSDFlattener xf = new XSDFlattener();
        try {
            boolean singleFileInput = false;
            if (rootComps != null && rootComps.size() == 1) {
                File tf = new File((String)rootComps.get(0));
                singleFileInput = tf.isFile();
            }
            System.out.print("Flattening " + (singleFileInput ? "schema" : "schemas") + " [" + new Date() + "]...");
            boolean flattened = xf.flatten(input, output, rootComps, writeInItsOwnFolder);
            System.out.print(LSQBKT + new Date() + "] ".concat(flattened ? "Completed." : "Completed with " + (xf.errors.size() == 1 ? "Error" : "Errors") + ".\nPlease check Readme.txt file in ".concat(output)));
        }
        catch (Exception ex) {
            Logger.getLogger(XSDFlattener.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

