<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    exclude-result-prefixes="xs"
    version="3.0">
    
    <xsl:param name="st3Files"/>
    <!-- updates the file WIPOST3Codes.xml used in the Schematron with the latest enumeration values -->
    <xsl:output method="xml" indent="yes"/>
    
    <xsl:template match="/">
<!--        <xsl:message><xsl:value-of select="$st3Files"/></xsl:message>-->
        <Codes>
            <xsl:comment>Used in the enforcement of SD-63</xsl:comment>
            <xsl:comment>Last Updated <xsl:value-of select="current-date()"/></xsl:comment>
            <xsl:for-each-group select="
                    for $x in tokenize($st3Files, ';')
                    return
                        doc($x)//*:enumeration" group-by="@value">
                <xsl:sort select="current-grouping-key()"/>
                <Code>
                    <xsl:value-of select="current-grouping-key()"/>
                </Code>
            </xsl:for-each-group>
        </Codes>
    </xsl:template>
    
</xsl:stylesheet>