<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:fnx="http://www.example.com/fnx" 
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    exclude-result-prefixes="xsd fnx"
    version="2.0">
    
    <xsl:import href="integritycheck.xsl"/><!-- need in order to reuse splitCamelCase function -->
    <xsl:param name="EnumerationsAndNames"/>
    <xsl:output method="text" encoding="UTF-8"/>
    <xsl:strip-space elements="*"/>
    
    <xsl:template match="/">
        <xsl:for-each select="tokenize($EnumerationsAndNames,',')">
            <xsl:apply-templates select="doc(resolve-uri(concat('file:///',current())))/xsd:schema"/>    
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="xsd:schema">
        <xsl:apply-templates select="xsd:element[@name] | xsd:attribute[@name] | xsd:complexType[@name] | xsd:simpleType[@name]" mode="retrieve-names"/>
        <xsl:apply-templates select="xsd:simpleType[not(matches(base-uri(), '(/ISO|/.*ST3CodeType.xsd)'))]/*:restriction/*:enumeration[matches(@value, '[a-zA-Z][a-z]+')]" mode="retrieve-enumeration"/>
    </xsl:template>
    
    <xsl:template match="xsd:enumeration[matches(@value, '[a-zA-Z][a-z]+')]" mode="retrieve-enumeration" priority="10">
        <xsl:value-of select="fnx:splitEnumeration(@value)"/>
        <xsl:text>
</xsl:text>
    </xsl:template>
    
    <xsl:template match="xsd:enumeration" mode="retrieve-enumeration"/>
    
    <xsl:template match="xsd:element | xsd:complexType | xsd:simpleType | xsd:attribute" mode="retrieve-names">
        <xsl:value-of select="fnx:splitCamelCase(@name)"/>
        <xsl:text>
</xsl:text>
    </xsl:template>
    
    
    
</xsl:stylesheet>