<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    exclude-result-prefixes="xs"
    version="3.0">
    
    <!-- produce components list with status: 'new', 'modified', 'unchanged', or 'unknown' 
    
         Should work even if folder depth levels are uneven between two versions of schemas
         
-->
    <xsl:param name="previousSchemaInputDir"/>
    
    <xsl:param name="newSchemaComponents"/>
    <xsl:param name="preexistingSchemaComponents"/>
    <xsl:param name="deletedComponents"/>
    <xsl:param name="previousSchemaVersion"/>
    
    <xsl:variable name="previousSchemaCollection" select="collection(concat('file:///',$previousSchemaInputDir,'?select=*.xsd&amp;recurse=yes'))[not(contains(base-uri(.),'/ExternalStandards/'))]"/>
    
    <xsl:key name="schema-by-name-and-namespace" match="*:schema/*[@name]" use="concat(@name,tokenize(parent::*:schema/@targetNamespace,'[/:]')[last()])"/><!-- e.g. 'TrademarkDocumentType,Trademark' -->
    
    <xsl:template match="/" mode="component-status">
        <components>
            <xsl:merge>
                <xsl:merge-source name="newSchemaFiles" for-each-source="tokenize($newSchemaComponents, ';')" select="snapshot(/*:schema/*[@name])" sort-before-merge="true">
                    <xsl:merge-key select="@name"/>
                    <xsl:merge-key select="parent::node()/@targetNamespace/tokenize(., '[/:]')[last()]"></xsl:merge-key>
                </xsl:merge-source>
                <xsl:merge-source name="deletedSchemaFiles" for-each-source="tokenize($deletedComponents,';')" select="snapshot(/*:schema/*[@name])" sort-before-merge="true">
                    <xsl:merge-key select="@name"/>
                    <xsl:merge-key select="parent::node()/@targetNamespace/tokenize(., '[/:]')[last()]"></xsl:merge-key>
                </xsl:merge-source>
                <xsl:merge-source name="preexistingSchemaFiles" for-each-source="tokenize($preexistingSchemaComponents, ';')" select="snapshot(/*:schema/*[@name])" sort-before-merge="true">
                    <xsl:merge-key select="@name"/>
                    <xsl:merge-key select="parent::node()/@targetNamespace/tokenize(., '[/:]')[last()]"></xsl:merge-key>
                </xsl:merge-source>
                <xsl:merge-source name="previousSchemaFiles" select="snapshot($previousSchemaCollection/*:schema/*[@name])" sort-before-merge="true">
                    <xsl:merge-key select="@name"/>
                    <xsl:merge-key select="parent::node()/@targetNamespace/tokenize(., '[/:]')[last()]"></xsl:merge-key>
                </xsl:merge-source>
                <xsl:merge-action>
<!--                    <xsl:message>checking: <xsl:value-of select="current-merge-key()[1]"/> in <xsl:value-of select="current-merge-key()[2]"/></xsl:message>-->
                    
                    <xsl:choose>
                        <xsl:when test="exists(current-merge-group('newSchemaFiles')) and empty(current-merge-group('previousSchemaFiles'))">
                            <component uri="{base-uri(.)}" status="new" namespace="{current-merge-key()[2]}" name="{current-merge-key()[1]}" type="{local-name()}"/>   
                        </xsl:when>
                        <xsl:when test="exists(current-merge-group('deletedSchemaFiles')) and empty(current-merge-group('preexistingSchemaFiles'))">
                            <component uri="{base-uri(.)}" status="deleted" namespace="{current-merge-key()[2]}" name="{current-merge-key()[1]}" type="{local-name()}"/>
                        </xsl:when>
                        <xsl:when test="exists(current-merge-group('preexistingSchemaFiles'))"><!--  and empty(current-merge-group('newSchemaFiles') or current-merge-group('deletedSchemaFiles')) -->
                            <xsl:variable name="componentName" select="current-merge-key()[1]"/>
                            <xsl:variable name="namespace" select="current-merge-key()[2]"/>
                            <!--<xsl:variable name="previousComponent" select="($previousSchemaCollection/key('schema-by-name-and-namespace', concat($componentName, $namespace)))[1]"/>-->
<!--                            <xsl:message>check if component in preexisting schema was modified</xsl:message>-->
                            <xsl:choose>
                                <!-- when flattened, check for new/deleted -->
                                <xsl:when test="exists(current-merge-group('previousSchemaFiles')) and deep-equal(current-merge-group('previousSchemaFiles')[1], current-merge-group('preexistingSchemaFiles')[1]) = false()">
                                    <!-- compare only at the component leve; this works in conjunction with saxon setting to strip whitespace only nodes (see ant build) -->
                                    <xsl:variable name="only-modified-annotation" select="deep-equal(current-merge-group('previousSchemaFiles')[1]/descendant::*[not(ancestor-or-self::*:annotation[1])], current-merge-group('preexistingSchemaFiles')[1]/descendant::*[not(ancestor-or-self::*:annotation[1])]) and deep-equal(current-merge-group('previousSchemaFiles')[1]/descendant-or-self::*[not(ancestor-or-self::*:annotation[1])]/@*, current-merge-group('preexistingSchemaFiles')[1]/descendant-or-self::*[not(ancestor-or-self::*:annotation[1])]/@*)"/>
                                    <component uri="{base-uri(.)}" status="modified" namespace="{current-merge-key()[2]}" name="{current-merge-key()[1]}" only-modified-annotation="{$only-modified-annotation}" type="{local-name()}"/>
                                </xsl:when>
                                <xsl:when test="exists(current-merge-group('previousSchemaFiles')) and deep-equal(current-merge-group('previousSchemaFiles')[1], current-merge-group('preexistingSchemaFiles')[1]) = true()">
                                    <component uri="{base-uri(.)}" status="unchanged" namespace="{current-merge-key()[2]}" name="{current-merge-key()[1]}" type="{local-name()}"/>
                                </xsl:when>
                                <xsl:when test="empty(current-merge-group('previousSchemaFiles'))">
                           <xsl:message>new in flattened schema: <xsl:value-of select="current-merge-key()[1]"/></xsl:message>
                                    <component uri="{base-uri(.)}" status="new" namespace="{current-merge-key()[2]}" name="{current-merge-key()[1]}" type="{local-name()}"/>        
                                </xsl:when>
                            </xsl:choose> 
                        </xsl:when>
                        <xsl:when test="exists(current-merge-group('previousSchemaFiles')) ">
                                    <xsl:message>deleted in flattened schema: <xsl:value-of select="current-merge-key()[1]"/></xsl:message>
                                    <component uri="{base-uri(.)}" status="deleted" namespace="{current-merge-key()[2]}" name="{current-merge-key()[1]}" type="{local-name()}"/>
                                
                        </xsl:when>
                    </xsl:choose>
                </xsl:merge-action>
            </xsl:merge>
            
            
        </components>
    </xsl:template>
    
</xsl:stylesheet>