<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet 
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                exclude-result-prefixes="#all"
                version="3.0">
    
    <xsl:output method="text" encoding="UTF-8"/>
    <xsl:param name="inputDir"/>
    
    <xsl:template match="/">
        <xsl:message><xsl:value-of select="$inputDir"/></xsl:message>
        <xsl:variable name="found-bad-references">
            <xsl:where-populated>
                <bad-references>
                    <xsl:for-each select="collection(concat('file:///',$inputDir, '?select=', '*','.xsd&amp;recurse=yes'))[*:schema/*[local-name() = 'include' or local-name() = 'import']]">
                        <xsl:message>Checking import/includes for <xsl:value-of select="document-uri(current())"/></xsl:message>
                        <xsl:apply-templates select="*:schema/*[local-name() = 'include' or local-name() = 'import']">
                            <xsl:with-param name="schema-uri" select="document-uri(current())"/>
                        </xsl:apply-templates>
                    </xsl:for-each>
                </bad-references>
            </xsl:where-populated>
        </xsl:variable>
        <xsl:for-each select="$found-bad-references/bad-references/*">
            <xsl:value-of select="concat(@referenced-schema, ' not found (referenced by ', @source-schema, ')')"/>
            <xsl:text>
</xsl:text>
            
        </xsl:for-each>
        
        <xsl:on-empty>
            <xsl:message>All references in @schemaLocation have been successfully resolved.</xsl:message>
        </xsl:on-empty>
    </xsl:template>

    <xsl:template match="*:include|*:import">
            <xsl:param name="schema-uri"/>
            
            <xsl:if test="doc-available(resolve-uri(@schemaLocation,$schema-uri)) = false()">
                <referenced-schema-not-found source-schema="{$schema-uri}" referenced-schema="{@schemaLocation}">
                </referenced-schema-not-found>
                </xsl:if>
    </xsl:template>
</xsl:stylesheet>
