<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:sch="http://purl.oclc.org/dsdl/schematron"
    version="2.0">

  <xsl:output method="xml" indent="yes"/>

  <xsl:template match="@* | node()" mode="build-pattern-file">
    <xsl:copy>
      <xsl:apply-templates select="@* | node()" mode="build-pattern-file"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="node()[self::comment()]" mode="build-pattern-file"/>
  <xsl:template match="sch:schema/text()" mode="build-pattern-file"/>

  <!-- So that unit testing (status.xsl) can be affected by ApprovedExceptions.xml settings -->
  <xsl:template match="sch:let[@name='kWhereToApproveExceptions']" mode="build-pattern-file">
    <let xmlns="http://purl.oclc.org/dsdl/schematron" name="kWhereToApproveExceptions" value="'InSchematronRules'"/>
  </xsl:template>
  
  <xsl:template match="sch:let[@name='st96Version']" mode="build-pattern-file">
    <let xmlns="http://purl.oclc.org/dsdl/schematron" name="st96Version" value="'{doc('st96Version.xml')//*:attribute[@name eq 'st96Version'][1]/@*:fixed}'"/>
  </xsl:template>
  
  <xsl:template match="sch:let[@name='approvedExceptions']" mode="build-pattern-file">
    <let xmlns="http://purl.oclc.org/dsdl/schematron" name="approvedExceptions" value="doc('../ApprovedExceptions.xml')"/>
  </xsl:template>
  

  <xsl:template match="sch:pattern" mode="build-pattern-file">
    <xsl:param name="guidelineId" tunnel="yes"/>
    <xsl:if test="sch:title = $guidelineId">
      <xsl:copy>
        <xsl:apply-templates mode="build-pattern-file"/>
      </xsl:copy>
    </xsl:if>
  </xsl:template>

  <xsl:template match="/">
    <xsl:for-each select="sch:schema/sch:pattern">
      <xsl:variable name="title" select="sch:title"/>
      <xsl:result-document href="split_guidelines/{$title}.sch">
        <xsl:apply-templates select="/" mode="build-pattern-file">
          <xsl:with-param name="guidelineId" select="$title" tunnel="yes"/>
        </xsl:apply-templates>
      </xsl:result-document>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>
